/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.Date;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationFactory;
import org.icepdf.core.pobjects.annotations.FreeTextAnnotation;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.ViewModel;
import org.icepdf.ri.common.tools.LineAnnotationHandler;
import org.icepdf.ri.common.tools.SelectionBoxHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;
import org.icepdf.ri.common.views.annotations.FreeTextAnnotationComponent;

public class FreeTextAnnotationHandler
extends SelectionBoxHandler
implements ToolHandler {
    private static final Logger logger = Logger.getLogger(LineAnnotationHandler.class.toString());
    public static final int DEFAULT_WIDTH = 30;
    public static final int DEFAULT_HEIGHT = 20;
    private FreeTextAnnotation annotation;

    public FreeTextAnnotationHandler(DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(documentViewController, abstractPageViewComponent);
    }

    @Override
    public void setSelectionRectangle(Point point, Rectangle rectangle) {
    }

    @Override
    public void paintTool(Graphics graphics) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.pageViewComponent != null) {
            this.pageViewComponent.requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void createFreeTextAnnotation(int n, int n2) {
        this.createFreeTextAnnotation(n, n2, true);
    }

    public void createFreeTextAnnotation(int n, int n2, boolean bl) {
        this.updateSelectionSize(n, n2, this.pageViewComponent);
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        float f = documentViewModel.getViewZoom();
        int n3 = (int)(30.0f * f);
        int n4 = (int)(20.0f * f);
        if (this.rectToDraw == null) {
            this.rectToDraw = new Rectangle(n, n2, n3, n4);
        }
        this.rectToDraw.setLocation(this.rectToDraw.x, this.rectToDraw.y);
        this.rectToDraw.setSize(new Dimension(n3, n4));
        Rectangle rectangle = this.convertToPageSpace(this.rectToDraw).getBounds();
        rectangle.setLocation(rectangle.x - 5, rectangle.y - rectangle.height - 5);
        this.annotation = (FreeTextAnnotation)AnnotationFactory.buildAnnotation((Library)this.documentViewController.getDocument().getPageTree().getLibrary(), (Name)Annotation.SUBTYPE_FREE_TEXT, (Rectangle)rectangle);
        ViewModel viewModel = this.documentViewController.getParentController().getViewModel();
        this.annotation.setFlag(1024, !viewModel.getAnnotationPrivacy());
        this.annotation.setCreationDate(PDate.formatDateTime((Date)new Date()));
        this.annotation.setTitleText(SystemProperties.USER_NAME);
        this.annotation.setContents("");
        this.checkAndApplyPreferences();
        AffineTransform affineTransform = this.getToPageSpaceTransform();
        this.annotation.resetAppearanceStream(affineTransform);
        AbstractAnnotationComponent abstractAnnotationComponent = AnnotationComponentFactory.buildAnnotationComponent((Annotation)this.annotation, this.documentViewController, this.pageViewComponent);
        abstractAnnotationComponent.setBounds(this.rectToDraw);
        abstractAnnotationComponent.refreshAnnotationRect();
        this.documentViewController.addNewAnnotation(abstractAnnotationComponent);
        this.documentViewController.getParentController().setDocumentToolMode(this.preferences.getInt("application.annotation.freetext.selection.type", 0));
        ((FreeTextAnnotationComponent)abstractAnnotationComponent).requestTextAreaFocus();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.createFreeTextAnnotation(mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    protected void checkAndApplyPreferences() {
        int n;
        if (this.preferences.getInt("application.viewer.preference.annotation.freetext.color", -1) != -1) {
            n = this.preferences.getInt("application.viewer.preference.annotation.freetext.color", 0);
            this.annotation.setFontColor(new Color(n));
        }
        if (this.preferences.getInt("application.viewer.preference.annotation.freetext.fill.color", -1) != -1) {
            n = this.preferences.getInt("application.viewer.preference.annotation.freetext.fill.color", 0);
            this.annotation.setFillColor(new Color(n));
        }
        if (this.preferences.getInt("application.viewer.preference.annotation.freetext.border.color", -1) != -1) {
            n = this.preferences.getInt("application.viewer.preference.annotation.freetext.border.color", 0);
            this.annotation.setColor(new Color(n));
        }
        String string = this.preferences.get("application.viewer.preference.annotation.freetext.font", "Helvetica");
        this.annotation.setFontName(string);
        int n2 = this.preferences.getInt("application.viewer.preference.annotation.freetext.size", FreeTextAnnotation.defaultFontSize);
        this.annotation.setFontSize(n2);
        int n3 = this.preferences.getInt("application.viewer.preference.annotation.freetext.opacity", 255);
        this.annotation.setOpacity(n3);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.updateSelectionSize(mouseEvent.getX(), mouseEvent.getY(), this.pageViewComponent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }
}

