/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.tools.ZoomOutPageHandler;
import org.icepdf.ri.common.views.DocumentViewController;

public class DynamicZoomHandler
implements ToolHandler,
MouseWheelListener {
    private static final Logger logger = Logger.getLogger(ZoomOutPageHandler.class.toString());
    private final DocumentViewController documentViewController;
    protected final JScrollPane documentScrollPane;

    public DynamicZoomHandler(DocumentViewController documentViewController, JScrollPane jScrollPane) {
        this.documentViewController = documentViewController;
        this.documentScrollPane = jScrollPane;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        this.documentScrollPane.setWheelScrollingEnabled(false);
        Point point = this.documentScrollPane.getViewport().getViewPosition();
        int n2 = this.documentScrollPane.getViewport().getWidth() / 2;
        int n3 = this.documentScrollPane.getViewport().getHeight() / 2;
        point.setLocation(point.x + n2, point.y + n3);
        if (n > 0) {
            this.documentViewController.setZoomOut(point);
        } else {
            this.documentViewController.setZoomIn(point);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void paintTool(Graphics graphics) {
    }

    @Override
    public void installTool() {
        this.documentScrollPane.setWheelScrollingEnabled(false);
        this.documentScrollPane.addMouseWheelListener(this);
    }

    @Override
    public void uninstallTool() {
        this.documentScrollPane.setWheelScrollingEnabled(true);
        this.documentScrollPane.removeMouseWheelListener(this);
    }
}

