/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.icepdf.ri.common.tools.CommonToolHandler;
import org.icepdf.ri.common.tools.DestinationHandler;
import org.icepdf.ri.common.tools.FreeTextAnnotationHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.images.Images;

public class AnnotationSelectionHandler
extends CommonToolHandler
implements ToolHandler,
ActionListener {
    protected final DocumentViewController documentViewController;
    protected final AbstractPageViewComponent pageViewComponent;
    private final JPopupMenu contextMenu;
    private final JMenuItem addDestinationMenuItem;
    private final JMenuItem freeTextMenuItem;
    private int x;
    private int y;

    public AnnotationSelectionHandler(DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(documentViewController, abstractPageViewComponent);
        this.documentViewController = documentViewController;
        this.pageViewComponent = abstractPageViewComponent;
        ResourceBundle resourceBundle = documentViewController.getParentController().getMessageBundle();
        this.contextMenu = new JPopupMenu();
        this.addDestinationMenuItem = new JMenuItem(resourceBundle.getString("viewer.utilityPane.view.selectionTool.contextMenu.addDestination.label"));
        this.addDestinationMenuItem.setIcon(new ImageIcon(Images.get("destination_20.png")));
        this.addDestinationMenuItem.addActionListener(this);
        this.contextMenu.add(this.addDestinationMenuItem);
        this.freeTextMenuItem = new JMenuItem(resourceBundle.getString("viewer.utilityPane.view.selectionTool.contextMenu.addFreeText.label"));
        this.freeTextMenuItem.setIcon(new ImageIcon(Images.get("freetext_annot_a_20.png")));
        this.freeTextMenuItem.addActionListener(this);
        this.contextMenu.add(this.freeTextMenuItem);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.documentViewController.clearSelectedAnnotations();
        if (this.pageViewComponent != null) {
            this.pageViewComponent.requestFocus();
        }
        if (this.pageViewComponent != null && mouseEvent.getButton() == 3) {
            this.x = mouseEvent.getX();
            this.y = mouseEvent.getY();
            this.contextMenu.show(mouseEvent.getComponent(), this.x, this.y);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addDestinationMenuItem) {
            new DestinationHandler(this.documentViewController, this.pageViewComponent).createNewDestination(this.x, this.y);
        } else if (actionEvent.getSource() == this.freeTextMenuItem) {
            new FreeTextAnnotationHandler(this.documentViewController, this.pageViewComponent).createFreeTextAnnotation(this.x, this.y);
        }
    }

    @Override
    public void paintTool(Graphics graphics) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    protected void checkAndApplyPreferences() {
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }
}

