/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.icepdf.ri.common.EscapeJDialog;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.preferences.AdvancedPreferencesPanel;
import org.icepdf.ri.common.preferences.AnnotationPreferencesPanel;
import org.icepdf.ri.common.preferences.ExImportPreferencesPanel;
import org.icepdf.ri.common.preferences.FontsPreferencesPanel;
import org.icepdf.ri.common.preferences.GeneralPreferencesPanel;
import org.icepdf.ri.common.preferences.ImagingPreferencesPanel;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class PreferencesDialog
extends EscapeJDialog {
    private final GridBagConstraints constraints;
    private final JTabbedPane propertiesTabbedPane;

    public PreferencesDialog(Frame frame, SwingController swingController, ResourceBundle resourceBundle) {
        super(frame, true);
        this.setTitle(resourceBundle.getString("viewer.dialog.viewerPreferences.title"));
        JButton jButton = new JButton(resourceBundle.getString("viewer.button.ok.label"));
        jButton.setMnemonic(resourceBundle.getString("viewer.button.ok.mnemonic").charAt(0));
        jButton.addActionListener(actionEvent -> {
            if (actionEvent.getSource() == jButton) {
                this.setVisible(false);
                this.dispose();
            }
        });
        this.propertiesTabbedPane = this.createTabbedPane(swingController, resourceBundle);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.constraints.anchor = 11;
        this.addGB(jPanel, this.propertiesTabbedPane, 0, 0, 1, 1);
        this.constraints.fill = 0;
        this.addGB(jPanel, jButton, 0, 1, 1, 1);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)jPanel, "North");
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    protected GeneralPreferencesPanel createGeneralPreferencesPanel(SwingController swingController, ViewerPropertiesManager viewerPropertiesManager, ResourceBundle resourceBundle) {
        return new GeneralPreferencesPanel(swingController, viewerPropertiesManager, resourceBundle);
    }

    protected AnnotationPreferencesPanel createAnnotationPreferencesPanel(SwingController swingController, ViewerPropertiesManager viewerPropertiesManager, ResourceBundle resourceBundle) {
        return new AnnotationPreferencesPanel(swingController, viewerPropertiesManager, resourceBundle);
    }

    protected ImagingPreferencesPanel createImagingPreferencesPanel(SwingController swingController, ViewerPropertiesManager viewerPropertiesManager, ResourceBundle resourceBundle) {
        return new ImagingPreferencesPanel(swingController, viewerPropertiesManager, resourceBundle);
    }

    protected FontsPreferencesPanel createFontsPreferencesPanel(SwingController swingController, ViewerPropertiesManager viewerPropertiesManager, ResourceBundle resourceBundle) {
        return new FontsPreferencesPanel(swingController, viewerPropertiesManager, resourceBundle);
    }

    protected AdvancedPreferencesPanel createAdvancedPreferencesPanel(SwingController swingController, ViewerPropertiesManager viewerPropertiesManager, ResourceBundle resourceBundle) {
        return new AdvancedPreferencesPanel(swingController, viewerPropertiesManager, resourceBundle);
    }

    protected ExImportPreferencesPanel createExImportPreferencesPanel(SwingController swingController, ViewerPropertiesManager viewerPropertiesManager, ResourceBundle resourceBundle, Dialog dialog) {
        return new ExImportPreferencesPanel(swingController, viewerPropertiesManager, resourceBundle, dialog);
    }

    protected JTabbedPane createTabbedPane(SwingController swingController, ResourceBundle resourceBundle) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setAlignmentY(0.0f);
        ViewerPropertiesManager viewerPropertiesManager = ViewerPropertiesManager.getInstance();
        if (viewerPropertiesManager.checkAndStoreBooleanProperty("application.preferences.show.general")) {
            jTabbedPane.addTab(resourceBundle.getString("viewer.dialog.viewerPreferences.section.general.title"), this.createGeneralPreferencesPanel(swingController, viewerPropertiesManager, resourceBundle));
        }
        if (viewerPropertiesManager.checkAndStoreBooleanProperty("application.preferences.show.annotations")) {
            jTabbedPane.addTab(resourceBundle.getString("viewer.dialog.viewerPreferences.section.annotations.title"), this.createAnnotationPreferencesPanel(swingController, viewerPropertiesManager, resourceBundle));
        }
        if (viewerPropertiesManager.checkAndStoreBooleanProperty("application.preferences.show.imaging")) {
            jTabbedPane.addTab(resourceBundle.getString("viewer.dialog.viewerPreferences.section.imaging.title"), this.createImagingPreferencesPanel(swingController, viewerPropertiesManager, resourceBundle));
        }
        if (viewerPropertiesManager.checkAndStoreBooleanProperty("application.preferences.show.fonts")) {
            jTabbedPane.addTab(resourceBundle.getString("viewer.dialog.viewerPreferences.section.fonts.title"), this.createFontsPreferencesPanel(swingController, viewerPropertiesManager, resourceBundle));
        }
        if (viewerPropertiesManager.checkAndStoreBooleanProperty("application.preferences.show.advanced")) {
            jTabbedPane.addTab(resourceBundle.getString("viewer.dialog.viewerPreferences.section.advanced.title"), this.createAdvancedPreferencesPanel(swingController, viewerPropertiesManager, resourceBundle));
        }
        if (viewerPropertiesManager.checkAndStoreBooleanProperty("application.preferences.show.eximport", true)) {
            jTabbedPane.addTab(resourceBundle.getString("viewer.dialog.viewerPreferences.section.eximport.title"), this.createExImportPreferencesPanel(swingController, viewerPropertiesManager, resourceBundle, this));
        }
        return jTabbedPane;
    }

    public void setSelectedPreference(String string) {
        if ("application.preferences.show.general".equals(string)) {
            this.propertiesTabbedPane.setSelectedIndex(0);
        } else if ("application.preferences.show.annotations".equals(string)) {
            this.propertiesTabbedPane.setSelectedIndex(1);
        } else if ("application.preferences.show.imaging".equals(string)) {
            this.propertiesTabbedPane.setSelectedIndex(2);
        } else if ("application.preferences.show.fonts".equals(string)) {
            this.propertiesTabbedPane.setSelectedIndex(3);
        } else if ("application.preferences.show.advanced".equals(string)) {
            this.propertiesTabbedPane.setSelectedIndex(4);
        } else {
            this.propertiesTabbedPane.setSelectedIndex(0);
        }
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }
}

