/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.fonts;

import java.text.MessageFormat;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.icepdf.core.pobjects.fonts.Font;
import org.icepdf.ri.common.AbstractWorkerPanel;
import org.icepdf.ri.common.fonts.FindFontsTask;
import org.icepdf.ri.common.fonts.FontCellRender;
import org.icepdf.ri.common.views.Controller;

public class FontHandlerPanel
extends AbstractWorkerPanel {
    private final MessageFormat typeMessageForm;
    private final MessageFormat encodingMessageForm;
    private final MessageFormat actualTypeMessageForm;
    private final MessageFormat actualFontMessageForm;

    public FontHandlerPanel(Controller controller) {
        super(controller);
        this.typeMessageForm = new MessageFormat(this.messageBundle.getString("viewer.dialog.fonts.info.type.label"));
        this.encodingMessageForm = new MessageFormat(this.messageBundle.getString("viewer.dialog.fonts.info.encoding.label"));
        this.actualTypeMessageForm = new MessageFormat(this.messageBundle.getString("viewer.dialog.fonts.info.substitution.type.label"));
        this.actualFontMessageForm = new MessageFormat(this.messageBundle.getString("viewer.dialog.fonts.info.substitution.path.label"));
    }

    @Override
    public void buildUI() {
        super.buildUI();
        this.buildProgressBar();
    }

    @Override
    public void refreshDocumentInstance() {
        this.stopWorkerTask();
        super.refreshDocumentInstance();
        this.rootNodeLabel = this.getDocumentTitle();
        this.cellRenderer = new FontCellRender();
        if (this.progressLabel != null) {
            this.progressLabel.setText("");
        }
        this.buildUI();
        this.workerTask = new FindFontsTask(this, this.controller, this.messageBundle);
        this.workerTask.execute();
    }

    @Override
    public void startProgressControls(int n) {
        this.progressBar.setMaximum(n);
        this.progressBar.setVisible(true);
        this.progressLabel.setVisible(true);
    }

    @Override
    public void updateProgressControls(int n) {
        this.progressBar.setValue(n);
    }

    @Override
    public void updateProgressControls(int n, String string) {
    }

    @Override
    public void updateProgressControls(String string) {
    }

    @Override
    public void endProgressControls() {
        this.progressBar.setVisible(false);
        this.progressLabel.setVisible(false);
    }

    @Override
    protected void buildWorkerTaskUI() {
    }

    @Override
    public void selectTreeNodeUserObject(Object object) {
    }

    void addFoundEntry(Font font) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(font.getBaseFont(), true);
        this.insertNode(font.getSubType(), this.typeMessageForm, defaultMutableTreeNode);
        this.insertNode(font.getEncoding(), this.encodingMessageForm, defaultMutableTreeNode);
        if (font.isFontSubstitution() && font.getFont() != null) {
            this.insertNode(font.getFont().getName(), this.actualTypeMessageForm, defaultMutableTreeNode);
            this.insertNode(font.getFont().getSource(), this.actualFontMessageForm, defaultMutableTreeNode);
        }
        this.addObject(this.rootTreeNode, defaultMutableTreeNode);
        this.tree.expandPath(new TreePath(this.rootTreeNode));
    }

    private void insertNode(Object object, MessageFormat messageFormat, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (object != null) {
            Object[] objectArray = new Object[]{object.toString()};
            object = messageFormat.format(objectArray);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object, true);
            this.addObject(defaultMutableTreeNode, defaultMutableTreeNode2);
        }
    }

    private void addObject(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = this.rootTreeNode;
        }
        this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
    }
}

