/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.fonts;

import java.awt.Container;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.DictionaryEntries;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.fonts.Font;
import org.icepdf.core.util.Library;
import org.icepdf.ri.common.AbstractTask;
import org.icepdf.ri.common.fonts.FontHandlerPanel;
import org.icepdf.ri.common.views.Controller;

public class FindFontsTask
extends AbstractTask<Void, Font> {
    private static final Logger logger = Logger.getLogger(FindFontsTask.class.toString());
    private final MessageFormat searchingMessageForm;
    private final Container viewContainer;

    public FindFontsTask(FontHandlerPanel fontHandlerPanel, Controller controller, ResourceBundle resourceBundle) {
        super(controller, fontHandlerPanel, resourceBundle);
        this.viewContainer = controller.getDocumentViewController().getViewContainer();
        this.searchingMessageForm = new MessageFormat(resourceBundle.getString("viewer.dialog.fonts.searching.label"));
        this.lengthOfTask = controller.getDocument().getNumberOfPages();
        fontHandlerPanel.startProgressControls(this.lengthOfTask);
    }

    @Override
    protected Void doInBackground() {
        try {
            HashMap<Reference, Font> hashMap = new HashMap<Reference, Font>();
            Document document = this.controller.getDocument();
            block2: for (int i = 0; i < document.getNumberOfPages() && !this.isCancelled(); ++i) {
                DictionaryEntries dictionaryEntries;
                this.taskProgress = i;
                int n = (int)((float)i / (float)this.lengthOfTask * 100.0f);
                Object[] objectArray = new Object[]{String.valueOf(n)};
                this.taskStatusMessage = this.searchingMessageForm.format(objectArray);
                Library library = document.getCatalog().getLibrary();
                Page page = document.getPageTree().getPage(i);
                page.initPageResources();
                Resources resources = page.getResources();
                if (resources == null || (dictionaryEntries = resources.getFonts()) == null || dictionaryEntries.size() <= 0) continue;
                Set set = dictionaryEntries.keySet();
                for (Object k : set) {
                    Reference reference;
                    Object object = dictionaryEntries.get(k);
                    if (!(object instanceof Reference) || hashMap.containsKey(reference = (Reference)object)) continue;
                    object = library.getObject(reference);
                    if (this.isCancelled()) {
                        this.taskStatusMessage = "";
                        continue block2;
                    }
                    if (!(object instanceof Font)) continue;
                    Font font = (Font)object;
                    font.init();
                    hashMap.put(reference, font);
                    this.publish(font);
                }
            }
            this.taskStatusMessage = "";
        }
        catch (InterruptedException interruptedException) {
            logger.finer("Find fonts task interrupted. ");
        }
        return null;
    }

    @Override
    protected void process(List<Font> list) {
        for (Font font : list) {
            ((FontHandlerPanel)this.workerPanel).addFoundEntry(font);
        }
        this.workerPanel.updateProgressControls(this.taskProgress);
        this.workerPanel.expandAllNodes();
        this.viewContainer.repaint();
    }

    @Override
    protected void done() {
        this.workerPanel.endProgressControls();
    }
}

