/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.util.ArrayList;
import org.icepdf.core.Memento;
import org.icepdf.core.util.Defs;

public class UndoCaretaker {
    private static final int maxHistorySize = Defs.sysPropertyInt((String)"org.icepdf.ri.viewer.undo.size", (int)25);
    private final ArrayList<Memento> mementoStateHistory = new ArrayList(maxHistorySize);
    private int cursor = 0;

    public void undo() {
        if (this.isUndo()) {
            --this.cursor;
            Memento memento = this.mementoStateHistory.get(this.cursor);
            memento.restore();
        }
    }

    public boolean isUndo() {
        return this.mementoStateHistory.size() > 0 && this.cursor > 0;
    }

    public void redo() {
        if (this.isRedo()) {
            ++this.cursor;
            Memento memento = this.mementoStateHistory.get(this.cursor);
            memento.restore();
        }
    }

    public boolean isRedo() {
        return this.cursor + 1 < this.mementoStateHistory.size();
    }

    public void addState(Memento memento, Memento memento2) {
        if (this.cursor >= maxHistorySize) {
            this.mementoStateHistory.remove(0);
            this.mementoStateHistory.remove(1);
            this.cursor = this.mementoStateHistory.size() - 1;
        }
        if (this.isRedo()) {
            int n = this.mementoStateHistory.size();
            for (int i = this.cursor + 1; i < n; ++i) {
                this.mementoStateHistory.remove(this.cursor + 1);
            }
        }
        if (this.mementoStateHistory.size() == 0) {
            this.mementoStateHistory.add(memento);
            this.mementoStateHistory.add(memento2);
            this.cursor = 1;
        } else {
            this.mementoStateHistory.set(this.cursor, memento);
            this.mementoStateHistory.add(memento2);
            ++this.cursor;
        }
    }
}

