/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.graphics.images.references.ImageReference;
import org.icepdf.core.pobjects.graphics.images.references.ImageReferenceFactory;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.KeyEventConstants;
import org.icepdf.ri.common.PageNumberTextFieldInputVerifier;
import org.icepdf.ri.common.PageNumberTextFieldKeyListener;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.ToolbarLayout;
import org.icepdf.ri.common.ViewBuilder;
import org.icepdf.ri.common.WindowManagementCallback;
import org.icepdf.ri.common.utility.annotation.AnnotationPanel;
import org.icepdf.ri.common.utility.annotation.destinations.DestinationsPanel;
import org.icepdf.ri.common.utility.annotation.markup.MarkupAnnotationPanel;
import org.icepdf.ri.common.utility.attachment.AttachmentPanel;
import org.icepdf.ri.common.utility.layers.LayersPanel;
import org.icepdf.ri.common.utility.outline.OutlinesTree;
import org.icepdf.ri.common.utility.search.SearchPanel;
import org.icepdf.ri.common.utility.search.SearchToolBar;
import org.icepdf.ri.common.utility.signatures.SignaturesHandlerPanel;
import org.icepdf.ri.common.utility.thumbs.ThumbnailsPanel;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewControllerImpl;
import org.icepdf.ri.common.views.PageViewDecorator;
import org.icepdf.ri.common.widgets.annotations.AnnotationColorToggleButton;
import org.icepdf.ri.common.widgets.annotations.IconAnnotationColorToggleButton;
import org.icepdf.ri.images.Images;
import org.icepdf.ri.util.MacOSAdapter;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class SwingViewBuilder
implements ViewBuilder {
    private static final Logger logger = Logger.getLogger(SwingViewBuilder.class.toString());
    public static final int TOOL_BAR_STYLE_FIXED = 2;
    protected static final float[] DEFAULT_ZOOM_LEVELS = new float[]{0.05f, 0.1f, 0.25f, 0.5f, 0.75f, 1.0f, 1.5f, 2.0f, 3.0f, 4.0f, 8.0f, 16.0f, 24.0f, 32.0f, 64.0f};
    protected SwingController viewerController;
    protected Font buttonFont;
    protected boolean showButtonText;
    protected int toolbarStyle;
    protected float[] zoomLevels;
    protected boolean haveMadeAToolBar;
    protected int documentViewType;
    protected int documentPageFitMode;
    protected String iconSize;
    protected ResourceBundle messageBundle;
    protected static ViewerPropertiesManager propertiesManager;
    protected static final boolean isMacOs;

    public SwingViewBuilder(SwingController swingController) {
        this(swingController, null, null, false, 2, null, 1, 3, 0.0f);
    }

    public SwingViewBuilder(SwingController swingController, ViewerPropertiesManager viewerPropertiesManager) {
        this(swingController, viewerPropertiesManager, null, false, 2, null, 1, 3, 0.0f);
    }

    public SwingViewBuilder(SwingController swingController, int n, int n2) {
        this(swingController, null, null, false, 2, null, n, n2, 0.0f);
    }

    public SwingViewBuilder(SwingController swingController, int n, int n2, float f) {
        this(swingController, null, null, false, 2, null, n, n2, f);
    }

    public SwingViewBuilder(SwingController swingController, Font font, boolean bl, int n, float[] fArray, int n2, int n3) {
        this(swingController, null, font, bl, n, fArray, n2, n3, 0.0f);
    }

    public SwingViewBuilder(SwingController swingController, ViewerPropertiesManager viewerPropertiesManager, Font font, boolean bl, int n, float[] fArray, int n2, int n3, float f) {
        this.viewerController = swingController;
        this.messageBundle = this.viewerController.getMessageBundle();
        propertiesManager = viewerPropertiesManager;
        if (propertiesManager == null) {
            propertiesManager = ViewerPropertiesManager.getInstance();
        }
        this.viewerController.setPropertiesManager(propertiesManager);
        this.overrideHighlightColor(propertiesManager);
        DocumentViewControllerImpl documentViewControllerImpl = (DocumentViewControllerImpl)this.viewerController.getDocumentViewController();
        documentViewControllerImpl.setDocumentViewType(n2, n3);
        this.buttonFont = font;
        if (this.buttonFont == null) {
            this.buttonFont = SwingViewBuilder.buildButtonFont();
        }
        this.showButtonText = bl;
        this.toolbarStyle = n;
        this.zoomLevels = fArray;
        if (this.zoomLevels == null) {
            this.zoomLevels = DEFAULT_ZOOM_LEVELS;
        }
        this.documentViewType = n2;
        this.documentPageFitMode = n3;
        this.iconSize = propertiesManager.getPreferences().get("application.icon.default.size", "_32");
    }

    @Override
    public JFrame buildViewerFrame() {
        JFrame jFrame = new JFrame();
        jFrame.setIconImage(new ImageIcon(Images.get("icepdf-app-icon-64x64.png")).getImage());
        jFrame.setTitle(this.messageBundle.getString("viewer.window.title.default"));
        jFrame.setDefaultCloseOperation(0);
        JMenuBar jMenuBar = this.buildCompleteMenuBar();
        if (jMenuBar != null) {
            jFrame.setJMenuBar(jMenuBar);
        }
        Container container = jFrame.getContentPane();
        this.buildContents(container, false);
        if (this.viewerController != null) {
            this.viewerController.setViewerFrame(jFrame);
        }
        return jFrame;
    }

    public JPanel buildViewerPanel() {
        JPanel jPanel = new JPanel();
        this.buildContents(jPanel, true);
        return jPanel;
    }

    @Override
    public void buildContents(Container container, boolean bl) {
        JPanel jPanel;
        JSplitPane jSplitPane;
        container.setLayout(new BorderLayout());
        JToolBar jToolBar = this.buildCompleteToolBar(bl);
        if (jToolBar != null) {
            container.add((Component)jToolBar, "North");
        }
        if ((jSplitPane = this.buildUtilityAndDocumentSplitPane(bl)) != null) {
            container.add((Component)jSplitPane, "Center");
        }
        if ((jPanel = this.buildStatusPanel()) != null) {
            container.add((Component)jPanel, "South");
        }
    }

    @Override
    public JMenuBar buildCompleteMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.addToMenuBar(jMenuBar, this.buildFileMenu());
        this.addToMenuBar(jMenuBar, this.buildEditMenu());
        this.addToMenuBar(jMenuBar, this.buildViewMenu());
        this.addToMenuBar(jMenuBar, this.buildDocumentMenu());
        this.addToMenuBar(jMenuBar, this.buildWindowMenu());
        this.addToMenuBar(jMenuBar, this.buildHelpMenu());
        if (isMacOs) {
            try {
                MacOSAdapter.setQuitHandler(this.viewerController, this.viewerController.getClass().getDeclaredMethod("exit", null));
                MacOSAdapter.setAboutHandler(this.viewerController, this.viewerController.getClass().getDeclaredMethod("showAboutDialog", null));
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "Error occurred while loading the MacOSAdapter:", exception);
            }
        }
        return jMenuBar;
    }

    protected static KeyStroke buildKeyStroke(int n, int n2) {
        return SwingViewBuilder.buildKeyStroke(n, n2, false);
    }

    protected static KeyStroke buildKeyStroke(int n, int n2, boolean bl) {
        SwingViewBuilder.doubleCheckPropertiesManager();
        if (propertiesManager.checkAndStoreBooleanProperty("application.menuitem.show.keyboard.shortcuts", true)) {
            return KeyStroke.getKeyStroke(n, n2, bl);
        }
        return null;
    }

    protected int buildMnemonic(char c) {
        SwingViewBuilder.doubleCheckPropertiesManager();
        if (propertiesManager.checkAndStoreBooleanProperty("application.menuitem.show.keyboard.shortcuts", true)) {
            return c;
        }
        return -1;
    }

    public JMenu buildFileMenu() {
        JMenu jMenu = new JMenu(this.messageBundle.getString("viewer.menu.file.label"));
        jMenu.setMnemonic(this.buildMnemonic(this.messageBundle.getString("viewer.menu.file.mnemonic").charAt(0)));
        JMenuItem jMenuItem = this.buildOpenFileMenuItem();
        JMenuItem jMenuItem2 = this.buildOpenURLMenuItem();
        if (jMenuItem != null && jMenuItem2 != null) {
            JMenu jMenu2 = new JMenu(this.messageBundle.getString("viewer.menu.open.label"));
            jMenu2.setIcon(new ImageIcon(Images.get("open_a_24.png")));
            jMenu2.setDisabledIcon(new ImageIcon(Images.get("open_i_24.png")));
            jMenu2.setRolloverIcon(new ImageIcon(Images.get("open_r_24.png")));
            this.addToMenu(jMenu2, jMenuItem);
            this.addToMenu(jMenu2, jMenuItem2);
            this.addToMenu(jMenu, jMenu2);
        } else if (jMenuItem != null || jMenuItem2 != null) {
            this.addToMenu(jMenu, jMenuItem);
            this.addToMenu(jMenu, jMenuItem2);
        }
        this.addToMenu(jMenu, this.buildRecentFileMenuItem());
        jMenu.addSeparator();
        this.addToMenu(jMenu, this.buildCloseMenuItem());
        this.addToMenu(jMenu, this.buildSaveFileMenuItem());
        this.addToMenu(jMenu, this.buildSaveAsFileMenuItem());
        jMenu.addSeparator();
        this.addToMenu(jMenu, this.buildExportDocumentFileMenuItem());
        this.addToMenu(jMenu, this.buildExportTextMenuItem());
        this.addToMenu(jMenu, this.buildSendByMailMenuItem());
        jMenu.addSeparator();
        this.addToMenu(jMenu, this.buildPropertiesMenuItem());
        jMenu.addSeparator();
        this.addToMenu(jMenu, this.buildPrintSetupMenuItem());
        this.addToMenu(jMenu, this.buildPrintMenuItem());
        if (!isMacOs) {
            jMenu.addSeparator();
            this.addToMenu(jMenu, this.buildExitMenuItem());
        }
        return jMenu;
    }

    public JMenu buildRecentFileMenuItem() {
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.show.resentfiles")) {
            JMenu jMenu = new JMenu(this.messageBundle.getString("viewer.menu.open.recentFiles.label"));
            this.viewerController.setRecentFilesSubMenu(jMenu);
            this.viewerController.refreshRecentFileMenuItem();
            return jMenu;
        }
        return null;
    }

    public JMenuItem buildOpenFileMenuItem() {
        JMenuItem jMenuItem = SwingViewBuilder.makeMenuItem(this.messageBundle.getString("viewer.menu.open.file.label"), SwingViewBuilder.buildKeyStroke(79, KeyEventConstants.MODIFIER_OPEN_FILE));
        if (this.viewerController != null) {
            this.viewerController.setOpenFileMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildSendByMailMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.sendMail.label"), null, this.iconSize, SwingViewBuilder.buildKeyStroke(77, KeyEventConstants.MODIFIER_SEND_MAIL));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setSendMailMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildOpenURLMenuItem() {
        JMenuItem jMenuItem = SwingViewBuilder.makeMenuItem(this.messageBundle.getString("viewer.menu.open.URL.label"), SwingViewBuilder.buildKeyStroke(85, KeyEventConstants.MODIFIER_OPEN_URL));
        if (this.viewerController != null) {
            this.viewerController.setOpenURLMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildCloseMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.close.label"), null, null, SwingViewBuilder.buildKeyStroke(87, KeyEventConstants.MODIFIER_CLOSE));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setCloseMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildSaveFileMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.save.label"), "save", "_24", SwingViewBuilder.buildKeyStroke(83, KeyEventConstants.MODIFIER_SAVE, false));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setSaveFileMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildSaveAsFileMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.saveAs.label"), null, null, SwingViewBuilder.buildKeyStroke(83, KeyEventConstants.MODIFIER_SAVE_AS, false));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setSaveAsFileMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildExportDocumentFileMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.exportDocument.label"), null, null, SwingViewBuilder.buildKeyStroke(69, KeyEventConstants.MODIFIER_EXPORT_DOCUMENT, false));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setExportDocumentFileMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildExportTextMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.exportText.label"), null, null, SwingViewBuilder.buildKeyStroke(84, KeyEventConstants.MODIFIER_EXPORT_TEXT, false));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setExportTextMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildPropertiesMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.documentProperties.label"), null, null, SwingViewBuilder.buildKeyStroke(68, KeyEventConstants.MODIFIER_DOCUMENT_PROPERTIES));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setPropertiesMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildPermissionsMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.documentPermission.label"), null, null, null);
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setPermissionsMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildInformationMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.documentInformation.label"), null, null, null);
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setInformationMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildFontInformationMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.documentFonts.label"), null, null, null);
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setFontInformationMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildPrintSetupMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.printSetup.label"), null, null, SwingViewBuilder.buildKeyStroke(80, KeyEventConstants.MODIFIER_PRINT_SETUP, false));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setPrintSetupMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildPrintMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.print.label"), "print", "_24", SwingViewBuilder.buildKeyStroke(80, KeyEventConstants.MODIFIER_PRINT));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setPrintMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildExitMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.exit.label"), null, null, SwingViewBuilder.buildKeyStroke(81, KeyEventConstants.MODIFIER_EXIT));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setExitMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenu buildEditMenu() {
        JMenu jMenu = new JMenu(this.messageBundle.getString("viewer.menu.edit.label"));
        jMenu.setMnemonic(this.buildMnemonic(this.messageBundle.getString("viewer.menu.edit.mnemonic").charAt(0)));
        this.addToMenu(jMenu, this.buildUndoMenuItem());
        this.addToMenu(jMenu, this.buildRedoMenuItem());
        jMenu.addSeparator();
        this.addToMenu(jMenu, this.buildCopyMenuItem());
        this.addToMenu(jMenu, this.buildDeleteMenuItem());
        jMenu.addSeparator();
        this.addToMenu(jMenu, this.buildSelectAllMenuItem());
        this.addToMenu(jMenu, this.buildDeselectAllMenuItem());
        jMenu.addSeparator();
        this.addToMenu(jMenu, this.buildPreferencesMenuItem());
        return jMenu;
    }

    public JMenuItem buildUndoMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.edit.undo.label"), null, null, SwingViewBuilder.buildKeyStroke(90, KeyEventConstants.MODIFIER_UNDO));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setUndoMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildRedoMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.edit.redo.label"), null, null, SwingViewBuilder.buildKeyStroke(90, KeyEventConstants.MODIFIER_REDO));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setReduMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildCopyMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.edit.copy.label"), null, null, SwingViewBuilder.buildKeyStroke(67, KeyEventConstants.MODIFIER_COPY));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setCopyMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildDeleteMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.edit.delete.label"), null, null, SwingViewBuilder.buildKeyStroke(68, KeyEventConstants.MODIFIER_DELETE));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setDeleteMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildSelectAllMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.edit.selectAll.label"), null, null, SwingViewBuilder.buildKeyStroke(65, KeyEventConstants.MODIFIER_SELECT_ALL));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setSelectAllMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildDeselectAllMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.edit.deselectAll.label"), null, null, SwingViewBuilder.buildKeyStroke(65, KeyEventConstants.MODIFIER_DESELECT_ALL));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setDeselectAllMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildPreferencesMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.edit.preferences.label"), null, null, SwingViewBuilder.buildKeyStroke(75, KeyEventConstants.MODIFIER_PREFERENCES));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setPreferencesMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenu buildViewMenu() {
        JMenu jMenu = new JMenu(this.messageBundle.getString("viewer.menu.view.label"));
        jMenu.setMnemonic(this.buildMnemonic(this.messageBundle.getString("viewer.menu.view.mnemonic").charAt(0)));
        this.addToMenu(jMenu, this.buildFitActualSizeMenuItem());
        this.addToMenu(jMenu, this.buildFitPageMenuItem());
        this.addToMenu(jMenu, this.buildFitWidthMenuItem());
        jMenu.addSeparator();
        this.addToMenu(jMenu, this.buildFullScreenMenuItem());
        jMenu.addSeparator();
        this.addToMenu(jMenu, this.buildZoomInMenuItem());
        this.addToMenu(jMenu, this.buildZoomOutMenuItem());
        jMenu.addSeparator();
        this.addToMenu(jMenu, this.buildRotateLeftMenuItem());
        this.addToMenu(jMenu, this.buildRotateRightMenuItem());
        jMenu.addSeparator();
        this.addToMenu(jMenu, this.buildShowHideToolBarMenuItem());
        this.addToMenu(jMenu, this.buildShowHideUtilityPaneMenuItem());
        return jMenu;
    }

    public JMenuItem buildFitActualSizeMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.view.actualSize.label"), "actual_size", "_24", SwingViewBuilder.buildKeyStroke(49, KeyEventConstants.MODIFIER_FIT_ACTUAL));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setFitActualSizeMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildFitPageMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.view.fitInWindow.label"), "fit_window", "_24", SwingViewBuilder.buildKeyStroke(50, KeyEventConstants.MODIFIER_FIT_PAGE));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setFitPageMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildFitWidthMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.view.fitWidth.label"), "fit_width", "_24", SwingViewBuilder.buildKeyStroke(51, KeyEventConstants.MODIFIER_FIT_WIDTH));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setFitWidthMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildFullScreenMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.view.fullScreen.label"), "fullscreen", "_24", SwingViewBuilder.buildKeyStroke(76, KeyEventConstants.MODIFIER_FULL_SCREEN));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setFullScreenMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildZoomInMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.view.zoomIn.label"), "zoom_in", "_24", SwingViewBuilder.buildKeyStroke(73, KeyEventConstants.MODIFIER_ZOOM_IN, false));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setZoomInMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildZoomOutMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.view.zoomOut.label"), "zoom_out", "_24", SwingViewBuilder.buildKeyStroke(79, KeyEventConstants.MODIFIER_ZOOM_OUT, false));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setZoomOutMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildRotateLeftMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.view.rotateLeft.label"), "rotate_left", "_24", SwingViewBuilder.buildKeyStroke(76, KeyEventConstants.MODIFIER_ROTATE_LEFT));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setRotateLeftMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildRotateRightMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.view.rotateRight.label"), "rotate_right", "_24", SwingViewBuilder.buildKeyStroke(82, KeyEventConstants.MODIFIER_ROTATE_RIGHT));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setRotateRightMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildShowHideToolBarMenuItem() {
        JMenuItem jMenuItem = SwingViewBuilder.makeMenuItem("", null);
        if (this.viewerController != null) {
            this.viewerController.setShowHideToolBarMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildShowHideUtilityPaneMenuItem() {
        JMenuItem jMenuItem = SwingViewBuilder.makeMenuItem("", null);
        if (this.viewerController != null) {
            this.viewerController.setShowHideUtilityPaneMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenu buildDocumentMenu() {
        JMenu jMenu = new JMenu(this.messageBundle.getString("viewer.menu.document.label"));
        jMenu.setMnemonic(this.buildMnemonic(this.messageBundle.getString("viewer.menu.document.mnemonic").charAt(0)));
        this.addToMenu(jMenu, this.buildFirstPageMenuItem());
        this.addToMenu(jMenu, this.buildPreviousPageMenuItem());
        this.addToMenu(jMenu, this.buildNextPageMenuItem());
        this.addToMenu(jMenu, this.buildLastPageMenuItem());
        jMenu.addSeparator();
        this.addToMenu(jMenu, this.buildSearchMenuItem());
        this.addToMenu(jMenu, this.buildAdvancedSearchMenuItem());
        this.addToMenu(jMenu, this.buildSearchNextMenuItem());
        this.addToMenu(jMenu, this.buildSearchPreviousMenuItem());
        jMenu.addSeparator();
        this.addToMenu(jMenu, this.buildGoToPageMenuItem());
        return jMenu;
    }

    public JMenuItem buildFirstPageMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.document.firstPage.label"), "first", "_24", SwingViewBuilder.buildKeyStroke(38, KeyEventConstants.MODIFIER_FIRST_PAGE));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setFirstPageMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildPreviousPageMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.document.previousPage.label"), "back", "_24", SwingViewBuilder.buildKeyStroke(37, KeyEventConstants.MODIFIER_PREVIOUS_PAGE));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setPreviousPageMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildNextPageMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.document.nextPage.label"), "forward", "_24", SwingViewBuilder.buildKeyStroke(39, KeyEventConstants.MODIFIER_NEXT_PAGE));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setNextPageMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildLastPageMenuItem() {
        JMenuItem jMenuItem = this.makeMenuItem(this.messageBundle.getString("viewer.menu.document.lastPage.label"), "last", "_24", SwingViewBuilder.buildKeyStroke(40, KeyEventConstants.MODIFIER_LAST_PAGE));
        if (this.viewerController != null && jMenuItem != null) {
            this.viewerController.setLastPageMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildSearchMenuItem() {
        JMenuItem jMenuItem = SwingViewBuilder.makeMenuItem(this.messageBundle.getString("viewer.menu.document.search.label"), SwingViewBuilder.buildKeyStroke(70, KeyEventConstants.MODIFIER_SEARCH));
        if (this.viewerController != null) {
            this.viewerController.setSearchMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildAdvancedSearchMenuItem() {
        JMenuItem jMenuItem = SwingViewBuilder.makeMenuItem(this.messageBundle.getString("viewer.toolbar.search.advanced.label"), SwingViewBuilder.buildKeyStroke(70, KeyEventConstants.MODIFIER_ADVANCED_SEARCH));
        if (this.viewerController != null) {
            this.viewerController.setAdvancedSearchMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildSearchNextMenuItem() {
        JMenuItem jMenuItem = SwingViewBuilder.makeMenuItem(this.messageBundle.getString("viewer.menu.document.search.next.label"), SwingViewBuilder.buildKeyStroke(114, 0));
        if (this.viewerController != null) {
            this.viewerController.setSearchNextMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildSearchPreviousMenuItem() {
        JMenuItem jMenuItem = SwingViewBuilder.makeMenuItem(this.messageBundle.getString("viewer.menu.document.search.previous.label"), SwingViewBuilder.buildKeyStroke(114, 64));
        if (this.viewerController != null) {
            this.viewerController.setSearchPreviousMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildGoToPageMenuItem() {
        JMenuItem jMenuItem = SwingViewBuilder.makeMenuItem(this.messageBundle.getString("viewer.menu.document.gotToPage.label"), SwingViewBuilder.buildKeyStroke(78, KeyEventConstants.MODIFIER_GOTO));
        if (this.viewerController != null) {
            this.viewerController.setGoToPageMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenu buildWindowMenu() {
        final JMenu jMenu = new JMenu(this.messageBundle.getString("viewer.menu.window.label"));
        jMenu.setMnemonic(this.buildMnemonic(this.messageBundle.getString("viewer.menu.window.mnemonic").charAt(0)));
        this.addToMenu(jMenu, this.buildMinimiseAllMenuItem());
        this.addToMenu(jMenu, this.buildBringAllToFrontMenuItem());
        jMenu.addSeparator();
        this.addToMenu(jMenu, this.buildShowAnnotationPreviewMenuItem());
        jMenu.addSeparator();
        final int n = jMenu.getItemCount();
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                for (int i = jMenu.getItemCount(); i > n; --i) {
                    jMenu.remove(i - 1);
                }
                SwingViewBuilder.this.buildWindowListMenuItems(jMenu);
            }
        });
        return jMenu;
    }

    public JMenuItem buildMinimiseAllMenuItem() {
        JMenuItem jMenuItem = SwingViewBuilder.makeMenuItem(this.messageBundle.getString("viewer.menu.window.minAll.label"), null);
        jMenuItem.setMnemonic(this.buildMnemonic(this.messageBundle.getString("viewer.menu.window.minAll.mnemonic").charAt(0)));
        if (this.viewerController != null) {
            this.viewerController.setMinimiseAllMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildBringAllToFrontMenuItem() {
        JMenuItem jMenuItem = SwingViewBuilder.makeMenuItem(this.messageBundle.getString("viewer.menu.window.frontAll.label"), null);
        jMenuItem.setMnemonic(this.buildMnemonic(this.messageBundle.getString("viewer.menu.window.frontAll.mnemonic").charAt(0)));
        if (this.viewerController != null) {
            this.viewerController.setBringAllToFrontMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem buildShowAnnotationPreviewMenuItem() {
        JMenuItem jMenuItem = SwingViewBuilder.makeMenuItem(this.messageBundle.getString("viewer.menu.window.annotationPreview.label"), null);
        jMenuItem.setMnemonic(this.buildMnemonic(this.messageBundle.getString("viewer.menu.window.annotationPreview.mnemonic").charAt(0)));
        if (this.viewerController != null) {
            this.viewerController.setAnnotationPreviewMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    public void buildWindowListMenuItems(JMenu jMenu) {
        if (this.viewerController != null && this.viewerController.getWindowManagementCallback() != null) {
            WindowManagementCallback windowManagementCallback = this.viewerController.getWindowManagementCallback();
            List list = windowManagementCallback.getWindowDocumentOriginList(this.viewerController);
            int n = -1;
            int n2 = list.size();
            if (n2 > 0 && list.get(n2 - 1) instanceof Integer) {
                n = (Integer)list.remove(--n2);
            }
            this.shortenDocumentOrigins(list);
            ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>(Math.max(n2, 1));
            for (int i = 0; i < n2; ++i) {
                String string = Integer.toString(i + 1);
                String string2 = null;
                String string3 = null;
                try {
                    string2 = this.messageBundle.getString("viewer.menu.window." + string + ".label");
                    string3 = this.messageBundle.getString("viewer.menu.window." + string + ".mnemonic");
                }
                catch (Exception exception) {
                    logger.log(Level.FINER, "Error setting viewer window window title", exception);
                }
                String string4 = (String)list.get(i);
                if (string4 == null) {
                    string4 = "";
                }
                String string5 = string2 != null && string2.length() > 0 ? string + "  " + string4 : "    " + string4;
                JMenuItem jMenuItem = new JMenuItem(string5);
                if (string3 != null && string.length() == 1) {
                    jMenuItem.setMnemonic(this.buildMnemonic(string.charAt(0)));
                }
                if (n == i) {
                    jMenuItem.setEnabled(false);
                }
                jMenu.add(jMenuItem);
                arrayList.add(jMenuItem);
            }
            this.viewerController.setWindowListMenuItems(arrayList);
        }
    }

    protected void shortenDocumentOrigins(List<Object> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            int n;
            int n2;
            int n3;
            int n4;
            String string = (String)list.get(i);
            if (string == null || (n4 = Math.max(n3 = string.lastIndexOf(File.separator), Math.max(n2 = string.lastIndexOf("/"), n = string.lastIndexOf("\\")))) < 0) continue;
            string = string.substring(n4);
            list.set(i, string);
        }
    }

    public JMenu buildHelpMenu() {
        JMenu jMenu = new JMenu(this.messageBundle.getString("viewer.menu.help.label"));
        jMenu.setMnemonic(this.buildMnemonic(this.messageBundle.getString("viewer.menu.help.mnemonic").charAt(0)));
        if (!isMacOs) {
            this.addToMenu(jMenu, this.buildAboutMenuItem());
        }
        return jMenu;
    }

    public JMenuItem buildAboutMenuItem() {
        JMenuItem jMenuItem = SwingViewBuilder.makeMenuItem(this.messageBundle.getString("viewer.menu.help.about.label"), null);
        if (this.viewerController != null) {
            this.viewerController.setAboutMenuItem(jMenuItem);
        }
        return jMenuItem;
    }

    @Override
    public JToolBar buildCompleteToolBar(boolean bl) {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setLayout(new ToolbarLayout(0, 0, 0));
        this.commonToolBarSetup(jToolBar, true);
        SwingViewBuilder.doubleCheckPropertiesManager();
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.show.utility")) {
            this.addToToolBar(jToolBar, this.buildUtilityToolBar(bl, propertiesManager));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.show.pagenav")) {
            this.addToToolBar(jToolBar, this.buildPageNavigationToolBar());
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.show.zoom")) {
            this.addToToolBar(jToolBar, this.buildZoomToolBar());
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.show.fullscreen")) {
            this.addToToolBar(jToolBar, this.buildFullScreenToolBar());
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.show.fit")) {
            this.addToToolBar(jToolBar, this.buildFitToolBar());
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.show.rotate")) {
            this.addToToolBar(jToolBar, this.buildRotateToolBar());
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.show.tool")) {
            this.addToToolBar(jToolBar, this.buildToolToolBar());
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.show.annotation")) {
            this.addToToolBar(jToolBar, this.buildAnnotationlToolBar());
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.show.forms")) {
            this.addToToolBar(jToolBar, this.buildFormsToolBar());
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.show.search")) {
            this.addToToolBar(jToolBar, this.buildQuickSearchToolBar());
        }
        if (jToolBar.getComponentCount() == 0) {
            jToolBar = null;
        }
        if (this.viewerController != null && jToolBar != null) {
            this.viewerController.setCompleteToolBar(jToolBar);
        }
        return jToolBar;
    }

    public JToolBar buildUtilityToolBar(boolean bl) {
        return this.buildUtilityToolBar(bl, null);
    }

    public JToolBar buildUtilityToolBar(boolean bl, ViewerPropertiesManager viewerPropertiesManager) {
        JToolBar jToolBar = new JToolBar();
        this.commonToolBarSetup(jToolBar, false);
        if (!bl && viewerPropertiesManager.checkAndStoreBooleanProperty("application.toolbar.show.utility.open")) {
            this.addToToolBar(jToolBar, this.buildOpenFileButton());
        }
        if (viewerPropertiesManager.checkAndStoreBooleanProperty("application.toolbar.show.utility.save")) {
            this.addToToolBar(jToolBar, this.buildSaveFileButton());
        }
        if (viewerPropertiesManager.checkAndStoreBooleanProperty("application.toolbar.show.utility.print")) {
            this.addToToolBar(jToolBar, this.buildPrintButton());
        }
        if (viewerPropertiesManager.checkAndStoreBooleanProperty("application.toolbar.show.utility.search")) {
            this.addToToolBar(jToolBar, this.buildSearchButton());
        }
        if (viewerPropertiesManager.checkAndStoreBooleanProperty("application.toolbar.show.utility.upane")) {
            this.addToToolBar(jToolBar, this.buildShowHideUtilityPaneButton());
        }
        if (jToolBar.getComponentCount() == 0) {
            return null;
        }
        return jToolBar;
    }

    public JButton buildOpenFileButton() {
        JButton jButton = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.open.label"), this.messageBundle.getString("viewer.toolbar.open.tooltip"), "open", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jButton != null) {
            this.viewerController.setOpenFileButton(jButton);
        }
        return jButton;
    }

    public JButton buildSaveFileButton() {
        JButton jButton = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.save.label"), this.messageBundle.getString("viewer.toolbar.save.tooltip"), "save", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jButton != null) {
            this.viewerController.setSaveFileButton(jButton);
        }
        return jButton;
    }

    public JButton buildPrintButton() {
        JButton jButton = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.print.label"), this.messageBundle.getString("viewer.toolbar.print.tooltip"), "print", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jButton != null) {
            this.viewerController.setPrintButton(jButton);
        }
        return jButton;
    }

    public JButton buildSearchButton() {
        JButton jButton = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.search.label"), this.messageBundle.getString("viewer.toolbar.search.tooltip"), "search", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jButton != null) {
            this.viewerController.setSearchButton(jButton);
        }
        return jButton;
    }

    public JButton buildAnnotationPreviewButton(String string) {
        JButton jButton = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.tool.annotationPreview.label"), this.messageBundle.getString("viewer.toolbar.tool.annotationPreview.tooltip"), "annot_preview", string, this.buttonFont);
        if (this.viewerController != null && jButton != null) {
            this.viewerController.setAnnotationSummaryButton(jButton);
        }
        return jButton;
    }

    public JButton buildShowAnnotationUtilityButton(String string) {
        JButton jButton = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.tool.annotationUtility.label"), this.messageBundle.getString("viewer.toolbar.tool.annotationUtility.tooltip"), "utility_annotations", string, this.buttonFont);
        if (this.viewerController != null && jButton != null) {
            this.viewerController.setShowAnnotationUtilityPaneButton(jButton);
        }
        return jButton;
    }

    public JButton buildShowBookmarkUtilityButton(String string) {
        JButton jButton = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.tool.bookmarkUtility.label"), this.messageBundle.getString("viewer.toolbar.tool.bookmarkUtility.tooltip"), "utility_bookmarks", string, this.buttonFont);
        if (this.viewerController != null && jButton != null) {
            this.viewerController.setShowBookmarkUtilityPaneButton(jButton);
        }
        return jButton;
    }

    public JToggleButton buildShowHideUtilityPaneButton() {
        JToggleButton jToggleButton = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.utilityPane.label"), this.messageBundle.getString("viewer.toolbar.utilityPane.tooltip"), "utility_pane", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setShowHideUtilityPaneButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToolBar buildPageNavigationToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.commonToolBarSetup(jToolBar, false);
        this.addToToolBar(jToolBar, this.buildFirstPageButton());
        this.addToToolBar(jToolBar, this.buildPreviousPageButton());
        this.addToToolBar(jToolBar, this.buildCurrentPageNumberTextField());
        this.addToToolBar(jToolBar, this.buildNumberOfPagesLabel());
        this.addToToolBar(jToolBar, this.buildNextPageButton());
        this.addToToolBar(jToolBar, this.buildLastPageButton());
        return jToolBar;
    }

    public JButton buildFirstPageButton() {
        JButton jButton = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.navigation.firstPage.label"), this.messageBundle.getString("viewer.toolbar.navigation.firstPage.tooltip"), "first", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jButton != null) {
            this.viewerController.setFirstPageButton(jButton);
        }
        return jButton;
    }

    public JButton buildPreviousPageButton() {
        JButton jButton = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.navigation.previousPage.label"), this.messageBundle.getString("viewer.toolbar.navigation.previousPage.tooltip"), "back", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jButton != null) {
            this.viewerController.setPreviousPageButton(jButton);
        }
        return jButton;
    }

    public JButton buildNextPageButton() {
        JButton jButton = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.navigation.nextPage.label"), this.messageBundle.getString("viewer.toolbar.navigation.nextPage.tooltip"), "forward", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jButton != null) {
            this.viewerController.setNextPageButton(jButton);
        }
        return jButton;
    }

    public JButton buildLastPageButton() {
        JButton jButton = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.navigation.lastPage.label"), this.messageBundle.getString("viewer.toolbar.navigation.lastPage.tooltip"), "last", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jButton != null) {
            this.viewerController.setLastPageButton(jButton);
        }
        return jButton;
    }

    public JTextField buildCurrentPageNumberTextField() {
        JTextField jTextField = new JTextField("", 3);
        jTextField.setToolTipText(this.messageBundle.getString("viewer.toolbar.navigation.current.tooltip"));
        jTextField.setInputVerifier(new PageNumberTextFieldInputVerifier());
        jTextField.addKeyListener(new PageNumberTextFieldKeyListener());
        if (this.viewerController != null) {
            this.viewerController.setCurrentPageNumberTextField(jTextField);
        }
        return jTextField;
    }

    public JLabel buildNumberOfPagesLabel() {
        JLabel jLabel = new JLabel();
        jLabel.setToolTipText(this.messageBundle.getString("viewer.toolbar.navigation.pages.tooltip"));
        if (this.viewerController != null) {
            this.viewerController.setNumberOfPagesLabel(jLabel);
        }
        return jLabel;
    }

    public JToolBar buildZoomToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.commonToolBarSetup(jToolBar, false);
        this.addToToolBar(jToolBar, this.buildZoomOutButton());
        this.addToToolBar(jToolBar, this.buildZoomCombBox());
        this.addToToolBar(jToolBar, this.buildZoomInButton());
        return jToolBar;
    }

    public JButton buildZoomOutButton() {
        JButton jButton = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.zoom.out.label"), this.messageBundle.getString("viewer.toolbar.zoom.out.tooltip"), "zoom_out", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jButton != null) {
            this.viewerController.setZoomOutButton(jButton);
        }
        return jButton;
    }

    public JComboBox buildZoomCombBox() {
        SwingViewBuilder.doubleCheckPropertiesManager();
        this.zoomLevels = ViewerPropertiesManager.getInstance().checkAndStoreFloatArrayProperty("application.zoom.range.default", this.zoomLevels);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setToolTipText(this.messageBundle.getString("viewer.toolbar.zoom.tooltip"));
        jComboBox.setPreferredSize(new Dimension(90, this.iconSize.equals("_32") ? 32 : 24));
        for (float f : this.zoomLevels) {
            jComboBox.addItem(NumberFormat.getPercentInstance().format(f));
        }
        jComboBox.setEditable(true);
        if (this.viewerController != null) {
            this.viewerController.setZoomComboBox(jComboBox, this.zoomLevels);
        }
        return jComboBox;
    }

    public JButton buildZoomInButton() {
        JButton jButton = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.zoom.in.label"), this.messageBundle.getString("viewer.toolbar.zoom.in.tooltip"), "zoom_in", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jButton != null) {
            this.viewerController.setZoomInButton(jButton);
        }
        return jButton;
    }

    public JComboBox buildAnnotationPermissionCombBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setToolTipText(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.view.publicToggleButton.tooltip.label"));
        jComboBox.setPreferredSize(new Dimension(65, this.iconSize.equals("_32") ? 32 : 24));
        jComboBox.addItem(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.view.publicToggleButton.label"));
        jComboBox.addItem(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.view.privateToggleButton.label"));
        jComboBox.setEditable(true);
        if (this.viewerController != null) {
            this.viewerController.setAnnotationPermissionComboBox(jComboBox);
        }
        return jComboBox;
    }

    public JToolBar buildFitToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.commonToolBarSetup(jToolBar, false);
        this.addToToolBar(jToolBar, this.buildFitActualSizeButton());
        this.addToToolBar(jToolBar, this.buildFitPageButton());
        this.addToToolBar(jToolBar, this.buildFitWidthButton());
        return jToolBar;
    }

    public JToolBar buildFullScreenToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.commonToolBarSetup(jToolBar, false);
        this.addToToolBar(jToolBar, this.buildFullScreenButton());
        return jToolBar;
    }

    public JToggleButton buildFitActualSizeButton() {
        JToggleButton jToggleButton = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.pageFit.actualsize.label"), this.messageBundle.getString("viewer.toolbar.pageFit.actualsize.tooltip"), "actual_size", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setFitActualSizeButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildFitPageButton() {
        JToggleButton jToggleButton = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.pageFit.fitWindow.label"), this.messageBundle.getString("viewer.toolbar.pageFit.fitWindow.tooltip"), "fit_window", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setFitHeightButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildFitWidthButton() {
        JToggleButton jToggleButton = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.pageFit.fitWidth.label"), this.messageBundle.getString("viewer.toolbar.pageFit.fitWidth.tooltip"), "fit_width", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setFitWidthButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JButton buildFullScreenButton() {
        JButton jButton = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.pageFit.fullscreen.label"), this.messageBundle.getString("viewer.toolbar.pageFit.fullscreen.tooltip"), "fullscreen", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jButton != null) {
            this.viewerController.setFullScreenButton(jButton);
        }
        return jButton;
    }

    public JToolBar buildRotateToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.commonToolBarSetup(jToolBar, false);
        this.addToToolBar(jToolBar, this.buildRotateRightButton());
        this.addToToolBar(jToolBar, this.buildRotateLeftButton());
        return jToolBar;
    }

    public JButton buildRotateLeftButton() {
        JButton jButton = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.rotation.left.label"), this.messageBundle.getString("viewer.toolbar.rotation.left.tooltip"), "rotate_left", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jButton != null) {
            this.viewerController.setRotateLeftButton(jButton);
        }
        return jButton;
    }

    public JButton buildRotateRightButton() {
        JButton jButton = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.rotation.right.label"), this.messageBundle.getString("viewer.toolbar.rotation.right.tooltip"), "rotate_right", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jButton != null) {
            this.viewerController.setRotateRightButton(jButton);
        }
        return jButton;
    }

    public JToolBar buildToolToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.commonToolBarSetup(jToolBar, false);
        this.addToToolBar(jToolBar, this.buildPanToolButton());
        this.addToToolBar(jToolBar, this.buildTextSelectToolButton());
        this.addToToolBar(jToolBar, this.buildZoomInToolButton());
        this.addToToolBar(jToolBar, this.buildZoomOutToolButton());
        return jToolBar;
    }

    public JToolBar buildAnnotationlToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.commonToolBarSetup(jToolBar, false);
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.annotation.selection.enabled")) {
            this.addToToolBar(jToolBar, this.buildSelectToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.annotation.highlight.enabled")) {
            this.addToToolBar(jToolBar, this.buildHighlightAnnotationToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.annotation.underline.enabled")) {
            this.addToToolBar(jToolBar, this.buildUnderlineAnnotationToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.annotation.strikeout.enabled")) {
            this.addToToolBar(jToolBar, this.buildStrikeOutAnnotationToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.annotation.line.enabled")) {
            this.addToToolBar(jToolBar, this.buildLineAnnotationToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.annotation.link.enabled")) {
            this.addToToolBar(jToolBar, this.buildLinkAnnotationToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.annotation.arrow.enabled")) {
            this.addToToolBar(jToolBar, this.buildLineArrowAnnotationToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.annotation.rectangle.enabled")) {
            this.addToToolBar(jToolBar, this.buildSquareAnnotationToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.annotation.circle.enabled")) {
            this.addToToolBar(jToolBar, this.buildCircleAnnotationToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.annotation.ink.enabled")) {
            this.addToToolBar(jToolBar, this.buildInkAnnotationToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.annotation.freetext.enabled")) {
            this.addToToolBar(jToolBar, this.buildFreeTextAnnotationToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.annotation.text.enabled")) {
            this.addToToolBar(jToolBar, this.buildTextAnnotationToolButton(this.iconSize));
        }
        if (SystemProperties.PRIVATE_PROPERTY_ENABLED && propertiesManager.checkAndStoreBooleanProperty("application.toolbar.annotation.permission.enabled")) {
            this.addToToolBar(jToolBar, this.buildAnnotationPermissionCombBox());
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.annotation.toolbar.enabled")) {
            this.addToToolBar(jToolBar, this.buildShowAnnotationUtilityButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.bookmark.toolbar.enabled")) {
            this.addToToolBar(jToolBar, this.buildShowBookmarkUtilityButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.toolbar.annotation.preview.enabled")) {
            this.addToToolBar(jToolBar, this.buildAnnotationPreviewButton(this.iconSize));
        }
        return jToolBar;
    }

    public JToolBar buildFormsToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.commonToolBarSetup(jToolBar, false);
        this.addToToolBar(jToolBar, this.buildFormHighlightButton(this.iconSize));
        return jToolBar;
    }

    public JToolBar buildQuickSearchToolBar() {
        SearchToolBar searchToolBar = new SearchToolBar(this.viewerController, this.messageBundle.getString("viewer.toolbar.tool.search.label"), this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.tool.search.previous.label"), this.messageBundle.getString("viewer.toolbar.tool.search.previous.tooltip"), "back", this.iconSize, this.buttonFont), this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.tool.search.next.label"), this.messageBundle.getString("viewer.toolbar.tool.search.next.tooltip"), "forward", this.iconSize, this.buttonFont));
        if (this.viewerController != null) {
            this.viewerController.setQuickSearchToolBar(searchToolBar);
        }
        return searchToolBar;
    }

    public JToolBar buildAnnotationPropertiesToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.commonToolBarSetup(jToolBar, true);
        if (propertiesManager.checkAndStoreBooleanProperty("application.annotation.properties.highlight.enabled")) {
            this.addToToolBar(jToolBar, this.buildHighlightAnnotationPropertiesToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.annotation.properties.strikeout.enabled")) {
            this.addToToolBar(jToolBar, this.buildStrikeOutAnnotationPropertiesToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.annotation.properties.underline.enabled")) {
            this.addToToolBar(jToolBar, this.buildUnderlineAnnotationPropertiesToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.annotation.properties.line.enabled")) {
            this.addToToolBar(jToolBar, this.buildLineAnnotationPropertiesToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.annotation.properties.arrow.enabled")) {
            this.addToToolBar(jToolBar, this.buildLineArrowAnnotationPropertiesToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.annotation.properties.rectangle.enabled")) {
            this.addToToolBar(jToolBar, this.buildSquareAnnotationPropertiesToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.annotation.properties.circle.enabled")) {
            this.addToToolBar(jToolBar, this.buildCircleAnnotationPropertiesToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.annotation.properties.ink.enabled")) {
            this.addToToolBar(jToolBar, this.buildInkAnnotationPropertiesToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.annotation.properties.freetext.enabled")) {
            this.addToToolBar(jToolBar, this.buildFreeTextAnnotationPropertiesToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.annotation.properties.text.enabled")) {
            this.addToToolBar(jToolBar, this.buildTextAnnotationPropertiesToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.annotation.properties.link.enabled")) {
            this.addToToolBar(jToolBar, this.buildLinkAnnotationPropertiesToolButton(this.iconSize));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.annotation.editing.mode.enabled")) {
            jToolBar.addSeparator();
            this.addToToolBar(jToolBar, this.buildAnnotationEditingModeToolButton(this.iconSize));
        }
        return jToolBar;
    }

    public JToggleButton buildPanToolButton() {
        JToggleButton jToggleButton = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.tool.pan.label"), this.messageBundle.getString("viewer.toolbar.tool.pan.tooltip"), "pan", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setPanToolButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildTextSelectToolButton() {
        JToggleButton jToggleButton = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.tool.text.label"), this.messageBundle.getString("viewer.toolbar.tool.text.tooltip"), "selection_text", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setTextSelectToolButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildSelectToolButton(String string) {
        JToggleButton jToggleButton = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.tool.select.label"), this.messageBundle.getString("viewer.toolbar.tool.select.tooltip"), "select", string, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setSelectToolButton(jToggleButton);
        }
        return jToggleButton;
    }

    public AbstractButton buildHighlightAnnotationToolButton(String string) {
        AnnotationColorToggleButton annotationColorToggleButton = this.makeAnnotationToggleButton(this.messageBundle.getString("viewer.toolbar.tool.highlight.label"), this.messageBundle.getString("viewer.toolbar.tool.highlight.tooltip"), "application.viewer.preference.annotation.highlight.color", "highlight_annot_c", string, this.buttonFont, 0.5f);
        if (this.viewerController != null) {
            this.viewerController.setHighlightAnnotationToolButton(annotationColorToggleButton);
        }
        return annotationColorToggleButton;
    }

    public AbstractButton buildStrikeOutAnnotationToolButton(String string) {
        AnnotationColorToggleButton annotationColorToggleButton = this.makeAnnotationToggleButton(this.messageBundle.getString("viewer.toolbar.tool.strikeOut.label"), this.messageBundle.getString("viewer.toolbar.tool.strikeOut.tooltip"), "application.viewer.preference.annotation.strikeout.color", "strikeout_c", string, this.buttonFont, 1.0f);
        if (this.viewerController != null) {
            this.viewerController.setStrikeOutAnnotationToolButton(annotationColorToggleButton);
        }
        return annotationColorToggleButton;
    }

    public AbstractButton buildUnderlineAnnotationToolButton(String string) {
        AnnotationColorToggleButton annotationColorToggleButton = this.makeAnnotationToggleButton(this.messageBundle.getString("viewer.toolbar.tool.underline.label"), this.messageBundle.getString("viewer.toolbar.tool.underline.tooltip"), "application.viewer.preference.annotation.underline.color", "underline_c", string, this.buttonFont, 1.0f);
        if (this.viewerController != null) {
            this.viewerController.setUnderlineAnnotationToolButton(annotationColorToggleButton);
        }
        return annotationColorToggleButton;
    }

    public AbstractButton buildLineAnnotationToolButton(String string) {
        AnnotationColorToggleButton annotationColorToggleButton = this.makeAnnotationToggleButton(this.messageBundle.getString("viewer.toolbar.tool.line.label"), this.messageBundle.getString("viewer.toolbar.tool.line.tooltip"), "application.viewer.preference.annotation.line.color", "line_c", string, this.buttonFont, 1.0f);
        if (this.viewerController != null) {
            this.viewerController.setLineAnnotationToolButton(annotationColorToggleButton);
        }
        return annotationColorToggleButton;
    }

    public JToggleButton buildLinkAnnotationToolButton(String string) {
        JToggleButton jToggleButton = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.tool.link.label"), this.messageBundle.getString("viewer.toolbar.tool.link.tooltip"), "link_annot", string, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setLinkAnnotationToolButton(jToggleButton);
        }
        return jToggleButton;
    }

    public AbstractButton buildLineArrowAnnotationToolButton(String string) {
        AnnotationColorToggleButton annotationColorToggleButton = this.makeAnnotationToggleButton(this.messageBundle.getString("viewer.toolbar.tool.lineArrow.label"), this.messageBundle.getString("viewer.toolbar.tool.lineArrow.tooltip"), "application.viewer.preference.annotation.arrow.color", "arrow_c", string, this.buttonFont, 1.0f);
        if (this.viewerController != null) {
            this.viewerController.setLineArrowAnnotationToolButton(annotationColorToggleButton);
        }
        return annotationColorToggleButton;
    }

    public AbstractButton buildSquareAnnotationToolButton(String string) {
        AnnotationColorToggleButton annotationColorToggleButton = this.makeAnnotationToggleButton(this.messageBundle.getString("viewer.toolbar.tool.rectangle.label"), this.messageBundle.getString("viewer.toolbar.tool.rectangle.tooltip"), "application.viewer.preference.annotation.square.color", "square_c", string, this.buttonFont, 1.0f);
        if (this.viewerController != null) {
            this.viewerController.setSquareAnnotationToolButton(annotationColorToggleButton);
        }
        return annotationColorToggleButton;
    }

    public AbstractButton buildCircleAnnotationToolButton(String string) {
        AnnotationColorToggleButton annotationColorToggleButton = this.makeAnnotationToggleButton(this.messageBundle.getString("viewer.toolbar.tool.circle.label"), this.messageBundle.getString("viewer.toolbar.tool.circle.tooltip"), "application.viewer.preference.annotation.circle.color", "circle_c", string, this.buttonFont, 1.0f);
        if (this.viewerController != null) {
            this.viewerController.setCircleAnnotationToolButton(annotationColorToggleButton);
        }
        return annotationColorToggleButton;
    }

    public AbstractButton buildInkAnnotationToolButton(String string) {
        AnnotationColorToggleButton annotationColorToggleButton = this.makeAnnotationToggleButton(this.messageBundle.getString("viewer.toolbar.tool.ink.label"), this.messageBundle.getString("viewer.toolbar.tool.ink.tooltip"), "application.viewer.preference.annotation.ink.color", "ink_c", string, this.buttonFont, 1.0f);
        if (this.viewerController != null) {
            this.viewerController.setInkAnnotationToolButton(annotationColorToggleButton);
        }
        return annotationColorToggleButton;
    }

    public JToggleButton buildFreeTextAnnotationToolButton(String string) {
        JToggleButton jToggleButton = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.tool.freeText.label"), this.messageBundle.getString("viewer.toolbar.tool.freeText.tooltip"), "freetext_annot", string, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setFreeTextAnnotationToolButton(jToggleButton);
        }
        return jToggleButton;
    }

    public AbstractButton buildTextAnnotationToolButton(String string) {
        AnnotationColorToggleButton annotationColorToggleButton = this.makeAnnotationToggleButton(this.messageBundle.getString("viewer.toolbar.tool.textAnno.label"), this.messageBundle.getString("viewer.toolbar.tool.textAnno.tooltip"), "application.viewer.preference.annotation.text.color", "text_annot_c", string, this.buttonFont, 0.5f);
        if (this.viewerController != null) {
            this.viewerController.setTextAnnotationToolButton(annotationColorToggleButton);
        }
        return annotationColorToggleButton;
    }

    public JToggleButton buildFormHighlightButton(String string) {
        JToggleButton jToggleButton = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.tool.forms.highlight.label"), this.messageBundle.getString("viewer.toolbar.tool.forms.highlight.tooltip"), "form_highlight", string, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setFormHighlightButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildLinkAnnotationPropertiesToolButton(String string) {
        JToggleButton jToggleButton = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.link.label"), this.messageBundle.getString("viewer.toolbar.tool.link.tooltip"), "link_annot", string, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setLinkAnnotationPropertiesToolButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildAnnotationEditingModeToolButton(String string) {
        JToggleButton jToggleButton = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.annotationEditingMode.label"), this.messageBundle.getString("viewer.toolbar.tool.annotationEditingMode.tooltip"), "annot_tools", string, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setAnnotationEditingModeToolButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildHighlightAnnotationPropertiesToolButton(String string) {
        JToggleButton jToggleButton = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.highlight.label"), this.messageBundle.getString("viewer.toolbar.tool.highlight.tooltip"), "highlight_annot", string, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setHighlightAnnotationPropertiesToolButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildStrikeOutAnnotationPropertiesToolButton(String string) {
        JToggleButton jToggleButton = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.strikeOut.label"), this.messageBundle.getString("viewer.toolbar.tool.strikeOut.tooltip"), "strikeout", string, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setStrikeOutAnnotationPropertiesToolButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildUnderlineAnnotationPropertiesToolButton(String string) {
        JToggleButton jToggleButton = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.underline.label"), this.messageBundle.getString("viewer.toolbar.tool.underline.tooltip"), "underline", string, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setUnderlineAnnotationPropertiesToolButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildLineAnnotationPropertiesToolButton(String string) {
        JToggleButton jToggleButton = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.line.label"), this.messageBundle.getString("viewer.toolbar.tool.line.tooltip"), "line", string, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setLineAnnotationPropertiesToolButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildLineArrowAnnotationPropertiesToolButton(String string) {
        JToggleButton jToggleButton = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.lineArrow.label"), this.messageBundle.getString("viewer.toolbar.tool.lineArrow.tooltip"), "arrow", string, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setLineArrowAnnotationPropertiesToolButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildSquareAnnotationPropertiesToolButton(String string) {
        JToggleButton jToggleButton = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.rectangle.label"), this.messageBundle.getString("viewer.toolbar.tool.rectangle.tooltip"), "square", string, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setSquareAnnotationPropertiesToolButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildCircleAnnotationPropertiesToolButton(String string) {
        JToggleButton jToggleButton = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.circle.label"), this.messageBundle.getString("viewer.toolbar.tool.circle.tooltip"), "circle", string, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setCircleAnnotationPropertiesToolButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildInkAnnotationPropertiesToolButton(String string) {
        JToggleButton jToggleButton = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.ink.label"), this.messageBundle.getString("viewer.toolbar.tool.ink.tooltip"), "ink", string, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setInkAnnotationPropertiesToolButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildFreeTextAnnotationPropertiesToolButton(String string) {
        JToggleButton jToggleButton = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.freeText.label"), this.messageBundle.getString("viewer.toolbar.tool.freeText.tooltip"), "freetext_annot", string, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setFreeTextAnnotationPropertiesToolButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildTextAnnotationPropertiesToolButton(String string) {
        JToggleButton jToggleButton = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.textAnno.label"), this.messageBundle.getString("viewer.toolbar.tool.textAnno.tooltip"), "text_annot", string, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setTextAnnotationPropertiesToolButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildZoomInToolButton() {
        JToggleButton jToggleButton = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.tool.zoomMarquis.label"), this.messageBundle.getString("viewer.toolbar.tool.zoomMarquis.tooltip"), "zoom_marquis", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setZoomInToolButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildZoomOutToolButton() {
        JToggleButton jToggleButton = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.tool.zoomDynamic.label"), this.messageBundle.getString("viewer.toolbar.tool.zoomDynamic.tooltip"), "zoom_dynamic", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setZoomDynamicToolButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JSplitPane buildUtilityAndDocumentSplitPane(boolean bl) {
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setDividerSize(8);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setLeftComponent(this.buildUtilityTabbedPane());
        DocumentViewController documentViewController = this.viewerController.getDocumentViewController();
        this.viewerController.setIsEmbeddedComponent(bl);
        jSplitPane.getActionMap().getParent().remove("toggleFocus");
        jSplitPane.setRightComponent(documentViewController.getViewContainer());
        int n = propertiesManager.getPreferences().getInt("application.divider.location", 260);
        jSplitPane.setDividerLocation(n);
        if (this.viewerController != null) {
            this.viewerController.setUtilityAndDocumentSplitPane(jSplitPane);
        }
        return jSplitPane;
    }

    public JTabbedPane buildUtilityTabbedPane() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setPreferredSize(new Dimension(250, 400));
        SwingViewBuilder.doubleCheckPropertiesManager();
        if (propertiesManager.checkAndStoreBooleanProperty("application.utilitypane.show.bookmarks")) {
            jTabbedPane.add(this.messageBundle.getString("viewer.utilityPane.bookmarks.tab.title"), this.buildOutlineComponents());
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.utilitypane.show.attachments")) {
            jTabbedPane.add(this.messageBundle.getString("viewer.utilityPane.attachments.tab.title"), this.buildAttachmentPanel());
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.utilitypane.show.search")) {
            jTabbedPane.add(this.messageBundle.getString("viewer.utilityPane.search.tab.title"), this.buildSearchPanel());
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.utilitypane.show.thumbs")) {
            jTabbedPane.add(this.messageBundle.getString("viewer.utilityPane.thumbs.tab.title"), this.buildThumbsPanel());
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.utilitypane.show.layers")) {
            jTabbedPane.add(this.messageBundle.getString("viewer.utilityPane.layers.tab.title"), this.buildLayersComponents());
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.utilitypane.show.signatures")) {
            jTabbedPane.add(this.messageBundle.getString("viewer.utilityPane.signatures.tab.title"), this.buildSignatureComponents());
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.utilitypane.show.annotation")) {
            jTabbedPane.add(this.messageBundle.getString("viewer.utilityPane.annotation.tab.title"), this.buildAnnotationPanel());
        }
        if (jTabbedPane.getComponentCount() == 0) {
            jTabbedPane = null;
        }
        if (this.viewerController != null) {
            this.viewerController.setUtilityTabbedPane(jTabbedPane);
        }
        return jTabbedPane;
    }

    public JComponent buildOutlineComponents() {
        OutlinesTree outlinesTree = new OutlinesTree();
        JScrollPane jScrollPane = new JScrollPane(outlinesTree);
        if (this.viewerController != null) {
            this.viewerController.setOutlineComponents(outlinesTree, jScrollPane);
        }
        return jScrollPane;
    }

    public ThumbnailsPanel buildThumbsPanel() {
        ThumbnailsPanel thumbnailsPanel = new ThumbnailsPanel(this.viewerController, propertiesManager);
        if (this.viewerController != null) {
            this.viewerController.setThumbnailsPanel(thumbnailsPanel);
        }
        return thumbnailsPanel;
    }

    public LayersPanel buildLayersComponents() {
        LayersPanel layersPanel = new LayersPanel(this.viewerController);
        if (this.viewerController != null) {
            this.viewerController.setLayersPanel(layersPanel);
        }
        return layersPanel;
    }

    public JComponent buildSignatureComponents() {
        SignaturesHandlerPanel signaturesHandlerPanel = new SignaturesHandlerPanel(this.viewerController);
        if (this.viewerController != null) {
            this.viewerController.setSignaturesPanel(signaturesHandlerPanel);
        }
        return signaturesHandlerPanel;
    }

    public SearchPanel buildSearchPanel() {
        SearchPanel searchPanel = new SearchPanel(this.viewerController);
        if (this.viewerController != null) {
            this.viewerController.setSearchPanel(searchPanel);
        }
        return searchPanel;
    }

    public AttachmentPanel buildAttachmentPanel() {
        AttachmentPanel attachmentPanel = new AttachmentPanel(this.viewerController);
        if (this.viewerController != null) {
            this.viewerController.setAttachmentPanel(attachmentPanel);
        }
        return attachmentPanel;
    }

    public AnnotationPanel buildAnnotationPanel() {
        JPanel jPanel;
        AnnotationPanel annotationPanel = new AnnotationPanel(this.viewerController);
        if (propertiesManager.checkAndStoreBooleanProperty("application.utilitypane.show.annotation.markup")) {
            jPanel = this.buildMarkupAnnotationPanel();
            annotationPanel.addMarkupAnnotationPanel((MarkupAnnotationPanel)jPanel, this.messageBundle.getString("viewer.utilityPane.markupAnnotation.title"));
        }
        if (propertiesManager.checkAndStoreBooleanProperty("application.utilitypane.show.annotation.dests")) {
            jPanel = this.buildDestinationsPanel();
            annotationPanel.addDestinationPanel((DestinationsPanel)jPanel, this.messageBundle.getString("viewer.utilityPane.destinations.title"));
        }
        if (this.viewerController != null) {
            this.viewerController.setAnnotationPanel(annotationPanel);
        }
        return annotationPanel;
    }

    public MarkupAnnotationPanel buildMarkupAnnotationPanel() {
        MarkupAnnotationPanel markupAnnotationPanel = new MarkupAnnotationPanel(this.viewerController);
        markupAnnotationPanel.setAnnotationUtilityToolbar(this.buildAnnotationPropertiesToolBar());
        return markupAnnotationPanel;
    }

    public DestinationsPanel buildDestinationsPanel() {
        return new DestinationsPanel(this.viewerController, propertiesManager);
    }

    public JPanel buildStatusPanel() {
        if (propertiesManager.checkAndStoreBooleanProperty("application.statusbar")) {
            JLabel jLabel;
            JPanel jPanel;
            JPanel jPanel2 = new JPanel(new BorderLayout());
            if (propertiesManager.checkAndStoreBooleanProperty("application.statusbar.show.statuslabel")) {
                jPanel = new JPanel();
                jLabel = new JLabel(" ");
                jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
                jPanel.add(jLabel);
                jPanel2.add((Component)jPanel, "West");
                if (this.viewerController != null) {
                    this.viewerController.setStatusLabel(jLabel);
                }
            }
            jPanel = new JPanel();
            if (propertiesManager.checkAndStoreBooleanProperty("application.statusbar.show.viewmode")) {
                if (propertiesManager.checkAndStoreBooleanProperty("application.statusbar.show.viewmode.singlepage")) {
                    jPanel.add(this.buildPageViewSinglePageNonConToggleButton());
                }
                if (propertiesManager.checkAndStoreBooleanProperty("application.statusbar.show.viewmode.single.page.continuous")) {
                    jPanel.add(this.buildPageViewSinglePageConToggleButton());
                }
                if (propertiesManager.checkAndStoreBooleanProperty("application.statusbar.show.viewmode.double.page")) {
                    jPanel.add(this.buildPageViewFacingPageNonConToggleButton());
                }
                if (propertiesManager.checkAndStoreBooleanProperty("application.statusbar.show.viewmode.double.page.continuous")) {
                    jPanel.add(this.buildPageViewFacingPageConToggleButton());
                }
            }
            jPanel2.add((Component)jPanel, "Center");
            jPanel.setLayout(new ToolbarLayout(2, 0, 1));
            jLabel = new JLabel(" ");
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            jPanel2.add((Component)jLabel, "East");
            return jPanel2;
        }
        return null;
    }

    public JToggleButton buildPageViewSinglePageConToggleButton() {
        JToggleButton jToggleButton = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.pageView.continuous.singlePage.label"), this.messageBundle.getString("viewer.toolbar.pageView.continuous.singlePage.tooltip"), "single_page_column", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setPageViewSinglePageConButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildPageViewFacingPageConToggleButton() {
        JToggleButton jToggleButton = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.pageView.continuous.facingPage.label"), this.messageBundle.getString("viewer.toolbar.pageView.continuous.facingPage.tooltip"), "two_page_column", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setPageViewFacingPageConButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildPageViewSinglePageNonConToggleButton() {
        JToggleButton jToggleButton = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.pageView.nonContinuous.singlePage.label"), this.messageBundle.getString("viewer.toolbar.pageView.nonContinuous.singlePage.tooltip"), "single_page", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setPageViewSinglePageNonConButton(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton buildPageViewFacingPageNonConToggleButton() {
        JToggleButton jToggleButton = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.pageView.nonContinuous.facingPage.label"), this.messageBundle.getString("viewer.toolbar.pageView.nonContinuous.facingPage.tooltip"), "two_page", this.iconSize, this.buttonFont);
        if (this.viewerController != null && jToggleButton != null) {
            this.viewerController.setPageViewFacingPageNonConButton(jToggleButton);
        }
        return jToggleButton;
    }

    protected JButton makeToolbarButton(String string, String string2, String string3, String string4, Font font) {
        JButton jButton = new JButton(this.showButtonText ? string : "");
        jButton.setFont(font);
        jButton.setToolTipText(string2);
        this.setPreferredButtonSize(jButton, string4);
        try {
            jButton.setIcon(new ImageIcon(Images.get(string3 + "_a" + string4 + ".png")));
            jButton.setPressedIcon(new ImageIcon(Images.get(string3 + "_i" + string4 + ".png")));
            jButton.setRolloverIcon(new ImageIcon(Images.get(string3 + "_r" + string4 + ".png")));
            jButton.setDisabledIcon(new ImageIcon(Images.get(string3 + "_i" + string4 + ".png")));
        }
        catch (NullPointerException nullPointerException) {
            logger.warning("Failed to load toolbar button images: " + string3 + "_i" + string4 + ".png");
        }
        jButton.setRolloverEnabled(true);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setFocusPainted(true);
        return jButton;
    }

    private void setPreferredButtonSize(Component component, String string) {
        if (this.iconSize.equals("_32")) {
            component.setPreferredSize(new Dimension(32, 32));
        } else if (this.iconSize.equals("_24")) {
            component.setPreferredSize(new Dimension(24, 24));
        }
    }

    protected AnnotationColorToggleButton makeAnnotationToggleButton(String string, String string2, String string3, String string4, String string5, Font font, float f) {
        return new IconAnnotationColorToggleButton(this.viewerController, this.messageBundle, string, string2, string3, string4, string5, font, f);
    }

    protected JToggleButton makeToolbarToggleButton(String string, String string2, String string3, String string4, Font font) {
        JToggleButton jToggleButton = new JToggleButton(this.showButtonText ? string : "");
        jToggleButton.setFont(font);
        jToggleButton.setToolTipText(string2);
        this.setPreferredButtonSize(jToggleButton, string4);
        jToggleButton.setRolloverEnabled(true);
        try {
            jToggleButton.setIcon(new ImageIcon(Images.get(string3 + "_a" + string4 + ".png")));
            jToggleButton.setPressedIcon(new ImageIcon(Images.get(string3 + "_i" + string4 + ".png")));
            jToggleButton.setRolloverIcon(new ImageIcon(Images.get(string3 + "_r" + string4 + ".png")));
            jToggleButton.setDisabledIcon(new ImageIcon(Images.get(string3 + "_i" + string4 + ".png")));
        }
        catch (NullPointerException nullPointerException) {
            logger.warning("Failed to load toolbar toggle button images: " + string3 + "_i" + string4 + ".png");
        }
        jToggleButton.setBorder(BorderFactory.createEmptyBorder());
        jToggleButton.setContentAreaFilled(false);
        jToggleButton.setFocusPainted(true);
        return jToggleButton;
    }

    protected JToggleButton makeToolbarToggleButtonSmall(String string, String string2, String string3, String string4, Font font) {
        JToggleButton jToggleButton = new JToggleButton(this.showButtonText ? string : "");
        jToggleButton.setFont(font);
        jToggleButton.setToolTipText(string2);
        this.setPreferredButtonSize(jToggleButton, string4);
        try {
            jToggleButton.setIcon(new ImageIcon(Images.get(string3 + "_a" + string4 + ".png")));
            jToggleButton.setPressedIcon(new ImageIcon(Images.get(string3 + "_i" + string4 + ".png")));
            jToggleButton.setRolloverIcon(new ImageIcon(Images.get(string3 + "_r" + string4 + ".png")));
            jToggleButton.setDisabledIcon(new ImageIcon(Images.get(string3 + "_i" + string4 + ".png")));
        }
        catch (NullPointerException nullPointerException) {
            logger.warning("Failed to load toolbar toggle images: " + string3 + "_i" + string4 + ".png");
        }
        jToggleButton.setBorder(BorderFactory.createEmptyBorder());
        jToggleButton.setContentAreaFilled(false);
        jToggleButton.setRolloverEnabled(true);
        jToggleButton.setFocusPainted(true);
        return jToggleButton;
    }

    protected JToggleButton makeToolbarToggleButton(String string, String string2, Font font) {
        JToggleButton jToggleButton = new JToggleButton(this.showButtonText ? string : "");
        jToggleButton.setFont(font);
        jToggleButton.setToolTipText(string2);
        this.setPreferredButtonSize(jToggleButton, this.iconSize);
        jToggleButton.setText(string);
        jToggleButton.setFocusPainted(true);
        return jToggleButton;
    }

    protected JToggleButton makeToolbarToggleButton(String string, String string2, String string3, int n, int n2, Font font) {
        JToggleButton jToggleButton = new JToggleButton(this.showButtonText ? string : "");
        jToggleButton.setFont(font);
        jToggleButton.setToolTipText(string2);
        jToggleButton.setRolloverEnabled(false);
        this.setPreferredButtonSize(jToggleButton, this.iconSize);
        try {
            jToggleButton.setIcon(new ImageIcon(Images.get(string3 + "_d.png")));
            jToggleButton.setPressedIcon(new ImageIcon(Images.get(string3 + "_d.png")));
            jToggleButton.setSelectedIcon(new ImageIcon(Images.get(string3 + "_n.png")));
            jToggleButton.setDisabledIcon(new ImageIcon(Images.get(string3 + "_n.png")));
        }
        catch (NullPointerException nullPointerException) {
            logger.warning("Failed to load toobar toggle button images: " + string3 + ".png");
        }
        jToggleButton.setBorderPainted(false);
        jToggleButton.setBorder(BorderFactory.createEmptyBorder());
        jToggleButton.setContentAreaFilled(false);
        jToggleButton.setFocusPainted(false);
        jToggleButton.setPreferredSize(new Dimension(n, n2));
        return jToggleButton;
    }

    protected static JMenuItem makeMenuItem(String string, KeyStroke keyStroke) {
        JMenuItem jMenuItem = new JMenuItem(string);
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        return jMenuItem;
    }

    protected JMenuItem makeMenuItem(String string, String string2, String string3, KeyStroke keyStroke) {
        JMenuItem jMenuItem = new JMenuItem(string);
        if (string2 != null) {
            try {
                jMenuItem.setIcon(new ImageIcon(Images.get(string2 + "_a" + string3 + ".png")));
                jMenuItem.setDisabledIcon(new ImageIcon(Images.get(string2 + "_i" + string3 + ".png")));
                jMenuItem.setRolloverIcon(new ImageIcon(Images.get(string2 + "_r" + string3 + ".png")));
            }
            catch (NullPointerException nullPointerException) {
                logger.warning("Failed to load menu images: " + string2 + "_a" + string3 + ".png");
            }
        } else {
            jMenuItem.setIcon(new ImageIcon(Images.get("menu_spacer.gif")));
            jMenuItem.setDisabledIcon(new ImageIcon(Images.get("menu_spacer.gif")));
            jMenuItem.setRolloverIcon(new ImageIcon(Images.get("menu_spacer.gif")));
        }
        jMenuItem.setBorder(BorderFactory.createEmptyBorder());
        jMenuItem.setContentAreaFilled(false);
        jMenuItem.setFocusPainted(true);
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        return jMenuItem;
    }

    protected void commonToolBarSetup(JToolBar jToolBar, boolean bl) {
        if (!bl) {
            jToolBar.requestFocus();
            jToolBar.setRollover(true);
        }
        if (this.toolbarStyle == 2) {
            jToolBar.setFloatable(false);
            if (!bl) {
                if (this.haveMadeAToolBar) {
                    jToolBar.addSeparator();
                }
                this.haveMadeAToolBar = true;
            }
        }
    }

    protected static void doubleCheckPropertiesManager() {
        if (propertiesManager == null) {
            propertiesManager = ViewerPropertiesManager.getInstance();
        }
    }

    protected void overrideHighlightColor(ViewerPropertiesManager viewerPropertiesManager) {
        Preferences preferences = viewerPropertiesManager.getPreferences();
        Page.highlightColor = new Color(preferences.getInt("org.icepdf.core.views.page.text.highlight.color", Page.highlightColor.getRGB()));
        Page.selectionColor = new Color(preferences.getInt("org.icepdf.core.views.page.text.selection.color", Page.selectionColor.getRGB()));
        PageViewDecorator.pageShadowColor = new Color(preferences.getInt("org.icepdf.core.views.page.shadow.color", PageViewDecorator.pageShadowColor.getRGB()));
        PageViewDecorator.pageColor = new Color(preferences.getInt("org.icepdf.core.views.page.paper.color", PageViewDecorator.pageColor.getRGB()));
        PageViewDecorator.pageBorderColor = new Color(preferences.getInt("org.icepdf.core.views.background.color", PageViewDecorator.pageBorderColor.getRGB()));
        AbstractDocumentView.backgroundColour = new Color(preferences.getInt("org.icepdf.core.views.background.color", AbstractDocumentView.backgroundColour.getRGB()));
        ImageReferenceFactory.imageReferenceType = ImageReferenceFactory.getImageReferenceType((String)preferences.get("org.icepdf.core.imageReference", "default"));
        Library.commonPoolThreads = preferences.getInt("org.icepdf.core.library.threadPoolSize", Library.commonPoolThreads);
        Library.imagePoolThreads = preferences.getInt("org.icepdf.core.library.imageThreadPoolSize", Library.imagePoolThreads);
        ImageReference.useProxy = preferences.getBoolean("org.icepdf.core.imageProxy", ImageReference.useProxy);
    }

    public static Font buildButtonFont() {
        return new Font("Helvetica", 0, 9);
    }

    protected void addToToolBar(JToolBar jToolBar, JComponent jComponent) {
        if (jComponent != null) {
            jToolBar.add(jComponent);
        }
    }

    protected void addToMenu(JMenu jMenu, JMenuItem jMenuItem) {
        if (jMenuItem != null) {
            jMenu.add(jMenuItem);
        }
    }

    protected void addToMenuBar(JMenuBar jMenuBar, JMenu jMenu) {
        if (jMenu != null) {
            jMenuBar.add(jMenu);
        }
    }

    static {
        isMacOs = SystemProperties.OS_NAME.contains("OS X");
    }
}

