/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import org.icepdf.core.pobjects.LiteralStringObject;
import org.icepdf.core.pobjects.NameNode;
import org.icepdf.core.pobjects.StringObject;

public class NameTreeNode
extends DefaultMutableTreeNode {
    private NameNode item;
    private StringObject name;
    private Object value;
    private ResourceBundle messageBundle;
    private MessageFormat formatter;
    private boolean rootNode;
    private boolean intermediateNode;
    private boolean leaf;
    private boolean loadedChildren;

    public NameTreeNode(NameNode nameNode, ResourceBundle resourceBundle) {
        this.item = nameNode;
        this.messageBundle = resourceBundle;
        if (!nameNode.hasLimits()) {
            this.rootNode = true;
            this.setUserObject(resourceBundle.getString("viewer.utilityPane.action.dialog.goto.nameTree.root.label"));
        } else {
            this.intermediateNode = true;
            Object[] objectArray = new Object[]{nameNode.getLowerLimit(), nameNode.getUpperLimit()};
            if (this.formatter == null) {
                this.formatter = new MessageFormat(resourceBundle.getString("viewer.utilityPane.action.dialog.goto.nameTree.branch.label"));
            }
            this.setUserObject(this.formatter.format(objectArray));
        }
    }

    public NameTreeNode(StringObject stringObject, Object object) {
        this.leaf = true;
        this.name = stringObject;
        this.value = object;
        this.setUserObject(stringObject);
    }

    public NameTreeNode(StringObject stringObject, Object object, Pattern pattern, boolean bl) {
        this.leaf = true;
        this.name = stringObject;
        this.value = object;
        this.setUserObject(this.applyMessage(stringObject.toString(), pattern, bl));
    }

    private String applyMessage(String string, Pattern pattern, boolean bl) {
        Matcher matcher = pattern.matcher(bl ? string : string.toLowerCase());
        StringBuilder stringBuilder = new StringBuilder("<html>");
        int n = 0;
        while (matcher.find()) {
            int n2 = matcher.start();
            int n3 = matcher.end();
            stringBuilder.append(string, n, n2);
            stringBuilder.append("<b>");
            stringBuilder.append(string, n2, n3);
            stringBuilder.append("</b>");
            n = n3;
        }
        if (n < string.length()) {
            stringBuilder.append(string.substring(n));
        }
        return stringBuilder.toString();
    }

    public StringObject getName() {
        return this.name;
    }

    public Object getReference() {
        return this.value;
    }

    public boolean isRootNode() {
        return this.rootNode;
    }

    @Override
    public boolean isLeaf() {
        return this.leaf;
    }

    public void setRootNode(boolean bl) {
        this.rootNode = bl;
    }

    @Override
    public int getChildCount() {
        this.ensureChildrenLoaded();
        return super.getChildCount();
    }

    public Enumeration children() {
        this.ensureChildrenLoaded();
        return super.children();
    }

    private void ensureChildrenLoaded() {
        if (!this.loadedChildren && (this.intermediateNode || this.rootNode)) {
            Object object;
            this.loadedChildren = true;
            if (this.item.getKidsReferences() != null) {
                int n = this.item.getKidsReferences().size();
                for (int i = 0; i < n; ++i) {
                    object = this.item.getNode(i);
                    NameTreeNode nameTreeNode = new NameTreeNode((NameNode)object, this.messageBundle);
                    this.add(nameTreeNode);
                }
            }
            if (this.item.getNamesAndValues() != null) {
                List list = this.item.getNamesAndValues();
                int n = list.size();
                for (int i = 0; i < n; i += 2) {
                    Object e = list.get(i);
                    Object object2 = e instanceof StringObject ? (StringObject)e : new LiteralStringObject((String)list.get(i));
                    object = list.get(i + 1);
                    this.add(new NameTreeNode((StringObject)object2, object));
                }
            }
        }
    }
}

