/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.actions.Action;
import org.icepdf.core.pobjects.actions.GoToAction;
import org.icepdf.core.pobjects.actions.GoToRAction;
import org.icepdf.core.pobjects.actions.JavaScriptAction;
import org.icepdf.core.pobjects.actions.LaunchAction;
import org.icepdf.core.pobjects.actions.NamedAction;
import org.icepdf.core.pobjects.actions.ResetFormAction;
import org.icepdf.core.pobjects.actions.SubmitFormAction;
import org.icepdf.core.pobjects.actions.URIAction;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.PageViewComponent;
import org.icepdf.ri.common.views.PageViewComponentImpl;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;
import org.icepdf.ri.util.BareBonesBrowserLaunch;

public class MyAnnotationCallback
implements AnnotationCallback {
    private static final Logger logger = Logger.getLogger(MyAnnotationCallback.class.toString());
    private final DocumentViewController documentViewController;

    public MyAnnotationCallback(DocumentViewController documentViewController) {
        this.documentViewController = documentViewController;
    }

    @Override
    public void processAnnotationAction(Annotation annotation, Action action, int n, int n2) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Annotation " + annotation.toString());
            if (annotation.getAction() != null) {
                logger.fine("   Action: " + annotation.getAction().toString());
            }
        }
        if (annotation instanceof LinkAnnotation) {
            LinkAnnotation linkAnnotation = (LinkAnnotation)annotation;
            if (action != null) {
                if (action instanceof GoToAction && this.documentViewController != null) {
                    this.documentViewController.setDestinationTarget(((GoToAction)action).getDestination());
                } else if (action instanceof URIAction) {
                    BareBonesBrowserLaunch.openURL(((URIAction)action).getURI());
                } else if (!(action instanceof GoToRAction) && action instanceof LaunchAction) {
                    LaunchAction launchAction = (LaunchAction)action;
                    String string = launchAction.getExternalFile();
                    String string2 = this.documentViewController.getDocument().getDocumentLocation();
                    string2 = string2.substring(0, string2.lastIndexOf(File.separator) + 1);
                    BareBonesBrowserLaunch.openFile(string2 + string);
                }
            } else if (linkAnnotation.getDestination() != null && this.documentViewController != null) {
                this.documentViewController.setDestinationTarget(linkAnnotation.getDestination());
            }
        } else if (action != null) {
            if (action instanceof GoToAction) {
                this.documentViewController.setDestinationTarget(((GoToAction)action).getDestination());
            } else if (action instanceof URIAction) {
                BareBonesBrowserLaunch.openURL(((URIAction)action).getURI());
            } else if (action instanceof SubmitFormAction) {
                int n3 = ((SubmitFormAction)action).executeFormAction(n, n2);
            } else if (action instanceof ResetFormAction) {
                int n4 = ((ResetFormAction)action).executeFormAction(n, n2);
            } else if (action instanceof JavaScriptAction) {
                JavaScriptAction javaScriptAction = (JavaScriptAction)action;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Annotation JS: " + javaScriptAction.getJavaScript());
                }
            } else if (action instanceof NamedAction) {
                NamedAction namedAction = (NamedAction)action;
                Name name = namedAction.getNamedAction();
                if (NamedAction.FIRST_PAGE_KEY.equals(name)) {
                    this.documentViewController.setCurrentPageIndex(0);
                } else if (NamedAction.LAST_PAGE_KEY.equals(name)) {
                    int n5 = this.documentViewController.getDocument().getNumberOfPages();
                    this.documentViewController.setCurrentPageIndex(n5 - 1);
                } else if (NamedAction.NEXT_PAGE_KEY.equals(name)) {
                    int n6 = this.documentViewController.getCurrentPageIndex();
                    this.documentViewController.setCurrentPageIndex(n6 + 1);
                } else if (NamedAction.PREV_PAGE_KEY.equals(name)) {
                    int n7 = this.documentViewController.getCurrentPageIndex();
                    this.documentViewController.setCurrentPageIndex(n7 - 1);
                } else if (NamedAction.PRINT_KEY.equals(name)) {
                    Controller controller = this.documentViewController.getParentController();
                    controller.print(true);
                } else if (NamedAction.SAVE_AS_KEY.equals(name)) {
                    Controller controller = this.documentViewController.getParentController();
                    controller.saveFileAs();
                }
            }
        }
    }

    @Override
    public void pageAnnotationsInitialized(Page page) {
    }

    @Override
    public void newAnnotation(PageViewComponent pageViewComponent, AnnotationComponent annotationComponent) {
        Document document = this.documentViewController.getDocument();
        PageTree pageTree = document.getPageTree();
        Page page = pageTree.getPage(pageViewComponent.getPageIndex());
        page.addAnnotation(annotationComponent.getAnnotation(), !annotationComponent.isSynthetic());
        ((PageViewComponentImpl)pageViewComponent).addAnnotation(annotationComponent);
    }

    @Override
    public void updateAnnotation(AnnotationComponent annotationComponent) {
        Document document = this.documentViewController.getDocument();
        PageTree pageTree = document.getPageTree();
        Page page = pageTree.getPage(annotationComponent.getPageIndex());
        page.updateAnnotation(annotationComponent.getAnnotation());
    }

    @Override
    public void removeAnnotation(PageViewComponent pageViewComponent, AnnotationComponent annotationComponent) {
        MarkupAnnotation markupAnnotation;
        Document document = this.documentViewController.getDocument();
        PageTree pageTree = document.getPageTree();
        Page page = pageTree.getPage(pageViewComponent.getPageIndex());
        page.deleteAnnotation(annotationComponent.getAnnotation());
        ((PageViewComponentImpl)pageViewComponent).removeAnnotation(annotationComponent);
        if (annotationComponent.getAnnotation() instanceof MarkupAnnotation && (markupAnnotation = (MarkupAnnotation)annotationComponent.getAnnotation()).getPopupAnnotation() != null) {
            page.deleteAnnotation((Annotation)markupAnnotation.getPopupAnnotation());
            ArrayList<AbstractAnnotationComponent> arrayList = ((PageViewComponentImpl)pageViewComponent).getAnnotationComponents();
            Reference reference = markupAnnotation.getPopupAnnotation().getPObjectReference();
            for (AbstractAnnotationComponent abstractAnnotationComponent : arrayList) {
                Reference reference2 = abstractAnnotationComponent.getAnnotation().getPObjectReference();
                if (reference2 == null || !reference2.equals((Object)reference) || !(abstractAnnotationComponent instanceof PopupAnnotationComponent)) continue;
                PopupAnnotationComponent popupAnnotationComponent = (PopupAnnotationComponent)abstractAnnotationComponent;
                ((PageViewComponentImpl)pageViewComponent).removeAnnotation(popupAnnotationComponent);
                break;
            }
        }
    }
}

