/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class FileExtensionUtils {
    public static final String pdf = "pdf";
    public static final String svg = "svg";
    public static final String ps = "ps";
    public static final String txt = "txt";

    public static FileFilter getPDFFileFilter() {
        return new ExtensionFileFilter("Adobe PDF Files (*.pdf)", pdf);
    }

    public static FileFilter getTextFileFilter() {
        return new ExtensionFileFilter("Text Files (*.txt)", txt);
    }

    public static FileFilter getSVGFileFilter() {
        return new ExtensionFileFilter("SVG Files (*.svg)", svg);
    }

    public static String getExtension(File file) {
        return FileExtensionUtils.getExtension(file.getName());
    }

    public static String getExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1).toLowerCase();
        }
        return string2;
    }

    private static class ExtensionFileFilter
    extends FileFilter {
        private final String description;
        private final String extension;

        ExtensionFileFilter(String string, String string2) {
            this.description = string;
            this.extension = string2;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = FileExtensionUtils.getExtension(file);
            return string != null && string.equals(this.extension);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

