/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.images.Images;

public class DropDownButton
extends JButton
implements MouseListener {
    private static final Logger logger = Logger.getLogger(DropDownButton.class.toString());
    protected final Controller controller;
    protected final JPopupMenu popupMenu;
    protected final String imageName;
    protected final String imageSize;

    public DropDownButton(Controller controller, String string, String string2, String string3, String string4, Font font) {
        super(string);
        this.controller = controller;
        this.setFont(font);
        this.setToolTipText(string2);
        this.setRolloverEnabled(true);
        this.imageName = string3;
        this.imageSize = string4;
        if (string3 != null) {
            try {
                ImageIcon imageIcon = new ImageIcon(Images.get(string3 + "_a" + string4 + ".png"));
                this.setIcon(new ImageIcon(Images.get(string3 + "_a" + string4 + ".png")));
                this.setPressedIcon(new ImageIcon(Images.get(string3 + "_i" + string4 + ".png")));
                this.setRolloverIcon(new ImageIcon(Images.get(string3 + "_r" + string4 + ".png")));
                this.setDisabledIcon(new ImageIcon(Images.get(string3 + "_i" + string4 + ".png")));
                this.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
            }
            catch (NullPointerException nullPointerException) {
                logger.warning("Failed to load dropdown image button images: " + string3 + "_i" + string4 + ".png");
            }
        }
        this.popupMenu = new JPopupMenu();
        this.addMouseListener(this);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.popupMenu.setEnabled(bl);
    }

    @Override
    public void setSelected(boolean bl) {
        super.setSelected(bl);
        try {
            if (bl) {
                this.setIcon(new ImageIcon(Images.get(this.imageName + "_selected_a" + this.imageSize + ".png")));
            } else {
                this.setIcon(new ImageIcon(Images.get(this.imageName + "_a" + this.imageSize + ".png")));
            }
        }
        catch (Exception exception) {
            logger.warning("Could not load icon" + this.imageName + "_a" + this.imageSize + ".png");
        }
    }

    public void add(JMenuItem jMenuItem, int n) {
        this.popupMenu.add((Component)jMenuItem, n);
    }

    public void add(JMenuItem jMenuItem) {
        this.popupMenu.add(jMenuItem);
    }

    public void addSeparator() {
        this.popupMenu.addSeparator();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && this.isEnabled()) {
            this.popupMenu.show(mouseEvent.getComponent(), 5, this.getHeight() - 5);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

