/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JScrollPane;
import org.icepdf.ri.common.MouseWheelCurrentPageListener;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewControllerImpl;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.PageViewComponent;

public class CurrentPageChanger
extends MouseAdapter
implements AdjustmentListener {
    private static final Logger logger = Logger.getLogger(CurrentPageChanger.class.toString());
    private boolean isScrolled = false;
    private final List<AbstractPageViewComponent> pageComponents;
    private final JScrollPane scrollpane;
    private final Object mouseWheelCurrentPageListener;
    private final AbstractDocumentView documentView;
    private final DocumentViewModel documentViewModel;

    public CurrentPageChanger(JScrollPane jScrollPane, AbstractDocumentView abstractDocumentView, List<AbstractPageViewComponent> list) {
        this(jScrollPane, abstractDocumentView, list, true);
    }

    public CurrentPageChanger(JScrollPane jScrollPane, AbstractDocumentView abstractDocumentView, List<AbstractPageViewComponent> list, boolean bl) {
        this.pageComponents = list;
        this.scrollpane = jScrollPane;
        this.documentView = abstractDocumentView;
        this.documentViewModel = abstractDocumentView.getViewModel();
        this.documentView.addMouseListener(this);
        this.scrollpane.getHorizontalScrollBar().addAdjustmentListener(this);
        this.scrollpane.getHorizontalScrollBar().addMouseListener(this);
        this.scrollpane.getVerticalScrollBar().addAdjustmentListener(this);
        this.scrollpane.getVerticalScrollBar().addMouseListener(this);
        this.mouseWheelCurrentPageListener = MouseWheelCurrentPageListener.install(jScrollPane, this);
    }

    private void addMouseListenerToAnyButtonsIn(Component component) {
        int n = component instanceof Container ? ((Container)component).getComponentCount() : -1;
        for (int i = 0; i < n; ++i) {
            Component component2 = ((Container)component).getComponent(i);
            if (component2 instanceof AbstractButton) {
                component2.addMouseListener(this);
            }
            this.addMouseListenerToAnyButtonsIn(component2);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isScrolled) {
            this.calculateCurrentPage();
            this.isScrolled = false;
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.isScrolled = true;
    }

    public void calculateCurrentPage() {
        if (this.pageComponents != null) {
            Rectangle rectangle;
            Rectangle rectangle2 = this.scrollpane.getViewport().getViewRect();
            ArrayList<AbstractPageViewComponent> arrayList = new ArrayList<AbstractPageViewComponent>(10);
            int n = 0;
            for (AbstractPageViewComponent abstractPageViewComponent : this.pageComponents) {
                if (abstractPageViewComponent != null && (rectangle = this.documentViewModel.getPageBounds(n)) != null && abstractPageViewComponent.isShowing()) {
                    arrayList.add(abstractPageViewComponent);
                }
                ++n;
            }
            int n2 = rectangle2.x + rectangle2.width / 2;
            int n3 = rectangle2.y + rectangle2.height / 2;
            Point point = new Point(n2, n3);
            double d = Double.MAX_VALUE;
            int n4 = -1;
            for (PageViewComponent object2 : arrayList) {
                if (object2 == null) continue;
                rectangle = this.documentViewModel.getPageBounds(object2.getPageIndex());
                n2 = rectangle.x + rectangle.width / 2;
                n3 = rectangle.y + rectangle.height / 2;
                double d2 = point.distance(n2, n3);
                if (!(d2 < d)) continue;
                d = d2;
                n4 = object2.getPageIndex();
            }
            arrayList.clear();
            arrayList.trimToSize();
            int n5 = this.documentViewModel.getViewCurrentPageIndex();
            this.documentViewModel.setViewCurrentPageIndex(n4);
            DocumentViewControllerImpl documentViewControllerImpl = (DocumentViewControllerImpl)this.documentView.getParentViewController();
            documentViewControllerImpl.firePropertyChange("documentCurrentPage", n5, n4);
        }
    }

    public void dispose() {
        this.documentView.removeMouseListener(this);
        this.scrollpane.getHorizontalScrollBar().removeAdjustmentListener(this);
        this.scrollpane.getHorizontalScrollBar().removeMouseListener(this);
        this.scrollpane.getVerticalScrollBar().removeAdjustmentListener(this);
        this.scrollpane.getVerticalScrollBar().removeMouseListener(this);
        MouseWheelCurrentPageListener.uninstall(this.scrollpane, this.mouseWheelCurrentPageListener);
    }
}

