/* Copyright 2013 Samuel Halliday (generated Java and C).
 * Copyright 2003-2007 Keith Seymour (Fortran to Java translation).
 * Copyright 1992-2007 The University of Tennessee. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer listed
 *   in this license in the documentation and/or other materials
 *   provided with the distribution.
 *
 * - Neither the name of the copyright holders nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.github.fommil.netlib;

/**
 * Generated by {@code JavaInterfaceGenerator} from {@code org.netlib.lapack} in {@code net.sourceforge.f2j:arpack_combined_all:jar:0.1}.
 * <p>
 * Property {@value #PROPERTY_KEY} defines the implementation to load,
 * defaulting to {@value #FALLBACK}.
 * <p>
 * <i>This requires 1D column-major linearized arrays, as
 * expected by the lower level routines; contrary to
 * typical Java 2D row-major arrays.</i>
 */
@lombok.extern.java.Log
public abstract class LAPACK {

  private static final String FALLBACK = "com.github.fommil.netlib.F2jLAPACK";
  private static final String IMPLS = "com.github.fommil.netlib.NativeSystemLAPACK,com.github.fommil.netlib.NativeRefLAPACK,com.github.fommil.netlib.F2jLAPACK";
  private static final String PROPERTY_KEY = "com.github.fommil.netlib.LAPACK";
  private static final LAPACK INSTANCE;
  static {
    try {
      String[] classNames = System.getProperty(PROPERTY_KEY, IMPLS).split(",");
      LAPACK impl = null;
      for (String className: classNames) {
        try {
          impl = load(className);
          break;
        } catch (Exception e) {
          log.warning("Failed to load implementation from: " + className);
        }
      }
      if (impl == null) {
        log.warning("Using the fallback implementation.");
        impl = load(FALLBACK);
      }
      INSTANCE = impl;
      log.config("Implementation provided by " + INSTANCE.getClass());
      INSTANCE.slamch("E"); INSTANCE.dlamch("E");
    } catch (Exception e) {
      throw new ExceptionInInitializerError(e);
    }
  }

  private static LAPACK load(String className) throws Exception {
    Class klass = Class.forName(className);
    return (LAPACK) klass.newInstance();
  }

  /**
   * @return the environment-defined implementation.
   */
  public static LAPACK getInstance() {
    return INSTANCE;
  }

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DBDSDC computes the singular value decomposition (SVD) of a real
   *  N-by-N (upper or lower) bidiagonal matrix B:  B = U * S * VT,
   *  using a divide and conquer method, where S is a diagonal matrix
   *  with non-negative diagonal elements (the singular values of B), and
   *  U and VT are orthogonal matrices of left and right singular vectors,
   *  respectively. DBDSDC can be used to compute all singular values,
   *  and optionally, singular vectors or singular vectors in compact form.
   *
   *  This code makes very mild assumptions about floating point
   *  arithmetic. It will work on machines with a guard digit in
   *  add/subtract, or on those binary machines without guard digits
   *  which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or Cray-2.
   *  It could conceivably fail on hexadecimal or decimal machines
   *  without guard digits, but we know of none.  See DLASD3 for details.
   *
   *  The code currently calls DLASDQ if singular values only are desired.
   *  However, it can be slightly modified to compute singular values
   *  using the divide and conquer method.
   *
   *  Arguments
   *  =========
   *
   *  UPLO    (input) CHARACTER*1
   *          = 'U':  B is upper bidiagonal.
   *          = 'L':  B is lower bidiagonal.
   *
   *  COMPQ   (input) CHARACTER*1
   *          Specifies whether singular vectors are to be computed
   *          as follows:
   *          = 'N':  Compute singular values only;
   *          = 'P':  Compute singular values and compute singular
   *                  vectors in compact form;
   *          = 'I':  Compute singular values and singular vectors.
   *
   *  N       (input) INTEGER
   *          The order of the matrix B.  N >= 0.
   *
   *  D       (input/output) DOUBLE PRECISION array, dimension (N)
   *          On entry, the n diagonal elements of the bidiagonal matrix B.
   *          On exit, if INFO=0, the singular values of B.
   *
   *  E       (input/output) DOUBLE PRECISION array, dimension (N-1)
   *          On entry, the elements of E contain the offdiagonal
   *          elements of the bidiagonal matrix whose SVD is desired.
   *          On exit, E has been destroyed.
   *
   *  U       (output) DOUBLE PRECISION array, dimension (LDU,N)
   *          If  COMPQ = 'I', then:
   *             On exit, if INFO = 0, U contains the left singular vectors
   *             of the bidiagonal matrix.
   *          For other values of COMPQ, U is not referenced.
   *
   *  LDU     (input) INTEGER
   *          The leading dimension of the array U.  LDU >= 1.
   *          If singular vectors are desired, then LDU >= max( 1, N ).
   *
   *  VT      (output) DOUBLE PRECISION array, dimension (LDVT,N)
   *          If  COMPQ = 'I', then:
   *             On exit, if INFO = 0, VT' contains the right singular
   *             vectors of the bidiagonal matrix.
   *          For other values of COMPQ, VT is not referenced.
   *
   *  LDVT    (input) INTEGER
   *          The leading dimension of the array VT.  LDVT >= 1.
   *          If singular vectors are desired, then LDVT >= max( 1, N ).
   *
   *  Q       (output) DOUBLE PRECISION array, dimension (LDQ)
   *          If  COMPQ = 'P', then:
   *             On exit, if INFO = 0, Q and IQ contain the left
   *             and right singular vectors in a compact form,
   *             requiring O(N log N) space instead of 2*N**2.
   *             In particular, Q contains all the DOUBLE PRECISION data in
   *             LDQ >= N*(11 + 2*SMLSIZ + 8*INT(LOG_2(N/(SMLSIZ+1))))
   *             words of memory, where SMLSIZ is returned by ILAENV and
   *             is equal to the maximum size of the subproblems at the
   *             bottom of the computation tree (usually about 25).
   *          For other values of COMPQ, Q is not referenced.
   *
   *  IQ      (output) INTEGER array, dimension (LDIQ)
   *          If  COMPQ = 'P', then:
   *             On exit, if INFO = 0, Q and IQ contain the left
   *             and right singular vectors in a compact form,
   *             requiring O(N log N) space instead of 2*N**2.
   *             In particular, IQ contains all INTEGER data in
   *             LDIQ >= N*(3 + 3*INT(LOG_2(N/(SMLSIZ+1))))
   *             words of memory, where SMLSIZ is returned by ILAENV and
   *             is equal to the maximum size of the subproblems at the
   *             bottom of the computation tree (usually about 25).
   *          For other values of COMPQ, IQ is not referenced.
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (MAX(1,LWORK))
   *          If COMPQ = 'N' then LWORK >= (4 * N).
   *          If COMPQ = 'P' then LWORK >= (6 * N).
   *          If COMPQ = 'I' then LWORK >= (3 * N**2 + 4 * N).
   *
   *  IWORK   (workspace) INTEGER array, dimension (8*N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  The algorithm failed to compute an singular value.
   *                The update process of divide and conquer failed.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Ming Gu and Huan Ren, Computer Science Division, University of
   *     California at Berkeley, USA
   *
   *  =====================================================================
   *  Changed dimension statement in comment describing E from (N) to
   *  (N-1).  Sven, 17 Feb 05.
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param compq
   * @param n
   * @param d
   * @param e
   * @param u
   * @param ldu
   * @param vt
   * @param ldvt
   * @param q
   * @param iq
   * @param work
   * @param iwork
   * @param info
   * 
   */
  abstract public void dbdsdc(java.lang.String uplo, java.lang.String compq, int n, double[] d, double[] e, double[] u, int ldu, double[] vt, int ldvt, double[] q, int[] iq, double[] work, int[] iwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DBDSDC computes the singular value decomposition (SVD) of a real
   *  N-by-N (upper or lower) bidiagonal matrix B:  B = U * S * VT,
   *  using a divide and conquer method, where S is a diagonal matrix
   *  with non-negative diagonal elements (the singular values of B), and
   *  U and VT are orthogonal matrices of left and right singular vectors,
   *  respectively. DBDSDC can be used to compute all singular values,
   *  and optionally, singular vectors or singular vectors in compact form.
   *
   *  This code makes very mild assumptions about floating point
   *  arithmetic. It will work on machines with a guard digit in
   *  add/subtract, or on those binary machines without guard digits
   *  which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or Cray-2.
   *  It could conceivably fail on hexadecimal or decimal machines
   *  without guard digits, but we know of none.  See DLASD3 for details.
   *
   *  The code currently calls DLASDQ if singular values only are desired.
   *  However, it can be slightly modified to compute singular values
   *  using the divide and conquer method.
   *
   *  Arguments
   *  =========
   *
   *  UPLO    (input) CHARACTER*1
   *          = 'U':  B is upper bidiagonal.
   *          = 'L':  B is lower bidiagonal.
   *
   *  COMPQ   (input) CHARACTER*1
   *          Specifies whether singular vectors are to be computed
   *          as follows:
   *          = 'N':  Compute singular values only;
   *          = 'P':  Compute singular values and compute singular
   *                  vectors in compact form;
   *          = 'I':  Compute singular values and singular vectors.
   *
   *  N       (input) INTEGER
   *          The order of the matrix B.  N >= 0.
   *
   *  D       (input/output) DOUBLE PRECISION array, dimension (N)
   *          On entry, the n diagonal elements of the bidiagonal matrix B.
   *          On exit, if INFO=0, the singular values of B.
   *
   *  E       (input/output) DOUBLE PRECISION array, dimension (N-1)
   *          On entry, the elements of E contain the offdiagonal
   *          elements of the bidiagonal matrix whose SVD is desired.
   *          On exit, E has been destroyed.
   *
   *  U       (output) DOUBLE PRECISION array, dimension (LDU,N)
   *          If  COMPQ = 'I', then:
   *             On exit, if INFO = 0, U contains the left singular vectors
   *             of the bidiagonal matrix.
   *          For other values of COMPQ, U is not referenced.
   *
   *  LDU     (input) INTEGER
   *          The leading dimension of the array U.  LDU >= 1.
   *          If singular vectors are desired, then LDU >= max( 1, N ).
   *
   *  VT      (output) DOUBLE PRECISION array, dimension (LDVT,N)
   *          If  COMPQ = 'I', then:
   *             On exit, if INFO = 0, VT' contains the right singular
   *             vectors of the bidiagonal matrix.
   *          For other values of COMPQ, VT is not referenced.
   *
   *  LDVT    (input) INTEGER
   *          The leading dimension of the array VT.  LDVT >= 1.
   *          If singular vectors are desired, then LDVT >= max( 1, N ).
   *
   *  Q       (output) DOUBLE PRECISION array, dimension (LDQ)
   *          If  COMPQ = 'P', then:
   *             On exit, if INFO = 0, Q and IQ contain the left
   *             and right singular vectors in a compact form,
   *             requiring O(N log N) space instead of 2*N**2.
   *             In particular, Q contains all the DOUBLE PRECISION data in
   *             LDQ >= N*(11 + 2*SMLSIZ + 8*INT(LOG_2(N/(SMLSIZ+1))))
   *             words of memory, where SMLSIZ is returned by ILAENV and
   *             is equal to the maximum size of the subproblems at the
   *             bottom of the computation tree (usually about 25).
   *          For other values of COMPQ, Q is not referenced.
   *
   *  IQ      (output) INTEGER array, dimension (LDIQ)
   *          If  COMPQ = 'P', then:
   *             On exit, if INFO = 0, Q and IQ contain the left
   *             and right singular vectors in a compact form,
   *             requiring O(N log N) space instead of 2*N**2.
   *             In particular, IQ contains all INTEGER data in
   *             LDIQ >= N*(3 + 3*INT(LOG_2(N/(SMLSIZ+1))))
   *             words of memory, where SMLSIZ is returned by ILAENV and
   *             is equal to the maximum size of the subproblems at the
   *             bottom of the computation tree (usually about 25).
   *          For other values of COMPQ, IQ is not referenced.
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (MAX(1,LWORK))
   *          If COMPQ = 'N' then LWORK >= (4 * N).
   *          If COMPQ = 'P' then LWORK >= (6 * N).
   *          If COMPQ = 'I' then LWORK >= (3 * N**2 + 4 * N).
   *
   *  IWORK   (workspace) INTEGER array, dimension (8*N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  The algorithm failed to compute an singular value.
   *                The update process of divide and conquer failed.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Ming Gu and Huan Ren, Computer Science Division, University of
   *     California at Berkeley, USA
   *
   *  =====================================================================
   *  Changed dimension statement in comment describing E from (N) to
   *  (N-1).  Sven, 17 Feb 05.
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param compq
   * @param n
   * @param d
   * @param _d_offset
   * @param e
   * @param _e_offset
   * @param u
   * @param _u_offset
   * @param ldu
   * @param vt
   * @param _vt_offset
   * @param ldvt
   * @param q
   * @param _q_offset
   * @param iq
   * @param _iq_offset
   * @param work
   * @param _work_offset
   * @param iwork
   * @param _iwork_offset
   * @param info
   * 
   */
  abstract public void dbdsdc(java.lang.String uplo, java.lang.String compq, int n, double[] d, int _d_offset, double[] e, int _e_offset, double[] u, int _u_offset, int ldu, double[] vt, int _vt_offset, int ldvt, double[] q, int _q_offset, int[] iq, int _iq_offset, double[] work, int _work_offset, int[] iwork, int _iwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DBDSQR computes the singular values and, optionally, the right and/or
   *  left singular vectors from the singular value decomposition (SVD) of
   *  a real N-by-N (upper or lower) bidiagonal matrix B using the implicit
   *  zero-shift QR algorithm.  The SVD of B has the form
   * 
   *     B = Q * S * P**T
   * 
   *  where S is the diagonal matrix of singular values, Q is an orthogonal
   *  matrix of left singular vectors, and P is an orthogonal matrix of
   *  right singular vectors.  If left singular vectors are requested, this
   *  subroutine actually returns U*Q instead of Q, and, if right singular
   *  vectors are requested, this subroutine returns P**T*VT instead of
   *  P**T, for given real input matrices U and VT.  When U and VT are the
   *  orthogonal matrices that reduce a general matrix A to bidiagonal
   *  form:  A = U*B*VT, as computed by DGEBRD, then
   *
   *     A = (U*Q) * S * (P**T*VT)
   *
   *  is the SVD of A.  Optionally, the subroutine may also compute Q**T*C
   *  for a given real input matrix C.
   *
   *  See "Computing  Small Singular Values of Bidiagonal Matrices With
   *  Guaranteed High Relative Accuracy," by J. Demmel and W. Kahan,
   *  LAPACK Working Note #3 (or SIAM J. Sci. Statist. Comput. vol. 11,
   *  no. 5, pp. 873-912, Sept 1990) and
   *  "Accurate singular values and differential qd algorithms," by
   *  B. Parlett and V. Fernando, Technical Report CPAM-554, Mathematics
   *  Department, University of California at Berkeley, July 1992
   *  for a detailed description of the algorithm.
   *
   *  Arguments
   *  =========
   *
   *  UPLO    (input) CHARACTER*1
   *          = 'U':  B is upper bidiagonal;
   *          = 'L':  B is lower bidiagonal.
   *
   *  N       (input) INTEGER
   *          The order of the matrix B.  N >= 0.
   *
   *  NCVT    (input) INTEGER
   *          The number of columns of the matrix VT. NCVT >= 0.
   *
   *  NRU     (input) INTEGER
   *          The number of rows of the matrix U. NRU >= 0.
   *
   *  NCC     (input) INTEGER
   *          The number of columns of the matrix C. NCC >= 0.
   *
   *  D       (input/output) DOUBLE PRECISION array, dimension (N)
   *          On entry, the n diagonal elements of the bidiagonal matrix B.
   *          On exit, if INFO=0, the singular values of B in decreasing
   *          order.
   *
   *  E       (input/output) DOUBLE PRECISION array, dimension (N-1)
   *          On entry, the N-1 offdiagonal elements of the bidiagonal
   *          matrix B. 
   *          On exit, if INFO = 0, E is destroyed; if INFO > 0, D and E
   *          will contain the diagonal and superdiagonal elements of a
   *          bidiagonal matrix orthogonally equivalent to the one given
   *          as input.
   *
   *  VT      (input/output) DOUBLE PRECISION array, dimension (LDVT, NCVT)
   *          On entry, an N-by-NCVT matrix VT.
   *          On exit, VT is overwritten by P**T * VT.
   *          Not referenced if NCVT = 0.
   *
   *  LDVT    (input) INTEGER
   *          The leading dimension of the array VT.
   *          LDVT >= max(1,N) if NCVT > 0; LDVT >= 1 if NCVT = 0.
   *
   *  U       (input/output) DOUBLE PRECISION array, dimension (LDU, N)
   *          On entry, an NRU-by-N matrix U.
   *          On exit, U is overwritten by U * Q.
   *          Not referenced if NRU = 0.
   *
   *  LDU     (input) INTEGER
   *          The leading dimension of the array U.  LDU >= max(1,NRU).
   *
   *  C       (input/output) DOUBLE PRECISION array, dimension (LDC, NCC)
   *          On entry, an N-by-NCC matrix C.
   *          On exit, C is overwritten by Q**T * C.
   *          Not referenced if NCC = 0.
   *
   *  LDC     (input) INTEGER
   *          The leading dimension of the array C.
   *          LDC >= max(1,N) if NCC > 0; LDC >=1 if NCC = 0.
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (2*N)
   *          if NCVT = NRU = NCC = 0, (max(1, 4*N)) otherwise
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  If INFO = -i, the i-th argument had an illegal value
   *          > 0:  the algorithm did not converge; D and E contain the
   *                elements of a bidiagonal matrix which is orthogonally
   *                similar to the input matrix B;  if INFO = i, i
   *                elements of E have not converged to zero.
   *
   *  Internal Parameters
   *  ===================
   *
   *  TOLMUL  DOUBLE PRECISION, default = max(10,min(100,EPS**(-1/8)))
   *          TOLMUL controls the convergence criterion of the QR loop.
   *          If it is positive, TOLMUL*EPS is the desired relative
   *             precision in the computed singular values.
   *          If it is negative, abs(TOLMUL*EPS*sigma_max) is the
   *             desired absolute accuracy in the computed singular
   *             values (corresponds to relative accuracy
   *             abs(TOLMUL*EPS) in the largest singular value.
   *          abs(TOLMUL) should be between 1 and 1/EPS, and preferably
   *             between 10 (for fast convergence) and .1/EPS
   *             (for there to be some accuracy in the results).
   *          Default is to lose at either one eighth or 2 of the
   *             available decimal digits in each computed singular value
   *             (whichever is smaller).
   *
   *  MAXITR  INTEGER, default = 6
   *          MAXITR controls the maximum number of passes of the
   *          algorithm through its inner loop. The algorithms stops
   *          (and so fails to converge) if the number of passes
   *          through the inner loop exceeds MAXITR*N**2.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param ncvt
   * @param nru
   * @param ncc
   * @param d
   * @param e
   * @param vt
   * @param ldvt
   * @param u
   * @param ldu
   * @param c
   * @param Ldc
   * @param work
   * @param info
   * 
   */
  abstract public void dbdsqr(java.lang.String uplo, int n, int ncvt, int nru, int ncc, double[] d, double[] e, double[] vt, int ldvt, double[] u, int ldu, double[] c, int Ldc, double[] work, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DBDSQR computes the singular values and, optionally, the right and/or
   *  left singular vectors from the singular value decomposition (SVD) of
   *  a real N-by-N (upper or lower) bidiagonal matrix B using the implicit
   *  zero-shift QR algorithm.  The SVD of B has the form
   * 
   *     B = Q * S * P**T
   * 
   *  where S is the diagonal matrix of singular values, Q is an orthogonal
   *  matrix of left singular vectors, and P is an orthogonal matrix of
   *  right singular vectors.  If left singular vectors are requested, this
   *  subroutine actually returns U*Q instead of Q, and, if right singular
   *  vectors are requested, this subroutine returns P**T*VT instead of
   *  P**T, for given real input matrices U and VT.  When U and VT are the
   *  orthogonal matrices that reduce a general matrix A to bidiagonal
   *  form:  A = U*B*VT, as computed by DGEBRD, then
   *
   *     A = (U*Q) * S * (P**T*VT)
   *
   *  is the SVD of A.  Optionally, the subroutine may also compute Q**T*C
   *  for a given real input matrix C.
   *
   *  See "Computing  Small Singular Values of Bidiagonal Matrices With
   *  Guaranteed High Relative Accuracy," by J. Demmel and W. Kahan,
   *  LAPACK Working Note #3 (or SIAM J. Sci. Statist. Comput. vol. 11,
   *  no. 5, pp. 873-912, Sept 1990) and
   *  "Accurate singular values and differential qd algorithms," by
   *  B. Parlett and V. Fernando, Technical Report CPAM-554, Mathematics
   *  Department, University of California at Berkeley, July 1992
   *  for a detailed description of the algorithm.
   *
   *  Arguments
   *  =========
   *
   *  UPLO    (input) CHARACTER*1
   *          = 'U':  B is upper bidiagonal;
   *          = 'L':  B is lower bidiagonal.
   *
   *  N       (input) INTEGER
   *          The order of the matrix B.  N >= 0.
   *
   *  NCVT    (input) INTEGER
   *          The number of columns of the matrix VT. NCVT >= 0.
   *
   *  NRU     (input) INTEGER
   *          The number of rows of the matrix U. NRU >= 0.
   *
   *  NCC     (input) INTEGER
   *          The number of columns of the matrix C. NCC >= 0.
   *
   *  D       (input/output) DOUBLE PRECISION array, dimension (N)
   *          On entry, the n diagonal elements of the bidiagonal matrix B.
   *          On exit, if INFO=0, the singular values of B in decreasing
   *          order.
   *
   *  E       (input/output) DOUBLE PRECISION array, dimension (N-1)
   *          On entry, the N-1 offdiagonal elements of the bidiagonal
   *          matrix B. 
   *          On exit, if INFO = 0, E is destroyed; if INFO > 0, D and E
   *          will contain the diagonal and superdiagonal elements of a
   *          bidiagonal matrix orthogonally equivalent to the one given
   *          as input.
   *
   *  VT      (input/output) DOUBLE PRECISION array, dimension (LDVT, NCVT)
   *          On entry, an N-by-NCVT matrix VT.
   *          On exit, VT is overwritten by P**T * VT.
   *          Not referenced if NCVT = 0.
   *
   *  LDVT    (input) INTEGER
   *          The leading dimension of the array VT.
   *          LDVT >= max(1,N) if NCVT > 0; LDVT >= 1 if NCVT = 0.
   *
   *  U       (input/output) DOUBLE PRECISION array, dimension (LDU, N)
   *          On entry, an NRU-by-N matrix U.
   *          On exit, U is overwritten by U * Q.
   *          Not referenced if NRU = 0.
   *
   *  LDU     (input) INTEGER
   *          The leading dimension of the array U.  LDU >= max(1,NRU).
   *
   *  C       (input/output) DOUBLE PRECISION array, dimension (LDC, NCC)
   *          On entry, an N-by-NCC matrix C.
   *          On exit, C is overwritten by Q**T * C.
   *          Not referenced if NCC = 0.
   *
   *  LDC     (input) INTEGER
   *          The leading dimension of the array C.
   *          LDC >= max(1,N) if NCC > 0; LDC >=1 if NCC = 0.
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (2*N)
   *          if NCVT = NRU = NCC = 0, (max(1, 4*N)) otherwise
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  If INFO = -i, the i-th argument had an illegal value
   *          > 0:  the algorithm did not converge; D and E contain the
   *                elements of a bidiagonal matrix which is orthogonally
   *                similar to the input matrix B;  if INFO = i, i
   *                elements of E have not converged to zero.
   *
   *  Internal Parameters
   *  ===================
   *
   *  TOLMUL  DOUBLE PRECISION, default = max(10,min(100,EPS**(-1/8)))
   *          TOLMUL controls the convergence criterion of the QR loop.
   *          If it is positive, TOLMUL*EPS is the desired relative
   *             precision in the computed singular values.
   *          If it is negative, abs(TOLMUL*EPS*sigma_max) is the
   *             desired absolute accuracy in the computed singular
   *             values (corresponds to relative accuracy
   *             abs(TOLMUL*EPS) in the largest singular value.
   *          abs(TOLMUL) should be between 1 and 1/EPS, and preferably
   *             between 10 (for fast convergence) and .1/EPS
   *             (for there to be some accuracy in the results).
   *          Default is to lose at either one eighth or 2 of the
   *             available decimal digits in each computed singular value
   *             (whichever is smaller).
   *
   *  MAXITR  INTEGER, default = 6
   *          MAXITR controls the maximum number of passes of the
   *          algorithm through its inner loop. The algorithms stops
   *          (and so fails to converge) if the number of passes
   *          through the inner loop exceeds MAXITR*N**2.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param uplo
   * @param n
   * @param ncvt
   * @param nru
   * @param ncc
   * @param d
   * @param _d_offset
   * @param e
   * @param _e_offset
   * @param vt
   * @param _vt_offset
   * @param ldvt
   * @param u
   * @param _u_offset
   * @param ldu
   * @param c
   * @param _c_offset
   * @param Ldc
   * @param work
   * @param _work_offset
   * @param info
   * 
   */
  abstract public void dbdsqr(java.lang.String uplo, int n, int ncvt, int nru, int ncc, double[] d, int _d_offset, double[] e, int _e_offset, double[] vt, int _vt_offset, int ldvt, double[] u, int _u_offset, int ldu, double[] c, int _c_offset, int Ldc, double[] work, int _work_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DDISNA computes the reciprocal condition numbers for the eigenvectors
   *  of a real symmetric or complex Hermitian matrix or for the left or
   *  right singular vectors of a general m-by-n matrix. The reciprocal
   *  condition number is the 'gap' between the corresponding eigenvalue or
   *  singular value and the nearest other one.
   *
   *  The bound on the error, measured by angle in radians, in the I-th
   *  computed vector is given by
   *
   *         DLAMCH( 'E' ) * ( ANORM / SEP( I ) )
   *
   *  where ANORM = 2-norm(A) = max( abs( D(j) ) ).  SEP(I) is not allowed
   *  to be smaller than DLAMCH( 'E' )*ANORM in order to limit the size of
   *  the error bound.
   *
   *  DDISNA may also be used to compute error bounds for eigenvectors of
   *  the generalized symmetric definite eigenproblem.
   *
   *  Arguments
   *  =========
   *
   *  JOB     (input) CHARACTER*1
   *          Specifies for which problem the reciprocal condition numbers
   *          should be computed:
   *          = 'E':  the eigenvectors of a symmetric/Hermitian matrix;
   *          = 'L':  the left singular vectors of a general matrix;
   *          = 'R':  the right singular vectors of a general matrix.
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix. M >= 0.
   *
   *  N       (input) INTEGER
   *          If JOB = 'L' or 'R', the number of columns of the matrix,
   *          in which case N >= 0. Ignored if JOB = 'E'.
   *
   *  D       (input) DOUBLE PRECISION array, dimension (M) if JOB = 'E'
   *                              dimension (min(M,N)) if JOB = 'L' or 'R'
   *          The eigenvalues (if JOB = 'E') or singular values (if JOB =
   *          'L' or 'R') of the matrix, in either increasing or decreasing
   *          order. If singular values, they must be non-negative.
   *
   *  SEP     (output) DOUBLE PRECISION array, dimension (M) if JOB = 'E'
   *                               dimension (min(M,N)) if JOB = 'L' or 'R'
   *          The reciprocal condition numbers of the vectors.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param job
   * @param m
   * @param n
   * @param d
   * @param sep
   * @param info
   * 
   */
  abstract public void ddisna(java.lang.String job, int m, int n, double[] d, double[] sep, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DDISNA computes the reciprocal condition numbers for the eigenvectors
   *  of a real symmetric or complex Hermitian matrix or for the left or
   *  right singular vectors of a general m-by-n matrix. The reciprocal
   *  condition number is the 'gap' between the corresponding eigenvalue or
   *  singular value and the nearest other one.
   *
   *  The bound on the error, measured by angle in radians, in the I-th
   *  computed vector is given by
   *
   *         DLAMCH( 'E' ) * ( ANORM / SEP( I ) )
   *
   *  where ANORM = 2-norm(A) = max( abs( D(j) ) ).  SEP(I) is not allowed
   *  to be smaller than DLAMCH( 'E' )*ANORM in order to limit the size of
   *  the error bound.
   *
   *  DDISNA may also be used to compute error bounds for eigenvectors of
   *  the generalized symmetric definite eigenproblem.
   *
   *  Arguments
   *  =========
   *
   *  JOB     (input) CHARACTER*1
   *          Specifies for which problem the reciprocal condition numbers
   *          should be computed:
   *          = 'E':  the eigenvectors of a symmetric/Hermitian matrix;
   *          = 'L':  the left singular vectors of a general matrix;
   *          = 'R':  the right singular vectors of a general matrix.
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix. M >= 0.
   *
   *  N       (input) INTEGER
   *          If JOB = 'L' or 'R', the number of columns of the matrix,
   *          in which case N >= 0. Ignored if JOB = 'E'.
   *
   *  D       (input) DOUBLE PRECISION array, dimension (M) if JOB = 'E'
   *                              dimension (min(M,N)) if JOB = 'L' or 'R'
   *          The eigenvalues (if JOB = 'E') or singular values (if JOB =
   *          'L' or 'R') of the matrix, in either increasing or decreasing
   *          order. If singular values, they must be non-negative.
   *
   *  SEP     (output) DOUBLE PRECISION array, dimension (M) if JOB = 'E'
   *                               dimension (min(M,N)) if JOB = 'L' or 'R'
   *          The reciprocal condition numbers of the vectors.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param job
   * @param m
   * @param n
   * @param d
   * @param _d_offset
   * @param sep
   * @param _sep_offset
   * @param info
   * 
   */
  abstract public void ddisna(java.lang.String job, int m, int n, double[] d, int _d_offset, double[] sep, int _sep_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGBBRD reduces a real general m-by-n band matrix A to upper
   *  bidiagonal form B by an orthogonal transformation: Q' * A * P = B.
   *
   *  The routine computes B, and optionally forms Q or P', or computes
   *  Q'*C for a given matrix C.
   *
   *  Arguments
   *  =========
   *
   *  VECT    (input) CHARACTER*1
   *          Specifies whether or not the matrices Q and P' are to be
   *          formed.
   *          = 'N': do not form Q or P';
   *          = 'Q': form Q only;
   *          = 'P': form P' only;
   *          = 'B': form both.
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  NCC     (input) INTEGER
   *          The number of columns of the matrix C.  NCC >= 0.
   *
   *  KL      (input) INTEGER
   *          The number of subdiagonals of the matrix A. KL >= 0.
   *
   *  KU      (input) INTEGER
   *          The number of superdiagonals of the matrix A. KU >= 0.
   *
   *  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
   *          On entry, the m-by-n band matrix A, stored in rows 1 to
   *          KL+KU+1. The j-th column of A is stored in the j-th column of
   *          the array AB as follows:
   *          AB(ku+1+i-j,j) = A(i,j) for max(1,j-ku)<=i<=min(m,j+kl).
   *          On exit, A is overwritten by values generated during the
   *          reduction.
   *
   *  LDAB    (input) INTEGER
   *          The leading dimension of the array A. LDAB >= KL+KU+1.
   *
   *  D       (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The diagonal elements of the bidiagonal matrix B.
   *
   *  E       (output) DOUBLE PRECISION array, dimension (min(M,N)-1)
   *          The superdiagonal elements of the bidiagonal matrix B.
   *
   *  Q       (output) DOUBLE PRECISION array, dimension (LDQ,M)
   *          If VECT = 'Q' or 'B', the m-by-m orthogonal matrix Q.
   *          If VECT = 'N' or 'P', the array Q is not referenced.
   *
   *  LDQ     (input) INTEGER
   *          The leading dimension of the array Q.
   *          LDQ >= max(1,M) if VECT = 'Q' or 'B'; LDQ >= 1 otherwise.
   *
   *  PT      (output) DOUBLE PRECISION array, dimension (LDPT,N)
   *          If VECT = 'P' or 'B', the n-by-n orthogonal matrix P'.
   *          If VECT = 'N' or 'Q', the array PT is not referenced.
   *
   *  LDPT    (input) INTEGER
   *          The leading dimension of the array PT.
   *          LDPT >= max(1,N) if VECT = 'P' or 'B'; LDPT >= 1 otherwise.
   *
   *  C       (input/output) DOUBLE PRECISION array, dimension (LDC,NCC)
   *          On entry, an m-by-ncc matrix C.
   *          On exit, C is overwritten by Q'*C.
   *          C is not referenced if NCC = 0.
   *
   *  LDC     (input) INTEGER
   *          The leading dimension of the array C.
   *          LDC >= max(1,M) if NCC > 0; LDC >= 1 if NCC = 0.
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (2*max(M,N))
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param vect
   * @param m
   * @param n
   * @param ncc
   * @param kl
   * @param ku
   * @param ab
   * @param ldab
   * @param d
   * @param e
   * @param q
   * @param ldq
   * @param pt
   * @param ldpt
   * @param c
   * @param Ldc
   * @param work
   * @param info
   * 
   */
  abstract public void dgbbrd(java.lang.String vect, int m, int n, int ncc, int kl, int ku, double[] ab, int ldab, double[] d, double[] e, double[] q, int ldq, double[] pt, int ldpt, double[] c, int Ldc, double[] work, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGBBRD reduces a real general m-by-n band matrix A to upper
   *  bidiagonal form B by an orthogonal transformation: Q' * A * P = B.
   *
   *  The routine computes B, and optionally forms Q or P', or computes
   *  Q'*C for a given matrix C.
   *
   *  Arguments
   *  =========
   *
   *  VECT    (input) CHARACTER*1
   *          Specifies whether or not the matrices Q and P' are to be
   *          formed.
   *          = 'N': do not form Q or P';
   *          = 'Q': form Q only;
   *          = 'P': form P' only;
   *          = 'B': form both.
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  NCC     (input) INTEGER
   *          The number of columns of the matrix C.  NCC >= 0.
   *
   *  KL      (input) INTEGER
   *          The number of subdiagonals of the matrix A. KL >= 0.
   *
   *  KU      (input) INTEGER
   *          The number of superdiagonals of the matrix A. KU >= 0.
   *
   *  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
   *          On entry, the m-by-n band matrix A, stored in rows 1 to
   *          KL+KU+1. The j-th column of A is stored in the j-th column of
   *          the array AB as follows:
   *          AB(ku+1+i-j,j) = A(i,j) for max(1,j-ku)<=i<=min(m,j+kl).
   *          On exit, A is overwritten by values generated during the
   *          reduction.
   *
   *  LDAB    (input) INTEGER
   *          The leading dimension of the array A. LDAB >= KL+KU+1.
   *
   *  D       (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The diagonal elements of the bidiagonal matrix B.
   *
   *  E       (output) DOUBLE PRECISION array, dimension (min(M,N)-1)
   *          The superdiagonal elements of the bidiagonal matrix B.
   *
   *  Q       (output) DOUBLE PRECISION array, dimension (LDQ,M)
   *          If VECT = 'Q' or 'B', the m-by-m orthogonal matrix Q.
   *          If VECT = 'N' or 'P', the array Q is not referenced.
   *
   *  LDQ     (input) INTEGER
   *          The leading dimension of the array Q.
   *          LDQ >= max(1,M) if VECT = 'Q' or 'B'; LDQ >= 1 otherwise.
   *
   *  PT      (output) DOUBLE PRECISION array, dimension (LDPT,N)
   *          If VECT = 'P' or 'B', the n-by-n orthogonal matrix P'.
   *          If VECT = 'N' or 'Q', the array PT is not referenced.
   *
   *  LDPT    (input) INTEGER
   *          The leading dimension of the array PT.
   *          LDPT >= max(1,N) if VECT = 'P' or 'B'; LDPT >= 1 otherwise.
   *
   *  C       (input/output) DOUBLE PRECISION array, dimension (LDC,NCC)
   *          On entry, an m-by-ncc matrix C.
   *          On exit, C is overwritten by Q'*C.
   *          C is not referenced if NCC = 0.
   *
   *  LDC     (input) INTEGER
   *          The leading dimension of the array C.
   *          LDC >= max(1,M) if NCC > 0; LDC >= 1 if NCC = 0.
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (2*max(M,N))
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param vect
   * @param m
   * @param n
   * @param ncc
   * @param kl
   * @param ku
   * @param ab
   * @param _ab_offset
   * @param ldab
   * @param d
   * @param _d_offset
   * @param e
   * @param _e_offset
   * @param q
   * @param _q_offset
   * @param ldq
   * @param pt
   * @param _pt_offset
   * @param ldpt
   * @param c
   * @param _c_offset
   * @param Ldc
   * @param work
   * @param _work_offset
   * @param info
   * 
   */
  abstract public void dgbbrd(java.lang.String vect, int m, int n, int ncc, int kl, int ku, double[] ab, int _ab_offset, int ldab, double[] d, int _d_offset, double[] e, int _e_offset, double[] q, int _q_offset, int ldq, double[] pt, int _pt_offset, int ldpt, double[] c, int _c_offset, int Ldc, double[] work, int _work_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGBCON estimates the reciprocal of the condition number of a real
   *  general band matrix A, in either the 1-norm or the infinity-norm,
   *  using the LU factorization computed by DGBTRF.
   *
   *  An estimate is obtained for norm(inv(A)), and the reciprocal of the
   *  condition number is computed as
   *     RCOND = 1 / ( norm(A) * norm(inv(A)) ).
   *
   *  Arguments
   *  =========
   *
   *  NORM    (input) CHARACTER*1
   *          Specifies whether the 1-norm condition number or the
   *          infinity-norm condition number is required:
   *          = '1' or 'O':  1-norm;
   *          = 'I':         Infinity-norm.
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  KL      (input) INTEGER
   *          The number of subdiagonals within the band of A.  KL >= 0.
   *
   *  KU      (input) INTEGER
   *          The number of superdiagonals within the band of A.  KU >= 0.
   *
   *  AB      (input) DOUBLE PRECISION array, dimension (LDAB,N)
   *          Details of the LU factorization of the band matrix A, as
   *          computed by DGBTRF.  U is stored as an upper triangular band
   *          matrix with KL+KU superdiagonals in rows 1 to KL+KU+1, and
   *          the multipliers used during the factorization are stored in
   *          rows KL+KU+2 to 2*KL+KU+1.
   *
   *  LDAB    (input) INTEGER
   *          The leading dimension of the array AB.  LDAB >= 2*KL+KU+1.
   *
   *  IPIV    (input) INTEGER array, dimension (N)
   *          The pivot indices; for 1 <= i <= N, row i of the matrix was
   *          interchanged with row IPIV(i).
   *
   *  ANORM   (input) DOUBLE PRECISION
   *          If NORM = '1' or 'O', the 1-norm of the original matrix A.
   *          If NORM = 'I', the infinity-norm of the original matrix A.
   *
   *  RCOND   (output) DOUBLE PRECISION
   *          The reciprocal of the condition number of the matrix A,
   *          computed as RCOND = 1/(norm(A) * norm(inv(A))).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)
   *
   *  IWORK   (workspace) INTEGER array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param norm
   * @param n
   * @param kl
   * @param ku
   * @param ab
   * @param ldab
   * @param ipiv
   * @param anorm
   * @param rcond
   * @param work
   * @param iwork
   * @param info
   * 
   */
  abstract public void dgbcon(java.lang.String norm, int n, int kl, int ku, double[] ab, int ldab, int[] ipiv, double anorm, org.netlib.util.doubleW rcond, double[] work, int[] iwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGBCON estimates the reciprocal of the condition number of a real
   *  general band matrix A, in either the 1-norm or the infinity-norm,
   *  using the LU factorization computed by DGBTRF.
   *
   *  An estimate is obtained for norm(inv(A)), and the reciprocal of the
   *  condition number is computed as
   *     RCOND = 1 / ( norm(A) * norm(inv(A)) ).
   *
   *  Arguments
   *  =========
   *
   *  NORM    (input) CHARACTER*1
   *          Specifies whether the 1-norm condition number or the
   *          infinity-norm condition number is required:
   *          = '1' or 'O':  1-norm;
   *          = 'I':         Infinity-norm.
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  KL      (input) INTEGER
   *          The number of subdiagonals within the band of A.  KL >= 0.
   *
   *  KU      (input) INTEGER
   *          The number of superdiagonals within the band of A.  KU >= 0.
   *
   *  AB      (input) DOUBLE PRECISION array, dimension (LDAB,N)
   *          Details of the LU factorization of the band matrix A, as
   *          computed by DGBTRF.  U is stored as an upper triangular band
   *          matrix with KL+KU superdiagonals in rows 1 to KL+KU+1, and
   *          the multipliers used during the factorization are stored in
   *          rows KL+KU+2 to 2*KL+KU+1.
   *
   *  LDAB    (input) INTEGER
   *          The leading dimension of the array AB.  LDAB >= 2*KL+KU+1.
   *
   *  IPIV    (input) INTEGER array, dimension (N)
   *          The pivot indices; for 1 <= i <= N, row i of the matrix was
   *          interchanged with row IPIV(i).
   *
   *  ANORM   (input) DOUBLE PRECISION
   *          If NORM = '1' or 'O', the 1-norm of the original matrix A.
   *          If NORM = 'I', the infinity-norm of the original matrix A.
   *
   *  RCOND   (output) DOUBLE PRECISION
   *          The reciprocal of the condition number of the matrix A,
   *          computed as RCOND = 1/(norm(A) * norm(inv(A))).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)
   *
   *  IWORK   (workspace) INTEGER array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param norm
   * @param n
   * @param kl
   * @param ku
   * @param ab
   * @param _ab_offset
   * @param ldab
   * @param ipiv
   * @param _ipiv_offset
   * @param anorm
   * @param rcond
   * @param work
   * @param _work_offset
   * @param iwork
   * @param _iwork_offset
   * @param info
   * 
   */
  abstract public void dgbcon(java.lang.String norm, int n, int kl, int ku, double[] ab, int _ab_offset, int ldab, int[] ipiv, int _ipiv_offset, double anorm, org.netlib.util.doubleW rcond, double[] work, int _work_offset, int[] iwork, int _iwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGBEQU computes row and column scalings intended to equilibrate an
   *  M-by-N band matrix A and reduce its condition number.  R returns the
   *  row scale factors and C the column scale factors, chosen to try to
   *  make the largest element in each row and column of the matrix B with
   *  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.
   *
   *  R(i) and C(j) are restricted to be between SMLNUM = smallest safe
   *  number and BIGNUM = largest safe number.  Use of these scaling
   *  factors is not guaranteed to reduce the condition number of A but
   *  works well in practice.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  KL      (input) INTEGER
   *          The number of subdiagonals within the band of A.  KL >= 0.
   *
   *  KU      (input) INTEGER
   *          The number of superdiagonals within the band of A.  KU >= 0.
   *
   *  AB      (input) DOUBLE PRECISION array, dimension (LDAB,N)
   *          The band matrix A, stored in rows 1 to KL+KU+1.  The j-th
   *          column of A is stored in the j-th column of the array AB as
   *          follows:
   *          AB(ku+1+i-j,j) = A(i,j) for max(1,j-ku)<=i<=min(m,j+kl).
   *
   *  LDAB    (input) INTEGER
   *          The leading dimension of the array AB.  LDAB >= KL+KU+1.
   *
   *  R       (output) DOUBLE PRECISION array, dimension (M)
   *          If INFO = 0, or INFO > M, R contains the row scale factors
   *          for A.
   *
   *  C       (output) DOUBLE PRECISION array, dimension (N)
   *          If INFO = 0, C contains the column scale factors for A.
   *
   *  ROWCND  (output) DOUBLE PRECISION
   *          If INFO = 0 or INFO > M, ROWCND contains the ratio of the
   *          smallest R(i) to the largest R(i).  If ROWCND >= 0.1 and
   *          AMAX is neither too large nor too small, it is not worth
   *          scaling by R.
   *
   *  COLCND  (output) DOUBLE PRECISION
   *          If INFO = 0, COLCND contains the ratio of the smallest
   *          C(i) to the largest C(i).  If COLCND >= 0.1, it is not
   *          worth scaling by C.
   *
   *  AMAX    (output) DOUBLE PRECISION
   *          Absolute value of largest matrix element.  If AMAX is very
   *          close to overflow or very close to underflow, the matrix
   *          should be scaled.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO = i, and i is
   *                <= M:  the i-th row of A is exactly zero
   *                >  M:  the (i-M)-th column of A is exactly zero
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param kl
   * @param ku
   * @param ab
   * @param ldab
   * @param r
   * @param c
   * @param rowcnd
   * @param colcnd
   * @param amax
   * @param info
   * 
   */
  abstract public void dgbequ(int m, int n, int kl, int ku, double[] ab, int ldab, double[] r, double[] c, org.netlib.util.doubleW rowcnd, org.netlib.util.doubleW colcnd, org.netlib.util.doubleW amax, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGBEQU computes row and column scalings intended to equilibrate an
   *  M-by-N band matrix A and reduce its condition number.  R returns the
   *  row scale factors and C the column scale factors, chosen to try to
   *  make the largest element in each row and column of the matrix B with
   *  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.
   *
   *  R(i) and C(j) are restricted to be between SMLNUM = smallest safe
   *  number and BIGNUM = largest safe number.  Use of these scaling
   *  factors is not guaranteed to reduce the condition number of A but
   *  works well in practice.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  KL      (input) INTEGER
   *          The number of subdiagonals within the band of A.  KL >= 0.
   *
   *  KU      (input) INTEGER
   *          The number of superdiagonals within the band of A.  KU >= 0.
   *
   *  AB      (input) DOUBLE PRECISION array, dimension (LDAB,N)
   *          The band matrix A, stored in rows 1 to KL+KU+1.  The j-th
   *          column of A is stored in the j-th column of the array AB as
   *          follows:
   *          AB(ku+1+i-j,j) = A(i,j) for max(1,j-ku)<=i<=min(m,j+kl).
   *
   *  LDAB    (input) INTEGER
   *          The leading dimension of the array AB.  LDAB >= KL+KU+1.
   *
   *  R       (output) DOUBLE PRECISION array, dimension (M)
   *          If INFO = 0, or INFO > M, R contains the row scale factors
   *          for A.
   *
   *  C       (output) DOUBLE PRECISION array, dimension (N)
   *          If INFO = 0, C contains the column scale factors for A.
   *
   *  ROWCND  (output) DOUBLE PRECISION
   *          If INFO = 0 or INFO > M, ROWCND contains the ratio of the
   *          smallest R(i) to the largest R(i).  If ROWCND >= 0.1 and
   *          AMAX is neither too large nor too small, it is not worth
   *          scaling by R.
   *
   *  COLCND  (output) DOUBLE PRECISION
   *          If INFO = 0, COLCND contains the ratio of the smallest
   *          C(i) to the largest C(i).  If COLCND >= 0.1, it is not
   *          worth scaling by C.
   *
   *  AMAX    (output) DOUBLE PRECISION
   *          Absolute value of largest matrix element.  If AMAX is very
   *          close to overflow or very close to underflow, the matrix
   *          should be scaled.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO = i, and i is
   *                <= M:  the i-th row of A is exactly zero
   *                >  M:  the (i-M)-th column of A is exactly zero
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param kl
   * @param ku
   * @param ab
   * @param _ab_offset
   * @param ldab
   * @param r
   * @param _r_offset
   * @param c
   * @param _c_offset
   * @param rowcnd
   * @param colcnd
   * @param amax
   * @param info
   * 
   */
  abstract public void dgbequ(int m, int n, int kl, int ku, double[] ab, int _ab_offset, int ldab, double[] r, int _r_offset, double[] c, int _c_offset, org.netlib.util.doubleW rowcnd, org.netlib.util.doubleW colcnd, org.netlib.util.doubleW amax, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGBRFS improves the computed solution to a system of linear
   *  equations when the coefficient matrix is banded, and provides
   *  error bounds and backward error estimates for the solution.
   *
   *  Arguments
   *  =========
   *
   *  TRANS   (input) CHARACTER*1
   *          Specifies the form of the system of equations:
   *          = 'N':  A * X = B     (No transpose)
   *          = 'T':  A**T * X = B  (Transpose)
   *          = 'C':  A**H * X = B  (Conjugate transpose = Transpose)
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  KL      (input) INTEGER
   *          The number of subdiagonals within the band of A.  KL >= 0.
   *
   *  KU      (input) INTEGER
   *          The number of superdiagonals within the band of A.  KU >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrices B and X.  NRHS >= 0.
   *
   *  AB      (input) DOUBLE PRECISION array, dimension (LDAB,N)
   *          The original band matrix A, stored in rows 1 to KL+KU+1.
   *          The j-th column of A is stored in the j-th column of the
   *          array AB as follows:
   *          AB(ku+1+i-j,j) = A(i,j) for max(1,j-ku)<=i<=min(n,j+kl).
   *
   *  LDAB    (input) INTEGER
   *          The leading dimension of the array AB.  LDAB >= KL+KU+1.
   *
   *  AFB     (input) DOUBLE PRECISION array, dimension (LDAFB,N)
   *          Details of the LU factorization of the band matrix A, as
   *          computed by DGBTRF.  U is stored as an upper triangular band
   *          matrix with KL+KU superdiagonals in rows 1 to KL+KU+1, and
   *          the multipliers used during the factorization are stored in
   *          rows KL+KU+2 to 2*KL+KU+1.
   *
   *  LDAFB   (input) INTEGER
   *          The leading dimension of the array AFB.  LDAFB >= 2*KL*KU+1.
   *
   *  IPIV    (input) INTEGER array, dimension (N)
   *          The pivot indices from DGBTRF; for 1<=i<=N, row i of the
   *          matrix was interchanged with row IPIV(i).
   *
   *  B       (input) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          The right hand side matrix B.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  X       (input/output) DOUBLE PRECISION array, dimension (LDX,NRHS)
   *          On entry, the solution matrix X, as computed by DGBTRS.
   *          On exit, the improved solution matrix X.
   *
   *  LDX     (input) INTEGER
   *          The leading dimension of the array X.  LDX >= max(1,N).
   *
   *  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The estimated forward error bound for each solution vector
   *          X(j) (the j-th column of the solution matrix X).
   *          If XTRUE is the true solution corresponding to X(j), FERR(j)
   *          is an estimated upper bound for the magnitude of the largest
   *          element in (X(j) - XTRUE) divided by the magnitude of the
   *          largest element in X(j).  The estimate is as reliable as
   *          the estimate for RCOND, and is almost always a slight
   *          overestimate of the true error.
   *
   *  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The componentwise relative backward error of each solution
   *          vector X(j) (i.e., the smallest relative change in
   *          any element of A or B that makes X(j) an exact solution).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)
   *
   *  IWORK   (workspace) INTEGER array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  Internal Parameters
   *  ===================
   *
   *  ITMAX is the maximum number of steps of iterative refinement.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param n
   * @param kl
   * @param ku
   * @param nrhs
   * @param ab
   * @param ldab
   * @param afb
   * @param ldafb
   * @param ipiv
   * @param b
   * @param ldb
   * @param x
   * @param ldx
   * @param ferr
   * @param berr
   * @param work
   * @param iwork
   * @param info
   * 
   */
  abstract public void dgbrfs(java.lang.String trans, int n, int kl, int ku, int nrhs, double[] ab, int ldab, double[] afb, int ldafb, int[] ipiv, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGBRFS improves the computed solution to a system of linear
   *  equations when the coefficient matrix is banded, and provides
   *  error bounds and backward error estimates for the solution.
   *
   *  Arguments
   *  =========
   *
   *  TRANS   (input) CHARACTER*1
   *          Specifies the form of the system of equations:
   *          = 'N':  A * X = B     (No transpose)
   *          = 'T':  A**T * X = B  (Transpose)
   *          = 'C':  A**H * X = B  (Conjugate transpose = Transpose)
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  KL      (input) INTEGER
   *          The number of subdiagonals within the band of A.  KL >= 0.
   *
   *  KU      (input) INTEGER
   *          The number of superdiagonals within the band of A.  KU >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrices B and X.  NRHS >= 0.
   *
   *  AB      (input) DOUBLE PRECISION array, dimension (LDAB,N)
   *          The original band matrix A, stored in rows 1 to KL+KU+1.
   *          The j-th column of A is stored in the j-th column of the
   *          array AB as follows:
   *          AB(ku+1+i-j,j) = A(i,j) for max(1,j-ku)<=i<=min(n,j+kl).
   *
   *  LDAB    (input) INTEGER
   *          The leading dimension of the array AB.  LDAB >= KL+KU+1.
   *
   *  AFB     (input) DOUBLE PRECISION array, dimension (LDAFB,N)
   *          Details of the LU factorization of the band matrix A, as
   *          computed by DGBTRF.  U is stored as an upper triangular band
   *          matrix with KL+KU superdiagonals in rows 1 to KL+KU+1, and
   *          the multipliers used during the factorization are stored in
   *          rows KL+KU+2 to 2*KL+KU+1.
   *
   *  LDAFB   (input) INTEGER
   *          The leading dimension of the array AFB.  LDAFB >= 2*KL*KU+1.
   *
   *  IPIV    (input) INTEGER array, dimension (N)
   *          The pivot indices from DGBTRF; for 1<=i<=N, row i of the
   *          matrix was interchanged with row IPIV(i).
   *
   *  B       (input) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          The right hand side matrix B.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  X       (input/output) DOUBLE PRECISION array, dimension (LDX,NRHS)
   *          On entry, the solution matrix X, as computed by DGBTRS.
   *          On exit, the improved solution matrix X.
   *
   *  LDX     (input) INTEGER
   *          The leading dimension of the array X.  LDX >= max(1,N).
   *
   *  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The estimated forward error bound for each solution vector
   *          X(j) (the j-th column of the solution matrix X).
   *          If XTRUE is the true solution corresponding to X(j), FERR(j)
   *          is an estimated upper bound for the magnitude of the largest
   *          element in (X(j) - XTRUE) divided by the magnitude of the
   *          largest element in X(j).  The estimate is as reliable as
   *          the estimate for RCOND, and is almost always a slight
   *          overestimate of the true error.
   *
   *  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The componentwise relative backward error of each solution
   *          vector X(j) (i.e., the smallest relative change in
   *          any element of A or B that makes X(j) an exact solution).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)
   *
   *  IWORK   (workspace) INTEGER array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  Internal Parameters
   *  ===================
   *
   *  ITMAX is the maximum number of steps of iterative refinement.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param n
   * @param kl
   * @param ku
   * @param nrhs
   * @param ab
   * @param _ab_offset
   * @param ldab
   * @param afb
   * @param _afb_offset
   * @param ldafb
   * @param ipiv
   * @param _ipiv_offset
   * @param b
   * @param _b_offset
   * @param ldb
   * @param x
   * @param _x_offset
   * @param ldx
   * @param ferr
   * @param _ferr_offset
   * @param berr
   * @param _berr_offset
   * @param work
   * @param _work_offset
   * @param iwork
   * @param _iwork_offset
   * @param info
   * 
   */
  abstract public void dgbrfs(java.lang.String trans, int n, int kl, int ku, int nrhs, double[] ab, int _ab_offset, int ldab, double[] afb, int _afb_offset, int ldafb, int[] ipiv, int _ipiv_offset, double[] b, int _b_offset, int ldb, double[] x, int _x_offset, int ldx, double[] ferr, int _ferr_offset, double[] berr, int _berr_offset, double[] work, int _work_offset, int[] iwork, int _iwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGBSV computes the solution to a real system of linear equations
   *  A * X = B, where A is a band matrix of order N with KL subdiagonals
   *  and KU superdiagonals, and X and B are N-by-NRHS matrices.
   *
   *  The LU decomposition with partial pivoting and row interchanges is
   *  used to factor A as A = L * U, where L is a product of permutation
   *  and unit lower triangular matrices with KL subdiagonals, and U is
   *  upper triangular with KL+KU superdiagonals.  The factored form of A
   *  is then used to solve the system of equations A * X = B.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The number of linear equations, i.e., the order of the
   *          matrix A.  N >= 0.
   *
   *  KL      (input) INTEGER
   *          The number of subdiagonals within the band of A.  KL >= 0.
   *
   *  KU      (input) INTEGER
   *          The number of superdiagonals within the band of A.  KU >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrix B.  NRHS >= 0.
   *
   *  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
   *          On entry, the matrix A in band storage, in rows KL+1 to
   *          2*KL+KU+1; rows 1 to KL of the array need not be set.
   *          The j-th column of A is stored in the j-th column of the
   *          array AB as follows:
   *          AB(KL+KU+1+i-j,j) = A(i,j) for max(1,j-KU)<=i<=min(N,j+KL)
   *          On exit, details of the factorization: U is stored as an
   *          upper triangular band matrix with KL+KU superdiagonals in
   *          rows 1 to KL+KU+1, and the multipliers used during the
   *          factorization are stored in rows KL+KU+2 to 2*KL+KU+1.
   *          See below for further details.
   *
   *  LDAB    (input) INTEGER
   *          The leading dimension of the array AB.  LDAB >= 2*KL+KU+1.
   *
   *  IPIV    (output) INTEGER array, dimension (N)
   *          The pivot indices that define the permutation matrix P;
   *          row i of the matrix was interchanged with row IPIV(i).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the N-by-NRHS right hand side matrix B.
   *          On exit, if INFO = 0, the N-by-NRHS solution matrix X.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO = i, U(i,i) is exactly zero.  The factorization
   *                has been completed, but the factor U is exactly
   *                singular, and the solution has not been computed.
   *
   *  Further Details
   *  ===============
   *
   *  The band storage scheme is illustrated by the following example, when
   *  M = N = 6, KL = 2, KU = 1:
   *
   *  On entry:                       On exit:
   *
   *      *    *    *    +    +    +       *    *    *   u14  u25  u36
   *      *    *    +    +    +    +       *    *   u13  u24  u35  u46
   *      *   a12  a23  a34  a45  a56      *   u12  u23  u34  u45  u56
   *     a11  a22  a33  a44  a55  a66     u11  u22  u33  u44  u55  u66
   *     a21  a32  a43  a54  a65   *      m21  m32  m43  m54  m65   *
   *     a31  a42  a53  a64   *    *      m31  m42  m53  m64   *    *
   *
   *  Array elements marked * are not used by the routine; elements marked
   *  + need not be set on entry, but are required by the routine to store
   *  elements of U because of fill-in resulting from the row interchanges.
   *
   *  =====================================================================
   *
   *     .. External Subroutines ..
   * </code></pre>
   *
   * @param n
   * @param kl
   * @param ku
   * @param nrhs
   * @param ab
   * @param ldab
   * @param ipiv
   * @param b
   * @param ldb
   * @param info
   * 
   */
  abstract public void dgbsv(int n, int kl, int ku, int nrhs, double[] ab, int ldab, int[] ipiv, double[] b, int ldb, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGBSV computes the solution to a real system of linear equations
   *  A * X = B, where A is a band matrix of order N with KL subdiagonals
   *  and KU superdiagonals, and X and B are N-by-NRHS matrices.
   *
   *  The LU decomposition with partial pivoting and row interchanges is
   *  used to factor A as A = L * U, where L is a product of permutation
   *  and unit lower triangular matrices with KL subdiagonals, and U is
   *  upper triangular with KL+KU superdiagonals.  The factored form of A
   *  is then used to solve the system of equations A * X = B.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The number of linear equations, i.e., the order of the
   *          matrix A.  N >= 0.
   *
   *  KL      (input) INTEGER
   *          The number of subdiagonals within the band of A.  KL >= 0.
   *
   *  KU      (input) INTEGER
   *          The number of superdiagonals within the band of A.  KU >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrix B.  NRHS >= 0.
   *
   *  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
   *          On entry, the matrix A in band storage, in rows KL+1 to
   *          2*KL+KU+1; rows 1 to KL of the array need not be set.
   *          The j-th column of A is stored in the j-th column of the
   *          array AB as follows:
   *          AB(KL+KU+1+i-j,j) = A(i,j) for max(1,j-KU)<=i<=min(N,j+KL)
   *          On exit, details of the factorization: U is stored as an
   *          upper triangular band matrix with KL+KU superdiagonals in
   *          rows 1 to KL+KU+1, and the multipliers used during the
   *          factorization are stored in rows KL+KU+2 to 2*KL+KU+1.
   *          See below for further details.
   *
   *  LDAB    (input) INTEGER
   *          The leading dimension of the array AB.  LDAB >= 2*KL+KU+1.
   *
   *  IPIV    (output) INTEGER array, dimension (N)
   *          The pivot indices that define the permutation matrix P;
   *          row i of the matrix was interchanged with row IPIV(i).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the N-by-NRHS right hand side matrix B.
   *          On exit, if INFO = 0, the N-by-NRHS solution matrix X.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO = i, U(i,i) is exactly zero.  The factorization
   *                has been completed, but the factor U is exactly
   *                singular, and the solution has not been computed.
   *
   *  Further Details
   *  ===============
   *
   *  The band storage scheme is illustrated by the following example, when
   *  M = N = 6, KL = 2, KU = 1:
   *
   *  On entry:                       On exit:
   *
   *      *    *    *    +    +    +       *    *    *   u14  u25  u36
   *      *    *    +    +    +    +       *    *   u13  u24  u35  u46
   *      *   a12  a23  a34  a45  a56      *   u12  u23  u34  u45  u56
   *     a11  a22  a33  a44  a55  a66     u11  u22  u33  u44  u55  u66
   *     a21  a32  a43  a54  a65   *      m21  m32  m43  m54  m65   *
   *     a31  a42  a53  a64   *    *      m31  m42  m53  m64   *    *
   *
   *  Array elements marked * are not used by the routine; elements marked
   *  + need not be set on entry, but are required by the routine to store
   *  elements of U because of fill-in resulting from the row interchanges.
   *
   *  =====================================================================
   *
   *     .. External Subroutines ..
   * </code></pre>
   *
   * @param n
   * @param kl
   * @param ku
   * @param nrhs
   * @param ab
   * @param _ab_offset
   * @param ldab
   * @param ipiv
   * @param _ipiv_offset
   * @param b
   * @param _b_offset
   * @param ldb
   * @param info
   * 
   */
  abstract public void dgbsv(int n, int kl, int ku, int nrhs, double[] ab, int _ab_offset, int ldab, int[] ipiv, int _ipiv_offset, double[] b, int _b_offset, int ldb, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGBSVX uses the LU factorization to compute the solution to a real
   *  system of linear equations A * X = B, A**T * X = B, or A**H * X = B,
   *  where A is a band matrix of order N with KL subdiagonals and KU
   *  superdiagonals, and X and B are N-by-NRHS matrices.
   *
   *  Error bounds on the solution and a condition estimate are also
   *  provided.
   *
   *  Description
   *  ===========
   *
   *  The following steps are performed by this subroutine:
   *
   *  1. If FACT = 'E', real scaling factors are computed to equilibrate
   *     the system:
   *        TRANS = 'N':  diag(R)*A*diag(C)     *inv(diag(C))*X = diag(R)*B
   *        TRANS = 'T': (diag(R)*A*diag(C))**T *inv(diag(R))*X = diag(C)*B
   *        TRANS = 'C': (diag(R)*A*diag(C))**H *inv(diag(R))*X = diag(C)*B
   *     Whether or not the system will be equilibrated depends on the
   *     scaling of the matrix A, but if equilibration is used, A is
   *     overwritten by diag(R)*A*diag(C) and B by diag(R)*B (if TRANS='N')
   *     or diag(C)*B (if TRANS = 'T' or 'C').
   *
   *  2. If FACT = 'N' or 'E', the LU decomposition is used to factor the
   *     matrix A (after equilibration if FACT = 'E') as
   *        A = L * U,
   *     where L is a product of permutation and unit lower triangular
   *     matrices with KL subdiagonals, and U is upper triangular with
   *     KL+KU superdiagonals.
   *
   *  3. If some U(i,i)=0, so that U is exactly singular, then the routine
   *     returns with INFO = i. Otherwise, the factored form of A is used
   *     to estimate the condition number of the matrix A.  If the
   *     reciprocal of the condition number is less than machine precision,
   *     INFO = N+1 is returned as a warning, but the routine still goes on
   *     to solve for X and compute error bounds as described below.
   *
   *  4. The system of equations is solved for X using the factored form
   *     of A.
   *
   *  5. Iterative refinement is applied to improve the computed solution
   *     matrix and calculate error bounds and backward error estimates
   *     for it.
   *
   *  6. If equilibration was used, the matrix X is premultiplied by
   *     diag(C) (if TRANS = 'N') or diag(R) (if TRANS = 'T' or 'C') so
   *     that it solves the original system before equilibration.
   *
   *  Arguments
   *  =========
   *
   *  FACT    (input) CHARACTER*1
   *          Specifies whether or not the factored form of the matrix A is
   *          supplied on entry, and if not, whether the matrix A should be
   *          equilibrated before it is factored.
   *          = 'F':  On entry, AFB and IPIV contain the factored form of
   *                  A.  If EQUED is not 'N', the matrix A has been
   *                  equilibrated with scaling factors given by R and C.
   *                  AB, AFB, and IPIV are not modified.
   *          = 'N':  The matrix A will be copied to AFB and factored.
   *          = 'E':  The matrix A will be equilibrated if necessary, then
   *                  copied to AFB and factored.
   *
   *  TRANS   (input) CHARACTER*1
   *          Specifies the form of the system of equations.
   *          = 'N':  A * X = B     (No transpose)
   *          = 'T':  A**T * X = B  (Transpose)
   *          = 'C':  A**H * X = B  (Transpose)
   *
   *  N       (input) INTEGER
   *          The number of linear equations, i.e., the order of the
   *          matrix A.  N >= 0.
   *
   *  KL      (input) INTEGER
   *          The number of subdiagonals within the band of A.  KL >= 0.
   *
   *  KU      (input) INTEGER
   *          The number of superdiagonals within the band of A.  KU >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrices B and X.  NRHS >= 0.
   *
   *  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
   *          On entry, the matrix A in band storage, in rows 1 to KL+KU+1.
   *          The j-th column of A is stored in the j-th column of the
   *          array AB as follows:
   *          AB(KU+1+i-j,j) = A(i,j) for max(1,j-KU)<=i<=min(N,j+kl)
   *
   *          If FACT = 'F' and EQUED is not 'N', then A must have been
   *          equilibrated by the scaling factors in R and/or C.  AB is not
   *          modified if FACT = 'F' or 'N', or if FACT = 'E' and
   *          EQUED = 'N' on exit.
   *
   *          On exit, if EQUED .ne. 'N', A is scaled as follows:
   *          EQUED = 'R':  A := diag(R) * A
   *          EQUED = 'C':  A := A * diag(C)
   *          EQUED = 'B':  A := diag(R) * A * diag(C).
   *
   *  LDAB    (input) INTEGER
   *          The leading dimension of the array AB.  LDAB >= KL+KU+1.
   *
   *  AFB     (input or output) DOUBLE PRECISION array, dimension (LDAFB,N)
   *          If FACT = 'F', then AFB is an input argument and on entry
   *          contains details of the LU factorization of the band matrix
   *          A, as computed by DGBTRF.  U is stored as an upper triangular
   *          band matrix with KL+KU superdiagonals in rows 1 to KL+KU+1,
   *          and the multipliers used during the factorization are stored
   *          in rows KL+KU+2 to 2*KL+KU+1.  If EQUED .ne. 'N', then AFB is
   *          the factored form of the equilibrated matrix A.
   *
   *          If FACT = 'N', then AFB is an output argument and on exit
   *          returns details of the LU factorization of A.
   *
   *          If FACT = 'E', then AFB is an output argument and on exit
   *          returns details of the LU factorization of the equilibrated
   *          matrix A (see the description of AB for the form of the
   *          equilibrated matrix).
   *
   *  LDAFB   (input) INTEGER
   *          The leading dimension of the array AFB.  LDAFB >= 2*KL+KU+1.
   *
   *  IPIV    (input or output) INTEGER array, dimension (N)
   *          If FACT = 'F', then IPIV is an input argument and on entry
   *          contains the pivot indices from the factorization A = L*U
   *          as computed by DGBTRF; row i of the matrix was interchanged
   *          with row IPIV(i).
   *
   *          If FACT = 'N', then IPIV is an output argument and on exit
   *          contains the pivot indices from the factorization A = L*U
   *          of the original matrix A.
   *
   *          If FACT = 'E', then IPIV is an output argument and on exit
   *          contains the pivot indices from the factorization A = L*U
   *          of the equilibrated matrix A.
   *
   *  EQUED   (input or output) CHARACTER*1
   *          Specifies the form of equilibration that was done.
   *          = 'N':  No equilibration (always true if FACT = 'N').
   *          = 'R':  Row equilibration, i.e., A has been premultiplied by
   *                  diag(R).
   *          = 'C':  Column equilibration, i.e., A has been postmultiplied
   *                  by diag(C).
   *          = 'B':  Both row and column equilibration, i.e., A has been
   *                  replaced by diag(R) * A * diag(C).
   *          EQUED is an input argument if FACT = 'F'; otherwise, it is an
   *          output argument.
   *
   *  R       (input or output) DOUBLE PRECISION array, dimension (N)
   *          The row scale factors for A.  If EQUED = 'R' or 'B', A is
   *          multiplied on the left by diag(R); if EQUED = 'N' or 'C', R
   *          is not accessed.  R is an input argument if FACT = 'F';
   *          otherwise, R is an output argument.  If FACT = 'F' and
   *          EQUED = 'R' or 'B', each element of R must be positive.
   *
   *  C       (input or output) DOUBLE PRECISION array, dimension (N)
   *          The column scale factors for A.  If EQUED = 'C' or 'B', A is
   *          multiplied on the right by diag(C); if EQUED = 'N' or 'R', C
   *          is not accessed.  C is an input argument if FACT = 'F';
   *          otherwise, C is an output argument.  If FACT = 'F' and
   *          EQUED = 'C' or 'B', each element of C must be positive.
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the right hand side matrix B.
   *          On exit,
   *          if EQUED = 'N', B is not modified;
   *          if TRANS = 'N' and EQUED = 'R' or 'B', B is overwritten by
   *          diag(R)*B;
   *          if TRANS = 'T' or 'C' and EQUED = 'C' or 'B', B is
   *          overwritten by diag(C)*B.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  X       (output) DOUBLE PRECISION array, dimension (LDX,NRHS)
   *          If INFO = 0 or INFO = N+1, the N-by-NRHS solution matrix X
   *          to the original system of equations.  Note that A and B are
   *          modified on exit if EQUED .ne. 'N', and the solution to the
   *          equilibrated system is inv(diag(C))*X if TRANS = 'N' and
   *          EQUED = 'C' or 'B', or inv(diag(R))*X if TRANS = 'T' or 'C'
   *          and EQUED = 'R' or 'B'.
   *
   *  LDX     (input) INTEGER
   *          The leading dimension of the array X.  LDX >= max(1,N).
   *
   *  RCOND   (output) DOUBLE PRECISION
   *          The estimate of the reciprocal condition number of the matrix
   *          A after equilibration (if done).  If RCOND is less than the
   *          machine precision (in particular, if RCOND = 0), the matrix
   *          is singular to working precision.  This condition is
   *          indicated by a return code of INFO > 0.
   *
   *  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The estimated forward error bound for each solution vector
   *          X(j) (the j-th column of the solution matrix X).
   *          If XTRUE is the true solution corresponding to X(j), FERR(j)
   *          is an estimated upper bound for the magnitude of the largest
   *          element in (X(j) - XTRUE) divided by the magnitude of the
   *          largest element in X(j).  The estimate is as reliable as
   *          the estimate for RCOND, and is almost always a slight
   *          overestimate of the true error.
   *
   *  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The componentwise relative backward error of each solution
   *          vector X(j) (i.e., the smallest relative change in
   *          any element of A or B that makes X(j) an exact solution).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (3*N)
   *          On exit, WORK(1) contains the reciprocal pivot growth
   *          factor norm(A)/norm(U). The "max absolute element" norm is
   *          used. If WORK(1) is much less than 1, then the stability
   *          of the LU factorization of the (equilibrated) matrix A
   *          could be poor. This also means that the solution X, condition
   *          estimator RCOND, and forward error bound FERR could be
   *          unreliable. If factorization fails with 0<INFO<=N, then
   *          WORK(1) contains the reciprocal pivot growth factor for the
   *          leading INFO columns of A.
   *
   *  IWORK   (workspace) INTEGER array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO = i, and i is
   *                <= N:  U(i,i) is exactly zero.  The factorization
   *                       has been completed, but the factor U is exactly
   *                       singular, so the solution and error bounds
   *                       could not be computed. RCOND = 0 is returned.
   *                = N+1: U is nonsingular, but RCOND is less than machine
   *                       precision, meaning that the matrix is singular
   *                       to working precision.  Nevertheless, the
   *                       solution and error bounds are computed because
   *                       there are a number of situations where the
   *                       computed solution can be more accurate than the
   *                       value of RCOND would suggest.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param fact
   * @param trans
   * @param n
   * @param kl
   * @param ku
   * @param nrhs
   * @param ab
   * @param ldab
   * @param afb
   * @param ldafb
   * @param ipiv
   * @param equed
   * @param r
   * @param c
   * @param b
   * @param ldb
   * @param x
   * @param ldx
   * @param rcond
   * @param ferr
   * @param berr
   * @param work
   * @param iwork
   * @param info
   * 
   */
  abstract public void dgbsvx(java.lang.String fact, java.lang.String trans, int n, int kl, int ku, int nrhs, double[] ab, int ldab, double[] afb, int ldafb, int[] ipiv, org.netlib.util.StringW equed, double[] r, double[] c, double[] b, int ldb, double[] x, int ldx, org.netlib.util.doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGBSVX uses the LU factorization to compute the solution to a real
   *  system of linear equations A * X = B, A**T * X = B, or A**H * X = B,
   *  where A is a band matrix of order N with KL subdiagonals and KU
   *  superdiagonals, and X and B are N-by-NRHS matrices.
   *
   *  Error bounds on the solution and a condition estimate are also
   *  provided.
   *
   *  Description
   *  ===========
   *
   *  The following steps are performed by this subroutine:
   *
   *  1. If FACT = 'E', real scaling factors are computed to equilibrate
   *     the system:
   *        TRANS = 'N':  diag(R)*A*diag(C)     *inv(diag(C))*X = diag(R)*B
   *        TRANS = 'T': (diag(R)*A*diag(C))**T *inv(diag(R))*X = diag(C)*B
   *        TRANS = 'C': (diag(R)*A*diag(C))**H *inv(diag(R))*X = diag(C)*B
   *     Whether or not the system will be equilibrated depends on the
   *     scaling of the matrix A, but if equilibration is used, A is
   *     overwritten by diag(R)*A*diag(C) and B by diag(R)*B (if TRANS='N')
   *     or diag(C)*B (if TRANS = 'T' or 'C').
   *
   *  2. If FACT = 'N' or 'E', the LU decomposition is used to factor the
   *     matrix A (after equilibration if FACT = 'E') as
   *        A = L * U,
   *     where L is a product of permutation and unit lower triangular
   *     matrices with KL subdiagonals, and U is upper triangular with
   *     KL+KU superdiagonals.
   *
   *  3. If some U(i,i)=0, so that U is exactly singular, then the routine
   *     returns with INFO = i. Otherwise, the factored form of A is used
   *     to estimate the condition number of the matrix A.  If the
   *     reciprocal of the condition number is less than machine precision,
   *     INFO = N+1 is returned as a warning, but the routine still goes on
   *     to solve for X and compute error bounds as described below.
   *
   *  4. The system of equations is solved for X using the factored form
   *     of A.
   *
   *  5. Iterative refinement is applied to improve the computed solution
   *     matrix and calculate error bounds and backward error estimates
   *     for it.
   *
   *  6. If equilibration was used, the matrix X is premultiplied by
   *     diag(C) (if TRANS = 'N') or diag(R) (if TRANS = 'T' or 'C') so
   *     that it solves the original system before equilibration.
   *
   *  Arguments
   *  =========
   *
   *  FACT    (input) CHARACTER*1
   *          Specifies whether or not the factored form of the matrix A is
   *          supplied on entry, and if not, whether the matrix A should be
   *          equilibrated before it is factored.
   *          = 'F':  On entry, AFB and IPIV contain the factored form of
   *                  A.  If EQUED is not 'N', the matrix A has been
   *                  equilibrated with scaling factors given by R and C.
   *                  AB, AFB, and IPIV are not modified.
   *          = 'N':  The matrix A will be copied to AFB and factored.
   *          = 'E':  The matrix A will be equilibrated if necessary, then
   *                  copied to AFB and factored.
   *
   *  TRANS   (input) CHARACTER*1
   *          Specifies the form of the system of equations.
   *          = 'N':  A * X = B     (No transpose)
   *          = 'T':  A**T * X = B  (Transpose)
   *          = 'C':  A**H * X = B  (Transpose)
   *
   *  N       (input) INTEGER
   *          The number of linear equations, i.e., the order of the
   *          matrix A.  N >= 0.
   *
   *  KL      (input) INTEGER
   *          The number of subdiagonals within the band of A.  KL >= 0.
   *
   *  KU      (input) INTEGER
   *          The number of superdiagonals within the band of A.  KU >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrices B and X.  NRHS >= 0.
   *
   *  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
   *          On entry, the matrix A in band storage, in rows 1 to KL+KU+1.
   *          The j-th column of A is stored in the j-th column of the
   *          array AB as follows:
   *          AB(KU+1+i-j,j) = A(i,j) for max(1,j-KU)<=i<=min(N,j+kl)
   *
   *          If FACT = 'F' and EQUED is not 'N', then A must have been
   *          equilibrated by the scaling factors in R and/or C.  AB is not
   *          modified if FACT = 'F' or 'N', or if FACT = 'E' and
   *          EQUED = 'N' on exit.
   *
   *          On exit, if EQUED .ne. 'N', A is scaled as follows:
   *          EQUED = 'R':  A := diag(R) * A
   *          EQUED = 'C':  A := A * diag(C)
   *          EQUED = 'B':  A := diag(R) * A * diag(C).
   *
   *  LDAB    (input) INTEGER
   *          The leading dimension of the array AB.  LDAB >= KL+KU+1.
   *
   *  AFB     (input or output) DOUBLE PRECISION array, dimension (LDAFB,N)
   *          If FACT = 'F', then AFB is an input argument and on entry
   *          contains details of the LU factorization of the band matrix
   *          A, as computed by DGBTRF.  U is stored as an upper triangular
   *          band matrix with KL+KU superdiagonals in rows 1 to KL+KU+1,
   *          and the multipliers used during the factorization are stored
   *          in rows KL+KU+2 to 2*KL+KU+1.  If EQUED .ne. 'N', then AFB is
   *          the factored form of the equilibrated matrix A.
   *
   *          If FACT = 'N', then AFB is an output argument and on exit
   *          returns details of the LU factorization of A.
   *
   *          If FACT = 'E', then AFB is an output argument and on exit
   *          returns details of the LU factorization of the equilibrated
   *          matrix A (see the description of AB for the form of the
   *          equilibrated matrix).
   *
   *  LDAFB   (input) INTEGER
   *          The leading dimension of the array AFB.  LDAFB >= 2*KL+KU+1.
   *
   *  IPIV    (input or output) INTEGER array, dimension (N)
   *          If FACT = 'F', then IPIV is an input argument and on entry
   *          contains the pivot indices from the factorization A = L*U
   *          as computed by DGBTRF; row i of the matrix was interchanged
   *          with row IPIV(i).
   *
   *          If FACT = 'N', then IPIV is an output argument and on exit
   *          contains the pivot indices from the factorization A = L*U
   *          of the original matrix A.
   *
   *          If FACT = 'E', then IPIV is an output argument and on exit
   *          contains the pivot indices from the factorization A = L*U
   *          of the equilibrated matrix A.
   *
   *  EQUED   (input or output) CHARACTER*1
   *          Specifies the form of equilibration that was done.
   *          = 'N':  No equilibration (always true if FACT = 'N').
   *          = 'R':  Row equilibration, i.e., A has been premultiplied by
   *                  diag(R).
   *          = 'C':  Column equilibration, i.e., A has been postmultiplied
   *                  by diag(C).
   *          = 'B':  Both row and column equilibration, i.e., A has been
   *                  replaced by diag(R) * A * diag(C).
   *          EQUED is an input argument if FACT = 'F'; otherwise, it is an
   *          output argument.
   *
   *  R       (input or output) DOUBLE PRECISION array, dimension (N)
   *          The row scale factors for A.  If EQUED = 'R' or 'B', A is
   *          multiplied on the left by diag(R); if EQUED = 'N' or 'C', R
   *          is not accessed.  R is an input argument if FACT = 'F';
   *          otherwise, R is an output argument.  If FACT = 'F' and
   *          EQUED = 'R' or 'B', each element of R must be positive.
   *
   *  C       (input or output) DOUBLE PRECISION array, dimension (N)
   *          The column scale factors for A.  If EQUED = 'C' or 'B', A is
   *          multiplied on the right by diag(C); if EQUED = 'N' or 'R', C
   *          is not accessed.  C is an input argument if FACT = 'F';
   *          otherwise, C is an output argument.  If FACT = 'F' and
   *          EQUED = 'C' or 'B', each element of C must be positive.
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the right hand side matrix B.
   *          On exit,
   *          if EQUED = 'N', B is not modified;
   *          if TRANS = 'N' and EQUED = 'R' or 'B', B is overwritten by
   *          diag(R)*B;
   *          if TRANS = 'T' or 'C' and EQUED = 'C' or 'B', B is
   *          overwritten by diag(C)*B.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  X       (output) DOUBLE PRECISION array, dimension (LDX,NRHS)
   *          If INFO = 0 or INFO = N+1, the N-by-NRHS solution matrix X
   *          to the original system of equations.  Note that A and B are
   *          modified on exit if EQUED .ne. 'N', and the solution to the
   *          equilibrated system is inv(diag(C))*X if TRANS = 'N' and
   *          EQUED = 'C' or 'B', or inv(diag(R))*X if TRANS = 'T' or 'C'
   *          and EQUED = 'R' or 'B'.
   *
   *  LDX     (input) INTEGER
   *          The leading dimension of the array X.  LDX >= max(1,N).
   *
   *  RCOND   (output) DOUBLE PRECISION
   *          The estimate of the reciprocal condition number of the matrix
   *          A after equilibration (if done).  If RCOND is less than the
   *          machine precision (in particular, if RCOND = 0), the matrix
   *          is singular to working precision.  This condition is
   *          indicated by a return code of INFO > 0.
   *
   *  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The estimated forward error bound for each solution vector
   *          X(j) (the j-th column of the solution matrix X).
   *          If XTRUE is the true solution corresponding to X(j), FERR(j)
   *          is an estimated upper bound for the magnitude of the largest
   *          element in (X(j) - XTRUE) divided by the magnitude of the
   *          largest element in X(j).  The estimate is as reliable as
   *          the estimate for RCOND, and is almost always a slight
   *          overestimate of the true error.
   *
   *  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The componentwise relative backward error of each solution
   *          vector X(j) (i.e., the smallest relative change in
   *          any element of A or B that makes X(j) an exact solution).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (3*N)
   *          On exit, WORK(1) contains the reciprocal pivot growth
   *          factor norm(A)/norm(U). The "max absolute element" norm is
   *          used. If WORK(1) is much less than 1, then the stability
   *          of the LU factorization of the (equilibrated) matrix A
   *          could be poor. This also means that the solution X, condition
   *          estimator RCOND, and forward error bound FERR could be
   *          unreliable. If factorization fails with 0<INFO<=N, then
   *          WORK(1) contains the reciprocal pivot growth factor for the
   *          leading INFO columns of A.
   *
   *  IWORK   (workspace) INTEGER array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO = i, and i is
   *                <= N:  U(i,i) is exactly zero.  The factorization
   *                       has been completed, but the factor U is exactly
   *                       singular, so the solution and error bounds
   *                       could not be computed. RCOND = 0 is returned.
   *                = N+1: U is nonsingular, but RCOND is less than machine
   *                       precision, meaning that the matrix is singular
   *                       to working precision.  Nevertheless, the
   *                       solution and error bounds are computed because
   *                       there are a number of situations where the
   *                       computed solution can be more accurate than the
   *                       value of RCOND would suggest.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param fact
   * @param trans
   * @param n
   * @param kl
   * @param ku
   * @param nrhs
   * @param ab
   * @param _ab_offset
   * @param ldab
   * @param afb
   * @param _afb_offset
   * @param ldafb
   * @param ipiv
   * @param _ipiv_offset
   * @param equed
   * @param r
   * @param _r_offset
   * @param c
   * @param _c_offset
   * @param b
   * @param _b_offset
   * @param ldb
   * @param x
   * @param _x_offset
   * @param ldx
   * @param rcond
   * @param ferr
   * @param _ferr_offset
   * @param berr
   * @param _berr_offset
   * @param work
   * @param _work_offset
   * @param iwork
   * @param _iwork_offset
   * @param info
   * 
   */
  abstract public void dgbsvx(java.lang.String fact, java.lang.String trans, int n, int kl, int ku, int nrhs, double[] ab, int _ab_offset, int ldab, double[] afb, int _afb_offset, int ldafb, int[] ipiv, int _ipiv_offset, org.netlib.util.StringW equed, double[] r, int _r_offset, double[] c, int _c_offset, double[] b, int _b_offset, int ldb, double[] x, int _x_offset, int ldx, org.netlib.util.doubleW rcond, double[] ferr, int _ferr_offset, double[] berr, int _berr_offset, double[] work, int _work_offset, int[] iwork, int _iwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGBTF2 computes an LU factorization of a real m-by-n band matrix A
   *  using partial pivoting with row interchanges.
   *
   *  This is the unblocked version of the algorithm, calling Level 2 BLAS.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  KL      (input) INTEGER
   *          The number of subdiagonals within the band of A.  KL >= 0.
   *
   *  KU      (input) INTEGER
   *          The number of superdiagonals within the band of A.  KU >= 0.
   *
   *  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
   *          On entry, the matrix A in band storage, in rows KL+1 to
   *          2*KL+KU+1; rows 1 to KL of the array need not be set.
   *          The j-th column of A is stored in the j-th column of the
   *          array AB as follows:
   *          AB(kl+ku+1+i-j,j) = A(i,j) for max(1,j-ku)<=i<=min(m,j+kl)
   *
   *          On exit, details of the factorization: U is stored as an
   *          upper triangular band matrix with KL+KU superdiagonals in
   *          rows 1 to KL+KU+1, and the multipliers used during the
   *          factorization are stored in rows KL+KU+2 to 2*KL+KU+1.
   *          See below for further details.
   *
   *  LDAB    (input) INTEGER
   *          The leading dimension of the array AB.  LDAB >= 2*KL+KU+1.
   *
   *  IPIV    (output) INTEGER array, dimension (min(M,N))
   *          The pivot indices; for 1 <= i <= min(M,N), row i of the
   *          matrix was interchanged with row IPIV(i).
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value
   *          > 0: if INFO = +i, U(i,i) is exactly zero. The factorization
   *               has been completed, but the factor U is exactly
   *               singular, and division by zero will occur if it is used
   *               to solve a system of equations.
   *
   *  Further Details
   *  ===============
   *
   *  The band storage scheme is illustrated by the following example, when
   *  M = N = 6, KL = 2, KU = 1:
   *
   *  On entry:                       On exit:
   *
   *      *    *    *    +    +    +       *    *    *   u14  u25  u36
   *      *    *    +    +    +    +       *    *   u13  u24  u35  u46
   *      *   a12  a23  a34  a45  a56      *   u12  u23  u34  u45  u56
   *     a11  a22  a33  a44  a55  a66     u11  u22  u33  u44  u55  u66
   *     a21  a32  a43  a54  a65   *      m21  m32  m43  m54  m65   *
   *     a31  a42  a53  a64   *    *      m31  m42  m53  m64   *    *
   *
   *  Array elements marked * are not used by the routine; elements marked
   *  + need not be set on entry, but are required by the routine to store
   *  elements of U, because of fill-in resulting from the row
   *  interchanges.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param kl
   * @param ku
   * @param ab
   * @param ldab
   * @param ipiv
   * @param info
   * 
   */
  abstract public void dgbtf2(int m, int n, int kl, int ku, double[] ab, int ldab, int[] ipiv, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGBTF2 computes an LU factorization of a real m-by-n band matrix A
   *  using partial pivoting with row interchanges.
   *
   *  This is the unblocked version of the algorithm, calling Level 2 BLAS.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  KL      (input) INTEGER
   *          The number of subdiagonals within the band of A.  KL >= 0.
   *
   *  KU      (input) INTEGER
   *          The number of superdiagonals within the band of A.  KU >= 0.
   *
   *  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
   *          On entry, the matrix A in band storage, in rows KL+1 to
   *          2*KL+KU+1; rows 1 to KL of the array need not be set.
   *          The j-th column of A is stored in the j-th column of the
   *          array AB as follows:
   *          AB(kl+ku+1+i-j,j) = A(i,j) for max(1,j-ku)<=i<=min(m,j+kl)
   *
   *          On exit, details of the factorization: U is stored as an
   *          upper triangular band matrix with KL+KU superdiagonals in
   *          rows 1 to KL+KU+1, and the multipliers used during the
   *          factorization are stored in rows KL+KU+2 to 2*KL+KU+1.
   *          See below for further details.
   *
   *  LDAB    (input) INTEGER
   *          The leading dimension of the array AB.  LDAB >= 2*KL+KU+1.
   *
   *  IPIV    (output) INTEGER array, dimension (min(M,N))
   *          The pivot indices; for 1 <= i <= min(M,N), row i of the
   *          matrix was interchanged with row IPIV(i).
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value
   *          > 0: if INFO = +i, U(i,i) is exactly zero. The factorization
   *               has been completed, but the factor U is exactly
   *               singular, and division by zero will occur if it is used
   *               to solve a system of equations.
   *
   *  Further Details
   *  ===============
   *
   *  The band storage scheme is illustrated by the following example, when
   *  M = N = 6, KL = 2, KU = 1:
   *
   *  On entry:                       On exit:
   *
   *      *    *    *    +    +    +       *    *    *   u14  u25  u36
   *      *    *    +    +    +    +       *    *   u13  u24  u35  u46
   *      *   a12  a23  a34  a45  a56      *   u12  u23  u34  u45  u56
   *     a11  a22  a33  a44  a55  a66     u11  u22  u33  u44  u55  u66
   *     a21  a32  a43  a54  a65   *      m21  m32  m43  m54  m65   *
   *     a31  a42  a53  a64   *    *      m31  m42  m53  m64   *    *
   *
   *  Array elements marked * are not used by the routine; elements marked
   *  + need not be set on entry, but are required by the routine to store
   *  elements of U, because of fill-in resulting from the row
   *  interchanges.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param kl
   * @param ku
   * @param ab
   * @param _ab_offset
   * @param ldab
   * @param ipiv
   * @param _ipiv_offset
   * @param info
   * 
   */
  abstract public void dgbtf2(int m, int n, int kl, int ku, double[] ab, int _ab_offset, int ldab, int[] ipiv, int _ipiv_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGBTRF computes an LU factorization of a real m-by-n band matrix A
   *  using partial pivoting with row interchanges.
   *
   *  This is the blocked version of the algorithm, calling Level 3 BLAS.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  KL      (input) INTEGER
   *          The number of subdiagonals within the band of A.  KL >= 0.
   *
   *  KU      (input) INTEGER
   *          The number of superdiagonals within the band of A.  KU >= 0.
   *
   *  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
   *          On entry, the matrix A in band storage, in rows KL+1 to
   *          2*KL+KU+1; rows 1 to KL of the array need not be set.
   *          The j-th column of A is stored in the j-th column of the
   *          array AB as follows:
   *          AB(kl+ku+1+i-j,j) = A(i,j) for max(1,j-ku)<=i<=min(m,j+kl)
   *
   *          On exit, details of the factorization: U is stored as an
   *          upper triangular band matrix with KL+KU superdiagonals in
   *          rows 1 to KL+KU+1, and the multipliers used during the
   *          factorization are stored in rows KL+KU+2 to 2*KL+KU+1.
   *          See below for further details.
   *
   *  LDAB    (input) INTEGER
   *          The leading dimension of the array AB.  LDAB >= 2*KL+KU+1.
   *
   *  IPIV    (output) INTEGER array, dimension (min(M,N))
   *          The pivot indices; for 1 <= i <= min(M,N), row i of the
   *          matrix was interchanged with row IPIV(i).
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value
   *          > 0: if INFO = +i, U(i,i) is exactly zero. The factorization
   *               has been completed, but the factor U is exactly
   *               singular, and division by zero will occur if it is used
   *               to solve a system of equations.
   *
   *  Further Details
   *  ===============
   *
   *  The band storage scheme is illustrated by the following example, when
   *  M = N = 6, KL = 2, KU = 1:
   *
   *  On entry:                       On exit:
   *
   *      *    *    *    +    +    +       *    *    *   u14  u25  u36
   *      *    *    +    +    +    +       *    *   u13  u24  u35  u46
   *      *   a12  a23  a34  a45  a56      *   u12  u23  u34  u45  u56
   *     a11  a22  a33  a44  a55  a66     u11  u22  u33  u44  u55  u66
   *     a21  a32  a43  a54  a65   *      m21  m32  m43  m54  m65   *
   *     a31  a42  a53  a64   *    *      m31  m42  m53  m64   *    *
   *
   *  Array elements marked * are not used by the routine; elements marked
   *  + need not be set on entry, but are required by the routine to store
   *  elements of U because of fill-in resulting from the row interchanges.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param kl
   * @param ku
   * @param ab
   * @param ldab
   * @param ipiv
   * @param info
   * 
   */
  abstract public void dgbtrf(int m, int n, int kl, int ku, double[] ab, int ldab, int[] ipiv, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGBTRF computes an LU factorization of a real m-by-n band matrix A
   *  using partial pivoting with row interchanges.
   *
   *  This is the blocked version of the algorithm, calling Level 3 BLAS.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  KL      (input) INTEGER
   *          The number of subdiagonals within the band of A.  KL >= 0.
   *
   *  KU      (input) INTEGER
   *          The number of superdiagonals within the band of A.  KU >= 0.
   *
   *  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
   *          On entry, the matrix A in band storage, in rows KL+1 to
   *          2*KL+KU+1; rows 1 to KL of the array need not be set.
   *          The j-th column of A is stored in the j-th column of the
   *          array AB as follows:
   *          AB(kl+ku+1+i-j,j) = A(i,j) for max(1,j-ku)<=i<=min(m,j+kl)
   *
   *          On exit, details of the factorization: U is stored as an
   *          upper triangular band matrix with KL+KU superdiagonals in
   *          rows 1 to KL+KU+1, and the multipliers used during the
   *          factorization are stored in rows KL+KU+2 to 2*KL+KU+1.
   *          See below for further details.
   *
   *  LDAB    (input) INTEGER
   *          The leading dimension of the array AB.  LDAB >= 2*KL+KU+1.
   *
   *  IPIV    (output) INTEGER array, dimension (min(M,N))
   *          The pivot indices; for 1 <= i <= min(M,N), row i of the
   *          matrix was interchanged with row IPIV(i).
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value
   *          > 0: if INFO = +i, U(i,i) is exactly zero. The factorization
   *               has been completed, but the factor U is exactly
   *               singular, and division by zero will occur if it is used
   *               to solve a system of equations.
   *
   *  Further Details
   *  ===============
   *
   *  The band storage scheme is illustrated by the following example, when
   *  M = N = 6, KL = 2, KU = 1:
   *
   *  On entry:                       On exit:
   *
   *      *    *    *    +    +    +       *    *    *   u14  u25  u36
   *      *    *    +    +    +    +       *    *   u13  u24  u35  u46
   *      *   a12  a23  a34  a45  a56      *   u12  u23  u34  u45  u56
   *     a11  a22  a33  a44  a55  a66     u11  u22  u33  u44  u55  u66
   *     a21  a32  a43  a54  a65   *      m21  m32  m43  m54  m65   *
   *     a31  a42  a53  a64   *    *      m31  m42  m53  m64   *    *
   *
   *  Array elements marked * are not used by the routine; elements marked
   *  + need not be set on entry, but are required by the routine to store
   *  elements of U because of fill-in resulting from the row interchanges.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param kl
   * @param ku
   * @param ab
   * @param _ab_offset
   * @param ldab
   * @param ipiv
   * @param _ipiv_offset
   * @param info
   * 
   */
  abstract public void dgbtrf(int m, int n, int kl, int ku, double[] ab, int _ab_offset, int ldab, int[] ipiv, int _ipiv_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGBTRS solves a system of linear equations
   *     A * X = B  or  A' * X = B
   *  with a general band matrix A using the LU factorization computed
   *  by DGBTRF.
   *
   *  Arguments
   *  =========
   *
   *  TRANS   (input) CHARACTER*1
   *          Specifies the form of the system of equations.
   *          = 'N':  A * X = B  (No transpose)
   *          = 'T':  A'* X = B  (Transpose)
   *          = 'C':  A'* X = B  (Conjugate transpose = Transpose)
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  KL      (input) INTEGER
   *          The number of subdiagonals within the band of A.  KL >= 0.
   *
   *  KU      (input) INTEGER
   *          The number of superdiagonals within the band of A.  KU >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrix B.  NRHS >= 0.
   *
   *  AB      (input) DOUBLE PRECISION array, dimension (LDAB,N)
   *          Details of the LU factorization of the band matrix A, as
   *          computed by DGBTRF.  U is stored as an upper triangular band
   *          matrix with KL+KU superdiagonals in rows 1 to KL+KU+1, and
   *          the multipliers used during the factorization are stored in
   *          rows KL+KU+2 to 2*KL+KU+1.
   *
   *  LDAB    (input) INTEGER
   *          The leading dimension of the array AB.  LDAB >= 2*KL+KU+1.
   *
   *  IPIV    (input) INTEGER array, dimension (N)
   *          The pivot indices; for 1 <= i <= N, row i of the matrix was
   *          interchanged with row IPIV(i).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the right hand side matrix B.
   *          On exit, the solution matrix X.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param n
   * @param kl
   * @param ku
   * @param nrhs
   * @param ab
   * @param ldab
   * @param ipiv
   * @param b
   * @param ldb
   * @param info
   * 
   */
  abstract public void dgbtrs(java.lang.String trans, int n, int kl, int ku, int nrhs, double[] ab, int ldab, int[] ipiv, double[] b, int ldb, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGBTRS solves a system of linear equations
   *     A * X = B  or  A' * X = B
   *  with a general band matrix A using the LU factorization computed
   *  by DGBTRF.
   *
   *  Arguments
   *  =========
   *
   *  TRANS   (input) CHARACTER*1
   *          Specifies the form of the system of equations.
   *          = 'N':  A * X = B  (No transpose)
   *          = 'T':  A'* X = B  (Transpose)
   *          = 'C':  A'* X = B  (Conjugate transpose = Transpose)
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  KL      (input) INTEGER
   *          The number of subdiagonals within the band of A.  KL >= 0.
   *
   *  KU      (input) INTEGER
   *          The number of superdiagonals within the band of A.  KU >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrix B.  NRHS >= 0.
   *
   *  AB      (input) DOUBLE PRECISION array, dimension (LDAB,N)
   *          Details of the LU factorization of the band matrix A, as
   *          computed by DGBTRF.  U is stored as an upper triangular band
   *          matrix with KL+KU superdiagonals in rows 1 to KL+KU+1, and
   *          the multipliers used during the factorization are stored in
   *          rows KL+KU+2 to 2*KL+KU+1.
   *
   *  LDAB    (input) INTEGER
   *          The leading dimension of the array AB.  LDAB >= 2*KL+KU+1.
   *
   *  IPIV    (input) INTEGER array, dimension (N)
   *          The pivot indices; for 1 <= i <= N, row i of the matrix was
   *          interchanged with row IPIV(i).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the right hand side matrix B.
   *          On exit, the solution matrix X.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param n
   * @param kl
   * @param ku
   * @param nrhs
   * @param ab
   * @param _ab_offset
   * @param ldab
   * @param ipiv
   * @param _ipiv_offset
   * @param b
   * @param _b_offset
   * @param ldb
   * @param info
   * 
   */
  abstract public void dgbtrs(java.lang.String trans, int n, int kl, int ku, int nrhs, double[] ab, int _ab_offset, int ldab, int[] ipiv, int _ipiv_offset, double[] b, int _b_offset, int ldb, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEBAK forms the right or left eigenvectors of a real general matrix
   *  by backward transformation on the computed eigenvectors of the
   *  balanced matrix output by DGEBAL.
   *
   *  Arguments
   *  =========
   *
   *  JOB     (input) CHARACTER*1
   *          Specifies the type of backward transformation required:
   *          = 'N', do nothing, return immediately;
   *          = 'P', do backward transformation for permutation only;
   *          = 'S', do backward transformation for scaling only;
   *          = 'B', do backward transformations for both permutation and
   *                 scaling.
   *          JOB must be the same as the argument JOB supplied to DGEBAL.
   *
   *  SIDE    (input) CHARACTER*1
   *          = 'R':  V contains right eigenvectors;
   *          = 'L':  V contains left eigenvectors.
   *
   *  N       (input) INTEGER
   *          The number of rows of the matrix V.  N >= 0.
   *
   *  ILO     (input) INTEGER
   *  IHI     (input) INTEGER
   *          The integers ILO and IHI determined by DGEBAL.
   *          1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0.
   *
   *  SCALE   (input) DOUBLE PRECISION array, dimension (N)
   *          Details of the permutation and scaling factors, as returned
   *          by DGEBAL.
   *
   *  M       (input) INTEGER
   *          The number of columns of the matrix V.  M >= 0.
   *
   *  V       (input/output) DOUBLE PRECISION array, dimension (LDV,M)
   *          On entry, the matrix of right or left eigenvectors to be
   *          transformed, as returned by DHSEIN or DTREVC.
   *          On exit, V is overwritten by the transformed eigenvectors.
   *
   *  LDV     (input) INTEGER
   *          The leading dimension of the array V. LDV >= max(1,N).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param job
   * @param side
   * @param n
   * @param ilo
   * @param ihi
   * @param scale
   * @param m
   * @param v
   * @param ldv
   * @param info
   * 
   */
  abstract public void dgebak(java.lang.String job, java.lang.String side, int n, int ilo, int ihi, double[] scale, int m, double[] v, int ldv, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEBAK forms the right or left eigenvectors of a real general matrix
   *  by backward transformation on the computed eigenvectors of the
   *  balanced matrix output by DGEBAL.
   *
   *  Arguments
   *  =========
   *
   *  JOB     (input) CHARACTER*1
   *          Specifies the type of backward transformation required:
   *          = 'N', do nothing, return immediately;
   *          = 'P', do backward transformation for permutation only;
   *          = 'S', do backward transformation for scaling only;
   *          = 'B', do backward transformations for both permutation and
   *                 scaling.
   *          JOB must be the same as the argument JOB supplied to DGEBAL.
   *
   *  SIDE    (input) CHARACTER*1
   *          = 'R':  V contains right eigenvectors;
   *          = 'L':  V contains left eigenvectors.
   *
   *  N       (input) INTEGER
   *          The number of rows of the matrix V.  N >= 0.
   *
   *  ILO     (input) INTEGER
   *  IHI     (input) INTEGER
   *          The integers ILO and IHI determined by DGEBAL.
   *          1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0.
   *
   *  SCALE   (input) DOUBLE PRECISION array, dimension (N)
   *          Details of the permutation and scaling factors, as returned
   *          by DGEBAL.
   *
   *  M       (input) INTEGER
   *          The number of columns of the matrix V.  M >= 0.
   *
   *  V       (input/output) DOUBLE PRECISION array, dimension (LDV,M)
   *          On entry, the matrix of right or left eigenvectors to be
   *          transformed, as returned by DHSEIN or DTREVC.
   *          On exit, V is overwritten by the transformed eigenvectors.
   *
   *  LDV     (input) INTEGER
   *          The leading dimension of the array V. LDV >= max(1,N).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param job
   * @param side
   * @param n
   * @param ilo
   * @param ihi
   * @param scale
   * @param _scale_offset
   * @param m
   * @param v
   * @param _v_offset
   * @param ldv
   * @param info
   * 
   */
  abstract public void dgebak(java.lang.String job, java.lang.String side, int n, int ilo, int ihi, double[] scale, int _scale_offset, int m, double[] v, int _v_offset, int ldv, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEBAL balances a general real matrix A.  This involves, first,
   *  permuting A by a similarity transformation to isolate eigenvalues
   *  in the first 1 to ILO-1 and last IHI+1 to N elements on the
   *  diagonal; and second, applying a diagonal similarity transformation
   *  to rows and columns ILO to IHI to make the rows and columns as
   *  close in norm as possible.  Both steps are optional.
   *
   *  Balancing may reduce the 1-norm of the matrix, and improve the
   *  accuracy of the computed eigenvalues and/or eigenvectors.
   *
   *  Arguments
   *  =========
   *
   *  JOB     (input) CHARACTER*1
   *          Specifies the operations to be performed on A:
   *          = 'N':  none:  simply set ILO = 1, IHI = N, SCALE(I) = 1.0
   *                  for i = 1,...,N;
   *          = 'P':  permute only;
   *          = 'S':  scale only;
   *          = 'B':  both permute and scale.
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the input matrix A.
   *          On exit,  A is overwritten by the balanced matrix.
   *          If JOB = 'N', A is not referenced.
   *          See Further Details.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  ILO     (output) INTEGER
   *  IHI     (output) INTEGER
   *          ILO and IHI are set to integers such that on exit
   *          A(i,j) = 0 if i > j and j = 1,...,ILO-1 or I = IHI+1,...,N.
   *          If JOB = 'N' or 'S', ILO = 1 and IHI = N.
   *
   *  SCALE   (output) DOUBLE PRECISION array, dimension (N)
   *          Details of the permutations and scaling factors applied to
   *          A.  If P(j) is the index of the row and column interchanged
   *          with row and column j and D(j) is the scaling factor
   *          applied to row and column j, then
   *          SCALE(j) = P(j)    for j = 1,...,ILO-1
   *                   = D(j)    for j = ILO,...,IHI
   *                   = P(j)    for j = IHI+1,...,N.
   *          The order in which the interchanges are made is N to IHI+1,
   *          then 1 to ILO-1.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  The permutations consist of row and column interchanges which put
   *  the matrix in the form
   *
   *             ( T1   X   Y  )
   *     P A P = (  0   B   Z  )
   *             (  0   0   T2 )
   *
   *  where T1 and T2 are upper triangular matrices whose eigenvalues lie
   *  along the diagonal.  The column indices ILO and IHI mark the starting
   *  and ending columns of the submatrix B. Balancing consists of applying
   *  a diagonal similarity transformation inv(D) * B * D to make the
   *  1-norms of each row of B and its corresponding column nearly equal.
   *  The output matrix is
   *
   *     ( T1     X*D          Y    )
   *     (  0  inv(D)*B*D  inv(D)*Z ).
   *     (  0      0           T2   )
   *
   *  Information about the permutations P and the diagonal matrix D is
   *  returned in the vector SCALE.
   *
   *  This subroutine is based on the EISPACK routine BALANC.
   *
   *  Modified by Tzu-Yi Chen, Computer Science Division, University of
   *    California at Berkeley, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param job
   * @param n
   * @param a
   * @param lda
   * @param ilo
   * @param ihi
   * @param scale
   * @param info
   * 
   */
  abstract public void dgebal(java.lang.String job, int n, double[] a, int lda, org.netlib.util.intW ilo, org.netlib.util.intW ihi, double[] scale, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEBAL balances a general real matrix A.  This involves, first,
   *  permuting A by a similarity transformation to isolate eigenvalues
   *  in the first 1 to ILO-1 and last IHI+1 to N elements on the
   *  diagonal; and second, applying a diagonal similarity transformation
   *  to rows and columns ILO to IHI to make the rows and columns as
   *  close in norm as possible.  Both steps are optional.
   *
   *  Balancing may reduce the 1-norm of the matrix, and improve the
   *  accuracy of the computed eigenvalues and/or eigenvectors.
   *
   *  Arguments
   *  =========
   *
   *  JOB     (input) CHARACTER*1
   *          Specifies the operations to be performed on A:
   *          = 'N':  none:  simply set ILO = 1, IHI = N, SCALE(I) = 1.0
   *                  for i = 1,...,N;
   *          = 'P':  permute only;
   *          = 'S':  scale only;
   *          = 'B':  both permute and scale.
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the input matrix A.
   *          On exit,  A is overwritten by the balanced matrix.
   *          If JOB = 'N', A is not referenced.
   *          See Further Details.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  ILO     (output) INTEGER
   *  IHI     (output) INTEGER
   *          ILO and IHI are set to integers such that on exit
   *          A(i,j) = 0 if i > j and j = 1,...,ILO-1 or I = IHI+1,...,N.
   *          If JOB = 'N' or 'S', ILO = 1 and IHI = N.
   *
   *  SCALE   (output) DOUBLE PRECISION array, dimension (N)
   *          Details of the permutations and scaling factors applied to
   *          A.  If P(j) is the index of the row and column interchanged
   *          with row and column j and D(j) is the scaling factor
   *          applied to row and column j, then
   *          SCALE(j) = P(j)    for j = 1,...,ILO-1
   *                   = D(j)    for j = ILO,...,IHI
   *                   = P(j)    for j = IHI+1,...,N.
   *          The order in which the interchanges are made is N to IHI+1,
   *          then 1 to ILO-1.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  The permutations consist of row and column interchanges which put
   *  the matrix in the form
   *
   *             ( T1   X   Y  )
   *     P A P = (  0   B   Z  )
   *             (  0   0   T2 )
   *
   *  where T1 and T2 are upper triangular matrices whose eigenvalues lie
   *  along the diagonal.  The column indices ILO and IHI mark the starting
   *  and ending columns of the submatrix B. Balancing consists of applying
   *  a diagonal similarity transformation inv(D) * B * D to make the
   *  1-norms of each row of B and its corresponding column nearly equal.
   *  The output matrix is
   *
   *     ( T1     X*D          Y    )
   *     (  0  inv(D)*B*D  inv(D)*Z ).
   *     (  0      0           T2   )
   *
   *  Information about the permutations P and the diagonal matrix D is
   *  returned in the vector SCALE.
   *
   *  This subroutine is based on the EISPACK routine BALANC.
   *
   *  Modified by Tzu-Yi Chen, Computer Science Division, University of
   *    California at Berkeley, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param job
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param ilo
   * @param ihi
   * @param scale
   * @param _scale_offset
   * @param info
   * 
   */
  abstract public void dgebal(java.lang.String job, int n, double[] a, int _a_offset, int lda, org.netlib.util.intW ilo, org.netlib.util.intW ihi, double[] scale, int _scale_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEBD2 reduces a real general m by n matrix A to upper or lower
   *  bidiagonal form B by an orthogonal transformation: Q' * A * P = B.
   *
   *  If m >= n, B is upper bidiagonal; if m < n, B is lower bidiagonal.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows in the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns in the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the m by n general matrix to be reduced.
   *          On exit,
   *          if m >= n, the diagonal and the first superdiagonal are
   *            overwritten with the upper bidiagonal matrix B; the
   *            elements below the diagonal, with the array TAUQ, represent
   *            the orthogonal matrix Q as a product of elementary
   *            reflectors, and the elements above the first superdiagonal,
   *            with the array TAUP, represent the orthogonal matrix P as
   *            a product of elementary reflectors;
   *          if m < n, the diagonal and the first subdiagonal are
   *            overwritten with the lower bidiagonal matrix B; the
   *            elements below the first subdiagonal, with the array TAUQ,
   *            represent the orthogonal matrix Q as a product of
   *            elementary reflectors, and the elements above the diagonal,
   *            with the array TAUP, represent the orthogonal matrix P as
   *            a product of elementary reflectors.
   *          See Further Details.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  D       (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The diagonal elements of the bidiagonal matrix B:
   *          D(i) = A(i,i).
   *
   *  E       (output) DOUBLE PRECISION array, dimension (min(M,N)-1)
   *          The off-diagonal elements of the bidiagonal matrix B:
   *          if m >= n, E(i) = A(i,i+1) for i = 1,2,...,n-1;
   *          if m < n, E(i) = A(i+1,i) for i = 1,2,...,m-1.
   *
   *  TAUQ    (output) DOUBLE PRECISION array dimension (min(M,N))
   *          The scalar factors of the elementary reflectors which
   *          represent the orthogonal matrix Q. See Further Details.
   *
   *  TAUP    (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors which
   *          represent the orthogonal matrix P. See Further Details.
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (max(M,N))
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit.
   *          < 0: if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  The matrices Q and P are represented as products of elementary
   *  reflectors:
   *
   *  If m >= n,
   *
   *     Q = H(1) H(2) . . . H(n)  and  P = G(1) G(2) . . . G(n-1)
   *
   *  Each H(i) and G(i) has the form:
   *
   *     H(i) = I - tauq * v * v'  and G(i) = I - taup * u * u'
   *
   *  where tauq and taup are real scalars, and v and u are real vectors;
   *  v(1:i-1) = 0, v(i) = 1, and v(i+1:m) is stored on exit in A(i+1:m,i);
   *  u(1:i) = 0, u(i+1) = 1, and u(i+2:n) is stored on exit in A(i,i+2:n);
   *  tauq is stored in TAUQ(i) and taup in TAUP(i).
   *
   *  If m < n,
   *
   *     Q = H(1) H(2) . . . H(m-1)  and  P = G(1) G(2) . . . G(m)
   *
   *  Each H(i) and G(i) has the form:
   *
   *     H(i) = I - tauq * v * v'  and G(i) = I - taup * u * u'
   *
   *  where tauq and taup are real scalars, and v and u are real vectors;
   *  v(1:i) = 0, v(i+1) = 1, and v(i+2:m) is stored on exit in A(i+2:m,i);
   *  u(1:i-1) = 0, u(i) = 1, and u(i+1:n) is stored on exit in A(i,i+1:n);
   *  tauq is stored in TAUQ(i) and taup in TAUP(i).
   *
   *  The contents of A on exit are illustrated by the following examples:
   *
   *  m = 6 and n = 5 (m > n):          m = 5 and n = 6 (m < n):
   *
   *    (  d   e   u1  u1  u1 )           (  d   u1  u1  u1  u1  u1 )
   *    (  v1  d   e   u2  u2 )           (  e   d   u2  u2  u2  u2 )
   *    (  v1  v2  d   e   u3 )           (  v1  e   d   u3  u3  u3 )
   *    (  v1  v2  v3  d   e  )           (  v1  v2  e   d   u4  u4 )
   *    (  v1  v2  v3  v4  d  )           (  v1  v2  v3  e   d   u5 )
   *    (  v1  v2  v3  v4  v5 )
   *
   *  where d and e denote diagonal and off-diagonal elements of B, vi
   *  denotes an element of the vector defining H(i), and ui an element of
   *  the vector defining G(i).
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param d
   * @param e
   * @param tauq
   * @param taup
   * @param work
   * @param info
   * 
   */
  abstract public void dgebd2(int m, int n, double[] a, int lda, double[] d, double[] e, double[] tauq, double[] taup, double[] work, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEBD2 reduces a real general m by n matrix A to upper or lower
   *  bidiagonal form B by an orthogonal transformation: Q' * A * P = B.
   *
   *  If m >= n, B is upper bidiagonal; if m < n, B is lower bidiagonal.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows in the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns in the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the m by n general matrix to be reduced.
   *          On exit,
   *          if m >= n, the diagonal and the first superdiagonal are
   *            overwritten with the upper bidiagonal matrix B; the
   *            elements below the diagonal, with the array TAUQ, represent
   *            the orthogonal matrix Q as a product of elementary
   *            reflectors, and the elements above the first superdiagonal,
   *            with the array TAUP, represent the orthogonal matrix P as
   *            a product of elementary reflectors;
   *          if m < n, the diagonal and the first subdiagonal are
   *            overwritten with the lower bidiagonal matrix B; the
   *            elements below the first subdiagonal, with the array TAUQ,
   *            represent the orthogonal matrix Q as a product of
   *            elementary reflectors, and the elements above the diagonal,
   *            with the array TAUP, represent the orthogonal matrix P as
   *            a product of elementary reflectors.
   *          See Further Details.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  D       (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The diagonal elements of the bidiagonal matrix B:
   *          D(i) = A(i,i).
   *
   *  E       (output) DOUBLE PRECISION array, dimension (min(M,N)-1)
   *          The off-diagonal elements of the bidiagonal matrix B:
   *          if m >= n, E(i) = A(i,i+1) for i = 1,2,...,n-1;
   *          if m < n, E(i) = A(i+1,i) for i = 1,2,...,m-1.
   *
   *  TAUQ    (output) DOUBLE PRECISION array dimension (min(M,N))
   *          The scalar factors of the elementary reflectors which
   *          represent the orthogonal matrix Q. See Further Details.
   *
   *  TAUP    (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors which
   *          represent the orthogonal matrix P. See Further Details.
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (max(M,N))
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit.
   *          < 0: if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  The matrices Q and P are represented as products of elementary
   *  reflectors:
   *
   *  If m >= n,
   *
   *     Q = H(1) H(2) . . . H(n)  and  P = G(1) G(2) . . . G(n-1)
   *
   *  Each H(i) and G(i) has the form:
   *
   *     H(i) = I - tauq * v * v'  and G(i) = I - taup * u * u'
   *
   *  where tauq and taup are real scalars, and v and u are real vectors;
   *  v(1:i-1) = 0, v(i) = 1, and v(i+1:m) is stored on exit in A(i+1:m,i);
   *  u(1:i) = 0, u(i+1) = 1, and u(i+2:n) is stored on exit in A(i,i+2:n);
   *  tauq is stored in TAUQ(i) and taup in TAUP(i).
   *
   *  If m < n,
   *
   *     Q = H(1) H(2) . . . H(m-1)  and  P = G(1) G(2) . . . G(m)
   *
   *  Each H(i) and G(i) has the form:
   *
   *     H(i) = I - tauq * v * v'  and G(i) = I - taup * u * u'
   *
   *  where tauq and taup are real scalars, and v and u are real vectors;
   *  v(1:i) = 0, v(i+1) = 1, and v(i+2:m) is stored on exit in A(i+2:m,i);
   *  u(1:i-1) = 0, u(i) = 1, and u(i+1:n) is stored on exit in A(i,i+1:n);
   *  tauq is stored in TAUQ(i) and taup in TAUP(i).
   *
   *  The contents of A on exit are illustrated by the following examples:
   *
   *  m = 6 and n = 5 (m > n):          m = 5 and n = 6 (m < n):
   *
   *    (  d   e   u1  u1  u1 )           (  d   u1  u1  u1  u1  u1 )
   *    (  v1  d   e   u2  u2 )           (  e   d   u2  u2  u2  u2 )
   *    (  v1  v2  d   e   u3 )           (  v1  e   d   u3  u3  u3 )
   *    (  v1  v2  v3  d   e  )           (  v1  v2  e   d   u4  u4 )
   *    (  v1  v2  v3  v4  d  )           (  v1  v2  v3  e   d   u5 )
   *    (  v1  v2  v3  v4  v5 )
   *
   *  where d and e denote diagonal and off-diagonal elements of B, vi
   *  denotes an element of the vector defining H(i), and ui an element of
   *  the vector defining G(i).
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param d
   * @param _d_offset
   * @param e
   * @param _e_offset
   * @param tauq
   * @param _tauq_offset
   * @param taup
   * @param _taup_offset
   * @param work
   * @param _work_offset
   * @param info
   * 
   */
  abstract public void dgebd2(int m, int n, double[] a, int _a_offset, int lda, double[] d, int _d_offset, double[] e, int _e_offset, double[] tauq, int _tauq_offset, double[] taup, int _taup_offset, double[] work, int _work_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEBRD reduces a general real M-by-N matrix A to upper or lower
   *  bidiagonal form B by an orthogonal transformation: Q**T * A * P = B.
   *
   *  If m >= n, B is upper bidiagonal; if m < n, B is lower bidiagonal.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows in the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns in the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N general matrix to be reduced.
   *          On exit,
   *          if m >= n, the diagonal and the first superdiagonal are
   *            overwritten with the upper bidiagonal matrix B; the
   *            elements below the diagonal, with the array TAUQ, represent
   *            the orthogonal matrix Q as a product of elementary
   *            reflectors, and the elements above the first superdiagonal,
   *            with the array TAUP, represent the orthogonal matrix P as
   *            a product of elementary reflectors;
   *          if m < n, the diagonal and the first subdiagonal are
   *            overwritten with the lower bidiagonal matrix B; the
   *            elements below the first subdiagonal, with the array TAUQ,
   *            represent the orthogonal matrix Q as a product of
   *            elementary reflectors, and the elements above the diagonal,
   *            with the array TAUP, represent the orthogonal matrix P as
   *            a product of elementary reflectors.
   *          See Further Details.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  D       (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The diagonal elements of the bidiagonal matrix B:
   *          D(i) = A(i,i).
   *
   *  E       (output) DOUBLE PRECISION array, dimension (min(M,N)-1)
   *          The off-diagonal elements of the bidiagonal matrix B:
   *          if m >= n, E(i) = A(i,i+1) for i = 1,2,...,n-1;
   *          if m < n, E(i) = A(i+1,i) for i = 1,2,...,m-1.
   *
   *  TAUQ    (output) DOUBLE PRECISION array dimension (min(M,N))
   *          The scalar factors of the elementary reflectors which
   *          represent the orthogonal matrix Q. See Further Details.
   *
   *  TAUP    (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors which
   *          represent the orthogonal matrix P. See Further Details.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The length of the array WORK.  LWORK >= max(1,M,N).
   *          For optimum performance LWORK >= (M+N)*NB, where NB
   *          is the optimal blocksize.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  The matrices Q and P are represented as products of elementary
   *  reflectors:
   *
   *  If m >= n,
   *
   *     Q = H(1) H(2) . . . H(n)  and  P = G(1) G(2) . . . G(n-1)
   *
   *  Each H(i) and G(i) has the form:
   *
   *     H(i) = I - tauq * v * v'  and G(i) = I - taup * u * u'
   *
   *  where tauq and taup are real scalars, and v and u are real vectors;
   *  v(1:i-1) = 0, v(i) = 1, and v(i+1:m) is stored on exit in A(i+1:m,i);
   *  u(1:i) = 0, u(i+1) = 1, and u(i+2:n) is stored on exit in A(i,i+2:n);
   *  tauq is stored in TAUQ(i) and taup in TAUP(i).
   *
   *  If m < n,
   *
   *     Q = H(1) H(2) . . . H(m-1)  and  P = G(1) G(2) . . . G(m)
   *
   *  Each H(i) and G(i) has the form:
   *
   *     H(i) = I - tauq * v * v'  and G(i) = I - taup * u * u'
   *
   *  where tauq and taup are real scalars, and v and u are real vectors;
   *  v(1:i) = 0, v(i+1) = 1, and v(i+2:m) is stored on exit in A(i+2:m,i);
   *  u(1:i-1) = 0, u(i) = 1, and u(i+1:n) is stored on exit in A(i,i+1:n);
   *  tauq is stored in TAUQ(i) and taup in TAUP(i).
   *
   *  The contents of A on exit are illustrated by the following examples:
   *
   *  m = 6 and n = 5 (m > n):          m = 5 and n = 6 (m < n):
   *
   *    (  d   e   u1  u1  u1 )           (  d   u1  u1  u1  u1  u1 )
   *    (  v1  d   e   u2  u2 )           (  e   d   u2  u2  u2  u2 )
   *    (  v1  v2  d   e   u3 )           (  v1  e   d   u3  u3  u3 )
   *    (  v1  v2  v3  d   e  )           (  v1  v2  e   d   u4  u4 )
   *    (  v1  v2  v3  v4  d  )           (  v1  v2  v3  e   d   u5 )
   *    (  v1  v2  v3  v4  v5 )
   *
   *  where d and e denote diagonal and off-diagonal elements of B, vi
   *  denotes an element of the vector defining H(i), and ui an element of
   *  the vector defining G(i).
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param d
   * @param e
   * @param tauq
   * @param taup
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgebrd(int m, int n, double[] a, int lda, double[] d, double[] e, double[] tauq, double[] taup, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEBRD reduces a general real M-by-N matrix A to upper or lower
   *  bidiagonal form B by an orthogonal transformation: Q**T * A * P = B.
   *
   *  If m >= n, B is upper bidiagonal; if m < n, B is lower bidiagonal.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows in the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns in the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N general matrix to be reduced.
   *          On exit,
   *          if m >= n, the diagonal and the first superdiagonal are
   *            overwritten with the upper bidiagonal matrix B; the
   *            elements below the diagonal, with the array TAUQ, represent
   *            the orthogonal matrix Q as a product of elementary
   *            reflectors, and the elements above the first superdiagonal,
   *            with the array TAUP, represent the orthogonal matrix P as
   *            a product of elementary reflectors;
   *          if m < n, the diagonal and the first subdiagonal are
   *            overwritten with the lower bidiagonal matrix B; the
   *            elements below the first subdiagonal, with the array TAUQ,
   *            represent the orthogonal matrix Q as a product of
   *            elementary reflectors, and the elements above the diagonal,
   *            with the array TAUP, represent the orthogonal matrix P as
   *            a product of elementary reflectors.
   *          See Further Details.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  D       (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The diagonal elements of the bidiagonal matrix B:
   *          D(i) = A(i,i).
   *
   *  E       (output) DOUBLE PRECISION array, dimension (min(M,N)-1)
   *          The off-diagonal elements of the bidiagonal matrix B:
   *          if m >= n, E(i) = A(i,i+1) for i = 1,2,...,n-1;
   *          if m < n, E(i) = A(i+1,i) for i = 1,2,...,m-1.
   *
   *  TAUQ    (output) DOUBLE PRECISION array dimension (min(M,N))
   *          The scalar factors of the elementary reflectors which
   *          represent the orthogonal matrix Q. See Further Details.
   *
   *  TAUP    (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors which
   *          represent the orthogonal matrix P. See Further Details.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The length of the array WORK.  LWORK >= max(1,M,N).
   *          For optimum performance LWORK >= (M+N)*NB, where NB
   *          is the optimal blocksize.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  The matrices Q and P are represented as products of elementary
   *  reflectors:
   *
   *  If m >= n,
   *
   *     Q = H(1) H(2) . . . H(n)  and  P = G(1) G(2) . . . G(n-1)
   *
   *  Each H(i) and G(i) has the form:
   *
   *     H(i) = I - tauq * v * v'  and G(i) = I - taup * u * u'
   *
   *  where tauq and taup are real scalars, and v and u are real vectors;
   *  v(1:i-1) = 0, v(i) = 1, and v(i+1:m) is stored on exit in A(i+1:m,i);
   *  u(1:i) = 0, u(i+1) = 1, and u(i+2:n) is stored on exit in A(i,i+2:n);
   *  tauq is stored in TAUQ(i) and taup in TAUP(i).
   *
   *  If m < n,
   *
   *     Q = H(1) H(2) . . . H(m-1)  and  P = G(1) G(2) . . . G(m)
   *
   *  Each H(i) and G(i) has the form:
   *
   *     H(i) = I - tauq * v * v'  and G(i) = I - taup * u * u'
   *
   *  where tauq and taup are real scalars, and v and u are real vectors;
   *  v(1:i) = 0, v(i+1) = 1, and v(i+2:m) is stored on exit in A(i+2:m,i);
   *  u(1:i-1) = 0, u(i) = 1, and u(i+1:n) is stored on exit in A(i,i+1:n);
   *  tauq is stored in TAUQ(i) and taup in TAUP(i).
   *
   *  The contents of A on exit are illustrated by the following examples:
   *
   *  m = 6 and n = 5 (m > n):          m = 5 and n = 6 (m < n):
   *
   *    (  d   e   u1  u1  u1 )           (  d   u1  u1  u1  u1  u1 )
   *    (  v1  d   e   u2  u2 )           (  e   d   u2  u2  u2  u2 )
   *    (  v1  v2  d   e   u3 )           (  v1  e   d   u3  u3  u3 )
   *    (  v1  v2  v3  d   e  )           (  v1  v2  e   d   u4  u4 )
   *    (  v1  v2  v3  v4  d  )           (  v1  v2  v3  e   d   u5 )
   *    (  v1  v2  v3  v4  v5 )
   *
   *  where d and e denote diagonal and off-diagonal elements of B, vi
   *  denotes an element of the vector defining H(i), and ui an element of
   *  the vector defining G(i).
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param d
   * @param _d_offset
   * @param e
   * @param _e_offset
   * @param tauq
   * @param _tauq_offset
   * @param taup
   * @param _taup_offset
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgebrd(int m, int n, double[] a, int _a_offset, int lda, double[] d, int _d_offset, double[] e, int _e_offset, double[] tauq, int _tauq_offset, double[] taup, int _taup_offset, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGECON estimates the reciprocal of the condition number of a general
   *  real matrix A, in either the 1-norm or the infinity-norm, using
   *  the LU factorization computed by DGETRF.
   *
   *  An estimate is obtained for norm(inv(A)), and the reciprocal of the
   *  condition number is computed as
   *     RCOND = 1 / ( norm(A) * norm(inv(A)) ).
   *
   *  Arguments
   *  =========
   *
   *  NORM    (input) CHARACTER*1
   *          Specifies whether the 1-norm condition number or the
   *          infinity-norm condition number is required:
   *          = '1' or 'O':  1-norm;
   *          = 'I':         Infinity-norm.
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
   *          The factors L and U from the factorization A = P*L*U
   *          as computed by DGETRF.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  ANORM   (input) DOUBLE PRECISION
   *          If NORM = '1' or 'O', the 1-norm of the original matrix A.
   *          If NORM = 'I', the infinity-norm of the original matrix A.
   *
   *  RCOND   (output) DOUBLE PRECISION
   *          The reciprocal of the condition number of the matrix A,
   *          computed as RCOND = 1/(norm(A) * norm(inv(A))).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (4*N)
   *
   *  IWORK   (workspace) INTEGER array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param norm
   * @param n
   * @param a
   * @param lda
   * @param anorm
   * @param rcond
   * @param work
   * @param iwork
   * @param info
   * 
   */
  abstract public void dgecon(java.lang.String norm, int n, double[] a, int lda, double anorm, org.netlib.util.doubleW rcond, double[] work, int[] iwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGECON estimates the reciprocal of the condition number of a general
   *  real matrix A, in either the 1-norm or the infinity-norm, using
   *  the LU factorization computed by DGETRF.
   *
   *  An estimate is obtained for norm(inv(A)), and the reciprocal of the
   *  condition number is computed as
   *     RCOND = 1 / ( norm(A) * norm(inv(A)) ).
   *
   *  Arguments
   *  =========
   *
   *  NORM    (input) CHARACTER*1
   *          Specifies whether the 1-norm condition number or the
   *          infinity-norm condition number is required:
   *          = '1' or 'O':  1-norm;
   *          = 'I':         Infinity-norm.
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
   *          The factors L and U from the factorization A = P*L*U
   *          as computed by DGETRF.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  ANORM   (input) DOUBLE PRECISION
   *          If NORM = '1' or 'O', the 1-norm of the original matrix A.
   *          If NORM = 'I', the infinity-norm of the original matrix A.
   *
   *  RCOND   (output) DOUBLE PRECISION
   *          The reciprocal of the condition number of the matrix A,
   *          computed as RCOND = 1/(norm(A) * norm(inv(A))).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (4*N)
   *
   *  IWORK   (workspace) INTEGER array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param norm
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param anorm
   * @param rcond
   * @param work
   * @param _work_offset
   * @param iwork
   * @param _iwork_offset
   * @param info
   * 
   */
  abstract public void dgecon(java.lang.String norm, int n, double[] a, int _a_offset, int lda, double anorm, org.netlib.util.doubleW rcond, double[] work, int _work_offset, int[] iwork, int _iwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEEQU computes row and column scalings intended to equilibrate an
   *  M-by-N matrix A and reduce its condition number.  R returns the row
   *  scale factors and C the column scale factors, chosen to try to make
   *  the largest element in each row and column of the matrix B with
   *  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.
   *
   *  R(i) and C(j) are restricted to be between SMLNUM = smallest safe
   *  number and BIGNUM = largest safe number.  Use of these scaling
   *  factors is not guaranteed to reduce the condition number of A but
   *  works well in practice.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
   *          The M-by-N matrix whose equilibration factors are
   *          to be computed.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  R       (output) DOUBLE PRECISION array, dimension (M)
   *          If INFO = 0 or INFO > M, R contains the row scale factors
   *          for A.
   *
   *  C       (output) DOUBLE PRECISION array, dimension (N)
   *          If INFO = 0,  C contains the column scale factors for A.
   *
   *  ROWCND  (output) DOUBLE PRECISION
   *          If INFO = 0 or INFO > M, ROWCND contains the ratio of the
   *          smallest R(i) to the largest R(i).  If ROWCND >= 0.1 and
   *          AMAX is neither too large nor too small, it is not worth
   *          scaling by R.
   *
   *  COLCND  (output) DOUBLE PRECISION
   *          If INFO = 0, COLCND contains the ratio of the smallest
   *          C(i) to the largest C(i).  If COLCND >= 0.1, it is not
   *          worth scaling by C.
   *
   *  AMAX    (output) DOUBLE PRECISION
   *          Absolute value of largest matrix element.  If AMAX is very
   *          close to overflow or very close to underflow, the matrix
   *          should be scaled.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO = i,  and i is
   *                <= M:  the i-th row of A is exactly zero
   *                >  M:  the (i-M)-th column of A is exactly zero
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param r
   * @param c
   * @param rowcnd
   * @param colcnd
   * @param amax
   * @param info
   * 
   */
  abstract public void dgeequ(int m, int n, double[] a, int lda, double[] r, double[] c, org.netlib.util.doubleW rowcnd, org.netlib.util.doubleW colcnd, org.netlib.util.doubleW amax, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEEQU computes row and column scalings intended to equilibrate an
   *  M-by-N matrix A and reduce its condition number.  R returns the row
   *  scale factors and C the column scale factors, chosen to try to make
   *  the largest element in each row and column of the matrix B with
   *  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.
   *
   *  R(i) and C(j) are restricted to be between SMLNUM = smallest safe
   *  number and BIGNUM = largest safe number.  Use of these scaling
   *  factors is not guaranteed to reduce the condition number of A but
   *  works well in practice.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
   *          The M-by-N matrix whose equilibration factors are
   *          to be computed.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  R       (output) DOUBLE PRECISION array, dimension (M)
   *          If INFO = 0 or INFO > M, R contains the row scale factors
   *          for A.
   *
   *  C       (output) DOUBLE PRECISION array, dimension (N)
   *          If INFO = 0,  C contains the column scale factors for A.
   *
   *  ROWCND  (output) DOUBLE PRECISION
   *          If INFO = 0 or INFO > M, ROWCND contains the ratio of the
   *          smallest R(i) to the largest R(i).  If ROWCND >= 0.1 and
   *          AMAX is neither too large nor too small, it is not worth
   *          scaling by R.
   *
   *  COLCND  (output) DOUBLE PRECISION
   *          If INFO = 0, COLCND contains the ratio of the smallest
   *          C(i) to the largest C(i).  If COLCND >= 0.1, it is not
   *          worth scaling by C.
   *
   *  AMAX    (output) DOUBLE PRECISION
   *          Absolute value of largest matrix element.  If AMAX is very
   *          close to overflow or very close to underflow, the matrix
   *          should be scaled.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO = i,  and i is
   *                <= M:  the i-th row of A is exactly zero
   *                >  M:  the (i-M)-th column of A is exactly zero
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param r
   * @param _r_offset
   * @param c
   * @param _c_offset
   * @param rowcnd
   * @param colcnd
   * @param amax
   * @param info
   * 
   */
  abstract public void dgeequ(int m, int n, double[] a, int _a_offset, int lda, double[] r, int _r_offset, double[] c, int _c_offset, org.netlib.util.doubleW rowcnd, org.netlib.util.doubleW colcnd, org.netlib.util.doubleW amax, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEES computes for an N-by-N real nonsymmetric matrix A, the
   *  eigenvalues, the real Schur form T, and, optionally, the matrix of
   *  Schur vectors Z.  This gives the Schur factorization A = Z*T*(Z**T).
   *
   *  Optionally, it also orders the eigenvalues on the diagonal of the
   *  real Schur form so that selected eigenvalues are at the top left.
   *  The leading columns of Z then form an orthonormal basis for the
   *  invariant subspace corresponding to the selected eigenvalues.
   *
   *  A matrix is in real Schur form if it is upper quasi-triangular with
   *  1-by-1 and 2-by-2 blocks. 2-by-2 blocks will be standardized in the
   *  form
   *          [  a  b  ]
   *          [  c  a  ]
   *
   *  where b*c < 0. The eigenvalues of such a block are a +- sqrt(bc).
   *
   *  Arguments
   *  =========
   *
   *  JOBVS   (input) CHARACTER*1
   *          = 'N': Schur vectors are not computed;
   *          = 'V': Schur vectors are computed.
   *
   *  SORT    (input) CHARACTER*1
   *          Specifies whether or not to order the eigenvalues on the
   *          diagonal of the Schur form.
   *          = 'N': Eigenvalues are not ordered;
   *          = 'S': Eigenvalues are ordered (see SELECT).
   *
   *  SELECT  (external procedure) LOGICAL FUNCTION of two DOUBLE PRECISION
   *          SELECT must be declared EXTERNAL in the calling subroutine.
   *          If SORT = 'S', SELECT is used to select eigenvalues to sort
   *          to the top left of the Schur form.
   *          If SORT = 'N', SELECT is not referenced.
   *          An eigenvalue WR(j)+sqrt(-1)*WI(j) is selected if
   *          SELECT(WR(j),WI(j)) is true; i.e., if either one of a complex
   *          conjugate pair of eigenvalues is selected, then both complex
   *          eigenvalues are selected.
   *          Note that a selected complex eigenvalue may no longer
   *          satisfy SELECT(WR(j),WI(j)) = .TRUE. after ordering, since
   *          ordering may change the value of complex eigenvalues
   *          (especially if the eigenvalue is ill-conditioned); in this
   *          case INFO is set to N+2 (see INFO below).
   *
   *  N       (input) INTEGER
   *          The order of the matrix A. N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the N-by-N matrix A.
   *          On exit, A has been overwritten by its real Schur form T.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  SDIM    (output) INTEGER
   *          If SORT = 'N', SDIM = 0.
   *          If SORT = 'S', SDIM = number of eigenvalues (after sorting)
   *                         for which SELECT is true. (Complex conjugate
   *                         pairs for which SELECT is true for either
   *                         eigenvalue count as 2.)
   *
   *  WR      (output) DOUBLE PRECISION array, dimension (N)
   *  WI      (output) DOUBLE PRECISION array, dimension (N)
   *          WR and WI contain the real and imaginary parts,
   *          respectively, of the computed eigenvalues in the same order
   *          that they appear on the diagonal of the output Schur form T.
   *          Complex conjugate pairs of eigenvalues will appear
   *          consecutively with the eigenvalue having the positive
   *          imaginary part first.
   *
   *  VS      (output) DOUBLE PRECISION array, dimension (LDVS,N)
   *          If JOBVS = 'V', VS contains the orthogonal matrix Z of Schur
   *          vectors.
   *          If JOBVS = 'N', VS is not referenced.
   *
   *  LDVS    (input) INTEGER
   *          The leading dimension of the array VS.  LDVS >= 1; if
   *          JOBVS = 'V', LDVS >= N.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) contains the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,3*N).
   *          For good performance, LWORK must generally be larger.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  BWORK   (workspace) LOGICAL array, dimension (N)
   *          Not referenced if SORT = 'N'.
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value.
   *          > 0: if INFO = i, and i is
   *             <= N: the QR algorithm failed to compute all the
   *                   eigenvalues; elements 1:ILO-1 and i+1:N of WR and WI
   *                   contain those eigenvalues which have converged; if
   *                   JOBVS = 'V', VS contains the matrix which reduces A
   *                   to its partially converged Schur form.
   *             = N+1: the eigenvalues could not be reordered because some
   *                   eigenvalues were too close to separate (the problem
   *                   is very ill-conditioned);
   *             = N+2: after reordering, roundoff changed values of some
   *                   complex eigenvalues so that leading eigenvalues in
   *                   the Schur form no longer satisfy SELECT=.TRUE.  This
   *                   could also be caused by underflow due to scaling.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobvs
   * @param sort
   * @param select
   * @param n
   * @param a
   * @param lda
   * @param sdim
   * @param wr
   * @param wi
   * @param vs
   * @param ldvs
   * @param work
   * @param lwork
   * @param bwork
   * @param info
   * 
   */
  abstract public void dgees(java.lang.String jobvs, java.lang.String sort, java.lang.Object select, int n, double[] a, int lda, org.netlib.util.intW sdim, double[] wr, double[] wi, double[] vs, int ldvs, double[] work, int lwork, boolean[] bwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEES computes for an N-by-N real nonsymmetric matrix A, the
   *  eigenvalues, the real Schur form T, and, optionally, the matrix of
   *  Schur vectors Z.  This gives the Schur factorization A = Z*T*(Z**T).
   *
   *  Optionally, it also orders the eigenvalues on the diagonal of the
   *  real Schur form so that selected eigenvalues are at the top left.
   *  The leading columns of Z then form an orthonormal basis for the
   *  invariant subspace corresponding to the selected eigenvalues.
   *
   *  A matrix is in real Schur form if it is upper quasi-triangular with
   *  1-by-1 and 2-by-2 blocks. 2-by-2 blocks will be standardized in the
   *  form
   *          [  a  b  ]
   *          [  c  a  ]
   *
   *  where b*c < 0. The eigenvalues of such a block are a +- sqrt(bc).
   *
   *  Arguments
   *  =========
   *
   *  JOBVS   (input) CHARACTER*1
   *          = 'N': Schur vectors are not computed;
   *          = 'V': Schur vectors are computed.
   *
   *  SORT    (input) CHARACTER*1
   *          Specifies whether or not to order the eigenvalues on the
   *          diagonal of the Schur form.
   *          = 'N': Eigenvalues are not ordered;
   *          = 'S': Eigenvalues are ordered (see SELECT).
   *
   *  SELECT  (external procedure) LOGICAL FUNCTION of two DOUBLE PRECISION
   *          SELECT must be declared EXTERNAL in the calling subroutine.
   *          If SORT = 'S', SELECT is used to select eigenvalues to sort
   *          to the top left of the Schur form.
   *          If SORT = 'N', SELECT is not referenced.
   *          An eigenvalue WR(j)+sqrt(-1)*WI(j) is selected if
   *          SELECT(WR(j),WI(j)) is true; i.e., if either one of a complex
   *          conjugate pair of eigenvalues is selected, then both complex
   *          eigenvalues are selected.
   *          Note that a selected complex eigenvalue may no longer
   *          satisfy SELECT(WR(j),WI(j)) = .TRUE. after ordering, since
   *          ordering may change the value of complex eigenvalues
   *          (especially if the eigenvalue is ill-conditioned); in this
   *          case INFO is set to N+2 (see INFO below).
   *
   *  N       (input) INTEGER
   *          The order of the matrix A. N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the N-by-N matrix A.
   *          On exit, A has been overwritten by its real Schur form T.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  SDIM    (output) INTEGER
   *          If SORT = 'N', SDIM = 0.
   *          If SORT = 'S', SDIM = number of eigenvalues (after sorting)
   *                         for which SELECT is true. (Complex conjugate
   *                         pairs for which SELECT is true for either
   *                         eigenvalue count as 2.)
   *
   *  WR      (output) DOUBLE PRECISION array, dimension (N)
   *  WI      (output) DOUBLE PRECISION array, dimension (N)
   *          WR and WI contain the real and imaginary parts,
   *          respectively, of the computed eigenvalues in the same order
   *          that they appear on the diagonal of the output Schur form T.
   *          Complex conjugate pairs of eigenvalues will appear
   *          consecutively with the eigenvalue having the positive
   *          imaginary part first.
   *
   *  VS      (output) DOUBLE PRECISION array, dimension (LDVS,N)
   *          If JOBVS = 'V', VS contains the orthogonal matrix Z of Schur
   *          vectors.
   *          If JOBVS = 'N', VS is not referenced.
   *
   *  LDVS    (input) INTEGER
   *          The leading dimension of the array VS.  LDVS >= 1; if
   *          JOBVS = 'V', LDVS >= N.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) contains the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,3*N).
   *          For good performance, LWORK must generally be larger.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  BWORK   (workspace) LOGICAL array, dimension (N)
   *          Not referenced if SORT = 'N'.
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value.
   *          > 0: if INFO = i, and i is
   *             <= N: the QR algorithm failed to compute all the
   *                   eigenvalues; elements 1:ILO-1 and i+1:N of WR and WI
   *                   contain those eigenvalues which have converged; if
   *                   JOBVS = 'V', VS contains the matrix which reduces A
   *                   to its partially converged Schur form.
   *             = N+1: the eigenvalues could not be reordered because some
   *                   eigenvalues were too close to separate (the problem
   *                   is very ill-conditioned);
   *             = N+2: after reordering, roundoff changed values of some
   *                   complex eigenvalues so that leading eigenvalues in
   *                   the Schur form no longer satisfy SELECT=.TRUE.  This
   *                   could also be caused by underflow due to scaling.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobvs
   * @param sort
   * @param select
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param sdim
   * @param wr
   * @param _wr_offset
   * @param wi
   * @param _wi_offset
   * @param vs
   * @param _vs_offset
   * @param ldvs
   * @param work
   * @param _work_offset
   * @param lwork
   * @param bwork
   * @param _bwork_offset
   * @param info
   * 
   */
  abstract public void dgees(java.lang.String jobvs, java.lang.String sort, java.lang.Object select, int n, double[] a, int _a_offset, int lda, org.netlib.util.intW sdim, double[] wr, int _wr_offset, double[] wi, int _wi_offset, double[] vs, int _vs_offset, int ldvs, double[] work, int _work_offset, int lwork, boolean[] bwork, int _bwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEESX computes for an N-by-N real nonsymmetric matrix A, the
   *  eigenvalues, the real Schur form T, and, optionally, the matrix of
   *  Schur vectors Z.  This gives the Schur factorization A = Z*T*(Z**T).
   *
   *  Optionally, it also orders the eigenvalues on the diagonal of the
   *  real Schur form so that selected eigenvalues are at the top left;
   *  computes a reciprocal condition number for the average of the
   *  selected eigenvalues (RCONDE); and computes a reciprocal condition
   *  number for the right invariant subspace corresponding to the
   *  selected eigenvalues (RCONDV).  The leading columns of Z form an
   *  orthonormal basis for this invariant subspace.
   *
   *  For further explanation of the reciprocal condition numbers RCONDE
   *  and RCONDV, see Section 4.10 of the LAPACK Users' Guide (where
   *  these quantities are called s and sep respectively).
   *
   *  A real matrix is in real Schur form if it is upper quasi-triangular
   *  with 1-by-1 and 2-by-2 blocks. 2-by-2 blocks will be standardized in
   *  the form
   *            [  a  b  ]
   *            [  c  a  ]
   *
   *  where b*c < 0. The eigenvalues of such a block are a +- sqrt(bc).
   *
   *  Arguments
   *  =========
   *
   *  JOBVS   (input) CHARACTER*1
   *          = 'N': Schur vectors are not computed;
   *          = 'V': Schur vectors are computed.
   *
   *  SORT    (input) CHARACTER*1
   *          Specifies whether or not to order the eigenvalues on the
   *          diagonal of the Schur form.
   *          = 'N': Eigenvalues are not ordered;
   *          = 'S': Eigenvalues are ordered (see SELECT).
   *
   *  SELECT  (external procedure) LOGICAL FUNCTION of two DOUBLE PRECISION
   *          SELECT must be declared EXTERNAL in the calling subroutine.
   *          If SORT = 'S', SELECT is used to select eigenvalues to sort
   *          to the top left of the Schur form.
   *          If SORT = 'N', SELECT is not referenced.
   *          An eigenvalue WR(j)+sqrt(-1)*WI(j) is selected if
   *          SELECT(WR(j),WI(j)) is true; i.e., if either one of a
   *          complex conjugate pair of eigenvalues is selected, then both
   *          are.  Note that a selected complex eigenvalue may no longer
   *          satisfy SELECT(WR(j),WI(j)) = .TRUE. after ordering, since
   *          ordering may change the value of complex eigenvalues
   *          (especially if the eigenvalue is ill-conditioned); in this
   *          case INFO may be set to N+3 (see INFO below).
   *
   *  SENSE   (input) CHARACTER*1
   *          Determines which reciprocal condition numbers are computed.
   *          = 'N': None are computed;
   *          = 'E': Computed for average of selected eigenvalues only;
   *          = 'V': Computed for selected right invariant subspace only;
   *          = 'B': Computed for both.
   *          If SENSE = 'E', 'V' or 'B', SORT must equal 'S'.
   *
   *  N       (input) INTEGER
   *          The order of the matrix A. N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
   *          On entry, the N-by-N matrix A.
   *          On exit, A is overwritten by its real Schur form T.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  SDIM    (output) INTEGER
   *          If SORT = 'N', SDIM = 0.
   *          If SORT = 'S', SDIM = number of eigenvalues (after sorting)
   *                         for which SELECT is true. (Complex conjugate
   *                         pairs for which SELECT is true for either
   *                         eigenvalue count as 2.)
   *
   *  WR      (output) DOUBLE PRECISION array, dimension (N)
   *  WI      (output) DOUBLE PRECISION array, dimension (N)
   *          WR and WI contain the real and imaginary parts, respectively,
   *          of the computed eigenvalues, in the same order that they
   *          appear on the diagonal of the output Schur form T.  Complex
   *          conjugate pairs of eigenvalues appear consecutively with the
   *          eigenvalue having the positive imaginary part first.
   *
   *  VS      (output) DOUBLE PRECISION array, dimension (LDVS,N)
   *          If JOBVS = 'V', VS contains the orthogonal matrix Z of Schur
   *          vectors.
   *          If JOBVS = 'N', VS is not referenced.
   *
   *  LDVS    (input) INTEGER
   *          The leading dimension of the array VS.  LDVS >= 1, and if
   *          JOBVS = 'V', LDVS >= N.
   *
   *  RCONDE  (output) DOUBLE PRECISION
   *          If SENSE = 'E' or 'B', RCONDE contains the reciprocal
   *          condition number for the average of the selected eigenvalues.
   *          Not referenced if SENSE = 'N' or 'V'.
   *
   *  RCONDV  (output) DOUBLE PRECISION
   *          If SENSE = 'V' or 'B', RCONDV contains the reciprocal
   *          condition number for the selected right invariant subspace.
   *          Not referenced if SENSE = 'N' or 'E'.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,3*N).
   *          Also, if SENSE = 'E' or 'V' or 'B',
   *          LWORK >= N+2*SDIM*(N-SDIM), where SDIM is the number of
   *          selected eigenvalues computed by this routine.  Note that
   *          N+2*SDIM*(N-SDIM) <= N+N*N/2. Note also that an error is only
   *          returned if LWORK < max(1,3*N), but if SENSE = 'E' or 'V' or
   *          'B' this may not be large enough.
   *          For good performance, LWORK must generally be larger.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates upper bounds on the optimal sizes of the
   *          arrays WORK and IWORK, returns these values as the first
   *          entries of the WORK and IWORK arrays, and no error messages
   *          related to LWORK or LIWORK are issued by XERBLA.
   *
   *  IWORK   (workspace/output) INTEGER array, dimension (MAX(1,LIWORK))
   *          On exit, if INFO = 0, IWORK(1) returns the optimal LIWORK.
   *
   *  LIWORK  (input) INTEGER
   *          The dimension of the array IWORK.
   *          LIWORK >= 1; if SENSE = 'V' or 'B', LIWORK >= SDIM*(N-SDIM).
   *          Note that SDIM*(N-SDIM) <= N*N/4. Note also that an error is
   *          only returned if LIWORK < 1, but if SENSE = 'V' or 'B' this
   *          may not be large enough.
   *
   *          If LIWORK = -1, then a workspace query is assumed; the
   *          routine only calculates upper bounds on the optimal sizes of
   *          the arrays WORK and IWORK, returns these values as the first
   *          entries of the WORK and IWORK arrays, and no error messages
   *          related to LWORK or LIWORK are issued by XERBLA.
   *
   *  BWORK   (workspace) LOGICAL array, dimension (N)
   *          Not referenced if SORT = 'N'.
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value.
   *          > 0: if INFO = i, and i is
   *             <= N: the QR algorithm failed to compute all the
   *                   eigenvalues; elements 1:ILO-1 and i+1:N of WR and WI
   *                   contain those eigenvalues which have converged; if
   *                   JOBVS = 'V', VS contains the transformation which
   *                   reduces A to its partially converged Schur form.
   *             = N+1: the eigenvalues could not be reordered because some
   *                   eigenvalues were too close to separate (the problem
   *                   is very ill-conditioned);
   *             = N+2: after reordering, roundoff changed values of some
   *                   complex eigenvalues so that leading eigenvalues in
   *                   the Schur form no longer satisfy SELECT=.TRUE.  This
   *                   could also be caused by underflow due to scaling.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobvs
   * @param sort
   * @param select
   * @param sense
   * @param n
   * @param a
   * @param lda
   * @param sdim
   * @param wr
   * @param wi
   * @param vs
   * @param ldvs
   * @param rconde
   * @param rcondv
   * @param work
   * @param lwork
   * @param iwork
   * @param liwork
   * @param bwork
   * @param info
   * 
   */
  abstract public void dgeesx(java.lang.String jobvs, java.lang.String sort, java.lang.Object select, java.lang.String sense, int n, double[] a, int lda, org.netlib.util.intW sdim, double[] wr, double[] wi, double[] vs, int ldvs, org.netlib.util.doubleW rconde, org.netlib.util.doubleW rcondv, double[] work, int lwork, int[] iwork, int liwork, boolean[] bwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEESX computes for an N-by-N real nonsymmetric matrix A, the
   *  eigenvalues, the real Schur form T, and, optionally, the matrix of
   *  Schur vectors Z.  This gives the Schur factorization A = Z*T*(Z**T).
   *
   *  Optionally, it also orders the eigenvalues on the diagonal of the
   *  real Schur form so that selected eigenvalues are at the top left;
   *  computes a reciprocal condition number for the average of the
   *  selected eigenvalues (RCONDE); and computes a reciprocal condition
   *  number for the right invariant subspace corresponding to the
   *  selected eigenvalues (RCONDV).  The leading columns of Z form an
   *  orthonormal basis for this invariant subspace.
   *
   *  For further explanation of the reciprocal condition numbers RCONDE
   *  and RCONDV, see Section 4.10 of the LAPACK Users' Guide (where
   *  these quantities are called s and sep respectively).
   *
   *  A real matrix is in real Schur form if it is upper quasi-triangular
   *  with 1-by-1 and 2-by-2 blocks. 2-by-2 blocks will be standardized in
   *  the form
   *            [  a  b  ]
   *            [  c  a  ]
   *
   *  where b*c < 0. The eigenvalues of such a block are a +- sqrt(bc).
   *
   *  Arguments
   *  =========
   *
   *  JOBVS   (input) CHARACTER*1
   *          = 'N': Schur vectors are not computed;
   *          = 'V': Schur vectors are computed.
   *
   *  SORT    (input) CHARACTER*1
   *          Specifies whether or not to order the eigenvalues on the
   *          diagonal of the Schur form.
   *          = 'N': Eigenvalues are not ordered;
   *          = 'S': Eigenvalues are ordered (see SELECT).
   *
   *  SELECT  (external procedure) LOGICAL FUNCTION of two DOUBLE PRECISION
   *          SELECT must be declared EXTERNAL in the calling subroutine.
   *          If SORT = 'S', SELECT is used to select eigenvalues to sort
   *          to the top left of the Schur form.
   *          If SORT = 'N', SELECT is not referenced.
   *          An eigenvalue WR(j)+sqrt(-1)*WI(j) is selected if
   *          SELECT(WR(j),WI(j)) is true; i.e., if either one of a
   *          complex conjugate pair of eigenvalues is selected, then both
   *          are.  Note that a selected complex eigenvalue may no longer
   *          satisfy SELECT(WR(j),WI(j)) = .TRUE. after ordering, since
   *          ordering may change the value of complex eigenvalues
   *          (especially if the eigenvalue is ill-conditioned); in this
   *          case INFO may be set to N+3 (see INFO below).
   *
   *  SENSE   (input) CHARACTER*1
   *          Determines which reciprocal condition numbers are computed.
   *          = 'N': None are computed;
   *          = 'E': Computed for average of selected eigenvalues only;
   *          = 'V': Computed for selected right invariant subspace only;
   *          = 'B': Computed for both.
   *          If SENSE = 'E', 'V' or 'B', SORT must equal 'S'.
   *
   *  N       (input) INTEGER
   *          The order of the matrix A. N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
   *          On entry, the N-by-N matrix A.
   *          On exit, A is overwritten by its real Schur form T.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  SDIM    (output) INTEGER
   *          If SORT = 'N', SDIM = 0.
   *          If SORT = 'S', SDIM = number of eigenvalues (after sorting)
   *                         for which SELECT is true. (Complex conjugate
   *                         pairs for which SELECT is true for either
   *                         eigenvalue count as 2.)
   *
   *  WR      (output) DOUBLE PRECISION array, dimension (N)
   *  WI      (output) DOUBLE PRECISION array, dimension (N)
   *          WR and WI contain the real and imaginary parts, respectively,
   *          of the computed eigenvalues, in the same order that they
   *          appear on the diagonal of the output Schur form T.  Complex
   *          conjugate pairs of eigenvalues appear consecutively with the
   *          eigenvalue having the positive imaginary part first.
   *
   *  VS      (output) DOUBLE PRECISION array, dimension (LDVS,N)
   *          If JOBVS = 'V', VS contains the orthogonal matrix Z of Schur
   *          vectors.
   *          If JOBVS = 'N', VS is not referenced.
   *
   *  LDVS    (input) INTEGER
   *          The leading dimension of the array VS.  LDVS >= 1, and if
   *          JOBVS = 'V', LDVS >= N.
   *
   *  RCONDE  (output) DOUBLE PRECISION
   *          If SENSE = 'E' or 'B', RCONDE contains the reciprocal
   *          condition number for the average of the selected eigenvalues.
   *          Not referenced if SENSE = 'N' or 'V'.
   *
   *  RCONDV  (output) DOUBLE PRECISION
   *          If SENSE = 'V' or 'B', RCONDV contains the reciprocal
   *          condition number for the selected right invariant subspace.
   *          Not referenced if SENSE = 'N' or 'E'.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,3*N).
   *          Also, if SENSE = 'E' or 'V' or 'B',
   *          LWORK >= N+2*SDIM*(N-SDIM), where SDIM is the number of
   *          selected eigenvalues computed by this routine.  Note that
   *          N+2*SDIM*(N-SDIM) <= N+N*N/2. Note also that an error is only
   *          returned if LWORK < max(1,3*N), but if SENSE = 'E' or 'V' or
   *          'B' this may not be large enough.
   *          For good performance, LWORK must generally be larger.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates upper bounds on the optimal sizes of the
   *          arrays WORK and IWORK, returns these values as the first
   *          entries of the WORK and IWORK arrays, and no error messages
   *          related to LWORK or LIWORK are issued by XERBLA.
   *
   *  IWORK   (workspace/output) INTEGER array, dimension (MAX(1,LIWORK))
   *          On exit, if INFO = 0, IWORK(1) returns the optimal LIWORK.
   *
   *  LIWORK  (input) INTEGER
   *          The dimension of the array IWORK.
   *          LIWORK >= 1; if SENSE = 'V' or 'B', LIWORK >= SDIM*(N-SDIM).
   *          Note that SDIM*(N-SDIM) <= N*N/4. Note also that an error is
   *          only returned if LIWORK < 1, but if SENSE = 'V' or 'B' this
   *          may not be large enough.
   *
   *          If LIWORK = -1, then a workspace query is assumed; the
   *          routine only calculates upper bounds on the optimal sizes of
   *          the arrays WORK and IWORK, returns these values as the first
   *          entries of the WORK and IWORK arrays, and no error messages
   *          related to LWORK or LIWORK are issued by XERBLA.
   *
   *  BWORK   (workspace) LOGICAL array, dimension (N)
   *          Not referenced if SORT = 'N'.
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value.
   *          > 0: if INFO = i, and i is
   *             <= N: the QR algorithm failed to compute all the
   *                   eigenvalues; elements 1:ILO-1 and i+1:N of WR and WI
   *                   contain those eigenvalues which have converged; if
   *                   JOBVS = 'V', VS contains the transformation which
   *                   reduces A to its partially converged Schur form.
   *             = N+1: the eigenvalues could not be reordered because some
   *                   eigenvalues were too close to separate (the problem
   *                   is very ill-conditioned);
   *             = N+2: after reordering, roundoff changed values of some
   *                   complex eigenvalues so that leading eigenvalues in
   *                   the Schur form no longer satisfy SELECT=.TRUE.  This
   *                   could also be caused by underflow due to scaling.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobvs
   * @param sort
   * @param select
   * @param sense
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param sdim
   * @param wr
   * @param _wr_offset
   * @param wi
   * @param _wi_offset
   * @param vs
   * @param _vs_offset
   * @param ldvs
   * @param rconde
   * @param rcondv
   * @param work
   * @param _work_offset
   * @param lwork
   * @param iwork
   * @param _iwork_offset
   * @param liwork
   * @param bwork
   * @param _bwork_offset
   * @param info
   * 
   */
  abstract public void dgeesx(java.lang.String jobvs, java.lang.String sort, java.lang.Object select, java.lang.String sense, int n, double[] a, int _a_offset, int lda, org.netlib.util.intW sdim, double[] wr, int _wr_offset, double[] wi, int _wi_offset, double[] vs, int _vs_offset, int ldvs, org.netlib.util.doubleW rconde, org.netlib.util.doubleW rcondv, double[] work, int _work_offset, int lwork, int[] iwork, int _iwork_offset, int liwork, boolean[] bwork, int _bwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEEV computes for an N-by-N real nonsymmetric matrix A, the
   *  eigenvalues and, optionally, the left and/or right eigenvectors.
   *
   *  The right eigenvector v(j) of A satisfies
   *                   A * v(j) = lambda(j) * v(j)
   *  where lambda(j) is its eigenvalue.
   *  The left eigenvector u(j) of A satisfies
   *                u(j)**H * A = lambda(j) * u(j)**H
   *  where u(j)**H denotes the conjugate transpose of u(j).
   *
   *  The computed eigenvectors are normalized to have Euclidean norm
   *  equal to 1 and largest component real.
   *
   *  Arguments
   *  =========
   *
   *  JOBVL   (input) CHARACTER*1
   *          = 'N': left eigenvectors of A are not computed;
   *          = 'V': left eigenvectors of A are computed.
   *
   *  JOBVR   (input) CHARACTER*1
   *          = 'N': right eigenvectors of A are not computed;
   *          = 'V': right eigenvectors of A are computed.
   *
   *  N       (input) INTEGER
   *          The order of the matrix A. N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the N-by-N matrix A.
   *          On exit, A has been overwritten.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  WR      (output) DOUBLE PRECISION array, dimension (N)
   *  WI      (output) DOUBLE PRECISION array, dimension (N)
   *          WR and WI contain the real and imaginary parts,
   *          respectively, of the computed eigenvalues.  Complex
   *          conjugate pairs of eigenvalues appear consecutively
   *          with the eigenvalue having the positive imaginary part
   *          first.
   *
   *  VL      (output) DOUBLE PRECISION array, dimension (LDVL,N)
   *          If JOBVL = 'V', the left eigenvectors u(j) are stored one
   *          after another in the columns of VL, in the same order
   *          as their eigenvalues.
   *          If JOBVL = 'N', VL is not referenced.
   *          If the j-th eigenvalue is real, then u(j) = VL(:,j),
   *          the j-th column of VL.
   *          If the j-th and (j+1)-st eigenvalues form a complex
   *          conjugate pair, then u(j) = VL(:,j) + i*VL(:,j+1) and
   *          u(j+1) = VL(:,j) - i*VL(:,j+1).
   *
   *  LDVL    (input) INTEGER
   *          The leading dimension of the array VL.  LDVL >= 1; if
   *          JOBVL = 'V', LDVL >= N.
   *
   *  VR      (output) DOUBLE PRECISION array, dimension (LDVR,N)
   *          If JOBVR = 'V', the right eigenvectors v(j) are stored one
   *          after another in the columns of VR, in the same order
   *          as their eigenvalues.
   *          If JOBVR = 'N', VR is not referenced.
   *          If the j-th eigenvalue is real, then v(j) = VR(:,j),
   *          the j-th column of VR.
   *          If the j-th and (j+1)-st eigenvalues form a complex
   *          conjugate pair, then v(j) = VR(:,j) + i*VR(:,j+1) and
   *          v(j+1) = VR(:,j) - i*VR(:,j+1).
   *
   *  LDVR    (input) INTEGER
   *          The leading dimension of the array VR.  LDVR >= 1; if
   *          JOBVR = 'V', LDVR >= N.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,3*N), and
   *          if JOBVL = 'V' or JOBVR = 'V', LWORK >= 4*N.  For good
   *          performance, LWORK must generally be larger.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  if INFO = i, the QR algorithm failed to compute all the
   *                eigenvalues, and no eigenvectors have been computed;
   *                elements i+1:N of WR and WI contain eigenvalues which
   *                have converged.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobvl
   * @param jobvr
   * @param n
   * @param a
   * @param lda
   * @param wr
   * @param wi
   * @param vl
   * @param ldvl
   * @param vr
   * @param ldvr
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgeev(java.lang.String jobvl, java.lang.String jobvr, int n, double[] a, int lda, double[] wr, double[] wi, double[] vl, int ldvl, double[] vr, int ldvr, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEEV computes for an N-by-N real nonsymmetric matrix A, the
   *  eigenvalues and, optionally, the left and/or right eigenvectors.
   *
   *  The right eigenvector v(j) of A satisfies
   *                   A * v(j) = lambda(j) * v(j)
   *  where lambda(j) is its eigenvalue.
   *  The left eigenvector u(j) of A satisfies
   *                u(j)**H * A = lambda(j) * u(j)**H
   *  where u(j)**H denotes the conjugate transpose of u(j).
   *
   *  The computed eigenvectors are normalized to have Euclidean norm
   *  equal to 1 and largest component real.
   *
   *  Arguments
   *  =========
   *
   *  JOBVL   (input) CHARACTER*1
   *          = 'N': left eigenvectors of A are not computed;
   *          = 'V': left eigenvectors of A are computed.
   *
   *  JOBVR   (input) CHARACTER*1
   *          = 'N': right eigenvectors of A are not computed;
   *          = 'V': right eigenvectors of A are computed.
   *
   *  N       (input) INTEGER
   *          The order of the matrix A. N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the N-by-N matrix A.
   *          On exit, A has been overwritten.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  WR      (output) DOUBLE PRECISION array, dimension (N)
   *  WI      (output) DOUBLE PRECISION array, dimension (N)
   *          WR and WI contain the real and imaginary parts,
   *          respectively, of the computed eigenvalues.  Complex
   *          conjugate pairs of eigenvalues appear consecutively
   *          with the eigenvalue having the positive imaginary part
   *          first.
   *
   *  VL      (output) DOUBLE PRECISION array, dimension (LDVL,N)
   *          If JOBVL = 'V', the left eigenvectors u(j) are stored one
   *          after another in the columns of VL, in the same order
   *          as their eigenvalues.
   *          If JOBVL = 'N', VL is not referenced.
   *          If the j-th eigenvalue is real, then u(j) = VL(:,j),
   *          the j-th column of VL.
   *          If the j-th and (j+1)-st eigenvalues form a complex
   *          conjugate pair, then u(j) = VL(:,j) + i*VL(:,j+1) and
   *          u(j+1) = VL(:,j) - i*VL(:,j+1).
   *
   *  LDVL    (input) INTEGER
   *          The leading dimension of the array VL.  LDVL >= 1; if
   *          JOBVL = 'V', LDVL >= N.
   *
   *  VR      (output) DOUBLE PRECISION array, dimension (LDVR,N)
   *          If JOBVR = 'V', the right eigenvectors v(j) are stored one
   *          after another in the columns of VR, in the same order
   *          as their eigenvalues.
   *          If JOBVR = 'N', VR is not referenced.
   *          If the j-th eigenvalue is real, then v(j) = VR(:,j),
   *          the j-th column of VR.
   *          If the j-th and (j+1)-st eigenvalues form a complex
   *          conjugate pair, then v(j) = VR(:,j) + i*VR(:,j+1) and
   *          v(j+1) = VR(:,j) - i*VR(:,j+1).
   *
   *  LDVR    (input) INTEGER
   *          The leading dimension of the array VR.  LDVR >= 1; if
   *          JOBVR = 'V', LDVR >= N.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,3*N), and
   *          if JOBVL = 'V' or JOBVR = 'V', LWORK >= 4*N.  For good
   *          performance, LWORK must generally be larger.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  if INFO = i, the QR algorithm failed to compute all the
   *                eigenvalues, and no eigenvectors have been computed;
   *                elements i+1:N of WR and WI contain eigenvalues which
   *                have converged.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobvl
   * @param jobvr
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param wr
   * @param _wr_offset
   * @param wi
   * @param _wi_offset
   * @param vl
   * @param _vl_offset
   * @param ldvl
   * @param vr
   * @param _vr_offset
   * @param ldvr
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgeev(java.lang.String jobvl, java.lang.String jobvr, int n, double[] a, int _a_offset, int lda, double[] wr, int _wr_offset, double[] wi, int _wi_offset, double[] vl, int _vl_offset, int ldvl, double[] vr, int _vr_offset, int ldvr, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEEVX computes for an N-by-N real nonsymmetric matrix A, the
   *  eigenvalues and, optionally, the left and/or right eigenvectors.
   *
   *  Optionally also, it computes a balancing transformation to improve
   *  the conditioning of the eigenvalues and eigenvectors (ILO, IHI,
   *  SCALE, and ABNRM), reciprocal condition numbers for the eigenvalues
   *  (RCONDE), and reciprocal condition numbers for the right
   *  eigenvectors (RCONDV).
   *
   *  The right eigenvector v(j) of A satisfies
   *                   A * v(j) = lambda(j) * v(j)
   *  where lambda(j) is its eigenvalue.
   *  The left eigenvector u(j) of A satisfies
   *                u(j)**H * A = lambda(j) * u(j)**H
   *  where u(j)**H denotes the conjugate transpose of u(j).
   *
   *  The computed eigenvectors are normalized to have Euclidean norm
   *  equal to 1 and largest component real.
   *
   *  Balancing a matrix means permuting the rows and columns to make it
   *  more nearly upper triangular, and applying a diagonal similarity
   *  transformation D * A * D**(-1), where D is a diagonal matrix, to
   *  make its rows and columns closer in norm and the condition numbers
   *  of its eigenvalues and eigenvectors smaller.  The computed
   *  reciprocal condition numbers correspond to the balanced matrix.
   *  Permuting rows and columns will not change the condition numbers
   *  (in exact arithmetic) but diagonal scaling will.  For further
   *  explanation of balancing, see section 4.10.2 of the LAPACK
   *  Users' Guide.
   *
   *  Arguments
   *  =========
   *
   *  BALANC  (input) CHARACTER*1
   *          Indicates how the input matrix should be diagonally scaled
   *          and/or permuted to improve the conditioning of its
   *          eigenvalues.
   *          = 'N': Do not diagonally scale or permute;
   *          = 'P': Perform permutations to make the matrix more nearly
   *                 upper triangular. Do not diagonally scale;
   *          = 'S': Diagonally scale the matrix, i.e. replace A by
   *                 D*A*D**(-1), where D is a diagonal matrix chosen
   *                 to make the rows and columns of A more equal in
   *                 norm. Do not permute;
   *          = 'B': Both diagonally scale and permute A.
   *
   *          Computed reciprocal condition numbers will be for the matrix
   *          after balancing and/or permuting. Permuting does not change
   *          condition numbers (in exact arithmetic), but balancing does.
   *
   *  JOBVL   (input) CHARACTER*1
   *          = 'N': left eigenvectors of A are not computed;
   *          = 'V': left eigenvectors of A are computed.
   *          If SENSE = 'E' or 'B', JOBVL must = 'V'.
   *
   *  JOBVR   (input) CHARACTER*1
   *          = 'N': right eigenvectors of A are not computed;
   *          = 'V': right eigenvectors of A are computed.
   *          If SENSE = 'E' or 'B', JOBVR must = 'V'.
   *
   *  SENSE   (input) CHARACTER*1
   *          Determines which reciprocal condition numbers are computed.
   *          = 'N': None are computed;
   *          = 'E': Computed for eigenvalues only;
   *          = 'V': Computed for right eigenvectors only;
   *          = 'B': Computed for eigenvalues and right eigenvectors.
   *
   *          If SENSE = 'E' or 'B', both left and right eigenvectors
   *          must also be computed (JOBVL = 'V' and JOBVR = 'V').
   *
   *  N       (input) INTEGER
   *          The order of the matrix A. N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the N-by-N matrix A.
   *          On exit, A has been overwritten.  If JOBVL = 'V' or
   *          JOBVR = 'V', A contains the real Schur form of the balanced
   *          version of the input matrix A.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  WR      (output) DOUBLE PRECISION array, dimension (N)
   *  WI      (output) DOUBLE PRECISION array, dimension (N)
   *          WR and WI contain the real and imaginary parts,
   *          respectively, of the computed eigenvalues.  Complex
   *          conjugate pairs of eigenvalues will appear consecutively
   *          with the eigenvalue having the positive imaginary part
   *          first.
   *
   *  VL      (output) DOUBLE PRECISION array, dimension (LDVL,N)
   *          If JOBVL = 'V', the left eigenvectors u(j) are stored one
   *          after another in the columns of VL, in the same order
   *          as their eigenvalues.
   *          If JOBVL = 'N', VL is not referenced.
   *          If the j-th eigenvalue is real, then u(j) = VL(:,j),
   *          the j-th column of VL.
   *          If the j-th and (j+1)-st eigenvalues form a complex
   *          conjugate pair, then u(j) = VL(:,j) + i*VL(:,j+1) and
   *          u(j+1) = VL(:,j) - i*VL(:,j+1).
   *
   *  LDVL    (input) INTEGER
   *          The leading dimension of the array VL.  LDVL >= 1; if
   *          JOBVL = 'V', LDVL >= N.
   *
   *  VR      (output) DOUBLE PRECISION array, dimension (LDVR,N)
   *          If JOBVR = 'V', the right eigenvectors v(j) are stored one
   *          after another in the columns of VR, in the same order
   *          as their eigenvalues.
   *          If JOBVR = 'N', VR is not referenced.
   *          If the j-th eigenvalue is real, then v(j) = VR(:,j),
   *          the j-th column of VR.
   *          If the j-th and (j+1)-st eigenvalues form a complex
   *          conjugate pair, then v(j) = VR(:,j) + i*VR(:,j+1) and
   *          v(j+1) = VR(:,j) - i*VR(:,j+1).
   *
   *  LDVR    (input) INTEGER
   *          The leading dimension of the array VR.  LDVR >= 1, and if
   *          JOBVR = 'V', LDVR >= N.
   *
   *  ILO     (output) INTEGER
   *  IHI     (output) INTEGER
   *          ILO and IHI are integer values determined when A was
   *          balanced.  The balanced A(i,j) = 0 if I > J and
   *          J = 1,...,ILO-1 or I = IHI+1,...,N.
   *
   *  SCALE   (output) DOUBLE PRECISION array, dimension (N)
   *          Details of the permutations and scaling factors applied
   *          when balancing A.  If P(j) is the index of the row and column
   *          interchanged with row and column j, and D(j) is the scaling
   *          factor applied to row and column j, then
   *          SCALE(J) = P(J),    for J = 1,...,ILO-1
   *                   = D(J),    for J = ILO,...,IHI
   *                   = P(J)     for J = IHI+1,...,N.
   *          The order in which the interchanges are made is N to IHI+1,
   *          then 1 to ILO-1.
   *
   *  ABNRM   (output) DOUBLE PRECISION
   *          The one-norm of the balanced matrix (the maximum
   *          of the sum of absolute values of elements of any column).
   *
   *  RCONDE  (output) DOUBLE PRECISION array, dimension (N)
   *          RCONDE(j) is the reciprocal condition number of the j-th
   *          eigenvalue.
   *
   *  RCONDV  (output) DOUBLE PRECISION array, dimension (N)
   *          RCONDV(j) is the reciprocal condition number of the j-th
   *          right eigenvector.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.   If SENSE = 'N' or 'E',
   *          LWORK >= max(1,2*N), and if JOBVL = 'V' or JOBVR = 'V',
   *          LWORK >= 3*N.  If SENSE = 'V' or 'B', LWORK >= N*(N+6).
   *          For good performance, LWORK must generally be larger.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  IWORK   (workspace) INTEGER array, dimension (2*N-2)
   *          If SENSE = 'N' or 'E', not referenced.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  if INFO = i, the QR algorithm failed to compute all the
   *                eigenvalues, and no eigenvectors or condition numbers
   *                have been computed; elements 1:ILO-1 and i+1:N of WR
   *                and WI contain eigenvalues which have converged.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param balanc
   * @param jobvl
   * @param jobvr
   * @param sense
   * @param n
   * @param a
   * @param lda
   * @param wr
   * @param wi
   * @param vl
   * @param ldvl
   * @param vr
   * @param ldvr
   * @param ilo
   * @param ihi
   * @param scale
   * @param abnrm
   * @param rconde
   * @param rcondv
   * @param work
   * @param lwork
   * @param iwork
   * @param info
   * 
   */
  abstract public void dgeevx(java.lang.String balanc, java.lang.String jobvl, java.lang.String jobvr, java.lang.String sense, int n, double[] a, int lda, double[] wr, double[] wi, double[] vl, int ldvl, double[] vr, int ldvr, org.netlib.util.intW ilo, org.netlib.util.intW ihi, double[] scale, org.netlib.util.doubleW abnrm, double[] rconde, double[] rcondv, double[] work, int lwork, int[] iwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEEVX computes for an N-by-N real nonsymmetric matrix A, the
   *  eigenvalues and, optionally, the left and/or right eigenvectors.
   *
   *  Optionally also, it computes a balancing transformation to improve
   *  the conditioning of the eigenvalues and eigenvectors (ILO, IHI,
   *  SCALE, and ABNRM), reciprocal condition numbers for the eigenvalues
   *  (RCONDE), and reciprocal condition numbers for the right
   *  eigenvectors (RCONDV).
   *
   *  The right eigenvector v(j) of A satisfies
   *                   A * v(j) = lambda(j) * v(j)
   *  where lambda(j) is its eigenvalue.
   *  The left eigenvector u(j) of A satisfies
   *                u(j)**H * A = lambda(j) * u(j)**H
   *  where u(j)**H denotes the conjugate transpose of u(j).
   *
   *  The computed eigenvectors are normalized to have Euclidean norm
   *  equal to 1 and largest component real.
   *
   *  Balancing a matrix means permuting the rows and columns to make it
   *  more nearly upper triangular, and applying a diagonal similarity
   *  transformation D * A * D**(-1), where D is a diagonal matrix, to
   *  make its rows and columns closer in norm and the condition numbers
   *  of its eigenvalues and eigenvectors smaller.  The computed
   *  reciprocal condition numbers correspond to the balanced matrix.
   *  Permuting rows and columns will not change the condition numbers
   *  (in exact arithmetic) but diagonal scaling will.  For further
   *  explanation of balancing, see section 4.10.2 of the LAPACK
   *  Users' Guide.
   *
   *  Arguments
   *  =========
   *
   *  BALANC  (input) CHARACTER*1
   *          Indicates how the input matrix should be diagonally scaled
   *          and/or permuted to improve the conditioning of its
   *          eigenvalues.
   *          = 'N': Do not diagonally scale or permute;
   *          = 'P': Perform permutations to make the matrix more nearly
   *                 upper triangular. Do not diagonally scale;
   *          = 'S': Diagonally scale the matrix, i.e. replace A by
   *                 D*A*D**(-1), where D is a diagonal matrix chosen
   *                 to make the rows and columns of A more equal in
   *                 norm. Do not permute;
   *          = 'B': Both diagonally scale and permute A.
   *
   *          Computed reciprocal condition numbers will be for the matrix
   *          after balancing and/or permuting. Permuting does not change
   *          condition numbers (in exact arithmetic), but balancing does.
   *
   *  JOBVL   (input) CHARACTER*1
   *          = 'N': left eigenvectors of A are not computed;
   *          = 'V': left eigenvectors of A are computed.
   *          If SENSE = 'E' or 'B', JOBVL must = 'V'.
   *
   *  JOBVR   (input) CHARACTER*1
   *          = 'N': right eigenvectors of A are not computed;
   *          = 'V': right eigenvectors of A are computed.
   *          If SENSE = 'E' or 'B', JOBVR must = 'V'.
   *
   *  SENSE   (input) CHARACTER*1
   *          Determines which reciprocal condition numbers are computed.
   *          = 'N': None are computed;
   *          = 'E': Computed for eigenvalues only;
   *          = 'V': Computed for right eigenvectors only;
   *          = 'B': Computed for eigenvalues and right eigenvectors.
   *
   *          If SENSE = 'E' or 'B', both left and right eigenvectors
   *          must also be computed (JOBVL = 'V' and JOBVR = 'V').
   *
   *  N       (input) INTEGER
   *          The order of the matrix A. N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the N-by-N matrix A.
   *          On exit, A has been overwritten.  If JOBVL = 'V' or
   *          JOBVR = 'V', A contains the real Schur form of the balanced
   *          version of the input matrix A.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  WR      (output) DOUBLE PRECISION array, dimension (N)
   *  WI      (output) DOUBLE PRECISION array, dimension (N)
   *          WR and WI contain the real and imaginary parts,
   *          respectively, of the computed eigenvalues.  Complex
   *          conjugate pairs of eigenvalues will appear consecutively
   *          with the eigenvalue having the positive imaginary part
   *          first.
   *
   *  VL      (output) DOUBLE PRECISION array, dimension (LDVL,N)
   *          If JOBVL = 'V', the left eigenvectors u(j) are stored one
   *          after another in the columns of VL, in the same order
   *          as their eigenvalues.
   *          If JOBVL = 'N', VL is not referenced.
   *          If the j-th eigenvalue is real, then u(j) = VL(:,j),
   *          the j-th column of VL.
   *          If the j-th and (j+1)-st eigenvalues form a complex
   *          conjugate pair, then u(j) = VL(:,j) + i*VL(:,j+1) and
   *          u(j+1) = VL(:,j) - i*VL(:,j+1).
   *
   *  LDVL    (input) INTEGER
   *          The leading dimension of the array VL.  LDVL >= 1; if
   *          JOBVL = 'V', LDVL >= N.
   *
   *  VR      (output) DOUBLE PRECISION array, dimension (LDVR,N)
   *          If JOBVR = 'V', the right eigenvectors v(j) are stored one
   *          after another in the columns of VR, in the same order
   *          as their eigenvalues.
   *          If JOBVR = 'N', VR is not referenced.
   *          If the j-th eigenvalue is real, then v(j) = VR(:,j),
   *          the j-th column of VR.
   *          If the j-th and (j+1)-st eigenvalues form a complex
   *          conjugate pair, then v(j) = VR(:,j) + i*VR(:,j+1) and
   *          v(j+1) = VR(:,j) - i*VR(:,j+1).
   *
   *  LDVR    (input) INTEGER
   *          The leading dimension of the array VR.  LDVR >= 1, and if
   *          JOBVR = 'V', LDVR >= N.
   *
   *  ILO     (output) INTEGER
   *  IHI     (output) INTEGER
   *          ILO and IHI are integer values determined when A was
   *          balanced.  The balanced A(i,j) = 0 if I > J and
   *          J = 1,...,ILO-1 or I = IHI+1,...,N.
   *
   *  SCALE   (output) DOUBLE PRECISION array, dimension (N)
   *          Details of the permutations and scaling factors applied
   *          when balancing A.  If P(j) is the index of the row and column
   *          interchanged with row and column j, and D(j) is the scaling
   *          factor applied to row and column j, then
   *          SCALE(J) = P(J),    for J = 1,...,ILO-1
   *                   = D(J),    for J = ILO,...,IHI
   *                   = P(J)     for J = IHI+1,...,N.
   *          The order in which the interchanges are made is N to IHI+1,
   *          then 1 to ILO-1.
   *
   *  ABNRM   (output) DOUBLE PRECISION
   *          The one-norm of the balanced matrix (the maximum
   *          of the sum of absolute values of elements of any column).
   *
   *  RCONDE  (output) DOUBLE PRECISION array, dimension (N)
   *          RCONDE(j) is the reciprocal condition number of the j-th
   *          eigenvalue.
   *
   *  RCONDV  (output) DOUBLE PRECISION array, dimension (N)
   *          RCONDV(j) is the reciprocal condition number of the j-th
   *          right eigenvector.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.   If SENSE = 'N' or 'E',
   *          LWORK >= max(1,2*N), and if JOBVL = 'V' or JOBVR = 'V',
   *          LWORK >= 3*N.  If SENSE = 'V' or 'B', LWORK >= N*(N+6).
   *          For good performance, LWORK must generally be larger.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  IWORK   (workspace) INTEGER array, dimension (2*N-2)
   *          If SENSE = 'N' or 'E', not referenced.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  if INFO = i, the QR algorithm failed to compute all the
   *                eigenvalues, and no eigenvectors or condition numbers
   *                have been computed; elements 1:ILO-1 and i+1:N of WR
   *                and WI contain eigenvalues which have converged.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param balanc
   * @param jobvl
   * @param jobvr
   * @param sense
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param wr
   * @param _wr_offset
   * @param wi
   * @param _wi_offset
   * @param vl
   * @param _vl_offset
   * @param ldvl
   * @param vr
   * @param _vr_offset
   * @param ldvr
   * @param ilo
   * @param ihi
   * @param scale
   * @param _scale_offset
   * @param abnrm
   * @param rconde
   * @param _rconde_offset
   * @param rcondv
   * @param _rcondv_offset
   * @param work
   * @param _work_offset
   * @param lwork
   * @param iwork
   * @param _iwork_offset
   * @param info
   * 
   */
  abstract public void dgeevx(java.lang.String balanc, java.lang.String jobvl, java.lang.String jobvr, java.lang.String sense, int n, double[] a, int _a_offset, int lda, double[] wr, int _wr_offset, double[] wi, int _wi_offset, double[] vl, int _vl_offset, int ldvl, double[] vr, int _vr_offset, int ldvr, org.netlib.util.intW ilo, org.netlib.util.intW ihi, double[] scale, int _scale_offset, org.netlib.util.doubleW abnrm, double[] rconde, int _rconde_offset, double[] rcondv, int _rcondv_offset, double[] work, int _work_offset, int lwork, int[] iwork, int _iwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  This routine is deprecated and has been replaced by routine DGGES.
   *
   *  DGEGS computes the eigenvalues, real Schur form, and, optionally,
   *  left and or/right Schur vectors of a real matrix pair (A,B).
   *  Given two square matrices A and B, the generalized real Schur
   *  factorization has the form
   *
   *    A = Q*S*Z**T,  B = Q*T*Z**T
   *
   *  where Q and Z are orthogonal matrices, T is upper triangular, and S
   *  is an upper quasi-triangular matrix with 1-by-1 and 2-by-2 diagonal
   *  blocks, the 2-by-2 blocks corresponding to complex conjugate pairs
   *  of eigenvalues of (A,B).  The columns of Q are the left Schur vectors
   *  and the columns of Z are the right Schur vectors.
   *
   *  If only the eigenvalues of (A,B) are needed, the driver routine
   *  DGEGV should be used instead.  See DGEGV for a description of the
   *  eigenvalues of the generalized nonsymmetric eigenvalue problem
   *  (GNEP).
   *
   *  Arguments
   *  =========
   *
   *  JOBVSL  (input) CHARACTER*1
   *          = 'N':  do not compute the left Schur vectors;
   *          = 'V':  compute the left Schur vectors (returned in VSL).
   *
   *  JOBVSR  (input) CHARACTER*1
   *          = 'N':  do not compute the right Schur vectors;
   *          = 'V':  compute the right Schur vectors (returned in VSR).
   *
   *  N       (input) INTEGER
   *          The order of the matrices A, B, VSL, and VSR.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
   *          On entry, the matrix A.
   *          On exit, the upper quasi-triangular matrix S from the
   *          generalized real Schur factorization.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of A.  LDA >= max(1,N).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
   *          On entry, the matrix B.
   *          On exit, the upper triangular matrix T from the generalized
   *          real Schur factorization.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of B.  LDB >= max(1,N).
   *
   *  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
   *          The real parts of each scalar alpha defining an eigenvalue
   *          of GNEP.
   *
   *  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
   *          The imaginary parts of each scalar alpha defining an
   *          eigenvalue of GNEP.  If ALPHAI(j) is zero, then the j-th
   *          eigenvalue is real; if positive, then the j-th and (j+1)-st
   *          eigenvalues are a complex conjugate pair, with
   *          ALPHAI(j+1) = -ALPHAI(j).
   *
   *  BETA    (output) DOUBLE PRECISION array, dimension (N)
   *          The scalars beta that define the eigenvalues of GNEP.
   *          Together, the quantities alpha = (ALPHAR(j),ALPHAI(j)) and
   *          beta = BETA(j) represent the j-th eigenvalue of the matrix
   *          pair (A,B), in one of the forms lambda = alpha/beta or
   *          mu = beta/alpha.  Since either lambda or mu may overflow,
   *          they should not, in general, be computed.
   *
   *  VSL     (output) DOUBLE PRECISION array, dimension (LDVSL,N)
   *          If JOBVSL = 'V', the matrix of left Schur vectors Q.
   *          Not referenced if JOBVSL = 'N'.
   *
   *  LDVSL   (input) INTEGER
   *          The leading dimension of the matrix VSL. LDVSL >=1, and
   *          if JOBVSL = 'V', LDVSL >= N.
   *
   *  VSR     (output) DOUBLE PRECISION array, dimension (LDVSR,N)
   *          If JOBVSR = 'V', the matrix of right Schur vectors Z.
   *          Not referenced if JOBVSR = 'N'.
   *
   *  LDVSR   (input) INTEGER
   *          The leading dimension of the matrix VSR. LDVSR >= 1, and
   *          if JOBVSR = 'V', LDVSR >= N.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,4*N).
   *          For good performance, LWORK must generally be larger.
   *          To compute the optimal value of LWORK, call ILAENV to get
   *          blocksizes (for DGEQRF, DORMQR, and DORGQR.)  Then compute:
   *          NB  -- MAX of the blocksizes for DGEQRF, DORMQR, and DORGQR
   *          The optimal LWORK is  2*N + N*(NB+1).
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          = 1,...,N:
   *                The QZ iteration failed.  (A,B) are not in Schur
   *                form, but ALPHAR(j), ALPHAI(j), and BETA(j) should
   *                be correct for j=INFO+1,...,N.
   *          > N:  errors that usually indicate LAPACK problems:
   *                =N+1: error return from DGGBAL
   *                =N+2: error return from DGEQRF
   *                =N+3: error return from DORMQR
   *                =N+4: error return from DORGQR
   *                =N+5: error return from DGGHRD
   *                =N+6: error return from DHGEQZ (other than failed
   *                                                iteration)
   *                =N+7: error return from DGGBAK (computing VSL)
   *                =N+8: error return from DGGBAK (computing VSR)
   *                =N+9: error return from DLASCL (various places)
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobvsl
   * @param jobvsr
   * @param n
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param alphar
   * @param alphai
   * @param beta
   * @param vsl
   * @param ldvsl
   * @param vsr
   * @param ldvsr
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgegs(java.lang.String jobvsl, java.lang.String jobvsr, int n, double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, double[] vsl, int ldvsl, double[] vsr, int ldvsr, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  This routine is deprecated and has been replaced by routine DGGES.
   *
   *  DGEGS computes the eigenvalues, real Schur form, and, optionally,
   *  left and or/right Schur vectors of a real matrix pair (A,B).
   *  Given two square matrices A and B, the generalized real Schur
   *  factorization has the form
   *
   *    A = Q*S*Z**T,  B = Q*T*Z**T
   *
   *  where Q and Z are orthogonal matrices, T is upper triangular, and S
   *  is an upper quasi-triangular matrix with 1-by-1 and 2-by-2 diagonal
   *  blocks, the 2-by-2 blocks corresponding to complex conjugate pairs
   *  of eigenvalues of (A,B).  The columns of Q are the left Schur vectors
   *  and the columns of Z are the right Schur vectors.
   *
   *  If only the eigenvalues of (A,B) are needed, the driver routine
   *  DGEGV should be used instead.  See DGEGV for a description of the
   *  eigenvalues of the generalized nonsymmetric eigenvalue problem
   *  (GNEP).
   *
   *  Arguments
   *  =========
   *
   *  JOBVSL  (input) CHARACTER*1
   *          = 'N':  do not compute the left Schur vectors;
   *          = 'V':  compute the left Schur vectors (returned in VSL).
   *
   *  JOBVSR  (input) CHARACTER*1
   *          = 'N':  do not compute the right Schur vectors;
   *          = 'V':  compute the right Schur vectors (returned in VSR).
   *
   *  N       (input) INTEGER
   *          The order of the matrices A, B, VSL, and VSR.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
   *          On entry, the matrix A.
   *          On exit, the upper quasi-triangular matrix S from the
   *          generalized real Schur factorization.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of A.  LDA >= max(1,N).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
   *          On entry, the matrix B.
   *          On exit, the upper triangular matrix T from the generalized
   *          real Schur factorization.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of B.  LDB >= max(1,N).
   *
   *  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
   *          The real parts of each scalar alpha defining an eigenvalue
   *          of GNEP.
   *
   *  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
   *          The imaginary parts of each scalar alpha defining an
   *          eigenvalue of GNEP.  If ALPHAI(j) is zero, then the j-th
   *          eigenvalue is real; if positive, then the j-th and (j+1)-st
   *          eigenvalues are a complex conjugate pair, with
   *          ALPHAI(j+1) = -ALPHAI(j).
   *
   *  BETA    (output) DOUBLE PRECISION array, dimension (N)
   *          The scalars beta that define the eigenvalues of GNEP.
   *          Together, the quantities alpha = (ALPHAR(j),ALPHAI(j)) and
   *          beta = BETA(j) represent the j-th eigenvalue of the matrix
   *          pair (A,B), in one of the forms lambda = alpha/beta or
   *          mu = beta/alpha.  Since either lambda or mu may overflow,
   *          they should not, in general, be computed.
   *
   *  VSL     (output) DOUBLE PRECISION array, dimension (LDVSL,N)
   *          If JOBVSL = 'V', the matrix of left Schur vectors Q.
   *          Not referenced if JOBVSL = 'N'.
   *
   *  LDVSL   (input) INTEGER
   *          The leading dimension of the matrix VSL. LDVSL >=1, and
   *          if JOBVSL = 'V', LDVSL >= N.
   *
   *  VSR     (output) DOUBLE PRECISION array, dimension (LDVSR,N)
   *          If JOBVSR = 'V', the matrix of right Schur vectors Z.
   *          Not referenced if JOBVSR = 'N'.
   *
   *  LDVSR   (input) INTEGER
   *          The leading dimension of the matrix VSR. LDVSR >= 1, and
   *          if JOBVSR = 'V', LDVSR >= N.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,4*N).
   *          For good performance, LWORK must generally be larger.
   *          To compute the optimal value of LWORK, call ILAENV to get
   *          blocksizes (for DGEQRF, DORMQR, and DORGQR.)  Then compute:
   *          NB  -- MAX of the blocksizes for DGEQRF, DORMQR, and DORGQR
   *          The optimal LWORK is  2*N + N*(NB+1).
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          = 1,...,N:
   *                The QZ iteration failed.  (A,B) are not in Schur
   *                form, but ALPHAR(j), ALPHAI(j), and BETA(j) should
   *                be correct for j=INFO+1,...,N.
   *          > N:  errors that usually indicate LAPACK problems:
   *                =N+1: error return from DGGBAL
   *                =N+2: error return from DGEQRF
   *                =N+3: error return from DORMQR
   *                =N+4: error return from DORGQR
   *                =N+5: error return from DGGHRD
   *                =N+6: error return from DHGEQZ (other than failed
   *                                                iteration)
   *                =N+7: error return from DGGBAK (computing VSL)
   *                =N+8: error return from DGGBAK (computing VSR)
   *                =N+9: error return from DLASCL (various places)
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobvsl
   * @param jobvsr
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param alphar
   * @param _alphar_offset
   * @param alphai
   * @param _alphai_offset
   * @param beta
   * @param _beta_offset
   * @param vsl
   * @param _vsl_offset
   * @param ldvsl
   * @param vsr
   * @param _vsr_offset
   * @param ldvsr
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgegs(java.lang.String jobvsl, java.lang.String jobvsr, int n, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double[] alphar, int _alphar_offset, double[] alphai, int _alphai_offset, double[] beta, int _beta_offset, double[] vsl, int _vsl_offset, int ldvsl, double[] vsr, int _vsr_offset, int ldvsr, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  This routine is deprecated and has been replaced by routine DGGEV.
   *
   *  DGEGV computes the eigenvalues and, optionally, the left and/or right
   *  eigenvectors of a real matrix pair (A,B).
   *  Given two square matrices A and B,
   *  the generalized nonsymmetric eigenvalue problem (GNEP) is to find the
   *  eigenvalues lambda and corresponding (non-zero) eigenvectors x such
   *  that
   *
   *     A*x = lambda*B*x.
   *
   *  An alternate form is to find the eigenvalues mu and corresponding
   *  eigenvectors y such that
   *
   *     mu*A*y = B*y.
   *
   *  These two forms are equivalent with mu = 1/lambda and x = y if
   *  neither lambda nor mu is zero.  In order to deal with the case that
   *  lambda or mu is zero or small, two values alpha and beta are returned
   *  for each eigenvalue, such that lambda = alpha/beta and
   *  mu = beta/alpha.
   *
   *  The vectors x and y in the above equations are right eigenvectors of
   *  the matrix pair (A,B).  Vectors u and v satisfying
   *
   *     u**H*A = lambda*u**H*B  or  mu*v**H*A = v**H*B
   *
   *  are left eigenvectors of (A,B).
   *
   *  Note: this routine performs "full balancing" on A and B -- see
   *  "Further Details", below.
   *
   *  Arguments
   *  =========
   *
   *  JOBVL   (input) CHARACTER*1
   *          = 'N':  do not compute the left generalized eigenvectors;
   *          = 'V':  compute the left generalized eigenvectors (returned
   *                  in VL).
   *
   *  JOBVR   (input) CHARACTER*1
   *          = 'N':  do not compute the right generalized eigenvectors;
   *          = 'V':  compute the right generalized eigenvectors (returned
   *                  in VR).
   *
   *  N       (input) INTEGER
   *          The order of the matrices A, B, VL, and VR.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
   *          On entry, the matrix A.
   *          If JOBVL = 'V' or JOBVR = 'V', then on exit A
   *          contains the real Schur form of A from the generalized Schur
   *          factorization of the pair (A,B) after balancing.
   *          If no eigenvectors were computed, then only the diagonal
   *          blocks from the Schur form will be correct.  See DGGHRD and
   *          DHGEQZ for details.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of A.  LDA >= max(1,N).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
   *          On entry, the matrix B.
   *          If JOBVL = 'V' or JOBVR = 'V', then on exit B contains the
   *          upper triangular matrix obtained from B in the generalized
   *          Schur factorization of the pair (A,B) after balancing.
   *          If no eigenvectors were computed, then only those elements of
   *          B corresponding to the diagonal blocks from the Schur form of
   *          A will be correct.  See DGGHRD and DHGEQZ for details.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of B.  LDB >= max(1,N).
   *
   *  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
   *          The real parts of each scalar alpha defining an eigenvalue of
   *          GNEP.
   *
   *  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
   *          The imaginary parts of each scalar alpha defining an
   *          eigenvalue of GNEP.  If ALPHAI(j) is zero, then the j-th
   *          eigenvalue is real; if positive, then the j-th and
   *          (j+1)-st eigenvalues are a complex conjugate pair, with
   *          ALPHAI(j+1) = -ALPHAI(j).
   *
   *  BETA    (output) DOUBLE PRECISION array, dimension (N)
   *          The scalars beta that define the eigenvalues of GNEP.
   *          
   *          Together, the quantities alpha = (ALPHAR(j),ALPHAI(j)) and
   *          beta = BETA(j) represent the j-th eigenvalue of the matrix
   *          pair (A,B), in one of the forms lambda = alpha/beta or
   *          mu = beta/alpha.  Since either lambda or mu may overflow,
   *          they should not, in general, be computed.
   *
   *  VL      (output) DOUBLE PRECISION array, dimension (LDVL,N)
   *          If JOBVL = 'V', the left eigenvectors u(j) are stored
   *          in the columns of VL, in the same order as their eigenvalues.
   *          If the j-th eigenvalue is real, then u(j) = VL(:,j).
   *          If the j-th and (j+1)-st eigenvalues form a complex conjugate
   *          pair, then
   *             u(j) = VL(:,j) + i*VL(:,j+1)
   *          and
   *            u(j+1) = VL(:,j) - i*VL(:,j+1).
   *
   *          Each eigenvector is scaled so that its largest component has
   *          abs(real part) + abs(imag. part) = 1, except for eigenvectors
   *          corresponding to an eigenvalue with alpha = beta = 0, which
   *          are set to zero.
   *          Not referenced if JOBVL = 'N'.
   *
   *  LDVL    (input) INTEGER
   *          The leading dimension of the matrix VL. LDVL >= 1, and
   *          if JOBVL = 'V', LDVL >= N.
   *
   *  VR      (output) DOUBLE PRECISION array, dimension (LDVR,N)
   *          If JOBVR = 'V', the right eigenvectors x(j) are stored
   *          in the columns of VR, in the same order as their eigenvalues.
   *          If the j-th eigenvalue is real, then x(j) = VR(:,j).
   *          If the j-th and (j+1)-st eigenvalues form a complex conjugate
   *          pair, then
   *            x(j) = VR(:,j) + i*VR(:,j+1)
   *          and
   *            x(j+1) = VR(:,j) - i*VR(:,j+1).
   *
   *          Each eigenvector is scaled so that its largest component has
   *          abs(real part) + abs(imag. part) = 1, except for eigenvalues
   *          corresponding to an eigenvalue with alpha = beta = 0, which
   *          are set to zero.
   *          Not referenced if JOBVR = 'N'.
   *
   *  LDVR    (input) INTEGER
   *          The leading dimension of the matrix VR. LDVR >= 1, and
   *          if JOBVR = 'V', LDVR >= N.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,8*N).
   *          For good performance, LWORK must generally be larger.
   *          To compute the optimal value of LWORK, call ILAENV to get
   *          blocksizes (for DGEQRF, DORMQR, and DORGQR.)  Then compute:
   *          NB  -- MAX of the blocksizes for DGEQRF, DORMQR, and DORGQR;
   *          The optimal LWORK is:
   *              2*N + MAX( 6*N, N*(NB+1) ).
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          = 1,...,N:
   *                The QZ iteration failed.  No eigenvectors have been
   *                calculated, but ALPHAR(j), ALPHAI(j), and BETA(j)
   *                should be correct for j=INFO+1,...,N.
   *          > N:  errors that usually indicate LAPACK problems:
   *                =N+1: error return from DGGBAL
   *                =N+2: error return from DGEQRF
   *                =N+3: error return from DORMQR
   *                =N+4: error return from DORGQR
   *                =N+5: error return from DGGHRD
   *                =N+6: error return from DHGEQZ (other than failed
   *                                                iteration)
   *                =N+7: error return from DTGEVC
   *                =N+8: error return from DGGBAK (computing VL)
   *                =N+9: error return from DGGBAK (computing VR)
   *                =N+10: error return from DLASCL (various calls)
   *
   *  Further Details
   *  ===============
   *
   *  Balancing
   *  ---------
   *
   *  This driver calls DGGBAL to both permute and scale rows and columns
   *  of A and B.  The permutations PL and PR are chosen so that PL*A*PR
   *  and PL*B*R will be upper triangular except for the diagonal blocks
   *  A(i:j,i:j) and B(i:j,i:j), with i and j as close together as
   *  possible.  The diagonal scaling matrices DL and DR are chosen so
   *  that the pair  DL*PL*A*PR*DR, DL*PL*B*PR*DR have elements close to
   *  one (except for the elements that start out zero.)
   *
   *  After the eigenvalues and eigenvectors of the balanced matrices
   *  have been computed, DGGBAK transforms the eigenvectors back to what
   *  they would have been (in perfect arithmetic) if they had not been
   *  balanced.
   *
   *  Contents of A and B on Exit
   *  -------- -- - --- - -- ----
   *
   *  If any eigenvectors are computed (either JOBVL='V' or JOBVR='V' or
   *  both), then on exit the arrays A and B will contain the real Schur
   *  form[*] of the "balanced" versions of A and B.  If no eigenvectors
   *  are computed, then only the diagonal blocks will be correct.
   *
   *  [*] See DHGEQZ, DGEGS, or read the book "Matrix Computations",
   *      by Golub & van Loan, pub. by Johns Hopkins U. Press.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobvl
   * @param jobvr
   * @param n
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param alphar
   * @param alphai
   * @param beta
   * @param vl
   * @param ldvl
   * @param vr
   * @param ldvr
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgegv(java.lang.String jobvl, java.lang.String jobvr, int n, double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, double[] vl, int ldvl, double[] vr, int ldvr, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  This routine is deprecated and has been replaced by routine DGGEV.
   *
   *  DGEGV computes the eigenvalues and, optionally, the left and/or right
   *  eigenvectors of a real matrix pair (A,B).
   *  Given two square matrices A and B,
   *  the generalized nonsymmetric eigenvalue problem (GNEP) is to find the
   *  eigenvalues lambda and corresponding (non-zero) eigenvectors x such
   *  that
   *
   *     A*x = lambda*B*x.
   *
   *  An alternate form is to find the eigenvalues mu and corresponding
   *  eigenvectors y such that
   *
   *     mu*A*y = B*y.
   *
   *  These two forms are equivalent with mu = 1/lambda and x = y if
   *  neither lambda nor mu is zero.  In order to deal with the case that
   *  lambda or mu is zero or small, two values alpha and beta are returned
   *  for each eigenvalue, such that lambda = alpha/beta and
   *  mu = beta/alpha.
   *
   *  The vectors x and y in the above equations are right eigenvectors of
   *  the matrix pair (A,B).  Vectors u and v satisfying
   *
   *     u**H*A = lambda*u**H*B  or  mu*v**H*A = v**H*B
   *
   *  are left eigenvectors of (A,B).
   *
   *  Note: this routine performs "full balancing" on A and B -- see
   *  "Further Details", below.
   *
   *  Arguments
   *  =========
   *
   *  JOBVL   (input) CHARACTER*1
   *          = 'N':  do not compute the left generalized eigenvectors;
   *          = 'V':  compute the left generalized eigenvectors (returned
   *                  in VL).
   *
   *  JOBVR   (input) CHARACTER*1
   *          = 'N':  do not compute the right generalized eigenvectors;
   *          = 'V':  compute the right generalized eigenvectors (returned
   *                  in VR).
   *
   *  N       (input) INTEGER
   *          The order of the matrices A, B, VL, and VR.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
   *          On entry, the matrix A.
   *          If JOBVL = 'V' or JOBVR = 'V', then on exit A
   *          contains the real Schur form of A from the generalized Schur
   *          factorization of the pair (A,B) after balancing.
   *          If no eigenvectors were computed, then only the diagonal
   *          blocks from the Schur form will be correct.  See DGGHRD and
   *          DHGEQZ for details.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of A.  LDA >= max(1,N).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
   *          On entry, the matrix B.
   *          If JOBVL = 'V' or JOBVR = 'V', then on exit B contains the
   *          upper triangular matrix obtained from B in the generalized
   *          Schur factorization of the pair (A,B) after balancing.
   *          If no eigenvectors were computed, then only those elements of
   *          B corresponding to the diagonal blocks from the Schur form of
   *          A will be correct.  See DGGHRD and DHGEQZ for details.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of B.  LDB >= max(1,N).
   *
   *  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
   *          The real parts of each scalar alpha defining an eigenvalue of
   *          GNEP.
   *
   *  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
   *          The imaginary parts of each scalar alpha defining an
   *          eigenvalue of GNEP.  If ALPHAI(j) is zero, then the j-th
   *          eigenvalue is real; if positive, then the j-th and
   *          (j+1)-st eigenvalues are a complex conjugate pair, with
   *          ALPHAI(j+1) = -ALPHAI(j).
   *
   *  BETA    (output) DOUBLE PRECISION array, dimension (N)
   *          The scalars beta that define the eigenvalues of GNEP.
   *          
   *          Together, the quantities alpha = (ALPHAR(j),ALPHAI(j)) and
   *          beta = BETA(j) represent the j-th eigenvalue of the matrix
   *          pair (A,B), in one of the forms lambda = alpha/beta or
   *          mu = beta/alpha.  Since either lambda or mu may overflow,
   *          they should not, in general, be computed.
   *
   *  VL      (output) DOUBLE PRECISION array, dimension (LDVL,N)
   *          If JOBVL = 'V', the left eigenvectors u(j) are stored
   *          in the columns of VL, in the same order as their eigenvalues.
   *          If the j-th eigenvalue is real, then u(j) = VL(:,j).
   *          If the j-th and (j+1)-st eigenvalues form a complex conjugate
   *          pair, then
   *             u(j) = VL(:,j) + i*VL(:,j+1)
   *          and
   *            u(j+1) = VL(:,j) - i*VL(:,j+1).
   *
   *          Each eigenvector is scaled so that its largest component has
   *          abs(real part) + abs(imag. part) = 1, except for eigenvectors
   *          corresponding to an eigenvalue with alpha = beta = 0, which
   *          are set to zero.
   *          Not referenced if JOBVL = 'N'.
   *
   *  LDVL    (input) INTEGER
   *          The leading dimension of the matrix VL. LDVL >= 1, and
   *          if JOBVL = 'V', LDVL >= N.
   *
   *  VR      (output) DOUBLE PRECISION array, dimension (LDVR,N)
   *          If JOBVR = 'V', the right eigenvectors x(j) are stored
   *          in the columns of VR, in the same order as their eigenvalues.
   *          If the j-th eigenvalue is real, then x(j) = VR(:,j).
   *          If the j-th and (j+1)-st eigenvalues form a complex conjugate
   *          pair, then
   *            x(j) = VR(:,j) + i*VR(:,j+1)
   *          and
   *            x(j+1) = VR(:,j) - i*VR(:,j+1).
   *
   *          Each eigenvector is scaled so that its largest component has
   *          abs(real part) + abs(imag. part) = 1, except for eigenvalues
   *          corresponding to an eigenvalue with alpha = beta = 0, which
   *          are set to zero.
   *          Not referenced if JOBVR = 'N'.
   *
   *  LDVR    (input) INTEGER
   *          The leading dimension of the matrix VR. LDVR >= 1, and
   *          if JOBVR = 'V', LDVR >= N.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,8*N).
   *          For good performance, LWORK must generally be larger.
   *          To compute the optimal value of LWORK, call ILAENV to get
   *          blocksizes (for DGEQRF, DORMQR, and DORGQR.)  Then compute:
   *          NB  -- MAX of the blocksizes for DGEQRF, DORMQR, and DORGQR;
   *          The optimal LWORK is:
   *              2*N + MAX( 6*N, N*(NB+1) ).
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          = 1,...,N:
   *                The QZ iteration failed.  No eigenvectors have been
   *                calculated, but ALPHAR(j), ALPHAI(j), and BETA(j)
   *                should be correct for j=INFO+1,...,N.
   *          > N:  errors that usually indicate LAPACK problems:
   *                =N+1: error return from DGGBAL
   *                =N+2: error return from DGEQRF
   *                =N+3: error return from DORMQR
   *                =N+4: error return from DORGQR
   *                =N+5: error return from DGGHRD
   *                =N+6: error return from DHGEQZ (other than failed
   *                                                iteration)
   *                =N+7: error return from DTGEVC
   *                =N+8: error return from DGGBAK (computing VL)
   *                =N+9: error return from DGGBAK (computing VR)
   *                =N+10: error return from DLASCL (various calls)
   *
   *  Further Details
   *  ===============
   *
   *  Balancing
   *  ---------
   *
   *  This driver calls DGGBAL to both permute and scale rows and columns
   *  of A and B.  The permutations PL and PR are chosen so that PL*A*PR
   *  and PL*B*R will be upper triangular except for the diagonal blocks
   *  A(i:j,i:j) and B(i:j,i:j), with i and j as close together as
   *  possible.  The diagonal scaling matrices DL and DR are chosen so
   *  that the pair  DL*PL*A*PR*DR, DL*PL*B*PR*DR have elements close to
   *  one (except for the elements that start out zero.)
   *
   *  After the eigenvalues and eigenvectors of the balanced matrices
   *  have been computed, DGGBAK transforms the eigenvectors back to what
   *  they would have been (in perfect arithmetic) if they had not been
   *  balanced.
   *
   *  Contents of A and B on Exit
   *  -------- -- - --- - -- ----
   *
   *  If any eigenvectors are computed (either JOBVL='V' or JOBVR='V' or
   *  both), then on exit the arrays A and B will contain the real Schur
   *  form[*] of the "balanced" versions of A and B.  If no eigenvectors
   *  are computed, then only the diagonal blocks will be correct.
   *
   *  [*] See DHGEQZ, DGEGS, or read the book "Matrix Computations",
   *      by Golub & van Loan, pub. by Johns Hopkins U. Press.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobvl
   * @param jobvr
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param alphar
   * @param _alphar_offset
   * @param alphai
   * @param _alphai_offset
   * @param beta
   * @param _beta_offset
   * @param vl
   * @param _vl_offset
   * @param ldvl
   * @param vr
   * @param _vr_offset
   * @param ldvr
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgegv(java.lang.String jobvl, java.lang.String jobvr, int n, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double[] alphar, int _alphar_offset, double[] alphai, int _alphai_offset, double[] beta, int _beta_offset, double[] vl, int _vl_offset, int ldvl, double[] vr, int _vr_offset, int ldvr, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEHD2 reduces a real general matrix A to upper Hessenberg form H by
   *  an orthogonal similarity transformation:  Q' * A * Q = H .
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  ILO     (input) INTEGER
   *  IHI     (input) INTEGER
   *          It is assumed that A is already upper triangular in rows
   *          and columns 1:ILO-1 and IHI+1:N. ILO and IHI are normally
   *          set by a previous call to DGEBAL; otherwise they should be
   *          set to 1 and N respectively. See Further Details.
   *          1 <= ILO <= IHI <= max(1,N).
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the n by n general matrix to be reduced.
   *          On exit, the upper triangle and the first subdiagonal of A
   *          are overwritten with the upper Hessenberg matrix H, and the
   *          elements below the first subdiagonal, with the array TAU,
   *          represent the orthogonal matrix Q as a product of elementary
   *          reflectors. See Further Details.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (N-1)
   *          The scalar factors of the elementary reflectors (see Further
   *          Details).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of (ihi-ilo) elementary
   *  reflectors
   *
   *     Q = H(ilo) H(ilo+1) . . . H(ihi-1).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(1:i) = 0, v(i+1) = 1 and v(ihi+1:n) = 0; v(i+2:ihi) is stored on
   *  exit in A(i+2:ihi,i), and tau in TAU(i).
   *
   *  The contents of A are illustrated by the following example, with
   *  n = 7, ilo = 2 and ihi = 6:
   *
   *  on entry,                        on exit,
   *
   *  ( a   a   a   a   a   a   a )    (  a   a   h   h   h   h   a )
   *  (     a   a   a   a   a   a )    (      a   h   h   h   h   a )
   *  (     a   a   a   a   a   a )    (      h   h   h   h   h   h )
   *  (     a   a   a   a   a   a )    (      v2  h   h   h   h   h )
   *  (     a   a   a   a   a   a )    (      v2  v3  h   h   h   h )
   *  (     a   a   a   a   a   a )    (      v2  v3  v4  h   h   h )
   *  (                         a )    (                          a )
   *
   *  where a denotes an element of the original matrix A, h denotes a
   *  modified element of the upper Hessenberg matrix H, and vi denotes an
   *  element of the vector defining H(i).
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param ilo
   * @param ihi
   * @param a
   * @param lda
   * @param tau
   * @param work
   * @param info
   * 
   */
  abstract public void dgehd2(int n, int ilo, int ihi, double[] a, int lda, double[] tau, double[] work, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEHD2 reduces a real general matrix A to upper Hessenberg form H by
   *  an orthogonal similarity transformation:  Q' * A * Q = H .
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  ILO     (input) INTEGER
   *  IHI     (input) INTEGER
   *          It is assumed that A is already upper triangular in rows
   *          and columns 1:ILO-1 and IHI+1:N. ILO and IHI are normally
   *          set by a previous call to DGEBAL; otherwise they should be
   *          set to 1 and N respectively. See Further Details.
   *          1 <= ILO <= IHI <= max(1,N).
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the n by n general matrix to be reduced.
   *          On exit, the upper triangle and the first subdiagonal of A
   *          are overwritten with the upper Hessenberg matrix H, and the
   *          elements below the first subdiagonal, with the array TAU,
   *          represent the orthogonal matrix Q as a product of elementary
   *          reflectors. See Further Details.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (N-1)
   *          The scalar factors of the elementary reflectors (see Further
   *          Details).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of (ihi-ilo) elementary
   *  reflectors
   *
   *     Q = H(ilo) H(ilo+1) . . . H(ihi-1).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(1:i) = 0, v(i+1) = 1 and v(ihi+1:n) = 0; v(i+2:ihi) is stored on
   *  exit in A(i+2:ihi,i), and tau in TAU(i).
   *
   *  The contents of A are illustrated by the following example, with
   *  n = 7, ilo = 2 and ihi = 6:
   *
   *  on entry,                        on exit,
   *
   *  ( a   a   a   a   a   a   a )    (  a   a   h   h   h   h   a )
   *  (     a   a   a   a   a   a )    (      a   h   h   h   h   a )
   *  (     a   a   a   a   a   a )    (      h   h   h   h   h   h )
   *  (     a   a   a   a   a   a )    (      v2  h   h   h   h   h )
   *  (     a   a   a   a   a   a )    (      v2  v3  h   h   h   h )
   *  (     a   a   a   a   a   a )    (      v2  v3  v4  h   h   h )
   *  (                         a )    (                          a )
   *
   *  where a denotes an element of the original matrix A, h denotes a
   *  modified element of the upper Hessenberg matrix H, and vi denotes an
   *  element of the vector defining H(i).
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param ilo
   * @param ihi
   * @param a
   * @param _a_offset
   * @param lda
   * @param tau
   * @param _tau_offset
   * @param work
   * @param _work_offset
   * @param info
   * 
   */
  abstract public void dgehd2(int n, int ilo, int ihi, double[] a, int _a_offset, int lda, double[] tau, int _tau_offset, double[] work, int _work_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEHRD reduces a real general matrix A to upper Hessenberg form H by
   *  an orthogonal similarity transformation:  Q' * A * Q = H .
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  ILO     (input) INTEGER
   *  IHI     (input) INTEGER
   *          It is assumed that A is already upper triangular in rows
   *          and columns 1:ILO-1 and IHI+1:N. ILO and IHI are normally
   *          set by a previous call to DGEBAL; otherwise they should be
   *          set to 1 and N respectively. See Further Details.
   *          1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the N-by-N general matrix to be reduced.
   *          On exit, the upper triangle and the first subdiagonal of A
   *          are overwritten with the upper Hessenberg matrix H, and the
   *          elements below the first subdiagonal, with the array TAU,
   *          represent the orthogonal matrix Q as a product of elementary
   *          reflectors. See Further Details.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (N-1)
   *          The scalar factors of the elementary reflectors (see Further
   *          Details). Elements 1:ILO-1 and IHI:N-1 of TAU are set to
   *          zero.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (LWORK)
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The length of the array WORK.  LWORK >= max(1,N).
   *          For optimum performance LWORK >= N*NB, where NB is the
   *          optimal blocksize.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of (ihi-ilo) elementary
   *  reflectors
   *
   *     Q = H(ilo) H(ilo+1) . . . H(ihi-1).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(1:i) = 0, v(i+1) = 1 and v(ihi+1:n) = 0; v(i+2:ihi) is stored on
   *  exit in A(i+2:ihi,i), and tau in TAU(i).
   *
   *  The contents of A are illustrated by the following example, with
   *  n = 7, ilo = 2 and ihi = 6:
   *
   *  on entry,                        on exit,
   *
   *  ( a   a   a   a   a   a   a )    (  a   a   h   h   h   h   a )
   *  (     a   a   a   a   a   a )    (      a   h   h   h   h   a )
   *  (     a   a   a   a   a   a )    (      h   h   h   h   h   h )
   *  (     a   a   a   a   a   a )    (      v2  h   h   h   h   h )
   *  (     a   a   a   a   a   a )    (      v2  v3  h   h   h   h )
   *  (     a   a   a   a   a   a )    (      v2  v3  v4  h   h   h )
   *  (                         a )    (                          a )
   *
   *  where a denotes an element of the original matrix A, h denotes a
   *  modified element of the upper Hessenberg matrix H, and vi denotes an
   *  element of the vector defining H(i).
   *
   *  This file is a slight modification of LAPACK-3.0's DGEHRD
   *  subroutine incorporating improvements proposed by Quintana-Orti and
   *  Van de Geijn (2005). 
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param ilo
   * @param ihi
   * @param a
   * @param lda
   * @param tau
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgehrd(int n, int ilo, int ihi, double[] a, int lda, double[] tau, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEHRD reduces a real general matrix A to upper Hessenberg form H by
   *  an orthogonal similarity transformation:  Q' * A * Q = H .
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  ILO     (input) INTEGER
   *  IHI     (input) INTEGER
   *          It is assumed that A is already upper triangular in rows
   *          and columns 1:ILO-1 and IHI+1:N. ILO and IHI are normally
   *          set by a previous call to DGEBAL; otherwise they should be
   *          set to 1 and N respectively. See Further Details.
   *          1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the N-by-N general matrix to be reduced.
   *          On exit, the upper triangle and the first subdiagonal of A
   *          are overwritten with the upper Hessenberg matrix H, and the
   *          elements below the first subdiagonal, with the array TAU,
   *          represent the orthogonal matrix Q as a product of elementary
   *          reflectors. See Further Details.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (N-1)
   *          The scalar factors of the elementary reflectors (see Further
   *          Details). Elements 1:ILO-1 and IHI:N-1 of TAU are set to
   *          zero.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (LWORK)
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The length of the array WORK.  LWORK >= max(1,N).
   *          For optimum performance LWORK >= N*NB, where NB is the
   *          optimal blocksize.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of (ihi-ilo) elementary
   *  reflectors
   *
   *     Q = H(ilo) H(ilo+1) . . . H(ihi-1).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(1:i) = 0, v(i+1) = 1 and v(ihi+1:n) = 0; v(i+2:ihi) is stored on
   *  exit in A(i+2:ihi,i), and tau in TAU(i).
   *
   *  The contents of A are illustrated by the following example, with
   *  n = 7, ilo = 2 and ihi = 6:
   *
   *  on entry,                        on exit,
   *
   *  ( a   a   a   a   a   a   a )    (  a   a   h   h   h   h   a )
   *  (     a   a   a   a   a   a )    (      a   h   h   h   h   a )
   *  (     a   a   a   a   a   a )    (      h   h   h   h   h   h )
   *  (     a   a   a   a   a   a )    (      v2  h   h   h   h   h )
   *  (     a   a   a   a   a   a )    (      v2  v3  h   h   h   h )
   *  (     a   a   a   a   a   a )    (      v2  v3  v4  h   h   h )
   *  (                         a )    (                          a )
   *
   *  where a denotes an element of the original matrix A, h denotes a
   *  modified element of the upper Hessenberg matrix H, and vi denotes an
   *  element of the vector defining H(i).
   *
   *  This file is a slight modification of LAPACK-3.0's DGEHRD
   *  subroutine incorporating improvements proposed by Quintana-Orti and
   *  Van de Geijn (2005). 
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param ilo
   * @param ihi
   * @param a
   * @param _a_offset
   * @param lda
   * @param tau
   * @param _tau_offset
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgehrd(int n, int ilo, int ihi, double[] a, int _a_offset, int lda, double[] tau, int _tau_offset, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGELQ2 computes an LQ factorization of a real m by n matrix A:
   *  A = L * Q.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the m by n matrix A.
   *          On exit, the elements on and below the diagonal of the array
   *          contain the m by min(m,n) lower trapezoidal matrix L (L is
   *          lower triangular if m <= n); the elements above the diagonal,
   *          with the array TAU, represent the orthogonal matrix Q as a
   *          product of elementary reflectors (see Further Details).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors (see Further
   *          Details).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (M)
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(k) . . . H(2) H(1), where k = min(m,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(1:i-1) = 0 and v(i) = 1; v(i+1:n) is stored on exit in A(i,i+1:n),
   *  and tau in TAU(i).
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param tau
   * @param work
   * @param info
   * 
   */
  abstract public void dgelq2(int m, int n, double[] a, int lda, double[] tau, double[] work, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGELQ2 computes an LQ factorization of a real m by n matrix A:
   *  A = L * Q.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the m by n matrix A.
   *          On exit, the elements on and below the diagonal of the array
   *          contain the m by min(m,n) lower trapezoidal matrix L (L is
   *          lower triangular if m <= n); the elements above the diagonal,
   *          with the array TAU, represent the orthogonal matrix Q as a
   *          product of elementary reflectors (see Further Details).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors (see Further
   *          Details).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (M)
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(k) . . . H(2) H(1), where k = min(m,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(1:i-1) = 0 and v(i) = 1; v(i+1:n) is stored on exit in A(i,i+1:n),
   *  and tau in TAU(i).
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param tau
   * @param _tau_offset
   * @param work
   * @param _work_offset
   * @param info
   * 
   */
  abstract public void dgelq2(int m, int n, double[] a, int _a_offset, int lda, double[] tau, int _tau_offset, double[] work, int _work_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGELQF computes an LQ factorization of a real M-by-N matrix A:
   *  A = L * Q.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, the elements on and below the diagonal of the array
   *          contain the m-by-min(m,n) lower trapezoidal matrix L (L is
   *          lower triangular if m <= n); the elements above the diagonal,
   *          with the array TAU, represent the orthogonal matrix Q as a
   *          product of elementary reflectors (see Further Details).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors (see Further
   *          Details).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,M).
   *          For optimum performance LWORK >= M*NB, where NB is the
   *          optimal blocksize.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(k) . . . H(2) H(1), where k = min(m,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(1:i-1) = 0 and v(i) = 1; v(i+1:n) is stored on exit in A(i,i+1:n),
   *  and tau in TAU(i).
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param tau
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgelqf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGELQF computes an LQ factorization of a real M-by-N matrix A:
   *  A = L * Q.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, the elements on and below the diagonal of the array
   *          contain the m-by-min(m,n) lower trapezoidal matrix L (L is
   *          lower triangular if m <= n); the elements above the diagonal,
   *          with the array TAU, represent the orthogonal matrix Q as a
   *          product of elementary reflectors (see Further Details).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors (see Further
   *          Details).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,M).
   *          For optimum performance LWORK >= M*NB, where NB is the
   *          optimal blocksize.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(k) . . . H(2) H(1), where k = min(m,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(1:i-1) = 0 and v(i) = 1; v(i+1:n) is stored on exit in A(i,i+1:n),
   *  and tau in TAU(i).
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param tau
   * @param _tau_offset
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgelqf(int m, int n, double[] a, int _a_offset, int lda, double[] tau, int _tau_offset, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGELS solves overdetermined or underdetermined real linear systems
   *  involving an M-by-N matrix A, or its transpose, using a QR or LQ
   *  factorization of A.  It is assumed that A has full rank.
   *
   *  The following options are provided:
   *
   *  1. If TRANS = 'N' and m >= n:  find the least squares solution of
   *     an overdetermined system, i.e., solve the least squares problem
   *                  minimize || B - A*X ||.
   *
   *  2. If TRANS = 'N' and m < n:  find the minimum norm solution of
   *     an underdetermined system A * X = B.
   *
   *  3. If TRANS = 'T' and m >= n:  find the minimum norm solution of
   *     an undetermined system A**T * X = B.
   *
   *  4. If TRANS = 'T' and m < n:  find the least squares solution of
   *     an overdetermined system, i.e., solve the least squares problem
   *                  minimize || B - A**T * X ||.
   *
   *  Several right hand side vectors b and solution vectors x can be
   *  handled in a single call; they are stored as the columns of the
   *  M-by-NRHS right hand side matrix B and the N-by-NRHS solution
   *  matrix X.
   *
   *  Arguments
   *  =========
   *
   *  TRANS   (input) CHARACTER*1
   *          = 'N': the linear system involves A;
   *          = 'T': the linear system involves A**T.
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of
   *          columns of the matrices B and X. NRHS >=0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit,
   *            if M >= N, A is overwritten by details of its QR
   *                       factorization as returned by DGEQRF;
   *            if M <  N, A is overwritten by details of its LQ
   *                       factorization as returned by DGELQF.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the matrix B of right hand side vectors, stored
   *          columnwise; B is M-by-NRHS if TRANS = 'N', or N-by-NRHS
   *          if TRANS = 'T'.
   *          On exit, if INFO = 0, B is overwritten by the solution
   *          vectors, stored columnwise:
   *          if TRANS = 'N' and m >= n, rows 1 to n of B contain the least
   *          squares solution vectors; the residual sum of squares for the
   *          solution in each column is given by the sum of squares of
   *          elements N+1 to M in that column;
   *          if TRANS = 'N' and m < n, rows 1 to N of B contain the
   *          minimum norm solution vectors;
   *          if TRANS = 'T' and m >= n, rows 1 to M of B contain the
   *          minimum norm solution vectors;
   *          if TRANS = 'T' and m < n, rows 1 to M of B contain the
   *          least squares solution vectors; the residual sum of squares
   *          for the solution in each column is given by the sum of
   *          squares of elements M+1 to N in that column.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= MAX(1,M,N).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.
   *          LWORK >= max( 1, MN + max( MN, NRHS ) ).
   *          For optimal performance,
   *          LWORK >= max( 1, MN + max( MN, NRHS )*NB ).
   *          where MN = min(M,N) and NB is the optimum block size.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO =  i, the i-th diagonal element of the
   *                triangular factor of A is zero, so that A does not have
   *                full rank; the least squares solution could not be
   *                computed.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param m
   * @param n
   * @param nrhs
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgels(java.lang.String trans, int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGELS solves overdetermined or underdetermined real linear systems
   *  involving an M-by-N matrix A, or its transpose, using a QR or LQ
   *  factorization of A.  It is assumed that A has full rank.
   *
   *  The following options are provided:
   *
   *  1. If TRANS = 'N' and m >= n:  find the least squares solution of
   *     an overdetermined system, i.e., solve the least squares problem
   *                  minimize || B - A*X ||.
   *
   *  2. If TRANS = 'N' and m < n:  find the minimum norm solution of
   *     an underdetermined system A * X = B.
   *
   *  3. If TRANS = 'T' and m >= n:  find the minimum norm solution of
   *     an undetermined system A**T * X = B.
   *
   *  4. If TRANS = 'T' and m < n:  find the least squares solution of
   *     an overdetermined system, i.e., solve the least squares problem
   *                  minimize || B - A**T * X ||.
   *
   *  Several right hand side vectors b and solution vectors x can be
   *  handled in a single call; they are stored as the columns of the
   *  M-by-NRHS right hand side matrix B and the N-by-NRHS solution
   *  matrix X.
   *
   *  Arguments
   *  =========
   *
   *  TRANS   (input) CHARACTER*1
   *          = 'N': the linear system involves A;
   *          = 'T': the linear system involves A**T.
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of
   *          columns of the matrices B and X. NRHS >=0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit,
   *            if M >= N, A is overwritten by details of its QR
   *                       factorization as returned by DGEQRF;
   *            if M <  N, A is overwritten by details of its LQ
   *                       factorization as returned by DGELQF.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the matrix B of right hand side vectors, stored
   *          columnwise; B is M-by-NRHS if TRANS = 'N', or N-by-NRHS
   *          if TRANS = 'T'.
   *          On exit, if INFO = 0, B is overwritten by the solution
   *          vectors, stored columnwise:
   *          if TRANS = 'N' and m >= n, rows 1 to n of B contain the least
   *          squares solution vectors; the residual sum of squares for the
   *          solution in each column is given by the sum of squares of
   *          elements N+1 to M in that column;
   *          if TRANS = 'N' and m < n, rows 1 to N of B contain the
   *          minimum norm solution vectors;
   *          if TRANS = 'T' and m >= n, rows 1 to M of B contain the
   *          minimum norm solution vectors;
   *          if TRANS = 'T' and m < n, rows 1 to M of B contain the
   *          least squares solution vectors; the residual sum of squares
   *          for the solution in each column is given by the sum of
   *          squares of elements M+1 to N in that column.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= MAX(1,M,N).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.
   *          LWORK >= max( 1, MN + max( MN, NRHS ) ).
   *          For optimal performance,
   *          LWORK >= max( 1, MN + max( MN, NRHS )*NB ).
   *          where MN = min(M,N) and NB is the optimum block size.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO =  i, the i-th diagonal element of the
   *                triangular factor of A is zero, so that A does not have
   *                full rank; the least squares solution could not be
   *                computed.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param m
   * @param n
   * @param nrhs
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgels(java.lang.String trans, int m, int n, int nrhs, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGELSD computes the minimum-norm solution to a real linear least
   *  squares problem:
   *      minimize 2-norm(| b - A*x |)
   *  using the singular value decomposition (SVD) of A. A is an M-by-N
   *  matrix which may be rank-deficient.
   *
   *  Several right hand side vectors b and solution vectors x can be
   *  handled in a single call; they are stored as the columns of the
   *  M-by-NRHS right hand side matrix B and the N-by-NRHS solution
   *  matrix X.
   *
   *  The problem is solved in three steps:
   *  (1) Reduce the coefficient matrix A to bidiagonal form with
   *      Householder transformations, reducing the original problem
   *      into a "bidiagonal least squares problem" (BLS)
   *  (2) Solve the BLS using a divide and conquer approach.
   *  (3) Apply back all the Householder tranformations to solve
   *      the original least squares problem.
   *
   *  The effective rank of A is determined by treating as zero those
   *  singular values which are less than RCOND times the largest singular
   *  value.
   *
   *  The divide and conquer algorithm makes very mild assumptions about
   *  floating point arithmetic. It will work on machines with a guard
   *  digit in add/subtract, or on those binary machines without guard
   *  digits which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or
   *  Cray-2. It could conceivably fail on hexadecimal or decimal machines
   *  without guard digits, but we know of none.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of A. M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of A. N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrices B and X. NRHS >= 0.
   *
   *  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, A has been destroyed.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the M-by-NRHS right hand side matrix B.
   *          On exit, B is overwritten by the N-by-NRHS solution
   *          matrix X.  If m >= n and RANK = n, the residual
   *          sum-of-squares for the solution in the i-th column is given
   *          by the sum of squares of elements n+1:m in that column.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,max(M,N)).
   *
   *  S       (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The singular values of A in decreasing order.
   *          The condition number of A in the 2-norm = S(1)/S(min(m,n)).
   *
   *  RCOND   (input) DOUBLE PRECISION
   *          RCOND is used to determine the effective rank of A.
   *          Singular values S(i) <= RCOND*S(1) are treated as zero.
   *          If RCOND < 0, machine precision is used instead.
   *
   *  RANK    (output) INTEGER
   *          The effective rank of A, i.e., the number of singular values
   *          which are greater than RCOND*S(1).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK. LWORK must be at least 1.
   *          The exact minimum amount of workspace needed depends on M,
   *          N and NRHS. As long as LWORK is at least
   *              12*N + 2*N*SMLSIZ + 8*N*NLVL + N*NRHS + (SMLSIZ+1)**2,
   *          if M is greater than or equal to N or
   *              12*M + 2*M*SMLSIZ + 8*M*NLVL + M*NRHS + (SMLSIZ+1)**2,
   *          if M is less than N, the code will execute correctly.
   *          SMLSIZ is returned by ILAENV and is equal to the maximum
   *          size of the subproblems at the bottom of the computation
   *          tree (usually about 25), and
   *             NLVL = MAX( 0, INT( LOG_2( MIN( M,N )/(SMLSIZ+1) ) ) + 1 )
   *          For good performance, LWORK should generally be larger.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  IWORK   (workspace) INTEGER array, dimension (MAX(1,LIWORK))
   *          LIWORK >= 3 * MINMN * NLVL + 11 * MINMN,
   *          where MINMN = MIN( M,N ).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  the algorithm for computing the SVD failed to converge;
   *                if INFO = i, i off-diagonal elements of an intermediate
   *                bidiagonal form did not converge to zero.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Ming Gu and Ren-Cang Li, Computer Science Division, University of
   *       California at Berkeley, USA
   *     Osni Marques, LBNL/NERSC, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param nrhs
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param s
   * @param rcond
   * @param rank
   * @param work
   * @param lwork
   * @param iwork
   * @param info
   * 
   */
  abstract public void dgelsd(int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, double[] s, double rcond, org.netlib.util.intW rank, double[] work, int lwork, int[] iwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGELSD computes the minimum-norm solution to a real linear least
   *  squares problem:
   *      minimize 2-norm(| b - A*x |)
   *  using the singular value decomposition (SVD) of A. A is an M-by-N
   *  matrix which may be rank-deficient.
   *
   *  Several right hand side vectors b and solution vectors x can be
   *  handled in a single call; they are stored as the columns of the
   *  M-by-NRHS right hand side matrix B and the N-by-NRHS solution
   *  matrix X.
   *
   *  The problem is solved in three steps:
   *  (1) Reduce the coefficient matrix A to bidiagonal form with
   *      Householder transformations, reducing the original problem
   *      into a "bidiagonal least squares problem" (BLS)
   *  (2) Solve the BLS using a divide and conquer approach.
   *  (3) Apply back all the Householder tranformations to solve
   *      the original least squares problem.
   *
   *  The effective rank of A is determined by treating as zero those
   *  singular values which are less than RCOND times the largest singular
   *  value.
   *
   *  The divide and conquer algorithm makes very mild assumptions about
   *  floating point arithmetic. It will work on machines with a guard
   *  digit in add/subtract, or on those binary machines without guard
   *  digits which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or
   *  Cray-2. It could conceivably fail on hexadecimal or decimal machines
   *  without guard digits, but we know of none.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of A. M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of A. N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrices B and X. NRHS >= 0.
   *
   *  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, A has been destroyed.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the M-by-NRHS right hand side matrix B.
   *          On exit, B is overwritten by the N-by-NRHS solution
   *          matrix X.  If m >= n and RANK = n, the residual
   *          sum-of-squares for the solution in the i-th column is given
   *          by the sum of squares of elements n+1:m in that column.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,max(M,N)).
   *
   *  S       (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The singular values of A in decreasing order.
   *          The condition number of A in the 2-norm = S(1)/S(min(m,n)).
   *
   *  RCOND   (input) DOUBLE PRECISION
   *          RCOND is used to determine the effective rank of A.
   *          Singular values S(i) <= RCOND*S(1) are treated as zero.
   *          If RCOND < 0, machine precision is used instead.
   *
   *  RANK    (output) INTEGER
   *          The effective rank of A, i.e., the number of singular values
   *          which are greater than RCOND*S(1).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK. LWORK must be at least 1.
   *          The exact minimum amount of workspace needed depends on M,
   *          N and NRHS. As long as LWORK is at least
   *              12*N + 2*N*SMLSIZ + 8*N*NLVL + N*NRHS + (SMLSIZ+1)**2,
   *          if M is greater than or equal to N or
   *              12*M + 2*M*SMLSIZ + 8*M*NLVL + M*NRHS + (SMLSIZ+1)**2,
   *          if M is less than N, the code will execute correctly.
   *          SMLSIZ is returned by ILAENV and is equal to the maximum
   *          size of the subproblems at the bottom of the computation
   *          tree (usually about 25), and
   *             NLVL = MAX( 0, INT( LOG_2( MIN( M,N )/(SMLSIZ+1) ) ) + 1 )
   *          For good performance, LWORK should generally be larger.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  IWORK   (workspace) INTEGER array, dimension (MAX(1,LIWORK))
   *          LIWORK >= 3 * MINMN * NLVL + 11 * MINMN,
   *          where MINMN = MIN( M,N ).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  the algorithm for computing the SVD failed to converge;
   *                if INFO = i, i off-diagonal elements of an intermediate
   *                bidiagonal form did not converge to zero.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Ming Gu and Ren-Cang Li, Computer Science Division, University of
   *       California at Berkeley, USA
   *     Osni Marques, LBNL/NERSC, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param nrhs
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param s
   * @param _s_offset
   * @param rcond
   * @param rank
   * @param work
   * @param _work_offset
   * @param lwork
   * @param iwork
   * @param _iwork_offset
   * @param info
   * 
   */
  abstract public void dgelsd(int m, int n, int nrhs, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double[] s, int _s_offset, double rcond, org.netlib.util.intW rank, double[] work, int _work_offset, int lwork, int[] iwork, int _iwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGELSS computes the minimum norm solution to a real linear least
   *  squares problem:
   *
   *  Minimize 2-norm(| b - A*x |).
   *
   *  using the singular value decomposition (SVD) of A. A is an M-by-N
   *  matrix which may be rank-deficient.
   *
   *  Several right hand side vectors b and solution vectors x can be
   *  handled in a single call; they are stored as the columns of the
   *  M-by-NRHS right hand side matrix B and the N-by-NRHS solution matrix
   *  X.
   *
   *  The effective rank of A is determined by treating as zero those
   *  singular values which are less than RCOND times the largest singular
   *  value.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A. M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A. N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrices B and X. NRHS >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, the first min(m,n) rows of A are overwritten with
   *          its right singular vectors, stored rowwise.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the M-by-NRHS right hand side matrix B.
   *          On exit, B is overwritten by the N-by-NRHS solution
   *          matrix X.  If m >= n and RANK = n, the residual
   *          sum-of-squares for the solution in the i-th column is given
   *          by the sum of squares of elements n+1:m in that column.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,max(M,N)).
   *
   *  S       (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The singular values of A in decreasing order.
   *          The condition number of A in the 2-norm = S(1)/S(min(m,n)).
   *
   *  RCOND   (input) DOUBLE PRECISION
   *          RCOND is used to determine the effective rank of A.
   *          Singular values S(i) <= RCOND*S(1) are treated as zero.
   *          If RCOND < 0, machine precision is used instead.
   *
   *  RANK    (output) INTEGER
   *          The effective rank of A, i.e., the number of singular values
   *          which are greater than RCOND*S(1).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK. LWORK >= 1, and also:
   *          LWORK >= 3*min(M,N) + max( 2*min(M,N), max(M,N), NRHS )
   *          For good performance, LWORK should generally be larger.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  the algorithm for computing the SVD failed to converge;
   *                if INFO = i, i off-diagonal elements of an intermediate
   *                bidiagonal form did not converge to zero.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param nrhs
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param s
   * @param rcond
   * @param rank
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgelss(int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, double[] s, double rcond, org.netlib.util.intW rank, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGELSS computes the minimum norm solution to a real linear least
   *  squares problem:
   *
   *  Minimize 2-norm(| b - A*x |).
   *
   *  using the singular value decomposition (SVD) of A. A is an M-by-N
   *  matrix which may be rank-deficient.
   *
   *  Several right hand side vectors b and solution vectors x can be
   *  handled in a single call; they are stored as the columns of the
   *  M-by-NRHS right hand side matrix B and the N-by-NRHS solution matrix
   *  X.
   *
   *  The effective rank of A is determined by treating as zero those
   *  singular values which are less than RCOND times the largest singular
   *  value.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A. M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A. N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrices B and X. NRHS >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, the first min(m,n) rows of A are overwritten with
   *          its right singular vectors, stored rowwise.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the M-by-NRHS right hand side matrix B.
   *          On exit, B is overwritten by the N-by-NRHS solution
   *          matrix X.  If m >= n and RANK = n, the residual
   *          sum-of-squares for the solution in the i-th column is given
   *          by the sum of squares of elements n+1:m in that column.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,max(M,N)).
   *
   *  S       (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The singular values of A in decreasing order.
   *          The condition number of A in the 2-norm = S(1)/S(min(m,n)).
   *
   *  RCOND   (input) DOUBLE PRECISION
   *          RCOND is used to determine the effective rank of A.
   *          Singular values S(i) <= RCOND*S(1) are treated as zero.
   *          If RCOND < 0, machine precision is used instead.
   *
   *  RANK    (output) INTEGER
   *          The effective rank of A, i.e., the number of singular values
   *          which are greater than RCOND*S(1).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK. LWORK >= 1, and also:
   *          LWORK >= 3*min(M,N) + max( 2*min(M,N), max(M,N), NRHS )
   *          For good performance, LWORK should generally be larger.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  the algorithm for computing the SVD failed to converge;
   *                if INFO = i, i off-diagonal elements of an intermediate
   *                bidiagonal form did not converge to zero.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param nrhs
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param s
   * @param _s_offset
   * @param rcond
   * @param rank
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgelss(int m, int n, int nrhs, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double[] s, int _s_offset, double rcond, org.netlib.util.intW rank, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  This routine is deprecated and has been replaced by routine DGELSY.
   *
   *  DGELSX computes the minimum-norm solution to a real linear least
   *  squares problem:
   *      minimize || A * X - B ||
   *  using a complete orthogonal factorization of A.  A is an M-by-N
   *  matrix which may be rank-deficient.
   *
   *  Several right hand side vectors b and solution vectors x can be
   *  handled in a single call; they are stored as the columns of the
   *  M-by-NRHS right hand side matrix B and the N-by-NRHS solution
   *  matrix X.
   *
   *  The routine first computes a QR factorization with column pivoting:
   *      A * P = Q * [ R11 R12 ]
   *                  [  0  R22 ]
   *  with R11 defined as the largest leading submatrix whose estimated
   *  condition number is less than 1/RCOND.  The order of R11, RANK,
   *  is the effective rank of A.
   *
   *  Then, R22 is considered to be negligible, and R12 is annihilated
   *  by orthogonal transformations from the right, arriving at the
   *  complete orthogonal factorization:
   *     A * P = Q * [ T11 0 ] * Z
   *                 [  0  0 ]
   *  The minimum-norm solution is then
   *     X = P * Z' [ inv(T11)*Q1'*B ]
   *                [        0       ]
   *  where Q1 consists of the first RANK columns of Q.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of
   *          columns of matrices B and X. NRHS >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, A has been overwritten by details of its
   *          complete orthogonal factorization.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the M-by-NRHS right hand side matrix B.
   *          On exit, the N-by-NRHS solution matrix X.
   *          If m >= n and RANK = n, the residual sum-of-squares for
   *          the solution in the i-th column is given by the sum of
   *          squares of elements N+1:M in that column.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,M,N).
   *
   *  JPVT    (input/output) INTEGER array, dimension (N)
   *          On entry, if JPVT(i) .ne. 0, the i-th column of A is an
   *          initial column, otherwise it is a free column.  Before
   *          the QR factorization of A, all initial columns are
   *          permuted to the leading positions; only the remaining
   *          free columns are moved as a result of column pivoting
   *          during the factorization.
   *          On exit, if JPVT(i) = k, then the i-th column of A*P
   *          was the k-th column of A.
   *
   *  RCOND   (input) DOUBLE PRECISION
   *          RCOND is used to determine the effective rank of A, which
   *          is defined as the order of the largest leading triangular
   *          submatrix R11 in the QR factorization with pivoting of A,
   *          whose estimated condition number < 1/RCOND.
   *
   *  RANK    (output) INTEGER
   *          The effective rank of A, i.e., the order of the submatrix
   *          R11.  This is the same as the order of the submatrix T11
   *          in the complete orthogonal factorization of A.
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension
   *                      (max( min(M,N)+3*N, 2*min(M,N)+NRHS )),
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param nrhs
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param jpvt
   * @param rcond
   * @param rank
   * @param work
   * @param info
   * 
   */
  abstract public void dgelsx(int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, int[] jpvt, double rcond, org.netlib.util.intW rank, double[] work, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  This routine is deprecated and has been replaced by routine DGELSY.
   *
   *  DGELSX computes the minimum-norm solution to a real linear least
   *  squares problem:
   *      minimize || A * X - B ||
   *  using a complete orthogonal factorization of A.  A is an M-by-N
   *  matrix which may be rank-deficient.
   *
   *  Several right hand side vectors b and solution vectors x can be
   *  handled in a single call; they are stored as the columns of the
   *  M-by-NRHS right hand side matrix B and the N-by-NRHS solution
   *  matrix X.
   *
   *  The routine first computes a QR factorization with column pivoting:
   *      A * P = Q * [ R11 R12 ]
   *                  [  0  R22 ]
   *  with R11 defined as the largest leading submatrix whose estimated
   *  condition number is less than 1/RCOND.  The order of R11, RANK,
   *  is the effective rank of A.
   *
   *  Then, R22 is considered to be negligible, and R12 is annihilated
   *  by orthogonal transformations from the right, arriving at the
   *  complete orthogonal factorization:
   *     A * P = Q * [ T11 0 ] * Z
   *                 [  0  0 ]
   *  The minimum-norm solution is then
   *     X = P * Z' [ inv(T11)*Q1'*B ]
   *                [        0       ]
   *  where Q1 consists of the first RANK columns of Q.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of
   *          columns of matrices B and X. NRHS >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, A has been overwritten by details of its
   *          complete orthogonal factorization.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the M-by-NRHS right hand side matrix B.
   *          On exit, the N-by-NRHS solution matrix X.
   *          If m >= n and RANK = n, the residual sum-of-squares for
   *          the solution in the i-th column is given by the sum of
   *          squares of elements N+1:M in that column.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,M,N).
   *
   *  JPVT    (input/output) INTEGER array, dimension (N)
   *          On entry, if JPVT(i) .ne. 0, the i-th column of A is an
   *          initial column, otherwise it is a free column.  Before
   *          the QR factorization of A, all initial columns are
   *          permuted to the leading positions; only the remaining
   *          free columns are moved as a result of column pivoting
   *          during the factorization.
   *          On exit, if JPVT(i) = k, then the i-th column of A*P
   *          was the k-th column of A.
   *
   *  RCOND   (input) DOUBLE PRECISION
   *          RCOND is used to determine the effective rank of A, which
   *          is defined as the order of the largest leading triangular
   *          submatrix R11 in the QR factorization with pivoting of A,
   *          whose estimated condition number < 1/RCOND.
   *
   *  RANK    (output) INTEGER
   *          The effective rank of A, i.e., the order of the submatrix
   *          R11.  This is the same as the order of the submatrix T11
   *          in the complete orthogonal factorization of A.
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension
   *                      (max( min(M,N)+3*N, 2*min(M,N)+NRHS )),
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param nrhs
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param jpvt
   * @param _jpvt_offset
   * @param rcond
   * @param rank
   * @param work
   * @param _work_offset
   * @param info
   * 
   */
  abstract public void dgelsx(int m, int n, int nrhs, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, int[] jpvt, int _jpvt_offset, double rcond, org.netlib.util.intW rank, double[] work, int _work_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGELSY computes the minimum-norm solution to a real linear least
   *  squares problem:
   *      minimize || A * X - B ||
   *  using a complete orthogonal factorization of A.  A is an M-by-N
   *  matrix which may be rank-deficient.
   *
   *  Several right hand side vectors b and solution vectors x can be
   *  handled in a single call; they are stored as the columns of the
   *  M-by-NRHS right hand side matrix B and the N-by-NRHS solution
   *  matrix X.
   *
   *  The routine first computes a QR factorization with column pivoting:
   *      A * P = Q * [ R11 R12 ]
   *                  [  0  R22 ]
   *  with R11 defined as the largest leading submatrix whose estimated
   *  condition number is less than 1/RCOND.  The order of R11, RANK,
   *  is the effective rank of A.
   *
   *  Then, R22 is considered to be negligible, and R12 is annihilated
   *  by orthogonal transformations from the right, arriving at the
   *  complete orthogonal factorization:
   *     A * P = Q * [ T11 0 ] * Z
   *                 [  0  0 ]
   *  The minimum-norm solution is then
   *     X = P * Z' [ inv(T11)*Q1'*B ]
   *                [        0       ]
   *  where Q1 consists of the first RANK columns of Q.
   *
   *  This routine is basically identical to the original xGELSX except
   *  three differences:
   *    o The call to the subroutine xGEQPF has been substituted by the
   *      the call to the subroutine xGEQP3. This subroutine is a Blas-3
   *      version of the QR factorization with column pivoting.
   *    o Matrix B (the right hand side) is updated with Blas-3.
   *    o The permutation of matrix B (the right hand side) is faster and
   *      more simple.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of
   *          columns of matrices B and X. NRHS >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, A has been overwritten by details of its
   *          complete orthogonal factorization.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the M-by-NRHS right hand side matrix B.
   *          On exit, the N-by-NRHS solution matrix X.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,M,N).
   *
   *  JPVT    (input/output) INTEGER array, dimension (N)
   *          On entry, if JPVT(i) .ne. 0, the i-th column of A is permuted
   *          to the front of AP, otherwise column i is a free column.
   *          On exit, if JPVT(i) = k, then the i-th column of AP
   *          was the k-th column of A.
   *
   *  RCOND   (input) DOUBLE PRECISION
   *          RCOND is used to determine the effective rank of A, which
   *          is defined as the order of the largest leading triangular
   *          submatrix R11 in the QR factorization with pivoting of A,
   *          whose estimated condition number < 1/RCOND.
   *
   *  RANK    (output) INTEGER
   *          The effective rank of A, i.e., the order of the submatrix
   *          R11.  This is the same as the order of the submatrix T11
   *          in the complete orthogonal factorization of A.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.
   *          The unblocked strategy requires that:
   *             LWORK >= MAX( MN+3*N+1, 2*MN+NRHS ),
   *          where MN = min( M, N ).
   *          The block algorithm requires that:
   *             LWORK >= MAX( MN+2*N+NB*(N+1), 2*MN+NB*NRHS ),
   *          where NB is an upper bound on the blocksize returned
   *          by ILAENV for the routines DGEQP3, DTZRZF, STZRQF, DORMQR,
   *          and DORMRZ.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: If INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *    A. Petitet, Computer Science Dept., Univ. of Tenn., Knoxville, USA
   *    E. Quintana-Orti, Depto. de Informatica, Universidad Jaime I, Spain
   *    G. Quintana-Orti, Depto. de Informatica, Universidad Jaime I, Spain
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param nrhs
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param jpvt
   * @param rcond
   * @param rank
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgelsy(int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, int[] jpvt, double rcond, org.netlib.util.intW rank, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGELSY computes the minimum-norm solution to a real linear least
   *  squares problem:
   *      minimize || A * X - B ||
   *  using a complete orthogonal factorization of A.  A is an M-by-N
   *  matrix which may be rank-deficient.
   *
   *  Several right hand side vectors b and solution vectors x can be
   *  handled in a single call; they are stored as the columns of the
   *  M-by-NRHS right hand side matrix B and the N-by-NRHS solution
   *  matrix X.
   *
   *  The routine first computes a QR factorization with column pivoting:
   *      A * P = Q * [ R11 R12 ]
   *                  [  0  R22 ]
   *  with R11 defined as the largest leading submatrix whose estimated
   *  condition number is less than 1/RCOND.  The order of R11, RANK,
   *  is the effective rank of A.
   *
   *  Then, R22 is considered to be negligible, and R12 is annihilated
   *  by orthogonal transformations from the right, arriving at the
   *  complete orthogonal factorization:
   *     A * P = Q * [ T11 0 ] * Z
   *                 [  0  0 ]
   *  The minimum-norm solution is then
   *     X = P * Z' [ inv(T11)*Q1'*B ]
   *                [        0       ]
   *  where Q1 consists of the first RANK columns of Q.
   *
   *  This routine is basically identical to the original xGELSX except
   *  three differences:
   *    o The call to the subroutine xGEQPF has been substituted by the
   *      the call to the subroutine xGEQP3. This subroutine is a Blas-3
   *      version of the QR factorization with column pivoting.
   *    o Matrix B (the right hand side) is updated with Blas-3.
   *    o The permutation of matrix B (the right hand side) is faster and
   *      more simple.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of
   *          columns of matrices B and X. NRHS >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, A has been overwritten by details of its
   *          complete orthogonal factorization.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the M-by-NRHS right hand side matrix B.
   *          On exit, the N-by-NRHS solution matrix X.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,M,N).
   *
   *  JPVT    (input/output) INTEGER array, dimension (N)
   *          On entry, if JPVT(i) .ne. 0, the i-th column of A is permuted
   *          to the front of AP, otherwise column i is a free column.
   *          On exit, if JPVT(i) = k, then the i-th column of AP
   *          was the k-th column of A.
   *
   *  RCOND   (input) DOUBLE PRECISION
   *          RCOND is used to determine the effective rank of A, which
   *          is defined as the order of the largest leading triangular
   *          submatrix R11 in the QR factorization with pivoting of A,
   *          whose estimated condition number < 1/RCOND.
   *
   *  RANK    (output) INTEGER
   *          The effective rank of A, i.e., the order of the submatrix
   *          R11.  This is the same as the order of the submatrix T11
   *          in the complete orthogonal factorization of A.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.
   *          The unblocked strategy requires that:
   *             LWORK >= MAX( MN+3*N+1, 2*MN+NRHS ),
   *          where MN = min( M, N ).
   *          The block algorithm requires that:
   *             LWORK >= MAX( MN+2*N+NB*(N+1), 2*MN+NB*NRHS ),
   *          where NB is an upper bound on the blocksize returned
   *          by ILAENV for the routines DGEQP3, DTZRZF, STZRQF, DORMQR,
   *          and DORMRZ.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: If INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *    A. Petitet, Computer Science Dept., Univ. of Tenn., Knoxville, USA
   *    E. Quintana-Orti, Depto. de Informatica, Universidad Jaime I, Spain
   *    G. Quintana-Orti, Depto. de Informatica, Universidad Jaime I, Spain
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param nrhs
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param jpvt
   * @param _jpvt_offset
   * @param rcond
   * @param rank
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgelsy(int m, int n, int nrhs, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, int[] jpvt, int _jpvt_offset, double rcond, org.netlib.util.intW rank, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEQL2 computes a QL factorization of a real m by n matrix A:
   *  A = Q * L.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the m by n matrix A.
   *          On exit, if m >= n, the lower triangle of the subarray
   *          A(m-n+1:m,1:n) contains the n by n lower triangular matrix L;
   *          if m <= n, the elements on and below the (n-m)-th
   *          superdiagonal contain the m by n lower trapezoidal matrix L;
   *          the remaining elements, with the array TAU, represent the
   *          orthogonal matrix Q as a product of elementary reflectors
   *          (see Further Details).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors (see Further
   *          Details).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(k) . . . H(2) H(1), where k = min(m,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(m-k+i+1:m) = 0 and v(m-k+i) = 1; v(1:m-k+i-1) is stored on exit in
   *  A(1:m-k+i-1,n-k+i), and tau in TAU(i).
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param tau
   * @param work
   * @param info
   * 
   */
  abstract public void dgeql2(int m, int n, double[] a, int lda, double[] tau, double[] work, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEQL2 computes a QL factorization of a real m by n matrix A:
   *  A = Q * L.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the m by n matrix A.
   *          On exit, if m >= n, the lower triangle of the subarray
   *          A(m-n+1:m,1:n) contains the n by n lower triangular matrix L;
   *          if m <= n, the elements on and below the (n-m)-th
   *          superdiagonal contain the m by n lower trapezoidal matrix L;
   *          the remaining elements, with the array TAU, represent the
   *          orthogonal matrix Q as a product of elementary reflectors
   *          (see Further Details).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors (see Further
   *          Details).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(k) . . . H(2) H(1), where k = min(m,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(m-k+i+1:m) = 0 and v(m-k+i) = 1; v(1:m-k+i-1) is stored on exit in
   *  A(1:m-k+i-1,n-k+i), and tau in TAU(i).
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param tau
   * @param _tau_offset
   * @param work
   * @param _work_offset
   * @param info
   * 
   */
  abstract public void dgeql2(int m, int n, double[] a, int _a_offset, int lda, double[] tau, int _tau_offset, double[] work, int _work_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEQLF computes a QL factorization of a real M-by-N matrix A:
   *  A = Q * L.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit,
   *          if m >= n, the lower triangle of the subarray
   *          A(m-n+1:m,1:n) contains the N-by-N lower triangular matrix L;
   *          if m <= n, the elements on and below the (n-m)-th
   *          superdiagonal contain the M-by-N lower trapezoidal matrix L;
   *          the remaining elements, with the array TAU, represent the
   *          orthogonal matrix Q as a product of elementary reflectors
   *          (see Further Details).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors (see Further
   *          Details).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,N).
   *          For optimum performance LWORK >= N*NB, where NB is the
   *          optimal blocksize.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(k) . . . H(2) H(1), where k = min(m,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(m-k+i+1:m) = 0 and v(m-k+i) = 1; v(1:m-k+i-1) is stored on exit in
   *  A(1:m-k+i-1,n-k+i), and tau in TAU(i).
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param tau
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgeqlf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEQLF computes a QL factorization of a real M-by-N matrix A:
   *  A = Q * L.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit,
   *          if m >= n, the lower triangle of the subarray
   *          A(m-n+1:m,1:n) contains the N-by-N lower triangular matrix L;
   *          if m <= n, the elements on and below the (n-m)-th
   *          superdiagonal contain the M-by-N lower trapezoidal matrix L;
   *          the remaining elements, with the array TAU, represent the
   *          orthogonal matrix Q as a product of elementary reflectors
   *          (see Further Details).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors (see Further
   *          Details).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,N).
   *          For optimum performance LWORK >= N*NB, where NB is the
   *          optimal blocksize.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(k) . . . H(2) H(1), where k = min(m,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(m-k+i+1:m) = 0 and v(m-k+i) = 1; v(1:m-k+i-1) is stored on exit in
   *  A(1:m-k+i-1,n-k+i), and tau in TAU(i).
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param tau
   * @param _tau_offset
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgeqlf(int m, int n, double[] a, int _a_offset, int lda, double[] tau, int _tau_offset, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEQP3 computes a QR factorization with column pivoting of a
   *  matrix A:  A*P = Q*R  using Level 3 BLAS.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A. M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, the upper triangle of the array contains the
   *          min(M,N)-by-N upper trapezoidal matrix R; the elements below
   *          the diagonal, together with the array TAU, represent the
   *          orthogonal matrix Q as a product of min(M,N) elementary
   *          reflectors.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A. LDA >= max(1,M).
   *
   *  JPVT    (input/output) INTEGER array, dimension (N)
   *          On entry, if JPVT(J).ne.0, the J-th column of A is permuted
   *          to the front of A*P (a leading column); if JPVT(J)=0,
   *          the J-th column of A is a free column.
   *          On exit, if JPVT(J)=K, then the J-th column of A*P was the
   *          the K-th column of A.
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO=0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK. LWORK >= 3*N+1.
   *          For optimal performance LWORK >= 2*N+( N+1 )*NB, where NB
   *          is the optimal blocksize.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit.
   *          < 0: if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(1) H(2) . . . H(k), where k = min(m,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real/complex scalar, and v is a real/complex vector
   *  with v(1:i-1) = 0 and v(i) = 1; v(i+1:m) is stored on exit in
   *  A(i+1:m,i), and tau in TAU(i).
   *
   *  Based on contributions by
   *    G. Quintana-Orti, Depto. de Informatica, Universidad Jaime I, Spain
   *    X. Sun, Computer Science Dept., Duke University, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param jpvt
   * @param tau
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgeqp3(int m, int n, double[] a, int lda, int[] jpvt, double[] tau, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEQP3 computes a QR factorization with column pivoting of a
   *  matrix A:  A*P = Q*R  using Level 3 BLAS.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A. M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, the upper triangle of the array contains the
   *          min(M,N)-by-N upper trapezoidal matrix R; the elements below
   *          the diagonal, together with the array TAU, represent the
   *          orthogonal matrix Q as a product of min(M,N) elementary
   *          reflectors.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A. LDA >= max(1,M).
   *
   *  JPVT    (input/output) INTEGER array, dimension (N)
   *          On entry, if JPVT(J).ne.0, the J-th column of A is permuted
   *          to the front of A*P (a leading column); if JPVT(J)=0,
   *          the J-th column of A is a free column.
   *          On exit, if JPVT(J)=K, then the J-th column of A*P was the
   *          the K-th column of A.
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO=0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK. LWORK >= 3*N+1.
   *          For optimal performance LWORK >= 2*N+( N+1 )*NB, where NB
   *          is the optimal blocksize.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit.
   *          < 0: if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(1) H(2) . . . H(k), where k = min(m,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real/complex scalar, and v is a real/complex vector
   *  with v(1:i-1) = 0 and v(i) = 1; v(i+1:m) is stored on exit in
   *  A(i+1:m,i), and tau in TAU(i).
   *
   *  Based on contributions by
   *    G. Quintana-Orti, Depto. de Informatica, Universidad Jaime I, Spain
   *    X. Sun, Computer Science Dept., Duke University, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param jpvt
   * @param _jpvt_offset
   * @param tau
   * @param _tau_offset
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgeqp3(int m, int n, double[] a, int _a_offset, int lda, int[] jpvt, int _jpvt_offset, double[] tau, int _tau_offset, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  This routine is deprecated and has been replaced by routine DGEQP3.
   *
   *  DGEQPF computes a QR factorization with column pivoting of a
   *  real M-by-N matrix A: A*P = Q*R.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A. M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A. N >= 0
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, the upper triangle of the array contains the
   *          min(M,N)-by-N upper triangular matrix R; the elements
   *          below the diagonal, together with the array TAU,
   *          represent the orthogonal matrix Q as a product of
   *          min(m,n) elementary reflectors.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A. LDA >= max(1,M).
   *
   *  JPVT    (input/output) INTEGER array, dimension (N)
   *          On entry, if JPVT(i) .ne. 0, the i-th column of A is permuted
   *          to the front of A*P (a leading column); if JPVT(i) = 0,
   *          the i-th column of A is a free column.
   *          On exit, if JPVT(i) = k, then the i-th column of A*P
   *          was the k-th column of A.
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors.
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(1) H(2) . . . H(n)
   *
   *  Each H(i) has the form
   *
   *     H = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(1:i-1) = 0 and v(i) = 1; v(i+1:m) is stored on exit in A(i+1:m,i).
   *
   *  The matrix P is represented in jpvt as follows: If
   *     jpvt(j) = i
   *  then the jth column of P is the ith canonical unit vector.
   *
   *  Partial column norm updating strategy modified by
   *    Z. Drmac and Z. Bujanovic, Dept. of Mathematics,
   *    University of Zagreb, Croatia.
   *    June 2006.
   *  For more details see LAPACK Working Note 176.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param jpvt
   * @param tau
   * @param work
   * @param info
   * 
   */
  abstract public void dgeqpf(int m, int n, double[] a, int lda, int[] jpvt, double[] tau, double[] work, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  This routine is deprecated and has been replaced by routine DGEQP3.
   *
   *  DGEQPF computes a QR factorization with column pivoting of a
   *  real M-by-N matrix A: A*P = Q*R.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A. M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A. N >= 0
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, the upper triangle of the array contains the
   *          min(M,N)-by-N upper triangular matrix R; the elements
   *          below the diagonal, together with the array TAU,
   *          represent the orthogonal matrix Q as a product of
   *          min(m,n) elementary reflectors.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A. LDA >= max(1,M).
   *
   *  JPVT    (input/output) INTEGER array, dimension (N)
   *          On entry, if JPVT(i) .ne. 0, the i-th column of A is permuted
   *          to the front of A*P (a leading column); if JPVT(i) = 0,
   *          the i-th column of A is a free column.
   *          On exit, if JPVT(i) = k, then the i-th column of A*P
   *          was the k-th column of A.
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors.
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(1) H(2) . . . H(n)
   *
   *  Each H(i) has the form
   *
   *     H = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(1:i-1) = 0 and v(i) = 1; v(i+1:m) is stored on exit in A(i+1:m,i).
   *
   *  The matrix P is represented in jpvt as follows: If
   *     jpvt(j) = i
   *  then the jth column of P is the ith canonical unit vector.
   *
   *  Partial column norm updating strategy modified by
   *    Z. Drmac and Z. Bujanovic, Dept. of Mathematics,
   *    University of Zagreb, Croatia.
   *    June 2006.
   *  For more details see LAPACK Working Note 176.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param jpvt
   * @param _jpvt_offset
   * @param tau
   * @param _tau_offset
   * @param work
   * @param _work_offset
   * @param info
   * 
   */
  abstract public void dgeqpf(int m, int n, double[] a, int _a_offset, int lda, int[] jpvt, int _jpvt_offset, double[] tau, int _tau_offset, double[] work, int _work_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEQR2 computes a QR factorization of a real m by n matrix A:
   *  A = Q * R.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the m by n matrix A.
   *          On exit, the elements on and above the diagonal of the array
   *          contain the min(m,n) by n upper trapezoidal matrix R (R is
   *          upper triangular if m >= n); the elements below the diagonal,
   *          with the array TAU, represent the orthogonal matrix Q as a
   *          product of elementary reflectors (see Further Details).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors (see Further
   *          Details).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(1) H(2) . . . H(k), where k = min(m,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(1:i-1) = 0 and v(i) = 1; v(i+1:m) is stored on exit in A(i+1:m,i),
   *  and tau in TAU(i).
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param tau
   * @param work
   * @param info
   * 
   */
  abstract public void dgeqr2(int m, int n, double[] a, int lda, double[] tau, double[] work, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEQR2 computes a QR factorization of a real m by n matrix A:
   *  A = Q * R.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the m by n matrix A.
   *          On exit, the elements on and above the diagonal of the array
   *          contain the min(m,n) by n upper trapezoidal matrix R (R is
   *          upper triangular if m >= n); the elements below the diagonal,
   *          with the array TAU, represent the orthogonal matrix Q as a
   *          product of elementary reflectors (see Further Details).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors (see Further
   *          Details).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(1) H(2) . . . H(k), where k = min(m,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(1:i-1) = 0 and v(i) = 1; v(i+1:m) is stored on exit in A(i+1:m,i),
   *  and tau in TAU(i).
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param tau
   * @param _tau_offset
   * @param work
   * @param _work_offset
   * @param info
   * 
   */
  abstract public void dgeqr2(int m, int n, double[] a, int _a_offset, int lda, double[] tau, int _tau_offset, double[] work, int _work_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEQRF computes a QR factorization of a real M-by-N matrix A:
   *  A = Q * R.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, the elements on and above the diagonal of the array
   *          contain the min(M,N)-by-N upper trapezoidal matrix R (R is
   *          upper triangular if m >= n); the elements below the diagonal,
   *          with the array TAU, represent the orthogonal matrix Q as a
   *          product of min(m,n) elementary reflectors (see Further
   *          Details).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors (see Further
   *          Details).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,N).
   *          For optimum performance LWORK >= N*NB, where NB is
   *          the optimal blocksize.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(1) H(2) . . . H(k), where k = min(m,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(1:i-1) = 0 and v(i) = 1; v(i+1:m) is stored on exit in A(i+1:m,i),
   *  and tau in TAU(i).
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param tau
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgeqrf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGEQRF computes a QR factorization of a real M-by-N matrix A:
   *  A = Q * R.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, the elements on and above the diagonal of the array
   *          contain the min(M,N)-by-N upper trapezoidal matrix R (R is
   *          upper triangular if m >= n); the elements below the diagonal,
   *          with the array TAU, represent the orthogonal matrix Q as a
   *          product of min(m,n) elementary reflectors (see Further
   *          Details).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors (see Further
   *          Details).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,N).
   *          For optimum performance LWORK >= N*NB, where NB is
   *          the optimal blocksize.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(1) H(2) . . . H(k), where k = min(m,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(1:i-1) = 0 and v(i) = 1; v(i+1:m) is stored on exit in A(i+1:m,i),
   *  and tau in TAU(i).
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param tau
   * @param _tau_offset
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgeqrf(int m, int n, double[] a, int _a_offset, int lda, double[] tau, int _tau_offset, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGERFS improves the computed solution to a system of linear
   *  equations and provides error bounds and backward error estimates for
   *  the solution.
   *
   *  Arguments
   *  =========
   *
   *  TRANS   (input) CHARACTER*1
   *          Specifies the form of the system of equations:
   *          = 'N':  A * X = B     (No transpose)
   *          = 'T':  A**T * X = B  (Transpose)
   *          = 'C':  A**H * X = B  (Conjugate transpose = Transpose)
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrices B and X.  NRHS >= 0.
   *
   *  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
   *          The original N-by-N matrix A.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  AF      (input) DOUBLE PRECISION array, dimension (LDAF,N)
   *          The factors L and U from the factorization A = P*L*U
   *          as computed by DGETRF.
   *
   *  LDAF    (input) INTEGER
   *          The leading dimension of the array AF.  LDAF >= max(1,N).
   *
   *  IPIV    (input) INTEGER array, dimension (N)
   *          The pivot indices from DGETRF; for 1<=i<=N, row i of the
   *          matrix was interchanged with row IPIV(i).
   *
   *  B       (input) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          The right hand side matrix B.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  X       (input/output) DOUBLE PRECISION array, dimension (LDX,NRHS)
   *          On entry, the solution matrix X, as computed by DGETRS.
   *          On exit, the improved solution matrix X.
   *
   *  LDX     (input) INTEGER
   *          The leading dimension of the array X.  LDX >= max(1,N).
   *
   *  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The estimated forward error bound for each solution vector
   *          X(j) (the j-th column of the solution matrix X).
   *          If XTRUE is the true solution corresponding to X(j), FERR(j)
   *          is an estimated upper bound for the magnitude of the largest
   *          element in (X(j) - XTRUE) divided by the magnitude of the
   *          largest element in X(j).  The estimate is as reliable as
   *          the estimate for RCOND, and is almost always a slight
   *          overestimate of the true error.
   *
   *  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The componentwise relative backward error of each solution
   *          vector X(j) (i.e., the smallest relative change in
   *          any element of A or B that makes X(j) an exact solution).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)
   *
   *  IWORK   (workspace) INTEGER array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  Internal Parameters
   *  ===================
   *
   *  ITMAX is the maximum number of steps of iterative refinement.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param n
   * @param nrhs
   * @param a
   * @param lda
   * @param af
   * @param ldaf
   * @param ipiv
   * @param b
   * @param ldb
   * @param x
   * @param ldx
   * @param ferr
   * @param berr
   * @param work
   * @param iwork
   * @param info
   * 
   */
  abstract public void dgerfs(java.lang.String trans, int n, int nrhs, double[] a, int lda, double[] af, int ldaf, int[] ipiv, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGERFS improves the computed solution to a system of linear
   *  equations and provides error bounds and backward error estimates for
   *  the solution.
   *
   *  Arguments
   *  =========
   *
   *  TRANS   (input) CHARACTER*1
   *          Specifies the form of the system of equations:
   *          = 'N':  A * X = B     (No transpose)
   *          = 'T':  A**T * X = B  (Transpose)
   *          = 'C':  A**H * X = B  (Conjugate transpose = Transpose)
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrices B and X.  NRHS >= 0.
   *
   *  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
   *          The original N-by-N matrix A.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  AF      (input) DOUBLE PRECISION array, dimension (LDAF,N)
   *          The factors L and U from the factorization A = P*L*U
   *          as computed by DGETRF.
   *
   *  LDAF    (input) INTEGER
   *          The leading dimension of the array AF.  LDAF >= max(1,N).
   *
   *  IPIV    (input) INTEGER array, dimension (N)
   *          The pivot indices from DGETRF; for 1<=i<=N, row i of the
   *          matrix was interchanged with row IPIV(i).
   *
   *  B       (input) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          The right hand side matrix B.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  X       (input/output) DOUBLE PRECISION array, dimension (LDX,NRHS)
   *          On entry, the solution matrix X, as computed by DGETRS.
   *          On exit, the improved solution matrix X.
   *
   *  LDX     (input) INTEGER
   *          The leading dimension of the array X.  LDX >= max(1,N).
   *
   *  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The estimated forward error bound for each solution vector
   *          X(j) (the j-th column of the solution matrix X).
   *          If XTRUE is the true solution corresponding to X(j), FERR(j)
   *          is an estimated upper bound for the magnitude of the largest
   *          element in (X(j) - XTRUE) divided by the magnitude of the
   *          largest element in X(j).  The estimate is as reliable as
   *          the estimate for RCOND, and is almost always a slight
   *          overestimate of the true error.
   *
   *  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The componentwise relative backward error of each solution
   *          vector X(j) (i.e., the smallest relative change in
   *          any element of A or B that makes X(j) an exact solution).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)
   *
   *  IWORK   (workspace) INTEGER array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  Internal Parameters
   *  ===================
   *
   *  ITMAX is the maximum number of steps of iterative refinement.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param n
   * @param nrhs
   * @param a
   * @param _a_offset
   * @param lda
   * @param af
   * @param _af_offset
   * @param ldaf
   * @param ipiv
   * @param _ipiv_offset
   * @param b
   * @param _b_offset
   * @param ldb
   * @param x
   * @param _x_offset
   * @param ldx
   * @param ferr
   * @param _ferr_offset
   * @param berr
   * @param _berr_offset
   * @param work
   * @param _work_offset
   * @param iwork
   * @param _iwork_offset
   * @param info
   * 
   */
  abstract public void dgerfs(java.lang.String trans, int n, int nrhs, double[] a, int _a_offset, int lda, double[] af, int _af_offset, int ldaf, int[] ipiv, int _ipiv_offset, double[] b, int _b_offset, int ldb, double[] x, int _x_offset, int ldx, double[] ferr, int _ferr_offset, double[] berr, int _berr_offset, double[] work, int _work_offset, int[] iwork, int _iwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGERQ2 computes an RQ factorization of a real m by n matrix A:
   *  A = R * Q.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the m by n matrix A.
   *          On exit, if m <= n, the upper triangle of the subarray
   *          A(1:m,n-m+1:n) contains the m by m upper triangular matrix R;
   *          if m >= n, the elements on and above the (m-n)-th subdiagonal
   *          contain the m by n upper trapezoidal matrix R; the remaining
   *          elements, with the array TAU, represent the orthogonal matrix
   *          Q as a product of elementary reflectors (see Further
   *          Details).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors (see Further
   *          Details).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (M)
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(1) H(2) . . . H(k), where k = min(m,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(n-k+i+1:n) = 0 and v(n-k+i) = 1; v(1:n-k+i-1) is stored on exit in
   *  A(m-k+i,1:n-k+i-1), and tau in TAU(i).
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param tau
   * @param work
   * @param info
   * 
   */
  abstract public void dgerq2(int m, int n, double[] a, int lda, double[] tau, double[] work, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGERQ2 computes an RQ factorization of a real m by n matrix A:
   *  A = R * Q.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the m by n matrix A.
   *          On exit, if m <= n, the upper triangle of the subarray
   *          A(1:m,n-m+1:n) contains the m by m upper triangular matrix R;
   *          if m >= n, the elements on and above the (m-n)-th subdiagonal
   *          contain the m by n upper trapezoidal matrix R; the remaining
   *          elements, with the array TAU, represent the orthogonal matrix
   *          Q as a product of elementary reflectors (see Further
   *          Details).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors (see Further
   *          Details).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (M)
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(1) H(2) . . . H(k), where k = min(m,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(n-k+i+1:n) = 0 and v(n-k+i) = 1; v(1:n-k+i-1) is stored on exit in
   *  A(m-k+i,1:n-k+i-1), and tau in TAU(i).
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param tau
   * @param _tau_offset
   * @param work
   * @param _work_offset
   * @param info
   * 
   */
  abstract public void dgerq2(int m, int n, double[] a, int _a_offset, int lda, double[] tau, int _tau_offset, double[] work, int _work_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGERQF computes an RQ factorization of a real M-by-N matrix A:
   *  A = R * Q.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit,
   *          if m <= n, the upper triangle of the subarray
   *          A(1:m,n-m+1:n) contains the M-by-M upper triangular matrix R;
   *          if m >= n, the elements on and above the (m-n)-th subdiagonal
   *          contain the M-by-N upper trapezoidal matrix R;
   *          the remaining elements, with the array TAU, represent the
   *          orthogonal matrix Q as a product of min(m,n) elementary
   *          reflectors (see Further Details).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors (see Further
   *          Details).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,M).
   *          For optimum performance LWORK >= M*NB, where NB is
   *          the optimal blocksize.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(1) H(2) . . . H(k), where k = min(m,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(n-k+i+1:n) = 0 and v(n-k+i) = 1; v(1:n-k+i-1) is stored on exit in
   *  A(m-k+i,1:n-k+i-1), and tau in TAU(i).
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param tau
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgerqf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGERQF computes an RQ factorization of a real M-by-N matrix A:
   *  A = R * Q.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit,
   *          if m <= n, the upper triangle of the subarray
   *          A(1:m,n-m+1:n) contains the M-by-M upper triangular matrix R;
   *          if m >= n, the elements on and above the (m-n)-th subdiagonal
   *          contain the M-by-N upper trapezoidal matrix R;
   *          the remaining elements, with the array TAU, represent the
   *          orthogonal matrix Q as a product of min(m,n) elementary
   *          reflectors (see Further Details).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors (see Further
   *          Details).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,M).
   *          For optimum performance LWORK >= M*NB, where NB is
   *          the optimal blocksize.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(1) H(2) . . . H(k), where k = min(m,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(n-k+i+1:n) = 0 and v(n-k+i) = 1; v(1:n-k+i-1) is stored on exit in
   *  A(m-k+i,1:n-k+i-1), and tau in TAU(i).
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param tau
   * @param _tau_offset
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgerqf(int m, int n, double[] a, int _a_offset, int lda, double[] tau, int _tau_offset, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGESC2 solves a system of linear equations
   *
   *            A * X = scale* RHS
   *
   *  with a general N-by-N matrix A using the LU factorization with
   *  complete pivoting computed by DGETC2.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.
   *
   *  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the  LU part of the factorization of the n-by-n
   *          matrix A computed by DGETC2:  A = P * L * U * Q
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1, N).
   *
   *  RHS     (input/output) DOUBLE PRECISION array, dimension (N).
   *          On entry, the right hand side vector b.
   *          On exit, the solution vector X.
   *
   *  IPIV    (input) INTEGER array, dimension (N).
   *          The pivot indices; for 1 <= i <= N, row i of the
   *          matrix has been interchanged with row IPIV(i).
   *
   *  JPIV    (input) INTEGER array, dimension (N).
   *          The pivot indices; for 1 <= j <= N, column j of the
   *          matrix has been interchanged with column JPIV(j).
   *
   *  SCALE    (output) DOUBLE PRECISION
   *           On exit, SCALE contains the scale factor. SCALE is chosen
   *           0 <= SCALE <= 1 to prevent owerflow in the solution.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Bo Kagstrom and Peter Poromaa, Department of Computing Science,
   *     Umea University, S-901 87 Umea, Sweden.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param a
   * @param lda
   * @param rhs
   * @param ipiv
   * @param jpiv
   * @param scale
   * 
   */
  abstract public void dgesc2(int n, double[] a, int lda, double[] rhs, int[] ipiv, int[] jpiv, org.netlib.util.doubleW scale);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGESC2 solves a system of linear equations
   *
   *            A * X = scale* RHS
   *
   *  with a general N-by-N matrix A using the LU factorization with
   *  complete pivoting computed by DGETC2.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.
   *
   *  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the  LU part of the factorization of the n-by-n
   *          matrix A computed by DGETC2:  A = P * L * U * Q
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1, N).
   *
   *  RHS     (input/output) DOUBLE PRECISION array, dimension (N).
   *          On entry, the right hand side vector b.
   *          On exit, the solution vector X.
   *
   *  IPIV    (input) INTEGER array, dimension (N).
   *          The pivot indices; for 1 <= i <= N, row i of the
   *          matrix has been interchanged with row IPIV(i).
   *
   *  JPIV    (input) INTEGER array, dimension (N).
   *          The pivot indices; for 1 <= j <= N, column j of the
   *          matrix has been interchanged with column JPIV(j).
   *
   *  SCALE    (output) DOUBLE PRECISION
   *           On exit, SCALE contains the scale factor. SCALE is chosen
   *           0 <= SCALE <= 1 to prevent owerflow in the solution.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Bo Kagstrom and Peter Poromaa, Department of Computing Science,
   *     Umea University, S-901 87 Umea, Sweden.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param rhs
   * @param _rhs_offset
   * @param ipiv
   * @param _ipiv_offset
   * @param jpiv
   * @param _jpiv_offset
   * @param scale
   * 
   */
  abstract public void dgesc2(int n, double[] a, int _a_offset, int lda, double[] rhs, int _rhs_offset, int[] ipiv, int _ipiv_offset, int[] jpiv, int _jpiv_offset, org.netlib.util.doubleW scale);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGESDD computes the singular value decomposition (SVD) of a real
   *  M-by-N matrix A, optionally computing the left and right singular
   *  vectors.  If singular vectors are desired, it uses a
   *  divide-and-conquer algorithm.
   *
   *  The SVD is written
   *
   *       A = U * SIGMA * transpose(V)
   *
   *  where SIGMA is an M-by-N matrix which is zero except for its
   *  min(m,n) diagonal elements, U is an M-by-M orthogonal matrix, and
   *  V is an N-by-N orthogonal matrix.  The diagonal elements of SIGMA
   *  are the singular values of A; they are real and non-negative, and
   *  are returned in descending order.  The first min(m,n) columns of
   *  U and V are the left and right singular vectors of A.
   *
   *  Note that the routine returns VT = V**T, not V.
   *
   *  The divide and conquer algorithm makes very mild assumptions about
   *  floating point arithmetic. It will work on machines with a guard
   *  digit in add/subtract, or on those binary machines without guard
   *  digits which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or
   *  Cray-2. It could conceivably fail on hexadecimal or decimal machines
   *  without guard digits, but we know of none.
   *
   *  Arguments
   *  =========
   *
   *  JOBZ    (input) CHARACTER*1
   *          Specifies options for computing all or part of the matrix U:
   *          = 'A':  all M columns of U and all N rows of V**T are
   *                  returned in the arrays U and VT;
   *          = 'S':  the first min(M,N) columns of U and the first
   *                  min(M,N) rows of V**T are returned in the arrays U
   *                  and VT;
   *          = 'O':  If M >= N, the first N columns of U are overwritten
   *                  on the array A and all rows of V**T are returned in
   *                  the array VT;
   *                  otherwise, all columns of U are returned in the
   *                  array U and the first M rows of V**T are overwritten
   *                  in the array A;
   *          = 'N':  no columns of U or rows of V**T are computed.
   *
   *  M       (input) INTEGER
   *          The number of rows of the input matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the input matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit,
   *          if JOBZ = 'O',  A is overwritten with the first N columns
   *                          of U (the left singular vectors, stored
   *                          columnwise) if M >= N;
   *                          A is overwritten with the first M rows
   *                          of V**T (the right singular vectors, stored
   *                          rowwise) otherwise.
   *          if JOBZ .ne. 'O', the contents of A are destroyed.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  S       (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The singular values of A, sorted so that S(i) >= S(i+1).
   *
   *  U       (output) DOUBLE PRECISION array, dimension (LDU,UCOL)
   *          UCOL = M if JOBZ = 'A' or JOBZ = 'O' and M < N;
   *          UCOL = min(M,N) if JOBZ = 'S'.
   *          If JOBZ = 'A' or JOBZ = 'O' and M < N, U contains the M-by-M
   *          orthogonal matrix U;
   *          if JOBZ = 'S', U contains the first min(M,N) columns of U
   *          (the left singular vectors, stored columnwise);
   *          if JOBZ = 'O' and M >= N, or JOBZ = 'N', U is not referenced.
   *
   *  LDU     (input) INTEGER
   *          The leading dimension of the array U.  LDU >= 1; if
   *          JOBZ = 'S' or 'A' or JOBZ = 'O' and M < N, LDU >= M.
   *
   *  VT      (output) DOUBLE PRECISION array, dimension (LDVT,N)
   *          If JOBZ = 'A' or JOBZ = 'O' and M >= N, VT contains the
   *          N-by-N orthogonal matrix V**T;
   *          if JOBZ = 'S', VT contains the first min(M,N) rows of
   *          V**T (the right singular vectors, stored rowwise);
   *          if JOBZ = 'O' and M < N, or JOBZ = 'N', VT is not referenced.
   *
   *  LDVT    (input) INTEGER
   *          The leading dimension of the array VT.  LDVT >= 1; if
   *          JOBZ = 'A' or JOBZ = 'O' and M >= N, LDVT >= N;
   *          if JOBZ = 'S', LDVT >= min(M,N).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK;
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK. LWORK >= 1.
   *          If JOBZ = 'N',
   *            LWORK >= 3*min(M,N) + max(max(M,N),7*min(M,N)).
   *          If JOBZ = 'O',
   *            LWORK >= 3*min(M,N)*min(M,N) + 
   *                     max(max(M,N),5*min(M,N)*min(M,N)+4*min(M,N)).
   *          If JOBZ = 'S' or 'A'
   *            LWORK >= 3*min(M,N)*min(M,N) +
   *                     max(max(M,N),4*min(M,N)*min(M,N)+4*min(M,N)).
   *          For good performance, LWORK should generally be larger.
   *          If LWORK = -1 but other input arguments are legal, WORK(1)
   *          returns the optimal LWORK.
   *
   *  IWORK   (workspace) INTEGER array, dimension (8*min(M,N))
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  DBDSDC did not converge, updating process failed.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Ming Gu and Huan Ren, Computer Science Division, University of
   *     California at Berkeley, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobz
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param s
   * @param u
   * @param ldu
   * @param vt
   * @param ldvt
   * @param work
   * @param lwork
   * @param iwork
   * @param info
   * 
   */
  abstract public void dgesdd(java.lang.String jobz, int m, int n, double[] a, int lda, double[] s, double[] u, int ldu, double[] vt, int ldvt, double[] work, int lwork, int[] iwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGESDD computes the singular value decomposition (SVD) of a real
   *  M-by-N matrix A, optionally computing the left and right singular
   *  vectors.  If singular vectors are desired, it uses a
   *  divide-and-conquer algorithm.
   *
   *  The SVD is written
   *
   *       A = U * SIGMA * transpose(V)
   *
   *  where SIGMA is an M-by-N matrix which is zero except for its
   *  min(m,n) diagonal elements, U is an M-by-M orthogonal matrix, and
   *  V is an N-by-N orthogonal matrix.  The diagonal elements of SIGMA
   *  are the singular values of A; they are real and non-negative, and
   *  are returned in descending order.  The first min(m,n) columns of
   *  U and V are the left and right singular vectors of A.
   *
   *  Note that the routine returns VT = V**T, not V.
   *
   *  The divide and conquer algorithm makes very mild assumptions about
   *  floating point arithmetic. It will work on machines with a guard
   *  digit in add/subtract, or on those binary machines without guard
   *  digits which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or
   *  Cray-2. It could conceivably fail on hexadecimal or decimal machines
   *  without guard digits, but we know of none.
   *
   *  Arguments
   *  =========
   *
   *  JOBZ    (input) CHARACTER*1
   *          Specifies options for computing all or part of the matrix U:
   *          = 'A':  all M columns of U and all N rows of V**T are
   *                  returned in the arrays U and VT;
   *          = 'S':  the first min(M,N) columns of U and the first
   *                  min(M,N) rows of V**T are returned in the arrays U
   *                  and VT;
   *          = 'O':  If M >= N, the first N columns of U are overwritten
   *                  on the array A and all rows of V**T are returned in
   *                  the array VT;
   *                  otherwise, all columns of U are returned in the
   *                  array U and the first M rows of V**T are overwritten
   *                  in the array A;
   *          = 'N':  no columns of U or rows of V**T are computed.
   *
   *  M       (input) INTEGER
   *          The number of rows of the input matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the input matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit,
   *          if JOBZ = 'O',  A is overwritten with the first N columns
   *                          of U (the left singular vectors, stored
   *                          columnwise) if M >= N;
   *                          A is overwritten with the first M rows
   *                          of V**T (the right singular vectors, stored
   *                          rowwise) otherwise.
   *          if JOBZ .ne. 'O', the contents of A are destroyed.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  S       (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The singular values of A, sorted so that S(i) >= S(i+1).
   *
   *  U       (output) DOUBLE PRECISION array, dimension (LDU,UCOL)
   *          UCOL = M if JOBZ = 'A' or JOBZ = 'O' and M < N;
   *          UCOL = min(M,N) if JOBZ = 'S'.
   *          If JOBZ = 'A' or JOBZ = 'O' and M < N, U contains the M-by-M
   *          orthogonal matrix U;
   *          if JOBZ = 'S', U contains the first min(M,N) columns of U
   *          (the left singular vectors, stored columnwise);
   *          if JOBZ = 'O' and M >= N, or JOBZ = 'N', U is not referenced.
   *
   *  LDU     (input) INTEGER
   *          The leading dimension of the array U.  LDU >= 1; if
   *          JOBZ = 'S' or 'A' or JOBZ = 'O' and M < N, LDU >= M.
   *
   *  VT      (output) DOUBLE PRECISION array, dimension (LDVT,N)
   *          If JOBZ = 'A' or JOBZ = 'O' and M >= N, VT contains the
   *          N-by-N orthogonal matrix V**T;
   *          if JOBZ = 'S', VT contains the first min(M,N) rows of
   *          V**T (the right singular vectors, stored rowwise);
   *          if JOBZ = 'O' and M < N, or JOBZ = 'N', VT is not referenced.
   *
   *  LDVT    (input) INTEGER
   *          The leading dimension of the array VT.  LDVT >= 1; if
   *          JOBZ = 'A' or JOBZ = 'O' and M >= N, LDVT >= N;
   *          if JOBZ = 'S', LDVT >= min(M,N).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK;
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK. LWORK >= 1.
   *          If JOBZ = 'N',
   *            LWORK >= 3*min(M,N) + max(max(M,N),7*min(M,N)).
   *          If JOBZ = 'O',
   *            LWORK >= 3*min(M,N)*min(M,N) + 
   *                     max(max(M,N),5*min(M,N)*min(M,N)+4*min(M,N)).
   *          If JOBZ = 'S' or 'A'
   *            LWORK >= 3*min(M,N)*min(M,N) +
   *                     max(max(M,N),4*min(M,N)*min(M,N)+4*min(M,N)).
   *          For good performance, LWORK should generally be larger.
   *          If LWORK = -1 but other input arguments are legal, WORK(1)
   *          returns the optimal LWORK.
   *
   *  IWORK   (workspace) INTEGER array, dimension (8*min(M,N))
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  DBDSDC did not converge, updating process failed.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Ming Gu and Huan Ren, Computer Science Division, University of
   *     California at Berkeley, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobz
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param s
   * @param _s_offset
   * @param u
   * @param _u_offset
   * @param ldu
   * @param vt
   * @param _vt_offset
   * @param ldvt
   * @param work
   * @param _work_offset
   * @param lwork
   * @param iwork
   * @param _iwork_offset
   * @param info
   * 
   */
  abstract public void dgesdd(java.lang.String jobz, int m, int n, double[] a, int _a_offset, int lda, double[] s, int _s_offset, double[] u, int _u_offset, int ldu, double[] vt, int _vt_offset, int ldvt, double[] work, int _work_offset, int lwork, int[] iwork, int _iwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGESV computes the solution to a real system of linear equations
   *     A * X = B,
   *  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.
   *
   *  The LU decomposition with partial pivoting and row interchanges is
   *  used to factor A as
   *     A = P * L * U,
   *  where P is a permutation matrix, L is unit lower triangular, and U is
   *  upper triangular.  The factored form of A is then used to solve the
   *  system of equations A * X = B.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The number of linear equations, i.e., the order of the
   *          matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrix B.  NRHS >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the N-by-N coefficient matrix A.
   *          On exit, the factors L and U from the factorization
   *          A = P*L*U; the unit diagonal elements of L are not stored.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  IPIV    (output) INTEGER array, dimension (N)
   *          The pivot indices that define the permutation matrix P;
   *          row i of the matrix was interchanged with row IPIV(i).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the N-by-NRHS matrix of right hand side matrix B.
   *          On exit, if INFO = 0, the N-by-NRHS solution matrix X.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO = i, U(i,i) is exactly zero.  The factorization
   *                has been completed, but the factor U is exactly
   *                singular, so the solution could not be computed.
   *
   *  =====================================================================
   *
   *     .. External Subroutines ..
   * </code></pre>
   *
   * @param n
   * @param nrhs
   * @param a
   * @param lda
   * @param ipiv
   * @param b
   * @param ldb
   * @param info
   * 
   */
  abstract public void dgesv(int n, int nrhs, double[] a, int lda, int[] ipiv, double[] b, int ldb, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGESV computes the solution to a real system of linear equations
   *     A * X = B,
   *  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.
   *
   *  The LU decomposition with partial pivoting and row interchanges is
   *  used to factor A as
   *     A = P * L * U,
   *  where P is a permutation matrix, L is unit lower triangular, and U is
   *  upper triangular.  The factored form of A is then used to solve the
   *  system of equations A * X = B.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The number of linear equations, i.e., the order of the
   *          matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrix B.  NRHS >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the N-by-N coefficient matrix A.
   *          On exit, the factors L and U from the factorization
   *          A = P*L*U; the unit diagonal elements of L are not stored.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  IPIV    (output) INTEGER array, dimension (N)
   *          The pivot indices that define the permutation matrix P;
   *          row i of the matrix was interchanged with row IPIV(i).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the N-by-NRHS matrix of right hand side matrix B.
   *          On exit, if INFO = 0, the N-by-NRHS solution matrix X.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO = i, U(i,i) is exactly zero.  The factorization
   *                has been completed, but the factor U is exactly
   *                singular, so the solution could not be computed.
   *
   *  =====================================================================
   *
   *     .. External Subroutines ..
   * </code></pre>
   *
   * @param n
   * @param nrhs
   * @param a
   * @param _a_offset
   * @param lda
   * @param ipiv
   * @param _ipiv_offset
   * @param b
   * @param _b_offset
   * @param ldb
   * @param info
   * 
   */
  abstract public void dgesv(int n, int nrhs, double[] a, int _a_offset, int lda, int[] ipiv, int _ipiv_offset, double[] b, int _b_offset, int ldb, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGESVD computes the singular value decomposition (SVD) of a real
   *  M-by-N matrix A, optionally computing the left and/or right singular
   *  vectors. The SVD is written
   *
   *       A = U * SIGMA * transpose(V)
   *
   *  where SIGMA is an M-by-N matrix which is zero except for its
   *  min(m,n) diagonal elements, U is an M-by-M orthogonal matrix, and
   *  V is an N-by-N orthogonal matrix.  The diagonal elements of SIGMA
   *  are the singular values of A; they are real and non-negative, and
   *  are returned in descending order.  The first min(m,n) columns of
   *  U and V are the left and right singular vectors of A.
   *
   *  Note that the routine returns V**T, not V.
   *
   *  Arguments
   *  =========
   *
   *  JOBU    (input) CHARACTER*1
   *          Specifies options for computing all or part of the matrix U:
   *          = 'A':  all M columns of U are returned in array U:
   *          = 'S':  the first min(m,n) columns of U (the left singular
   *                  vectors) are returned in the array U;
   *          = 'O':  the first min(m,n) columns of U (the left singular
   *                  vectors) are overwritten on the array A;
   *          = 'N':  no columns of U (no left singular vectors) are
   *                  computed.
   *
   *  JOBVT   (input) CHARACTER*1
   *          Specifies options for computing all or part of the matrix
   *          V**T:
   *          = 'A':  all N rows of V**T are returned in the array VT;
   *          = 'S':  the first min(m,n) rows of V**T (the right singular
   *                  vectors) are returned in the array VT;
   *          = 'O':  the first min(m,n) rows of V**T (the right singular
   *                  vectors) are overwritten on the array A;
   *          = 'N':  no rows of V**T (no right singular vectors) are
   *                  computed.
   *
   *          JOBVT and JOBU cannot both be 'O'.
   *
   *  M       (input) INTEGER
   *          The number of rows of the input matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the input matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit,
   *          if JOBU = 'O',  A is overwritten with the first min(m,n)
   *                          columns of U (the left singular vectors,
   *                          stored columnwise);
   *          if JOBVT = 'O', A is overwritten with the first min(m,n)
   *                          rows of V**T (the right singular vectors,
   *                          stored rowwise);
   *          if JOBU .ne. 'O' and JOBVT .ne. 'O', the contents of A
   *                          are destroyed.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  S       (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The singular values of A, sorted so that S(i) >= S(i+1).
   *
   *  U       (output) DOUBLE PRECISION array, dimension (LDU,UCOL)
   *          (LDU,M) if JOBU = 'A' or (LDU,min(M,N)) if JOBU = 'S'.
   *          If JOBU = 'A', U contains the M-by-M orthogonal matrix U;
   *          if JOBU = 'S', U contains the first min(m,n) columns of U
   *          (the left singular vectors, stored columnwise);
   *          if JOBU = 'N' or 'O', U is not referenced.
   *
   *  LDU     (input) INTEGER
   *          The leading dimension of the array U.  LDU >= 1; if
   *          JOBU = 'S' or 'A', LDU >= M.
   *
   *  VT      (output) DOUBLE PRECISION array, dimension (LDVT,N)
   *          If JOBVT = 'A', VT contains the N-by-N orthogonal matrix
   *          V**T;
   *          if JOBVT = 'S', VT contains the first min(m,n) rows of
   *          V**T (the right singular vectors, stored rowwise);
   *          if JOBVT = 'N' or 'O', VT is not referenced.
   *
   *  LDVT    (input) INTEGER
   *          The leading dimension of the array VT.  LDVT >= 1; if
   *          JOBVT = 'A', LDVT >= N; if JOBVT = 'S', LDVT >= min(M,N).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK;
   *          if INFO > 0, WORK(2:MIN(M,N)) contains the unconverged
   *          superdiagonal elements of an upper bidiagonal matrix B
   *          whose diagonal is in S (not necessarily sorted). B
   *          satisfies A = U * B * VT, so it has the same singular values
   *          as A, and singular vectors related by U and VT.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.
   *          LWORK >= MAX(1,3*MIN(M,N)+MAX(M,N),5*MIN(M,N)).
   *          For good performance, LWORK should generally be larger.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  if DBDSQR did not converge, INFO specifies how many
   *                superdiagonals of an intermediate bidiagonal form B
   *                did not converge to zero. See the description of WORK
   *                above for details.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobu
   * @param jobvt
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param s
   * @param u
   * @param ldu
   * @param vt
   * @param ldvt
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgesvd(java.lang.String jobu, java.lang.String jobvt, int m, int n, double[] a, int lda, double[] s, double[] u, int ldu, double[] vt, int ldvt, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGESVD computes the singular value decomposition (SVD) of a real
   *  M-by-N matrix A, optionally computing the left and/or right singular
   *  vectors. The SVD is written
   *
   *       A = U * SIGMA * transpose(V)
   *
   *  where SIGMA is an M-by-N matrix which is zero except for its
   *  min(m,n) diagonal elements, U is an M-by-M orthogonal matrix, and
   *  V is an N-by-N orthogonal matrix.  The diagonal elements of SIGMA
   *  are the singular values of A; they are real and non-negative, and
   *  are returned in descending order.  The first min(m,n) columns of
   *  U and V are the left and right singular vectors of A.
   *
   *  Note that the routine returns V**T, not V.
   *
   *  Arguments
   *  =========
   *
   *  JOBU    (input) CHARACTER*1
   *          Specifies options for computing all or part of the matrix U:
   *          = 'A':  all M columns of U are returned in array U:
   *          = 'S':  the first min(m,n) columns of U (the left singular
   *                  vectors) are returned in the array U;
   *          = 'O':  the first min(m,n) columns of U (the left singular
   *                  vectors) are overwritten on the array A;
   *          = 'N':  no columns of U (no left singular vectors) are
   *                  computed.
   *
   *  JOBVT   (input) CHARACTER*1
   *          Specifies options for computing all or part of the matrix
   *          V**T:
   *          = 'A':  all N rows of V**T are returned in the array VT;
   *          = 'S':  the first min(m,n) rows of V**T (the right singular
   *                  vectors) are returned in the array VT;
   *          = 'O':  the first min(m,n) rows of V**T (the right singular
   *                  vectors) are overwritten on the array A;
   *          = 'N':  no rows of V**T (no right singular vectors) are
   *                  computed.
   *
   *          JOBVT and JOBU cannot both be 'O'.
   *
   *  M       (input) INTEGER
   *          The number of rows of the input matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the input matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit,
   *          if JOBU = 'O',  A is overwritten with the first min(m,n)
   *                          columns of U (the left singular vectors,
   *                          stored columnwise);
   *          if JOBVT = 'O', A is overwritten with the first min(m,n)
   *                          rows of V**T (the right singular vectors,
   *                          stored rowwise);
   *          if JOBU .ne. 'O' and JOBVT .ne. 'O', the contents of A
   *                          are destroyed.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  S       (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The singular values of A, sorted so that S(i) >= S(i+1).
   *
   *  U       (output) DOUBLE PRECISION array, dimension (LDU,UCOL)
   *          (LDU,M) if JOBU = 'A' or (LDU,min(M,N)) if JOBU = 'S'.
   *          If JOBU = 'A', U contains the M-by-M orthogonal matrix U;
   *          if JOBU = 'S', U contains the first min(m,n) columns of U
   *          (the left singular vectors, stored columnwise);
   *          if JOBU = 'N' or 'O', U is not referenced.
   *
   *  LDU     (input) INTEGER
   *          The leading dimension of the array U.  LDU >= 1; if
   *          JOBU = 'S' or 'A', LDU >= M.
   *
   *  VT      (output) DOUBLE PRECISION array, dimension (LDVT,N)
   *          If JOBVT = 'A', VT contains the N-by-N orthogonal matrix
   *          V**T;
   *          if JOBVT = 'S', VT contains the first min(m,n) rows of
   *          V**T (the right singular vectors, stored rowwise);
   *          if JOBVT = 'N' or 'O', VT is not referenced.
   *
   *  LDVT    (input) INTEGER
   *          The leading dimension of the array VT.  LDVT >= 1; if
   *          JOBVT = 'A', LDVT >= N; if JOBVT = 'S', LDVT >= min(M,N).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK;
   *          if INFO > 0, WORK(2:MIN(M,N)) contains the unconverged
   *          superdiagonal elements of an upper bidiagonal matrix B
   *          whose diagonal is in S (not necessarily sorted). B
   *          satisfies A = U * B * VT, so it has the same singular values
   *          as A, and singular vectors related by U and VT.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.
   *          LWORK >= MAX(1,3*MIN(M,N)+MAX(M,N),5*MIN(M,N)).
   *          For good performance, LWORK should generally be larger.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  if DBDSQR did not converge, INFO specifies how many
   *                superdiagonals of an intermediate bidiagonal form B
   *                did not converge to zero. See the description of WORK
   *                above for details.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobu
   * @param jobvt
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param s
   * @param _s_offset
   * @param u
   * @param _u_offset
   * @param ldu
   * @param vt
   * @param _vt_offset
   * @param ldvt
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgesvd(java.lang.String jobu, java.lang.String jobvt, int m, int n, double[] a, int _a_offset, int lda, double[] s, int _s_offset, double[] u, int _u_offset, int ldu, double[] vt, int _vt_offset, int ldvt, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGESVX uses the LU factorization to compute the solution to a real
   *  system of linear equations
   *     A * X = B,
   *  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.
   *
   *  Error bounds on the solution and a condition estimate are also
   *  provided.
   *
   *  Description
   *  ===========
   *
   *  The following steps are performed:
   *
   *  1. If FACT = 'E', real scaling factors are computed to equilibrate
   *     the system:
   *        TRANS = 'N':  diag(R)*A*diag(C)     *inv(diag(C))*X = diag(R)*B
   *        TRANS = 'T': (diag(R)*A*diag(C))**T *inv(diag(R))*X = diag(C)*B
   *        TRANS = 'C': (diag(R)*A*diag(C))**H *inv(diag(R))*X = diag(C)*B
   *     Whether or not the system will be equilibrated depends on the
   *     scaling of the matrix A, but if equilibration is used, A is
   *     overwritten by diag(R)*A*diag(C) and B by diag(R)*B (if TRANS='N')
   *     or diag(C)*B (if TRANS = 'T' or 'C').
   *
   *  2. If FACT = 'N' or 'E', the LU decomposition is used to factor the
   *     matrix A (after equilibration if FACT = 'E') as
   *        A = P * L * U,
   *     where P is a permutation matrix, L is a unit lower triangular
   *     matrix, and U is upper triangular.
   *
   *  3. If some U(i,i)=0, so that U is exactly singular, then the routine
   *     returns with INFO = i. Otherwise, the factored form of A is used
   *     to estimate the condition number of the matrix A.  If the
   *     reciprocal of the condition number is less than machine precision,
   *     INFO = N+1 is returned as a warning, but the routine still goes on
   *     to solve for X and compute error bounds as described below.
   *
   *  4. The system of equations is solved for X using the factored form
   *     of A.
   *
   *  5. Iterative refinement is applied to improve the computed solution
   *     matrix and calculate error bounds and backward error estimates
   *     for it.
   *
   *  6. If equilibration was used, the matrix X is premultiplied by
   *     diag(C) (if TRANS = 'N') or diag(R) (if TRANS = 'T' or 'C') so
   *     that it solves the original system before equilibration.
   *
   *  Arguments
   *  =========
   *
   *  FACT    (input) CHARACTER*1
   *          Specifies whether or not the factored form of the matrix A is
   *          supplied on entry, and if not, whether the matrix A should be
   *          equilibrated before it is factored.
   *          = 'F':  On entry, AF and IPIV contain the factored form of A.
   *                  If EQUED is not 'N', the matrix A has been
   *                  equilibrated with scaling factors given by R and C.
   *                  A, AF, and IPIV are not modified.
   *          = 'N':  The matrix A will be copied to AF and factored.
   *          = 'E':  The matrix A will be equilibrated if necessary, then
   *                  copied to AF and factored.
   *
   *  TRANS   (input) CHARACTER*1
   *          Specifies the form of the system of equations:
   *          = 'N':  A * X = B     (No transpose)
   *          = 'T':  A**T * X = B  (Transpose)
   *          = 'C':  A**H * X = B  (Transpose)
   *
   *  N       (input) INTEGER
   *          The number of linear equations, i.e., the order of the
   *          matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrices B and X.  NRHS >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the N-by-N matrix A.  If FACT = 'F' and EQUED is
   *          not 'N', then A must have been equilibrated by the scaling
   *          factors in R and/or C.  A is not modified if FACT = 'F' or
   *          'N', or if FACT = 'E' and EQUED = 'N' on exit.
   *
   *          On exit, if EQUED .ne. 'N', A is scaled as follows:
   *          EQUED = 'R':  A := diag(R) * A
   *          EQUED = 'C':  A := A * diag(C)
   *          EQUED = 'B':  A := diag(R) * A * diag(C).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  AF      (input or output) DOUBLE PRECISION array, dimension (LDAF,N)
   *          If FACT = 'F', then AF is an input argument and on entry
   *          contains the factors L and U from the factorization
   *          A = P*L*U as computed by DGETRF.  If EQUED .ne. 'N', then
   *          AF is the factored form of the equilibrated matrix A.
   *
   *          If FACT = 'N', then AF is an output argument and on exit
   *          returns the factors L and U from the factorization A = P*L*U
   *          of the original matrix A.
   *
   *          If FACT = 'E', then AF is an output argument and on exit
   *          returns the factors L and U from the factorization A = P*L*U
   *          of the equilibrated matrix A (see the description of A for
   *          the form of the equilibrated matrix).
   *
   *  LDAF    (input) INTEGER
   *          The leading dimension of the array AF.  LDAF >= max(1,N).
   *
   *  IPIV    (input or output) INTEGER array, dimension (N)
   *          If FACT = 'F', then IPIV is an input argument and on entry
   *          contains the pivot indices from the factorization A = P*L*U
   *          as computed by DGETRF; row i of the matrix was interchanged
   *          with row IPIV(i).
   *
   *          If FACT = 'N', then IPIV is an output argument and on exit
   *          contains the pivot indices from the factorization A = P*L*U
   *          of the original matrix A.
   *
   *          If FACT = 'E', then IPIV is an output argument and on exit
   *          contains the pivot indices from the factorization A = P*L*U
   *          of the equilibrated matrix A.
   *
   *  EQUED   (input or output) CHARACTER*1
   *          Specifies the form of equilibration that was done.
   *          = 'N':  No equilibration (always true if FACT = 'N').
   *          = 'R':  Row equilibration, i.e., A has been premultiplied by
   *                  diag(R).
   *          = 'C':  Column equilibration, i.e., A has been postmultiplied
   *                  by diag(C).
   *          = 'B':  Both row and column equilibration, i.e., A has been
   *                  replaced by diag(R) * A * diag(C).
   *          EQUED is an input argument if FACT = 'F'; otherwise, it is an
   *          output argument.
   *
   *  R       (input or output) DOUBLE PRECISION array, dimension (N)
   *          The row scale factors for A.  If EQUED = 'R' or 'B', A is
   *          multiplied on the left by diag(R); if EQUED = 'N' or 'C', R
   *          is not accessed.  R is an input argument if FACT = 'F';
   *          otherwise, R is an output argument.  If FACT = 'F' and
   *          EQUED = 'R' or 'B', each element of R must be positive.
   *
   *  C       (input or output) DOUBLE PRECISION array, dimension (N)
   *          The column scale factors for A.  If EQUED = 'C' or 'B', A is
   *          multiplied on the right by diag(C); if EQUED = 'N' or 'R', C
   *          is not accessed.  C is an input argument if FACT = 'F';
   *          otherwise, C is an output argument.  If FACT = 'F' and
   *          EQUED = 'C' or 'B', each element of C must be positive.
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the N-by-NRHS right hand side matrix B.
   *          On exit,
   *          if EQUED = 'N', B is not modified;
   *          if TRANS = 'N' and EQUED = 'R' or 'B', B is overwritten by
   *          diag(R)*B;
   *          if TRANS = 'T' or 'C' and EQUED = 'C' or 'B', B is
   *          overwritten by diag(C)*B.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  X       (output) DOUBLE PRECISION array, dimension (LDX,NRHS)
   *          If INFO = 0 or INFO = N+1, the N-by-NRHS solution matrix X
   *          to the original system of equations.  Note that A and B are
   *          modified on exit if EQUED .ne. 'N', and the solution to the
   *          equilibrated system is inv(diag(C))*X if TRANS = 'N' and
   *          EQUED = 'C' or 'B', or inv(diag(R))*X if TRANS = 'T' or 'C'
   *          and EQUED = 'R' or 'B'.
   *
   *  LDX     (input) INTEGER
   *          The leading dimension of the array X.  LDX >= max(1,N).
   *
   *  RCOND   (output) DOUBLE PRECISION
   *          The estimate of the reciprocal condition number of the matrix
   *          A after equilibration (if done).  If RCOND is less than the
   *          machine precision (in particular, if RCOND = 0), the matrix
   *          is singular to working precision.  This condition is
   *          indicated by a return code of INFO > 0.
   *
   *  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The estimated forward error bound for each solution vector
   *          X(j) (the j-th column of the solution matrix X).
   *          If XTRUE is the true solution corresponding to X(j), FERR(j)
   *          is an estimated upper bound for the magnitude of the largest
   *          element in (X(j) - XTRUE) divided by the magnitude of the
   *          largest element in X(j).  The estimate is as reliable as
   *          the estimate for RCOND, and is almost always a slight
   *          overestimate of the true error.
   *
   *  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The componentwise relative backward error of each solution
   *          vector X(j) (i.e., the smallest relative change in
   *          any element of A or B that makes X(j) an exact solution).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (4*N)
   *          On exit, WORK(1) contains the reciprocal pivot growth
   *          factor norm(A)/norm(U). The "max absolute element" norm is
   *          used. If WORK(1) is much less than 1, then the stability
   *          of the LU factorization of the (equilibrated) matrix A
   *          could be poor. This also means that the solution X, condition
   *          estimator RCOND, and forward error bound FERR could be
   *          unreliable. If factorization fails with 0<INFO<=N, then
   *          WORK(1) contains the reciprocal pivot growth factor for the
   *          leading INFO columns of A.
   *
   *  IWORK   (workspace) INTEGER array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO = i, and i is
   *                <= N:  U(i,i) is exactly zero.  The factorization has
   *                       been completed, but the factor U is exactly
   *                       singular, so the solution and error bounds
   *                       could not be computed. RCOND = 0 is returned.
   *                = N+1: U is nonsingular, but RCOND is less than machine
   *                       precision, meaning that the matrix is singular
   *                       to working precision.  Nevertheless, the
   *                       solution and error bounds are computed because
   *                       there are a number of situations where the
   *                       computed solution can be more accurate than the
   *                       value of RCOND would suggest.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param fact
   * @param trans
   * @param n
   * @param nrhs
   * @param a
   * @param lda
   * @param af
   * @param ldaf
   * @param ipiv
   * @param equed
   * @param r
   * @param c
   * @param b
   * @param ldb
   * @param x
   * @param ldx
   * @param rcond
   * @param ferr
   * @param berr
   * @param work
   * @param iwork
   * @param info
   * 
   */
  abstract public void dgesvx(java.lang.String fact, java.lang.String trans, int n, int nrhs, double[] a, int lda, double[] af, int ldaf, int[] ipiv, org.netlib.util.StringW equed, double[] r, double[] c, double[] b, int ldb, double[] x, int ldx, org.netlib.util.doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGESVX uses the LU factorization to compute the solution to a real
   *  system of linear equations
   *     A * X = B,
   *  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.
   *
   *  Error bounds on the solution and a condition estimate are also
   *  provided.
   *
   *  Description
   *  ===========
   *
   *  The following steps are performed:
   *
   *  1. If FACT = 'E', real scaling factors are computed to equilibrate
   *     the system:
   *        TRANS = 'N':  diag(R)*A*diag(C)     *inv(diag(C))*X = diag(R)*B
   *        TRANS = 'T': (diag(R)*A*diag(C))**T *inv(diag(R))*X = diag(C)*B
   *        TRANS = 'C': (diag(R)*A*diag(C))**H *inv(diag(R))*X = diag(C)*B
   *     Whether or not the system will be equilibrated depends on the
   *     scaling of the matrix A, but if equilibration is used, A is
   *     overwritten by diag(R)*A*diag(C) and B by diag(R)*B (if TRANS='N')
   *     or diag(C)*B (if TRANS = 'T' or 'C').
   *
   *  2. If FACT = 'N' or 'E', the LU decomposition is used to factor the
   *     matrix A (after equilibration if FACT = 'E') as
   *        A = P * L * U,
   *     where P is a permutation matrix, L is a unit lower triangular
   *     matrix, and U is upper triangular.
   *
   *  3. If some U(i,i)=0, so that U is exactly singular, then the routine
   *     returns with INFO = i. Otherwise, the factored form of A is used
   *     to estimate the condition number of the matrix A.  If the
   *     reciprocal of the condition number is less than machine precision,
   *     INFO = N+1 is returned as a warning, but the routine still goes on
   *     to solve for X and compute error bounds as described below.
   *
   *  4. The system of equations is solved for X using the factored form
   *     of A.
   *
   *  5. Iterative refinement is applied to improve the computed solution
   *     matrix and calculate error bounds and backward error estimates
   *     for it.
   *
   *  6. If equilibration was used, the matrix X is premultiplied by
   *     diag(C) (if TRANS = 'N') or diag(R) (if TRANS = 'T' or 'C') so
   *     that it solves the original system before equilibration.
   *
   *  Arguments
   *  =========
   *
   *  FACT    (input) CHARACTER*1
   *          Specifies whether or not the factored form of the matrix A is
   *          supplied on entry, and if not, whether the matrix A should be
   *          equilibrated before it is factored.
   *          = 'F':  On entry, AF and IPIV contain the factored form of A.
   *                  If EQUED is not 'N', the matrix A has been
   *                  equilibrated with scaling factors given by R and C.
   *                  A, AF, and IPIV are not modified.
   *          = 'N':  The matrix A will be copied to AF and factored.
   *          = 'E':  The matrix A will be equilibrated if necessary, then
   *                  copied to AF and factored.
   *
   *  TRANS   (input) CHARACTER*1
   *          Specifies the form of the system of equations:
   *          = 'N':  A * X = B     (No transpose)
   *          = 'T':  A**T * X = B  (Transpose)
   *          = 'C':  A**H * X = B  (Transpose)
   *
   *  N       (input) INTEGER
   *          The number of linear equations, i.e., the order of the
   *          matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrices B and X.  NRHS >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the N-by-N matrix A.  If FACT = 'F' and EQUED is
   *          not 'N', then A must have been equilibrated by the scaling
   *          factors in R and/or C.  A is not modified if FACT = 'F' or
   *          'N', or if FACT = 'E' and EQUED = 'N' on exit.
   *
   *          On exit, if EQUED .ne. 'N', A is scaled as follows:
   *          EQUED = 'R':  A := diag(R) * A
   *          EQUED = 'C':  A := A * diag(C)
   *          EQUED = 'B':  A := diag(R) * A * diag(C).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  AF      (input or output) DOUBLE PRECISION array, dimension (LDAF,N)
   *          If FACT = 'F', then AF is an input argument and on entry
   *          contains the factors L and U from the factorization
   *          A = P*L*U as computed by DGETRF.  If EQUED .ne. 'N', then
   *          AF is the factored form of the equilibrated matrix A.
   *
   *          If FACT = 'N', then AF is an output argument and on exit
   *          returns the factors L and U from the factorization A = P*L*U
   *          of the original matrix A.
   *
   *          If FACT = 'E', then AF is an output argument and on exit
   *          returns the factors L and U from the factorization A = P*L*U
   *          of the equilibrated matrix A (see the description of A for
   *          the form of the equilibrated matrix).
   *
   *  LDAF    (input) INTEGER
   *          The leading dimension of the array AF.  LDAF >= max(1,N).
   *
   *  IPIV    (input or output) INTEGER array, dimension (N)
   *          If FACT = 'F', then IPIV is an input argument and on entry
   *          contains the pivot indices from the factorization A = P*L*U
   *          as computed by DGETRF; row i of the matrix was interchanged
   *          with row IPIV(i).
   *
   *          If FACT = 'N', then IPIV is an output argument and on exit
   *          contains the pivot indices from the factorization A = P*L*U
   *          of the original matrix A.
   *
   *          If FACT = 'E', then IPIV is an output argument and on exit
   *          contains the pivot indices from the factorization A = P*L*U
   *          of the equilibrated matrix A.
   *
   *  EQUED   (input or output) CHARACTER*1
   *          Specifies the form of equilibration that was done.
   *          = 'N':  No equilibration (always true if FACT = 'N').
   *          = 'R':  Row equilibration, i.e., A has been premultiplied by
   *                  diag(R).
   *          = 'C':  Column equilibration, i.e., A has been postmultiplied
   *                  by diag(C).
   *          = 'B':  Both row and column equilibration, i.e., A has been
   *                  replaced by diag(R) * A * diag(C).
   *          EQUED is an input argument if FACT = 'F'; otherwise, it is an
   *          output argument.
   *
   *  R       (input or output) DOUBLE PRECISION array, dimension (N)
   *          The row scale factors for A.  If EQUED = 'R' or 'B', A is
   *          multiplied on the left by diag(R); if EQUED = 'N' or 'C', R
   *          is not accessed.  R is an input argument if FACT = 'F';
   *          otherwise, R is an output argument.  If FACT = 'F' and
   *          EQUED = 'R' or 'B', each element of R must be positive.
   *
   *  C       (input or output) DOUBLE PRECISION array, dimension (N)
   *          The column scale factors for A.  If EQUED = 'C' or 'B', A is
   *          multiplied on the right by diag(C); if EQUED = 'N' or 'R', C
   *          is not accessed.  C is an input argument if FACT = 'F';
   *          otherwise, C is an output argument.  If FACT = 'F' and
   *          EQUED = 'C' or 'B', each element of C must be positive.
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the N-by-NRHS right hand side matrix B.
   *          On exit,
   *          if EQUED = 'N', B is not modified;
   *          if TRANS = 'N' and EQUED = 'R' or 'B', B is overwritten by
   *          diag(R)*B;
   *          if TRANS = 'T' or 'C' and EQUED = 'C' or 'B', B is
   *          overwritten by diag(C)*B.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  X       (output) DOUBLE PRECISION array, dimension (LDX,NRHS)
   *          If INFO = 0 or INFO = N+1, the N-by-NRHS solution matrix X
   *          to the original system of equations.  Note that A and B are
   *          modified on exit if EQUED .ne. 'N', and the solution to the
   *          equilibrated system is inv(diag(C))*X if TRANS = 'N' and
   *          EQUED = 'C' or 'B', or inv(diag(R))*X if TRANS = 'T' or 'C'
   *          and EQUED = 'R' or 'B'.
   *
   *  LDX     (input) INTEGER
   *          The leading dimension of the array X.  LDX >= max(1,N).
   *
   *  RCOND   (output) DOUBLE PRECISION
   *          The estimate of the reciprocal condition number of the matrix
   *          A after equilibration (if done).  If RCOND is less than the
   *          machine precision (in particular, if RCOND = 0), the matrix
   *          is singular to working precision.  This condition is
   *          indicated by a return code of INFO > 0.
   *
   *  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The estimated forward error bound for each solution vector
   *          X(j) (the j-th column of the solution matrix X).
   *          If XTRUE is the true solution corresponding to X(j), FERR(j)
   *          is an estimated upper bound for the magnitude of the largest
   *          element in (X(j) - XTRUE) divided by the magnitude of the
   *          largest element in X(j).  The estimate is as reliable as
   *          the estimate for RCOND, and is almost always a slight
   *          overestimate of the true error.
   *
   *  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The componentwise relative backward error of each solution
   *          vector X(j) (i.e., the smallest relative change in
   *          any element of A or B that makes X(j) an exact solution).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (4*N)
   *          On exit, WORK(1) contains the reciprocal pivot growth
   *          factor norm(A)/norm(U). The "max absolute element" norm is
   *          used. If WORK(1) is much less than 1, then the stability
   *          of the LU factorization of the (equilibrated) matrix A
   *          could be poor. This also means that the solution X, condition
   *          estimator RCOND, and forward error bound FERR could be
   *          unreliable. If factorization fails with 0<INFO<=N, then
   *          WORK(1) contains the reciprocal pivot growth factor for the
   *          leading INFO columns of A.
   *
   *  IWORK   (workspace) INTEGER array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO = i, and i is
   *                <= N:  U(i,i) is exactly zero.  The factorization has
   *                       been completed, but the factor U is exactly
   *                       singular, so the solution and error bounds
   *                       could not be computed. RCOND = 0 is returned.
   *                = N+1: U is nonsingular, but RCOND is less than machine
   *                       precision, meaning that the matrix is singular
   *                       to working precision.  Nevertheless, the
   *                       solution and error bounds are computed because
   *                       there are a number of situations where the
   *                       computed solution can be more accurate than the
   *                       value of RCOND would suggest.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param fact
   * @param trans
   * @param n
   * @param nrhs
   * @param a
   * @param _a_offset
   * @param lda
   * @param af
   * @param _af_offset
   * @param ldaf
   * @param ipiv
   * @param _ipiv_offset
   * @param equed
   * @param r
   * @param _r_offset
   * @param c
   * @param _c_offset
   * @param b
   * @param _b_offset
   * @param ldb
   * @param x
   * @param _x_offset
   * @param ldx
   * @param rcond
   * @param ferr
   * @param _ferr_offset
   * @param berr
   * @param _berr_offset
   * @param work
   * @param _work_offset
   * @param iwork
   * @param _iwork_offset
   * @param info
   * 
   */
  abstract public void dgesvx(java.lang.String fact, java.lang.String trans, int n, int nrhs, double[] a, int _a_offset, int lda, double[] af, int _af_offset, int ldaf, int[] ipiv, int _ipiv_offset, org.netlib.util.StringW equed, double[] r, int _r_offset, double[] c, int _c_offset, double[] b, int _b_offset, int ldb, double[] x, int _x_offset, int ldx, org.netlib.util.doubleW rcond, double[] ferr, int _ferr_offset, double[] berr, int _berr_offset, double[] work, int _work_offset, int[] iwork, int _iwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGETC2 computes an LU factorization with complete pivoting of the
   *  n-by-n matrix A. The factorization has the form A = P * L * U * Q,
   *  where P and Q are permutation matrices, L is lower triangular with
   *  unit diagonal elements and U is upper triangular.
   *
   *  This is the Level 2 BLAS algorithm.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The order of the matrix A. N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
   *          On entry, the n-by-n matrix A to be factored.
   *          On exit, the factors L and U from the factorization
   *          A = P*L*U*Q; the unit diagonal elements of L are not stored.
   *          If U(k, k) appears to be less than SMIN, U(k, k) is given the
   *          value of SMIN, i.e., giving a nonsingular perturbed system.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  IPIV    (output) INTEGER array, dimension(N).
   *          The pivot indices; for 1 <= i <= N, row i of the
   *          matrix has been interchanged with row IPIV(i).
   *
   *  JPIV    (output) INTEGER array, dimension(N).
   *          The pivot indices; for 1 <= j <= N, column j of the
   *          matrix has been interchanged with column JPIV(j).
   *
   *  INFO    (output) INTEGER
   *           = 0: successful exit
   *           > 0: if INFO = k, U(k, k) is likely to produce owerflow if
   *                we try to solve for x in Ax = b. So U is perturbed to
   *                avoid the overflow.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Bo Kagstrom and Peter Poromaa, Department of Computing Science,
   *     Umea University, S-901 87 Umea, Sweden.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param a
   * @param lda
   * @param ipiv
   * @param jpiv
   * @param info
   * 
   */
  abstract public void dgetc2(int n, double[] a, int lda, int[] ipiv, int[] jpiv, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGETC2 computes an LU factorization with complete pivoting of the
   *  n-by-n matrix A. The factorization has the form A = P * L * U * Q,
   *  where P and Q are permutation matrices, L is lower triangular with
   *  unit diagonal elements and U is upper triangular.
   *
   *  This is the Level 2 BLAS algorithm.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The order of the matrix A. N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
   *          On entry, the n-by-n matrix A to be factored.
   *          On exit, the factors L and U from the factorization
   *          A = P*L*U*Q; the unit diagonal elements of L are not stored.
   *          If U(k, k) appears to be less than SMIN, U(k, k) is given the
   *          value of SMIN, i.e., giving a nonsingular perturbed system.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  IPIV    (output) INTEGER array, dimension(N).
   *          The pivot indices; for 1 <= i <= N, row i of the
   *          matrix has been interchanged with row IPIV(i).
   *
   *  JPIV    (output) INTEGER array, dimension(N).
   *          The pivot indices; for 1 <= j <= N, column j of the
   *          matrix has been interchanged with column JPIV(j).
   *
   *  INFO    (output) INTEGER
   *           = 0: successful exit
   *           > 0: if INFO = k, U(k, k) is likely to produce owerflow if
   *                we try to solve for x in Ax = b. So U is perturbed to
   *                avoid the overflow.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Bo Kagstrom and Peter Poromaa, Department of Computing Science,
   *     Umea University, S-901 87 Umea, Sweden.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param ipiv
   * @param _ipiv_offset
   * @param jpiv
   * @param _jpiv_offset
   * @param info
   * 
   */
  abstract public void dgetc2(int n, double[] a, int _a_offset, int lda, int[] ipiv, int _ipiv_offset, int[] jpiv, int _jpiv_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGETF2 computes an LU factorization of a general m-by-n matrix A
   *  using partial pivoting with row interchanges.
   *
   *  The factorization has the form
   *     A = P * L * U
   *  where P is a permutation matrix, L is lower triangular with unit
   *  diagonal elements (lower trapezoidal if m > n), and U is upper
   *  triangular (upper trapezoidal if m < n).
   *
   *  This is the right-looking Level 2 BLAS version of the algorithm.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the m by n matrix to be factored.
   *          On exit, the factors L and U from the factorization
   *          A = P*L*U; the unit diagonal elements of L are not stored.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  IPIV    (output) INTEGER array, dimension (min(M,N))
   *          The pivot indices; for 1 <= i <= min(M,N), row i of the
   *          matrix was interchanged with row IPIV(i).
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -k, the k-th argument had an illegal value
   *          > 0: if INFO = k, U(k,k) is exactly zero. The factorization
   *               has been completed, but the factor U is exactly
   *               singular, and division by zero will occur if it is used
   *               to solve a system of equations.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param ipiv
   * @param info
   * 
   */
  abstract public void dgetf2(int m, int n, double[] a, int lda, int[] ipiv, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGETF2 computes an LU factorization of a general m-by-n matrix A
   *  using partial pivoting with row interchanges.
   *
   *  The factorization has the form
   *     A = P * L * U
   *  where P is a permutation matrix, L is lower triangular with unit
   *  diagonal elements (lower trapezoidal if m > n), and U is upper
   *  triangular (upper trapezoidal if m < n).
   *
   *  This is the right-looking Level 2 BLAS version of the algorithm.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the m by n matrix to be factored.
   *          On exit, the factors L and U from the factorization
   *          A = P*L*U; the unit diagonal elements of L are not stored.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  IPIV    (output) INTEGER array, dimension (min(M,N))
   *          The pivot indices; for 1 <= i <= min(M,N), row i of the
   *          matrix was interchanged with row IPIV(i).
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -k, the k-th argument had an illegal value
   *          > 0: if INFO = k, U(k,k) is exactly zero. The factorization
   *               has been completed, but the factor U is exactly
   *               singular, and division by zero will occur if it is used
   *               to solve a system of equations.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param ipiv
   * @param _ipiv_offset
   * @param info
   * 
   */
  abstract public void dgetf2(int m, int n, double[] a, int _a_offset, int lda, int[] ipiv, int _ipiv_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGETRF computes an LU factorization of a general M-by-N matrix A
   *  using partial pivoting with row interchanges.
   *
   *  The factorization has the form
   *     A = P * L * U
   *  where P is a permutation matrix, L is lower triangular with unit
   *  diagonal elements (lower trapezoidal if m > n), and U is upper
   *  triangular (upper trapezoidal if m < n).
   *
   *  This is the right-looking Level 3 BLAS version of the algorithm.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix to be factored.
   *          On exit, the factors L and U from the factorization
   *          A = P*L*U; the unit diagonal elements of L are not stored.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  IPIV    (output) INTEGER array, dimension (min(M,N))
   *          The pivot indices; for 1 <= i <= min(M,N), row i of the
   *          matrix was interchanged with row IPIV(i).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO = i, U(i,i) is exactly zero. The factorization
   *                has been completed, but the factor U is exactly
   *                singular, and division by zero will occur if it is used
   *                to solve a system of equations.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param ipiv
   * @param info
   * 
   */
  abstract public void dgetrf(int m, int n, double[] a, int lda, int[] ipiv, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGETRF computes an LU factorization of a general M-by-N matrix A
   *  using partial pivoting with row interchanges.
   *
   *  The factorization has the form
   *     A = P * L * U
   *  where P is a permutation matrix, L is lower triangular with unit
   *  diagonal elements (lower trapezoidal if m > n), and U is upper
   *  triangular (upper trapezoidal if m < n).
   *
   *  This is the right-looking Level 3 BLAS version of the algorithm.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix to be factored.
   *          On exit, the factors L and U from the factorization
   *          A = P*L*U; the unit diagonal elements of L are not stored.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  IPIV    (output) INTEGER array, dimension (min(M,N))
   *          The pivot indices; for 1 <= i <= min(M,N), row i of the
   *          matrix was interchanged with row IPIV(i).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO = i, U(i,i) is exactly zero. The factorization
   *                has been completed, but the factor U is exactly
   *                singular, and division by zero will occur if it is used
   *                to solve a system of equations.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param ipiv
   * @param _ipiv_offset
   * @param info
   * 
   */
  abstract public void dgetrf(int m, int n, double[] a, int _a_offset, int lda, int[] ipiv, int _ipiv_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGETRI computes the inverse of a matrix using the LU factorization
   *  computed by DGETRF.
   *
   *  This method inverts U and then computes inv(A) by solving the system
   *  inv(A)*L = inv(U) for inv(A).
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the factors L and U from the factorization
   *          A = P*L*U as computed by DGETRF.
   *          On exit, if INFO = 0, the inverse of the original matrix A.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  IPIV    (input) INTEGER array, dimension (N)
   *          The pivot indices from DGETRF; for 1<=i<=N, row i of the
   *          matrix was interchanged with row IPIV(i).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO=0, then WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,N).
   *          For optimal performance LWORK >= N*NB, where NB is
   *          the optimal blocksize returned by ILAENV.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO = i, U(i,i) is exactly zero; the matrix is
   *                singular and its inverse could not be computed.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param a
   * @param lda
   * @param ipiv
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgetri(int n, double[] a, int lda, int[] ipiv, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGETRI computes the inverse of a matrix using the LU factorization
   *  computed by DGETRF.
   *
   *  This method inverts U and then computes inv(A) by solving the system
   *  inv(A)*L = inv(U) for inv(A).
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the factors L and U from the factorization
   *          A = P*L*U as computed by DGETRF.
   *          On exit, if INFO = 0, the inverse of the original matrix A.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  IPIV    (input) INTEGER array, dimension (N)
   *          The pivot indices from DGETRF; for 1<=i<=N, row i of the
   *          matrix was interchanged with row IPIV(i).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO=0, then WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,N).
   *          For optimal performance LWORK >= N*NB, where NB is
   *          the optimal blocksize returned by ILAENV.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO = i, U(i,i) is exactly zero; the matrix is
   *                singular and its inverse could not be computed.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param ipiv
   * @param _ipiv_offset
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgetri(int n, double[] a, int _a_offset, int lda, int[] ipiv, int _ipiv_offset, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGETRS solves a system of linear equations
   *     A * X = B  or  A' * X = B
   *  with a general N-by-N matrix A using the LU factorization computed
   *  by DGETRF.
   *
   *  Arguments
   *  =========
   *
   *  TRANS   (input) CHARACTER*1
   *          Specifies the form of the system of equations:
   *          = 'N':  A * X = B  (No transpose)
   *          = 'T':  A'* X = B  (Transpose)
   *          = 'C':  A'* X = B  (Conjugate transpose = Transpose)
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrix B.  NRHS >= 0.
   *
   *  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
   *          The factors L and U from the factorization A = P*L*U
   *          as computed by DGETRF.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  IPIV    (input) INTEGER array, dimension (N)
   *          The pivot indices from DGETRF; for 1<=i<=N, row i of the
   *          matrix was interchanged with row IPIV(i).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the right hand side matrix B.
   *          On exit, the solution matrix X.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param n
   * @param nrhs
   * @param a
   * @param lda
   * @param ipiv
   * @param b
   * @param ldb
   * @param info
   * 
   */
  abstract public void dgetrs(java.lang.String trans, int n, int nrhs, double[] a, int lda, int[] ipiv, double[] b, int ldb, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGETRS solves a system of linear equations
   *     A * X = B  or  A' * X = B
   *  with a general N-by-N matrix A using the LU factorization computed
   *  by DGETRF.
   *
   *  Arguments
   *  =========
   *
   *  TRANS   (input) CHARACTER*1
   *          Specifies the form of the system of equations:
   *          = 'N':  A * X = B  (No transpose)
   *          = 'T':  A'* X = B  (Transpose)
   *          = 'C':  A'* X = B  (Conjugate transpose = Transpose)
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrix B.  NRHS >= 0.
   *
   *  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
   *          The factors L and U from the factorization A = P*L*U
   *          as computed by DGETRF.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  IPIV    (input) INTEGER array, dimension (N)
   *          The pivot indices from DGETRF; for 1<=i<=N, row i of the
   *          matrix was interchanged with row IPIV(i).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the right hand side matrix B.
   *          On exit, the solution matrix X.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param n
   * @param nrhs
   * @param a
   * @param _a_offset
   * @param lda
   * @param ipiv
   * @param _ipiv_offset
   * @param b
   * @param _b_offset
   * @param ldb
   * @param info
   * 
   */
  abstract public void dgetrs(java.lang.String trans, int n, int nrhs, double[] a, int _a_offset, int lda, int[] ipiv, int _ipiv_offset, double[] b, int _b_offset, int ldb, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGBAK forms the right or left eigenvectors of a real generalized
   *  eigenvalue problem A*x = lambda*B*x, by backward transformation on
   *  the computed eigenvectors of the balanced pair of matrices output by
   *  DGGBAL.
   *
   *  Arguments
   *  =========
   *
   *  JOB     (input) CHARACTER*1
   *          Specifies the type of backward transformation required:
   *          = 'N':  do nothing, return immediately;
   *          = 'P':  do backward transformation for permutation only;
   *          = 'S':  do backward transformation for scaling only;
   *          = 'B':  do backward transformations for both permutation and
   *                  scaling.
   *          JOB must be the same as the argument JOB supplied to DGGBAL.
   *
   *  SIDE    (input) CHARACTER*1
   *          = 'R':  V contains right eigenvectors;
   *          = 'L':  V contains left eigenvectors.
   *
   *  N       (input) INTEGER
   *          The number of rows of the matrix V.  N >= 0.
   *
   *  ILO     (input) INTEGER
   *  IHI     (input) INTEGER
   *          The integers ILO and IHI determined by DGGBAL.
   *          1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0.
   *
   *  LSCALE  (input) DOUBLE PRECISION array, dimension (N)
   *          Details of the permutations and/or scaling factors applied
   *          to the left side of A and B, as returned by DGGBAL.
   *
   *  RSCALE  (input) DOUBLE PRECISION array, dimension (N)
   *          Details of the permutations and/or scaling factors applied
   *          to the right side of A and B, as returned by DGGBAL.
   *
   *  M       (input) INTEGER
   *          The number of columns of the matrix V.  M >= 0.
   *
   *  V       (input/output) DOUBLE PRECISION array, dimension (LDV,M)
   *          On entry, the matrix of right or left eigenvectors to be
   *          transformed, as returned by DTGEVC.
   *          On exit, V is overwritten by the transformed eigenvectors.
   *
   *  LDV     (input) INTEGER
   *          The leading dimension of the matrix V. LDV >= max(1,N).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  See R.C. Ward, Balancing the generalized eigenvalue problem,
   *                 SIAM J. Sci. Stat. Comp. 2 (1981), 141-152.
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param job
   * @param side
   * @param n
   * @param ilo
   * @param ihi
   * @param lscale
   * @param rscale
   * @param m
   * @param v
   * @param ldv
   * @param info
   * 
   */
  abstract public void dggbak(java.lang.String job, java.lang.String side, int n, int ilo, int ihi, double[] lscale, double[] rscale, int m, double[] v, int ldv, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGBAK forms the right or left eigenvectors of a real generalized
   *  eigenvalue problem A*x = lambda*B*x, by backward transformation on
   *  the computed eigenvectors of the balanced pair of matrices output by
   *  DGGBAL.
   *
   *  Arguments
   *  =========
   *
   *  JOB     (input) CHARACTER*1
   *          Specifies the type of backward transformation required:
   *          = 'N':  do nothing, return immediately;
   *          = 'P':  do backward transformation for permutation only;
   *          = 'S':  do backward transformation for scaling only;
   *          = 'B':  do backward transformations for both permutation and
   *                  scaling.
   *          JOB must be the same as the argument JOB supplied to DGGBAL.
   *
   *  SIDE    (input) CHARACTER*1
   *          = 'R':  V contains right eigenvectors;
   *          = 'L':  V contains left eigenvectors.
   *
   *  N       (input) INTEGER
   *          The number of rows of the matrix V.  N >= 0.
   *
   *  ILO     (input) INTEGER
   *  IHI     (input) INTEGER
   *          The integers ILO and IHI determined by DGGBAL.
   *          1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0.
   *
   *  LSCALE  (input) DOUBLE PRECISION array, dimension (N)
   *          Details of the permutations and/or scaling factors applied
   *          to the left side of A and B, as returned by DGGBAL.
   *
   *  RSCALE  (input) DOUBLE PRECISION array, dimension (N)
   *          Details of the permutations and/or scaling factors applied
   *          to the right side of A and B, as returned by DGGBAL.
   *
   *  M       (input) INTEGER
   *          The number of columns of the matrix V.  M >= 0.
   *
   *  V       (input/output) DOUBLE PRECISION array, dimension (LDV,M)
   *          On entry, the matrix of right or left eigenvectors to be
   *          transformed, as returned by DTGEVC.
   *          On exit, V is overwritten by the transformed eigenvectors.
   *
   *  LDV     (input) INTEGER
   *          The leading dimension of the matrix V. LDV >= max(1,N).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  See R.C. Ward, Balancing the generalized eigenvalue problem,
   *                 SIAM J. Sci. Stat. Comp. 2 (1981), 141-152.
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param job
   * @param side
   * @param n
   * @param ilo
   * @param ihi
   * @param lscale
   * @param _lscale_offset
   * @param rscale
   * @param _rscale_offset
   * @param m
   * @param v
   * @param _v_offset
   * @param ldv
   * @param info
   * 
   */
  abstract public void dggbak(java.lang.String job, java.lang.String side, int n, int ilo, int ihi, double[] lscale, int _lscale_offset, double[] rscale, int _rscale_offset, int m, double[] v, int _v_offset, int ldv, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGBAL balances a pair of general real matrices (A,B).  This
   *  involves, first, permuting A and B by similarity transformations to
   *  isolate eigenvalues in the first 1 to ILO$-$1 and last IHI+1 to N
   *  elements on the diagonal; and second, applying a diagonal similarity
   *  transformation to rows and columns ILO to IHI to make the rows
   *  and columns as close in norm as possible. Both steps are optional.
   *
   *  Balancing may reduce the 1-norm of the matrices, and improve the
   *  accuracy of the computed eigenvalues and/or eigenvectors in the
   *  generalized eigenvalue problem A*x = lambda*B*x.
   *
   *  Arguments
   *  =========
   *
   *  JOB     (input) CHARACTER*1
   *          Specifies the operations to be performed on A and B:
   *          = 'N':  none:  simply set ILO = 1, IHI = N, LSCALE(I) = 1.0
   *                  and RSCALE(I) = 1.0 for i = 1,...,N.
   *          = 'P':  permute only;
   *          = 'S':  scale only;
   *          = 'B':  both permute and scale.
   *
   *  N       (input) INTEGER
   *          The order of the matrices A and B.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the input matrix A.
   *          On exit,  A is overwritten by the balanced matrix.
   *          If JOB = 'N', A is not referenced.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A. LDA >= max(1,N).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,N)
   *          On entry, the input matrix B.
   *          On exit,  B is overwritten by the balanced matrix.
   *          If JOB = 'N', B is not referenced.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,N).
   *
   *  ILO     (output) INTEGER
   *  IHI     (output) INTEGER
   *          ILO and IHI are set to integers such that on exit
   *          A(i,j) = 0 and B(i,j) = 0 if i > j and
   *          j = 1,...,ILO-1 or i = IHI+1,...,N.
   *          If JOB = 'N' or 'S', ILO = 1 and IHI = N.
   *
   *  LSCALE  (output) DOUBLE PRECISION array, dimension (N)
   *          Details of the permutations and scaling factors applied
   *          to the left side of A and B.  If P(j) is the index of the
   *          row interchanged with row j, and D(j)
   *          is the scaling factor applied to row j, then
   *            LSCALE(j) = P(j)    for J = 1,...,ILO-1
   *                      = D(j)    for J = ILO,...,IHI
   *                      = P(j)    for J = IHI+1,...,N.
   *          The order in which the interchanges are made is N to IHI+1,
   *          then 1 to ILO-1.
   *
   *  RSCALE  (output) DOUBLE PRECISION array, dimension (N)
   *          Details of the permutations and scaling factors applied
   *          to the right side of A and B.  If P(j) is the index of the
   *          column interchanged with column j, and D(j)
   *          is the scaling factor applied to column j, then
   *            LSCALE(j) = P(j)    for J = 1,...,ILO-1
   *                      = D(j)    for J = ILO,...,IHI
   *                      = P(j)    for J = IHI+1,...,N.
   *          The order in which the interchanges are made is N to IHI+1,
   *          then 1 to ILO-1.
   *
   *  WORK    (workspace) REAL array, dimension (lwork)
   *          lwork must be at least max(1,6*N) when JOB = 'S' or 'B', and
   *          at least 1 when JOB = 'N' or 'P'.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  See R.C. WARD, Balancing the generalized eigenvalue problem,
   *                 SIAM J. Sci. Stat. Comp. 2 (1981), 141-152.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param job
   * @param n
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param ilo
   * @param ihi
   * @param lscale
   * @param rscale
   * @param work
   * @param info
   * 
   */
  abstract public void dggbal(java.lang.String job, int n, double[] a, int lda, double[] b, int ldb, org.netlib.util.intW ilo, org.netlib.util.intW ihi, double[] lscale, double[] rscale, double[] work, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGBAL balances a pair of general real matrices (A,B).  This
   *  involves, first, permuting A and B by similarity transformations to
   *  isolate eigenvalues in the first 1 to ILO$-$1 and last IHI+1 to N
   *  elements on the diagonal; and second, applying a diagonal similarity
   *  transformation to rows and columns ILO to IHI to make the rows
   *  and columns as close in norm as possible. Both steps are optional.
   *
   *  Balancing may reduce the 1-norm of the matrices, and improve the
   *  accuracy of the computed eigenvalues and/or eigenvectors in the
   *  generalized eigenvalue problem A*x = lambda*B*x.
   *
   *  Arguments
   *  =========
   *
   *  JOB     (input) CHARACTER*1
   *          Specifies the operations to be performed on A and B:
   *          = 'N':  none:  simply set ILO = 1, IHI = N, LSCALE(I) = 1.0
   *                  and RSCALE(I) = 1.0 for i = 1,...,N.
   *          = 'P':  permute only;
   *          = 'S':  scale only;
   *          = 'B':  both permute and scale.
   *
   *  N       (input) INTEGER
   *          The order of the matrices A and B.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the input matrix A.
   *          On exit,  A is overwritten by the balanced matrix.
   *          If JOB = 'N', A is not referenced.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A. LDA >= max(1,N).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,N)
   *          On entry, the input matrix B.
   *          On exit,  B is overwritten by the balanced matrix.
   *          If JOB = 'N', B is not referenced.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,N).
   *
   *  ILO     (output) INTEGER
   *  IHI     (output) INTEGER
   *          ILO and IHI are set to integers such that on exit
   *          A(i,j) = 0 and B(i,j) = 0 if i > j and
   *          j = 1,...,ILO-1 or i = IHI+1,...,N.
   *          If JOB = 'N' or 'S', ILO = 1 and IHI = N.
   *
   *  LSCALE  (output) DOUBLE PRECISION array, dimension (N)
   *          Details of the permutations and scaling factors applied
   *          to the left side of A and B.  If P(j) is the index of the
   *          row interchanged with row j, and D(j)
   *          is the scaling factor applied to row j, then
   *            LSCALE(j) = P(j)    for J = 1,...,ILO-1
   *                      = D(j)    for J = ILO,...,IHI
   *                      = P(j)    for J = IHI+1,...,N.
   *          The order in which the interchanges are made is N to IHI+1,
   *          then 1 to ILO-1.
   *
   *  RSCALE  (output) DOUBLE PRECISION array, dimension (N)
   *          Details of the permutations and scaling factors applied
   *          to the right side of A and B.  If P(j) is the index of the
   *          column interchanged with column j, and D(j)
   *          is the scaling factor applied to column j, then
   *            LSCALE(j) = P(j)    for J = 1,...,ILO-1
   *                      = D(j)    for J = ILO,...,IHI
   *                      = P(j)    for J = IHI+1,...,N.
   *          The order in which the interchanges are made is N to IHI+1,
   *          then 1 to ILO-1.
   *
   *  WORK    (workspace) REAL array, dimension (lwork)
   *          lwork must be at least max(1,6*N) when JOB = 'S' or 'B', and
   *          at least 1 when JOB = 'N' or 'P'.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  See R.C. WARD, Balancing the generalized eigenvalue problem,
   *                 SIAM J. Sci. Stat. Comp. 2 (1981), 141-152.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param job
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param ilo
   * @param ihi
   * @param lscale
   * @param _lscale_offset
   * @param rscale
   * @param _rscale_offset
   * @param work
   * @param _work_offset
   * @param info
   * 
   */
  abstract public void dggbal(java.lang.String job, int n, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, org.netlib.util.intW ilo, org.netlib.util.intW ihi, double[] lscale, int _lscale_offset, double[] rscale, int _rscale_offset, double[] work, int _work_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGES computes for a pair of N-by-N real nonsymmetric matrices (A,B),
   *  the generalized eigenvalues, the generalized real Schur form (S,T),
   *  optionally, the left and/or right matrices of Schur vectors (VSL and
   *  VSR). This gives the generalized Schur factorization
   *
   *           (A,B) = ( (VSL)*S*(VSR)**T, (VSL)*T*(VSR)**T )
   *
   *  Optionally, it also orders the eigenvalues so that a selected cluster
   *  of eigenvalues appears in the leading diagonal blocks of the upper
   *  quasi-triangular matrix S and the upper triangular matrix T.The
   *  leading columns of VSL and VSR then form an orthonormal basis for the
   *  corresponding left and right eigenspaces (deflating subspaces).
   *
   *  (If only the generalized eigenvalues are needed, use the driver
   *  DGGEV instead, which is faster.)
   *
   *  A generalized eigenvalue for a pair of matrices (A,B) is a scalar w
   *  or a ratio alpha/beta = w, such that  A - w*B is singular.  It is
   *  usually represented as the pair (alpha,beta), as there is a
   *  reasonable interpretation for beta=0 or both being zero.
   *
   *  A pair of matrices (S,T) is in generalized real Schur form if T is
   *  upper triangular with non-negative diagonal and S is block upper
   *  triangular with 1-by-1 and 2-by-2 blocks.  1-by-1 blocks correspond
   *  to real generalized eigenvalues, while 2-by-2 blocks of S will be
   *  "standardized" by making the corresponding elements of T have the
   *  form:
   *          [  a  0  ]
   *          [  0  b  ]
   *
   *  and the pair of corresponding 2-by-2 blocks in S and T will have a
   *  complex conjugate pair of generalized eigenvalues.
   *
   *
   *  Arguments
   *  =========
   *
   *  JOBVSL  (input) CHARACTER*1
   *          = 'N':  do not compute the left Schur vectors;
   *          = 'V':  compute the left Schur vectors.
   *
   *  JOBVSR  (input) CHARACTER*1
   *          = 'N':  do not compute the right Schur vectors;
   *          = 'V':  compute the right Schur vectors.
   *
   *  SORT    (input) CHARACTER*1
   *          Specifies whether or not to order the eigenvalues on the
   *          diagonal of the generalized Schur form.
   *          = 'N':  Eigenvalues are not ordered;
   *          = 'S':  Eigenvalues are ordered (see SELCTG);
   *
   *  SELCTG  (external procedure) LOGICAL FUNCTION of three DOUBLE PRECISI
   *          SELCTG must be declared EXTERNAL in the calling subroutine.
   *          If SORT = 'N', SELCTG is not referenced.
   *          If SORT = 'S', SELCTG is used to select eigenvalues to sort
   *          to the top left of the Schur form.
   *          An eigenvalue (ALPHAR(j)+ALPHAI(j))/BETA(j) is selected if
   *          SELCTG(ALPHAR(j),ALPHAI(j),BETA(j)) is true; i.e. if either
   *          one of a complex conjugate pair of eigenvalues is selected,
   *          then both complex eigenvalues are selected.
   *
   *          Note that in the ill-conditioned case, a selected complex
   *          eigenvalue may no longer satisfy SELCTG(ALPHAR(j),ALPHAI(j),
   *          BETA(j)) = .TRUE. after ordering. INFO is to be set to N+2
   *          in this case.
   *
   *  N       (input) INTEGER
   *          The order of the matrices A, B, VSL, and VSR.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
   *          On entry, the first of the pair of matrices.
   *          On exit, A has been overwritten by its generalized Schur
   *          form S.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of A.  LDA >= max(1,N).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
   *          On entry, the second of the pair of matrices.
   *          On exit, B has been overwritten by its generalized Schur
   *          form T.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of B.  LDB >= max(1,N).
   *
   *  SDIM    (output) INTEGER
   *          If SORT = 'N', SDIM = 0.
   *          If SORT = 'S', SDIM = number of eigenvalues (after sorting)
   *          for which SELCTG is true.  (Complex conjugate pairs for which
   *          SELCTG is true for either eigenvalue count as 2.)
   *
   *  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
   *  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
   *  BETA    (output) DOUBLE PRECISION array, dimension (N)
   *          On exit, (ALPHAR(j) + ALPHAI(j)*i)/BETA(j), j=1,...,N, will
   *          be the generalized eigenvalues.  ALPHAR(j) + ALPHAI(j)*i,
   *          and  BETA(j),j=1,...,N are the diagonals of the complex Schur
   *          form (S,T) that would result if the 2-by-2 diagonal blocks of
   *          the real Schur form of (A,B) were further reduced to
   *          triangular form using 2-by-2 complex unitary transformations.
   *          If ALPHAI(j) is zero, then the j-th eigenvalue is real; if
   *          positive, then the j-th and (j+1)-st eigenvalues are a
   *          complex conjugate pair, with ALPHAI(j+1) negative.
   *
   *          Note: the quotients ALPHAR(j)/BETA(j) and ALPHAI(j)/BETA(j)
   *          may easily over- or underflow, and BETA(j) may even be zero.
   *          Thus, the user should avoid naively computing the ratio.
   *          However, ALPHAR and ALPHAI will be always less than and
   *          usually comparable with norm(A) in magnitude, and BETA always
   *          less than and usually comparable with norm(B).
   *
   *  VSL     (output) DOUBLE PRECISION array, dimension (LDVSL,N)
   *          If JOBVSL = 'V', VSL will contain the left Schur vectors.
   *          Not referenced if JOBVSL = 'N'.
   *
   *  LDVSL   (input) INTEGER
   *          The leading dimension of the matrix VSL. LDVSL >=1, and
   *          if JOBVSL = 'V', LDVSL >= N.
   *
   *  VSR     (output) DOUBLE PRECISION array, dimension (LDVSR,N)
   *          If JOBVSR = 'V', VSR will contain the right Schur vectors.
   *          Not referenced if JOBVSR = 'N'.
   *
   *  LDVSR   (input) INTEGER
   *          The leading dimension of the matrix VSR. LDVSR >= 1, and
   *          if JOBVSR = 'V', LDVSR >= N.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.
   *          If N = 0, LWORK >= 1, else LWORK >= 8*N+16.
   *          For good performance , LWORK must generally be larger.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  BWORK   (workspace) LOGICAL array, dimension (N)
   *          Not referenced if SORT = 'N'.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          = 1,...,N:
   *                The QZ iteration failed.  (A,B) are not in Schur
   *                form, but ALPHAR(j), ALPHAI(j), and BETA(j) should
   *                be correct for j=INFO+1,...,N.
   *          > N:  =N+1: other than QZ iteration failed in DHGEQZ.
   *                =N+2: after reordering, roundoff changed values of
   *                      some complex eigenvalues so that leading
   *                      eigenvalues in the Generalized Schur form no
   *                      longer satisfy SELCTG=.TRUE.  This could also
   *                      be caused due to scaling.
   *                =N+3: reordering failed in DTGSEN.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobvsl
   * @param jobvsr
   * @param sort
   * @param selctg
   * @param n
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param sdim
   * @param alphar
   * @param alphai
   * @param beta
   * @param vsl
   * @param ldvsl
   * @param vsr
   * @param ldvsr
   * @param work
   * @param lwork
   * @param bwork
   * @param info
   * 
   */
  abstract public void dgges(java.lang.String jobvsl, java.lang.String jobvsr, java.lang.String sort, java.lang.Object selctg, int n, double[] a, int lda, double[] b, int ldb, org.netlib.util.intW sdim, double[] alphar, double[] alphai, double[] beta, double[] vsl, int ldvsl, double[] vsr, int ldvsr, double[] work, int lwork, boolean[] bwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGES computes for a pair of N-by-N real nonsymmetric matrices (A,B),
   *  the generalized eigenvalues, the generalized real Schur form (S,T),
   *  optionally, the left and/or right matrices of Schur vectors (VSL and
   *  VSR). This gives the generalized Schur factorization
   *
   *           (A,B) = ( (VSL)*S*(VSR)**T, (VSL)*T*(VSR)**T )
   *
   *  Optionally, it also orders the eigenvalues so that a selected cluster
   *  of eigenvalues appears in the leading diagonal blocks of the upper
   *  quasi-triangular matrix S and the upper triangular matrix T.The
   *  leading columns of VSL and VSR then form an orthonormal basis for the
   *  corresponding left and right eigenspaces (deflating subspaces).
   *
   *  (If only the generalized eigenvalues are needed, use the driver
   *  DGGEV instead, which is faster.)
   *
   *  A generalized eigenvalue for a pair of matrices (A,B) is a scalar w
   *  or a ratio alpha/beta = w, such that  A - w*B is singular.  It is
   *  usually represented as the pair (alpha,beta), as there is a
   *  reasonable interpretation for beta=0 or both being zero.
   *
   *  A pair of matrices (S,T) is in generalized real Schur form if T is
   *  upper triangular with non-negative diagonal and S is block upper
   *  triangular with 1-by-1 and 2-by-2 blocks.  1-by-1 blocks correspond
   *  to real generalized eigenvalues, while 2-by-2 blocks of S will be
   *  "standardized" by making the corresponding elements of T have the
   *  form:
   *          [  a  0  ]
   *          [  0  b  ]
   *
   *  and the pair of corresponding 2-by-2 blocks in S and T will have a
   *  complex conjugate pair of generalized eigenvalues.
   *
   *
   *  Arguments
   *  =========
   *
   *  JOBVSL  (input) CHARACTER*1
   *          = 'N':  do not compute the left Schur vectors;
   *          = 'V':  compute the left Schur vectors.
   *
   *  JOBVSR  (input) CHARACTER*1
   *          = 'N':  do not compute the right Schur vectors;
   *          = 'V':  compute the right Schur vectors.
   *
   *  SORT    (input) CHARACTER*1
   *          Specifies whether or not to order the eigenvalues on the
   *          diagonal of the generalized Schur form.
   *          = 'N':  Eigenvalues are not ordered;
   *          = 'S':  Eigenvalues are ordered (see SELCTG);
   *
   *  SELCTG  (external procedure) LOGICAL FUNCTION of three DOUBLE PRECISI
   *          SELCTG must be declared EXTERNAL in the calling subroutine.
   *          If SORT = 'N', SELCTG is not referenced.
   *          If SORT = 'S', SELCTG is used to select eigenvalues to sort
   *          to the top left of the Schur form.
   *          An eigenvalue (ALPHAR(j)+ALPHAI(j))/BETA(j) is selected if
   *          SELCTG(ALPHAR(j),ALPHAI(j),BETA(j)) is true; i.e. if either
   *          one of a complex conjugate pair of eigenvalues is selected,
   *          then both complex eigenvalues are selected.
   *
   *          Note that in the ill-conditioned case, a selected complex
   *          eigenvalue may no longer satisfy SELCTG(ALPHAR(j),ALPHAI(j),
   *          BETA(j)) = .TRUE. after ordering. INFO is to be set to N+2
   *          in this case.
   *
   *  N       (input) INTEGER
   *          The order of the matrices A, B, VSL, and VSR.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
   *          On entry, the first of the pair of matrices.
   *          On exit, A has been overwritten by its generalized Schur
   *          form S.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of A.  LDA >= max(1,N).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
   *          On entry, the second of the pair of matrices.
   *          On exit, B has been overwritten by its generalized Schur
   *          form T.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of B.  LDB >= max(1,N).
   *
   *  SDIM    (output) INTEGER
   *          If SORT = 'N', SDIM = 0.
   *          If SORT = 'S', SDIM = number of eigenvalues (after sorting)
   *          for which SELCTG is true.  (Complex conjugate pairs for which
   *          SELCTG is true for either eigenvalue count as 2.)
   *
   *  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
   *  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
   *  BETA    (output) DOUBLE PRECISION array, dimension (N)
   *          On exit, (ALPHAR(j) + ALPHAI(j)*i)/BETA(j), j=1,...,N, will
   *          be the generalized eigenvalues.  ALPHAR(j) + ALPHAI(j)*i,
   *          and  BETA(j),j=1,...,N are the diagonals of the complex Schur
   *          form (S,T) that would result if the 2-by-2 diagonal blocks of
   *          the real Schur form of (A,B) were further reduced to
   *          triangular form using 2-by-2 complex unitary transformations.
   *          If ALPHAI(j) is zero, then the j-th eigenvalue is real; if
   *          positive, then the j-th and (j+1)-st eigenvalues are a
   *          complex conjugate pair, with ALPHAI(j+1) negative.
   *
   *          Note: the quotients ALPHAR(j)/BETA(j) and ALPHAI(j)/BETA(j)
   *          may easily over- or underflow, and BETA(j) may even be zero.
   *          Thus, the user should avoid naively computing the ratio.
   *          However, ALPHAR and ALPHAI will be always less than and
   *          usually comparable with norm(A) in magnitude, and BETA always
   *          less than and usually comparable with norm(B).
   *
   *  VSL     (output) DOUBLE PRECISION array, dimension (LDVSL,N)
   *          If JOBVSL = 'V', VSL will contain the left Schur vectors.
   *          Not referenced if JOBVSL = 'N'.
   *
   *  LDVSL   (input) INTEGER
   *          The leading dimension of the matrix VSL. LDVSL >=1, and
   *          if JOBVSL = 'V', LDVSL >= N.
   *
   *  VSR     (output) DOUBLE PRECISION array, dimension (LDVSR,N)
   *          If JOBVSR = 'V', VSR will contain the right Schur vectors.
   *          Not referenced if JOBVSR = 'N'.
   *
   *  LDVSR   (input) INTEGER
   *          The leading dimension of the matrix VSR. LDVSR >= 1, and
   *          if JOBVSR = 'V', LDVSR >= N.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.
   *          If N = 0, LWORK >= 1, else LWORK >= 8*N+16.
   *          For good performance , LWORK must generally be larger.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  BWORK   (workspace) LOGICAL array, dimension (N)
   *          Not referenced if SORT = 'N'.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          = 1,...,N:
   *                The QZ iteration failed.  (A,B) are not in Schur
   *                form, but ALPHAR(j), ALPHAI(j), and BETA(j) should
   *                be correct for j=INFO+1,...,N.
   *          > N:  =N+1: other than QZ iteration failed in DHGEQZ.
   *                =N+2: after reordering, roundoff changed values of
   *                      some complex eigenvalues so that leading
   *                      eigenvalues in the Generalized Schur form no
   *                      longer satisfy SELCTG=.TRUE.  This could also
   *                      be caused due to scaling.
   *                =N+3: reordering failed in DTGSEN.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobvsl
   * @param jobvsr
   * @param sort
   * @param selctg
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param sdim
   * @param alphar
   * @param _alphar_offset
   * @param alphai
   * @param _alphai_offset
   * @param beta
   * @param _beta_offset
   * @param vsl
   * @param _vsl_offset
   * @param ldvsl
   * @param vsr
   * @param _vsr_offset
   * @param ldvsr
   * @param work
   * @param _work_offset
   * @param lwork
   * @param bwork
   * @param _bwork_offset
   * @param info
   * 
   */
  abstract public void dgges(java.lang.String jobvsl, java.lang.String jobvsr, java.lang.String sort, java.lang.Object selctg, int n, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, org.netlib.util.intW sdim, double[] alphar, int _alphar_offset, double[] alphai, int _alphai_offset, double[] beta, int _beta_offset, double[] vsl, int _vsl_offset, int ldvsl, double[] vsr, int _vsr_offset, int ldvsr, double[] work, int _work_offset, int lwork, boolean[] bwork, int _bwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGESX computes for a pair of N-by-N real nonsymmetric matrices
   *  (A,B), the generalized eigenvalues, the real Schur form (S,T), and,
   *  optionally, the left and/or right matrices of Schur vectors (VSL and
   *  VSR).  This gives the generalized Schur factorization
   *
   *       (A,B) = ( (VSL) S (VSR)**T, (VSL) T (VSR)**T )
   *
   *  Optionally, it also orders the eigenvalues so that a selected cluster
   *  of eigenvalues appears in the leading diagonal blocks of the upper
   *  quasi-triangular matrix S and the upper triangular matrix T; computes
   *  a reciprocal condition number for the average of the selected
   *  eigenvalues (RCONDE); and computes a reciprocal condition number for
   *  the right and left deflating subspaces corresponding to the selected
   *  eigenvalues (RCONDV). The leading columns of VSL and VSR then form
   *  an orthonormal basis for the corresponding left and right eigenspaces
   *  (deflating subspaces).
   *
   *  A generalized eigenvalue for a pair of matrices (A,B) is a scalar w
   *  or a ratio alpha/beta = w, such that  A - w*B is singular.  It is
   *  usually represented as the pair (alpha,beta), as there is a
   *  reasonable interpretation for beta=0 or for both being zero.
   *
   *  A pair of matrices (S,T) is in generalized real Schur form if T is
   *  upper triangular with non-negative diagonal and S is block upper
   *  triangular with 1-by-1 and 2-by-2 blocks.  1-by-1 blocks correspond
   *  to real generalized eigenvalues, while 2-by-2 blocks of S will be
   *  "standardized" by making the corresponding elements of T have the
   *  form:
   *          [  a  0  ]
   *          [  0  b  ]
   *
   *  and the pair of corresponding 2-by-2 blocks in S and T will have a
   *  complex conjugate pair of generalized eigenvalues.
   *
   *
   *  Arguments
   *  =========
   *
   *  JOBVSL  (input) CHARACTER*1
   *          = 'N':  do not compute the left Schur vectors;
   *          = 'V':  compute the left Schur vectors.
   *
   *  JOBVSR  (input) CHARACTER*1
   *          = 'N':  do not compute the right Schur vectors;
   *          = 'V':  compute the right Schur vectors.
   *
   *  SORT    (input) CHARACTER*1
   *          Specifies whether or not to order the eigenvalues on the
   *          diagonal of the generalized Schur form.
   *          = 'N':  Eigenvalues are not ordered;
   *          = 'S':  Eigenvalues are ordered (see SELCTG).
   *
   *  SELCTG  (external procedure) LOGICAL FUNCTION of three DOUBLE PRECISI
   *          SELCTG must be declared EXTERNAL in the calling subroutine.
   *          If SORT = 'N', SELCTG is not referenced.
   *          If SORT = 'S', SELCTG is used to select eigenvalues to sort
   *          to the top left of the Schur form.
   *          An eigenvalue (ALPHAR(j)+ALPHAI(j))/BETA(j) is selected if
   *          SELCTG(ALPHAR(j),ALPHAI(j),BETA(j)) is true; i.e. if either
   *          one of a complex conjugate pair of eigenvalues is selected,
   *          then both complex eigenvalues are selected.
   *          Note that a selected complex eigenvalue may no longer satisfy
   *          SELCTG(ALPHAR(j),ALPHAI(j),BETA(j)) = .TRUE. after ordering,
   *          since ordering may change the value of complex eigenvalues
   *          (especially if the eigenvalue is ill-conditioned), in this
   *          case INFO is set to N+3.
   *
   *  SENSE   (input) CHARACTER*1
   *          Determines which reciprocal condition numbers are computed.
   *          = 'N' : None are computed;
   *          = 'E' : Computed for average of selected eigenvalues only;
   *          = 'V' : Computed for selected deflating subspaces only;
   *          = 'B' : Computed for both.
   *          If SENSE = 'E', 'V', or 'B', SORT must equal 'S'.
   *
   *  N       (input) INTEGER
   *          The order of the matrices A, B, VSL, and VSR.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
   *          On entry, the first of the pair of matrices.
   *          On exit, A has been overwritten by its generalized Schur
   *          form S.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of A.  LDA >= max(1,N).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
   *          On entry, the second of the pair of matrices.
   *          On exit, B has been overwritten by its generalized Schur
   *          form T.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of B.  LDB >= max(1,N).
   *
   *  SDIM    (output) INTEGER
   *          If SORT = 'N', SDIM = 0.
   *          If SORT = 'S', SDIM = number of eigenvalues (after sorting)
   *          for which SELCTG is true.  (Complex conjugate pairs for which
   *          SELCTG is true for either eigenvalue count as 2.)
   *
   *  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
   *  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
   *  BETA    (output) DOUBLE PRECISION array, dimension (N)
   *          On exit, (ALPHAR(j) + ALPHAI(j)*i)/BETA(j), j=1,...,N, will
   *          be the generalized eigenvalues.  ALPHAR(j) + ALPHAI(j)*i
   *          and BETA(j),j=1,...,N  are the diagonals of the complex Schur
   *          form (S,T) that would result if the 2-by-2 diagonal blocks of
   *          the real Schur form of (A,B) were further reduced to
   *          triangular form using 2-by-2 complex unitary transformations.
   *          If ALPHAI(j) is zero, then the j-th eigenvalue is real; if
   *          positive, then the j-th and (j+1)-st eigenvalues are a
   *          complex conjugate pair, with ALPHAI(j+1) negative.
   *
   *          Note: the quotients ALPHAR(j)/BETA(j) and ALPHAI(j)/BETA(j)
   *          may easily over- or underflow, and BETA(j) may even be zero.
   *          Thus, the user should avoid naively computing the ratio.
   *          However, ALPHAR and ALPHAI will be always less than and
   *          usually comparable with norm(A) in magnitude, and BETA always
   *          less than and usually comparable with norm(B).
   *
   *  VSL     (output) DOUBLE PRECISION array, dimension (LDVSL,N)
   *          If JOBVSL = 'V', VSL will contain the left Schur vectors.
   *          Not referenced if JOBVSL = 'N'.
   *
   *  LDVSL   (input) INTEGER
   *          The leading dimension of the matrix VSL. LDVSL >=1, and
   *          if JOBVSL = 'V', LDVSL >= N.
   *
   *  VSR     (output) DOUBLE PRECISION array, dimension (LDVSR,N)
   *          If JOBVSR = 'V', VSR will contain the right Schur vectors.
   *          Not referenced if JOBVSR = 'N'.
   *
   *  LDVSR   (input) INTEGER
   *          The leading dimension of the matrix VSR. LDVSR >= 1, and
   *          if JOBVSR = 'V', LDVSR >= N.
   *
   *  RCONDE  (output) DOUBLE PRECISION array, dimension ( 2 )
   *          If SENSE = 'E' or 'B', RCONDE(1) and RCONDE(2) contain the
   *          reciprocal condition numbers for the average of the selected
   *          eigenvalues.
   *          Not referenced if SENSE = 'N' or 'V'.
   *
   *  RCONDV  (output) DOUBLE PRECISION array, dimension ( 2 )
   *          If SENSE = 'V' or 'B', RCONDV(1) and RCONDV(2) contain the
   *          reciprocal condition numbers for the selected deflating
   *          subspaces.
   *          Not referenced if SENSE = 'N' or 'E'.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.
   *          If N = 0, LWORK >= 1, else if SENSE = 'E', 'V', or 'B',
   *          LWORK >= max( 8*N, 6*N+16, 2*SDIM*(N-SDIM) ), else
   *          LWORK >= max( 8*N, 6*N+16 ).
   *          Note that 2*SDIM*(N-SDIM) <= N*N/2.
   *          Note also that an error is only returned if
   *          LWORK < max( 8*N, 6*N+16), but if SENSE = 'E' or 'V' or 'B'
   *          this may not be large enough.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the bound on the optimal size of the WORK
   *          array and the minimum size of the IWORK array, returns these
   *          values as the first entries of the WORK and IWORK arrays, and
   *          no error message related to LWORK or LIWORK is issued by
   *          XERBLA.
   *
   *  IWORK   (workspace) INTEGER array, dimension (MAX(1,LIWORK))
   *          On exit, if INFO = 0, IWORK(1) returns the minimum LIWORK.
   *
   *  LIWORK  (input) INTEGER
   *          The dimension of the array IWORK.
   *          If SENSE = 'N' or N = 0, LIWORK >= 1, otherwise
   *          LIWORK >= N+6.
   *
   *          If LIWORK = -1, then a workspace query is assumed; the
   *          routine only calculates the bound on the optimal size of the
   *          WORK array and the minimum size of the IWORK array, returns
   *          these values as the first entries of the WORK and IWORK
   *          arrays, and no error message related to LWORK or LIWORK is
   *          issued by XERBLA.
   *
   *  BWORK   (workspace) LOGICAL array, dimension (N)
   *          Not referenced if SORT = 'N'.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          = 1,...,N:
   *                The QZ iteration failed.  (A,B) are not in Schur
   *                form, but ALPHAR(j), ALPHAI(j), and BETA(j) should
   *                be correct for j=INFO+1,...,N.
   *          > N:  =N+1: other than QZ iteration failed in DHGEQZ
   *                =N+2: after reordering, roundoff changed values of
   *                      some complex eigenvalues so that leading
   *                      eigenvalues in the Generalized Schur form no
   *                      longer satisfy SELCTG=.TRUE.  This could also
   *                      be caused due to scaling.
   *                =N+3: reordering failed in DTGSEN.
   *
   *  Further details
   *  ===============
   *
   *  An approximate (asymptotic) bound on the average absolute error of
   *  the selected eigenvalues is
   *
   *       EPS * norm((A, B)) / RCONDE( 1 ).
   *
   *  An approximate (asymptotic) bound on the maximum angular error in
   *  the computed deflating subspaces is
   *
   *       EPS * norm((A, B)) / RCONDV( 2 ).
   *
   *  See LAPACK User's Guide, section 4.11 for more information.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobvsl
   * @param jobvsr
   * @param sort
   * @param selctg
   * @param sense
   * @param n
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param sdim
   * @param alphar
   * @param alphai
   * @param beta
   * @param vsl
   * @param ldvsl
   * @param vsr
   * @param ldvsr
   * @param rconde
   * @param rcondv
   * @param work
   * @param lwork
   * @param iwork
   * @param liwork
   * @param bwork
   * @param info
   * 
   */
  abstract public void dggesx(java.lang.String jobvsl, java.lang.String jobvsr, java.lang.String sort, java.lang.Object selctg, java.lang.String sense, int n, double[] a, int lda, double[] b, int ldb, org.netlib.util.intW sdim, double[] alphar, double[] alphai, double[] beta, double[] vsl, int ldvsl, double[] vsr, int ldvsr, double[] rconde, double[] rcondv, double[] work, int lwork, int[] iwork, int liwork, boolean[] bwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGESX computes for a pair of N-by-N real nonsymmetric matrices
   *  (A,B), the generalized eigenvalues, the real Schur form (S,T), and,
   *  optionally, the left and/or right matrices of Schur vectors (VSL and
   *  VSR).  This gives the generalized Schur factorization
   *
   *       (A,B) = ( (VSL) S (VSR)**T, (VSL) T (VSR)**T )
   *
   *  Optionally, it also orders the eigenvalues so that a selected cluster
   *  of eigenvalues appears in the leading diagonal blocks of the upper
   *  quasi-triangular matrix S and the upper triangular matrix T; computes
   *  a reciprocal condition number for the average of the selected
   *  eigenvalues (RCONDE); and computes a reciprocal condition number for
   *  the right and left deflating subspaces corresponding to the selected
   *  eigenvalues (RCONDV). The leading columns of VSL and VSR then form
   *  an orthonormal basis for the corresponding left and right eigenspaces
   *  (deflating subspaces).
   *
   *  A generalized eigenvalue for a pair of matrices (A,B) is a scalar w
   *  or a ratio alpha/beta = w, such that  A - w*B is singular.  It is
   *  usually represented as the pair (alpha,beta), as there is a
   *  reasonable interpretation for beta=0 or for both being zero.
   *
   *  A pair of matrices (S,T) is in generalized real Schur form if T is
   *  upper triangular with non-negative diagonal and S is block upper
   *  triangular with 1-by-1 and 2-by-2 blocks.  1-by-1 blocks correspond
   *  to real generalized eigenvalues, while 2-by-2 blocks of S will be
   *  "standardized" by making the corresponding elements of T have the
   *  form:
   *          [  a  0  ]
   *          [  0  b  ]
   *
   *  and the pair of corresponding 2-by-2 blocks in S and T will have a
   *  complex conjugate pair of generalized eigenvalues.
   *
   *
   *  Arguments
   *  =========
   *
   *  JOBVSL  (input) CHARACTER*1
   *          = 'N':  do not compute the left Schur vectors;
   *          = 'V':  compute the left Schur vectors.
   *
   *  JOBVSR  (input) CHARACTER*1
   *          = 'N':  do not compute the right Schur vectors;
   *          = 'V':  compute the right Schur vectors.
   *
   *  SORT    (input) CHARACTER*1
   *          Specifies whether or not to order the eigenvalues on the
   *          diagonal of the generalized Schur form.
   *          = 'N':  Eigenvalues are not ordered;
   *          = 'S':  Eigenvalues are ordered (see SELCTG).
   *
   *  SELCTG  (external procedure) LOGICAL FUNCTION of three DOUBLE PRECISI
   *          SELCTG must be declared EXTERNAL in the calling subroutine.
   *          If SORT = 'N', SELCTG is not referenced.
   *          If SORT = 'S', SELCTG is used to select eigenvalues to sort
   *          to the top left of the Schur form.
   *          An eigenvalue (ALPHAR(j)+ALPHAI(j))/BETA(j) is selected if
   *          SELCTG(ALPHAR(j),ALPHAI(j),BETA(j)) is true; i.e. if either
   *          one of a complex conjugate pair of eigenvalues is selected,
   *          then both complex eigenvalues are selected.
   *          Note that a selected complex eigenvalue may no longer satisfy
   *          SELCTG(ALPHAR(j),ALPHAI(j),BETA(j)) = .TRUE. after ordering,
   *          since ordering may change the value of complex eigenvalues
   *          (especially if the eigenvalue is ill-conditioned), in this
   *          case INFO is set to N+3.
   *
   *  SENSE   (input) CHARACTER*1
   *          Determines which reciprocal condition numbers are computed.
   *          = 'N' : None are computed;
   *          = 'E' : Computed for average of selected eigenvalues only;
   *          = 'V' : Computed for selected deflating subspaces only;
   *          = 'B' : Computed for both.
   *          If SENSE = 'E', 'V', or 'B', SORT must equal 'S'.
   *
   *  N       (input) INTEGER
   *          The order of the matrices A, B, VSL, and VSR.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
   *          On entry, the first of the pair of matrices.
   *          On exit, A has been overwritten by its generalized Schur
   *          form S.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of A.  LDA >= max(1,N).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
   *          On entry, the second of the pair of matrices.
   *          On exit, B has been overwritten by its generalized Schur
   *          form T.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of B.  LDB >= max(1,N).
   *
   *  SDIM    (output) INTEGER
   *          If SORT = 'N', SDIM = 0.
   *          If SORT = 'S', SDIM = number of eigenvalues (after sorting)
   *          for which SELCTG is true.  (Complex conjugate pairs for which
   *          SELCTG is true for either eigenvalue count as 2.)
   *
   *  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
   *  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
   *  BETA    (output) DOUBLE PRECISION array, dimension (N)
   *          On exit, (ALPHAR(j) + ALPHAI(j)*i)/BETA(j), j=1,...,N, will
   *          be the generalized eigenvalues.  ALPHAR(j) + ALPHAI(j)*i
   *          and BETA(j),j=1,...,N  are the diagonals of the complex Schur
   *          form (S,T) that would result if the 2-by-2 diagonal blocks of
   *          the real Schur form of (A,B) were further reduced to
   *          triangular form using 2-by-2 complex unitary transformations.
   *          If ALPHAI(j) is zero, then the j-th eigenvalue is real; if
   *          positive, then the j-th and (j+1)-st eigenvalues are a
   *          complex conjugate pair, with ALPHAI(j+1) negative.
   *
   *          Note: the quotients ALPHAR(j)/BETA(j) and ALPHAI(j)/BETA(j)
   *          may easily over- or underflow, and BETA(j) may even be zero.
   *          Thus, the user should avoid naively computing the ratio.
   *          However, ALPHAR and ALPHAI will be always less than and
   *          usually comparable with norm(A) in magnitude, and BETA always
   *          less than and usually comparable with norm(B).
   *
   *  VSL     (output) DOUBLE PRECISION array, dimension (LDVSL,N)
   *          If JOBVSL = 'V', VSL will contain the left Schur vectors.
   *          Not referenced if JOBVSL = 'N'.
   *
   *  LDVSL   (input) INTEGER
   *          The leading dimension of the matrix VSL. LDVSL >=1, and
   *          if JOBVSL = 'V', LDVSL >= N.
   *
   *  VSR     (output) DOUBLE PRECISION array, dimension (LDVSR,N)
   *          If JOBVSR = 'V', VSR will contain the right Schur vectors.
   *          Not referenced if JOBVSR = 'N'.
   *
   *  LDVSR   (input) INTEGER
   *          The leading dimension of the matrix VSR. LDVSR >= 1, and
   *          if JOBVSR = 'V', LDVSR >= N.
   *
   *  RCONDE  (output) DOUBLE PRECISION array, dimension ( 2 )
   *          If SENSE = 'E' or 'B', RCONDE(1) and RCONDE(2) contain the
   *          reciprocal condition numbers for the average of the selected
   *          eigenvalues.
   *          Not referenced if SENSE = 'N' or 'V'.
   *
   *  RCONDV  (output) DOUBLE PRECISION array, dimension ( 2 )
   *          If SENSE = 'V' or 'B', RCONDV(1) and RCONDV(2) contain the
   *          reciprocal condition numbers for the selected deflating
   *          subspaces.
   *          Not referenced if SENSE = 'N' or 'E'.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.
   *          If N = 0, LWORK >= 1, else if SENSE = 'E', 'V', or 'B',
   *          LWORK >= max( 8*N, 6*N+16, 2*SDIM*(N-SDIM) ), else
   *          LWORK >= max( 8*N, 6*N+16 ).
   *          Note that 2*SDIM*(N-SDIM) <= N*N/2.
   *          Note also that an error is only returned if
   *          LWORK < max( 8*N, 6*N+16), but if SENSE = 'E' or 'V' or 'B'
   *          this may not be large enough.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the bound on the optimal size of the WORK
   *          array and the minimum size of the IWORK array, returns these
   *          values as the first entries of the WORK and IWORK arrays, and
   *          no error message related to LWORK or LIWORK is issued by
   *          XERBLA.
   *
   *  IWORK   (workspace) INTEGER array, dimension (MAX(1,LIWORK))
   *          On exit, if INFO = 0, IWORK(1) returns the minimum LIWORK.
   *
   *  LIWORK  (input) INTEGER
   *          The dimension of the array IWORK.
   *          If SENSE = 'N' or N = 0, LIWORK >= 1, otherwise
   *          LIWORK >= N+6.
   *
   *          If LIWORK = -1, then a workspace query is assumed; the
   *          routine only calculates the bound on the optimal size of the
   *          WORK array and the minimum size of the IWORK array, returns
   *          these values as the first entries of the WORK and IWORK
   *          arrays, and no error message related to LWORK or LIWORK is
   *          issued by XERBLA.
   *
   *  BWORK   (workspace) LOGICAL array, dimension (N)
   *          Not referenced if SORT = 'N'.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          = 1,...,N:
   *                The QZ iteration failed.  (A,B) are not in Schur
   *                form, but ALPHAR(j), ALPHAI(j), and BETA(j) should
   *                be correct for j=INFO+1,...,N.
   *          > N:  =N+1: other than QZ iteration failed in DHGEQZ
   *                =N+2: after reordering, roundoff changed values of
   *                      some complex eigenvalues so that leading
   *                      eigenvalues in the Generalized Schur form no
   *                      longer satisfy SELCTG=.TRUE.  This could also
   *                      be caused due to scaling.
   *                =N+3: reordering failed in DTGSEN.
   *
   *  Further details
   *  ===============
   *
   *  An approximate (asymptotic) bound on the average absolute error of
   *  the selected eigenvalues is
   *
   *       EPS * norm((A, B)) / RCONDE( 1 ).
   *
   *  An approximate (asymptotic) bound on the maximum angular error in
   *  the computed deflating subspaces is
   *
   *       EPS * norm((A, B)) / RCONDV( 2 ).
   *
   *  See LAPACK User's Guide, section 4.11 for more information.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobvsl
   * @param jobvsr
   * @param sort
   * @param selctg
   * @param sense
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param sdim
   * @param alphar
   * @param _alphar_offset
   * @param alphai
   * @param _alphai_offset
   * @param beta
   * @param _beta_offset
   * @param vsl
   * @param _vsl_offset
   * @param ldvsl
   * @param vsr
   * @param _vsr_offset
   * @param ldvsr
   * @param rconde
   * @param _rconde_offset
   * @param rcondv
   * @param _rcondv_offset
   * @param work
   * @param _work_offset
   * @param lwork
   * @param iwork
   * @param _iwork_offset
   * @param liwork
   * @param bwork
   * @param _bwork_offset
   * @param info
   * 
   */
  abstract public void dggesx(java.lang.String jobvsl, java.lang.String jobvsr, java.lang.String sort, java.lang.Object selctg, java.lang.String sense, int n, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, org.netlib.util.intW sdim, double[] alphar, int _alphar_offset, double[] alphai, int _alphai_offset, double[] beta, int _beta_offset, double[] vsl, int _vsl_offset, int ldvsl, double[] vsr, int _vsr_offset, int ldvsr, double[] rconde, int _rconde_offset, double[] rcondv, int _rcondv_offset, double[] work, int _work_offset, int lwork, int[] iwork, int _iwork_offset, int liwork, boolean[] bwork, int _bwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGEV computes for a pair of N-by-N real nonsymmetric matrices (A,B)
   *  the generalized eigenvalues, and optionally, the left and/or right
   *  generalized eigenvectors.
   *
   *  A generalized eigenvalue for a pair of matrices (A,B) is a scalar
   *  lambda or a ratio alpha/beta = lambda, such that A - lambda*B is
   *  singular. It is usually represented as the pair (alpha,beta), as
   *  there is a reasonable interpretation for beta=0, and even for both
   *  being zero.
   *
   *  The right eigenvector v(j) corresponding to the eigenvalue lambda(j)
   *  of (A,B) satisfies
   *
   *                   A * v(j) = lambda(j) * B * v(j).
   *
   *  The left eigenvector u(j) corresponding to the eigenvalue lambda(j)
   *  of (A,B) satisfies
   *
   *                   u(j)**H * A  = lambda(j) * u(j)**H * B .
   *
   *  where u(j)**H is the conjugate-transpose of u(j).
   *
   *
   *  Arguments
   *  =========
   *
   *  JOBVL   (input) CHARACTER*1
   *          = 'N':  do not compute the left generalized eigenvectors;
   *          = 'V':  compute the left generalized eigenvectors.
   *
   *  JOBVR   (input) CHARACTER*1
   *          = 'N':  do not compute the right generalized eigenvectors;
   *          = 'V':  compute the right generalized eigenvectors.
   *
   *  N       (input) INTEGER
   *          The order of the matrices A, B, VL, and VR.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
   *          On entry, the matrix A in the pair (A,B).
   *          On exit, A has been overwritten.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of A.  LDA >= max(1,N).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
   *          On entry, the matrix B in the pair (A,B).
   *          On exit, B has been overwritten.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of B.  LDB >= max(1,N).
   *
   *  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
   *  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
   *  BETA    (output) DOUBLE PRECISION array, dimension (N)
   *          On exit, (ALPHAR(j) + ALPHAI(j)*i)/BETA(j), j=1,...,N, will
   *          be the generalized eigenvalues.  If ALPHAI(j) is zero, then
   *          the j-th eigenvalue is real; if positive, then the j-th and
   *          (j+1)-st eigenvalues are a complex conjugate pair, with
   *          ALPHAI(j+1) negative.
   *
   *          Note: the quotients ALPHAR(j)/BETA(j) and ALPHAI(j)/BETA(j)
   *          may easily over- or underflow, and BETA(j) may even be zero.
   *          Thus, the user should avoid naively computing the ratio
   *          alpha/beta.  However, ALPHAR and ALPHAI will be always less
   *          than and usually comparable with norm(A) in magnitude, and
   *          BETA always less than and usually comparable with norm(B).
   *
   *  VL      (output) DOUBLE PRECISION array, dimension (LDVL,N)
   *          If JOBVL = 'V', the left eigenvectors u(j) are stored one
   *          after another in the columns of VL, in the same order as
   *          their eigenvalues. If the j-th eigenvalue is real, then
   *          u(j) = VL(:,j), the j-th column of VL. If the j-th and
   *          (j+1)-th eigenvalues form a complex conjugate pair, then
   *          u(j) = VL(:,j)+i*VL(:,j+1) and u(j+1) = VL(:,j)-i*VL(:,j+1).
   *          Each eigenvector is scaled so the largest component has
   *          abs(real part)+abs(imag. part)=1.
   *          Not referenced if JOBVL = 'N'.
   *
   *  LDVL    (input) INTEGER
   *          The leading dimension of the matrix VL. LDVL >= 1, and
   *          if JOBVL = 'V', LDVL >= N.
   *
   *  VR      (output) DOUBLE PRECISION array, dimension (LDVR,N)
   *          If JOBVR = 'V', the right eigenvectors v(j) are stored one
   *          after another in the columns of VR, in the same order as
   *          their eigenvalues. If the j-th eigenvalue is real, then
   *          v(j) = VR(:,j), the j-th column of VR. If the j-th and
   *          (j+1)-th eigenvalues form a complex conjugate pair, then
   *          v(j) = VR(:,j)+i*VR(:,j+1) and v(j+1) = VR(:,j)-i*VR(:,j+1).
   *          Each eigenvector is scaled so the largest component has
   *          abs(real part)+abs(imag. part)=1.
   *          Not referenced if JOBVR = 'N'.
   *
   *  LDVR    (input) INTEGER
   *          The leading dimension of the matrix VR. LDVR >= 1, and
   *          if JOBVR = 'V', LDVR >= N.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,8*N).
   *          For good performance, LWORK must generally be larger.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          = 1,...,N:
   *                The QZ iteration failed.  No eigenvectors have been
   *                calculated, but ALPHAR(j), ALPHAI(j), and BETA(j)
   *                should be correct for j=INFO+1,...,N.
   *          > N:  =N+1: other than QZ iteration failed in DHGEQZ.
   *                =N+2: error return from DTGEVC.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobvl
   * @param jobvr
   * @param n
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param alphar
   * @param alphai
   * @param beta
   * @param vl
   * @param ldvl
   * @param vr
   * @param ldvr
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dggev(java.lang.String jobvl, java.lang.String jobvr, int n, double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, double[] vl, int ldvl, double[] vr, int ldvr, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGEV computes for a pair of N-by-N real nonsymmetric matrices (A,B)
   *  the generalized eigenvalues, and optionally, the left and/or right
   *  generalized eigenvectors.
   *
   *  A generalized eigenvalue for a pair of matrices (A,B) is a scalar
   *  lambda or a ratio alpha/beta = lambda, such that A - lambda*B is
   *  singular. It is usually represented as the pair (alpha,beta), as
   *  there is a reasonable interpretation for beta=0, and even for both
   *  being zero.
   *
   *  The right eigenvector v(j) corresponding to the eigenvalue lambda(j)
   *  of (A,B) satisfies
   *
   *                   A * v(j) = lambda(j) * B * v(j).
   *
   *  The left eigenvector u(j) corresponding to the eigenvalue lambda(j)
   *  of (A,B) satisfies
   *
   *                   u(j)**H * A  = lambda(j) * u(j)**H * B .
   *
   *  where u(j)**H is the conjugate-transpose of u(j).
   *
   *
   *  Arguments
   *  =========
   *
   *  JOBVL   (input) CHARACTER*1
   *          = 'N':  do not compute the left generalized eigenvectors;
   *          = 'V':  compute the left generalized eigenvectors.
   *
   *  JOBVR   (input) CHARACTER*1
   *          = 'N':  do not compute the right generalized eigenvectors;
   *          = 'V':  compute the right generalized eigenvectors.
   *
   *  N       (input) INTEGER
   *          The order of the matrices A, B, VL, and VR.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
   *          On entry, the matrix A in the pair (A,B).
   *          On exit, A has been overwritten.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of A.  LDA >= max(1,N).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
   *          On entry, the matrix B in the pair (A,B).
   *          On exit, B has been overwritten.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of B.  LDB >= max(1,N).
   *
   *  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
   *  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
   *  BETA    (output) DOUBLE PRECISION array, dimension (N)
   *          On exit, (ALPHAR(j) + ALPHAI(j)*i)/BETA(j), j=1,...,N, will
   *          be the generalized eigenvalues.  If ALPHAI(j) is zero, then
   *          the j-th eigenvalue is real; if positive, then the j-th and
   *          (j+1)-st eigenvalues are a complex conjugate pair, with
   *          ALPHAI(j+1) negative.
   *
   *          Note: the quotients ALPHAR(j)/BETA(j) and ALPHAI(j)/BETA(j)
   *          may easily over- or underflow, and BETA(j) may even be zero.
   *          Thus, the user should avoid naively computing the ratio
   *          alpha/beta.  However, ALPHAR and ALPHAI will be always less
   *          than and usually comparable with norm(A) in magnitude, and
   *          BETA always less than and usually comparable with norm(B).
   *
   *  VL      (output) DOUBLE PRECISION array, dimension (LDVL,N)
   *          If JOBVL = 'V', the left eigenvectors u(j) are stored one
   *          after another in the columns of VL, in the same order as
   *          their eigenvalues. If the j-th eigenvalue is real, then
   *          u(j) = VL(:,j), the j-th column of VL. If the j-th and
   *          (j+1)-th eigenvalues form a complex conjugate pair, then
   *          u(j) = VL(:,j)+i*VL(:,j+1) and u(j+1) = VL(:,j)-i*VL(:,j+1).
   *          Each eigenvector is scaled so the largest component has
   *          abs(real part)+abs(imag. part)=1.
   *          Not referenced if JOBVL = 'N'.
   *
   *  LDVL    (input) INTEGER
   *          The leading dimension of the matrix VL. LDVL >= 1, and
   *          if JOBVL = 'V', LDVL >= N.
   *
   *  VR      (output) DOUBLE PRECISION array, dimension (LDVR,N)
   *          If JOBVR = 'V', the right eigenvectors v(j) are stored one
   *          after another in the columns of VR, in the same order as
   *          their eigenvalues. If the j-th eigenvalue is real, then
   *          v(j) = VR(:,j), the j-th column of VR. If the j-th and
   *          (j+1)-th eigenvalues form a complex conjugate pair, then
   *          v(j) = VR(:,j)+i*VR(:,j+1) and v(j+1) = VR(:,j)-i*VR(:,j+1).
   *          Each eigenvector is scaled so the largest component has
   *          abs(real part)+abs(imag. part)=1.
   *          Not referenced if JOBVR = 'N'.
   *
   *  LDVR    (input) INTEGER
   *          The leading dimension of the matrix VR. LDVR >= 1, and
   *          if JOBVR = 'V', LDVR >= N.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,8*N).
   *          For good performance, LWORK must generally be larger.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          = 1,...,N:
   *                The QZ iteration failed.  No eigenvectors have been
   *                calculated, but ALPHAR(j), ALPHAI(j), and BETA(j)
   *                should be correct for j=INFO+1,...,N.
   *          > N:  =N+1: other than QZ iteration failed in DHGEQZ.
   *                =N+2: error return from DTGEVC.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobvl
   * @param jobvr
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param alphar
   * @param _alphar_offset
   * @param alphai
   * @param _alphai_offset
   * @param beta
   * @param _beta_offset
   * @param vl
   * @param _vl_offset
   * @param ldvl
   * @param vr
   * @param _vr_offset
   * @param ldvr
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dggev(java.lang.String jobvl, java.lang.String jobvr, int n, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double[] alphar, int _alphar_offset, double[] alphai, int _alphai_offset, double[] beta, int _beta_offset, double[] vl, int _vl_offset, int ldvl, double[] vr, int _vr_offset, int ldvr, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGEVX computes for a pair of N-by-N real nonsymmetric matrices (A,B)
   *  the generalized eigenvalues, and optionally, the left and/or right
   *  generalized eigenvectors.
   *
   *  Optionally also, it computes a balancing transformation to improve
   *  the conditioning of the eigenvalues and eigenvectors (ILO, IHI,
   *  LSCALE, RSCALE, ABNRM, and BBNRM), reciprocal condition numbers for
   *  the eigenvalues (RCONDE), and reciprocal condition numbers for the
   *  right eigenvectors (RCONDV).
   *
   *  A generalized eigenvalue for a pair of matrices (A,B) is a scalar
   *  lambda or a ratio alpha/beta = lambda, such that A - lambda*B is
   *  singular. It is usually represented as the pair (alpha,beta), as
   *  there is a reasonable interpretation for beta=0, and even for both
   *  being zero.
   *
   *  The right eigenvector v(j) corresponding to the eigenvalue lambda(j)
   *  of (A,B) satisfies
   *
   *                   A * v(j) = lambda(j) * B * v(j) .
   *
   *  The left eigenvector u(j) corresponding to the eigenvalue lambda(j)
   *  of (A,B) satisfies
   *
   *                   u(j)**H * A  = lambda(j) * u(j)**H * B.
   *
   *  where u(j)**H is the conjugate-transpose of u(j).
   *
   *
   *  Arguments
   *  =========
   *
   *  BALANC  (input) CHARACTER*1
   *          Specifies the balance option to be performed.
   *          = 'N':  do not diagonally scale or permute;
   *          = 'P':  permute only;
   *          = 'S':  scale only;
   *          = 'B':  both permute and scale.
   *          Computed reciprocal condition numbers will be for the
   *          matrices after permuting and/or balancing. Permuting does
   *          not change condition numbers (in exact arithmetic), but
   *          balancing does.
   *
   *  JOBVL   (input) CHARACTER*1
   *          = 'N':  do not compute the left generalized eigenvectors;
   *          = 'V':  compute the left generalized eigenvectors.
   *
   *  JOBVR   (input) CHARACTER*1
   *          = 'N':  do not compute the right generalized eigenvectors;
   *          = 'V':  compute the right generalized eigenvectors.
   *
   *  SENSE   (input) CHARACTER*1
   *          Determines which reciprocal condition numbers are computed.
   *          = 'N': none are computed;
   *          = 'E': computed for eigenvalues only;
   *          = 'V': computed for eigenvectors only;
   *          = 'B': computed for eigenvalues and eigenvectors.
   *
   *  N       (input) INTEGER
   *          The order of the matrices A, B, VL, and VR.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
   *          On entry, the matrix A in the pair (A,B).
   *          On exit, A has been overwritten. If JOBVL='V' or JOBVR='V'
   *          or both, then A contains the first part of the real Schur
   *          form of the "balanced" versions of the input A and B.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of A.  LDA >= max(1,N).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
   *          On entry, the matrix B in the pair (A,B).
   *          On exit, B has been overwritten. If JOBVL='V' or JOBVR='V'
   *          or both, then B contains the second part of the real Schur
   *          form of the "balanced" versions of the input A and B.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of B.  LDB >= max(1,N).
   *
   *  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
   *  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
   *  BETA    (output) DOUBLE PRECISION array, dimension (N)
   *          On exit, (ALPHAR(j) + ALPHAI(j)*i)/BETA(j), j=1,...,N, will
   *          be the generalized eigenvalues.  If ALPHAI(j) is zero, then
   *          the j-th eigenvalue is real; if positive, then the j-th and
   *          (j+1)-st eigenvalues are a complex conjugate pair, with
   *          ALPHAI(j+1) negative.
   *
   *          Note: the quotients ALPHAR(j)/BETA(j) and ALPHAI(j)/BETA(j)
   *          may easily over- or underflow, and BETA(j) may even be zero.
   *          Thus, the user should avoid naively computing the ratio
   *          ALPHA/BETA. However, ALPHAR and ALPHAI will be always less
   *          than and usually comparable with norm(A) in magnitude, and
   *          BETA always less than and usually comparable with norm(B).
   *
   *  VL      (output) DOUBLE PRECISION array, dimension (LDVL,N)
   *          If JOBVL = 'V', the left eigenvectors u(j) are stored one
   *          after another in the columns of VL, in the same order as
   *          their eigenvalues. If the j-th eigenvalue is real, then
   *          u(j) = VL(:,j), the j-th column of VL. If the j-th and
   *          (j+1)-th eigenvalues form a complex conjugate pair, then
   *          u(j) = VL(:,j)+i*VL(:,j+1) and u(j+1) = VL(:,j)-i*VL(:,j+1).
   *          Each eigenvector will be scaled so the largest component have
   *          abs(real part) + abs(imag. part) = 1.
   *          Not referenced if JOBVL = 'N'.
   *
   *  LDVL    (input) INTEGER
   *          The leading dimension of the matrix VL. LDVL >= 1, and
   *          if JOBVL = 'V', LDVL >= N.
   *
   *  VR      (output) DOUBLE PRECISION array, dimension (LDVR,N)
   *          If JOBVR = 'V', the right eigenvectors v(j) are stored one
   *          after another in the columns of VR, in the same order as
   *          their eigenvalues. If the j-th eigenvalue is real, then
   *          v(j) = VR(:,j), the j-th column of VR. If the j-th and
   *          (j+1)-th eigenvalues form a complex conjugate pair, then
   *          v(j) = VR(:,j)+i*VR(:,j+1) and v(j+1) = VR(:,j)-i*VR(:,j+1).
   *          Each eigenvector will be scaled so the largest component have
   *          abs(real part) + abs(imag. part) = 1.
   *          Not referenced if JOBVR = 'N'.
   *
   *  LDVR    (input) INTEGER
   *          The leading dimension of the matrix VR. LDVR >= 1, and
   *          if JOBVR = 'V', LDVR >= N.
   *
   *  ILO     (output) INTEGER
   *  IHI     (output) INTEGER
   *          ILO and IHI are integer values such that on exit
   *          A(i,j) = 0 and B(i,j) = 0 if i > j and
   *          j = 1,...,ILO-1 or i = IHI+1,...,N.
   *          If BALANC = 'N' or 'S', ILO = 1 and IHI = N.
   *
   *  LSCALE  (output) DOUBLE PRECISION array, dimension (N)
   *          Details of the permutations and scaling factors applied
   *          to the left side of A and B.  If PL(j) is the index of the
   *          row interchanged with row j, and DL(j) is the scaling
   *          factor applied to row j, then
   *            LSCALE(j) = PL(j)  for j = 1,...,ILO-1
   *                      = DL(j)  for j = ILO,...,IHI
   *                      = PL(j)  for j = IHI+1,...,N.
   *          The order in which the interchanges are made is N to IHI+1,
   *          then 1 to ILO-1.
   *
   *  RSCALE  (output) DOUBLE PRECISION array, dimension (N)
   *          Details of the permutations and scaling factors applied
   *          to the right side of A and B.  If PR(j) is the index of the
   *          column interchanged with column j, and DR(j) is the scaling
   *          factor applied to column j, then
   *            RSCALE(j) = PR(j)  for j = 1,...,ILO-1
   *                      = DR(j)  for j = ILO,...,IHI
   *                      = PR(j)  for j = IHI+1,...,N
   *          The order in which the interchanges are made is N to IHI+1,
   *          then 1 to ILO-1.
   *
   *  ABNRM   (output) DOUBLE PRECISION
   *          The one-norm of the balanced matrix A.
   *
   *  BBNRM   (output) DOUBLE PRECISION
   *          The one-norm of the balanced matrix B.
   *
   *  RCONDE  (output) DOUBLE PRECISION array, dimension (N)
   *          If SENSE = 'E' or 'B', the reciprocal condition numbers of
   *          the eigenvalues, stored in consecutive elements of the array.
   *          For a complex conjugate pair of eigenvalues two consecutive
   *          elements of RCONDE are set to the same value. Thus RCONDE(j),
   *          RCONDV(j), and the j-th columns of VL and VR all correspond
   *          to the j-th eigenpair.
   *          If SENSE = 'N or 'V', RCONDE is not referenced.
   *
   *  RCONDV  (output) DOUBLE PRECISION array, dimension (N)
   *          If SENSE = 'V' or 'B', the estimated reciprocal condition
   *          numbers of the eigenvectors, stored in consecutive elements
   *          of the array. For a complex eigenvector two consecutive
   *          elements of RCONDV are set to the same value. If the
   *          eigenvalues cannot be reordered to compute RCONDV(j),
   *          RCONDV(j) is set to 0; this can only occur when the true
   *          value would be very small anyway.
   *          If SENSE = 'N' or 'E', RCONDV is not referenced.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK. LWORK >= max(1,2*N).
   *          If BALANC = 'S' or 'B', or JOBVL = 'V', or JOBVR = 'V',
   *          LWORK >= max(1,6*N).
   *          If SENSE = 'E' or 'B', LWORK >= max(1,10*N).
   *          If SENSE = 'V' or 'B', LWORK >= 2*N*N+8*N+16.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  IWORK   (workspace) INTEGER array, dimension (N+6)
   *          If SENSE = 'E', IWORK is not referenced.
   *
   *  BWORK   (workspace) LOGICAL array, dimension (N)
   *          If SENSE = 'N', BWORK is not referenced.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          = 1,...,N:
   *                The QZ iteration failed.  No eigenvectors have been
   *                calculated, but ALPHAR(j), ALPHAI(j), and BETA(j)
   *                should be correct for j=INFO+1,...,N.
   *          > N:  =N+1: other than QZ iteration failed in DHGEQZ.
   *                =N+2: error return from DTGEVC.
   *
   *  Further Details
   *  ===============
   *
   *  Balancing a matrix pair (A,B) includes, first, permuting rows and
   *  columns to isolate eigenvalues, second, applying diagonal similarity
   *  transformation to the rows and columns to make the rows and columns
   *  as close in norm as possible. The computed reciprocal condition
   *  numbers correspond to the balanced matrix. Permuting rows and columns
   *  will not change the condition numbers (in exact arithmetic) but
   *  diagonal scaling will.  For further explanation of balancing, see
   *  section 4.11.1.2 of LAPACK Users' Guide.
   *
   *  An approximate error bound on the chordal distance between the i-th
   *  computed generalized eigenvalue w and the corresponding exact
   *  eigenvalue lambda is
   *
   *       chord(w, lambda) <= EPS * norm(ABNRM, BBNRM) / RCONDE(I)
   *
   *  An approximate error bound for the angle between the i-th computed
   *  eigenvector VL(i) or VR(i) is given by
   *
   *       EPS * norm(ABNRM, BBNRM) / DIF(i).
   *
   *  For further explanation of the reciprocal condition numbers RCONDE
   *  and RCONDV, see section 4.11 of LAPACK User's Guide.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param balanc
   * @param jobvl
   * @param jobvr
   * @param sense
   * @param n
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param alphar
   * @param alphai
   * @param beta
   * @param vl
   * @param ldvl
   * @param vr
   * @param ldvr
   * @param ilo
   * @param ihi
   * @param lscale
   * @param rscale
   * @param abnrm
   * @param bbnrm
   * @param rconde
   * @param rcondv
   * @param work
   * @param lwork
   * @param iwork
   * @param bwork
   * @param info
   * 
   */
  abstract public void dggevx(java.lang.String balanc, java.lang.String jobvl, java.lang.String jobvr, java.lang.String sense, int n, double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, double[] vl, int ldvl, double[] vr, int ldvr, org.netlib.util.intW ilo, org.netlib.util.intW ihi, double[] lscale, double[] rscale, org.netlib.util.doubleW abnrm, org.netlib.util.doubleW bbnrm, double[] rconde, double[] rcondv, double[] work, int lwork, int[] iwork, boolean[] bwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGEVX computes for a pair of N-by-N real nonsymmetric matrices (A,B)
   *  the generalized eigenvalues, and optionally, the left and/or right
   *  generalized eigenvectors.
   *
   *  Optionally also, it computes a balancing transformation to improve
   *  the conditioning of the eigenvalues and eigenvectors (ILO, IHI,
   *  LSCALE, RSCALE, ABNRM, and BBNRM), reciprocal condition numbers for
   *  the eigenvalues (RCONDE), and reciprocal condition numbers for the
   *  right eigenvectors (RCONDV).
   *
   *  A generalized eigenvalue for a pair of matrices (A,B) is a scalar
   *  lambda or a ratio alpha/beta = lambda, such that A - lambda*B is
   *  singular. It is usually represented as the pair (alpha,beta), as
   *  there is a reasonable interpretation for beta=0, and even for both
   *  being zero.
   *
   *  The right eigenvector v(j) corresponding to the eigenvalue lambda(j)
   *  of (A,B) satisfies
   *
   *                   A * v(j) = lambda(j) * B * v(j) .
   *
   *  The left eigenvector u(j) corresponding to the eigenvalue lambda(j)
   *  of (A,B) satisfies
   *
   *                   u(j)**H * A  = lambda(j) * u(j)**H * B.
   *
   *  where u(j)**H is the conjugate-transpose of u(j).
   *
   *
   *  Arguments
   *  =========
   *
   *  BALANC  (input) CHARACTER*1
   *          Specifies the balance option to be performed.
   *          = 'N':  do not diagonally scale or permute;
   *          = 'P':  permute only;
   *          = 'S':  scale only;
   *          = 'B':  both permute and scale.
   *          Computed reciprocal condition numbers will be for the
   *          matrices after permuting and/or balancing. Permuting does
   *          not change condition numbers (in exact arithmetic), but
   *          balancing does.
   *
   *  JOBVL   (input) CHARACTER*1
   *          = 'N':  do not compute the left generalized eigenvectors;
   *          = 'V':  compute the left generalized eigenvectors.
   *
   *  JOBVR   (input) CHARACTER*1
   *          = 'N':  do not compute the right generalized eigenvectors;
   *          = 'V':  compute the right generalized eigenvectors.
   *
   *  SENSE   (input) CHARACTER*1
   *          Determines which reciprocal condition numbers are computed.
   *          = 'N': none are computed;
   *          = 'E': computed for eigenvalues only;
   *          = 'V': computed for eigenvectors only;
   *          = 'B': computed for eigenvalues and eigenvectors.
   *
   *  N       (input) INTEGER
   *          The order of the matrices A, B, VL, and VR.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
   *          On entry, the matrix A in the pair (A,B).
   *          On exit, A has been overwritten. If JOBVL='V' or JOBVR='V'
   *          or both, then A contains the first part of the real Schur
   *          form of the "balanced" versions of the input A and B.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of A.  LDA >= max(1,N).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
   *          On entry, the matrix B in the pair (A,B).
   *          On exit, B has been overwritten. If JOBVL='V' or JOBVR='V'
   *          or both, then B contains the second part of the real Schur
   *          form of the "balanced" versions of the input A and B.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of B.  LDB >= max(1,N).
   *
   *  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
   *  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
   *  BETA    (output) DOUBLE PRECISION array, dimension (N)
   *          On exit, (ALPHAR(j) + ALPHAI(j)*i)/BETA(j), j=1,...,N, will
   *          be the generalized eigenvalues.  If ALPHAI(j) is zero, then
   *          the j-th eigenvalue is real; if positive, then the j-th and
   *          (j+1)-st eigenvalues are a complex conjugate pair, with
   *          ALPHAI(j+1) negative.
   *
   *          Note: the quotients ALPHAR(j)/BETA(j) and ALPHAI(j)/BETA(j)
   *          may easily over- or underflow, and BETA(j) may even be zero.
   *          Thus, the user should avoid naively computing the ratio
   *          ALPHA/BETA. However, ALPHAR and ALPHAI will be always less
   *          than and usually comparable with norm(A) in magnitude, and
   *          BETA always less than and usually comparable with norm(B).
   *
   *  VL      (output) DOUBLE PRECISION array, dimension (LDVL,N)
   *          If JOBVL = 'V', the left eigenvectors u(j) are stored one
   *          after another in the columns of VL, in the same order as
   *          their eigenvalues. If the j-th eigenvalue is real, then
   *          u(j) = VL(:,j), the j-th column of VL. If the j-th and
   *          (j+1)-th eigenvalues form a complex conjugate pair, then
   *          u(j) = VL(:,j)+i*VL(:,j+1) and u(j+1) = VL(:,j)-i*VL(:,j+1).
   *          Each eigenvector will be scaled so the largest component have
   *          abs(real part) + abs(imag. part) = 1.
   *          Not referenced if JOBVL = 'N'.
   *
   *  LDVL    (input) INTEGER
   *          The leading dimension of the matrix VL. LDVL >= 1, and
   *          if JOBVL = 'V', LDVL >= N.
   *
   *  VR      (output) DOUBLE PRECISION array, dimension (LDVR,N)
   *          If JOBVR = 'V', the right eigenvectors v(j) are stored one
   *          after another in the columns of VR, in the same order as
   *          their eigenvalues. If the j-th eigenvalue is real, then
   *          v(j) = VR(:,j), the j-th column of VR. If the j-th and
   *          (j+1)-th eigenvalues form a complex conjugate pair, then
   *          v(j) = VR(:,j)+i*VR(:,j+1) and v(j+1) = VR(:,j)-i*VR(:,j+1).
   *          Each eigenvector will be scaled so the largest component have
   *          abs(real part) + abs(imag. part) = 1.
   *          Not referenced if JOBVR = 'N'.
   *
   *  LDVR    (input) INTEGER
   *          The leading dimension of the matrix VR. LDVR >= 1, and
   *          if JOBVR = 'V', LDVR >= N.
   *
   *  ILO     (output) INTEGER
   *  IHI     (output) INTEGER
   *          ILO and IHI are integer values such that on exit
   *          A(i,j) = 0 and B(i,j) = 0 if i > j and
   *          j = 1,...,ILO-1 or i = IHI+1,...,N.
   *          If BALANC = 'N' or 'S', ILO = 1 and IHI = N.
   *
   *  LSCALE  (output) DOUBLE PRECISION array, dimension (N)
   *          Details of the permutations and scaling factors applied
   *          to the left side of A and B.  If PL(j) is the index of the
   *          row interchanged with row j, and DL(j) is the scaling
   *          factor applied to row j, then
   *            LSCALE(j) = PL(j)  for j = 1,...,ILO-1
   *                      = DL(j)  for j = ILO,...,IHI
   *                      = PL(j)  for j = IHI+1,...,N.
   *          The order in which the interchanges are made is N to IHI+1,
   *          then 1 to ILO-1.
   *
   *  RSCALE  (output) DOUBLE PRECISION array, dimension (N)
   *          Details of the permutations and scaling factors applied
   *          to the right side of A and B.  If PR(j) is the index of the
   *          column interchanged with column j, and DR(j) is the scaling
   *          factor applied to column j, then
   *            RSCALE(j) = PR(j)  for j = 1,...,ILO-1
   *                      = DR(j)  for j = ILO,...,IHI
   *                      = PR(j)  for j = IHI+1,...,N
   *          The order in which the interchanges are made is N to IHI+1,
   *          then 1 to ILO-1.
   *
   *  ABNRM   (output) DOUBLE PRECISION
   *          The one-norm of the balanced matrix A.
   *
   *  BBNRM   (output) DOUBLE PRECISION
   *          The one-norm of the balanced matrix B.
   *
   *  RCONDE  (output) DOUBLE PRECISION array, dimension (N)
   *          If SENSE = 'E' or 'B', the reciprocal condition numbers of
   *          the eigenvalues, stored in consecutive elements of the array.
   *          For a complex conjugate pair of eigenvalues two consecutive
   *          elements of RCONDE are set to the same value. Thus RCONDE(j),
   *          RCONDV(j), and the j-th columns of VL and VR all correspond
   *          to the j-th eigenpair.
   *          If SENSE = 'N or 'V', RCONDE is not referenced.
   *
   *  RCONDV  (output) DOUBLE PRECISION array, dimension (N)
   *          If SENSE = 'V' or 'B', the estimated reciprocal condition
   *          numbers of the eigenvectors, stored in consecutive elements
   *          of the array. For a complex eigenvector two consecutive
   *          elements of RCONDV are set to the same value. If the
   *          eigenvalues cannot be reordered to compute RCONDV(j),
   *          RCONDV(j) is set to 0; this can only occur when the true
   *          value would be very small anyway.
   *          If SENSE = 'N' or 'E', RCONDV is not referenced.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK. LWORK >= max(1,2*N).
   *          If BALANC = 'S' or 'B', or JOBVL = 'V', or JOBVR = 'V',
   *          LWORK >= max(1,6*N).
   *          If SENSE = 'E' or 'B', LWORK >= max(1,10*N).
   *          If SENSE = 'V' or 'B', LWORK >= 2*N*N+8*N+16.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  IWORK   (workspace) INTEGER array, dimension (N+6)
   *          If SENSE = 'E', IWORK is not referenced.
   *
   *  BWORK   (workspace) LOGICAL array, dimension (N)
   *          If SENSE = 'N', BWORK is not referenced.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          = 1,...,N:
   *                The QZ iteration failed.  No eigenvectors have been
   *                calculated, but ALPHAR(j), ALPHAI(j), and BETA(j)
   *                should be correct for j=INFO+1,...,N.
   *          > N:  =N+1: other than QZ iteration failed in DHGEQZ.
   *                =N+2: error return from DTGEVC.
   *
   *  Further Details
   *  ===============
   *
   *  Balancing a matrix pair (A,B) includes, first, permuting rows and
   *  columns to isolate eigenvalues, second, applying diagonal similarity
   *  transformation to the rows and columns to make the rows and columns
   *  as close in norm as possible. The computed reciprocal condition
   *  numbers correspond to the balanced matrix. Permuting rows and columns
   *  will not change the condition numbers (in exact arithmetic) but
   *  diagonal scaling will.  For further explanation of balancing, see
   *  section 4.11.1.2 of LAPACK Users' Guide.
   *
   *  An approximate error bound on the chordal distance between the i-th
   *  computed generalized eigenvalue w and the corresponding exact
   *  eigenvalue lambda is
   *
   *       chord(w, lambda) <= EPS * norm(ABNRM, BBNRM) / RCONDE(I)
   *
   *  An approximate error bound for the angle between the i-th computed
   *  eigenvector VL(i) or VR(i) is given by
   *
   *       EPS * norm(ABNRM, BBNRM) / DIF(i).
   *
   *  For further explanation of the reciprocal condition numbers RCONDE
   *  and RCONDV, see section 4.11 of LAPACK User's Guide.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param balanc
   * @param jobvl
   * @param jobvr
   * @param sense
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param alphar
   * @param _alphar_offset
   * @param alphai
   * @param _alphai_offset
   * @param beta
   * @param _beta_offset
   * @param vl
   * @param _vl_offset
   * @param ldvl
   * @param vr
   * @param _vr_offset
   * @param ldvr
   * @param ilo
   * @param ihi
   * @param lscale
   * @param _lscale_offset
   * @param rscale
   * @param _rscale_offset
   * @param abnrm
   * @param bbnrm
   * @param rconde
   * @param _rconde_offset
   * @param rcondv
   * @param _rcondv_offset
   * @param work
   * @param _work_offset
   * @param lwork
   * @param iwork
   * @param _iwork_offset
   * @param bwork
   * @param _bwork_offset
   * @param info
   * 
   */
  abstract public void dggevx(java.lang.String balanc, java.lang.String jobvl, java.lang.String jobvr, java.lang.String sense, int n, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double[] alphar, int _alphar_offset, double[] alphai, int _alphai_offset, double[] beta, int _beta_offset, double[] vl, int _vl_offset, int ldvl, double[] vr, int _vr_offset, int ldvr, org.netlib.util.intW ilo, org.netlib.util.intW ihi, double[] lscale, int _lscale_offset, double[] rscale, int _rscale_offset, org.netlib.util.doubleW abnrm, org.netlib.util.doubleW bbnrm, double[] rconde, int _rconde_offset, double[] rcondv, int _rcondv_offset, double[] work, int _work_offset, int lwork, int[] iwork, int _iwork_offset, boolean[] bwork, int _bwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGGLM solves a general Gauss-Markov linear model (GLM) problem:
   *
   *          minimize || y ||_2   subject to   d = A*x + B*y
   *              x
   *
   *  where A is an N-by-M matrix, B is an N-by-P matrix, and d is a
   *  given N-vector. It is assumed that M <= N <= M+P, and
   *
   *             rank(A) = M    and    rank( A B ) = N.
   *
   *  Under these assumptions, the constrained equation is always
   *  consistent, and there is a unique solution x and a minimal 2-norm
   *  solution y, which is obtained using a generalized QR factorization
   *  of the matrices (A, B) given by
   *
   *     A = Q*(R),   B = Q*T*Z.
   *           (0)
   *
   *  In particular, if matrix B is square nonsingular, then the problem
   *  GLM is equivalent to the following weighted linear least squares
   *  problem
   *
   *               minimize || inv(B)*(d-A*x) ||_2
   *                   x
   *
   *  where inv(B) denotes the inverse of B.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The number of rows of the matrices A and B.  N >= 0.
   *
   *  M       (input) INTEGER
   *          The number of columns of the matrix A.  0 <= M <= N.
   *
   *  P       (input) INTEGER
   *          The number of columns of the matrix B.  P >= N-M.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,M)
   *          On entry, the N-by-M matrix A.
   *          On exit, the upper triangular part of the array A contains
   *          the M-by-M upper triangular matrix R.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A. LDA >= max(1,N).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,P)
   *          On entry, the N-by-P matrix B.
   *          On exit, if N <= P, the upper triangle of the subarray
   *          B(1:N,P-N+1:P) contains the N-by-N upper triangular matrix T;
   *          if N > P, the elements on and above the (N-P)th subdiagonal
   *          contain the N-by-P upper trapezoidal matrix T.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,N).
   *
   *  D       (input/output) DOUBLE PRECISION array, dimension (N)
   *          On entry, D is the left hand side of the GLM equation.
   *          On exit, D is destroyed.
   *
   *  X       (output) DOUBLE PRECISION array, dimension (M)
   *  Y       (output) DOUBLE PRECISION array, dimension (P)
   *          On exit, X and Y are the solutions of the GLM problem.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK. LWORK >= max(1,N+M+P).
   *          For optimum performance, LWORK >= M+min(N,P)+max(N,P)*NB,
   *          where NB is an upper bound for the optimal blocksizes for
   *          DGEQRF, SGERQF, DORMQR and SORMRQ.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          = 1:  the upper triangular factor R associated with A in the
   *                generalized QR factorization of the pair (A, B) is
   *                singular, so that rank(A) < M; the least squares
   *                solution could not be computed.
   *          = 2:  the bottom (N-M) by (N-M) part of the upper trapezoidal
   *                factor T associated with B in the generalized QR
   *                factorization of the pair (A, B) is singular, so that
   *                rank( A B ) < N; the least squares solution could not
   *                be computed.
   *
   *  ===================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param m
   * @param p
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param d
   * @param x
   * @param y
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dggglm(int n, int m, int p, double[] a, int lda, double[] b, int ldb, double[] d, double[] x, double[] y, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGGLM solves a general Gauss-Markov linear model (GLM) problem:
   *
   *          minimize || y ||_2   subject to   d = A*x + B*y
   *              x
   *
   *  where A is an N-by-M matrix, B is an N-by-P matrix, and d is a
   *  given N-vector. It is assumed that M <= N <= M+P, and
   *
   *             rank(A) = M    and    rank( A B ) = N.
   *
   *  Under these assumptions, the constrained equation is always
   *  consistent, and there is a unique solution x and a minimal 2-norm
   *  solution y, which is obtained using a generalized QR factorization
   *  of the matrices (A, B) given by
   *
   *     A = Q*(R),   B = Q*T*Z.
   *           (0)
   *
   *  In particular, if matrix B is square nonsingular, then the problem
   *  GLM is equivalent to the following weighted linear least squares
   *  problem
   *
   *               minimize || inv(B)*(d-A*x) ||_2
   *                   x
   *
   *  where inv(B) denotes the inverse of B.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The number of rows of the matrices A and B.  N >= 0.
   *
   *  M       (input) INTEGER
   *          The number of columns of the matrix A.  0 <= M <= N.
   *
   *  P       (input) INTEGER
   *          The number of columns of the matrix B.  P >= N-M.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,M)
   *          On entry, the N-by-M matrix A.
   *          On exit, the upper triangular part of the array A contains
   *          the M-by-M upper triangular matrix R.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A. LDA >= max(1,N).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,P)
   *          On entry, the N-by-P matrix B.
   *          On exit, if N <= P, the upper triangle of the subarray
   *          B(1:N,P-N+1:P) contains the N-by-N upper triangular matrix T;
   *          if N > P, the elements on and above the (N-P)th subdiagonal
   *          contain the N-by-P upper trapezoidal matrix T.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,N).
   *
   *  D       (input/output) DOUBLE PRECISION array, dimension (N)
   *          On entry, D is the left hand side of the GLM equation.
   *          On exit, D is destroyed.
   *
   *  X       (output) DOUBLE PRECISION array, dimension (M)
   *  Y       (output) DOUBLE PRECISION array, dimension (P)
   *          On exit, X and Y are the solutions of the GLM problem.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK. LWORK >= max(1,N+M+P).
   *          For optimum performance, LWORK >= M+min(N,P)+max(N,P)*NB,
   *          where NB is an upper bound for the optimal blocksizes for
   *          DGEQRF, SGERQF, DORMQR and SORMRQ.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          = 1:  the upper triangular factor R associated with A in the
   *                generalized QR factorization of the pair (A, B) is
   *                singular, so that rank(A) < M; the least squares
   *                solution could not be computed.
   *          = 2:  the bottom (N-M) by (N-M) part of the upper trapezoidal
   *                factor T associated with B in the generalized QR
   *                factorization of the pair (A, B) is singular, so that
   *                rank( A B ) < N; the least squares solution could not
   *                be computed.
   *
   *  ===================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param m
   * @param p
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param d
   * @param _d_offset
   * @param x
   * @param _x_offset
   * @param y
   * @param _y_offset
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dggglm(int n, int m, int p, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double[] d, int _d_offset, double[] x, int _x_offset, double[] y, int _y_offset, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGHRD reduces a pair of real matrices (A,B) to generalized upper
   *  Hessenberg form using orthogonal transformations, where A is a
   *  general matrix and B is upper triangular.  The form of the
   *  generalized eigenvalue problem is
   *     A*x = lambda*B*x,
   *  and B is typically made upper triangular by computing its QR
   *  factorization and moving the orthogonal matrix Q to the left side
   *  of the equation.
   *
   *  This subroutine simultaneously reduces A to a Hessenberg matrix H:
   *     Q**T*A*Z = H
   *  and transforms B to another upper triangular matrix T:
   *     Q**T*B*Z = T
   *  in order to reduce the problem to its standard form
   *     H*y = lambda*T*y
   *  where y = Z**T*x.
   *
   *  The orthogonal matrices Q and Z are determined as products of Givens
   *  rotations.  They may either be formed explicitly, or they may be
   *  postmultiplied into input matrices Q1 and Z1, so that
   *
   *       Q1 * A * Z1**T = (Q1*Q) * H * (Z1*Z)**T
   *
   *       Q1 * B * Z1**T = (Q1*Q) * T * (Z1*Z)**T
   *
   *  If Q1 is the orthogonal matrix from the QR factorization of B in the
   *  original equation A*x = lambda*B*x, then DGGHRD reduces the original
   *  problem to generalized Hessenberg form.
   *
   *  Arguments
   *  =========
   *
   *  COMPQ   (input) CHARACTER*1
   *          = 'N': do not compute Q;
   *          = 'I': Q is initialized to the unit matrix, and the
   *                 orthogonal matrix Q is returned;
   *          = 'V': Q must contain an orthogonal matrix Q1 on entry,
   *                 and the product Q1*Q is returned.
   *
   *  COMPZ   (input) CHARACTER*1
   *          = 'N': do not compute Z;
   *          = 'I': Z is initialized to the unit matrix, and the
   *                 orthogonal matrix Z is returned;
   *          = 'V': Z must contain an orthogonal matrix Z1 on entry,
   *                 and the product Z1*Z is returned.
   *
   *  N       (input) INTEGER
   *          The order of the matrices A and B.  N >= 0.
   *
   *  ILO     (input) INTEGER
   *  IHI     (input) INTEGER
   *          ILO and IHI mark the rows and columns of A which are to be
   *          reduced.  It is assumed that A is already upper triangular
   *          in rows and columns 1:ILO-1 and IHI+1:N.  ILO and IHI are
   *          normally set by a previous call to SGGBAL; otherwise they
   *          should be set to 1 and N respectively.
   *          1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
   *          On entry, the N-by-N general matrix to be reduced.
   *          On exit, the upper triangle and the first subdiagonal of A
   *          are overwritten with the upper Hessenberg matrix H, and the
   *          rest is set to zero.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
   *          On entry, the N-by-N upper triangular matrix B.
   *          On exit, the upper triangular matrix T = Q**T B Z.  The
   *          elements below the diagonal are set to zero.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  Q       (input/output) DOUBLE PRECISION array, dimension (LDQ, N)
   *          On entry, if COMPQ = 'V', the orthogonal matrix Q1,
   *          typically from the QR factorization of B.
   *          On exit, if COMPQ='I', the orthogonal matrix Q, and if
   *          COMPQ = 'V', the product Q1*Q.
   *          Not referenced if COMPQ='N'.
   *
   *  LDQ     (input) INTEGER
   *          The leading dimension of the array Q.
   *          LDQ >= N if COMPQ='V' or 'I'; LDQ >= 1 otherwise.
   *
   *  Z       (input/output) DOUBLE PRECISION array, dimension (LDZ, N)
   *          On entry, if COMPZ = 'V', the orthogonal matrix Z1.
   *          On exit, if COMPZ='I', the orthogonal matrix Z, and if
   *          COMPZ = 'V', the product Z1*Z.
   *          Not referenced if COMPZ='N'.
   *
   *  LDZ     (input) INTEGER
   *          The leading dimension of the array Z.
   *          LDZ >= N if COMPZ='V' or 'I'; LDZ >= 1 otherwise.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  This routine reduces A to Hessenberg and B to triangular form by
   *  an unblocked reduction, as described in _Matrix_Computations_,
   *  by Golub and Van Loan (Johns Hopkins Press.)
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param compq
   * @param compz
   * @param n
   * @param ilo
   * @param ihi
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param q
   * @param ldq
   * @param z
   * @param ldz
   * @param info
   * 
   */
  abstract public void dgghrd(java.lang.String compq, java.lang.String compz, int n, int ilo, int ihi, double[] a, int lda, double[] b, int ldb, double[] q, int ldq, double[] z, int ldz, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGHRD reduces a pair of real matrices (A,B) to generalized upper
   *  Hessenberg form using orthogonal transformations, where A is a
   *  general matrix and B is upper triangular.  The form of the
   *  generalized eigenvalue problem is
   *     A*x = lambda*B*x,
   *  and B is typically made upper triangular by computing its QR
   *  factorization and moving the orthogonal matrix Q to the left side
   *  of the equation.
   *
   *  This subroutine simultaneously reduces A to a Hessenberg matrix H:
   *     Q**T*A*Z = H
   *  and transforms B to another upper triangular matrix T:
   *     Q**T*B*Z = T
   *  in order to reduce the problem to its standard form
   *     H*y = lambda*T*y
   *  where y = Z**T*x.
   *
   *  The orthogonal matrices Q and Z are determined as products of Givens
   *  rotations.  They may either be formed explicitly, or they may be
   *  postmultiplied into input matrices Q1 and Z1, so that
   *
   *       Q1 * A * Z1**T = (Q1*Q) * H * (Z1*Z)**T
   *
   *       Q1 * B * Z1**T = (Q1*Q) * T * (Z1*Z)**T
   *
   *  If Q1 is the orthogonal matrix from the QR factorization of B in the
   *  original equation A*x = lambda*B*x, then DGGHRD reduces the original
   *  problem to generalized Hessenberg form.
   *
   *  Arguments
   *  =========
   *
   *  COMPQ   (input) CHARACTER*1
   *          = 'N': do not compute Q;
   *          = 'I': Q is initialized to the unit matrix, and the
   *                 orthogonal matrix Q is returned;
   *          = 'V': Q must contain an orthogonal matrix Q1 on entry,
   *                 and the product Q1*Q is returned.
   *
   *  COMPZ   (input) CHARACTER*1
   *          = 'N': do not compute Z;
   *          = 'I': Z is initialized to the unit matrix, and the
   *                 orthogonal matrix Z is returned;
   *          = 'V': Z must contain an orthogonal matrix Z1 on entry,
   *                 and the product Z1*Z is returned.
   *
   *  N       (input) INTEGER
   *          The order of the matrices A and B.  N >= 0.
   *
   *  ILO     (input) INTEGER
   *  IHI     (input) INTEGER
   *          ILO and IHI mark the rows and columns of A which are to be
   *          reduced.  It is assumed that A is already upper triangular
   *          in rows and columns 1:ILO-1 and IHI+1:N.  ILO and IHI are
   *          normally set by a previous call to SGGBAL; otherwise they
   *          should be set to 1 and N respectively.
   *          1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
   *          On entry, the N-by-N general matrix to be reduced.
   *          On exit, the upper triangle and the first subdiagonal of A
   *          are overwritten with the upper Hessenberg matrix H, and the
   *          rest is set to zero.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
   *          On entry, the N-by-N upper triangular matrix B.
   *          On exit, the upper triangular matrix T = Q**T B Z.  The
   *          elements below the diagonal are set to zero.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  Q       (input/output) DOUBLE PRECISION array, dimension (LDQ, N)
   *          On entry, if COMPQ = 'V', the orthogonal matrix Q1,
   *          typically from the QR factorization of B.
   *          On exit, if COMPQ='I', the orthogonal matrix Q, and if
   *          COMPQ = 'V', the product Q1*Q.
   *          Not referenced if COMPQ='N'.
   *
   *  LDQ     (input) INTEGER
   *          The leading dimension of the array Q.
   *          LDQ >= N if COMPQ='V' or 'I'; LDQ >= 1 otherwise.
   *
   *  Z       (input/output) DOUBLE PRECISION array, dimension (LDZ, N)
   *          On entry, if COMPZ = 'V', the orthogonal matrix Z1.
   *          On exit, if COMPZ='I', the orthogonal matrix Z, and if
   *          COMPZ = 'V', the product Z1*Z.
   *          Not referenced if COMPZ='N'.
   *
   *  LDZ     (input) INTEGER
   *          The leading dimension of the array Z.
   *          LDZ >= N if COMPZ='V' or 'I'; LDZ >= 1 otherwise.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  This routine reduces A to Hessenberg and B to triangular form by
   *  an unblocked reduction, as described in _Matrix_Computations_,
   *  by Golub and Van Loan (Johns Hopkins Press.)
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param compq
   * @param compz
   * @param n
   * @param ilo
   * @param ihi
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param q
   * @param _q_offset
   * @param ldq
   * @param z
   * @param _z_offset
   * @param ldz
   * @param info
   * 
   */
  abstract public void dgghrd(java.lang.String compq, java.lang.String compz, int n, int ilo, int ihi, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double[] q, int _q_offset, int ldq, double[] z, int _z_offset, int ldz, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGLSE solves the linear equality-constrained least squares (LSE)
   *  problem:
   *
   *          minimize || c - A*x ||_2   subject to   B*x = d
   *
   *  where A is an M-by-N matrix, B is a P-by-N matrix, c is a given
   *  M-vector, and d is a given P-vector. It is assumed that
   *  P <= N <= M+P, and
   *
   *           rank(B) = P and  rank( (A) ) = N.
   *                                ( (B) )
   *
   *  These conditions ensure that the LSE problem has a unique solution,
   *  which is obtained using a generalized RQ factorization of the
   *  matrices (B, A) given by
   *
   *     B = (0 R)*Q,   A = Z*T*Q.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrices A and B. N >= 0.
   *
   *  P       (input) INTEGER
   *          The number of rows of the matrix B. 0 <= P <= N <= M+P.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, the elements on and above the diagonal of the array
   *          contain the min(M,N)-by-N upper trapezoidal matrix T.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A. LDA >= max(1,M).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,N)
   *          On entry, the P-by-N matrix B.
   *          On exit, the upper triangle of the subarray B(1:P,N-P+1:N)
   *          contains the P-by-P upper triangular matrix R.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,P).
   *
   *  C       (input/output) DOUBLE PRECISION array, dimension (M)
   *          On entry, C contains the right hand side vector for the
   *          least squares part of the LSE problem.
   *          On exit, the residual sum of squares for the solution
   *          is given by the sum of squares of elements N-P+1 to M of
   *          vector C.
   *
   *  D       (input/output) DOUBLE PRECISION array, dimension (P)
   *          On entry, D contains the right hand side vector for the
   *          constrained equation.
   *          On exit, D is destroyed.
   *
   *  X       (output) DOUBLE PRECISION array, dimension (N)
   *          On exit, X is the solution of the LSE problem.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK. LWORK >= max(1,M+N+P).
   *          For optimum performance LWORK >= P+min(M,N)+max(M,N)*NB,
   *          where NB is an upper bound for the optimal blocksizes for
   *          DGEQRF, SGERQF, DORMQR and SORMRQ.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          = 1:  the upper triangular factor R associated with B in the
   *                generalized RQ factorization of the pair (B, A) is
   *                singular, so that rank(B) < P; the least squares
   *                solution could not be computed.
   *          = 2:  the (N-P) by (N-P) part of the upper trapezoidal factor
   *                T associated with A in the generalized RQ factorization
   *                of the pair (B, A) is singular, so that
   *                rank( (A) ) < N; the least squares solution could not
   *                    ( (B) )
   *                be computed.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param p
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param c
   * @param d
   * @param x
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgglse(int m, int n, int p, double[] a, int lda, double[] b, int ldb, double[] c, double[] d, double[] x, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGLSE solves the linear equality-constrained least squares (LSE)
   *  problem:
   *
   *          minimize || c - A*x ||_2   subject to   B*x = d
   *
   *  where A is an M-by-N matrix, B is a P-by-N matrix, c is a given
   *  M-vector, and d is a given P-vector. It is assumed that
   *  P <= N <= M+P, and
   *
   *           rank(B) = P and  rank( (A) ) = N.
   *                                ( (B) )
   *
   *  These conditions ensure that the LSE problem has a unique solution,
   *  which is obtained using a generalized RQ factorization of the
   *  matrices (B, A) given by
   *
   *     B = (0 R)*Q,   A = Z*T*Q.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrices A and B. N >= 0.
   *
   *  P       (input) INTEGER
   *          The number of rows of the matrix B. 0 <= P <= N <= M+P.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, the elements on and above the diagonal of the array
   *          contain the min(M,N)-by-N upper trapezoidal matrix T.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A. LDA >= max(1,M).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,N)
   *          On entry, the P-by-N matrix B.
   *          On exit, the upper triangle of the subarray B(1:P,N-P+1:N)
   *          contains the P-by-P upper triangular matrix R.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,P).
   *
   *  C       (input/output) DOUBLE PRECISION array, dimension (M)
   *          On entry, C contains the right hand side vector for the
   *          least squares part of the LSE problem.
   *          On exit, the residual sum of squares for the solution
   *          is given by the sum of squares of elements N-P+1 to M of
   *          vector C.
   *
   *  D       (input/output) DOUBLE PRECISION array, dimension (P)
   *          On entry, D contains the right hand side vector for the
   *          constrained equation.
   *          On exit, D is destroyed.
   *
   *  X       (output) DOUBLE PRECISION array, dimension (N)
   *          On exit, X is the solution of the LSE problem.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK. LWORK >= max(1,M+N+P).
   *          For optimum performance LWORK >= P+min(M,N)+max(M,N)*NB,
   *          where NB is an upper bound for the optimal blocksizes for
   *          DGEQRF, SGERQF, DORMQR and SORMRQ.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          = 1:  the upper triangular factor R associated with B in the
   *                generalized RQ factorization of the pair (B, A) is
   *                singular, so that rank(B) < P; the least squares
   *                solution could not be computed.
   *          = 2:  the (N-P) by (N-P) part of the upper trapezoidal factor
   *                T associated with A in the generalized RQ factorization
   *                of the pair (B, A) is singular, so that
   *                rank( (A) ) < N; the least squares solution could not
   *                    ( (B) )
   *                be computed.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param p
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param c
   * @param _c_offset
   * @param d
   * @param _d_offset
   * @param x
   * @param _x_offset
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dgglse(int m, int n, int p, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double[] c, int _c_offset, double[] d, int _d_offset, double[] x, int _x_offset, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGQRF computes a generalized QR factorization of an N-by-M matrix A
   *  and an N-by-P matrix B:
   *
   *              A = Q*R,        B = Q*T*Z,
   *
   *  where Q is an N-by-N orthogonal matrix, Z is a P-by-P orthogonal
   *  matrix, and R and T assume one of the forms:
   *
   *  if N >= M,  R = ( R11 ) M  ,   or if N < M,  R = ( R11  R12 ) N,
   *                  (  0  ) N-M                         N   M-N
   *                     M
   *
   *  where R11 is upper triangular, and
   *
   *  if N <= P,  T = ( 0  T12 ) N,   or if N > P,  T = ( T11 ) N-P,
   *                   P-N  N                           ( T21 ) P
   *                                                       P
   *
   *  where T12 or T21 is upper triangular.
   *
   *  In particular, if B is square and nonsingular, the GQR factorization
   *  of A and B implicitly gives the QR factorization of inv(B)*A:
   *
   *               inv(B)*A = Z'*(inv(T)*R)
   *
   *  where inv(B) denotes the inverse of the matrix B, and Z' denotes the
   *  transpose of the matrix Z.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The number of rows of the matrices A and B. N >= 0.
   *
   *  M       (input) INTEGER
   *          The number of columns of the matrix A.  M >= 0.
   *
   *  P       (input) INTEGER
   *          The number of columns of the matrix B.  P >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,M)
   *          On entry, the N-by-M matrix A.
   *          On exit, the elements on and above the diagonal of the array
   *          contain the min(N,M)-by-M upper trapezoidal matrix R (R is
   *          upper triangular if N >= M); the elements below the diagonal,
   *          with the array TAUA, represent the orthogonal matrix Q as a
   *          product of min(N,M) elementary reflectors (see Further
   *          Details).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A. LDA >= max(1,N).
   *
   *  TAUA    (output) DOUBLE PRECISION array, dimension (min(N,M))
   *          The scalar factors of the elementary reflectors which
   *          represent the orthogonal matrix Q (see Further Details).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,P)
   *          On entry, the N-by-P matrix B.
   *          On exit, if N <= P, the upper triangle of the subarray
   *          B(1:N,P-N+1:P) contains the N-by-N upper triangular matrix T;
   *          if N > P, the elements on and above the (N-P)-th subdiagonal
   *          contain the N-by-P upper trapezoidal matrix T; the remaining
   *          elements, with the array TAUB, represent the orthogonal
   *          matrix Z as a product of elementary reflectors (see Further
   *          Details).
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,N).
   *
   *  TAUB    (output) DOUBLE PRECISION array, dimension (min(N,P))
   *          The scalar factors of the elementary reflectors which
   *          represent the orthogonal matrix Z (see Further Details).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK. LWORK >= max(1,N,M,P).
   *          For optimum performance LWORK >= max(N,M,P)*max(NB1,NB2,NB3),
   *          where NB1 is the optimal blocksize for the QR factorization
   *          of an N-by-M matrix, NB2 is the optimal blocksize for the
   *          RQ factorization of an N-by-P matrix, and NB3 is the optimal
   *          blocksize for a call of DORMQR.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(1) H(2) . . . H(k), where k = min(n,m).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - taua * v * v'
   *
   *  where taua is a real scalar, and v is a real vector with
   *  v(1:i-1) = 0 and v(i) = 1; v(i+1:n) is stored on exit in A(i+1:n,i),
   *  and taua in TAUA(i).
   *  To form Q explicitly, use LAPACK subroutine DORGQR.
   *  To use Q to update another matrix, use LAPACK subroutine DORMQR.
   *
   *  The matrix Z is represented as a product of elementary reflectors
   *
   *     Z = H(1) H(2) . . . H(k), where k = min(n,p).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - taub * v * v'
   *
   *  where taub is a real scalar, and v is a real vector with
   *  v(p-k+i+1:p) = 0 and v(p-k+i) = 1; v(1:p-k+i-1) is stored on exit in
   *  B(n-k+i,1:p-k+i-1), and taub in TAUB(i).
   *  To form Z explicitly, use LAPACK subroutine DORGRQ.
   *  To use Z to update another matrix, use LAPACK subroutine DORMRQ.
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param m
   * @param p
   * @param a
   * @param lda
   * @param taua
   * @param b
   * @param ldb
   * @param taub
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dggqrf(int n, int m, int p, double[] a, int lda, double[] taua, double[] b, int ldb, double[] taub, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGQRF computes a generalized QR factorization of an N-by-M matrix A
   *  and an N-by-P matrix B:
   *
   *              A = Q*R,        B = Q*T*Z,
   *
   *  where Q is an N-by-N orthogonal matrix, Z is a P-by-P orthogonal
   *  matrix, and R and T assume one of the forms:
   *
   *  if N >= M,  R = ( R11 ) M  ,   or if N < M,  R = ( R11  R12 ) N,
   *                  (  0  ) N-M                         N   M-N
   *                     M
   *
   *  where R11 is upper triangular, and
   *
   *  if N <= P,  T = ( 0  T12 ) N,   or if N > P,  T = ( T11 ) N-P,
   *                   P-N  N                           ( T21 ) P
   *                                                       P
   *
   *  where T12 or T21 is upper triangular.
   *
   *  In particular, if B is square and nonsingular, the GQR factorization
   *  of A and B implicitly gives the QR factorization of inv(B)*A:
   *
   *               inv(B)*A = Z'*(inv(T)*R)
   *
   *  where inv(B) denotes the inverse of the matrix B, and Z' denotes the
   *  transpose of the matrix Z.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The number of rows of the matrices A and B. N >= 0.
   *
   *  M       (input) INTEGER
   *          The number of columns of the matrix A.  M >= 0.
   *
   *  P       (input) INTEGER
   *          The number of columns of the matrix B.  P >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,M)
   *          On entry, the N-by-M matrix A.
   *          On exit, the elements on and above the diagonal of the array
   *          contain the min(N,M)-by-M upper trapezoidal matrix R (R is
   *          upper triangular if N >= M); the elements below the diagonal,
   *          with the array TAUA, represent the orthogonal matrix Q as a
   *          product of min(N,M) elementary reflectors (see Further
   *          Details).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A. LDA >= max(1,N).
   *
   *  TAUA    (output) DOUBLE PRECISION array, dimension (min(N,M))
   *          The scalar factors of the elementary reflectors which
   *          represent the orthogonal matrix Q (see Further Details).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,P)
   *          On entry, the N-by-P matrix B.
   *          On exit, if N <= P, the upper triangle of the subarray
   *          B(1:N,P-N+1:P) contains the N-by-N upper triangular matrix T;
   *          if N > P, the elements on and above the (N-P)-th subdiagonal
   *          contain the N-by-P upper trapezoidal matrix T; the remaining
   *          elements, with the array TAUB, represent the orthogonal
   *          matrix Z as a product of elementary reflectors (see Further
   *          Details).
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,N).
   *
   *  TAUB    (output) DOUBLE PRECISION array, dimension (min(N,P))
   *          The scalar factors of the elementary reflectors which
   *          represent the orthogonal matrix Z (see Further Details).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK. LWORK >= max(1,N,M,P).
   *          For optimum performance LWORK >= max(N,M,P)*max(NB1,NB2,NB3),
   *          where NB1 is the optimal blocksize for the QR factorization
   *          of an N-by-M matrix, NB2 is the optimal blocksize for the
   *          RQ factorization of an N-by-P matrix, and NB3 is the optimal
   *          blocksize for a call of DORMQR.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(1) H(2) . . . H(k), where k = min(n,m).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - taua * v * v'
   *
   *  where taua is a real scalar, and v is a real vector with
   *  v(1:i-1) = 0 and v(i) = 1; v(i+1:n) is stored on exit in A(i+1:n,i),
   *  and taua in TAUA(i).
   *  To form Q explicitly, use LAPACK subroutine DORGQR.
   *  To use Q to update another matrix, use LAPACK subroutine DORMQR.
   *
   *  The matrix Z is represented as a product of elementary reflectors
   *
   *     Z = H(1) H(2) . . . H(k), where k = min(n,p).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - taub * v * v'
   *
   *  where taub is a real scalar, and v is a real vector with
   *  v(p-k+i+1:p) = 0 and v(p-k+i) = 1; v(1:p-k+i-1) is stored on exit in
   *  B(n-k+i,1:p-k+i-1), and taub in TAUB(i).
   *  To form Z explicitly, use LAPACK subroutine DORGRQ.
   *  To use Z to update another matrix, use LAPACK subroutine DORMRQ.
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param m
   * @param p
   * @param a
   * @param _a_offset
   * @param lda
   * @param taua
   * @param _taua_offset
   * @param b
   * @param _b_offset
   * @param ldb
   * @param taub
   * @param _taub_offset
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dggqrf(int n, int m, int p, double[] a, int _a_offset, int lda, double[] taua, int _taua_offset, double[] b, int _b_offset, int ldb, double[] taub, int _taub_offset, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGRQF computes a generalized RQ factorization of an M-by-N matrix A
   *  and a P-by-N matrix B:
   *
   *              A = R*Q,        B = Z*T*Q,
   *
   *  where Q is an N-by-N orthogonal matrix, Z is a P-by-P orthogonal
   *  matrix, and R and T assume one of the forms:
   *
   *  if M <= N,  R = ( 0  R12 ) M,   or if M > N,  R = ( R11 ) M-N,
   *                   N-M  M                           ( R21 ) N
   *                                                       N
   *
   *  where R12 or R21 is upper triangular, and
   *
   *  if P >= N,  T = ( T11 ) N  ,   or if P < N,  T = ( T11  T12 ) P,
   *                  (  0  ) P-N                         P   N-P
   *                     N
   *
   *  where T11 is upper triangular.
   *
   *  In particular, if B is square and nonsingular, the GRQ factorization
   *  of A and B implicitly gives the RQ factorization of A*inv(B):
   *
   *               A*inv(B) = (R*inv(T))*Z'
   *
   *  where inv(B) denotes the inverse of the matrix B, and Z' denotes the
   *  transpose of the matrix Z.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  P       (input) INTEGER
   *          The number of rows of the matrix B.  P >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrices A and B. N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, if M <= N, the upper triangle of the subarray
   *          A(1:M,N-M+1:N) contains the M-by-M upper triangular matrix R;
   *          if M > N, the elements on and above the (M-N)-th subdiagonal
   *          contain the M-by-N upper trapezoidal matrix R; the remaining
   *          elements, with the array TAUA, represent the orthogonal
   *          matrix Q as a product of elementary reflectors (see Further
   *          Details).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A. LDA >= max(1,M).
   *
   *  TAUA    (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors which
   *          represent the orthogonal matrix Q (see Further Details).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,N)
   *          On entry, the P-by-N matrix B.
   *          On exit, the elements on and above the diagonal of the array
   *          contain the min(P,N)-by-N upper trapezoidal matrix T (T is
   *          upper triangular if P >= N); the elements below the diagonal,
   *          with the array TAUB, represent the orthogonal matrix Z as a
   *          product of elementary reflectors (see Further Details).
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,P).
   *
   *  TAUB    (output) DOUBLE PRECISION array, dimension (min(P,N))
   *          The scalar factors of the elementary reflectors which
   *          represent the orthogonal matrix Z (see Further Details).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK. LWORK >= max(1,N,M,P).
   *          For optimum performance LWORK >= max(N,M,P)*max(NB1,NB2,NB3),
   *          where NB1 is the optimal blocksize for the RQ factorization
   *          of an M-by-N matrix, NB2 is the optimal blocksize for the
   *          QR factorization of a P-by-N matrix, and NB3 is the optimal
   *          blocksize for a call of DORMRQ.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INF0= -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(1) H(2) . . . H(k), where k = min(m,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - taua * v * v'
   *
   *  where taua is a real scalar, and v is a real vector with
   *  v(n-k+i+1:n) = 0 and v(n-k+i) = 1; v(1:n-k+i-1) is stored on exit in
   *  A(m-k+i,1:n-k+i-1), and taua in TAUA(i).
   *  To form Q explicitly, use LAPACK subroutine DORGRQ.
   *  To use Q to update another matrix, use LAPACK subroutine DORMRQ.
   *
   *  The matrix Z is represented as a product of elementary reflectors
   *
   *     Z = H(1) H(2) . . . H(k), where k = min(p,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - taub * v * v'
   *
   *  where taub is a real scalar, and v is a real vector with
   *  v(1:i-1) = 0 and v(i) = 1; v(i+1:p) is stored on exit in B(i+1:p,i),
   *  and taub in TAUB(i).
   *  To form Z explicitly, use LAPACK subroutine DORGQR.
   *  To use Z to update another matrix, use LAPACK subroutine DORMQR.
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param m
   * @param p
   * @param n
   * @param a
   * @param lda
   * @param taua
   * @param b
   * @param ldb
   * @param taub
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dggrqf(int m, int p, int n, double[] a, int lda, double[] taua, double[] b, int ldb, double[] taub, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGRQF computes a generalized RQ factorization of an M-by-N matrix A
   *  and a P-by-N matrix B:
   *
   *              A = R*Q,        B = Z*T*Q,
   *
   *  where Q is an N-by-N orthogonal matrix, Z is a P-by-P orthogonal
   *  matrix, and R and T assume one of the forms:
   *
   *  if M <= N,  R = ( 0  R12 ) M,   or if M > N,  R = ( R11 ) M-N,
   *                   N-M  M                           ( R21 ) N
   *                                                       N
   *
   *  where R12 or R21 is upper triangular, and
   *
   *  if P >= N,  T = ( T11 ) N  ,   or if P < N,  T = ( T11  T12 ) P,
   *                  (  0  ) P-N                         P   N-P
   *                     N
   *
   *  where T11 is upper triangular.
   *
   *  In particular, if B is square and nonsingular, the GRQ factorization
   *  of A and B implicitly gives the RQ factorization of A*inv(B):
   *
   *               A*inv(B) = (R*inv(T))*Z'
   *
   *  where inv(B) denotes the inverse of the matrix B, and Z' denotes the
   *  transpose of the matrix Z.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  P       (input) INTEGER
   *          The number of rows of the matrix B.  P >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrices A and B. N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, if M <= N, the upper triangle of the subarray
   *          A(1:M,N-M+1:N) contains the M-by-M upper triangular matrix R;
   *          if M > N, the elements on and above the (M-N)-th subdiagonal
   *          contain the M-by-N upper trapezoidal matrix R; the remaining
   *          elements, with the array TAUA, represent the orthogonal
   *          matrix Q as a product of elementary reflectors (see Further
   *          Details).
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A. LDA >= max(1,M).
   *
   *  TAUA    (output) DOUBLE PRECISION array, dimension (min(M,N))
   *          The scalar factors of the elementary reflectors which
   *          represent the orthogonal matrix Q (see Further Details).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,N)
   *          On entry, the P-by-N matrix B.
   *          On exit, the elements on and above the diagonal of the array
   *          contain the min(P,N)-by-N upper trapezoidal matrix T (T is
   *          upper triangular if P >= N); the elements below the diagonal,
   *          with the array TAUB, represent the orthogonal matrix Z as a
   *          product of elementary reflectors (see Further Details).
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,P).
   *
   *  TAUB    (output) DOUBLE PRECISION array, dimension (min(P,N))
   *          The scalar factors of the elementary reflectors which
   *          represent the orthogonal matrix Z (see Further Details).
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK. LWORK >= max(1,N,M,P).
   *          For optimum performance LWORK >= max(N,M,P)*max(NB1,NB2,NB3),
   *          where NB1 is the optimal blocksize for the RQ factorization
   *          of an M-by-N matrix, NB2 is the optimal blocksize for the
   *          QR factorization of a P-by-N matrix, and NB3 is the optimal
   *          blocksize for a call of DORMRQ.
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INF0= -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of elementary reflectors
   *
   *     Q = H(1) H(2) . . . H(k), where k = min(m,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - taua * v * v'
   *
   *  where taua is a real scalar, and v is a real vector with
   *  v(n-k+i+1:n) = 0 and v(n-k+i) = 1; v(1:n-k+i-1) is stored on exit in
   *  A(m-k+i,1:n-k+i-1), and taua in TAUA(i).
   *  To form Q explicitly, use LAPACK subroutine DORGRQ.
   *  To use Q to update another matrix, use LAPACK subroutine DORMRQ.
   *
   *  The matrix Z is represented as a product of elementary reflectors
   *
   *     Z = H(1) H(2) . . . H(k), where k = min(p,n).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - taub * v * v'
   *
   *  where taub is a real scalar, and v is a real vector with
   *  v(1:i-1) = 0 and v(i) = 1; v(i+1:p) is stored on exit in B(i+1:p,i),
   *  and taub in TAUB(i).
   *  To form Z explicitly, use LAPACK subroutine DORGQR.
   *  To use Z to update another matrix, use LAPACK subroutine DORMQR.
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param m
   * @param p
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param taua
   * @param _taua_offset
   * @param b
   * @param _b_offset
   * @param ldb
   * @param taub
   * @param _taub_offset
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dggrqf(int m, int p, int n, double[] a, int _a_offset, int lda, double[] taua, int _taua_offset, double[] b, int _b_offset, int ldb, double[] taub, int _taub_offset, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGSVD computes the generalized singular value decomposition (GSVD)
   *  of an M-by-N real matrix A and P-by-N real matrix B:
   *
   *      U'*A*Q = D1*( 0 R ),    V'*B*Q = D2*( 0 R )
   *
   *  where U, V and Q are orthogonal matrices, and Z' is the transpose
   *  of Z.  Let K+L = the effective numerical rank of the matrix (A',B')',
   *  then R is a K+L-by-K+L nonsingular upper triangular matrix, D1 and
   *  D2 are M-by-(K+L) and P-by-(K+L) "diagonal" matrices and of the
   *  following structures, respectively:
   *
   *  If M-K-L >= 0,
   *
   *                      K  L
   *         D1 =     K ( I  0 )
   *                  L ( 0  C )
   *              M-K-L ( 0  0 )
   *
   *                    K  L
   *         D2 =   L ( 0  S )
   *              P-L ( 0  0 )
   *
   *                  N-K-L  K    L
   *    ( 0 R ) = K (  0   R11  R12 )
   *              L (  0    0   R22 )
   *
   *  where
   *
   *    C = diag( ALPHA(K+1), ... , ALPHA(K+L) ),
   *    S = diag( BETA(K+1),  ... , BETA(K+L) ),
   *    C**2 + S**2 = I.
   *
   *    R is stored in A(1:K+L,N-K-L+1:N) on exit.
   *
   *  If M-K-L < 0,
   *
   *                    K M-K K+L-M
   *         D1 =   K ( I  0    0   )
   *              M-K ( 0  C    0   )
   *
   *                      K M-K K+L-M
   *         D2 =   M-K ( 0  S    0  )
   *              K+L-M ( 0  0    I  )
   *                P-L ( 0  0    0  )
   *
   *                     N-K-L  K   M-K  K+L-M
   *    ( 0 R ) =     K ( 0    R11  R12  R13  )
   *                M-K ( 0     0   R22  R23  )
   *              K+L-M ( 0     0    0   R33  )
   *
   *  where
   *
   *    C = diag( ALPHA(K+1), ... , ALPHA(M) ),
   *    S = diag( BETA(K+1),  ... , BETA(M) ),
   *    C**2 + S**2 = I.
   *
   *    (R11 R12 R13 ) is stored in A(1:M, N-K-L+1:N), and R33 is stored
   *    ( 0  R22 R23 )
   *    in B(M-K+1:L,N+M-K-L+1:N) on exit.
   *
   *  The routine computes C, S, R, and optionally the orthogonal
   *  transformation matrices U, V and Q.
   *
   *  In particular, if B is an N-by-N nonsingular matrix, then the GSVD of
   *  A and B implicitly gives the SVD of A*inv(B):
   *                       A*inv(B) = U*(D1*inv(D2))*V'.
   *  If ( A',B')' has orthonormal columns, then the GSVD of A and B is
   *  also equal to the CS decomposition of A and B. Furthermore, the GSVD
   *  can be used to derive the solution of the eigenvalue problem:
   *                       A'*A x = lambda* B'*B x.
   *  In some literature, the GSVD of A and B is presented in the form
   *                   U'*A*X = ( 0 D1 ),   V'*B*X = ( 0 D2 )
   *  where U and V are orthogonal and X is nonsingular, D1 and D2 are
   *  ``diagonal''.  The former GSVD form can be converted to the latter
   *  form by taking the nonsingular matrix X as
   *
   *                       X = Q*( I   0    )
   *                             ( 0 inv(R) ).
   *
   *  Arguments
   *  =========
   *
   *  JOBU    (input) CHARACTER*1
   *          = 'U':  Orthogonal matrix U is computed;
   *          = 'N':  U is not computed.
   *
   *  JOBV    (input) CHARACTER*1
   *          = 'V':  Orthogonal matrix V is computed;
   *          = 'N':  V is not computed.
   *
   *  JOBQ    (input) CHARACTER*1
   *          = 'Q':  Orthogonal matrix Q is computed;
   *          = 'N':  Q is not computed.
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrices A and B.  N >= 0.
   *
   *  P       (input) INTEGER
   *          The number of rows of the matrix B.  P >= 0.
   *
   *  K       (output) INTEGER
   *  L       (output) INTEGER
   *          On exit, K and L specify the dimension of the subblocks
   *          described in the Purpose section.
   *          K + L = effective numerical rank of (A',B')'.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, A contains the triangular matrix R, or part of R.
   *          See Purpose for details.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A. LDA >= max(1,M).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,N)
   *          On entry, the P-by-N matrix B.
   *          On exit, B contains the triangular matrix R if M-K-L < 0.
   *          See Purpose for details.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,P).
   *
   *  ALPHA   (output) DOUBLE PRECISION array, dimension (N)
   *  BETA    (output) DOUBLE PRECISION array, dimension (N)
   *          On exit, ALPHA and BETA contain the generalized singular
   *          value pairs of A and B;
   *            ALPHA(1:K) = 1,
   *            BETA(1:K)  = 0,
   *          and if M-K-L >= 0,
   *            ALPHA(K+1:K+L) = C,
   *            BETA(K+1:K+L)  = S,
   *          or if M-K-L < 0,
   *            ALPHA(K+1:M)=C, ALPHA(M+1:K+L)=0
   *            BETA(K+1:M) =S, BETA(M+1:K+L) =1
   *          and
   *            ALPHA(K+L+1:N) = 0
   *            BETA(K+L+1:N)  = 0
   *
   *  U       (output) DOUBLE PRECISION array, dimension (LDU,M)
   *          If JOBU = 'U', U contains the M-by-M orthogonal matrix U.
   *          If JOBU = 'N', U is not referenced.
   *
   *  LDU     (input) INTEGER
   *          The leading dimension of the array U. LDU >= max(1,M) if
   *          JOBU = 'U'; LDU >= 1 otherwise.
   *
   *  V       (output) DOUBLE PRECISION array, dimension (LDV,P)
   *          If JOBV = 'V', V contains the P-by-P orthogonal matrix V.
   *          If JOBV = 'N', V is not referenced.
   *
   *  LDV     (input) INTEGER
   *          The leading dimension of the array V. LDV >= max(1,P) if
   *          JOBV = 'V'; LDV >= 1 otherwise.
   *
   *  Q       (output) DOUBLE PRECISION array, dimension (LDQ,N)
   *          If JOBQ = 'Q', Q contains the N-by-N orthogonal matrix Q.
   *          If JOBQ = 'N', Q is not referenced.
   *
   *  LDQ     (input) INTEGER
   *          The leading dimension of the array Q. LDQ >= max(1,N) if
   *          JOBQ = 'Q'; LDQ >= 1 otherwise.
   *
   *  WORK    (workspace) DOUBLE PRECISION array,
   *                      dimension (max(3*N,M,P)+N)
   *
   *  IWORK   (workspace/output) INTEGER array, dimension (N)
   *          On exit, IWORK stores the sorting information. More
   *          precisely, the following loop will sort ALPHA
   *             for I = K+1, min(M,K+L)
   *                 swap ALPHA(I) and ALPHA(IWORK(I))
   *             endfor
   *          such that ALPHA(1) >= ALPHA(2) >= ... >= ALPHA(N).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  if INFO = 1, the Jacobi-type procedure failed to
   *                converge.  For further details, see subroutine DTGSJA.
   *
   *  Internal Parameters
   *  ===================
   *
   *  TOLA    DOUBLE PRECISION
   *  TOLB    DOUBLE PRECISION
   *          TOLA and TOLB are the thresholds to determine the effective
   *          rank of (A',B')'. Generally, they are set to
   *                   TOLA = MAX(M,N)*norm(A)*MAZHEPS,
   *                   TOLB = MAX(P,N)*norm(B)*MAZHEPS.
   *          The size of TOLA and TOLB may affect the size of backward
   *          errors of the decomposition.
   *
   *  Further Details
   *  ===============
   *
   *  2-96 Based on modifications by
   *     Ming Gu and Huan Ren, Computer Science Division, University of
   *     California at Berkeley, USA
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param jobu
   * @param jobv
   * @param jobq
   * @param m
   * @param n
   * @param p
   * @param k
   * @param l
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param alpha
   * @param beta
   * @param u
   * @param ldu
   * @param v
   * @param ldv
   * @param q
   * @param ldq
   * @param work
   * @param iwork
   * @param info
   * 
   */
  abstract public void dggsvd(java.lang.String jobu, java.lang.String jobv, java.lang.String jobq, int m, int n, int p, org.netlib.util.intW k, org.netlib.util.intW l, double[] a, int lda, double[] b, int ldb, double[] alpha, double[] beta, double[] u, int ldu, double[] v, int ldv, double[] q, int ldq, double[] work, int[] iwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGSVD computes the generalized singular value decomposition (GSVD)
   *  of an M-by-N real matrix A and P-by-N real matrix B:
   *
   *      U'*A*Q = D1*( 0 R ),    V'*B*Q = D2*( 0 R )
   *
   *  where U, V and Q are orthogonal matrices, and Z' is the transpose
   *  of Z.  Let K+L = the effective numerical rank of the matrix (A',B')',
   *  then R is a K+L-by-K+L nonsingular upper triangular matrix, D1 and
   *  D2 are M-by-(K+L) and P-by-(K+L) "diagonal" matrices and of the
   *  following structures, respectively:
   *
   *  If M-K-L >= 0,
   *
   *                      K  L
   *         D1 =     K ( I  0 )
   *                  L ( 0  C )
   *              M-K-L ( 0  0 )
   *
   *                    K  L
   *         D2 =   L ( 0  S )
   *              P-L ( 0  0 )
   *
   *                  N-K-L  K    L
   *    ( 0 R ) = K (  0   R11  R12 )
   *              L (  0    0   R22 )
   *
   *  where
   *
   *    C = diag( ALPHA(K+1), ... , ALPHA(K+L) ),
   *    S = diag( BETA(K+1),  ... , BETA(K+L) ),
   *    C**2 + S**2 = I.
   *
   *    R is stored in A(1:K+L,N-K-L+1:N) on exit.
   *
   *  If M-K-L < 0,
   *
   *                    K M-K K+L-M
   *         D1 =   K ( I  0    0   )
   *              M-K ( 0  C    0   )
   *
   *                      K M-K K+L-M
   *         D2 =   M-K ( 0  S    0  )
   *              K+L-M ( 0  0    I  )
   *                P-L ( 0  0    0  )
   *
   *                     N-K-L  K   M-K  K+L-M
   *    ( 0 R ) =     K ( 0    R11  R12  R13  )
   *                M-K ( 0     0   R22  R23  )
   *              K+L-M ( 0     0    0   R33  )
   *
   *  where
   *
   *    C = diag( ALPHA(K+1), ... , ALPHA(M) ),
   *    S = diag( BETA(K+1),  ... , BETA(M) ),
   *    C**2 + S**2 = I.
   *
   *    (R11 R12 R13 ) is stored in A(1:M, N-K-L+1:N), and R33 is stored
   *    ( 0  R22 R23 )
   *    in B(M-K+1:L,N+M-K-L+1:N) on exit.
   *
   *  The routine computes C, S, R, and optionally the orthogonal
   *  transformation matrices U, V and Q.
   *
   *  In particular, if B is an N-by-N nonsingular matrix, then the GSVD of
   *  A and B implicitly gives the SVD of A*inv(B):
   *                       A*inv(B) = U*(D1*inv(D2))*V'.
   *  If ( A',B')' has orthonormal columns, then the GSVD of A and B is
   *  also equal to the CS decomposition of A and B. Furthermore, the GSVD
   *  can be used to derive the solution of the eigenvalue problem:
   *                       A'*A x = lambda* B'*B x.
   *  In some literature, the GSVD of A and B is presented in the form
   *                   U'*A*X = ( 0 D1 ),   V'*B*X = ( 0 D2 )
   *  where U and V are orthogonal and X is nonsingular, D1 and D2 are
   *  ``diagonal''.  The former GSVD form can be converted to the latter
   *  form by taking the nonsingular matrix X as
   *
   *                       X = Q*( I   0    )
   *                             ( 0 inv(R) ).
   *
   *  Arguments
   *  =========
   *
   *  JOBU    (input) CHARACTER*1
   *          = 'U':  Orthogonal matrix U is computed;
   *          = 'N':  U is not computed.
   *
   *  JOBV    (input) CHARACTER*1
   *          = 'V':  Orthogonal matrix V is computed;
   *          = 'N':  V is not computed.
   *
   *  JOBQ    (input) CHARACTER*1
   *          = 'Q':  Orthogonal matrix Q is computed;
   *          = 'N':  Q is not computed.
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrices A and B.  N >= 0.
   *
   *  P       (input) INTEGER
   *          The number of rows of the matrix B.  P >= 0.
   *
   *  K       (output) INTEGER
   *  L       (output) INTEGER
   *          On exit, K and L specify the dimension of the subblocks
   *          described in the Purpose section.
   *          K + L = effective numerical rank of (A',B')'.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, A contains the triangular matrix R, or part of R.
   *          See Purpose for details.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A. LDA >= max(1,M).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,N)
   *          On entry, the P-by-N matrix B.
   *          On exit, B contains the triangular matrix R if M-K-L < 0.
   *          See Purpose for details.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,P).
   *
   *  ALPHA   (output) DOUBLE PRECISION array, dimension (N)
   *  BETA    (output) DOUBLE PRECISION array, dimension (N)
   *          On exit, ALPHA and BETA contain the generalized singular
   *          value pairs of A and B;
   *            ALPHA(1:K) = 1,
   *            BETA(1:K)  = 0,
   *          and if M-K-L >= 0,
   *            ALPHA(K+1:K+L) = C,
   *            BETA(K+1:K+L)  = S,
   *          or if M-K-L < 0,
   *            ALPHA(K+1:M)=C, ALPHA(M+1:K+L)=0
   *            BETA(K+1:M) =S, BETA(M+1:K+L) =1
   *          and
   *            ALPHA(K+L+1:N) = 0
   *            BETA(K+L+1:N)  = 0
   *
   *  U       (output) DOUBLE PRECISION array, dimension (LDU,M)
   *          If JOBU = 'U', U contains the M-by-M orthogonal matrix U.
   *          If JOBU = 'N', U is not referenced.
   *
   *  LDU     (input) INTEGER
   *          The leading dimension of the array U. LDU >= max(1,M) if
   *          JOBU = 'U'; LDU >= 1 otherwise.
   *
   *  V       (output) DOUBLE PRECISION array, dimension (LDV,P)
   *          If JOBV = 'V', V contains the P-by-P orthogonal matrix V.
   *          If JOBV = 'N', V is not referenced.
   *
   *  LDV     (input) INTEGER
   *          The leading dimension of the array V. LDV >= max(1,P) if
   *          JOBV = 'V'; LDV >= 1 otherwise.
   *
   *  Q       (output) DOUBLE PRECISION array, dimension (LDQ,N)
   *          If JOBQ = 'Q', Q contains the N-by-N orthogonal matrix Q.
   *          If JOBQ = 'N', Q is not referenced.
   *
   *  LDQ     (input) INTEGER
   *          The leading dimension of the array Q. LDQ >= max(1,N) if
   *          JOBQ = 'Q'; LDQ >= 1 otherwise.
   *
   *  WORK    (workspace) DOUBLE PRECISION array,
   *                      dimension (max(3*N,M,P)+N)
   *
   *  IWORK   (workspace/output) INTEGER array, dimension (N)
   *          On exit, IWORK stores the sorting information. More
   *          precisely, the following loop will sort ALPHA
   *             for I = K+1, min(M,K+L)
   *                 swap ALPHA(I) and ALPHA(IWORK(I))
   *             endfor
   *          such that ALPHA(1) >= ALPHA(2) >= ... >= ALPHA(N).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  if INFO = 1, the Jacobi-type procedure failed to
   *                converge.  For further details, see subroutine DTGSJA.
   *
   *  Internal Parameters
   *  ===================
   *
   *  TOLA    DOUBLE PRECISION
   *  TOLB    DOUBLE PRECISION
   *          TOLA and TOLB are the thresholds to determine the effective
   *          rank of (A',B')'. Generally, they are set to
   *                   TOLA = MAX(M,N)*norm(A)*MAZHEPS,
   *                   TOLB = MAX(P,N)*norm(B)*MAZHEPS.
   *          The size of TOLA and TOLB may affect the size of backward
   *          errors of the decomposition.
   *
   *  Further Details
   *  ===============
   *
   *  2-96 Based on modifications by
   *     Ming Gu and Huan Ren, Computer Science Division, University of
   *     California at Berkeley, USA
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param jobu
   * @param jobv
   * @param jobq
   * @param m
   * @param n
   * @param p
   * @param k
   * @param l
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param alpha
   * @param _alpha_offset
   * @param beta
   * @param _beta_offset
   * @param u
   * @param _u_offset
   * @param ldu
   * @param v
   * @param _v_offset
   * @param ldv
   * @param q
   * @param _q_offset
   * @param ldq
   * @param work
   * @param _work_offset
   * @param iwork
   * @param _iwork_offset
   * @param info
   * 
   */
  abstract public void dggsvd(java.lang.String jobu, java.lang.String jobv, java.lang.String jobq, int m, int n, int p, org.netlib.util.intW k, org.netlib.util.intW l, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double[] alpha, int _alpha_offset, double[] beta, int _beta_offset, double[] u, int _u_offset, int ldu, double[] v, int _v_offset, int ldv, double[] q, int _q_offset, int ldq, double[] work, int _work_offset, int[] iwork, int _iwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGSVP computes orthogonal matrices U, V and Q such that
   *
   *                   N-K-L  K    L
   *   U'*A*Q =     K ( 0    A12  A13 )  if M-K-L >= 0;
   *                L ( 0     0   A23 )
   *            M-K-L ( 0     0    0  )
   *
   *                   N-K-L  K    L
   *          =     K ( 0    A12  A13 )  if M-K-L < 0;
   *              M-K ( 0     0   A23 )
   *
   *                 N-K-L  K    L
   *   V'*B*Q =   L ( 0     0   B13 )
   *            P-L ( 0     0    0  )
   *
   *  where the K-by-K matrix A12 and L-by-L matrix B13 are nonsingular
   *  upper triangular; A23 is L-by-L upper triangular if M-K-L >= 0,
   *  otherwise A23 is (M-K)-by-L upper trapezoidal.  K+L = the effective
   *  numerical rank of the (M+P)-by-N matrix (A',B')'.  Z' denotes the
   *  transpose of Z.
   *
   *  This decomposition is the preprocessing step for computing the
   *  Generalized Singular Value Decomposition (GSVD), see subroutine
   *  DGGSVD.
   *
   *  Arguments
   *  =========
   *
   *  JOBU    (input) CHARACTER*1
   *          = 'U':  Orthogonal matrix U is computed;
   *          = 'N':  U is not computed.
   *
   *  JOBV    (input) CHARACTER*1
   *          = 'V':  Orthogonal matrix V is computed;
   *          = 'N':  V is not computed.
   *
   *  JOBQ    (input) CHARACTER*1
   *          = 'Q':  Orthogonal matrix Q is computed;
   *          = 'N':  Q is not computed.
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  P       (input) INTEGER
   *          The number of rows of the matrix B.  P >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrices A and B.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, A contains the triangular (or trapezoidal) matrix
   *          described in the Purpose section.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A. LDA >= max(1,M).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,N)
   *          On entry, the P-by-N matrix B.
   *          On exit, B contains the triangular matrix described in
   *          the Purpose section.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,P).
   *
   *  TOLA    (input) DOUBLE PRECISION
   *  TOLB    (input) DOUBLE PRECISION
   *          TOLA and TOLB are the thresholds to determine the effective
   *          numerical rank of matrix B and a subblock of A. Generally,
   *          they are set to
   *             TOLA = MAX(M,N)*norm(A)*MAZHEPS,
   *             TOLB = MAX(P,N)*norm(B)*MAZHEPS.
   *          The size of TOLA and TOLB may affect the size of backward
   *          errors of the decomposition.
   *
   *  K       (output) INTEGER
   *  L       (output) INTEGER
   *          On exit, K and L specify the dimension of the subblocks
   *          described in Purpose.
   *          K + L = effective numerical rank of (A',B')'.
   *
   *  U       (output) DOUBLE PRECISION array, dimension (LDU,M)
   *          If JOBU = 'U', U contains the orthogonal matrix U.
   *          If JOBU = 'N', U is not referenced.
   *
   *  LDU     (input) INTEGER
   *          The leading dimension of the array U. LDU >= max(1,M) if
   *          JOBU = 'U'; LDU >= 1 otherwise.
   *
   *  V       (output) DOUBLE PRECISION array, dimension (LDV,M)
   *          If JOBV = 'V', V contains the orthogonal matrix V.
   *          If JOBV = 'N', V is not referenced.
   *
   *  LDV     (input) INTEGER
   *          The leading dimension of the array V. LDV >= max(1,P) if
   *          JOBV = 'V'; LDV >= 1 otherwise.
   *
   *  Q       (output) DOUBLE PRECISION array, dimension (LDQ,N)
   *          If JOBQ = 'Q', Q contains the orthogonal matrix Q.
   *          If JOBQ = 'N', Q is not referenced.
   *
   *  LDQ     (input) INTEGER
   *          The leading dimension of the array Q. LDQ >= max(1,N) if
   *          JOBQ = 'Q'; LDQ >= 1 otherwise.
   *
   *  IWORK   (workspace) INTEGER array, dimension (N)
   *
   *  TAU     (workspace) DOUBLE PRECISION array, dimension (N)
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (max(3*N,M,P))
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *
   *  Further Details
   *  ===============
   *
   *  The subroutine uses LAPACK subroutine DGEQPF for the QR factorization
   *  with column pivoting to detect the effective numerical rank of the
   *  a matrix. It may be replaced by a better rank determination strategy.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobu
   * @param jobv
   * @param jobq
   * @param m
   * @param p
   * @param n
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param tola
   * @param tolb
   * @param k
   * @param l
   * @param u
   * @param ldu
   * @param v
   * @param ldv
   * @param q
   * @param ldq
   * @param iwork
   * @param tau
   * @param work
   * @param info
   * 
   */
  abstract public void dggsvp(java.lang.String jobu, java.lang.String jobv, java.lang.String jobq, int m, int p, int n, double[] a, int lda, double[] b, int ldb, double tola, double tolb, org.netlib.util.intW k, org.netlib.util.intW l, double[] u, int ldu, double[] v, int ldv, double[] q, int ldq, int[] iwork, double[] tau, double[] work, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGGSVP computes orthogonal matrices U, V and Q such that
   *
   *                   N-K-L  K    L
   *   U'*A*Q =     K ( 0    A12  A13 )  if M-K-L >= 0;
   *                L ( 0     0   A23 )
   *            M-K-L ( 0     0    0  )
   *
   *                   N-K-L  K    L
   *          =     K ( 0    A12  A13 )  if M-K-L < 0;
   *              M-K ( 0     0   A23 )
   *
   *                 N-K-L  K    L
   *   V'*B*Q =   L ( 0     0   B13 )
   *            P-L ( 0     0    0  )
   *
   *  where the K-by-K matrix A12 and L-by-L matrix B13 are nonsingular
   *  upper triangular; A23 is L-by-L upper triangular if M-K-L >= 0,
   *  otherwise A23 is (M-K)-by-L upper trapezoidal.  K+L = the effective
   *  numerical rank of the (M+P)-by-N matrix (A',B')'.  Z' denotes the
   *  transpose of Z.
   *
   *  This decomposition is the preprocessing step for computing the
   *  Generalized Singular Value Decomposition (GSVD), see subroutine
   *  DGGSVD.
   *
   *  Arguments
   *  =========
   *
   *  JOBU    (input) CHARACTER*1
   *          = 'U':  Orthogonal matrix U is computed;
   *          = 'N':  U is not computed.
   *
   *  JOBV    (input) CHARACTER*1
   *          = 'V':  Orthogonal matrix V is computed;
   *          = 'N':  V is not computed.
   *
   *  JOBQ    (input) CHARACTER*1
   *          = 'Q':  Orthogonal matrix Q is computed;
   *          = 'N':  Q is not computed.
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  P       (input) INTEGER
   *          The number of rows of the matrix B.  P >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrices A and B.  N >= 0.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N matrix A.
   *          On exit, A contains the triangular (or trapezoidal) matrix
   *          described in the Purpose section.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A. LDA >= max(1,M).
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,N)
   *          On entry, the P-by-N matrix B.
   *          On exit, B contains the triangular matrix described in
   *          the Purpose section.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B. LDB >= max(1,P).
   *
   *  TOLA    (input) DOUBLE PRECISION
   *  TOLB    (input) DOUBLE PRECISION
   *          TOLA and TOLB are the thresholds to determine the effective
   *          numerical rank of matrix B and a subblock of A. Generally,
   *          they are set to
   *             TOLA = MAX(M,N)*norm(A)*MAZHEPS,
   *             TOLB = MAX(P,N)*norm(B)*MAZHEPS.
   *          The size of TOLA and TOLB may affect the size of backward
   *          errors of the decomposition.
   *
   *  K       (output) INTEGER
   *  L       (output) INTEGER
   *          On exit, K and L specify the dimension of the subblocks
   *          described in Purpose.
   *          K + L = effective numerical rank of (A',B')'.
   *
   *  U       (output) DOUBLE PRECISION array, dimension (LDU,M)
   *          If JOBU = 'U', U contains the orthogonal matrix U.
   *          If JOBU = 'N', U is not referenced.
   *
   *  LDU     (input) INTEGER
   *          The leading dimension of the array U. LDU >= max(1,M) if
   *          JOBU = 'U'; LDU >= 1 otherwise.
   *
   *  V       (output) DOUBLE PRECISION array, dimension (LDV,M)
   *          If JOBV = 'V', V contains the orthogonal matrix V.
   *          If JOBV = 'N', V is not referenced.
   *
   *  LDV     (input) INTEGER
   *          The leading dimension of the array V. LDV >= max(1,P) if
   *          JOBV = 'V'; LDV >= 1 otherwise.
   *
   *  Q       (output) DOUBLE PRECISION array, dimension (LDQ,N)
   *          If JOBQ = 'Q', Q contains the orthogonal matrix Q.
   *          If JOBQ = 'N', Q is not referenced.
   *
   *  LDQ     (input) INTEGER
   *          The leading dimension of the array Q. LDQ >= max(1,N) if
   *          JOBQ = 'Q'; LDQ >= 1 otherwise.
   *
   *  IWORK   (workspace) INTEGER array, dimension (N)
   *
   *  TAU     (workspace) DOUBLE PRECISION array, dimension (N)
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (max(3*N,M,P))
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *
   *  Further Details
   *  ===============
   *
   *  The subroutine uses LAPACK subroutine DGEQPF for the QR factorization
   *  with column pivoting to detect the effective numerical rank of the
   *  a matrix. It may be replaced by a better rank determination strategy.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param jobu
   * @param jobv
   * @param jobq
   * @param m
   * @param p
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param tola
   * @param tolb
   * @param k
   * @param l
   * @param u
   * @param _u_offset
   * @param ldu
   * @param v
   * @param _v_offset
   * @param ldv
   * @param q
   * @param _q_offset
   * @param ldq
   * @param iwork
   * @param _iwork_offset
   * @param tau
   * @param _tau_offset
   * @param work
   * @param _work_offset
   * @param info
   * 
   */
  abstract public void dggsvp(java.lang.String jobu, java.lang.String jobv, java.lang.String jobq, int m, int p, int n, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double tola, double tolb, org.netlib.util.intW k, org.netlib.util.intW l, double[] u, int _u_offset, int ldu, double[] v, int _v_offset, int ldv, double[] q, int _q_offset, int ldq, int[] iwork, int _iwork_offset, double[] tau, int _tau_offset, double[] work, int _work_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGTCON estimates the reciprocal of the condition number of a real
   *  tridiagonal matrix A using the LU factorization as computed by
   *  DGTTRF.
   *
   *  An estimate is obtained for norm(inv(A)), and the reciprocal of the
   *  condition number is computed as RCOND = 1 / (ANORM * norm(inv(A))).
   *
   *  Arguments
   *  =========
   *
   *  NORM    (input) CHARACTER*1
   *          Specifies whether the 1-norm condition number or the
   *          infinity-norm condition number is required:
   *          = '1' or 'O':  1-norm;
   *          = 'I':         Infinity-norm.
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  DL      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) multipliers that define the matrix L from the
   *          LU factorization of A as computed by DGTTRF.
   *
   *  D       (input) DOUBLE PRECISION array, dimension (N)
   *          The n diagonal elements of the upper triangular matrix U from
   *          the LU factorization of A.
   *
   *  DU      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) elements of the first superdiagonal of U.
   *
   *  DU2     (input) DOUBLE PRECISION array, dimension (N-2)
   *          The (n-2) elements of the second superdiagonal of U.
   *
   *  IPIV    (input) INTEGER array, dimension (N)
   *          The pivot indices; for 1 <= i <= n, row i of the matrix was
   *          interchanged with row IPIV(i).  IPIV(i) will always be either
   *          i or i+1; IPIV(i) = i indicates a row interchange was not
   *          required.
   *
   *  ANORM   (input) DOUBLE PRECISION
   *          If NORM = '1' or 'O', the 1-norm of the original matrix A.
   *          If NORM = 'I', the infinity-norm of the original matrix A.
   *
   *  RCOND   (output) DOUBLE PRECISION
   *          The reciprocal of the condition number of the matrix A,
   *          computed as RCOND = 1/(ANORM * AINVNM), where AINVNM is an
   *          estimate of the 1-norm of inv(A) computed in this routine.
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (2*N)
   *
   *  IWORK   (workspace) INTEGER array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param norm
   * @param n
   * @param dl
   * @param d
   * @param du
   * @param du2
   * @param ipiv
   * @param anorm
   * @param rcond
   * @param work
   * @param iwork
   * @param info
   * 
   */
  abstract public void dgtcon(java.lang.String norm, int n, double[] dl, double[] d, double[] du, double[] du2, int[] ipiv, double anorm, org.netlib.util.doubleW rcond, double[] work, int[] iwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGTCON estimates the reciprocal of the condition number of a real
   *  tridiagonal matrix A using the LU factorization as computed by
   *  DGTTRF.
   *
   *  An estimate is obtained for norm(inv(A)), and the reciprocal of the
   *  condition number is computed as RCOND = 1 / (ANORM * norm(inv(A))).
   *
   *  Arguments
   *  =========
   *
   *  NORM    (input) CHARACTER*1
   *          Specifies whether the 1-norm condition number or the
   *          infinity-norm condition number is required:
   *          = '1' or 'O':  1-norm;
   *          = 'I':         Infinity-norm.
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  DL      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) multipliers that define the matrix L from the
   *          LU factorization of A as computed by DGTTRF.
   *
   *  D       (input) DOUBLE PRECISION array, dimension (N)
   *          The n diagonal elements of the upper triangular matrix U from
   *          the LU factorization of A.
   *
   *  DU      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) elements of the first superdiagonal of U.
   *
   *  DU2     (input) DOUBLE PRECISION array, dimension (N-2)
   *          The (n-2) elements of the second superdiagonal of U.
   *
   *  IPIV    (input) INTEGER array, dimension (N)
   *          The pivot indices; for 1 <= i <= n, row i of the matrix was
   *          interchanged with row IPIV(i).  IPIV(i) will always be either
   *          i or i+1; IPIV(i) = i indicates a row interchange was not
   *          required.
   *
   *  ANORM   (input) DOUBLE PRECISION
   *          If NORM = '1' or 'O', the 1-norm of the original matrix A.
   *          If NORM = 'I', the infinity-norm of the original matrix A.
   *
   *  RCOND   (output) DOUBLE PRECISION
   *          The reciprocal of the condition number of the matrix A,
   *          computed as RCOND = 1/(ANORM * AINVNM), where AINVNM is an
   *          estimate of the 1-norm of inv(A) computed in this routine.
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (2*N)
   *
   *  IWORK   (workspace) INTEGER array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param norm
   * @param n
   * @param dl
   * @param _dl_offset
   * @param d
   * @param _d_offset
   * @param du
   * @param _du_offset
   * @param du2
   * @param _du2_offset
   * @param ipiv
   * @param _ipiv_offset
   * @param anorm
   * @param rcond
   * @param work
   * @param _work_offset
   * @param iwork
   * @param _iwork_offset
   * @param info
   * 
   */
  abstract public void dgtcon(java.lang.String norm, int n, double[] dl, int _dl_offset, double[] d, int _d_offset, double[] du, int _du_offset, double[] du2, int _du2_offset, int[] ipiv, int _ipiv_offset, double anorm, org.netlib.util.doubleW rcond, double[] work, int _work_offset, int[] iwork, int _iwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGTRFS improves the computed solution to a system of linear
   *  equations when the coefficient matrix is tridiagonal, and provides
   *  error bounds and backward error estimates for the solution.
   *
   *  Arguments
   *  =========
   *
   *  TRANS   (input) CHARACTER*1
   *          Specifies the form of the system of equations:
   *          = 'N':  A * X = B     (No transpose)
   *          = 'T':  A**T * X = B  (Transpose)
   *          = 'C':  A**H * X = B  (Conjugate transpose = Transpose)
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrix B.  NRHS >= 0.
   *
   *  DL      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) subdiagonal elements of A.
   *
   *  D       (input) DOUBLE PRECISION array, dimension (N)
   *          The diagonal elements of A.
   *
   *  DU      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) superdiagonal elements of A.
   *
   *  DLF     (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) multipliers that define the matrix L from the
   *          LU factorization of A as computed by DGTTRF.
   *
   *  DF      (input) DOUBLE PRECISION array, dimension (N)
   *          The n diagonal elements of the upper triangular matrix U from
   *          the LU factorization of A.
   *
   *  DUF     (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) elements of the first superdiagonal of U.
   *
   *  DU2     (input) DOUBLE PRECISION array, dimension (N-2)
   *          The (n-2) elements of the second superdiagonal of U.
   *
   *  IPIV    (input) INTEGER array, dimension (N)
   *          The pivot indices; for 1 <= i <= n, row i of the matrix was
   *          interchanged with row IPIV(i).  IPIV(i) will always be either
   *          i or i+1; IPIV(i) = i indicates a row interchange was not
   *          required.
   *
   *  B       (input) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          The right hand side matrix B.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  X       (input/output) DOUBLE PRECISION array, dimension (LDX,NRHS)
   *          On entry, the solution matrix X, as computed by DGTTRS.
   *          On exit, the improved solution matrix X.
   *
   *  LDX     (input) INTEGER
   *          The leading dimension of the array X.  LDX >= max(1,N).
   *
   *  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The estimated forward error bound for each solution vector
   *          X(j) (the j-th column of the solution matrix X).
   *          If XTRUE is the true solution corresponding to X(j), FERR(j)
   *          is an estimated upper bound for the magnitude of the largest
   *          element in (X(j) - XTRUE) divided by the magnitude of the
   *          largest element in X(j).  The estimate is as reliable as
   *          the estimate for RCOND, and is almost always a slight
   *          overestimate of the true error.
   *
   *  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The componentwise relative backward error of each solution
   *          vector X(j) (i.e., the smallest relative change in
   *          any element of A or B that makes X(j) an exact solution).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)
   *
   *  IWORK   (workspace) INTEGER array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  Internal Parameters
   *  ===================
   *
   *  ITMAX is the maximum number of steps of iterative refinement.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param n
   * @param nrhs
   * @param dl
   * @param d
   * @param du
   * @param dlf
   * @param df
   * @param duf
   * @param du2
   * @param ipiv
   * @param b
   * @param ldb
   * @param x
   * @param ldx
   * @param ferr
   * @param berr
   * @param work
   * @param iwork
   * @param info
   * 
   */
  abstract public void dgtrfs(java.lang.String trans, int n, int nrhs, double[] dl, double[] d, double[] du, double[] dlf, double[] df, double[] duf, double[] du2, int[] ipiv, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGTRFS improves the computed solution to a system of linear
   *  equations when the coefficient matrix is tridiagonal, and provides
   *  error bounds and backward error estimates for the solution.
   *
   *  Arguments
   *  =========
   *
   *  TRANS   (input) CHARACTER*1
   *          Specifies the form of the system of equations:
   *          = 'N':  A * X = B     (No transpose)
   *          = 'T':  A**T * X = B  (Transpose)
   *          = 'C':  A**H * X = B  (Conjugate transpose = Transpose)
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrix B.  NRHS >= 0.
   *
   *  DL      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) subdiagonal elements of A.
   *
   *  D       (input) DOUBLE PRECISION array, dimension (N)
   *          The diagonal elements of A.
   *
   *  DU      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) superdiagonal elements of A.
   *
   *  DLF     (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) multipliers that define the matrix L from the
   *          LU factorization of A as computed by DGTTRF.
   *
   *  DF      (input) DOUBLE PRECISION array, dimension (N)
   *          The n diagonal elements of the upper triangular matrix U from
   *          the LU factorization of A.
   *
   *  DUF     (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) elements of the first superdiagonal of U.
   *
   *  DU2     (input) DOUBLE PRECISION array, dimension (N-2)
   *          The (n-2) elements of the second superdiagonal of U.
   *
   *  IPIV    (input) INTEGER array, dimension (N)
   *          The pivot indices; for 1 <= i <= n, row i of the matrix was
   *          interchanged with row IPIV(i).  IPIV(i) will always be either
   *          i or i+1; IPIV(i) = i indicates a row interchange was not
   *          required.
   *
   *  B       (input) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          The right hand side matrix B.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  X       (input/output) DOUBLE PRECISION array, dimension (LDX,NRHS)
   *          On entry, the solution matrix X, as computed by DGTTRS.
   *          On exit, the improved solution matrix X.
   *
   *  LDX     (input) INTEGER
   *          The leading dimension of the array X.  LDX >= max(1,N).
   *
   *  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The estimated forward error bound for each solution vector
   *          X(j) (the j-th column of the solution matrix X).
   *          If XTRUE is the true solution corresponding to X(j), FERR(j)
   *          is an estimated upper bound for the magnitude of the largest
   *          element in (X(j) - XTRUE) divided by the magnitude of the
   *          largest element in X(j).  The estimate is as reliable as
   *          the estimate for RCOND, and is almost always a slight
   *          overestimate of the true error.
   *
   *  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The componentwise relative backward error of each solution
   *          vector X(j) (i.e., the smallest relative change in
   *          any element of A or B that makes X(j) an exact solution).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)
   *
   *  IWORK   (workspace) INTEGER array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  Internal Parameters
   *  ===================
   *
   *  ITMAX is the maximum number of steps of iterative refinement.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param n
   * @param nrhs
   * @param dl
   * @param _dl_offset
   * @param d
   * @param _d_offset
   * @param du
   * @param _du_offset
   * @param dlf
   * @param _dlf_offset
   * @param df
   * @param _df_offset
   * @param duf
   * @param _duf_offset
   * @param du2
   * @param _du2_offset
   * @param ipiv
   * @param _ipiv_offset
   * @param b
   * @param _b_offset
   * @param ldb
   * @param x
   * @param _x_offset
   * @param ldx
   * @param ferr
   * @param _ferr_offset
   * @param berr
   * @param _berr_offset
   * @param work
   * @param _work_offset
   * @param iwork
   * @param _iwork_offset
   * @param info
   * 
   */
  abstract public void dgtrfs(java.lang.String trans, int n, int nrhs, double[] dl, int _dl_offset, double[] d, int _d_offset, double[] du, int _du_offset, double[] dlf, int _dlf_offset, double[] df, int _df_offset, double[] duf, int _duf_offset, double[] du2, int _du2_offset, int[] ipiv, int _ipiv_offset, double[] b, int _b_offset, int ldb, double[] x, int _x_offset, int ldx, double[] ferr, int _ferr_offset, double[] berr, int _berr_offset, double[] work, int _work_offset, int[] iwork, int _iwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGTSV  solves the equation
   *
   *     A*X = B,
   *
   *  where A is an n by n tridiagonal matrix, by Gaussian elimination with
   *  partial pivoting.
   *
   *  Note that the equation  A'*X = B  may be solved by interchanging the
   *  order of the arguments DU and DL.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrix B.  NRHS >= 0.
   *
   *  DL      (input/output) DOUBLE PRECISION array, dimension (N-1)
   *          On entry, DL must contain the (n-1) sub-diagonal elements of
   *          A.
   *
   *          On exit, DL is overwritten by the (n-2) elements of the
   *          second super-diagonal of the upper triangular matrix U from
   *          the LU factorization of A, in DL(1), ..., DL(n-2).
   *
   *  D       (input/output) DOUBLE PRECISION array, dimension (N)
   *          On entry, D must contain the diagonal elements of A.
   *
   *          On exit, D is overwritten by the n diagonal elements of U.
   *
   *  DU      (input/output) DOUBLE PRECISION array, dimension (N-1)
   *          On entry, DU must contain the (n-1) super-diagonal elements
   *          of A.
   *
   *          On exit, DU is overwritten by the (n-1) elements of the first
   *          super-diagonal of U.
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the N by NRHS matrix of right hand side matrix B.
   *          On exit, if INFO = 0, the N by NRHS solution matrix X.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value
   *          > 0: if INFO = i, U(i,i) is exactly zero, and the solution
   *               has not been computed.  The factorization has not been
   *               completed unless i = N.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param nrhs
   * @param dl
   * @param d
   * @param du
   * @param b
   * @param ldb
   * @param info
   * 
   */
  abstract public void dgtsv(int n, int nrhs, double[] dl, double[] d, double[] du, double[] b, int ldb, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGTSV  solves the equation
   *
   *     A*X = B,
   *
   *  where A is an n by n tridiagonal matrix, by Gaussian elimination with
   *  partial pivoting.
   *
   *  Note that the equation  A'*X = B  may be solved by interchanging the
   *  order of the arguments DU and DL.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrix B.  NRHS >= 0.
   *
   *  DL      (input/output) DOUBLE PRECISION array, dimension (N-1)
   *          On entry, DL must contain the (n-1) sub-diagonal elements of
   *          A.
   *
   *          On exit, DL is overwritten by the (n-2) elements of the
   *          second super-diagonal of the upper triangular matrix U from
   *          the LU factorization of A, in DL(1), ..., DL(n-2).
   *
   *  D       (input/output) DOUBLE PRECISION array, dimension (N)
   *          On entry, D must contain the diagonal elements of A.
   *
   *          On exit, D is overwritten by the n diagonal elements of U.
   *
   *  DU      (input/output) DOUBLE PRECISION array, dimension (N-1)
   *          On entry, DU must contain the (n-1) super-diagonal elements
   *          of A.
   *
   *          On exit, DU is overwritten by the (n-1) elements of the first
   *          super-diagonal of U.
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the N by NRHS matrix of right hand side matrix B.
   *          On exit, if INFO = 0, the N by NRHS solution matrix X.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value
   *          > 0: if INFO = i, U(i,i) is exactly zero, and the solution
   *               has not been computed.  The factorization has not been
   *               completed unless i = N.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param nrhs
   * @param dl
   * @param _dl_offset
   * @param d
   * @param _d_offset
   * @param du
   * @param _du_offset
   * @param b
   * @param _b_offset
   * @param ldb
   * @param info
   * 
   */
  abstract public void dgtsv(int n, int nrhs, double[] dl, int _dl_offset, double[] d, int _d_offset, double[] du, int _du_offset, double[] b, int _b_offset, int ldb, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGTSVX uses the LU factorization to compute the solution to a real
   *  system of linear equations A * X = B or A**T * X = B,
   *  where A is a tridiagonal matrix of order N and X and B are N-by-NRHS
   *  matrices.
   *
   *  Error bounds on the solution and a condition estimate are also
   *  provided.
   *
   *  Description
   *  ===========
   *
   *  The following steps are performed:
   *
   *  1. If FACT = 'N', the LU decomposition is used to factor the matrix A
   *     as A = L * U, where L is a product of permutation and unit lower
   *     bidiagonal matrices and U is upper triangular with nonzeros in
   *     only the main diagonal and first two superdiagonals.
   *
   *  2. If some U(i,i)=0, so that U is exactly singular, then the routine
   *     returns with INFO = i. Otherwise, the factored form of A is used
   *     to estimate the condition number of the matrix A.  If the
   *     reciprocal of the condition number is less than machine precision,
   *     INFO = N+1 is returned as a warning, but the routine still goes on
   *     to solve for X and compute error bounds as described below.
   *
   *  3. The system of equations is solved for X using the factored form
   *     of A.
   *
   *  4. Iterative refinement is applied to improve the computed solution
   *     matrix and calculate error bounds and backward error estimates
   *     for it.
   *
   *  Arguments
   *  =========
   *
   *  FACT    (input) CHARACTER*1
   *          Specifies whether or not the factored form of A has been
   *          supplied on entry.
   *          = 'F':  DLF, DF, DUF, DU2, and IPIV contain the factored
   *                  form of A; DL, D, DU, DLF, DF, DUF, DU2 and IPIV
   *                  will not be modified.
   *          = 'N':  The matrix will be copied to DLF, DF, and DUF
   *                  and factored.
   *
   *  TRANS   (input) CHARACTER*1
   *          Specifies the form of the system of equations:
   *          = 'N':  A * X = B     (No transpose)
   *          = 'T':  A**T * X = B  (Transpose)
   *          = 'C':  A**H * X = B  (Conjugate transpose = Transpose)
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrix B.  NRHS >= 0.
   *
   *  DL      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) subdiagonal elements of A.
   *
   *  D       (input) DOUBLE PRECISION array, dimension (N)
   *          The n diagonal elements of A.
   *
   *  DU      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) superdiagonal elements of A.
   *
   *  DLF     (input or output) DOUBLE PRECISION array, dimension (N-1)
   *          If FACT = 'F', then DLF is an input argument and on entry
   *          contains the (n-1) multipliers that define the matrix L from
   *          the LU factorization of A as computed by DGTTRF.
   *
   *          If FACT = 'N', then DLF is an output argument and on exit
   *          contains the (n-1) multipliers that define the matrix L from
   *          the LU factorization of A.
   *
   *  DF      (input or output) DOUBLE PRECISION array, dimension (N)
   *          If FACT = 'F', then DF is an input argument and on entry
   *          contains the n diagonal elements of the upper triangular
   *          matrix U from the LU factorization of A.
   *
   *          If FACT = 'N', then DF is an output argument and on exit
   *          contains the n diagonal elements of the upper triangular
   *          matrix U from the LU factorization of A.
   *
   *  DUF     (input or output) DOUBLE PRECISION array, dimension (N-1)
   *          If FACT = 'F', then DUF is an input argument and on entry
   *          contains the (n-1) elements of the first superdiagonal of U.
   *
   *          If FACT = 'N', then DUF is an output argument and on exit
   *          contains the (n-1) elements of the first superdiagonal of U.
   *
   *  DU2     (input or output) DOUBLE PRECISION array, dimension (N-2)
   *          If FACT = 'F', then DU2 is an input argument and on entry
   *          contains the (n-2) elements of the second superdiagonal of
   *          U.
   *
   *          If FACT = 'N', then DU2 is an output argument and on exit
   *          contains the (n-2) elements of the second superdiagonal of
   *          U.
   *
   *  IPIV    (input or output) INTEGER array, dimension (N)
   *          If FACT = 'F', then IPIV is an input argument and on entry
   *          contains the pivot indices from the LU factorization of A as
   *          computed by DGTTRF.
   *
   *          If FACT = 'N', then IPIV is an output argument and on exit
   *          contains the pivot indices from the LU factorization of A;
   *          row i of the matrix was interchanged with row IPIV(i).
   *          IPIV(i) will always be either i or i+1; IPIV(i) = i indicates
   *          a row interchange was not required.
   *
   *  B       (input) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          The N-by-NRHS right hand side matrix B.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  X       (output) DOUBLE PRECISION array, dimension (LDX,NRHS)
   *          If INFO = 0 or INFO = N+1, the N-by-NRHS solution matrix X.
   *
   *  LDX     (input) INTEGER
   *          The leading dimension of the array X.  LDX >= max(1,N).
   *
   *  RCOND   (output) DOUBLE PRECISION
   *          The estimate of the reciprocal condition number of the matrix
   *          A.  If RCOND is less than the machine precision (in
   *          particular, if RCOND = 0), the matrix is singular to working
   *          precision.  This condition is indicated by a return code of
   *          INFO > 0.
   *
   *  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The estimated forward error bound for each solution vector
   *          X(j) (the j-th column of the solution matrix X).
   *          If XTRUE is the true solution corresponding to X(j), FERR(j)
   *          is an estimated upper bound for the magnitude of the largest
   *          element in (X(j) - XTRUE) divided by the magnitude of the
   *          largest element in X(j).  The estimate is as reliable as
   *          the estimate for RCOND, and is almost always a slight
   *          overestimate of the true error.
   *
   *  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The componentwise relative backward error of each solution
   *          vector X(j) (i.e., the smallest relative change in
   *          any element of A or B that makes X(j) an exact solution).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)
   *
   *  IWORK   (workspace) INTEGER array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO = i, and i is
   *                <= N:  U(i,i) is exactly zero.  The factorization
   *                       has not been completed unless i = N, but the
   *                       factor U is exactly singular, so the solution
   *                       and error bounds could not be computed.
   *                       RCOND = 0 is returned.
   *                = N+1: U is nonsingular, but RCOND is less than machine
   *                       precision, meaning that the matrix is singular
   *                       to working precision.  Nevertheless, the
   *                       solution and error bounds are computed because
   *                       there are a number of situations where the
   *                       computed solution can be more accurate than the
   *                       value of RCOND would suggest.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param fact
   * @param trans
   * @param n
   * @param nrhs
   * @param dl
   * @param d
   * @param du
   * @param dlf
   * @param df
   * @param duf
   * @param du2
   * @param ipiv
   * @param b
   * @param ldb
   * @param x
   * @param ldx
   * @param rcond
   * @param ferr
   * @param berr
   * @param work
   * @param iwork
   * @param info
   * 
   */
  abstract public void dgtsvx(java.lang.String fact, java.lang.String trans, int n, int nrhs, double[] dl, double[] d, double[] du, double[] dlf, double[] df, double[] duf, double[] du2, int[] ipiv, double[] b, int ldb, double[] x, int ldx, org.netlib.util.doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGTSVX uses the LU factorization to compute the solution to a real
   *  system of linear equations A * X = B or A**T * X = B,
   *  where A is a tridiagonal matrix of order N and X and B are N-by-NRHS
   *  matrices.
   *
   *  Error bounds on the solution and a condition estimate are also
   *  provided.
   *
   *  Description
   *  ===========
   *
   *  The following steps are performed:
   *
   *  1. If FACT = 'N', the LU decomposition is used to factor the matrix A
   *     as A = L * U, where L is a product of permutation and unit lower
   *     bidiagonal matrices and U is upper triangular with nonzeros in
   *     only the main diagonal and first two superdiagonals.
   *
   *  2. If some U(i,i)=0, so that U is exactly singular, then the routine
   *     returns with INFO = i. Otherwise, the factored form of A is used
   *     to estimate the condition number of the matrix A.  If the
   *     reciprocal of the condition number is less than machine precision,
   *     INFO = N+1 is returned as a warning, but the routine still goes on
   *     to solve for X and compute error bounds as described below.
   *
   *  3. The system of equations is solved for X using the factored form
   *     of A.
   *
   *  4. Iterative refinement is applied to improve the computed solution
   *     matrix and calculate error bounds and backward error estimates
   *     for it.
   *
   *  Arguments
   *  =========
   *
   *  FACT    (input) CHARACTER*1
   *          Specifies whether or not the factored form of A has been
   *          supplied on entry.
   *          = 'F':  DLF, DF, DUF, DU2, and IPIV contain the factored
   *                  form of A; DL, D, DU, DLF, DF, DUF, DU2 and IPIV
   *                  will not be modified.
   *          = 'N':  The matrix will be copied to DLF, DF, and DUF
   *                  and factored.
   *
   *  TRANS   (input) CHARACTER*1
   *          Specifies the form of the system of equations:
   *          = 'N':  A * X = B     (No transpose)
   *          = 'T':  A**T * X = B  (Transpose)
   *          = 'C':  A**H * X = B  (Conjugate transpose = Transpose)
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrix B.  NRHS >= 0.
   *
   *  DL      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) subdiagonal elements of A.
   *
   *  D       (input) DOUBLE PRECISION array, dimension (N)
   *          The n diagonal elements of A.
   *
   *  DU      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) superdiagonal elements of A.
   *
   *  DLF     (input or output) DOUBLE PRECISION array, dimension (N-1)
   *          If FACT = 'F', then DLF is an input argument and on entry
   *          contains the (n-1) multipliers that define the matrix L from
   *          the LU factorization of A as computed by DGTTRF.
   *
   *          If FACT = 'N', then DLF is an output argument and on exit
   *          contains the (n-1) multipliers that define the matrix L from
   *          the LU factorization of A.
   *
   *  DF      (input or output) DOUBLE PRECISION array, dimension (N)
   *          If FACT = 'F', then DF is an input argument and on entry
   *          contains the n diagonal elements of the upper triangular
   *          matrix U from the LU factorization of A.
   *
   *          If FACT = 'N', then DF is an output argument and on exit
   *          contains the n diagonal elements of the upper triangular
   *          matrix U from the LU factorization of A.
   *
   *  DUF     (input or output) DOUBLE PRECISION array, dimension (N-1)
   *          If FACT = 'F', then DUF is an input argument and on entry
   *          contains the (n-1) elements of the first superdiagonal of U.
   *
   *          If FACT = 'N', then DUF is an output argument and on exit
   *          contains the (n-1) elements of the first superdiagonal of U.
   *
   *  DU2     (input or output) DOUBLE PRECISION array, dimension (N-2)
   *          If FACT = 'F', then DU2 is an input argument and on entry
   *          contains the (n-2) elements of the second superdiagonal of
   *          U.
   *
   *          If FACT = 'N', then DU2 is an output argument and on exit
   *          contains the (n-2) elements of the second superdiagonal of
   *          U.
   *
   *  IPIV    (input or output) INTEGER array, dimension (N)
   *          If FACT = 'F', then IPIV is an input argument and on entry
   *          contains the pivot indices from the LU factorization of A as
   *          computed by DGTTRF.
   *
   *          If FACT = 'N', then IPIV is an output argument and on exit
   *          contains the pivot indices from the LU factorization of A;
   *          row i of the matrix was interchanged with row IPIV(i).
   *          IPIV(i) will always be either i or i+1; IPIV(i) = i indicates
   *          a row interchange was not required.
   *
   *  B       (input) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          The N-by-NRHS right hand side matrix B.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  X       (output) DOUBLE PRECISION array, dimension (LDX,NRHS)
   *          If INFO = 0 or INFO = N+1, the N-by-NRHS solution matrix X.
   *
   *  LDX     (input) INTEGER
   *          The leading dimension of the array X.  LDX >= max(1,N).
   *
   *  RCOND   (output) DOUBLE PRECISION
   *          The estimate of the reciprocal condition number of the matrix
   *          A.  If RCOND is less than the machine precision (in
   *          particular, if RCOND = 0), the matrix is singular to working
   *          precision.  This condition is indicated by a return code of
   *          INFO > 0.
   *
   *  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The estimated forward error bound for each solution vector
   *          X(j) (the j-th column of the solution matrix X).
   *          If XTRUE is the true solution corresponding to X(j), FERR(j)
   *          is an estimated upper bound for the magnitude of the largest
   *          element in (X(j) - XTRUE) divided by the magnitude of the
   *          largest element in X(j).  The estimate is as reliable as
   *          the estimate for RCOND, and is almost always a slight
   *          overestimate of the true error.
   *
   *  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
   *          The componentwise relative backward error of each solution
   *          vector X(j) (i.e., the smallest relative change in
   *          any element of A or B that makes X(j) an exact solution).
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)
   *
   *  IWORK   (workspace) INTEGER array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO = i, and i is
   *                <= N:  U(i,i) is exactly zero.  The factorization
   *                       has not been completed unless i = N, but the
   *                       factor U is exactly singular, so the solution
   *                       and error bounds could not be computed.
   *                       RCOND = 0 is returned.
   *                = N+1: U is nonsingular, but RCOND is less than machine
   *                       precision, meaning that the matrix is singular
   *                       to working precision.  Nevertheless, the
   *                       solution and error bounds are computed because
   *                       there are a number of situations where the
   *                       computed solution can be more accurate than the
   *                       value of RCOND would suggest.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param fact
   * @param trans
   * @param n
   * @param nrhs
   * @param dl
   * @param _dl_offset
   * @param d
   * @param _d_offset
   * @param du
   * @param _du_offset
   * @param dlf
   * @param _dlf_offset
   * @param df
   * @param _df_offset
   * @param duf
   * @param _duf_offset
   * @param du2
   * @param _du2_offset
   * @param ipiv
   * @param _ipiv_offset
   * @param b
   * @param _b_offset
   * @param ldb
   * @param x
   * @param _x_offset
   * @param ldx
   * @param rcond
   * @param ferr
   * @param _ferr_offset
   * @param berr
   * @param _berr_offset
   * @param work
   * @param _work_offset
   * @param iwork
   * @param _iwork_offset
   * @param info
   * 
   */
  abstract public void dgtsvx(java.lang.String fact, java.lang.String trans, int n, int nrhs, double[] dl, int _dl_offset, double[] d, int _d_offset, double[] du, int _du_offset, double[] dlf, int _dlf_offset, double[] df, int _df_offset, double[] duf, int _duf_offset, double[] du2, int _du2_offset, int[] ipiv, int _ipiv_offset, double[] b, int _b_offset, int ldb, double[] x, int _x_offset, int ldx, org.netlib.util.doubleW rcond, double[] ferr, int _ferr_offset, double[] berr, int _berr_offset, double[] work, int _work_offset, int[] iwork, int _iwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGTTRF computes an LU factorization of a real tridiagonal matrix A
   *  using elimination with partial pivoting and row interchanges.
   *
   *  The factorization has the form
   *     A = L * U
   *  where L is a product of permutation and unit lower bidiagonal
   *  matrices and U is upper triangular with nonzeros in only the main
   *  diagonal and first two superdiagonals.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.
   *
   *  DL      (input/output) DOUBLE PRECISION array, dimension (N-1)
   *          On entry, DL must contain the (n-1) sub-diagonal elements of
   *          A.
   *
   *          On exit, DL is overwritten by the (n-1) multipliers that
   *          define the matrix L from the LU factorization of A.
   *
   *  D       (input/output) DOUBLE PRECISION array, dimension (N)
   *          On entry, D must contain the diagonal elements of A.
   *
   *          On exit, D is overwritten by the n diagonal elements of the
   *          upper triangular matrix U from the LU factorization of A.
   *
   *  DU      (input/output) DOUBLE PRECISION array, dimension (N-1)
   *          On entry, DU must contain the (n-1) super-diagonal elements
   *          of A.
   *
   *          On exit, DU is overwritten by the (n-1) elements of the first
   *          super-diagonal of U.
   *
   *  DU2     (output) DOUBLE PRECISION array, dimension (N-2)
   *          On exit, DU2 is overwritten by the (n-2) elements of the
   *          second super-diagonal of U.
   *
   *  IPIV    (output) INTEGER array, dimension (N)
   *          The pivot indices; for 1 <= i <= n, row i of the matrix was
   *          interchanged with row IPIV(i).  IPIV(i) will always be either
   *          i or i+1; IPIV(i) = i indicates a row interchange was not
   *          required.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -k, the k-th argument had an illegal value
   *          > 0:  if INFO = k, U(k,k) is exactly zero. The factorization
   *                has been completed, but the factor U is exactly
   *                singular, and division by zero will occur if it is used
   *                to solve a system of equations.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param dl
   * @param d
   * @param du
   * @param du2
   * @param ipiv
   * @param info
   * 
   */
  abstract public void dgttrf(int n, double[] dl, double[] d, double[] du, double[] du2, int[] ipiv, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGTTRF computes an LU factorization of a real tridiagonal matrix A
   *  using elimination with partial pivoting and row interchanges.
   *
   *  The factorization has the form
   *     A = L * U
   *  where L is a product of permutation and unit lower bidiagonal
   *  matrices and U is upper triangular with nonzeros in only the main
   *  diagonal and first two superdiagonals.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.
   *
   *  DL      (input/output) DOUBLE PRECISION array, dimension (N-1)
   *          On entry, DL must contain the (n-1) sub-diagonal elements of
   *          A.
   *
   *          On exit, DL is overwritten by the (n-1) multipliers that
   *          define the matrix L from the LU factorization of A.
   *
   *  D       (input/output) DOUBLE PRECISION array, dimension (N)
   *          On entry, D must contain the diagonal elements of A.
   *
   *          On exit, D is overwritten by the n diagonal elements of the
   *          upper triangular matrix U from the LU factorization of A.
   *
   *  DU      (input/output) DOUBLE PRECISION array, dimension (N-1)
   *          On entry, DU must contain the (n-1) super-diagonal elements
   *          of A.
   *
   *          On exit, DU is overwritten by the (n-1) elements of the first
   *          super-diagonal of U.
   *
   *  DU2     (output) DOUBLE PRECISION array, dimension (N-2)
   *          On exit, DU2 is overwritten by the (n-2) elements of the
   *          second super-diagonal of U.
   *
   *  IPIV    (output) INTEGER array, dimension (N)
   *          The pivot indices; for 1 <= i <= n, row i of the matrix was
   *          interchanged with row IPIV(i).  IPIV(i) will always be either
   *          i or i+1; IPIV(i) = i indicates a row interchange was not
   *          required.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -k, the k-th argument had an illegal value
   *          > 0:  if INFO = k, U(k,k) is exactly zero. The factorization
   *                has been completed, but the factor U is exactly
   *                singular, and division by zero will occur if it is used
   *                to solve a system of equations.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param dl
   * @param _dl_offset
   * @param d
   * @param _d_offset
   * @param du
   * @param _du_offset
   * @param du2
   * @param _du2_offset
   * @param ipiv
   * @param _ipiv_offset
   * @param info
   * 
   */
  abstract public void dgttrf(int n, double[] dl, int _dl_offset, double[] d, int _d_offset, double[] du, int _du_offset, double[] du2, int _du2_offset, int[] ipiv, int _ipiv_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGTTRS solves one of the systems of equations
   *     A*X = B  or  A'*X = B,
   *  with a tridiagonal matrix A using the LU factorization computed
   *  by DGTTRF.
   *
   *  Arguments
   *  =========
   *
   *  TRANS   (input) CHARACTER*1
   *          Specifies the form of the system of equations.
   *          = 'N':  A * X = B  (No transpose)
   *          = 'T':  A'* X = B  (Transpose)
   *          = 'C':  A'* X = B  (Conjugate transpose = Transpose)
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrix B.  NRHS >= 0.
   *
   *  DL      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) multipliers that define the matrix L from the
   *          LU factorization of A.
   *
   *  D       (input) DOUBLE PRECISION array, dimension (N)
   *          The n diagonal elements of the upper triangular matrix U from
   *          the LU factorization of A.
   *
   *  DU      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) elements of the first super-diagonal of U.
   *
   *  DU2     (input) DOUBLE PRECISION array, dimension (N-2)
   *          The (n-2) elements of the second super-diagonal of U.
   *
   *  IPIV    (input) INTEGER array, dimension (N)
   *          The pivot indices; for 1 <= i <= n, row i of the matrix was
   *          interchanged with row IPIV(i).  IPIV(i) will always be either
   *          i or i+1; IPIV(i) = i indicates a row interchange was not
   *          required.
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the matrix of right hand side vectors B.
   *          On exit, B is overwritten by the solution vectors X.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param trans
   * @param n
   * @param nrhs
   * @param dl
   * @param d
   * @param du
   * @param du2
   * @param ipiv
   * @param b
   * @param ldb
   * @param info
   * 
   */
  abstract public void dgttrs(java.lang.String trans, int n, int nrhs, double[] dl, double[] d, double[] du, double[] du2, int[] ipiv, double[] b, int ldb, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGTTRS solves one of the systems of equations
   *     A*X = B  or  A'*X = B,
   *  with a tridiagonal matrix A using the LU factorization computed
   *  by DGTTRF.
   *
   *  Arguments
   *  =========
   *
   *  TRANS   (input) CHARACTER*1
   *          Specifies the form of the system of equations.
   *          = 'N':  A * X = B  (No transpose)
   *          = 'T':  A'* X = B  (Transpose)
   *          = 'C':  A'* X = B  (Conjugate transpose = Transpose)
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrix B.  NRHS >= 0.
   *
   *  DL      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) multipliers that define the matrix L from the
   *          LU factorization of A.
   *
   *  D       (input) DOUBLE PRECISION array, dimension (N)
   *          The n diagonal elements of the upper triangular matrix U from
   *          the LU factorization of A.
   *
   *  DU      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) elements of the first super-diagonal of U.
   *
   *  DU2     (input) DOUBLE PRECISION array, dimension (N-2)
   *          The (n-2) elements of the second super-diagonal of U.
   *
   *  IPIV    (input) INTEGER array, dimension (N)
   *          The pivot indices; for 1 <= i <= n, row i of the matrix was
   *          interchanged with row IPIV(i).  IPIV(i) will always be either
   *          i or i+1; IPIV(i) = i indicates a row interchange was not
   *          required.
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the matrix of right hand side vectors B.
   *          On exit, B is overwritten by the solution vectors X.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param trans
   * @param n
   * @param nrhs
   * @param dl
   * @param _dl_offset
   * @param d
   * @param _d_offset
   * @param du
   * @param _du_offset
   * @param du2
   * @param _du2_offset
   * @param ipiv
   * @param _ipiv_offset
   * @param b
   * @param _b_offset
   * @param ldb
   * @param info
   * 
   */
  abstract public void dgttrs(java.lang.String trans, int n, int nrhs, double[] dl, int _dl_offset, double[] d, int _d_offset, double[] du, int _du_offset, double[] du2, int _du2_offset, int[] ipiv, int _ipiv_offset, double[] b, int _b_offset, int ldb, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGTTS2 solves one of the systems of equations
   *     A*X = B  or  A'*X = B,
   *  with a tridiagonal matrix A using the LU factorization computed
   *  by DGTTRF.
   *
   *  Arguments
   *  =========
   *
   *  ITRANS  (input) INTEGER
   *          Specifies the form of the system of equations.
   *          = 0:  A * X = B  (No transpose)
   *          = 1:  A'* X = B  (Transpose)
   *          = 2:  A'* X = B  (Conjugate transpose = Transpose)
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrix B.  NRHS >= 0.
   *
   *  DL      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) multipliers that define the matrix L from the
   *          LU factorization of A.
   *
   *  D       (input) DOUBLE PRECISION array, dimension (N)
   *          The n diagonal elements of the upper triangular matrix U from
   *          the LU factorization of A.
   *
   *  DU      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) elements of the first super-diagonal of U.
   *
   *  DU2     (input) DOUBLE PRECISION array, dimension (N-2)
   *          The (n-2) elements of the second super-diagonal of U.
   *
   *  IPIV    (input) INTEGER array, dimension (N)
   *          The pivot indices; for 1 <= i <= n, row i of the matrix was
   *          interchanged with row IPIV(i).  IPIV(i) will always be either
   *          i or i+1; IPIV(i) = i indicates a row interchange was not
   *          required.
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the matrix of right hand side vectors B.
   *          On exit, B is overwritten by the solution vectors X.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param itrans
   * @param n
   * @param nrhs
   * @param dl
   * @param d
   * @param du
   * @param du2
   * @param ipiv
   * @param b
   * @param ldb
   * 
   */
  abstract public void dgtts2(int itrans, int n, int nrhs, double[] dl, double[] d, double[] du, double[] du2, int[] ipiv, double[] b, int ldb);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DGTTS2 solves one of the systems of equations
   *     A*X = B  or  A'*X = B,
   *  with a tridiagonal matrix A using the LU factorization computed
   *  by DGTTRF.
   *
   *  Arguments
   *  =========
   *
   *  ITRANS  (input) INTEGER
   *          Specifies the form of the system of equations.
   *          = 0:  A * X = B  (No transpose)
   *          = 1:  A'* X = B  (Transpose)
   *          = 2:  A'* X = B  (Conjugate transpose = Transpose)
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrix B.  NRHS >= 0.
   *
   *  DL      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) multipliers that define the matrix L from the
   *          LU factorization of A.
   *
   *  D       (input) DOUBLE PRECISION array, dimension (N)
   *          The n diagonal elements of the upper triangular matrix U from
   *          the LU factorization of A.
   *
   *  DU      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) elements of the first super-diagonal of U.
   *
   *  DU2     (input) DOUBLE PRECISION array, dimension (N-2)
   *          The (n-2) elements of the second super-diagonal of U.
   *
   *  IPIV    (input) INTEGER array, dimension (N)
   *          The pivot indices; for 1 <= i <= n, row i of the matrix was
   *          interchanged with row IPIV(i).  IPIV(i) will always be either
   *          i or i+1; IPIV(i) = i indicates a row interchange was not
   *          required.
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the matrix of right hand side vectors B.
   *          On exit, B is overwritten by the solution vectors X.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,N).
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param itrans
   * @param n
   * @param nrhs
   * @param dl
   * @param _dl_offset
   * @param d
   * @param _d_offset
   * @param du
   * @param _du_offset
   * @param du2
   * @param _du2_offset
   * @param ipiv
   * @param _ipiv_offset
   * @param b
   * @param _b_offset
   * @param ldb
   * 
   */
  abstract public void dgtts2(int itrans, int n, int nrhs, double[] dl, int _dl_offset, double[] d, int _d_offset, double[] du, int _du_offset, double[] du2, int _du2_offset, int[] ipiv, int _ipiv_offset, double[] b, int _b_offset, int ldb);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DHGEQZ computes the eigenvalues of a real matrix pair (H,T),
   *  where H is an upper Hessenberg matrix and T is upper triangular,
   *  using the double-shift QZ method.
   *  Matrix pairs of this type are produced by the reduction to
   *  generalized upper Hessenberg form of a real matrix pair (A,B):
   *
   *     A = Q1*H*Z1**T,  B = Q1*T*Z1**T,
   *
   *  as computed by DGGHRD.
   *
   *  If JOB='S', then the Hessenberg-triangular pair (H,T) is
   *  also reduced to generalized Schur form,
   *  
   *     H = Q*S*Z**T,  T = Q*P*Z**T,
   *  
   *  where Q and Z are orthogonal matrices, P is an upper triangular
   *  matrix, and S is a quasi-triangular matrix with 1-by-1 and 2-by-2
   *  diagonal blocks.
   *
   *  The 1-by-1 blocks correspond to real eigenvalues of the matrix pair
   *  (H,T) and the 2-by-2 blocks correspond to complex conjugate pairs of
   *  eigenvalues.
   *
   *  Additionally, the 2-by-2 upper triangular diagonal blocks of P
   *  corresponding to 2-by-2 blocks of S are reduced to positive diagonal
   *  form, i.e., if S(j+1,j) is non-zero, then P(j+1,j) = P(j,j+1) = 0,
   *  P(j,j) > 0, and P(j+1,j+1) > 0.
   *
   *  Optionally, the orthogonal matrix Q from the generalized Schur
   *  factorization may be postmultiplied into an input matrix Q1, and the
   *  orthogonal matrix Z may be postmultiplied into an input matrix Z1.
   *  If Q1 and Z1 are the orthogonal matrices from DGGHRD that reduced
   *  the matrix pair (A,B) to generalized upper Hessenberg form, then the
   *  output matrices Q1*Q and Z1*Z are the orthogonal factors from the
   *  generalized Schur factorization of (A,B):
   *
   *     A = (Q1*Q)*S*(Z1*Z)**T,  B = (Q1*Q)*P*(Z1*Z)**T.
   *  
   *  To avoid overflow, eigenvalues of the matrix pair (H,T) (equivalently
   *  of (A,B)) are computed as a pair of values (alpha,beta), where alpha 
   *  complex and beta real.
   *  If beta is nonzero, lambda = alpha / beta is an eigenvalue of the
   *  generalized nonsymmetric eigenvalue problem (GNEP)
   *     A*x = lambda*B*x
   *  and if alpha is nonzero, mu = beta / alpha is an eigenvalue of the
   *  alternate form of the GNEP
   *     mu*A*y = B*y.
   *  Real eigenvalues can be read directly from the generalized Schur
   *  form: 
   *    alpha = S(i,i), beta = P(i,i).
   *
   *  Ref: C.B. Moler & G.W. Stewart, "An Algorithm for Generalized Matrix
   *       Eigenvalue Problems", SIAM J. Numer. Anal., 10(1973),
   *       pp. 241--256.
   *
   *  Arguments
   *  =========
   *
   *  JOB     (input) CHARACTER*1
   *          = 'E': Compute eigenvalues only;
   *          = 'S': Compute eigenvalues and the Schur form. 
   *
   *  COMPQ   (input) CHARACTER*1
   *          = 'N': Left Schur vectors (Q) are not computed;
   *          = 'I': Q is initialized to the unit matrix and the matrix Q
   *                 of left Schur vectors of (H,T) is returned;
   *          = 'V': Q must contain an orthogonal matrix Q1 on entry and
   *                 the product Q1*Q is returned.
   *
   *  COMPZ   (input) CHARACTER*1
   *          = 'N': Right Schur vectors (Z) are not computed;
   *          = 'I': Z is initialized to the unit matrix and the matrix Z
   *                 of right Schur vectors of (H,T) is returned;
   *          = 'V': Z must contain an orthogonal matrix Z1 on entry and
   *                 the product Z1*Z is returned.
   *
   *  N       (input) INTEGER
   *          The order of the matrices H, T, Q, and Z.  N >= 0.
   *
   *  ILO     (input) INTEGER
   *  IHI     (input) INTEGER
   *          ILO and IHI mark the rows and columns of H which are in
   *          Hessenberg form.  It is assumed that A is already upper
   *          triangular in rows and columns 1:ILO-1 and IHI+1:N.
   *          If N > 0, 1 <= ILO <= IHI <= N; if N = 0, ILO=1 and IHI=0.
   *
   *  H       (input/output) DOUBLE PRECISION array, dimension (LDH, N)
   *          On entry, the N-by-N upper Hessenberg matrix H.
   *          On exit, if JOB = 'S', H contains the upper quasi-triangular
   *          matrix S from the generalized Schur factorization;
   *          2-by-2 diagonal blocks (corresponding to complex conjugate
   *          pairs of eigenvalues) are returned in standard form, with
   *          H(i,i) = H(i+1,i+1) and H(i+1,i)*H(i,i+1) < 0.
   *          If JOB = 'E', the diagonal blocks of H match those of S, but
   *          the rest of H is unspecified.
   *
   *  LDH     (input) INTEGER
   *          The leading dimension of the array H.  LDH >= max( 1, N ).
   *
   *  T       (input/output) DOUBLE PRECISION array, dimension (LDT, N)
   *          On entry, the N-by-N upper triangular matrix T.
   *          On exit, if JOB = 'S', T contains the upper triangular
   *          matrix P from the generalized Schur factorization;
   *          2-by-2 diagonal blocks of P corresponding to 2-by-2 blocks of
   *          are reduced to positive diagonal form, i.e., if H(j+1,j) is
   *          non-zero, then T(j+1,j) = T(j,j+1) = 0, T(j,j) > 0, and
   *          T(j+1,j+1) > 0.
   *          If JOB = 'E', the diagonal blocks of T match those of P, but
   *          the rest of T is unspecified.
   *
   *  LDT     (input) INTEGER
   *          The leading dimension of the array T.  LDT >= max( 1, N ).
   *
   *  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
   *          The real parts of each scalar alpha defining an eigenvalue
   *          of GNEP.
   *
   *  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
   *          The imaginary parts of each scalar alpha defining an
   *          eigenvalue of GNEP.
   *          If ALPHAI(j) is zero, then the j-th eigenvalue is real; if
   *          positive, then the j-th and (j+1)-st eigenvalues are a
   *          complex conjugate pair, with ALPHAI(j+1) = -ALPHAI(j).
   *
   *  BETA    (output) DOUBLE PRECISION array, dimension (N)
   *          The scalars beta that define the eigenvalues of GNEP.
   *          Together, the quantities alpha = (ALPHAR(j),ALPHAI(j)) and
   *          beta = BETA(j) represent the j-th eigenvalue of the matrix
   *          pair (A,B), in one of the forms lambda = alpha/beta or
   *          mu = beta/alpha.  Since either lambda or mu may overflow,
   *          they should not, in general, be computed.
   *
   *  Q       (input/output) DOUBLE PRECISION array, dimension (LDQ, N)
   *          On entry, if COMPZ = 'V', the orthogonal matrix Q1 used in
   *          the reduction of (A,B) to generalized Hessenberg form.
   *          On exit, if COMPZ = 'I', the orthogonal matrix of left Schur
   *          vectors of (H,T), and if COMPZ = 'V', the orthogonal matrix
   *          of left Schur vectors of (A,B).
   *          Not referenced if COMPZ = 'N'.
   *
   *  LDQ     (input) INTEGER
   *          The leading dimension of the array Q.  LDQ >= 1.
   *          If COMPQ='V' or 'I', then LDQ >= N.
   *
   *  Z       (input/output) DOUBLE PRECISION array, dimension (LDZ, N)
   *          On entry, if COMPZ = 'V', the orthogonal matrix Z1 used in
   *          the reduction of (A,B) to generalized Hessenberg form.
   *          On exit, if COMPZ = 'I', the orthogonal matrix of
   *          right Schur vectors of (H,T), and if COMPZ = 'V', the
   *          orthogonal matrix of right Schur vectors of (A,B).
   *          Not referenced if COMPZ = 'N'.
   *
   *  LDZ     (input) INTEGER
   *          The leading dimension of the array Z.  LDZ >= 1.
   *          If COMPZ='V' or 'I', then LDZ >= N.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO >= 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,N).
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value
   *          = 1,...,N: the QZ iteration did not converge.  (H,T) is not
   *                     in Schur form, but ALPHAR(i), ALPHAI(i), and
   *                     BETA(i), i=INFO+1,...,N should be correct.
   *          = N+1,...,2*N: the shift calculation failed.  (H,T) is not
   *                     in Schur form, but ALPHAR(i), ALPHAI(i), and
   *                     BETA(i), i=INFO-N+1,...,N should be correct.
   *
   *  Further Details
   *  ===============
   *
   *  Iteration counters:
   *
   *  JITER  -- counts iterations.
   *  IITER  -- counts iterations run since ILAST was last
   *            changed.  This is therefore reset only when a 1-by-1 or
   *            2-by-2 block deflates off the bottom.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   *    $                     SAFETY = 1.0E+0 )
   * </code></pre>
   *
   * @param job
   * @param compq
   * @param compz
   * @param n
   * @param ilo
   * @param ihi
   * @param h
   * @param ldh
   * @param t
   * @param ldt
   * @param alphar
   * @param alphai
   * @param beta
   * @param q
   * @param ldq
   * @param z
   * @param ldz
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dhgeqz(java.lang.String job, java.lang.String compq, java.lang.String compz, int n, int ilo, int ihi, double[] h, int ldh, double[] t, int ldt, double[] alphar, double[] alphai, double[] beta, double[] q, int ldq, double[] z, int ldz, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DHGEQZ computes the eigenvalues of a real matrix pair (H,T),
   *  where H is an upper Hessenberg matrix and T is upper triangular,
   *  using the double-shift QZ method.
   *  Matrix pairs of this type are produced by the reduction to
   *  generalized upper Hessenberg form of a real matrix pair (A,B):
   *
   *     A = Q1*H*Z1**T,  B = Q1*T*Z1**T,
   *
   *  as computed by DGGHRD.
   *
   *  If JOB='S', then the Hessenberg-triangular pair (H,T) is
   *  also reduced to generalized Schur form,
   *  
   *     H = Q*S*Z**T,  T = Q*P*Z**T,
   *  
   *  where Q and Z are orthogonal matrices, P is an upper triangular
   *  matrix, and S is a quasi-triangular matrix with 1-by-1 and 2-by-2
   *  diagonal blocks.
   *
   *  The 1-by-1 blocks correspond to real eigenvalues of the matrix pair
   *  (H,T) and the 2-by-2 blocks correspond to complex conjugate pairs of
   *  eigenvalues.
   *
   *  Additionally, the 2-by-2 upper triangular diagonal blocks of P
   *  corresponding to 2-by-2 blocks of S are reduced to positive diagonal
   *  form, i.e., if S(j+1,j) is non-zero, then P(j+1,j) = P(j,j+1) = 0,
   *  P(j,j) > 0, and P(j+1,j+1) > 0.
   *
   *  Optionally, the orthogonal matrix Q from the generalized Schur
   *  factorization may be postmultiplied into an input matrix Q1, and the
   *  orthogonal matrix Z may be postmultiplied into an input matrix Z1.
   *  If Q1 and Z1 are the orthogonal matrices from DGGHRD that reduced
   *  the matrix pair (A,B) to generalized upper Hessenberg form, then the
   *  output matrices Q1*Q and Z1*Z are the orthogonal factors from the
   *  generalized Schur factorization of (A,B):
   *
   *     A = (Q1*Q)*S*(Z1*Z)**T,  B = (Q1*Q)*P*(Z1*Z)**T.
   *  
   *  To avoid overflow, eigenvalues of the matrix pair (H,T) (equivalently
   *  of (A,B)) are computed as a pair of values (alpha,beta), where alpha 
   *  complex and beta real.
   *  If beta is nonzero, lambda = alpha / beta is an eigenvalue of the
   *  generalized nonsymmetric eigenvalue problem (GNEP)
   *     A*x = lambda*B*x
   *  and if alpha is nonzero, mu = beta / alpha is an eigenvalue of the
   *  alternate form of the GNEP
   *     mu*A*y = B*y.
   *  Real eigenvalues can be read directly from the generalized Schur
   *  form: 
   *    alpha = S(i,i), beta = P(i,i).
   *
   *  Ref: C.B. Moler & G.W. Stewart, "An Algorithm for Generalized Matrix
   *       Eigenvalue Problems", SIAM J. Numer. Anal., 10(1973),
   *       pp. 241--256.
   *
   *  Arguments
   *  =========
   *
   *  JOB     (input) CHARACTER*1
   *          = 'E': Compute eigenvalues only;
   *          = 'S': Compute eigenvalues and the Schur form. 
   *
   *  COMPQ   (input) CHARACTER*1
   *          = 'N': Left Schur vectors (Q) are not computed;
   *          = 'I': Q is initialized to the unit matrix and the matrix Q
   *                 of left Schur vectors of (H,T) is returned;
   *          = 'V': Q must contain an orthogonal matrix Q1 on entry and
   *                 the product Q1*Q is returned.
   *
   *  COMPZ   (input) CHARACTER*1
   *          = 'N': Right Schur vectors (Z) are not computed;
   *          = 'I': Z is initialized to the unit matrix and the matrix Z
   *                 of right Schur vectors of (H,T) is returned;
   *          = 'V': Z must contain an orthogonal matrix Z1 on entry and
   *                 the product Z1*Z is returned.
   *
   *  N       (input) INTEGER
   *          The order of the matrices H, T, Q, and Z.  N >= 0.
   *
   *  ILO     (input) INTEGER
   *  IHI     (input) INTEGER
   *          ILO and IHI mark the rows and columns of H which are in
   *          Hessenberg form.  It is assumed that A is already upper
   *          triangular in rows and columns 1:ILO-1 and IHI+1:N.
   *          If N > 0, 1 <= ILO <= IHI <= N; if N = 0, ILO=1 and IHI=0.
   *
   *  H       (input/output) DOUBLE PRECISION array, dimension (LDH, N)
   *          On entry, the N-by-N upper Hessenberg matrix H.
   *          On exit, if JOB = 'S', H contains the upper quasi-triangular
   *          matrix S from the generalized Schur factorization;
   *          2-by-2 diagonal blocks (corresponding to complex conjugate
   *          pairs of eigenvalues) are returned in standard form, with
   *          H(i,i) = H(i+1,i+1) and H(i+1,i)*H(i,i+1) < 0.
   *          If JOB = 'E', the diagonal blocks of H match those of S, but
   *          the rest of H is unspecified.
   *
   *  LDH     (input) INTEGER
   *          The leading dimension of the array H.  LDH >= max( 1, N ).
   *
   *  T       (input/output) DOUBLE PRECISION array, dimension (LDT, N)
   *          On entry, the N-by-N upper triangular matrix T.
   *          On exit, if JOB = 'S', T contains the upper triangular
   *          matrix P from the generalized Schur factorization;
   *          2-by-2 diagonal blocks of P corresponding to 2-by-2 blocks of
   *          are reduced to positive diagonal form, i.e., if H(j+1,j) is
   *          non-zero, then T(j+1,j) = T(j,j+1) = 0, T(j,j) > 0, and
   *          T(j+1,j+1) > 0.
   *          If JOB = 'E', the diagonal blocks of T match those of P, but
   *          the rest of T is unspecified.
   *
   *  LDT     (input) INTEGER
   *          The leading dimension of the array T.  LDT >= max( 1, N ).
   *
   *  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
   *          The real parts of each scalar alpha defining an eigenvalue
   *          of GNEP.
   *
   *  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
   *          The imaginary parts of each scalar alpha defining an
   *          eigenvalue of GNEP.
   *          If ALPHAI(j) is zero, then the j-th eigenvalue is real; if
   *          positive, then the j-th and (j+1)-st eigenvalues are a
   *          complex conjugate pair, with ALPHAI(j+1) = -ALPHAI(j).
   *
   *  BETA    (output) DOUBLE PRECISION array, dimension (N)
   *          The scalars beta that define the eigenvalues of GNEP.
   *          Together, the quantities alpha = (ALPHAR(j),ALPHAI(j)) and
   *          beta = BETA(j) represent the j-th eigenvalue of the matrix
   *          pair (A,B), in one of the forms lambda = alpha/beta or
   *          mu = beta/alpha.  Since either lambda or mu may overflow,
   *          they should not, in general, be computed.
   *
   *  Q       (input/output) DOUBLE PRECISION array, dimension (LDQ, N)
   *          On entry, if COMPZ = 'V', the orthogonal matrix Q1 used in
   *          the reduction of (A,B) to generalized Hessenberg form.
   *          On exit, if COMPZ = 'I', the orthogonal matrix of left Schur
   *          vectors of (H,T), and if COMPZ = 'V', the orthogonal matrix
   *          of left Schur vectors of (A,B).
   *          Not referenced if COMPZ = 'N'.
   *
   *  LDQ     (input) INTEGER
   *          The leading dimension of the array Q.  LDQ >= 1.
   *          If COMPQ='V' or 'I', then LDQ >= N.
   *
   *  Z       (input/output) DOUBLE PRECISION array, dimension (LDZ, N)
   *          On entry, if COMPZ = 'V', the orthogonal matrix Z1 used in
   *          the reduction of (A,B) to generalized Hessenberg form.
   *          On exit, if COMPZ = 'I', the orthogonal matrix of
   *          right Schur vectors of (H,T), and if COMPZ = 'V', the
   *          orthogonal matrix of right Schur vectors of (A,B).
   *          Not referenced if COMPZ = 'N'.
   *
   *  LDZ     (input) INTEGER
   *          The leading dimension of the array Z.  LDZ >= 1.
   *          If COMPZ='V' or 'I', then LDZ >= N.
   *
   *  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
   *          On exit, if INFO >= 0, WORK(1) returns the optimal LWORK.
   *
   *  LWORK   (input) INTEGER
   *          The dimension of the array WORK.  LWORK >= max(1,N).
   *
   *          If LWORK = -1, then a workspace query is assumed; the routine
   *          only calculates the optimal size of the WORK array, returns
   *          this value as the first entry of the WORK array, and no error
   *          message related to LWORK is issued by XERBLA.
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          < 0: if INFO = -i, the i-th argument had an illegal value
   *          = 1,...,N: the QZ iteration did not converge.  (H,T) is not
   *                     in Schur form, but ALPHAR(i), ALPHAI(i), and
   *                     BETA(i), i=INFO+1,...,N should be correct.
   *          = N+1,...,2*N: the shift calculation failed.  (H,T) is not
   *                     in Schur form, but ALPHAR(i), ALPHAI(i), and
   *                     BETA(i), i=INFO-N+1,...,N should be correct.
   *
   *  Further Details
   *  ===============
   *
   *  Iteration counters:
   *
   *  JITER  -- counts iterations.
   *  IITER  -- counts iterations run since ILAST was last
   *            changed.  This is therefore reset only when a 1-by-1 or
   *            2-by-2 block deflates off the bottom.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   *    $                     SAFETY = 1.0E+0 )
   * </code></pre>
   *
   * @param job
   * @param compq
   * @param compz
   * @param n
   * @param ilo
   * @param ihi
   * @param h
   * @param _h_offset
   * @param ldh
   * @param t
   * @param _t_offset
   * @param ldt
   * @param alphar
   * @param _alphar_offset
   * @param alphai
   * @param _alphai_offset
   * @param beta
   * @param _beta_offset
   * @param q
   * @param _q_offset
   * @param ldq
   * @param z
   * @param _z_offset
   * @param ldz
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dhgeqz(java.lang.String job, java.lang.String compq, java.lang.String compz, int n, int ilo, int ihi, double[] h, int _h_offset, int ldh, double[] t, int _t_offset, int ldt, double[] alphar, int _alphar_offset, double[] alphai, int _alphai_offset, double[] beta, int _beta_offset, double[] q, int _q_offset, int ldq, double[] z, int _z_offset, int ldz, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DHSEIN uses inverse iteration to find specified right and/or left
   *  eigenvectors of a real upper Hessenberg matrix H.
   *
   *  The right eigenvector x and the left eigenvector y of the matrix H
   *  corresponding to an eigenvalue w are defined by:
   *
   *               H * x = w * x,     y**h * H = w * y**h
   *
   *  where y**h denotes the conjugate transpose of the vector y.
   *
   *  Arguments
   *  =========
   *
   *  SIDE    (input) CHARACTER*1
   *          = 'R': compute right eigenvectors only;
   *          = 'L': compute left eigenvectors only;
   *          = 'B': compute both right and left eigenvectors.
   *
   *  EIGSRC  (input) CHARACTER*1
   *          Specifies the source of eigenvalues supplied in (WR,WI):
   *          = 'Q': the eigenvalues were found using DHSEQR; thus, if
   *                 H has zero subdiagonal elements, and so is
   *                 block-triangular, then the j-th eigenvalue can be
   *                 assumed to be an eigenvalue of the block containing
   *                 the j-th row/column.  This property allows DHSEIN to
   *                 perform inverse iteration on just one diagonal block.
   *          = 'N': no assumptions are made on the correspondence
   *                 between eigenvalues and diagonal blocks.  In this
   *                 case, DHSEIN must always perform inverse iteration
   *                 using the whole matrix H.
   *
   *  INITV   (input) CHARACTER*1
   *          = 'N': no initial vectors are supplied;
   *          = 'U': user-supplied initial vectors are stored in the arrays
   *                 VL and/or VR.
   *
   *  SELECT  (input/output) LOGICAL array, dimension (N)
   *          Specifies the eigenvectors to be computed. To select the
   *          real eigenvector corresponding to a real eigenvalue WR(j),
   *          SELECT(j) must be set to .TRUE.. To select the complex
   *          eigenvector corresponding to a complex eigenvalue
   *          (WR(j),WI(j)), with complex conjugate (WR(j+1),WI(j+1)),
   *          either SELECT(j) or SELECT(j+1) or both must be set to
   *          .TRUE.; then on exit SELECT(j) is .TRUE. and SELECT(j+1) is
   *          .FALSE..
   *
   *  N       (input) INTEGER
   *          The order of the matrix H.  N >= 0.
   *
   *  H       (input) DOUBLE PRECISION array, dimension (LDH,N)
   *          The upper Hessenberg matrix H.
   *
   *  LDH     (input) INTEGER
   *          The leading dimension of the array H.  LDH >= max(1,N).
   *
   *  WR      (input/output) DOUBLE PRECISION array, dimension (N)
   *  WI      (input) DOUBLE PRECISION array, dimension (N)
   *          On entry, the real and imaginary parts of the eigenvalues of
   *          H; a complex conjugate pair of eigenvalues must be stored in
   *          consecutive elements of WR and WI.
   *          On exit, WR may have been altered since close eigenvalues
   *          are perturbed slightly in searching for independent
   *          eigenvectors.
   *
   *  VL      (input/output) DOUBLE PRECISION array, dimension (LDVL,MM)
   *          On entry, if INITV = 'U' and SIDE = 'L' or 'B', VL must
   *          contain starting vectors for the inverse iteration for the
   *          left eigenvectors; the starting vector for each eigenvector
   *          must be in the same column(s) in which the eigenvector will
   *          be stored.
   *          On exit, if SIDE = 'L' or 'B', the left eigenvectors
   *          specified by SELECT will be stored consecutively in the
   *          columns of VL, in the same order as their eigenvalues. A
   *          complex eigenvector corresponding to a complex eigenvalue is
   *          stored in two consecutive columns, the first holding the real
   *          part and the second the imaginary part.
   *          If SIDE = 'R', VL is not referenced.
   *
   *  LDVL    (input) INTEGER
   *          The leading dimension of the array VL.
   *          LDVL >= max(1,N) if SIDE = 'L' or 'B'; LDVL >= 1 otherwise.
   *
   *  VR      (input/output) DOUBLE PRECISION array, dimension (LDVR,MM)
   *          On entry, if INITV = 'U' and SIDE = 'R' or 'B', VR must
   *          contain starting vectors for the inverse iteration for the
   *          right eigenvectors; the starting vector for each eigenvector
   *          must be in the same column(s) in which the eigenvector will
   *          be stored.
   *          On exit, if SIDE = 'R' or 'B', the right eigenvectors
   *          specified by SELECT will be stored consecutively in the
   *          columns of VR, in the same order as their eigenvalues. A
   *          complex eigenvector corresponding to a complex eigenvalue is
   *          stored in two consecutive columns, the first holding the real
   *          part and the second the imaginary part.
   *          If SIDE = 'L', VR is not referenced.
   *
   *  LDVR    (input) INTEGER
   *          The leading dimension of the array VR.
   *          LDVR >= max(1,N) if SIDE = 'R' or 'B'; LDVR >= 1 otherwise.
   *
   *  MM      (input) INTEGER
   *          The number of columns in the arrays VL and/or VR. MM >= M.
   *
   *  M       (output) INTEGER
   *          The number of columns in the arrays VL and/or VR required to
   *          store the eigenvectors; each selected real eigenvector
   *          occupies one column and each selected complex eigenvector
   *          occupies two columns.
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension ((N+2)*N)
   *
   *  IFAILL  (output) INTEGER array, dimension (MM)
   *          If SIDE = 'L' or 'B', IFAILL(i) = j > 0 if the left
   *          eigenvector in the i-th column of VL (corresponding to the
   *          eigenvalue w(j)) failed to converge; IFAILL(i) = 0 if the
   *          eigenvector converged satisfactorily. If the i-th and (i+1)th
   *          columns of VL hold a complex eigenvector, then IFAILL(i) and
   *          IFAILL(i+1) are set to the same value.
   *          If SIDE = 'R', IFAILL is not referenced.
   *
   *  IFAILR  (output) INTEGER array, dimension (MM)
   *          If SIDE = 'R' or 'B', IFAILR(i) = j > 0 if the right
   *          eigenvector in the i-th column of VR (corresponding to the
   *          eigenvalue w(j)) failed to converge; IFAILR(i) = 0 if the
   *          eigenvector converged satisfactorily. If the i-th and (i+1)th
   *          columns of VR hold a complex eigenvector, then IFAILR(i) and
   *          IFAILR(i+1) are set to the same value.
   *          If SIDE = 'L', IFAILR is not referenced.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO = i, i is the number of eigenvectors which
   *                failed to converge; see IFAILL and IFAILR for further
   *                details.
   *
   *  Further Details
   *  ===============
   *
   *  Each eigenvector is normalized so that the element of largest
   *  magnitude has magnitude 1; here the magnitude of a complex number
   *  (x,y) is taken to be |x|+|y|.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param side
   * @param eigsrc
   * @param initv
   * @param select
   * @param n
   * @param h
   * @param ldh
   * @param wr
   * @param wi
   * @param vl
   * @param ldvl
   * @param vr
   * @param ldvr
   * @param mm
   * @param m
   * @param work
   * @param ifaill
   * @param ifailr
   * @param info
   * 
   */
  abstract public void dhsein(java.lang.String side, java.lang.String eigsrc, java.lang.String initv, boolean[] select, int n, double[] h, int ldh, double[] wr, double[] wi, double[] vl, int ldvl, double[] vr, int ldvr, int mm, org.netlib.util.intW m, double[] work, int[] ifaill, int[] ifailr, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DHSEIN uses inverse iteration to find specified right and/or left
   *  eigenvectors of a real upper Hessenberg matrix H.
   *
   *  The right eigenvector x and the left eigenvector y of the matrix H
   *  corresponding to an eigenvalue w are defined by:
   *
   *               H * x = w * x,     y**h * H = w * y**h
   *
   *  where y**h denotes the conjugate transpose of the vector y.
   *
   *  Arguments
   *  =========
   *
   *  SIDE    (input) CHARACTER*1
   *          = 'R': compute right eigenvectors only;
   *          = 'L': compute left eigenvectors only;
   *          = 'B': compute both right and left eigenvectors.
   *
   *  EIGSRC  (input) CHARACTER*1
   *          Specifies the source of eigenvalues supplied in (WR,WI):
   *          = 'Q': the eigenvalues were found using DHSEQR; thus, if
   *                 H has zero subdiagonal elements, and so is
   *                 block-triangular, then the j-th eigenvalue can be
   *                 assumed to be an eigenvalue of the block containing
   *                 the j-th row/column.  This property allows DHSEIN to
   *                 perform inverse iteration on just one diagonal block.
   *          = 'N': no assumptions are made on the correspondence
   *                 between eigenvalues and diagonal blocks.  In this
   *                 case, DHSEIN must always perform inverse iteration
   *                 using the whole matrix H.
   *
   *  INITV   (input) CHARACTER*1
   *          = 'N': no initial vectors are supplied;
   *          = 'U': user-supplied initial vectors are stored in the arrays
   *                 VL and/or VR.
   *
   *  SELECT  (input/output) LOGICAL array, dimension (N)
   *          Specifies the eigenvectors to be computed. To select the
   *          real eigenvector corresponding to a real eigenvalue WR(j),
   *          SELECT(j) must be set to .TRUE.. To select the complex
   *          eigenvector corresponding to a complex eigenvalue
   *          (WR(j),WI(j)), with complex conjugate (WR(j+1),WI(j+1)),
   *          either SELECT(j) or SELECT(j+1) or both must be set to
   *          .TRUE.; then on exit SELECT(j) is .TRUE. and SELECT(j+1) is
   *          .FALSE..
   *
   *  N       (input) INTEGER
   *          The order of the matrix H.  N >= 0.
   *
   *  H       (input) DOUBLE PRECISION array, dimension (LDH,N)
   *          The upper Hessenberg matrix H.
   *
   *  LDH     (input) INTEGER
   *          The leading dimension of the array H.  LDH >= max(1,N).
   *
   *  WR      (input/output) DOUBLE PRECISION array, dimension (N)
   *  WI      (input) DOUBLE PRECISION array, dimension (N)
   *          On entry, the real and imaginary parts of the eigenvalues of
   *          H; a complex conjugate pair of eigenvalues must be stored in
   *          consecutive elements of WR and WI.
   *          On exit, WR may have been altered since close eigenvalues
   *          are perturbed slightly in searching for independent
   *          eigenvectors.
   *
   *  VL      (input/output) DOUBLE PRECISION array, dimension (LDVL,MM)
   *          On entry, if INITV = 'U' and SIDE = 'L' or 'B', VL must
   *          contain starting vectors for the inverse iteration for the
   *          left eigenvectors; the starting vector for each eigenvector
   *          must be in the same column(s) in which the eigenvector will
   *          be stored.
   *          On exit, if SIDE = 'L' or 'B', the left eigenvectors
   *          specified by SELECT will be stored consecutively in the
   *          columns of VL, in the same order as their eigenvalues. A
   *          complex eigenvector corresponding to a complex eigenvalue is
   *          stored in two consecutive columns, the first holding the real
   *          part and the second the imaginary part.
   *          If SIDE = 'R', VL is not referenced.
   *
   *  LDVL    (input) INTEGER
   *          The leading dimension of the array VL.
   *          LDVL >= max(1,N) if SIDE = 'L' or 'B'; LDVL >= 1 otherwise.
   *
   *  VR      (input/output) DOUBLE PRECISION array, dimension (LDVR,MM)
   *          On entry, if INITV = 'U' and SIDE = 'R' or 'B', VR must
   *          contain starting vectors for the inverse iteration for the
   *          right eigenvectors; the starting vector for each eigenvector
   *          must be in the same column(s) in which the eigenvector will
   *          be stored.
   *          On exit, if SIDE = 'R' or 'B', the right eigenvectors
   *          specified by SELECT will be stored consecutively in the
   *          columns of VR, in the same order as their eigenvalues. A
   *          complex eigenvector corresponding to a complex eigenvalue is
   *          stored in two consecutive columns, the first holding the real
   *          part and the second the imaginary part.
   *          If SIDE = 'L', VR is not referenced.
   *
   *  LDVR    (input) INTEGER
   *          The leading dimension of the array VR.
   *          LDVR >= max(1,N) if SIDE = 'R' or 'B'; LDVR >= 1 otherwise.
   *
   *  MM      (input) INTEGER
   *          The number of columns in the arrays VL and/or VR. MM >= M.
   *
   *  M       (output) INTEGER
   *          The number of columns in the arrays VL and/or VR required to
   *          store the eigenvectors; each selected real eigenvector
   *          occupies one column and each selected complex eigenvector
   *          occupies two columns.
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension ((N+2)*N)
   *
   *  IFAILL  (output) INTEGER array, dimension (MM)
   *          If SIDE = 'L' or 'B', IFAILL(i) = j > 0 if the left
   *          eigenvector in the i-th column of VL (corresponding to the
   *          eigenvalue w(j)) failed to converge; IFAILL(i) = 0 if the
   *          eigenvector converged satisfactorily. If the i-th and (i+1)th
   *          columns of VL hold a complex eigenvector, then IFAILL(i) and
   *          IFAILL(i+1) are set to the same value.
   *          If SIDE = 'R', IFAILL is not referenced.
   *
   *  IFAILR  (output) INTEGER array, dimension (MM)
   *          If SIDE = 'R' or 'B', IFAILR(i) = j > 0 if the right
   *          eigenvector in the i-th column of VR (corresponding to the
   *          eigenvalue w(j)) failed to converge; IFAILR(i) = 0 if the
   *          eigenvector converged satisfactorily. If the i-th and (i+1)th
   *          columns of VR hold a complex eigenvector, then IFAILR(i) and
   *          IFAILR(i+1) are set to the same value.
   *          If SIDE = 'L', IFAILR is not referenced.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          < 0:  if INFO = -i, the i-th argument had an illegal value
   *          > 0:  if INFO = i, i is the number of eigenvectors which
   *                failed to converge; see IFAILL and IFAILR for further
   *                details.
   *
   *  Further Details
   *  ===============
   *
   *  Each eigenvector is normalized so that the element of largest
   *  magnitude has magnitude 1; here the magnitude of a complex number
   *  (x,y) is taken to be |x|+|y|.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param side
   * @param eigsrc
   * @param initv
   * @param select
   * @param _select_offset
   * @param n
   * @param h
   * @param _h_offset
   * @param ldh
   * @param wr
   * @param _wr_offset
   * @param wi
   * @param _wi_offset
   * @param vl
   * @param _vl_offset
   * @param ldvl
   * @param vr
   * @param _vr_offset
   * @param ldvr
   * @param mm
   * @param m
   * @param work
   * @param _work_offset
   * @param ifaill
   * @param _ifaill_offset
   * @param ifailr
   * @param _ifailr_offset
   * @param info
   * 
   */
  abstract public void dhsein(java.lang.String side, java.lang.String eigsrc, java.lang.String initv, boolean[] select, int _select_offset, int n, double[] h, int _h_offset, int ldh, double[] wr, int _wr_offset, double[] wi, int _wi_offset, double[] vl, int _vl_offset, int ldvl, double[] vr, int _vr_offset, int ldvr, int mm, org.netlib.util.intW m, double[] work, int _work_offset, int[] ifaill, int _ifaill_offset, int[] ifailr, int _ifailr_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *     Purpose
   *     =======
   *
   *     DHSEQR computes the eigenvalues of a Hessenberg matrix H
   *     and, optionally, the matrices T and Z from the Schur decomposition
   *     H = Z T Z**T, where T is an upper quasi-triangular matrix (the
   *     Schur form), and Z is the orthogonal matrix of Schur vectors.
   *
   *     Optionally Z may be postmultiplied into an input orthogonal
   *     matrix Q so that this routine can give the Schur factorization
   *     of a matrix A which has been reduced to the Hessenberg form H
   *     by the orthogonal matrix Q:  A = Q*H*Q**T = (QZ)*T*(QZ)**T.
   *
   *     Arguments
   *     =========
   *
   *     JOB   (input) CHARACTER*1
   *           = 'E':  compute eigenvalues only;
   *           = 'S':  compute eigenvalues and the Schur form T.
   *
   *     COMPZ (input) CHARACTER*1
   *           = 'N':  no Schur vectors are computed;
   *           = 'I':  Z is initialized to the unit matrix and the matrix Z
   *                   of Schur vectors of H is returned;
   *           = 'V':  Z must contain an orthogonal matrix Q on entry, and
   *                   the product Q*Z is returned.
   *
   *     N     (input) INTEGER
   *           The order of the matrix H.  N .GE. 0.
   *
   *     ILO   (input) INTEGER
   *     IHI   (input) INTEGER
   *           It is assumed that H is already upper triangular in rows
   *           and columns 1:ILO-1 and IHI+1:N. ILO and IHI are normally
   *           set by a previous call to DGEBAL, and then passed to DGEHRD
   *           when the matrix output by DGEBAL is reduced to Hessenberg
   *           form. Otherwise ILO and IHI should be set to 1 and N
   *           respectively.  If N.GT.0, then 1.LE.ILO.LE.IHI.LE.N.
   *           If N = 0, then ILO = 1 and IHI = 0.
   *
   *     H     (input/output) DOUBLE PRECISION array, dimension (LDH,N)
   *           On entry, the upper Hessenberg matrix H.
   *           On exit, if INFO = 0 and JOB = 'S', then H contains the
   *           upper quasi-triangular matrix T from the Schur decomposition
   *           (the Schur form); 2-by-2 diagonal blocks (corresponding to
   *           complex conjugate pairs of eigenvalues) are returned in
   *           standard form, with H(i,i) = H(i+1,i+1) and
   *           H(i+1,i)*H(i,i+1).LT.0. If INFO = 0 and JOB = 'E', the
   *           contents of H are unspecified on exit.  (The output value of
   *           H when INFO.GT.0 is given under the description of INFO
   *           below.)
   *
   *           Unlike earlier versions of DHSEQR, this subroutine may
   *           explicitly H(i,j) = 0 for i.GT.j and j = 1, 2, ... ILO-1
   *           or j = IHI+1, IHI+2, ... N.
   *
   *     LDH   (input) INTEGER
   *           The leading dimension of the array H. LDH .GE. max(1,N).
   *
   *     WR    (output) DOUBLE PRECISION array, dimension (N)
   *     WI    (output) DOUBLE PRECISION array, dimension (N)
   *           The real and imaginary parts, respectively, of the computed
   *           eigenvalues. If two eigenvalues are computed as a complex
   *           conjugate pair, they are stored in consecutive elements of
   *           WR and WI, say the i-th and (i+1)th, with WI(i) .GT. 0 and
   *           WI(i+1) .LT. 0. If JOB = 'S', the eigenvalues are stored in
   *           the same order as on the diagonal of the Schur form returned
   *           in H, with WR(i) = H(i,i) and, if H(i:i+1,i:i+1) is a 2-by-2
   *           diagonal block, WI(i) = sqrt(-H(i+1,i)*H(i,i+1)) and
   *           WI(i+1) = -WI(i).
   *
   *     Z     (input/output) DOUBLE PRECISION array, dimension (LDZ,N)
   *           If COMPZ = 'N', Z is not referenced.
   *           If COMPZ = 'I', on entry Z need not be set and on exit,
   *           if INFO = 0, Z contains the orthogonal matrix Z of the Schur
   *           vectors of H.  If COMPZ = 'V', on entry Z must contain an
   *           N-by-N matrix Q, which is assumed to be equal to the unit
   *           matrix except for the submatrix Z(ILO:IHI,ILO:IHI). On exit,
   *           if INFO = 0, Z contains Q*Z.
   *           Normally Q is the orthogonal matrix generated by DORGHR
   *           after the call to DGEHRD which formed the Hessenberg matrix
   *           H. (The output value of Z when INFO.GT.0 is given under
   *           the description of INFO below.)
   *
   *     LDZ   (input) INTEGER
   *           The leading dimension of the array Z.  if COMPZ = 'I' or
   *           COMPZ = 'V', then LDZ.GE.MAX(1,N).  Otherwize, LDZ.GE.1.
   *
   *     WORK  (workspace/output) DOUBLE PRECISION array, dimension (LWORK)
   *           On exit, if INFO = 0, WORK(1) returns an estimate of
   *           the optimal value for LWORK.
   *
   *     LWORK (input) INTEGER
   *           The dimension of the array WORK.  LWORK .GE. max(1,N)
   *           is sufficient, but LWORK typically as large as 6*N may
   *           be required for optimal performance.  A workspace query
   *           to determine the optimal workspace size is recommended.
   *
   *           If LWORK = -1, then DHSEQR does a workspace query.
   *           In this case, DHSEQR checks the input parameters and
   *           estimates the optimal workspace size for the given
   *           values of N, ILO and IHI.  The estimate is returned
   *           in WORK(1).  No error message related to LWORK is
   *           issued by XERBLA.  Neither H nor Z are accessed.
   *
   *
   *     INFO  (output) INTEGER
   *             =  0:  successful exit
   *           .LT. 0:  if INFO = -i, the i-th argument had an illegal
   *                    value
   *           .GT. 0:  if INFO = i, DHSEQR failed to compute all of
   *                the eigenvalues.  Elements 1:ilo-1 and i+1:n of WR
   *                and WI contain those eigenvalues which have been
   *                successfully computed.  (Failures are rare.)
   *
   *                If INFO .GT. 0 and JOB = 'E', then on exit, the
   *                remaining unconverged eigenvalues are the eigen-
   *                values of the upper Hessenberg matrix rows and
   *                columns ILO through INFO of the final, output
   *                value of H.
   *
   *                If INFO .GT. 0 and JOB   = 'S', then on exit
   *
   *           (*)  (initial value of H)*U  = U*(final value of H)
   *
   *                where U is an orthogonal matrix.  The final
   *                value of H is upper Hessenberg and quasi-triangular
   *                in rows and columns INFO+1 through IHI.
   *
   *                If INFO .GT. 0 and COMPZ = 'V', then on exit
   *
   *                  (final value of Z)  =  (initial value of Z)*U
   *
   *                where U is the orthogonal matrix in (*) (regard-
   *                less of the value of JOB.)
   *
   *                If INFO .GT. 0 and COMPZ = 'I', then on exit
   *                      (final value of Z)  = U
   *                where U is the orthogonal matrix in (*) (regard-
   *                less of the value of JOB.)
   *
   *                If INFO .GT. 0 and COMPZ = 'N', then Z is not
   *                accessed.
   *
   *     ================================================================
   *             Default values supplied by
   *             ILAENV(ISPEC,'DHSEQR',JOB(:1)//COMPZ(:1),N,ILO,IHI,LWORK).
   *             It is suggested that these defaults be adjusted in order
   *             to attain best performance in each particular
   *             computational environment.
   *
   *            ISPEC=1:  The DLAHQR vs DLAQR0 crossover point.
   *                      Default: 75. (Must be at least 11.)
   *
   *            ISPEC=2:  Recommended deflation window size.
   *                      This depends on ILO, IHI and NS.  NS is the
   *                      number of simultaneous shifts returned
   *                      by ILAENV(ISPEC=4).  (See ISPEC=4 below.)
   *                      The default for (IHI-ILO+1).LE.500 is NS.
   *                      The default for (IHI-ILO+1).GT.500 is 3*NS/2.
   *
   *            ISPEC=3:  Nibble crossover point. (See ILAENV for
   *                      details.)  Default: 14% of deflation window
   *                      size.
   *
   *            ISPEC=4:  Number of simultaneous shifts, NS, in
   *                      a multi-shift QR iteration.
   *
   *                      If IHI-ILO+1 is ...
   *
   *                      greater than      ...but less    ... the
   *                      or equal to ...      than        default is
   *
   *                           1               30          NS -   2(+)
   *                          30               60          NS -   4(+)
   *                          60              150          NS =  10(+)
   *                         150              590          NS =  **
   *                         590             3000          NS =  64
   *                        3000             6000          NS = 128
   *                        6000             infinity      NS = 256
   *
   *                  (+)  By default some or all matrices of this order 
   *                       are passed to the implicit double shift routine
   *                       DLAHQR and NS is ignored.  See ISPEC=1 above 
   *                       and comments in IPARM for details.
   *
   *                       The asterisks (**) indicate an ad-hoc
   *                       function of N increasing from 10 to 64.
   *
   *            ISPEC=5:  Select structured matrix multiply.
   *                      (See ILAENV for details.) Default: 3.
   *
   *     ================================================================
   *     Based on contributions by
   *        Karen Braman and Ralph Byers, Department of Mathematics,
   *        University of Kansas, USA
   *
   *     ================================================================
   *     References:
   *       K. Braman, R. Byers and R. Mathias, The Multi-Shift QR
   *       Algorithm Part I: Maintaining Well Focused Shifts, and Level 3
   *       Performance, SIAM Journal of Matrix Analysis, volume 23, pages
   *       929--947, 2002.
   *
   *       K. Braman, R. Byers and R. Mathias, The Multi-Shift QR
   *       Algorithm Part II: Aggressive Early Deflation, SIAM Journal
   *       of Matrix Analysis, volume 23, pages 948--973, 2002.
   *
   *     ================================================================
   *     .. Parameters ..
   *
   *     ==== Matrices of order NTINY or smaller must be processed by
   *     .    DLAHQR because of insufficient subdiagonal scratch space.
   *     .    (This is a hard limit.) ====
   *
   *     ==== NL allocates some local workspace to help small matrices
   *     .    through a rare DLAHQR failure.  NL .GT. NTINY = 11 is
   *     .    required and NL .LE. NMIN = ILAENV(ISPEC=1,...) is recom-
   *     .    mended.  (The default value of NMIN is 75.)  Using NL = 49
   *     .    allows up to six simultaneous shifts and a 16-by-16
   *     .    deflation window.  ====
   *
   * </code></pre>
   *
   * @param job
   * @param compz
   * @param n
   * @param ilo
   * @param ihi
   * @param h
   * @param ldh
   * @param wr
   * @param wi
   * @param z
   * @param ldz
   * @param work
   * @param lwork
   * @param info
   * 
   */
  abstract public void dhseqr(java.lang.String job, java.lang.String compz, int n, int ilo, int ihi, double[] h, int ldh, double[] wr, double[] wi, double[] z, int ldz, double[] work, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *     Purpose
   *     =======
   *
   *     DHSEQR computes the eigenvalues of a Hessenberg matrix H
   *     and, optionally, the matrices T and Z from the Schur decomposition
   *     H = Z T Z**T, where T is an upper quasi-triangular matrix (the
   *     Schur form), and Z is the orthogonal matrix of Schur vectors.
   *
   *     Optionally Z may be postmultiplied into an input orthogonal
   *     matrix Q so that this routine can give the Schur factorization
   *     of a matrix A which has been reduced to the Hessenberg form H
   *     by the orthogonal matrix Q:  A = Q*H*Q**T = (QZ)*T*(QZ)**T.
   *
   *     Arguments
   *     =========
   *
   *     JOB   (input) CHARACTER*1
   *           = 'E':  compute eigenvalues only;
   *           = 'S':  compute eigenvalues and the Schur form T.
   *
   *     COMPZ (input) CHARACTER*1
   *           = 'N':  no Schur vectors are computed;
   *           = 'I':  Z is initialized to the unit matrix and the matrix Z
   *                   of Schur vectors of H is returned;
   *           = 'V':  Z must contain an orthogonal matrix Q on entry, and
   *                   the product Q*Z is returned.
   *
   *     N     (input) INTEGER
   *           The order of the matrix H.  N .GE. 0.
   *
   *     ILO   (input) INTEGER
   *     IHI   (input) INTEGER
   *           It is assumed that H is already upper triangular in rows
   *           and columns 1:ILO-1 and IHI+1:N. ILO and IHI are normally
   *           set by a previous call to DGEBAL, and then passed to DGEHRD
   *           when the matrix output by DGEBAL is reduced to Hessenberg
   *           form. Otherwise ILO and IHI should be set to 1 and N
   *           respectively.  If N.GT.0, then 1.LE.ILO.LE.IHI.LE.N.
   *           If N = 0, then ILO = 1 and IHI = 0.
   *
   *     H     (input/output) DOUBLE PRECISION array, dimension (LDH,N)
   *           On entry, the upper Hessenberg matrix H.
   *           On exit, if INFO = 0 and JOB = 'S', then H contains the
   *           upper quasi-triangular matrix T from the Schur decomposition
   *           (the Schur form); 2-by-2 diagonal blocks (corresponding to
   *           complex conjugate pairs of eigenvalues) are returned in
   *           standard form, with H(i,i) = H(i+1,i+1) and
   *           H(i+1,i)*H(i,i+1).LT.0. If INFO = 0 and JOB = 'E', the
   *           contents of H are unspecified on exit.  (The output value of
   *           H when INFO.GT.0 is given under the description of INFO
   *           below.)
   *
   *           Unlike earlier versions of DHSEQR, this subroutine may
   *           explicitly H(i,j) = 0 for i.GT.j and j = 1, 2, ... ILO-1
   *           or j = IHI+1, IHI+2, ... N.
   *
   *     LDH   (input) INTEGER
   *           The leading dimension of the array H. LDH .GE. max(1,N).
   *
   *     WR    (output) DOUBLE PRECISION array, dimension (N)
   *     WI    (output) DOUBLE PRECISION array, dimension (N)
   *           The real and imaginary parts, respectively, of the computed
   *           eigenvalues. If two eigenvalues are computed as a complex
   *           conjugate pair, they are stored in consecutive elements of
   *           WR and WI, say the i-th and (i+1)th, with WI(i) .GT. 0 and
   *           WI(i+1) .LT. 0. If JOB = 'S', the eigenvalues are stored in
   *           the same order as on the diagonal of the Schur form returned
   *           in H, with WR(i) = H(i,i) and, if H(i:i+1,i:i+1) is a 2-by-2
   *           diagonal block, WI(i) = sqrt(-H(i+1,i)*H(i,i+1)) and
   *           WI(i+1) = -WI(i).
   *
   *     Z     (input/output) DOUBLE PRECISION array, dimension (LDZ,N)
   *           If COMPZ = 'N', Z is not referenced.
   *           If COMPZ = 'I', on entry Z need not be set and on exit,
   *           if INFO = 0, Z contains the orthogonal matrix Z of the Schur
   *           vectors of H.  If COMPZ = 'V', on entry Z must contain an
   *           N-by-N matrix Q, which is assumed to be equal to the unit
   *           matrix except for the submatrix Z(ILO:IHI,ILO:IHI). On exit,
   *           if INFO = 0, Z contains Q*Z.
   *           Normally Q is the orthogonal matrix generated by DORGHR
   *           after the call to DGEHRD which formed the Hessenberg matrix
   *           H. (The output value of Z when INFO.GT.0 is given under
   *           the description of INFO below.)
   *
   *     LDZ   (input) INTEGER
   *           The leading dimension of the array Z.  if COMPZ = 'I' or
   *           COMPZ = 'V', then LDZ.GE.MAX(1,N).  Otherwize, LDZ.GE.1.
   *
   *     WORK  (workspace/output) DOUBLE PRECISION array, dimension (LWORK)
   *           On exit, if INFO = 0, WORK(1) returns an estimate of
   *           the optimal value for LWORK.
   *
   *     LWORK (input) INTEGER
   *           The dimension of the array WORK.  LWORK .GE. max(1,N)
   *           is sufficient, but LWORK typically as large as 6*N may
   *           be required for optimal performance.  A workspace query
   *           to determine the optimal workspace size is recommended.
   *
   *           If LWORK = -1, then DHSEQR does a workspace query.
   *           In this case, DHSEQR checks the input parameters and
   *           estimates the optimal workspace size for the given
   *           values of N, ILO and IHI.  The estimate is returned
   *           in WORK(1).  No error message related to LWORK is
   *           issued by XERBLA.  Neither H nor Z are accessed.
   *
   *
   *     INFO  (output) INTEGER
   *             =  0:  successful exit
   *           .LT. 0:  if INFO = -i, the i-th argument had an illegal
   *                    value
   *           .GT. 0:  if INFO = i, DHSEQR failed to compute all of
   *                the eigenvalues.  Elements 1:ilo-1 and i+1:n of WR
   *                and WI contain those eigenvalues which have been
   *                successfully computed.  (Failures are rare.)
   *
   *                If INFO .GT. 0 and JOB = 'E', then on exit, the
   *                remaining unconverged eigenvalues are the eigen-
   *                values of the upper Hessenberg matrix rows and
   *                columns ILO through INFO of the final, output
   *                value of H.
   *
   *                If INFO .GT. 0 and JOB   = 'S', then on exit
   *
   *           (*)  (initial value of H)*U  = U*(final value of H)
   *
   *                where U is an orthogonal matrix.  The final
   *                value of H is upper Hessenberg and quasi-triangular
   *                in rows and columns INFO+1 through IHI.
   *
   *                If INFO .GT. 0 and COMPZ = 'V', then on exit
   *
   *                  (final value of Z)  =  (initial value of Z)*U
   *
   *                where U is the orthogonal matrix in (*) (regard-
   *                less of the value of JOB.)
   *
   *                If INFO .GT. 0 and COMPZ = 'I', then on exit
   *                      (final value of Z)  = U
   *                where U is the orthogonal matrix in (*) (regard-
   *                less of the value of JOB.)
   *
   *                If INFO .GT. 0 and COMPZ = 'N', then Z is not
   *                accessed.
   *
   *     ================================================================
   *             Default values supplied by
   *             ILAENV(ISPEC,'DHSEQR',JOB(:1)//COMPZ(:1),N,ILO,IHI,LWORK).
   *             It is suggested that these defaults be adjusted in order
   *             to attain best performance in each particular
   *             computational environment.
   *
   *            ISPEC=1:  The DLAHQR vs DLAQR0 crossover point.
   *                      Default: 75. (Must be at least 11.)
   *
   *            ISPEC=2:  Recommended deflation window size.
   *                      This depends on ILO, IHI and NS.  NS is the
   *                      number of simultaneous shifts returned
   *                      by ILAENV(ISPEC=4).  (See ISPEC=4 below.)
   *                      The default for (IHI-ILO+1).LE.500 is NS.
   *                      The default for (IHI-ILO+1).GT.500 is 3*NS/2.
   *
   *            ISPEC=3:  Nibble crossover point. (See ILAENV for
   *                      details.)  Default: 14% of deflation window
   *                      size.
   *
   *            ISPEC=4:  Number of simultaneous shifts, NS, in
   *                      a multi-shift QR iteration.
   *
   *                      If IHI-ILO+1 is ...
   *
   *                      greater than      ...but less    ... the
   *                      or equal to ...      than        default is
   *
   *                           1               30          NS -   2(+)
   *                          30               60          NS -   4(+)
   *                          60              150          NS =  10(+)
   *                         150              590          NS =  **
   *                         590             3000          NS =  64
   *                        3000             6000          NS = 128
   *                        6000             infinity      NS = 256
   *
   *                  (+)  By default some or all matrices of this order 
   *                       are passed to the implicit double shift routine
   *                       DLAHQR and NS is ignored.  See ISPEC=1 above 
   *                       and comments in IPARM for details.
   *
   *                       The asterisks (**) indicate an ad-hoc
   *                       function of N increasing from 10 to 64.
   *
   *            ISPEC=5:  Select structured matrix multiply.
   *                      (See ILAENV for details.) Default: 3.
   *
   *     ================================================================
   *     Based on contributions by
   *        Karen Braman and Ralph Byers, Department of Mathematics,
   *        University of Kansas, USA
   *
   *     ================================================================
   *     References:
   *       K. Braman, R. Byers and R. Mathias, The Multi-Shift QR
   *       Algorithm Part I: Maintaining Well Focused Shifts, and Level 3
   *       Performance, SIAM Journal of Matrix Analysis, volume 23, pages
   *       929--947, 2002.
   *
   *       K. Braman, R. Byers and R. Mathias, The Multi-Shift QR
   *       Algorithm Part II: Aggressive Early Deflation, SIAM Journal
   *       of Matrix Analysis, volume 23, pages 948--973, 2002.
   *
   *     ================================================================
   *     .. Parameters ..
   *
   *     ==== Matrices of order NTINY or smaller must be processed by
   *     .    DLAHQR because of insufficient subdiagonal scratch space.
   *     .    (This is a hard limit.) ====
   *
   *     ==== NL allocates some local workspace to help small matrices
   *     .    through a rare DLAHQR failure.  NL .GT. NTINY = 11 is
   *     .    required and NL .LE. NMIN = ILAENV(ISPEC=1,...) is recom-
   *     .    mended.  (The default value of NMIN is 75.)  Using NL = 49
   *     .    allows up to six simultaneous shifts and a 16-by-16
   *     .    deflation window.  ====
   *
   * </code></pre>
   *
   * @param job
   * @param compz
   * @param n
   * @param ilo
   * @param ihi
   * @param h
   * @param _h_offset
   * @param ldh
   * @param wr
   * @param _wr_offset
   * @param wi
   * @param _wi_offset
   * @param z
   * @param _z_offset
   * @param ldz
   * @param work
   * @param _work_offset
   * @param lwork
   * @param info
   * 
   */
  abstract public void dhseqr(java.lang.String job, java.lang.String compz, int n, int ilo, int ihi, double[] h, int _h_offset, int ldh, double[] wr, int _wr_offset, double[] wi, int _wi_offset, double[] z, int _z_offset, int ldz, double[] work, int _work_offset, int lwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DISNAN returns .TRUE. if its argument is NaN, and .FALSE.
   *  otherwise.  To be replaced by the Fortran 2003 intrinsic in the
   *  future.
   *
   *  Arguments
   *  =========
   *
   *  DIN      (input) DOUBLE PRECISION
   *          Input to test for NaN.
   *
   *  =====================================================================
   *
   *  .. External Functions ..
   * </code></pre>
   *
   * @param din
   * @return
   */
  abstract public boolean disnan(double din);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLABAD takes as input the values computed by DLAMCH for underflow and
   *  overflow, and returns the square root of each of these values if the
   *  log of LARGE is sufficiently large.  This subroutine is intended to
   *  identify machines with a large exponent range, such as the Crays, and
   *  redefine the underflow and overflow limits to be the square roots of
   *  the values computed by DLAMCH.  This subroutine is needed because
   *  DLAMCH does not compensate for poor arithmetic in the upper half of
   *  the exponent range, as is found on a Cray.
   *
   *  Arguments
   *  =========
   *
   *  SMALL   (input/output) DOUBLE PRECISION
   *          On entry, the underflow threshold as computed by DLAMCH.
   *          On exit, if LOG10(LARGE) is sufficiently large, the square
   *          root of SMALL, otherwise unchanged.
   *
   *  LARGE   (input/output) DOUBLE PRECISION
   *          On entry, the overflow threshold as computed by DLAMCH.
   *          On exit, if LOG10(LARGE) is sufficiently large, the square
   *          root of LARGE, otherwise unchanged.
   *
   *  =====================================================================
   *
   *     .. Intrinsic Functions ..
   * </code></pre>
   *
   * @param small
   * @param large
   * 
   */
  abstract public void dlabad(org.netlib.util.doubleW small, org.netlib.util.doubleW large);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLABRD reduces the first NB rows and columns of a real general
   *  m by n matrix A to upper or lower bidiagonal form by an orthogonal
   *  transformation Q' * A * P, and returns the matrices X and Y which
   *  are needed to apply the transformation to the unreduced part of A.
   *
   *  If m >= n, A is reduced to upper bidiagonal form; if m < n, to lower
   *  bidiagonal form.
   *
   *  This is an auxiliary routine called by DGEBRD
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows in the matrix A.
   *
   *  N       (input) INTEGER
   *          The number of columns in the matrix A.
   *
   *  NB      (input) INTEGER
   *          The number of leading rows and columns of A to be reduced.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the m by n general matrix to be reduced.
   *          On exit, the first NB rows and columns of the matrix are
   *          overwritten; the rest of the array is unchanged.
   *          If m >= n, elements on and below the diagonal in the first NB
   *            columns, with the array TAUQ, represent the orthogonal
   *            matrix Q as a product of elementary reflectors; and
   *            elements above the diagonal in the first NB rows, with the
   *            array TAUP, represent the orthogonal matrix P as a product
   *            of elementary reflectors.
   *          If m < n, elements below the diagonal in the first NB
   *            columns, with the array TAUQ, represent the orthogonal
   *            matrix Q as a product of elementary reflectors, and
   *            elements on and above the diagonal in the first NB rows,
   *            with the array TAUP, represent the orthogonal matrix P as
   *            a product of elementary reflectors.
   *          See Further Details.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  D       (output) DOUBLE PRECISION array, dimension (NB)
   *          The diagonal elements of the first NB rows and columns of
   *          the reduced matrix.  D(i) = A(i,i).
   *
   *  E       (output) DOUBLE PRECISION array, dimension (NB)
   *          The off-diagonal elements of the first NB rows and columns of
   *          the reduced matrix.
   *
   *  TAUQ    (output) DOUBLE PRECISION array dimension (NB)
   *          The scalar factors of the elementary reflectors which
   *          represent the orthogonal matrix Q. See Further Details.
   *
   *  TAUP    (output) DOUBLE PRECISION array, dimension (NB)
   *          The scalar factors of the elementary reflectors which
   *          represent the orthogonal matrix P. See Further Details.
   *
   *  X       (output) DOUBLE PRECISION array, dimension (LDX,NB)
   *          The m-by-nb matrix X required to update the unreduced part
   *          of A.
   *
   *  LDX     (input) INTEGER
   *          The leading dimension of the array X. LDX >= M.
   *
   *  Y       (output) DOUBLE PRECISION array, dimension (LDY,NB)
   *          The n-by-nb matrix Y required to update the unreduced part
   *          of A.
   *
   *  LDY     (input) INTEGER
   *          The leading dimension of the array Y. LDY >= N.
   *
   *  Further Details
   *  ===============
   *
   *  The matrices Q and P are represented as products of elementary
   *  reflectors:
   *
   *     Q = H(1) H(2) . . . H(nb)  and  P = G(1) G(2) . . . G(nb)
   *
   *  Each H(i) and G(i) has the form:
   *
   *     H(i) = I - tauq * v * v'  and G(i) = I - taup * u * u'
   *
   *  where tauq and taup are real scalars, and v and u are real vectors.
   *
   *  If m >= n, v(1:i-1) = 0, v(i) = 1, and v(i:m) is stored on exit in
   *  A(i:m,i); u(1:i) = 0, u(i+1) = 1, and u(i+1:n) is stored on exit in
   *  A(i,i+1:n); tauq is stored in TAUQ(i) and taup in TAUP(i).
   *
   *  If m < n, v(1:i) = 0, v(i+1) = 1, and v(i+1:m) is stored on exit in
   *  A(i+2:m,i); u(1:i-1) = 0, u(i) = 1, and u(i:n) is stored on exit in
   *  A(i,i+1:n); tauq is stored in TAUQ(i) and taup in TAUP(i).
   *
   *  The elements of the vectors v and u together form the m-by-nb matrix
   *  V and the nb-by-n matrix U' which are needed, with X and Y, to apply
   *  the transformation to the unreduced part of the matrix, using a block
   *  update of the form:  A := A - V*Y' - X*U'.
   *
   *  The contents of A on exit are illustrated by the following examples
   *  with nb = 2:
   *
   *  m = 6 and n = 5 (m > n):          m = 5 and n = 6 (m < n):
   *
   *    (  1   1   u1  u1  u1 )           (  1   u1  u1  u1  u1  u1 )
   *    (  v1  1   1   u2  u2 )           (  1   1   u2  u2  u2  u2 )
   *    (  v1  v2  a   a   a  )           (  v1  1   a   a   a   a  )
   *    (  v1  v2  a   a   a  )           (  v1  v2  a   a   a   a  )
   *    (  v1  v2  a   a   a  )           (  v1  v2  a   a   a   a  )
   *    (  v1  v2  a   a   a  )
   *
   *  where a denotes an element of the original matrix which is unchanged,
   *  vi denotes an element of the vector defining H(i), and ui an element
   *  of the vector defining G(i).
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param nb
   * @param a
   * @param lda
   * @param d
   * @param e
   * @param tauq
   * @param taup
   * @param x
   * @param ldx
   * @param y
   * @param ldy
   * 
   */
  abstract public void dlabrd(int m, int n, int nb, double[] a, int lda, double[] d, double[] e, double[] tauq, double[] taup, double[] x, int ldx, double[] y, int ldy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLABRD reduces the first NB rows and columns of a real general
   *  m by n matrix A to upper or lower bidiagonal form by an orthogonal
   *  transformation Q' * A * P, and returns the matrices X and Y which
   *  are needed to apply the transformation to the unreduced part of A.
   *
   *  If m >= n, A is reduced to upper bidiagonal form; if m < n, to lower
   *  bidiagonal form.
   *
   *  This is an auxiliary routine called by DGEBRD
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of rows in the matrix A.
   *
   *  N       (input) INTEGER
   *          The number of columns in the matrix A.
   *
   *  NB      (input) INTEGER
   *          The number of leading rows and columns of A to be reduced.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the m by n general matrix to be reduced.
   *          On exit, the first NB rows and columns of the matrix are
   *          overwritten; the rest of the array is unchanged.
   *          If m >= n, elements on and below the diagonal in the first NB
   *            columns, with the array TAUQ, represent the orthogonal
   *            matrix Q as a product of elementary reflectors; and
   *            elements above the diagonal in the first NB rows, with the
   *            array TAUP, represent the orthogonal matrix P as a product
   *            of elementary reflectors.
   *          If m < n, elements below the diagonal in the first NB
   *            columns, with the array TAUQ, represent the orthogonal
   *            matrix Q as a product of elementary reflectors, and
   *            elements on and above the diagonal in the first NB rows,
   *            with the array TAUP, represent the orthogonal matrix P as
   *            a product of elementary reflectors.
   *          See Further Details.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  D       (output) DOUBLE PRECISION array, dimension (NB)
   *          The diagonal elements of the first NB rows and columns of
   *          the reduced matrix.  D(i) = A(i,i).
   *
   *  E       (output) DOUBLE PRECISION array, dimension (NB)
   *          The off-diagonal elements of the first NB rows and columns of
   *          the reduced matrix.
   *
   *  TAUQ    (output) DOUBLE PRECISION array dimension (NB)
   *          The scalar factors of the elementary reflectors which
   *          represent the orthogonal matrix Q. See Further Details.
   *
   *  TAUP    (output) DOUBLE PRECISION array, dimension (NB)
   *          The scalar factors of the elementary reflectors which
   *          represent the orthogonal matrix P. See Further Details.
   *
   *  X       (output) DOUBLE PRECISION array, dimension (LDX,NB)
   *          The m-by-nb matrix X required to update the unreduced part
   *          of A.
   *
   *  LDX     (input) INTEGER
   *          The leading dimension of the array X. LDX >= M.
   *
   *  Y       (output) DOUBLE PRECISION array, dimension (LDY,NB)
   *          The n-by-nb matrix Y required to update the unreduced part
   *          of A.
   *
   *  LDY     (input) INTEGER
   *          The leading dimension of the array Y. LDY >= N.
   *
   *  Further Details
   *  ===============
   *
   *  The matrices Q and P are represented as products of elementary
   *  reflectors:
   *
   *     Q = H(1) H(2) . . . H(nb)  and  P = G(1) G(2) . . . G(nb)
   *
   *  Each H(i) and G(i) has the form:
   *
   *     H(i) = I - tauq * v * v'  and G(i) = I - taup * u * u'
   *
   *  where tauq and taup are real scalars, and v and u are real vectors.
   *
   *  If m >= n, v(1:i-1) = 0, v(i) = 1, and v(i:m) is stored on exit in
   *  A(i:m,i); u(1:i) = 0, u(i+1) = 1, and u(i+1:n) is stored on exit in
   *  A(i,i+1:n); tauq is stored in TAUQ(i) and taup in TAUP(i).
   *
   *  If m < n, v(1:i) = 0, v(i+1) = 1, and v(i+1:m) is stored on exit in
   *  A(i+2:m,i); u(1:i-1) = 0, u(i) = 1, and u(i:n) is stored on exit in
   *  A(i,i+1:n); tauq is stored in TAUQ(i) and taup in TAUP(i).
   *
   *  The elements of the vectors v and u together form the m-by-nb matrix
   *  V and the nb-by-n matrix U' which are needed, with X and Y, to apply
   *  the transformation to the unreduced part of the matrix, using a block
   *  update of the form:  A := A - V*Y' - X*U'.
   *
   *  The contents of A on exit are illustrated by the following examples
   *  with nb = 2:
   *
   *  m = 6 and n = 5 (m > n):          m = 5 and n = 6 (m < n):
   *
   *    (  1   1   u1  u1  u1 )           (  1   u1  u1  u1  u1  u1 )
   *    (  v1  1   1   u2  u2 )           (  1   1   u2  u2  u2  u2 )
   *    (  v1  v2  a   a   a  )           (  v1  1   a   a   a   a  )
   *    (  v1  v2  a   a   a  )           (  v1  v2  a   a   a   a  )
   *    (  v1  v2  a   a   a  )           (  v1  v2  a   a   a   a  )
   *    (  v1  v2  a   a   a  )
   *
   *  where a denotes an element of the original matrix which is unchanged,
   *  vi denotes an element of the vector defining H(i), and ui an element
   *  of the vector defining G(i).
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param nb
   * @param a
   * @param _a_offset
   * @param lda
   * @param d
   * @param _d_offset
   * @param e
   * @param _e_offset
   * @param tauq
   * @param _tauq_offset
   * @param taup
   * @param _taup_offset
   * @param x
   * @param _x_offset
   * @param ldx
   * @param y
   * @param _y_offset
   * @param ldy
   * 
   */
  abstract public void dlabrd(int m, int n, int nb, double[] a, int _a_offset, int lda, double[] d, int _d_offset, double[] e, int _e_offset, double[] tauq, int _tauq_offset, double[] taup, int _taup_offset, double[] x, int _x_offset, int ldx, double[] y, int _y_offset, int ldy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLACN2 estimates the 1-norm of a square, real matrix A.
   *  Reverse communication is used for evaluating matrix-vector products.
   *
   *  Arguments
   *  =========
   *
   *  N      (input) INTEGER
   *         The order of the matrix.  N >= 1.
   *
   *  V      (workspace) DOUBLE PRECISION array, dimension (N)
   *         On the final return, V = A*W,  where  EST = norm(V)/norm(W)
   *         (W is not returned).
   *
   *  X      (input/output) DOUBLE PRECISION array, dimension (N)
   *         On an intermediate return, X should be overwritten by
   *               A * X,   if KASE=1,
   *               A' * X,  if KASE=2,
   *         and DLACN2 must be re-called with all the other parameters
   *         unchanged.
   *
   *  ISGN   (workspace) INTEGER array, dimension (N)
   *
   *  EST    (input/output) DOUBLE PRECISION
   *         On entry with KASE = 1 or 2 and ISAVE(1) = 3, EST should be
   *         unchanged from the previous call to DLACN2.
   *         On exit, EST is an estimate (a lower bound) for norm(A). 
   *
   *  KASE   (input/output) INTEGER
   *         On the initial call to DLACN2, KASE should be 0.
   *         On an intermediate return, KASE will be 1 or 2, indicating
   *         whether X should be overwritten by A * X  or A' * X.
   *         On the final return from DLACN2, KASE will again be 0.
   *
   *  ISAVE  (input/output) INTEGER array, dimension (3)
   *         ISAVE is used to save variables between calls to DLACN2
   *
   *  Further Details
   *  ======= =======
   *
   *  Contributed by Nick Higham, University of Manchester.
   *  Originally named SONEST, dated March 16, 1988.
   *
   *  Reference: N.J. Higham, "FORTRAN codes for estimating the one-norm of
   *  a real or complex matrix, with applications to condition estimation",
   *  ACM Trans. Math. Soft., vol. 14, no. 4, pp. 381-396, December 1988.
   *
   *  This is a thread safe version of DLACON, which uses the array ISAVE
   *  in place of a SAVE statement, as follows:
   *
   *     DLACON     DLACN2
   *      JUMP     ISAVE(1)
   *      J        ISAVE(2)
   *      ITER     ISAVE(3)
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param v
   * @param x
   * @param isgn
   * @param est
   * @param kase
   * @param isave
   * 
   */
  abstract public void dlacn2(int n, double[] v, double[] x, int[] isgn, org.netlib.util.doubleW est, org.netlib.util.intW kase, int[] isave);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLACN2 estimates the 1-norm of a square, real matrix A.
   *  Reverse communication is used for evaluating matrix-vector products.
   *
   *  Arguments
   *  =========
   *
   *  N      (input) INTEGER
   *         The order of the matrix.  N >= 1.
   *
   *  V      (workspace) DOUBLE PRECISION array, dimension (N)
   *         On the final return, V = A*W,  where  EST = norm(V)/norm(W)
   *         (W is not returned).
   *
   *  X      (input/output) DOUBLE PRECISION array, dimension (N)
   *         On an intermediate return, X should be overwritten by
   *               A * X,   if KASE=1,
   *               A' * X,  if KASE=2,
   *         and DLACN2 must be re-called with all the other parameters
   *         unchanged.
   *
   *  ISGN   (workspace) INTEGER array, dimension (N)
   *
   *  EST    (input/output) DOUBLE PRECISION
   *         On entry with KASE = 1 or 2 and ISAVE(1) = 3, EST should be
   *         unchanged from the previous call to DLACN2.
   *         On exit, EST is an estimate (a lower bound) for norm(A). 
   *
   *  KASE   (input/output) INTEGER
   *         On the initial call to DLACN2, KASE should be 0.
   *         On an intermediate return, KASE will be 1 or 2, indicating
   *         whether X should be overwritten by A * X  or A' * X.
   *         On the final return from DLACN2, KASE will again be 0.
   *
   *  ISAVE  (input/output) INTEGER array, dimension (3)
   *         ISAVE is used to save variables between calls to DLACN2
   *
   *  Further Details
   *  ======= =======
   *
   *  Contributed by Nick Higham, University of Manchester.
   *  Originally named SONEST, dated March 16, 1988.
   *
   *  Reference: N.J. Higham, "FORTRAN codes for estimating the one-norm of
   *  a real or complex matrix, with applications to condition estimation",
   *  ACM Trans. Math. Soft., vol. 14, no. 4, pp. 381-396, December 1988.
   *
   *  This is a thread safe version of DLACON, which uses the array ISAVE
   *  in place of a SAVE statement, as follows:
   *
   *     DLACON     DLACN2
   *      JUMP     ISAVE(1)
   *      J        ISAVE(2)
   *      ITER     ISAVE(3)
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param v
   * @param _v_offset
   * @param x
   * @param _x_offset
   * @param isgn
   * @param _isgn_offset
   * @param est
   * @param kase
   * @param isave
   * @param _isave_offset
   * 
   */
  abstract public void dlacn2(int n, double[] v, int _v_offset, double[] x, int _x_offset, int[] isgn, int _isgn_offset, org.netlib.util.doubleW est, org.netlib.util.intW kase, int[] isave, int _isave_offset);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLACON estimates the 1-norm of a square, real matrix A.
   *  Reverse communication is used for evaluating matrix-vector products.
   *
   *  Arguments
   *  =========
   *
   *  N      (input) INTEGER
   *         The order of the matrix.  N >= 1.
   *
   *  V      (workspace) DOUBLE PRECISION array, dimension (N)
   *         On the final return, V = A*W,  where  EST = norm(V)/norm(W)
   *         (W is not returned).
   *
   *  X      (input/output) DOUBLE PRECISION array, dimension (N)
   *         On an intermediate return, X should be overwritten by
   *               A * X,   if KASE=1,
   *               A' * X,  if KASE=2,
   *         and DLACON must be re-called with all the other parameters
   *         unchanged.
   *
   *  ISGN   (workspace) INTEGER array, dimension (N)
   *
   *  EST    (input/output) DOUBLE PRECISION
   *         On entry with KASE = 1 or 2 and JUMP = 3, EST should be
   *         unchanged from the previous call to DLACON.
   *         On exit, EST is an estimate (a lower bound) for norm(A). 
   *
   *  KASE   (input/output) INTEGER
   *         On the initial call to DLACON, KASE should be 0.
   *         On an intermediate return, KASE will be 1 or 2, indicating
   *         whether X should be overwritten by A * X  or A' * X.
   *         On the final return from DLACON, KASE will again be 0.
   *
   *  Further Details
   *  ======= =======
   *
   *  Contributed by Nick Higham, University of Manchester.
   *  Originally named SONEST, dated March 16, 1988.
   *
   *  Reference: N.J. Higham, "FORTRAN codes for estimating the one-norm of
   *  a real or complex matrix, with applications to condition estimation",
   *  ACM Trans. Math. Soft., vol. 14, no. 4, pp. 381-396, December 1988.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param v
   * @param x
   * @param isgn
   * @param est
   * @param kase
   * 
   */
  abstract public void dlacon(int n, double[] v, double[] x, int[] isgn, org.netlib.util.doubleW est, org.netlib.util.intW kase);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLACON estimates the 1-norm of a square, real matrix A.
   *  Reverse communication is used for evaluating matrix-vector products.
   *
   *  Arguments
   *  =========
   *
   *  N      (input) INTEGER
   *         The order of the matrix.  N >= 1.
   *
   *  V      (workspace) DOUBLE PRECISION array, dimension (N)
   *         On the final return, V = A*W,  where  EST = norm(V)/norm(W)
   *         (W is not returned).
   *
   *  X      (input/output) DOUBLE PRECISION array, dimension (N)
   *         On an intermediate return, X should be overwritten by
   *               A * X,   if KASE=1,
   *               A' * X,  if KASE=2,
   *         and DLACON must be re-called with all the other parameters
   *         unchanged.
   *
   *  ISGN   (workspace) INTEGER array, dimension (N)
   *
   *  EST    (input/output) DOUBLE PRECISION
   *         On entry with KASE = 1 or 2 and JUMP = 3, EST should be
   *         unchanged from the previous call to DLACON.
   *         On exit, EST is an estimate (a lower bound) for norm(A). 
   *
   *  KASE   (input/output) INTEGER
   *         On the initial call to DLACON, KASE should be 0.
   *         On an intermediate return, KASE will be 1 or 2, indicating
   *         whether X should be overwritten by A * X  or A' * X.
   *         On the final return from DLACON, KASE will again be 0.
   *
   *  Further Details
   *  ======= =======
   *
   *  Contributed by Nick Higham, University of Manchester.
   *  Originally named SONEST, dated March 16, 1988.
   *
   *  Reference: N.J. Higham, "FORTRAN codes for estimating the one-norm of
   *  a real or complex matrix, with applications to condition estimation",
   *  ACM Trans. Math. Soft., vol. 14, no. 4, pp. 381-396, December 1988.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param v
   * @param _v_offset
   * @param x
   * @param _x_offset
   * @param isgn
   * @param _isgn_offset
   * @param est
   * @param kase
   * 
   */
  abstract public void dlacon(int n, double[] v, int _v_offset, double[] x, int _x_offset, int[] isgn, int _isgn_offset, org.netlib.util.doubleW est, org.netlib.util.intW kase);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLACPY copies all or part of a two-dimensional matrix A to another
   *  matrix B.
   *
   *  Arguments
   *  =========
   *
   *  UPLO    (input) CHARACTER*1
   *          Specifies the part of the matrix A to be copied to B.
   *          = 'U':      Upper triangular part
   *          = 'L':      Lower triangular part
   *          Otherwise:  All of the matrix A
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
   *          The m by n matrix A.  If UPLO = 'U', only the upper triangle
   *          or trapezoid is accessed; if UPLO = 'L', only the lower
   *          triangle or trapezoid is accessed.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  B       (output) DOUBLE PRECISION array, dimension (LDB,N)
   *          On exit, B = A in the locations specified by UPLO.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,M).
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param uplo
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * 
   */
  abstract public void dlacpy(java.lang.String uplo, int m, int n, double[] a, int lda, double[] b, int ldb);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLACPY copies all or part of a two-dimensional matrix A to another
   *  matrix B.
   *
   *  Arguments
   *  =========
   *
   *  UPLO    (input) CHARACTER*1
   *          Specifies the part of the matrix A to be copied to B.
   *          = 'U':      Upper triangular part
   *          = 'L':      Lower triangular part
   *          Otherwise:  All of the matrix A
   *
   *  M       (input) INTEGER
   *          The number of rows of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
   *          The m by n matrix A.  If UPLO = 'U', only the upper triangle
   *          or trapezoid is accessed; if UPLO = 'L', only the lower
   *          triangle or trapezoid is accessed.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  B       (output) DOUBLE PRECISION array, dimension (LDB,N)
   *          On exit, B = A in the locations specified by UPLO.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(1,M).
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param uplo
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * 
   */
  abstract public void dlacpy(java.lang.String uplo, int m, int n, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLADIV performs complex division in  real arithmetic
   *
   *                        a + i*b
   *             p + i*q = ---------
   *                        c + i*d
   *
   *  The algorithm is due to Robert L. Smith and can be found
   *  in D. Knuth, The art of Computer Programming, Vol.2, p.195
   *
   *  Arguments
   *  =========
   *
   *  A       (input) DOUBLE PRECISION
   *  B       (input) DOUBLE PRECISION
   *  C       (input) DOUBLE PRECISION
   *  D       (input) DOUBLE PRECISION
   *          The scalars a, b, c, and d in the above expression.
   *
   *  P       (output) DOUBLE PRECISION
   *  Q       (output) DOUBLE PRECISION
   *          The scalars p and q in the above expression.
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param a
   * @param b
   * @param c
   * @param d
   * @param p
   * @param q
   * 
   */
  abstract public void dladiv(double a, double b, double c, double d, org.netlib.util.doubleW p, org.netlib.util.doubleW q);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAE2  computes the eigenvalues of a 2-by-2 symmetric matrix
   *     [  A   B  ]
   *     [  B   C  ].
   *  On return, RT1 is the eigenvalue of larger absolute value, and RT2
   *  is the eigenvalue of smaller absolute value.
   *
   *  Arguments
   *  =========
   *
   *  A       (input) DOUBLE PRECISION
   *          The (1,1) element of the 2-by-2 matrix.
   *
   *  B       (input) DOUBLE PRECISION
   *          The (1,2) and (2,1) elements of the 2-by-2 matrix.
   *
   *  C       (input) DOUBLE PRECISION
   *          The (2,2) element of the 2-by-2 matrix.
   *
   *  RT1     (output) DOUBLE PRECISION
   *          The eigenvalue of larger absolute value.
   *
   *  RT2     (output) DOUBLE PRECISION
   *          The eigenvalue of smaller absolute value.
   *
   *  Further Details
   *  ===============
   *
   *  RT1 is accurate to a few ulps barring over/underflow.
   *
   *  RT2 may be inaccurate if there is massive cancellation in the
   *  determinant A*C-B*B; higher precision or correctly rounded or
   *  correctly truncated arithmetic would be needed to compute RT2
   *  accurately in all cases.
   *
   *  Overflow is possible only if RT1 is within a factor of 5 of overflow.
   *  Underflow is harmless if the input data is 0 or exceeds
   *     underflow_threshold / macheps.
   *
   * =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param a
   * @param b
   * @param c
   * @param rt1
   * @param rt2
   * 
   */
  abstract public void dlae2(double a, double b, double c, org.netlib.util.doubleW rt1, org.netlib.util.doubleW rt2);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAEBZ contains the iteration loops which compute and use the
   *  function N(w), which is the count of eigenvalues of a symmetric
   *  tridiagonal matrix T less than or equal to its argument  w.  It
   *  performs a choice of two types of loops:
   *
   *  IJOB=1, followed by
   *  IJOB=2: It takes as input a list of intervals and returns a list of
   *          sufficiently small intervals whose union contains the same
   *          eigenvalues as the union of the original intervals.
   *          The input intervals are (AB(j,1),AB(j,2)], j=1,...,MINP.
   *          The output interval (AB(j,1),AB(j,2)] will contain
   *          eigenvalues NAB(j,1)+1,...,NAB(j,2), where 1 <= j <= MOUT.
   *
   *  IJOB=3: It performs a binary search in each input interval
   *          (AB(j,1),AB(j,2)] for a point  w(j)  such that
   *          N(w(j))=NVAL(j), and uses  C(j)  as the starting point of
   *          the search.  If such a w(j) is found, then on output
   *          AB(j,1)=AB(j,2)=w.  If no such w(j) is found, then on output
   *          (AB(j,1),AB(j,2)] will be a small interval containing the
   *          point where N(w) jumps through NVAL(j), unless that point
   *          lies outside the initial interval.
   *
   *  Note that the intervals are in all cases half-open intervals,
   *  i.e., of the form  (a,b] , which includes  b  but not  a .
   *
   *  To avoid underflow, the matrix should be scaled so that its largest
   *  element is no greater than  overflow**(1/2) * underflow**(1/4)
   *  in absolute value.  To assure the most accurate computation
   *  of small eigenvalues, the matrix should be scaled to be
   *  not much smaller than that, either.
   *
   *  See W. Kahan "Accurate Eigenvalues of a Symmetric Tridiagonal
   *  Matrix", Report CS41, Computer Science Dept., Stanford
   *  University, July 21, 1966
   *
   *  Note: the arguments are, in general, *not* checked for unreasonable
   *  values.
   *
   *  Arguments
   *  =========
   *
   *  IJOB    (input) INTEGER
   *          Specifies what is to be done:
   *          = 1:  Compute NAB for the initial intervals.
   *          = 2:  Perform bisection iteration to find eigenvalues of T.
   *          = 3:  Perform bisection iteration to invert N(w), i.e.,
   *                to find a point which has a specified number of
   *                eigenvalues of T to its left.
   *          Other values will cause DLAEBZ to return with INFO=-1.
   *
   *  NITMAX  (input) INTEGER
   *          The maximum number of "levels" of bisection to be
   *          performed, i.e., an interval of width W will not be made
   *          smaller than 2^(-NITMAX) * W.  If not all intervals
   *          have converged after NITMAX iterations, then INFO is set
   *          to the number of non-converged intervals.
   *
   *  N       (input) INTEGER
   *          The dimension n of the tridiagonal matrix T.  It must be at
   *          least 1.
   *
   *  MMAX    (input) INTEGER
   *          The maximum number of intervals.  If more than MMAX intervals
   *          are generated, then DLAEBZ will quit with INFO=MMAX+1.
   *
   *  MINP    (input) INTEGER
   *          The initial number of intervals.  It may not be greater than
   *          MMAX.
   *
   *  NBMIN   (input) INTEGER
   *          The smallest number of intervals that should be processed
   *          using a vector loop.  If zero, then only the scalar loop
   *          will be used.
   *
   *  ABSTOL  (input) DOUBLE PRECISION
   *          The minimum (absolute) width of an interval.  When an
   *          interval is narrower than ABSTOL, or than RELTOL times the
   *          larger (in magnitude) endpoint, then it is considered to be
   *          sufficiently small, i.e., converged.  This must be at least
   *          zero.
   *
   *  RELTOL  (input) DOUBLE PRECISION
   *          The minimum relative width of an interval.  When an interval
   *          is narrower than ABSTOL, or than RELTOL times the larger (in
   *          magnitude) endpoint, then it is considered to be
   *          sufficiently small, i.e., converged.  Note: this should
   *          always be at least radix*machine epsilon.
   *
   *  PIVMIN  (input) DOUBLE PRECISION
   *          The minimum absolute value of a "pivot" in the Sturm
   *          sequence loop.  This *must* be at least  max |e(j)**2| *
   *          safe_min  and at least safe_min, where safe_min is at least
   *          the smallest number that can divide one without overflow.
   *
   *  D       (input) DOUBLE PRECISION array, dimension (N)
   *          The diagonal elements of the tridiagonal matrix T.
   *
   *  E       (input) DOUBLE PRECISION array, dimension (N)
   *          The offdiagonal elements of the tridiagonal matrix T in
   *          positions 1 through N-1.  E(N) is arbitrary.
   *
   *  E2      (input) DOUBLE PRECISION array, dimension (N)
   *          The squares of the offdiagonal elements of the tridiagonal
   *          matrix T.  E2(N) is ignored.
   *
   *  NVAL    (input/output) INTEGER array, dimension (MINP)
   *          If IJOB=1 or 2, not referenced.
   *          If IJOB=3, the desired values of N(w).  The elements of NVAL
   *          will be reordered to correspond with the intervals in AB.
   *          Thus, NVAL(j) on output will not, in general be the same as
   *          NVAL(j) on input, but it will correspond with the interval
   *          (AB(j,1),AB(j,2)] on output.
   *
   *  AB      (input/output) DOUBLE PRECISION array, dimension (MMAX,2)
   *          The endpoints of the intervals.  AB(j,1) is  a(j), the left
   *          endpoint of the j-th interval, and AB(j,2) is b(j), the
   *          right endpoint of the j-th interval.  The input intervals
   *          will, in general, be modified, split, and reordered by the
   *          calculation.
   *
   *  C       (input/output) DOUBLE PRECISION array, dimension (MMAX)
   *          If IJOB=1, ignored.
   *          If IJOB=2, workspace.
   *          If IJOB=3, then on input C(j) should be initialized to the
   *          first search point in the binary search.
   *
   *  MOUT    (output) INTEGER
   *          If IJOB=1, the number of eigenvalues in the intervals.
   *          If IJOB=2 or 3, the number of intervals output.
   *          If IJOB=3, MOUT will equal MINP.
   *
   *  NAB     (input/output) INTEGER array, dimension (MMAX,2)
   *          If IJOB=1, then on output NAB(i,j) will be set to N(AB(i,j)).
   *          If IJOB=2, then on input, NAB(i,j) should be set.  It must
   *             satisfy the condition:
   *             N(AB(i,1)) <= NAB(i,1) <= NAB(i,2) <= N(AB(i,2)),
   *             which means that in interval i only eigenvalues
   *             NAB(i,1)+1,...,NAB(i,2) will be considered.  Usually,
   *             NAB(i,j)=N(AB(i,j)), from a previous call to DLAEBZ with
   *             IJOB=1.
   *             On output, NAB(i,j) will contain
   *             max(na(k),min(nb(k),N(AB(i,j)))), where k is the index of
   *             the input interval that the output interval
   *             (AB(j,1),AB(j,2)] came from, and na(k) and nb(k) are the
   *             the input values of NAB(k,1) and NAB(k,2).
   *          If IJOB=3, then on output, NAB(i,j) contains N(AB(i,j)),
   *             unless N(w) > NVAL(i) for all search points  w , in which
   *             case NAB(i,1) will not be modified, i.e., the output
   *             value will be the same as the input value (modulo
   *             reorderings -- see NVAL and AB), or unless N(w) < NVAL(i)
   *             for all search points  w , in which case NAB(i,2) will
   *             not be modified.  Normally, NAB should be set to some
   *             distinctive value(s) before DLAEBZ is called.
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (MMAX)
   *          Workspace.
   *
   *  IWORK   (workspace) INTEGER array, dimension (MMAX)
   *          Workspace.
   *
   *  INFO    (output) INTEGER
   *          = 0:       All intervals converged.
   *          = 1--MMAX: The last INFO intervals did not converge.
   *          = MMAX+1:  More than MMAX intervals were generated.
   *
   *  Further Details
   *  ===============
   *
   *      This routine is intended to be called only by other LAPACK
   *  routines, thus the interface is less user-friendly.  It is intended
   *  for two purposes:
   *
   *  (a) finding eigenvalues.  In this case, DLAEBZ should have one or
   *      more initial intervals set up in AB, and DLAEBZ should be called
   *      with IJOB=1.  This sets up NAB, and also counts the eigenvalues.
   *      Intervals with no eigenvalues would usually be thrown out at
   *      this point.  Also, if not all the eigenvalues in an interval i
   *      are desired, NAB(i,1) can be increased or NAB(i,2) decreased.
   *      For example, set NAB(i,1)=NAB(i,2)-1 to get the largest
   *      eigenvalue.  DLAEBZ is then called with IJOB=2 and MMAX
   *      no smaller than the value of MOUT returned by the call with
   *      IJOB=1.  After this (IJOB=2) call, eigenvalues NAB(i,1)+1
   *      through NAB(i,2) are approximately AB(i,1) (or AB(i,2)) to the
   *      tolerance specified by ABSTOL and RELTOL.
   *
   *  (b) finding an interval (a',b'] containing eigenvalues w(f),...,w(l).
   *      In this case, start with a Gershgorin interval  (a,b).  Set up
   *      AB to contain 2 search intervals, both initially (a,b).  One
   *      NVAL element should contain  f-1  and the other should contain  l
   *      , while C should contain a and b, resp.  NAB(i,1) should be -1
   *      and NAB(i,2) should be N+1, to flag an error if the desired
   *      interval does not lie in (a,b).  DLAEBZ is then called with
   *      IJOB=3.  On exit, if w(f-1) < w(f), then one of the intervals --
   *      j -- will have AB(j,1)=AB(j,2) and NAB(j,1)=NAB(j,2)=f-1, while
   *      if, to the specified tolerance, w(f-k)=...=w(f+r), k > 0 and r
   *      >= 0, then the interval will have  N(AB(j,1))=NAB(j,1)=f-k and
   *      N(AB(j,2))=NAB(j,2)=f+r.  The cases w(l) < w(l+1) and
   *      w(l-r)=...=w(l+k) are handled similarly.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param ijob
   * @param nitmax
   * @param n
   * @param mmax
   * @param minp
   * @param nbmin
   * @param abstol
   * @param reltol
   * @param pivmin
   * @param d
   * @param e
   * @param e2
   * @param nval
   * @param ab
   * @param c
   * @param mout
   * @param nab
   * @param work
   * @param iwork
   * @param info
   * 
   */
  abstract public void dlaebz(int ijob, int nitmax, int n, int mmax, int minp, int nbmin, double abstol, double reltol, double pivmin, double[] d, double[] e, double[] e2, int[] nval, double[] ab, double[] c, org.netlib.util.intW mout, int[] nab, double[] work, int[] iwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAEBZ contains the iteration loops which compute and use the
   *  function N(w), which is the count of eigenvalues of a symmetric
   *  tridiagonal matrix T less than or equal to its argument  w.  It
   *  performs a choice of two types of loops:
   *
   *  IJOB=1, followed by
   *  IJOB=2: It takes as input a list of intervals and returns a list of
   *          sufficiently small intervals whose union contains the same
   *          eigenvalues as the union of the original intervals.
   *          The input intervals are (AB(j,1),AB(j,2)], j=1,...,MINP.
   *          The output interval (AB(j,1),AB(j,2)] will contain
   *          eigenvalues NAB(j,1)+1,...,NAB(j,2), where 1 <= j <= MOUT.
   *
   *  IJOB=3: It performs a binary search in each input interval
   *          (AB(j,1),AB(j,2)] for a point  w(j)  such that
   *          N(w(j))=NVAL(j), and uses  C(j)  as the starting point of
   *          the search.  If such a w(j) is found, then on output
   *          AB(j,1)=AB(j,2)=w.  If no such w(j) is found, then on output
   *          (AB(j,1),AB(j,2)] will be a small interval containing the
   *          point where N(w) jumps through NVAL(j), unless that point
   *          lies outside the initial interval.
   *
   *  Note that the intervals are in all cases half-open intervals,
   *  i.e., of the form  (a,b] , which includes  b  but not  a .
   *
   *  To avoid underflow, the matrix should be scaled so that its largest
   *  element is no greater than  overflow**(1/2) * underflow**(1/4)
   *  in absolute value.  To assure the most accurate computation
   *  of small eigenvalues, the matrix should be scaled to be
   *  not much smaller than that, either.
   *
   *  See W. Kahan "Accurate Eigenvalues of a Symmetric Tridiagonal
   *  Matrix", Report CS41, Computer Science Dept., Stanford
   *  University, July 21, 1966
   *
   *  Note: the arguments are, in general, *not* checked for unreasonable
   *  values.
   *
   *  Arguments
   *  =========
   *
   *  IJOB    (input) INTEGER
   *          Specifies what is to be done:
   *          = 1:  Compute NAB for the initial intervals.
   *          = 2:  Perform bisection iteration to find eigenvalues of T.
   *          = 3:  Perform bisection iteration to invert N(w), i.e.,
   *                to find a point which has a specified number of
   *                eigenvalues of T to its left.
   *          Other values will cause DLAEBZ to return with INFO=-1.
   *
   *  NITMAX  (input) INTEGER
   *          The maximum number of "levels" of bisection to be
   *          performed, i.e., an interval of width W will not be made
   *          smaller than 2^(-NITMAX) * W.  If not all intervals
   *          have converged after NITMAX iterations, then INFO is set
   *          to the number of non-converged intervals.
   *
   *  N       (input) INTEGER
   *          The dimension n of the tridiagonal matrix T.  It must be at
   *          least 1.
   *
   *  MMAX    (input) INTEGER
   *          The maximum number of intervals.  If more than MMAX intervals
   *          are generated, then DLAEBZ will quit with INFO=MMAX+1.
   *
   *  MINP    (input) INTEGER
   *          The initial number of intervals.  It may not be greater than
   *          MMAX.
   *
   *  NBMIN   (input) INTEGER
   *          The smallest number of intervals that should be processed
   *          using a vector loop.  If zero, then only the scalar loop
   *          will be used.
   *
   *  ABSTOL  (input) DOUBLE PRECISION
   *          The minimum (absolute) width of an interval.  When an
   *          interval is narrower than ABSTOL, or than RELTOL times the
   *          larger (in magnitude) endpoint, then it is considered to be
   *          sufficiently small, i.e., converged.  This must be at least
   *          zero.
   *
   *  RELTOL  (input) DOUBLE PRECISION
   *          The minimum relative width of an interval.  When an interval
   *          is narrower than ABSTOL, or than RELTOL times the larger (in
   *          magnitude) endpoint, then it is considered to be
   *          sufficiently small, i.e., converged.  Note: this should
   *          always be at least radix*machine epsilon.
   *
   *  PIVMIN  (input) DOUBLE PRECISION
   *          The minimum absolute value of a "pivot" in the Sturm
   *          sequence loop.  This *must* be at least  max |e(j)**2| *
   *          safe_min  and at least safe_min, where safe_min is at least
   *          the smallest number that can divide one without overflow.
   *
   *  D       (input) DOUBLE PRECISION array, dimension (N)
   *          The diagonal elements of the tridiagonal matrix T.
   *
   *  E       (input) DOUBLE PRECISION array, dimension (N)
   *          The offdiagonal elements of the tridiagonal matrix T in
   *          positions 1 through N-1.  E(N) is arbitrary.
   *
   *  E2      (input) DOUBLE PRECISION array, dimension (N)
   *          The squares of the offdiagonal elements of the tridiagonal
   *          matrix T.  E2(N) is ignored.
   *
   *  NVAL    (input/output) INTEGER array, dimension (MINP)
   *          If IJOB=1 or 2, not referenced.
   *          If IJOB=3, the desired values of N(w).  The elements of NVAL
   *          will be reordered to correspond with the intervals in AB.
   *          Thus, NVAL(j) on output will not, in general be the same as
   *          NVAL(j) on input, but it will correspond with the interval
   *          (AB(j,1),AB(j,2)] on output.
   *
   *  AB      (input/output) DOUBLE PRECISION array, dimension (MMAX,2)
   *          The endpoints of the intervals.  AB(j,1) is  a(j), the left
   *          endpoint of the j-th interval, and AB(j,2) is b(j), the
   *          right endpoint of the j-th interval.  The input intervals
   *          will, in general, be modified, split, and reordered by the
   *          calculation.
   *
   *  C       (input/output) DOUBLE PRECISION array, dimension (MMAX)
   *          If IJOB=1, ignored.
   *          If IJOB=2, workspace.
   *          If IJOB=3, then on input C(j) should be initialized to the
   *          first search point in the binary search.
   *
   *  MOUT    (output) INTEGER
   *          If IJOB=1, the number of eigenvalues in the intervals.
   *          If IJOB=2 or 3, the number of intervals output.
   *          If IJOB=3, MOUT will equal MINP.
   *
   *  NAB     (input/output) INTEGER array, dimension (MMAX,2)
   *          If IJOB=1, then on output NAB(i,j) will be set to N(AB(i,j)).
   *          If IJOB=2, then on input, NAB(i,j) should be set.  It must
   *             satisfy the condition:
   *             N(AB(i,1)) <= NAB(i,1) <= NAB(i,2) <= N(AB(i,2)),
   *             which means that in interval i only eigenvalues
   *             NAB(i,1)+1,...,NAB(i,2) will be considered.  Usually,
   *             NAB(i,j)=N(AB(i,j)), from a previous call to DLAEBZ with
   *             IJOB=1.
   *             On output, NAB(i,j) will contain
   *             max(na(k),min(nb(k),N(AB(i,j)))), where k is the index of
   *             the input interval that the output interval
   *             (AB(j,1),AB(j,2)] came from, and na(k) and nb(k) are the
   *             the input values of NAB(k,1) and NAB(k,2).
   *          If IJOB=3, then on output, NAB(i,j) contains N(AB(i,j)),
   *             unless N(w) > NVAL(i) for all search points  w , in which
   *             case NAB(i,1) will not be modified, i.e., the output
   *             value will be the same as the input value (modulo
   *             reorderings -- see NVAL and AB), or unless N(w) < NVAL(i)
   *             for all search points  w , in which case NAB(i,2) will
   *             not be modified.  Normally, NAB should be set to some
   *             distinctive value(s) before DLAEBZ is called.
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (MMAX)
   *          Workspace.
   *
   *  IWORK   (workspace) INTEGER array, dimension (MMAX)
   *          Workspace.
   *
   *  INFO    (output) INTEGER
   *          = 0:       All intervals converged.
   *          = 1--MMAX: The last INFO intervals did not converge.
   *          = MMAX+1:  More than MMAX intervals were generated.
   *
   *  Further Details
   *  ===============
   *
   *      This routine is intended to be called only by other LAPACK
   *  routines, thus the interface is less user-friendly.  It is intended
   *  for two purposes:
   *
   *  (a) finding eigenvalues.  In this case, DLAEBZ should have one or
   *      more initial intervals set up in AB, and DLAEBZ should be called
   *      with IJOB=1.  This sets up NAB, and also counts the eigenvalues.
   *      Intervals with no eigenvalues would usually be thrown out at
   *      this point.  Also, if not all the eigenvalues in an interval i
   *      are desired, NAB(i,1) can be increased or NAB(i,2) decreased.
   *      For example, set NAB(i,1)=NAB(i,2)-1 to get the largest
   *      eigenvalue.  DLAEBZ is then called with IJOB=2 and MMAX
   *      no smaller than the value of MOUT returned by the call with
   *      IJOB=1.  After this (IJOB=2) call, eigenvalues NAB(i,1)+1
   *      through NAB(i,2) are approximately AB(i,1) (or AB(i,2)) to the
   *      tolerance specified by ABSTOL and RELTOL.
   *
   *  (b) finding an interval (a',b'] containing eigenvalues w(f),...,w(l).
   *      In this case, start with a Gershgorin interval  (a,b).  Set up
   *      AB to contain 2 search intervals, both initially (a,b).  One
   *      NVAL element should contain  f-1  and the other should contain  l
   *      , while C should contain a and b, resp.  NAB(i,1) should be -1
   *      and NAB(i,2) should be N+1, to flag an error if the desired
   *      interval does not lie in (a,b).  DLAEBZ is then called with
   *      IJOB=3.  On exit, if w(f-1) < w(f), then one of the intervals --
   *      j -- will have AB(j,1)=AB(j,2) and NAB(j,1)=NAB(j,2)=f-1, while
   *      if, to the specified tolerance, w(f-k)=...=w(f+r), k > 0 and r
   *      >= 0, then the interval will have  N(AB(j,1))=NAB(j,1)=f-k and
   *      N(AB(j,2))=NAB(j,2)=f+r.  The cases w(l) < w(l+1) and
   *      w(l-r)=...=w(l+k) are handled similarly.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param ijob
   * @param nitmax
   * @param n
   * @param mmax
   * @param minp
   * @param nbmin
   * @param abstol
   * @param reltol
   * @param pivmin
   * @param d
   * @param _d_offset
   * @param e
   * @param _e_offset
   * @param e2
   * @param _e2_offset
   * @param nval
   * @param _nval_offset
   * @param ab
   * @param _ab_offset
   * @param c
   * @param _c_offset
   * @param mout
   * @param nab
   * @param _nab_offset
   * @param work
   * @param _work_offset
   * @param iwork
   * @param _iwork_offset
   * @param info
   * 
   */
  abstract public void dlaebz(int ijob, int nitmax, int n, int mmax, int minp, int nbmin, double abstol, double reltol, double pivmin, double[] d, int _d_offset, double[] e, int _e_offset, double[] e2, int _e2_offset, int[] nval, int _nval_offset, double[] ab, int _ab_offset, double[] c, int _c_offset, org.netlib.util.intW mout, int[] nab, int _nab_offset, double[] work, int _work_offset, int[] iwork, int _iwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAED0 computes all eigenvalues and corresponding eigenvectors of a
   *  symmetric tridiagonal matrix using the divide and conquer method.
   *
   *  Arguments
   *  =========
   *
   *  ICOMPQ  (input) INTEGER
   *          = 0:  Compute eigenvalues only.
   *          = 1:  Compute eigenvectors of original dense symmetric matrix
   *                also.  On entry, Q contains the orthogonal matrix used
   *                to reduce the original matrix to tridiagonal form.
   *          = 2:  Compute eigenvalues and eigenvectors of tridiagonal
   *                matrix.
   *
   *  QSIZ   (input) INTEGER
   *         The dimension of the orthogonal matrix used to reduce
   *         the full matrix to tridiagonal form.  QSIZ >= N if ICOMPQ = 1.
   *
   *  N      (input) INTEGER
   *         The dimension of the symmetric tridiagonal matrix.  N >= 0.
   *
   *  D      (input/output) DOUBLE PRECISION array, dimension (N)
   *         On entry, the main diagonal of the tridiagonal matrix.
   *         On exit, its eigenvalues.
   *
   *  E      (input) DOUBLE PRECISION array, dimension (N-1)
   *         The off-diagonal elements of the tridiagonal matrix.
   *         On exit, E has been destroyed.
   *
   *  Q      (input/output) DOUBLE PRECISION array, dimension (LDQ, N)
   *         On entry, Q must contain an N-by-N orthogonal matrix.
   *         If ICOMPQ = 0    Q is not referenced.
   *         If ICOMPQ = 1    On entry, Q is a subset of the columns of the
   *                          orthogonal matrix used to reduce the full
   *                          matrix to tridiagonal form corresponding to
   *                          the subset of the full matrix which is being
   *                          decomposed at this time.
   *         If ICOMPQ = 2    On entry, Q will be the identity matrix.
   *                          On exit, Q contains the eigenvectors of the
   *                          tridiagonal matrix.
   *
   *  LDQ    (input) INTEGER
   *         The leading dimension of the array Q.  If eigenvectors are
   *         desired, then  LDQ >= max(1,N).  In any case,  LDQ >= 1.
   *
   *  QSTORE (workspace) DOUBLE PRECISION array, dimension (LDQS, N)
   *         Referenced only when ICOMPQ = 1.  Used to store parts of
   *         the eigenvector matrix when the updating matrix multiplies
   *         take place.
   *
   *  LDQS   (input) INTEGER
   *         The leading dimension of the array QSTORE.  If ICOMPQ = 1,
   *         then  LDQS >= max(1,N).  In any case,  LDQS >= 1.
   *
   *  WORK   (workspace) DOUBLE PRECISION array,
   *         If ICOMPQ = 0 or 1, the dimension of WORK must be at least
   *                     1 + 3*N + 2*N*lg N + 2*N**2
   *                     ( lg( N ) = smallest integer k
   *                                 such that 2^k >= N )
   *         If ICOMPQ = 2, the dimension of WORK must be at least
   *                     4*N + N**2.
   *
   *  IWORK  (workspace) INTEGER array,
   *         If ICOMPQ = 0 or 1, the dimension of IWORK must be at least
   *                        6 + 6*N + 5*N*lg N.
   *                        ( lg( N ) = smallest integer k
   *                                    such that 2^k >= N )
   *         If ICOMPQ = 2, the dimension of IWORK must be at least
   *                        3 + 5*N.
   *
   *  INFO   (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  The algorithm failed to compute an eigenvalue while
   *                working on the submatrix lying in rows and columns
   *                INFO/(N+1) through mod(INFO,N+1).
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Jeff Rutter, Computer Science Division, University of California
   *     at Berkeley, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param icompq
   * @param qsiz
   * @param n
   * @param d
   * @param e
   * @param q
   * @param ldq
   * @param qstore
   * @param ldqs
   * @param work
   * @param iwork
   * @param info
   * 
   */
  abstract public void dlaed0(int icompq, int qsiz, int n, double[] d, double[] e, double[] q, int ldq, double[] qstore, int ldqs, double[] work, int[] iwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAED0 computes all eigenvalues and corresponding eigenvectors of a
   *  symmetric tridiagonal matrix using the divide and conquer method.
   *
   *  Arguments
   *  =========
   *
   *  ICOMPQ  (input) INTEGER
   *          = 0:  Compute eigenvalues only.
   *          = 1:  Compute eigenvectors of original dense symmetric matrix
   *                also.  On entry, Q contains the orthogonal matrix used
   *                to reduce the original matrix to tridiagonal form.
   *          = 2:  Compute eigenvalues and eigenvectors of tridiagonal
   *                matrix.
   *
   *  QSIZ   (input) INTEGER
   *         The dimension of the orthogonal matrix used to reduce
   *         the full matrix to tridiagonal form.  QSIZ >= N if ICOMPQ = 1.
   *
   *  N      (input) INTEGER
   *         The dimension of the symmetric tridiagonal matrix.  N >= 0.
   *
   *  D      (input/output) DOUBLE PRECISION array, dimension (N)
   *         On entry, the main diagonal of the tridiagonal matrix.
   *         On exit, its eigenvalues.
   *
   *  E      (input) DOUBLE PRECISION array, dimension (N-1)
   *         The off-diagonal elements of the tridiagonal matrix.
   *         On exit, E has been destroyed.
   *
   *  Q      (input/output) DOUBLE PRECISION array, dimension (LDQ, N)
   *         On entry, Q must contain an N-by-N orthogonal matrix.
   *         If ICOMPQ = 0    Q is not referenced.
   *         If ICOMPQ = 1    On entry, Q is a subset of the columns of the
   *                          orthogonal matrix used to reduce the full
   *                          matrix to tridiagonal form corresponding to
   *                          the subset of the full matrix which is being
   *                          decomposed at this time.
   *         If ICOMPQ = 2    On entry, Q will be the identity matrix.
   *                          On exit, Q contains the eigenvectors of the
   *                          tridiagonal matrix.
   *
   *  LDQ    (input) INTEGER
   *         The leading dimension of the array Q.  If eigenvectors are
   *         desired, then  LDQ >= max(1,N).  In any case,  LDQ >= 1.
   *
   *  QSTORE (workspace) DOUBLE PRECISION array, dimension (LDQS, N)
   *         Referenced only when ICOMPQ = 1.  Used to store parts of
   *         the eigenvector matrix when the updating matrix multiplies
   *         take place.
   *
   *  LDQS   (input) INTEGER
   *         The leading dimension of the array QSTORE.  If ICOMPQ = 1,
   *         then  LDQS >= max(1,N).  In any case,  LDQS >= 1.
   *
   *  WORK   (workspace) DOUBLE PRECISION array,
   *         If ICOMPQ = 0 or 1, the dimension of WORK must be at least
   *                     1 + 3*N + 2*N*lg N + 2*N**2
   *                     ( lg( N ) = smallest integer k
   *                                 such that 2^k >= N )
   *         If ICOMPQ = 2, the dimension of WORK must be at least
   *                     4*N + N**2.
   *
   *  IWORK  (workspace) INTEGER array,
   *         If ICOMPQ = 0 or 1, the dimension of IWORK must be at least
   *                        6 + 6*N + 5*N*lg N.
   *                        ( lg( N ) = smallest integer k
   *                                    such that 2^k >= N )
   *         If ICOMPQ = 2, the dimension of IWORK must be at least
   *                        3 + 5*N.
   *
   *  INFO   (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  The algorithm failed to compute an eigenvalue while
   *                working on the submatrix lying in rows and columns
   *                INFO/(N+1) through mod(INFO,N+1).
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Jeff Rutter, Computer Science Division, University of California
   *     at Berkeley, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param icompq
   * @param qsiz
   * @param n
   * @param d
   * @param _d_offset
   * @param e
   * @param _e_offset
   * @param q
   * @param _q_offset
   * @param ldq
   * @param qstore
   * @param _qstore_offset
   * @param ldqs
   * @param work
   * @param _work_offset
   * @param iwork
   * @param _iwork_offset
   * @param info
   * 
   */
  abstract public void dlaed0(int icompq, int qsiz, int n, double[] d, int _d_offset, double[] e, int _e_offset, double[] q, int _q_offset, int ldq, double[] qstore, int _qstore_offset, int ldqs, double[] work, int _work_offset, int[] iwork, int _iwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAED1 computes the updated eigensystem of a diagonal
   *  matrix after modification by a rank-one symmetric matrix.  This
   *  routine is used only for the eigenproblem which requires all
   *  eigenvalues and eigenvectors of a tridiagonal matrix.  DLAED7 handles
   *  the case in which eigenvalues only or eigenvalues and eigenvectors
   *  of a full symmetric matrix (which was reduced to tridiagonal form)
   *  are desired.
   *
   *    T = Q(in) ( D(in) + RHO * Z*Z' ) Q'(in) = Q(out) * D(out) * Q'(out)
   *
   *     where Z = Q'u, u is a vector of length N with ones in the
   *     CUTPNT and CUTPNT + 1 th elements and zeros elsewhere.
   *
   *     The eigenvectors of the original matrix are stored in Q, and the
   *     eigenvalues are in D.  The algorithm consists of three stages:
   *
   *        The first stage consists of deflating the size of the problem
   *        when there are multiple eigenvalues or if there is a zero in
   *        the Z vector.  For each such occurence the dimension of the
   *        secular equation problem is reduced by one.  This stage is
   *        performed by the routine DLAED2.
   *
   *        The second stage consists of calculating the updated
   *        eigenvalues. This is done by finding the roots of the secular
   *        equation via the routine DLAED4 (as called by DLAED3).
   *        This routine also calculates the eigenvectors of the current
   *        problem.
   *
   *        The final stage consists of computing the updated eigenvectors
   *        directly using the updated eigenvalues.  The eigenvectors for
   *        the current problem are multiplied with the eigenvectors from
   *        the overall problem.
   *
   *  Arguments
   *  =========
   *
   *  N      (input) INTEGER
   *         The dimension of the symmetric tridiagonal matrix.  N >= 0.
   *
   *  D      (input/output) DOUBLE PRECISION array, dimension (N)
   *         On entry, the eigenvalues of the rank-1-perturbed matrix.
   *         On exit, the eigenvalues of the repaired matrix.
   *
   *  Q      (input/output) DOUBLE PRECISION array, dimension (LDQ,N)
   *         On entry, the eigenvectors of the rank-1-perturbed matrix.
   *         On exit, the eigenvectors of the repaired tridiagonal matrix.
   *
   *  LDQ    (input) INTEGER
   *         The leading dimension of the array Q.  LDQ >= max(1,N).
   *
   *  INDXQ  (input/output) INTEGER array, dimension (N)
   *         On entry, the permutation which separately sorts the two
   *         subproblems in D into ascending order.
   *         On exit, the permutation which will reintegrate the
   *         subproblems back into sorted order,
   *         i.e. D( INDXQ( I = 1, N ) ) will be in ascending order.
   *
   *  RHO    (input) DOUBLE PRECISION
   *         The subdiagonal entry used to create the rank-1 modification.
   *
   *  CUTPNT (input) INTEGER
   *         The location of the last eigenvalue in the leading sub-matrix.
   *         min(1,N) <= CUTPNT <= N/2.
   *
   *  WORK   (workspace) DOUBLE PRECISION array, dimension (4*N + N**2)
   *
   *  IWORK  (workspace) INTEGER array, dimension (4*N)
   *
   *  INFO   (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  if INFO = 1, an eigenvalue did not converge
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Jeff Rutter, Computer Science Division, University of California
   *     at Berkeley, USA
   *  Modified by Francoise Tisseur, University of Tennessee.
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param d
   * @param q
   * @param ldq
   * @param indxq
   * @param rho
   * @param cutpnt
   * @param work
   * @param iwork
   * @param info
   * 
   */
  abstract public void dlaed1(int n, double[] d, double[] q, int ldq, int[] indxq, org.netlib.util.doubleW rho, int cutpnt, double[] work, int[] iwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAED1 computes the updated eigensystem of a diagonal
   *  matrix after modification by a rank-one symmetric matrix.  This
   *  routine is used only for the eigenproblem which requires all
   *  eigenvalues and eigenvectors of a tridiagonal matrix.  DLAED7 handles
   *  the case in which eigenvalues only or eigenvalues and eigenvectors
   *  of a full symmetric matrix (which was reduced to tridiagonal form)
   *  are desired.
   *
   *    T = Q(in) ( D(in) + RHO * Z*Z' ) Q'(in) = Q(out) * D(out) * Q'(out)
   *
   *     where Z = Q'u, u is a vector of length N with ones in the
   *     CUTPNT and CUTPNT + 1 th elements and zeros elsewhere.
   *
   *     The eigenvectors of the original matrix are stored in Q, and the
   *     eigenvalues are in D.  The algorithm consists of three stages:
   *
   *        The first stage consists of deflating the size of the problem
   *        when there are multiple eigenvalues or if there is a zero in
   *        the Z vector.  For each such occurence the dimension of the
   *        secular equation problem is reduced by one.  This stage is
   *        performed by the routine DLAED2.
   *
   *        The second stage consists of calculating the updated
   *        eigenvalues. This is done by finding the roots of the secular
   *        equation via the routine DLAED4 (as called by DLAED3).
   *        This routine also calculates the eigenvectors of the current
   *        problem.
   *
   *        The final stage consists of computing the updated eigenvectors
   *        directly using the updated eigenvalues.  The eigenvectors for
   *        the current problem are multiplied with the eigenvectors from
   *        the overall problem.
   *
   *  Arguments
   *  =========
   *
   *  N      (input) INTEGER
   *         The dimension of the symmetric tridiagonal matrix.  N >= 0.
   *
   *  D      (input/output) DOUBLE PRECISION array, dimension (N)
   *         On entry, the eigenvalues of the rank-1-perturbed matrix.
   *         On exit, the eigenvalues of the repaired matrix.
   *
   *  Q      (input/output) DOUBLE PRECISION array, dimension (LDQ,N)
   *         On entry, the eigenvectors of the rank-1-perturbed matrix.
   *         On exit, the eigenvectors of the repaired tridiagonal matrix.
   *
   *  LDQ    (input) INTEGER
   *         The leading dimension of the array Q.  LDQ >= max(1,N).
   *
   *  INDXQ  (input/output) INTEGER array, dimension (N)
   *         On entry, the permutation which separately sorts the two
   *         subproblems in D into ascending order.
   *         On exit, the permutation which will reintegrate the
   *         subproblems back into sorted order,
   *         i.e. D( INDXQ( I = 1, N ) ) will be in ascending order.
   *
   *  RHO    (input) DOUBLE PRECISION
   *         The subdiagonal entry used to create the rank-1 modification.
   *
   *  CUTPNT (input) INTEGER
   *         The location of the last eigenvalue in the leading sub-matrix.
   *         min(1,N) <= CUTPNT <= N/2.
   *
   *  WORK   (workspace) DOUBLE PRECISION array, dimension (4*N + N**2)
   *
   *  IWORK  (workspace) INTEGER array, dimension (4*N)
   *
   *  INFO   (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  if INFO = 1, an eigenvalue did not converge
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Jeff Rutter, Computer Science Division, University of California
   *     at Berkeley, USA
   *  Modified by Francoise Tisseur, University of Tennessee.
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param n
   * @param d
   * @param _d_offset
   * @param q
   * @param _q_offset
   * @param ldq
   * @param indxq
   * @param _indxq_offset
   * @param rho
   * @param cutpnt
   * @param work
   * @param _work_offset
   * @param iwork
   * @param _iwork_offset
   * @param info
   * 
   */
  abstract public void dlaed1(int n, double[] d, int _d_offset, double[] q, int _q_offset, int ldq, int[] indxq, int _indxq_offset, org.netlib.util.doubleW rho, int cutpnt, double[] work, int _work_offset, int[] iwork, int _iwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAED2 merges the two sets of eigenvalues together into a single
   *  sorted set.  Then it tries to deflate the size of the problem.
   *  There are two ways in which deflation can occur:  when two or more
   *  eigenvalues are close together or if there is a tiny entry in the
   *  Z vector.  For each such occurrence the order of the related secular
   *  equation problem is reduced by one.
   *
   *  Arguments
   *  =========
   *
   *  K      (output) INTEGER
   *         The number of non-deflated eigenvalues, and the order of the
   *         related secular equation. 0 <= K <=N.
   *
   *  N      (input) INTEGER
   *         The dimension of the symmetric tridiagonal matrix.  N >= 0.
   *
   *  N1     (input) INTEGER
   *         The location of the last eigenvalue in the leading sub-matrix.
   *         min(1,N) <= N1 <= N/2.
   *
   *  D      (input/output) DOUBLE PRECISION array, dimension (N)
   *         On entry, D contains the eigenvalues of the two submatrices to
   *         be combined.
   *         On exit, D contains the trailing (N-K) updated eigenvalues
   *         (those which were deflated) sorted into increasing order.
   *
   *  Q      (input/output) DOUBLE PRECISION array, dimension (LDQ, N)
   *         On entry, Q contains the eigenvectors of two submatrices in
   *         the two square blocks with corners at (1,1), (N1,N1)
   *         and (N1+1, N1+1), (N,N).
   *         On exit, Q contains the trailing (N-K) updated eigenvectors
   *         (those which were deflated) in its last N-K columns.
   *
   *  LDQ    (input) INTEGER
   *         The leading dimension of the array Q.  LDQ >= max(1,N).
   *
   *  INDXQ  (input/output) INTEGER array, dimension (N)
   *         The permutation which separately sorts the two sub-problems
   *         in D into ascending order.  Note that elements in the second
   *         half of this permutation must first have N1 added to their
   *         values. Destroyed on exit.
   *
   *  RHO    (input/output) DOUBLE PRECISION
   *         On entry, the off-diagonal element associated with the rank-1
   *         cut which originally split the two submatrices which are now
   *         being recombined.
   *         On exit, RHO has been modified to the value required by
   *         DLAED3.
   *
   *  Z      (input) DOUBLE PRECISION array, dimension (N)
   *         On entry, Z contains the updating vector (the last
   *         row of the first sub-eigenvector matrix and the first row of
   *         the second sub-eigenvector matrix).
   *         On exit, the contents of Z have been destroyed by the updating
   *         process.
   *
   *  DLAMDA (output) DOUBLE PRECISION array, dimension (N)
   *         A copy of the first K eigenvalues which will be used by
   *         DLAED3 to form the secular equation.
   *
   *  W      (output) DOUBLE PRECISION array, dimension (N)
   *         The first k values of the final deflation-altered z-vector
   *         which will be passed to DLAED3.
   *
   *  Q2     (output) DOUBLE PRECISION array, dimension (N1**2+(N-N1)**2)
   *         A copy of the first K eigenvectors which will be used by
   *         DLAED3 in a matrix multiply (DGEMM) to solve for the new
   *         eigenvectors.
   *
   *  INDX   (workspace) INTEGER array, dimension (N)
   *         The permutation used to sort the contents of DLAMDA into
   *         ascending order.
   *
   *  INDXC  (output) INTEGER array, dimension (N)
   *         The permutation used to arrange the columns of the deflated
   *         Q matrix into three groups:  the first group contains non-zero
   *         elements only at and above N1, the second contains
   *         non-zero elements only below N1, and the third is dense.
   *
   *  INDXP  (workspace) INTEGER array, dimension (N)
   *         The permutation used to place deflated values of D at the end
   *         of the array.  INDXP(1:K) points to the nondeflated D-values
   *         and INDXP(K+1:N) points to the deflated eigenvalues.
   *
   *  COLTYP (workspace/output) INTEGER array, dimension (N)
   *         During execution, a label which will indicate which of the
   *         following types a column in the Q2 matrix is:
   *         1 : non-zero in the upper half only;
   *         2 : dense;
   *         3 : non-zero in the lower half only;
   *         4 : deflated.
   *         On exit, COLTYP(i) is the number of columns of type i,
   *         for i=1 to 4 only.
   *
   *  INFO   (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Jeff Rutter, Computer Science Division, University of California
   *     at Berkeley, USA
   *  Modified by Francoise Tisseur, University of Tennessee.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param k
   * @param n
   * @param n1
   * @param d
   * @param q
   * @param ldq
   * @param indxq
   * @param rho
   * @param z
   * @param dlamda
   * @param w
   * @param q2
   * @param indx
   * @param indxc
   * @param indxp
   * @param coltyp
   * @param info
   * 
   */
  abstract public void dlaed2(org.netlib.util.intW k, int n, int n1, double[] d, double[] q, int ldq, int[] indxq, org.netlib.util.doubleW rho, double[] z, double[] dlamda, double[] w, double[] q2, int[] indx, int[] indxc, int[] indxp, int[] coltyp, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAED2 merges the two sets of eigenvalues together into a single
   *  sorted set.  Then it tries to deflate the size of the problem.
   *  There are two ways in which deflation can occur:  when two or more
   *  eigenvalues are close together or if there is a tiny entry in the
   *  Z vector.  For each such occurrence the order of the related secular
   *  equation problem is reduced by one.
   *
   *  Arguments
   *  =========
   *
   *  K      (output) INTEGER
   *         The number of non-deflated eigenvalues, and the order of the
   *         related secular equation. 0 <= K <=N.
   *
   *  N      (input) INTEGER
   *         The dimension of the symmetric tridiagonal matrix.  N >= 0.
   *
   *  N1     (input) INTEGER
   *         The location of the last eigenvalue in the leading sub-matrix.
   *         min(1,N) <= N1 <= N/2.
   *
   *  D      (input/output) DOUBLE PRECISION array, dimension (N)
   *         On entry, D contains the eigenvalues of the two submatrices to
   *         be combined.
   *         On exit, D contains the trailing (N-K) updated eigenvalues
   *         (those which were deflated) sorted into increasing order.
   *
   *  Q      (input/output) DOUBLE PRECISION array, dimension (LDQ, N)
   *         On entry, Q contains the eigenvectors of two submatrices in
   *         the two square blocks with corners at (1,1), (N1,N1)
   *         and (N1+1, N1+1), (N,N).
   *         On exit, Q contains the trailing (N-K) updated eigenvectors
   *         (those which were deflated) in its last N-K columns.
   *
   *  LDQ    (input) INTEGER
   *         The leading dimension of the array Q.  LDQ >= max(1,N).
   *
   *  INDXQ  (input/output) INTEGER array, dimension (N)
   *         The permutation which separately sorts the two sub-problems
   *         in D into ascending order.  Note that elements in the second
   *         half of this permutation must first have N1 added to their
   *         values. Destroyed on exit.
   *
   *  RHO    (input/output) DOUBLE PRECISION
   *         On entry, the off-diagonal element associated with the rank-1
   *         cut which originally split the two submatrices which are now
   *         being recombined.
   *         On exit, RHO has been modified to the value required by
   *         DLAED3.
   *
   *  Z      (input) DOUBLE PRECISION array, dimension (N)
   *         On entry, Z contains the updating vector (the last
   *         row of the first sub-eigenvector matrix and the first row of
   *         the second sub-eigenvector matrix).
   *         On exit, the contents of Z have been destroyed by the updating
   *         process.
   *
   *  DLAMDA (output) DOUBLE PRECISION array, dimension (N)
   *         A copy of the first K eigenvalues which will be used by
   *         DLAED3 to form the secular equation.
   *
   *  W      (output) DOUBLE PRECISION array, dimension (N)
   *         The first k values of the final deflation-altered z-vector
   *         which will be passed to DLAED3.
   *
   *  Q2     (output) DOUBLE PRECISION array, dimension (N1**2+(N-N1)**2)
   *         A copy of the first K eigenvectors which will be used by
   *         DLAED3 in a matrix multiply (DGEMM) to solve for the new
   *         eigenvectors.
   *
   *  INDX   (workspace) INTEGER array, dimension (N)
   *         The permutation used to sort the contents of DLAMDA into
   *         ascending order.
   *
   *  INDXC  (output) INTEGER array, dimension (N)
   *         The permutation used to arrange the columns of the deflated
   *         Q matrix into three groups:  the first group contains non-zero
   *         elements only at and above N1, the second contains
   *         non-zero elements only below N1, and the third is dense.
   *
   *  INDXP  (workspace) INTEGER array, dimension (N)
   *         The permutation used to place deflated values of D at the end
   *         of the array.  INDXP(1:K) points to the nondeflated D-values
   *         and INDXP(K+1:N) points to the deflated eigenvalues.
   *
   *  COLTYP (workspace/output) INTEGER array, dimension (N)
   *         During execution, a label which will indicate which of the
   *         following types a column in the Q2 matrix is:
   *         1 : non-zero in the upper half only;
   *         2 : dense;
   *         3 : non-zero in the lower half only;
   *         4 : deflated.
   *         On exit, COLTYP(i) is the number of columns of type i,
   *         for i=1 to 4 only.
   *
   *  INFO   (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Jeff Rutter, Computer Science Division, University of California
   *     at Berkeley, USA
   *  Modified by Francoise Tisseur, University of Tennessee.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param k
   * @param n
   * @param n1
   * @param d
   * @param _d_offset
   * @param q
   * @param _q_offset
   * @param ldq
   * @param indxq
   * @param _indxq_offset
   * @param rho
   * @param z
   * @param _z_offset
   * @param dlamda
   * @param _dlamda_offset
   * @param w
   * @param _w_offset
   * @param q2
   * @param _q2_offset
   * @param indx
   * @param _indx_offset
   * @param indxc
   * @param _indxc_offset
   * @param indxp
   * @param _indxp_offset
   * @param coltyp
   * @param _coltyp_offset
   * @param info
   * 
   */
  abstract public void dlaed2(org.netlib.util.intW k, int n, int n1, double[] d, int _d_offset, double[] q, int _q_offset, int ldq, int[] indxq, int _indxq_offset, org.netlib.util.doubleW rho, double[] z, int _z_offset, double[] dlamda, int _dlamda_offset, double[] w, int _w_offset, double[] q2, int _q2_offset, int[] indx, int _indx_offset, int[] indxc, int _indxc_offset, int[] indxp, int _indxp_offset, int[] coltyp, int _coltyp_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAED3 finds the roots of the secular equation, as defined by the
   *  values in D, W, and RHO, between 1 and K.  It makes the
   *  appropriate calls to DLAED4 and then updates the eigenvectors by
   *  multiplying the matrix of eigenvectors of the pair of eigensystems
   *  being combined by the matrix of eigenvectors of the K-by-K system
   *  which is solved here.
   *
   *  This code makes very mild assumptions about floating point
   *  arithmetic. It will work on machines with a guard digit in
   *  add/subtract, or on those binary machines without guard digits
   *  which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or Cray-2.
   *  It could conceivably fail on hexadecimal or decimal machines
   *  without guard digits, but we know of none.
   *
   *  Arguments
   *  =========
   *
   *  K       (input) INTEGER
   *          The number of terms in the rational function to be solved by
   *          DLAED4.  K >= 0.
   *
   *  N       (input) INTEGER
   *          The number of rows and columns in the Q matrix.
   *          N >= K (deflation may result in N>K).
   *
   *  N1      (input) INTEGER
   *          The location of the last eigenvalue in the leading submatrix.
   *          min(1,N) <= N1 <= N/2.
   *
   *  D       (output) DOUBLE PRECISION array, dimension (N)
   *          D(I) contains the updated eigenvalues for
   *          1 <= I <= K.
   *
   *  Q       (output) DOUBLE PRECISION array, dimension (LDQ,N)
   *          Initially the first K columns are used as workspace.
   *          On output the columns 1 to K contain
   *          the updated eigenvectors.
   *
   *  LDQ     (input) INTEGER
   *          The leading dimension of the array Q.  LDQ >= max(1,N).
   *
   *  RHO     (input) DOUBLE PRECISION
   *          The value of the parameter in the rank one update equation.
   *          RHO >= 0 required.
   *
   *  DLAMDA  (input/output) DOUBLE PRECISION array, dimension (K)
   *          The first K elements of this array contain the old roots
   *          of the deflated updating problem.  These are the poles
   *          of the secular equation. May be changed on output by
   *          having lowest order bit set to zero on Cray X-MP, Cray Y-MP,
   *          Cray-2, or Cray C-90, as described above.
   *
   *  Q2      (input) DOUBLE PRECISION array, dimension (LDQ2, N)
   *          The first K columns of this matrix contain the non-deflated
   *          eigenvectors for the split problem.
   *
   *  INDX    (input) INTEGER array, dimension (N)
   *          The permutation used to arrange the columns of the deflated
   *          Q matrix into three groups (see DLAED2).
   *          The rows of the eigenvectors found by DLAED4 must be likewise
   *          permuted before the matrix multiply can take place.
   *
   *  CTOT    (input) INTEGER array, dimension (4)
   *          A count of the total number of the various types of columns
   *          in Q, as described in INDX.  The fourth column type is any
   *          column which has been deflated.
   *
   *  W       (input/output) DOUBLE PRECISION array, dimension (K)
   *          The first K elements of this array contain the components
   *          of the deflation-adjusted updating vector. Destroyed on
   *          output.
   *
   *  S       (workspace) DOUBLE PRECISION array, dimension (N1 + 1)*K
   *          Will contain the eigenvectors of the repaired matrix which
   *          will be multiplied by the previously accumulated eigenvectors
   *          to update the system.
   *
   *  LDS     (input) INTEGER
   *          The leading dimension of S.  LDS >= max(1,K).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  if INFO = 1, an eigenvalue did not converge
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Jeff Rutter, Computer Science Division, University of California
   *     at Berkeley, USA
   *  Modified by Francoise Tisseur, University of Tennessee.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param k
   * @param n
   * @param n1
   * @param d
   * @param q
   * @param ldq
   * @param rho
   * @param dlamda
   * @param q2
   * @param indx
   * @param ctot
   * @param w
   * @param s
   * @param info
   * 
   */
  abstract public void dlaed3(int k, int n, int n1, double[] d, double[] q, int ldq, double rho, double[] dlamda, double[] q2, int[] indx, int[] ctot, double[] w, double[] s, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAED3 finds the roots of the secular equation, as defined by the
   *  values in D, W, and RHO, between 1 and K.  It makes the
   *  appropriate calls to DLAED4 and then updates the eigenvectors by
   *  multiplying the matrix of eigenvectors of the pair of eigensystems
   *  being combined by the matrix of eigenvectors of the K-by-K system
   *  which is solved here.
   *
   *  This code makes very mild assumptions about floating point
   *  arithmetic. It will work on machines with a guard digit in
   *  add/subtract, or on those binary machines without guard digits
   *  which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or Cray-2.
   *  It could conceivably fail on hexadecimal or decimal machines
   *  without guard digits, but we know of none.
   *
   *  Arguments
   *  =========
   *
   *  K       (input) INTEGER
   *          The number of terms in the rational function to be solved by
   *          DLAED4.  K >= 0.
   *
   *  N       (input) INTEGER
   *          The number of rows and columns in the Q matrix.
   *          N >= K (deflation may result in N>K).
   *
   *  N1      (input) INTEGER
   *          The location of the last eigenvalue in the leading submatrix.
   *          min(1,N) <= N1 <= N/2.
   *
   *  D       (output) DOUBLE PRECISION array, dimension (N)
   *          D(I) contains the updated eigenvalues for
   *          1 <= I <= K.
   *
   *  Q       (output) DOUBLE PRECISION array, dimension (LDQ,N)
   *          Initially the first K columns are used as workspace.
   *          On output the columns 1 to K contain
   *          the updated eigenvectors.
   *
   *  LDQ     (input) INTEGER
   *          The leading dimension of the array Q.  LDQ >= max(1,N).
   *
   *  RHO     (input) DOUBLE PRECISION
   *          The value of the parameter in the rank one update equation.
   *          RHO >= 0 required.
   *
   *  DLAMDA  (input/output) DOUBLE PRECISION array, dimension (K)
   *          The first K elements of this array contain the old roots
   *          of the deflated updating problem.  These are the poles
   *          of the secular equation. May be changed on output by
   *          having lowest order bit set to zero on Cray X-MP, Cray Y-MP,
   *          Cray-2, or Cray C-90, as described above.
   *
   *  Q2      (input) DOUBLE PRECISION array, dimension (LDQ2, N)
   *          The first K columns of this matrix contain the non-deflated
   *          eigenvectors for the split problem.
   *
   *  INDX    (input) INTEGER array, dimension (N)
   *          The permutation used to arrange the columns of the deflated
   *          Q matrix into three groups (see DLAED2).
   *          The rows of the eigenvectors found by DLAED4 must be likewise
   *          permuted before the matrix multiply can take place.
   *
   *  CTOT    (input) INTEGER array, dimension (4)
   *          A count of the total number of the various types of columns
   *          in Q, as described in INDX.  The fourth column type is any
   *          column which has been deflated.
   *
   *  W       (input/output) DOUBLE PRECISION array, dimension (K)
   *          The first K elements of this array contain the components
   *          of the deflation-adjusted updating vector. Destroyed on
   *          output.
   *
   *  S       (workspace) DOUBLE PRECISION array, dimension (N1 + 1)*K
   *          Will contain the eigenvectors of the repaired matrix which
   *          will be multiplied by the previously accumulated eigenvectors
   *          to update the system.
   *
   *  LDS     (input) INTEGER
   *          The leading dimension of S.  LDS >= max(1,K).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  if INFO = 1, an eigenvalue did not converge
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Jeff Rutter, Computer Science Division, University of California
   *     at Berkeley, USA
   *  Modified by Francoise Tisseur, University of Tennessee.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param k
   * @param n
   * @param n1
   * @param d
   * @param _d_offset
   * @param q
   * @param _q_offset
   * @param ldq
   * @param rho
   * @param dlamda
   * @param _dlamda_offset
   * @param q2
   * @param _q2_offset
   * @param indx
   * @param _indx_offset
   * @param ctot
   * @param _ctot_offset
   * @param w
   * @param _w_offset
   * @param s
   * @param _s_offset
   * @param info
   * 
   */
  abstract public void dlaed3(int k, int n, int n1, double[] d, int _d_offset, double[] q, int _q_offset, int ldq, double rho, double[] dlamda, int _dlamda_offset, double[] q2, int _q2_offset, int[] indx, int _indx_offset, int[] ctot, int _ctot_offset, double[] w, int _w_offset, double[] s, int _s_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  This subroutine computes the I-th updated eigenvalue of a symmetric
   *  rank-one modification to a diagonal matrix whose elements are
   *  given in the array d, and that
   *
   *             D(i) < D(j)  for  i < j
   *
   *  and that RHO > 0.  This is arranged by the calling routine, and is
   *  no loss in generality.  The rank-one modified system is thus
   *
   *             diag( D )  +  RHO *  Z * Z_transpose.
   *
   *  where we assume the Euclidean norm of Z is 1.
   *
   *  The method consists of approximating the rational functions in the
   *  secular equation by simpler interpolating rational functions.
   *
   *  Arguments
   *  =========
   *
   *  N      (input) INTEGER
   *         The length of all arrays.
   *
   *  I      (input) INTEGER
   *         The index of the eigenvalue to be computed.  1 <= I <= N.
   *
   *  D      (input) DOUBLE PRECISION array, dimension (N)
   *         The original eigenvalues.  It is assumed that they are in
   *         order, D(I) < D(J)  for I < J.
   *
   *  Z      (input) DOUBLE PRECISION array, dimension (N)
   *         The components of the updating vector.
   *
   *  DELTA  (output) DOUBLE PRECISION array, dimension (N)
   *         If N .GT. 2, DELTA contains (D(j) - lambda_I) in its  j-th
   *         component.  If N = 1, then DELTA(1) = 1. If N = 2, see DLAED5
   *         for detail. The vector DELTA contains the information necessar
   *         to construct the eigenvectors by DLAED3 and DLAED9.
   *
   *  RHO    (input) DOUBLE PRECISION
   *         The scalar in the symmetric updating formula.
   *
   *  DLAM   (output) DOUBLE PRECISION
   *         The computed lambda_I, the I-th updated eigenvalue.
   *
   *  INFO   (output) INTEGER
   *         = 0:  successful exit
   *         > 0:  if INFO = 1, the updating process failed.
   *
   *  Internal Parameters
   *  ===================
   *
   *  Logical variable ORGATI (origin-at-i?) is used for distinguishing
   *  whether D(i) or D(i+1) is treated as the origin.
   *
   *            ORGATI = .true.    origin at i
   *            ORGATI = .false.   origin at i+1
   *
   *   Logical variable SWTCH3 (switch-for-3-poles?) is for noting
   *   if we are working with THREE poles!
   *
   *   MAXIT is the maximum number of iterations allowed for each
   *   eigenvalue.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Ren-Cang Li, Computer Science Division, University of California
   *     at Berkeley, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param i
   * @param d
   * @param z
   * @param delta
   * @param rho
   * @param dlam
   * @param info
   * 
   */
  abstract public void dlaed4(int n, int i, double[] d, double[] z, double[] delta, double rho, org.netlib.util.doubleW dlam, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  This subroutine computes the I-th updated eigenvalue of a symmetric
   *  rank-one modification to a diagonal matrix whose elements are
   *  given in the array d, and that
   *
   *             D(i) < D(j)  for  i < j
   *
   *  and that RHO > 0.  This is arranged by the calling routine, and is
   *  no loss in generality.  The rank-one modified system is thus
   *
   *             diag( D )  +  RHO *  Z * Z_transpose.
   *
   *  where we assume the Euclidean norm of Z is 1.
   *
   *  The method consists of approximating the rational functions in the
   *  secular equation by simpler interpolating rational functions.
   *
   *  Arguments
   *  =========
   *
   *  N      (input) INTEGER
   *         The length of all arrays.
   *
   *  I      (input) INTEGER
   *         The index of the eigenvalue to be computed.  1 <= I <= N.
   *
   *  D      (input) DOUBLE PRECISION array, dimension (N)
   *         The original eigenvalues.  It is assumed that they are in
   *         order, D(I) < D(J)  for I < J.
   *
   *  Z      (input) DOUBLE PRECISION array, dimension (N)
   *         The components of the updating vector.
   *
   *  DELTA  (output) DOUBLE PRECISION array, dimension (N)
   *         If N .GT. 2, DELTA contains (D(j) - lambda_I) in its  j-th
   *         component.  If N = 1, then DELTA(1) = 1. If N = 2, see DLAED5
   *         for detail. The vector DELTA contains the information necessar
   *         to construct the eigenvectors by DLAED3 and DLAED9.
   *
   *  RHO    (input) DOUBLE PRECISION
   *         The scalar in the symmetric updating formula.
   *
   *  DLAM   (output) DOUBLE PRECISION
   *         The computed lambda_I, the I-th updated eigenvalue.
   *
   *  INFO   (output) INTEGER
   *         = 0:  successful exit
   *         > 0:  if INFO = 1, the updating process failed.
   *
   *  Internal Parameters
   *  ===================
   *
   *  Logical variable ORGATI (origin-at-i?) is used for distinguishing
   *  whether D(i) or D(i+1) is treated as the origin.
   *
   *            ORGATI = .true.    origin at i
   *            ORGATI = .false.   origin at i+1
   *
   *   Logical variable SWTCH3 (switch-for-3-poles?) is for noting
   *   if we are working with THREE poles!
   *
   *   MAXIT is the maximum number of iterations allowed for each
   *   eigenvalue.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Ren-Cang Li, Computer Science Division, University of California
   *     at Berkeley, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param i
   * @param d
   * @param _d_offset
   * @param z
   * @param _z_offset
   * @param delta
   * @param _delta_offset
   * @param rho
   * @param dlam
   * @param info
   * 
   */
  abstract public void dlaed4(int n, int i, double[] d, int _d_offset, double[] z, int _z_offset, double[] delta, int _delta_offset, double rho, org.netlib.util.doubleW dlam, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  This subroutine computes the I-th eigenvalue of a symmetric rank-one
   *  modification of a 2-by-2 diagonal matrix
   *
   *             diag( D )  +  RHO *  Z * transpose(Z) .
   *
   *  The diagonal elements in the array D are assumed to satisfy
   *
   *             D(i) < D(j)  for  i < j .
   *
   *  We also assume RHO > 0 and that the Euclidean norm of the vector
   *  Z is one.
   *
   *  Arguments
   *  =========
   *
   *  I      (input) INTEGER
   *         The index of the eigenvalue to be computed.  I = 1 or I = 2.
   *
   *  D      (input) DOUBLE PRECISION array, dimension (2)
   *         The original eigenvalues.  We assume D(1) < D(2).
   *
   *  Z      (input) DOUBLE PRECISION array, dimension (2)
   *         The components of the updating vector.
   *
   *  DELTA  (output) DOUBLE PRECISION array, dimension (2)
   *         The vector DELTA contains the information necessary
   *         to construct the eigenvectors.
   *
   *  RHO    (input) DOUBLE PRECISION
   *         The scalar in the symmetric updating formula.
   *
   *  DLAM   (output) DOUBLE PRECISION
   *         The computed lambda_I, the I-th updated eigenvalue.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Ren-Cang Li, Computer Science Division, University of California
   *     at Berkeley, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param i
   * @param d
   * @param z
   * @param delta
   * @param rho
   * @param dlam
   * 
   */
  abstract public void dlaed5(int i, double[] d, double[] z, double[] delta, double rho, org.netlib.util.doubleW dlam);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  This subroutine computes the I-th eigenvalue of a symmetric rank-one
   *  modification of a 2-by-2 diagonal matrix
   *
   *             diag( D )  +  RHO *  Z * transpose(Z) .
   *
   *  The diagonal elements in the array D are assumed to satisfy
   *
   *             D(i) < D(j)  for  i < j .
   *
   *  We also assume RHO > 0 and that the Euclidean norm of the vector
   *  Z is one.
   *
   *  Arguments
   *  =========
   *
   *  I      (input) INTEGER
   *         The index of the eigenvalue to be computed.  I = 1 or I = 2.
   *
   *  D      (input) DOUBLE PRECISION array, dimension (2)
   *         The original eigenvalues.  We assume D(1) < D(2).
   *
   *  Z      (input) DOUBLE PRECISION array, dimension (2)
   *         The components of the updating vector.
   *
   *  DELTA  (output) DOUBLE PRECISION array, dimension (2)
   *         The vector DELTA contains the information necessary
   *         to construct the eigenvectors.
   *
   *  RHO    (input) DOUBLE PRECISION
   *         The scalar in the symmetric updating formula.
   *
   *  DLAM   (output) DOUBLE PRECISION
   *         The computed lambda_I, the I-th updated eigenvalue.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Ren-Cang Li, Computer Science Division, University of California
   *     at Berkeley, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param i
   * @param d
   * @param _d_offset
   * @param z
   * @param _z_offset
   * @param delta
   * @param _delta_offset
   * @param rho
   * @param dlam
   * 
   */
  abstract public void dlaed5(int i, double[] d, int _d_offset, double[] z, int _z_offset, double[] delta, int _delta_offset, double rho, org.netlib.util.doubleW dlam);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAED6 computes the positive or negative root (closest to the origin)
   *  of
   *                   z(1)        z(2)        z(3)
   *  f(x) =   rho + --------- + ---------- + ---------
   *                  d(1)-x      d(2)-x      d(3)-x
   *
   *  It is assumed that
   *
   *        if ORGATI = .true. the root is between d(2) and d(3);
   *        otherwise it is between d(1) and d(2)
   *
   *  This routine will be called by DLAED4 when necessary. In most cases,
   *  the root sought is the smallest in magnitude, though it might not be
   *  in some extremely rare situations.
   *
   *  Arguments
   *  =========
   *
   *  KNITER       (input) INTEGER
   *               Refer to DLAED4 for its significance.
   *
   *  ORGATI       (input) LOGICAL
   *               If ORGATI is true, the needed root is between d(2) and
   *               d(3); otherwise it is between d(1) and d(2).  See
   *               DLAED4 for further details.
   *
   *  RHO          (input) DOUBLE PRECISION
   *               Refer to the equation f(x) above.
   *
   *  D            (input) DOUBLE PRECISION array, dimension (3)
   *               D satisfies d(1) < d(2) < d(3).
   *
   *  Z            (input) DOUBLE PRECISION array, dimension (3)
   *               Each of the elements in z must be positive.
   *
   *  FINIT        (input) DOUBLE PRECISION
   *               The value of f at 0. It is more accurate than the one
   *               evaluated inside this routine (if someone wants to do
   *               so).
   *
   *  TAU          (output) DOUBLE PRECISION
   *               The root of the equation f(x).
   *
   *  INFO         (output) INTEGER
   *               = 0: successful exit
   *               > 0: if INFO = 1, failure to converge
   *
   *  Further Details
   *  ===============
   *
   *  30/06/99: Based on contributions by
   *     Ren-Cang Li, Computer Science Division, University of California
   *     at Berkeley, USA
   *
   *  10/02/03: This version has a few statements commented out for thread
   *  safety (machine parameters are computed on each entry). SJH.
   *
   *  05/10/06: Modified from a new version of Ren-Cang Li, use
   *     Gragg-Thornton-Warner cubic convergent scheme for better stability
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param kniter
   * @param orgati
   * @param rho
   * @param d
   * @param z
   * @param finit
   * @param tau
   * @param info
   * 
   */
  abstract public void dlaed6(int kniter, boolean orgati, double rho, double[] d, double[] z, double finit, org.netlib.util.doubleW tau, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAED6 computes the positive or negative root (closest to the origin)
   *  of
   *                   z(1)        z(2)        z(3)
   *  f(x) =   rho + --------- + ---------- + ---------
   *                  d(1)-x      d(2)-x      d(3)-x
   *
   *  It is assumed that
   *
   *        if ORGATI = .true. the root is between d(2) and d(3);
   *        otherwise it is between d(1) and d(2)
   *
   *  This routine will be called by DLAED4 when necessary. In most cases,
   *  the root sought is the smallest in magnitude, though it might not be
   *  in some extremely rare situations.
   *
   *  Arguments
   *  =========
   *
   *  KNITER       (input) INTEGER
   *               Refer to DLAED4 for its significance.
   *
   *  ORGATI       (input) LOGICAL
   *               If ORGATI is true, the needed root is between d(2) and
   *               d(3); otherwise it is between d(1) and d(2).  See
   *               DLAED4 for further details.
   *
   *  RHO          (input) DOUBLE PRECISION
   *               Refer to the equation f(x) above.
   *
   *  D            (input) DOUBLE PRECISION array, dimension (3)
   *               D satisfies d(1) < d(2) < d(3).
   *
   *  Z            (input) DOUBLE PRECISION array, dimension (3)
   *               Each of the elements in z must be positive.
   *
   *  FINIT        (input) DOUBLE PRECISION
   *               The value of f at 0. It is more accurate than the one
   *               evaluated inside this routine (if someone wants to do
   *               so).
   *
   *  TAU          (output) DOUBLE PRECISION
   *               The root of the equation f(x).
   *
   *  INFO         (output) INTEGER
   *               = 0: successful exit
   *               > 0: if INFO = 1, failure to converge
   *
   *  Further Details
   *  ===============
   *
   *  30/06/99: Based on contributions by
   *     Ren-Cang Li, Computer Science Division, University of California
   *     at Berkeley, USA
   *
   *  10/02/03: This version has a few statements commented out for thread
   *  safety (machine parameters are computed on each entry). SJH.
   *
   *  05/10/06: Modified from a new version of Ren-Cang Li, use
   *     Gragg-Thornton-Warner cubic convergent scheme for better stability
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param kniter
   * @param orgati
   * @param rho
   * @param d
   * @param _d_offset
   * @param z
   * @param _z_offset
   * @param finit
   * @param tau
   * @param info
   * 
   */
  abstract public void dlaed6(int kniter, boolean orgati, double rho, double[] d, int _d_offset, double[] z, int _z_offset, double finit, org.netlib.util.doubleW tau, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAED7 computes the updated eigensystem of a diagonal
   *  matrix after modification by a rank-one symmetric matrix. This
   *  routine is used only for the eigenproblem which requires all
   *  eigenvalues and optionally eigenvectors of a dense symmetric matrix
   *  that has been reduced to tridiagonal form.  DLAED1 handles
   *  the case in which all eigenvalues and eigenvectors of a symmetric
   *  tridiagonal matrix are desired.
   *
   *    T = Q(in) ( D(in) + RHO * Z*Z' ) Q'(in) = Q(out) * D(out) * Q'(out)
   *
   *     where Z = Q'u, u is a vector of length N with ones in the
   *     CUTPNT and CUTPNT + 1 th elements and zeros elsewhere.
   *
   *     The eigenvectors of the original matrix are stored in Q, and the
   *     eigenvalues are in D.  The algorithm consists of three stages:
   *
   *        The first stage consists of deflating the size of the problem
   *        when there are multiple eigenvalues or if there is a zero in
   *        the Z vector.  For each such occurence the dimension of the
   *        secular equation problem is reduced by one.  This stage is
   *        performed by the routine DLAED8.
   *
   *        The second stage consists of calculating the updated
   *        eigenvalues. This is done by finding the roots of the secular
   *        equation via the routine DLAED4 (as called by DLAED9).
   *        This routine also calculates the eigenvectors of the current
   *        problem.
   *
   *        The final stage consists of computing the updated eigenvectors
   *        directly using the updated eigenvalues.  The eigenvectors for
   *        the current problem are multiplied with the eigenvectors from
   *        the overall problem.
   *
   *  Arguments
   *  =========
   *
   *  ICOMPQ  (input) INTEGER
   *          = 0:  Compute eigenvalues only.
   *          = 1:  Compute eigenvectors of original dense symmetric matrix
   *                also.  On entry, Q contains the orthogonal matrix used
   *                to reduce the original matrix to tridiagonal form.
   *
   *  N      (input) INTEGER
   *         The dimension of the symmetric tridiagonal matrix.  N >= 0.
   *
   *  QSIZ   (input) INTEGER
   *         The dimension of the orthogonal matrix used to reduce
   *         the full matrix to tridiagonal form.  QSIZ >= N if ICOMPQ = 1.
   *
   *  TLVLS  (input) INTEGER
   *         The total number of merging levels in the overall divide and
   *         conquer tree.
   *
   *  CURLVL (input) INTEGER
   *         The current level in the overall merge routine,
   *         0 <= CURLVL <= TLVLS.
   *
   *  CURPBM (input) INTEGER
   *         The current problem in the current level in the overall
   *         merge routine (counting from upper left to lower right).
   *
   *  D      (input/output) DOUBLE PRECISION array, dimension (N)
   *         On entry, the eigenvalues of the rank-1-perturbed matrix.
   *         On exit, the eigenvalues of the repaired matrix.
   *
   *  Q      (input/output) DOUBLE PRECISION array, dimension (LDQ, N)
   *         On entry, the eigenvectors of the rank-1-perturbed matrix.
   *         On exit, the eigenvectors of the repaired tridiagonal matrix.
   *
   *  LDQ    (input) INTEGER
   *         The leading dimension of the array Q.  LDQ >= max(1,N).
   *
   *  INDXQ  (output) INTEGER array, dimension (N)
   *         The permutation which will reintegrate the subproblem just
   *         solved back into sorted order, i.e., D( INDXQ( I = 1, N ) )
   *         will be in ascending order.
   *
   *  RHO    (input) DOUBLE PRECISION
   *         The subdiagonal element used to create the rank-1
   *         modification.
   *
   *  CUTPNT (input) INTEGER
   *         Contains the location of the last eigenvalue in the leading
   *         sub-matrix.  min(1,N) <= CUTPNT <= N.
   *
   *  QSTORE (input/output) DOUBLE PRECISION array, dimension (N**2+1)
   *         Stores eigenvectors of submatrices encountered during
   *         divide and conquer, packed together. QPTR points to
   *         beginning of the submatrices.
   *
   *  QPTR   (input/output) INTEGER array, dimension (N+2)
   *         List of indices pointing to beginning of submatrices stored
   *         in QSTORE. The submatrices are numbered starting at the
   *         bottom left of the divide and conquer tree, from left to
   *         right and bottom to top.
   *
   *  PRMPTR (input) INTEGER array, dimension (N lg N)
   *         Contains a list of pointers which indicate where in PERM a
   *         level's permutation is stored.  PRMPTR(i+1) - PRMPTR(i)
   *         indicates the size of the permutation and also the size of
   *         the full, non-deflated problem.
   *
   *  PERM   (input) INTEGER array, dimension (N lg N)
   *         Contains the permutations (from deflation and sorting) to be
   *         applied to each eigenblock.
   *
   *  GIVPTR (input) INTEGER array, dimension (N lg N)
   *         Contains a list of pointers which indicate where in GIVCOL a
   *         level's Givens rotations are stored.  GIVPTR(i+1) - GIVPTR(i)
   *         indicates the number of Givens rotations.
   *
   *  GIVCOL (input) INTEGER array, dimension (2, N lg N)
   *         Each pair of numbers indicates a pair of columns to take place
   *         in a Givens rotation.
   *
   *  GIVNUM (input) DOUBLE PRECISION array, dimension (2, N lg N)
   *         Each number indicates the S value to be used in the
   *         corresponding Givens rotation.
   *
   *  WORK   (workspace) DOUBLE PRECISION array, dimension (3*N+QSIZ*N)
   *
   *  IWORK  (workspace) INTEGER array, dimension (4*N)
   *
   *  INFO   (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  if INFO = 1, an eigenvalue did not converge
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Jeff Rutter, Computer Science Division, University of California
   *     at Berkeley, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param icompq
   * @param n
   * @param qsiz
   * @param tlvls
   * @param curlvl
   * @param curpbm
   * @param d
   * @param q
   * @param ldq
   * @param indxq
   * @param rho
   * @param cutpnt
   * @param qstore
   * @param qptr
   * @param prmptr
   * @param perm
   * @param givptr
   * @param givcol
   * @param givnum
   * @param work
   * @param iwork
   * @param info
   * 
   */
  abstract public void dlaed7(int icompq, int n, int qsiz, int tlvls, int curlvl, int curpbm, double[] d, double[] q, int ldq, int[] indxq, org.netlib.util.doubleW rho, int cutpnt, double[] qstore, int[] qptr, int[] prmptr, int[] perm, int[] givptr, int[] givcol, double[] givnum, double[] work, int[] iwork, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAED7 computes the updated eigensystem of a diagonal
   *  matrix after modification by a rank-one symmetric matrix. This
   *  routine is used only for the eigenproblem which requires all
   *  eigenvalues and optionally eigenvectors of a dense symmetric matrix
   *  that has been reduced to tridiagonal form.  DLAED1 handles
   *  the case in which all eigenvalues and eigenvectors of a symmetric
   *  tridiagonal matrix are desired.
   *
   *    T = Q(in) ( D(in) + RHO * Z*Z' ) Q'(in) = Q(out) * D(out) * Q'(out)
   *
   *     where Z = Q'u, u is a vector of length N with ones in the
   *     CUTPNT and CUTPNT + 1 th elements and zeros elsewhere.
   *
   *     The eigenvectors of the original matrix are stored in Q, and the
   *     eigenvalues are in D.  The algorithm consists of three stages:
   *
   *        The first stage consists of deflating the size of the problem
   *        when there are multiple eigenvalues or if there is a zero in
   *        the Z vector.  For each such occurence the dimension of the
   *        secular equation problem is reduced by one.  This stage is
   *        performed by the routine DLAED8.
   *
   *        The second stage consists of calculating the updated
   *        eigenvalues. This is done by finding the roots of the secular
   *        equation via the routine DLAED4 (as called by DLAED9).
   *        This routine also calculates the eigenvectors of the current
   *        problem.
   *
   *        The final stage consists of computing the updated eigenvectors
   *        directly using the updated eigenvalues.  The eigenvectors for
   *        the current problem are multiplied with the eigenvectors from
   *        the overall problem.
   *
   *  Arguments
   *  =========
   *
   *  ICOMPQ  (input) INTEGER
   *          = 0:  Compute eigenvalues only.
   *          = 1:  Compute eigenvectors of original dense symmetric matrix
   *                also.  On entry, Q contains the orthogonal matrix used
   *                to reduce the original matrix to tridiagonal form.
   *
   *  N      (input) INTEGER
   *         The dimension of the symmetric tridiagonal matrix.  N >= 0.
   *
   *  QSIZ   (input) INTEGER
   *         The dimension of the orthogonal matrix used to reduce
   *         the full matrix to tridiagonal form.  QSIZ >= N if ICOMPQ = 1.
   *
   *  TLVLS  (input) INTEGER
   *         The total number of merging levels in the overall divide and
   *         conquer tree.
   *
   *  CURLVL (input) INTEGER
   *         The current level in the overall merge routine,
   *         0 <= CURLVL <= TLVLS.
   *
   *  CURPBM (input) INTEGER
   *         The current problem in the current level in the overall
   *         merge routine (counting from upper left to lower right).
   *
   *  D      (input/output) DOUBLE PRECISION array, dimension (N)
   *         On entry, the eigenvalues of the rank-1-perturbed matrix.
   *         On exit, the eigenvalues of the repaired matrix.
   *
   *  Q      (input/output) DOUBLE PRECISION array, dimension (LDQ, N)
   *         On entry, the eigenvectors of the rank-1-perturbed matrix.
   *         On exit, the eigenvectors of the repaired tridiagonal matrix.
   *
   *  LDQ    (input) INTEGER
   *         The leading dimension of the array Q.  LDQ >= max(1,N).
   *
   *  INDXQ  (output) INTEGER array, dimension (N)
   *         The permutation which will reintegrate the subproblem just
   *         solved back into sorted order, i.e., D( INDXQ( I = 1, N ) )
   *         will be in ascending order.
   *
   *  RHO    (input) DOUBLE PRECISION
   *         The subdiagonal element used to create the rank-1
   *         modification.
   *
   *  CUTPNT (input) INTEGER
   *         Contains the location of the last eigenvalue in the leading
   *         sub-matrix.  min(1,N) <= CUTPNT <= N.
   *
   *  QSTORE (input/output) DOUBLE PRECISION array, dimension (N**2+1)
   *         Stores eigenvectors of submatrices encountered during
   *         divide and conquer, packed together. QPTR points to
   *         beginning of the submatrices.
   *
   *  QPTR   (input/output) INTEGER array, dimension (N+2)
   *         List of indices pointing to beginning of submatrices stored
   *         in QSTORE. The submatrices are numbered starting at the
   *         bottom left of the divide and conquer tree, from left to
   *         right and bottom to top.
   *
   *  PRMPTR (input) INTEGER array, dimension (N lg N)
   *         Contains a list of pointers which indicate where in PERM a
   *         level's permutation is stored.  PRMPTR(i+1) - PRMPTR(i)
   *         indicates the size of the permutation and also the size of
   *         the full, non-deflated problem.
   *
   *  PERM   (input) INTEGER array, dimension (N lg N)
   *         Contains the permutations (from deflation and sorting) to be
   *         applied to each eigenblock.
   *
   *  GIVPTR (input) INTEGER array, dimension (N lg N)
   *         Contains a list of pointers which indicate where in GIVCOL a
   *         level's Givens rotations are stored.  GIVPTR(i+1) - GIVPTR(i)
   *         indicates the number of Givens rotations.
   *
   *  GIVCOL (input) INTEGER array, dimension (2, N lg N)
   *         Each pair of numbers indicates a pair of columns to take place
   *         in a Givens rotation.
   *
   *  GIVNUM (input) DOUBLE PRECISION array, dimension (2, N lg N)
   *         Each number indicates the S value to be used in the
   *         corresponding Givens rotation.
   *
   *  WORK   (workspace) DOUBLE PRECISION array, dimension (3*N+QSIZ*N)
   *
   *  IWORK  (workspace) INTEGER array, dimension (4*N)
   *
   *  INFO   (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  if INFO = 1, an eigenvalue did not converge
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Jeff Rutter, Computer Science Division, University of California
   *     at Berkeley, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param icompq
   * @param n
   * @param qsiz
   * @param tlvls
   * @param curlvl
   * @param curpbm
   * @param d
   * @param _d_offset
   * @param q
   * @param _q_offset
   * @param ldq
   * @param indxq
   * @param _indxq_offset
   * @param rho
   * @param cutpnt
   * @param qstore
   * @param _qstore_offset
   * @param qptr
   * @param _qptr_offset
   * @param prmptr
   * @param _prmptr_offset
   * @param perm
   * @param _perm_offset
   * @param givptr
   * @param _givptr_offset
   * @param givcol
   * @param _givcol_offset
   * @param givnum
   * @param _givnum_offset
   * @param work
   * @param _work_offset
   * @param iwork
   * @param _iwork_offset
   * @param info
   * 
   */
  abstract public void dlaed7(int icompq, int n, int qsiz, int tlvls, int curlvl, int curpbm, double[] d, int _d_offset, double[] q, int _q_offset, int ldq, int[] indxq, int _indxq_offset, org.netlib.util.doubleW rho, int cutpnt, double[] qstore, int _qstore_offset, int[] qptr, int _qptr_offset, int[] prmptr, int _prmptr_offset, int[] perm, int _perm_offset, int[] givptr, int _givptr_offset, int[] givcol, int _givcol_offset, double[] givnum, int _givnum_offset, double[] work, int _work_offset, int[] iwork, int _iwork_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAED8 merges the two sets of eigenvalues together into a single
   *  sorted set.  Then it tries to deflate the size of the problem.
   *  There are two ways in which deflation can occur:  when two or more
   *  eigenvalues are close together or if there is a tiny element in the
   *  Z vector.  For each such occurrence the order of the related secular
   *  equation problem is reduced by one.
   *
   *  Arguments
   *  =========
   *
   *  ICOMPQ  (input) INTEGER
   *          = 0:  Compute eigenvalues only.
   *          = 1:  Compute eigenvectors of original dense symmetric matrix
   *                also.  On entry, Q contains the orthogonal matrix used
   *                to reduce the original matrix to tridiagonal form.
   *
   *  K      (output) INTEGER
   *         The number of non-deflated eigenvalues, and the order of the
   *         related secular equation.
   *
   *  N      (input) INTEGER
   *         The dimension of the symmetric tridiagonal matrix.  N >= 0.
   *
   *  QSIZ   (input) INTEGER
   *         The dimension of the orthogonal matrix used to reduce
   *         the full matrix to tridiagonal form.  QSIZ >= N if ICOMPQ = 1.
   *
   *  D      (input/output) DOUBLE PRECISION array, dimension (N)
   *         On entry, the eigenvalues of the two submatrices to be
   *         combined.  On exit, the trailing (N-K) updated eigenvalues
   *         (those which were deflated) sorted into increasing order.
   *
   *  Q      (input/output) DOUBLE PRECISION array, dimension (LDQ,N)
   *         If ICOMPQ = 0, Q is not referenced.  Otherwise,
   *         on entry, Q contains the eigenvectors of the partially solved
   *         system which has been previously updated in matrix
   *         multiplies with other partially solved eigensystems.
   *         On exit, Q contains the trailing (N-K) updated eigenvectors
   *         (those which were deflated) in its last N-K columns.
   *
   *  LDQ    (input) INTEGER
   *         The leading dimension of the array Q.  LDQ >= max(1,N).
   *
   *  INDXQ  (input) INTEGER array, dimension (N)
   *         The permutation which separately sorts the two sub-problems
   *         in D into ascending order.  Note that elements in the second
   *         half of this permutation must first have CUTPNT added to
   *         their values in order to be accurate.
   *
   *  RHO    (input/output) DOUBLE PRECISION
   *         On entry, the off-diagonal element associated with the rank-1
   *         cut which originally split the two submatrices which are now
   *         being recombined.
   *         On exit, RHO has been modified to the value required by
   *         DLAED3.
   *
   *  CUTPNT (input) INTEGER
   *         The location of the last eigenvalue in the leading
   *         sub-matrix.  min(1,N) <= CUTPNT <= N.
   *
   *  Z      (input) DOUBLE PRECISION array, dimension (N)
   *         On entry, Z contains the updating vector (the last row of
   *         the first sub-eigenvector matrix and the first row of the
   *         second sub-eigenvector matrix).
   *         On exit, the contents of Z are destroyed by the updating
   *         process.
   *
   *  DLAMDA (output) DOUBLE PRECISION array, dimension (N)
   *         A copy of the first K eigenvalues which will be used by
   *         DLAED3 to form the secular equation.
   *
   *  Q2     (output) DOUBLE PRECISION array, dimension (LDQ2,N)
   *         If ICOMPQ = 0, Q2 is not referenced.  Otherwise,
   *         a copy of the first K eigenvectors which will be used by
   *         DLAED7 in a matrix multiply (DGEMM) to update the new
   *         eigenvectors.
   *
   *  LDQ2   (input) INTEGER
   *         The leading dimension of the array Q2.  LDQ2 >= max(1,N).
   *
   *  W      (output) DOUBLE PRECISION array, dimension (N)
   *         The first k values of the final deflation-altered z-vector and
   *         will be passed to DLAED3.
   *
   *  PERM   (output) INTEGER array, dimension (N)
   *         The permutations (from deflation and sorting) to be applied
   *         to each eigenblock.
   *
   *  GIVPTR (output) INTEGER
   *         The number of Givens rotations which took place in this
   *         subproblem.
   *
   *  GIVCOL (output) INTEGER array, dimension (2, N)
   *         Each pair of numbers indicates a pair of columns to take place
   *         in a Givens rotation.
   *
   *  GIVNUM (output) DOUBLE PRECISION array, dimension (2, N)
   *         Each number indicates the S value to be used in the
   *         corresponding Givens rotation.
   *
   *  INDXP  (workspace) INTEGER array, dimension (N)
   *         The permutation used to place deflated values of D at the end
   *         of the array.  INDXP(1:K) points to the nondeflated D-values
   *         and INDXP(K+1:N) points to the deflated eigenvalues.
   *
   *  INDX   (workspace) INTEGER array, dimension (N)
   *         The permutation used to sort the contents of D into ascending
   *         order.
   *
   *  INFO   (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Jeff Rutter, Computer Science Division, University of California
   *     at Berkeley, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param icompq
   * @param k
   * @param n
   * @param qsiz
   * @param d
   * @param q
   * @param ldq
   * @param indxq
   * @param rho
   * @param cutpnt
   * @param z
   * @param dlamda
   * @param q2
   * @param ldq2
   * @param w
   * @param perm
   * @param givptr
   * @param givcol
   * @param givnum
   * @param indxp
   * @param indx
   * @param info
   * 
   */
  abstract public void dlaed8(int icompq, org.netlib.util.intW k, int n, int qsiz, double[] d, double[] q, int ldq, int[] indxq, org.netlib.util.doubleW rho, int cutpnt, double[] z, double[] dlamda, double[] q2, int ldq2, double[] w, int[] perm, org.netlib.util.intW givptr, int[] givcol, double[] givnum, int[] indxp, int[] indx, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAED8 merges the two sets of eigenvalues together into a single
   *  sorted set.  Then it tries to deflate the size of the problem.
   *  There are two ways in which deflation can occur:  when two or more
   *  eigenvalues are close together or if there is a tiny element in the
   *  Z vector.  For each such occurrence the order of the related secular
   *  equation problem is reduced by one.
   *
   *  Arguments
   *  =========
   *
   *  ICOMPQ  (input) INTEGER
   *          = 0:  Compute eigenvalues only.
   *          = 1:  Compute eigenvectors of original dense symmetric matrix
   *                also.  On entry, Q contains the orthogonal matrix used
   *                to reduce the original matrix to tridiagonal form.
   *
   *  K      (output) INTEGER
   *         The number of non-deflated eigenvalues, and the order of the
   *         related secular equation.
   *
   *  N      (input) INTEGER
   *         The dimension of the symmetric tridiagonal matrix.  N >= 0.
   *
   *  QSIZ   (input) INTEGER
   *         The dimension of the orthogonal matrix used to reduce
   *         the full matrix to tridiagonal form.  QSIZ >= N if ICOMPQ = 1.
   *
   *  D      (input/output) DOUBLE PRECISION array, dimension (N)
   *         On entry, the eigenvalues of the two submatrices to be
   *         combined.  On exit, the trailing (N-K) updated eigenvalues
   *         (those which were deflated) sorted into increasing order.
   *
   *  Q      (input/output) DOUBLE PRECISION array, dimension (LDQ,N)
   *         If ICOMPQ = 0, Q is not referenced.  Otherwise,
   *         on entry, Q contains the eigenvectors of the partially solved
   *         system which has been previously updated in matrix
   *         multiplies with other partially solved eigensystems.
   *         On exit, Q contains the trailing (N-K) updated eigenvectors
   *         (those which were deflated) in its last N-K columns.
   *
   *  LDQ    (input) INTEGER
   *         The leading dimension of the array Q.  LDQ >= max(1,N).
   *
   *  INDXQ  (input) INTEGER array, dimension (N)
   *         The permutation which separately sorts the two sub-problems
   *         in D into ascending order.  Note that elements in the second
   *         half of this permutation must first have CUTPNT added to
   *         their values in order to be accurate.
   *
   *  RHO    (input/output) DOUBLE PRECISION
   *         On entry, the off-diagonal element associated with the rank-1
   *         cut which originally split the two submatrices which are now
   *         being recombined.
   *         On exit, RHO has been modified to the value required by
   *         DLAED3.
   *
   *  CUTPNT (input) INTEGER
   *         The location of the last eigenvalue in the leading
   *         sub-matrix.  min(1,N) <= CUTPNT <= N.
   *
   *  Z      (input) DOUBLE PRECISION array, dimension (N)
   *         On entry, Z contains the updating vector (the last row of
   *         the first sub-eigenvector matrix and the first row of the
   *         second sub-eigenvector matrix).
   *         On exit, the contents of Z are destroyed by the updating
   *         process.
   *
   *  DLAMDA (output) DOUBLE PRECISION array, dimension (N)
   *         A copy of the first K eigenvalues which will be used by
   *         DLAED3 to form the secular equation.
   *
   *  Q2     (output) DOUBLE PRECISION array, dimension (LDQ2,N)
   *         If ICOMPQ = 0, Q2 is not referenced.  Otherwise,
   *         a copy of the first K eigenvectors which will be used by
   *         DLAED7 in a matrix multiply (DGEMM) to update the new
   *         eigenvectors.
   *
   *  LDQ2   (input) INTEGER
   *         The leading dimension of the array Q2.  LDQ2 >= max(1,N).
   *
   *  W      (output) DOUBLE PRECISION array, dimension (N)
   *         The first k values of the final deflation-altered z-vector and
   *         will be passed to DLAED3.
   *
   *  PERM   (output) INTEGER array, dimension (N)
   *         The permutations (from deflation and sorting) to be applied
   *         to each eigenblock.
   *
   *  GIVPTR (output) INTEGER
   *         The number of Givens rotations which took place in this
   *         subproblem.
   *
   *  GIVCOL (output) INTEGER array, dimension (2, N)
   *         Each pair of numbers indicates a pair of columns to take place
   *         in a Givens rotation.
   *
   *  GIVNUM (output) DOUBLE PRECISION array, dimension (2, N)
   *         Each number indicates the S value to be used in the
   *         corresponding Givens rotation.
   *
   *  INDXP  (workspace) INTEGER array, dimension (N)
   *         The permutation used to place deflated values of D at the end
   *         of the array.  INDXP(1:K) points to the nondeflated D-values
   *         and INDXP(K+1:N) points to the deflated eigenvalues.
   *
   *  INDX   (workspace) INTEGER array, dimension (N)
   *         The permutation used to sort the contents of D into ascending
   *         order.
   *
   *  INFO   (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Jeff Rutter, Computer Science Division, University of California
   *     at Berkeley, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param icompq
   * @param k
   * @param n
   * @param qsiz
   * @param d
   * @param _d_offset
   * @param q
   * @param _q_offset
   * @param ldq
   * @param indxq
   * @param _indxq_offset
   * @param rho
   * @param cutpnt
   * @param z
   * @param _z_offset
   * @param dlamda
   * @param _dlamda_offset
   * @param q2
   * @param _q2_offset
   * @param ldq2
   * @param w
   * @param _w_offset
   * @param perm
   * @param _perm_offset
   * @param givptr
   * @param givcol
   * @param _givcol_offset
   * @param givnum
   * @param _givnum_offset
   * @param indxp
   * @param _indxp_offset
   * @param indx
   * @param _indx_offset
   * @param info
   * 
   */
  abstract public void dlaed8(int icompq, org.netlib.util.intW k, int n, int qsiz, double[] d, int _d_offset, double[] q, int _q_offset, int ldq, int[] indxq, int _indxq_offset, org.netlib.util.doubleW rho, int cutpnt, double[] z, int _z_offset, double[] dlamda, int _dlamda_offset, double[] q2, int _q2_offset, int ldq2, double[] w, int _w_offset, int[] perm, int _perm_offset, org.netlib.util.intW givptr, int[] givcol, int _givcol_offset, double[] givnum, int _givnum_offset, int[] indxp, int _indxp_offset, int[] indx, int _indx_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAED9 finds the roots of the secular equation, as defined by the
   *  values in D, Z, and RHO, between KSTART and KSTOP.  It makes the
   *  appropriate calls to DLAED4 and then stores the new matrix of
   *  eigenvectors for use in calculating the next level of Z vectors.
   *
   *  Arguments
   *  =========
   *
   *  K       (input) INTEGER
   *          The number of terms in the rational function to be solved by
   *          DLAED4.  K >= 0.
   *
   *  KSTART  (input) INTEGER
   *  KSTOP   (input) INTEGER
   *          The updated eigenvalues Lambda(I), KSTART <= I <= KSTOP
   *          are to be computed.  1 <= KSTART <= KSTOP <= K.
   *
   *  N       (input) INTEGER
   *          The number of rows and columns in the Q matrix.
   *          N >= K (delation may result in N > K).
   *
   *  D       (output) DOUBLE PRECISION array, dimension (N)
   *          D(I) contains the updated eigenvalues
   *          for KSTART <= I <= KSTOP.
   *
   *  Q       (workspace) DOUBLE PRECISION array, dimension (LDQ,N)
   *
   *  LDQ     (input) INTEGER
   *          The leading dimension of the array Q.  LDQ >= max( 1, N ).
   *
   *  RHO     (input) DOUBLE PRECISION
   *          The value of the parameter in the rank one update equation.
   *          RHO >= 0 required.
   *
   *  DLAMDA  (input) DOUBLE PRECISION array, dimension (K)
   *          The first K elements of this array contain the old roots
   *          of the deflated updating problem.  These are the poles
   *          of the secular equation.
   *
   *  W       (input) DOUBLE PRECISION array, dimension (K)
   *          The first K elements of this array contain the components
   *          of the deflation-adjusted updating vector.
   *
   *  S       (output) DOUBLE PRECISION array, dimension (LDS, K)
   *          Will contain the eigenvectors of the repaired matrix which
   *          will be stored for subsequent Z vector calculation and
   *          multiplied by the previously accumulated eigenvectors
   *          to update the system.
   *
   *  LDS     (input) INTEGER
   *          The leading dimension of S.  LDS >= max( 1, K ).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  if INFO = 1, an eigenvalue did not converge
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Jeff Rutter, Computer Science Division, University of California
   *     at Berkeley, USA
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param k
   * @param kstart
   * @param kstop
   * @param n
   * @param d
   * @param q
   * @param ldq
   * @param rho
   * @param dlamda
   * @param w
   * @param s
   * @param lds
   * @param info
   * 
   */
  abstract public void dlaed9(int k, int kstart, int kstop, int n, double[] d, double[] q, int ldq, double rho, double[] dlamda, double[] w, double[] s, int lds, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAED9 finds the roots of the secular equation, as defined by the
   *  values in D, Z, and RHO, between KSTART and KSTOP.  It makes the
   *  appropriate calls to DLAED4 and then stores the new matrix of
   *  eigenvectors for use in calculating the next level of Z vectors.
   *
   *  Arguments
   *  =========
   *
   *  K       (input) INTEGER
   *          The number of terms in the rational function to be solved by
   *          DLAED4.  K >= 0.
   *
   *  KSTART  (input) INTEGER
   *  KSTOP   (input) INTEGER
   *          The updated eigenvalues Lambda(I), KSTART <= I <= KSTOP
   *          are to be computed.  1 <= KSTART <= KSTOP <= K.
   *
   *  N       (input) INTEGER
   *          The number of rows and columns in the Q matrix.
   *          N >= K (delation may result in N > K).
   *
   *  D       (output) DOUBLE PRECISION array, dimension (N)
   *          D(I) contains the updated eigenvalues
   *          for KSTART <= I <= KSTOP.
   *
   *  Q       (workspace) DOUBLE PRECISION array, dimension (LDQ,N)
   *
   *  LDQ     (input) INTEGER
   *          The leading dimension of the array Q.  LDQ >= max( 1, N ).
   *
   *  RHO     (input) DOUBLE PRECISION
   *          The value of the parameter in the rank one update equation.
   *          RHO >= 0 required.
   *
   *  DLAMDA  (input) DOUBLE PRECISION array, dimension (K)
   *          The first K elements of this array contain the old roots
   *          of the deflated updating problem.  These are the poles
   *          of the secular equation.
   *
   *  W       (input) DOUBLE PRECISION array, dimension (K)
   *          The first K elements of this array contain the components
   *          of the deflation-adjusted updating vector.
   *
   *  S       (output) DOUBLE PRECISION array, dimension (LDS, K)
   *          Will contain the eigenvectors of the repaired matrix which
   *          will be stored for subsequent Z vector calculation and
   *          multiplied by the previously accumulated eigenvectors
   *          to update the system.
   *
   *  LDS     (input) INTEGER
   *          The leading dimension of S.  LDS >= max( 1, K ).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *          > 0:  if INFO = 1, an eigenvalue did not converge
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Jeff Rutter, Computer Science Division, University of California
   *     at Berkeley, USA
   *
   *  =====================================================================
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param k
   * @param kstart
   * @param kstop
   * @param n
   * @param d
   * @param _d_offset
   * @param q
   * @param _q_offset
   * @param ldq
   * @param rho
   * @param dlamda
   * @param _dlamda_offset
   * @param w
   * @param _w_offset
   * @param s
   * @param _s_offset
   * @param lds
   * @param info
   * 
   */
  abstract public void dlaed9(int k, int kstart, int kstop, int n, double[] d, int _d_offset, double[] q, int _q_offset, int ldq, double rho, double[] dlamda, int _dlamda_offset, double[] w, int _w_offset, double[] s, int _s_offset, int lds, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAEDA computes the Z vector corresponding to the merge step in the
   *  CURLVLth step of the merge process with TLVLS steps for the CURPBMth
   *  problem.
   *
   *  Arguments
   *  =========
   *
   *  N      (input) INTEGER
   *         The dimension of the symmetric tridiagonal matrix.  N >= 0.
   *
   *  TLVLS  (input) INTEGER
   *         The total number of merging levels in the overall divide and
   *         conquer tree.
   *
   *  CURLVL (input) INTEGER
   *         The current level in the overall merge routine,
   *         0 <= curlvl <= tlvls.
   *
   *  CURPBM (input) INTEGER
   *         The current problem in the current level in the overall
   *         merge routine (counting from upper left to lower right).
   *
   *  PRMPTR (input) INTEGER array, dimension (N lg N)
   *         Contains a list of pointers which indicate where in PERM a
   *         level's permutation is stored.  PRMPTR(i+1) - PRMPTR(i)
   *         indicates the size of the permutation and incidentally the
   *         size of the full, non-deflated problem.
   *
   *  PERM   (input) INTEGER array, dimension (N lg N)
   *         Contains the permutations (from deflation and sorting) to be
   *         applied to each eigenblock.
   *
   *  GIVPTR (input) INTEGER array, dimension (N lg N)
   *         Contains a list of pointers which indicate where in GIVCOL a
   *         level's Givens rotations are stored.  GIVPTR(i+1) - GIVPTR(i)
   *         indicates the number of Givens rotations.
   *
   *  GIVCOL (input) INTEGER array, dimension (2, N lg N)
   *         Each pair of numbers indicates a pair of columns to take place
   *         in a Givens rotation.
   *
   *  GIVNUM (input) DOUBLE PRECISION array, dimension (2, N lg N)
   *         Each number indicates the S value to be used in the
   *         corresponding Givens rotation.
   *
   *  Q      (input) DOUBLE PRECISION array, dimension (N**2)
   *         Contains the square eigenblocks from previous levels, the
   *         starting positions for blocks are given by QPTR.
   *
   *  QPTR   (input) INTEGER array, dimension (N+2)
   *         Contains a list of pointers which indicate where in Q an
   *         eigenblock is stored.  SQRT( QPTR(i+1) - QPTR(i) ) indicates
   *         the size of the block.
   *
   *  Z      (output) DOUBLE PRECISION array, dimension (N)
   *         On output this vector contains the updating vector (the last
   *         row of the first sub-eigenvector matrix and the first row of
   *         the second sub-eigenvector matrix).
   *
   *  ZTEMP  (workspace) DOUBLE PRECISION array, dimension (N)
   *
   *  INFO   (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Jeff Rutter, Computer Science Division, University of California
   *     at Berkeley, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param tlvls
   * @param curlvl
   * @param curpbm
   * @param prmptr
   * @param perm
   * @param givptr
   * @param givcol
   * @param givnum
   * @param q
   * @param qptr
   * @param z
   * @param ztemp
   * @param info
   * 
   */
  abstract public void dlaeda(int n, int tlvls, int curlvl, int curpbm, int[] prmptr, int[] perm, int[] givptr, int[] givcol, double[] givnum, double[] q, int[] qptr, double[] z, double[] ztemp, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAEDA computes the Z vector corresponding to the merge step in the
   *  CURLVLth step of the merge process with TLVLS steps for the CURPBMth
   *  problem.
   *
   *  Arguments
   *  =========
   *
   *  N      (input) INTEGER
   *         The dimension of the symmetric tridiagonal matrix.  N >= 0.
   *
   *  TLVLS  (input) INTEGER
   *         The total number of merging levels in the overall divide and
   *         conquer tree.
   *
   *  CURLVL (input) INTEGER
   *         The current level in the overall merge routine,
   *         0 <= curlvl <= tlvls.
   *
   *  CURPBM (input) INTEGER
   *         The current problem in the current level in the overall
   *         merge routine (counting from upper left to lower right).
   *
   *  PRMPTR (input) INTEGER array, dimension (N lg N)
   *         Contains a list of pointers which indicate where in PERM a
   *         level's permutation is stored.  PRMPTR(i+1) - PRMPTR(i)
   *         indicates the size of the permutation and incidentally the
   *         size of the full, non-deflated problem.
   *
   *  PERM   (input) INTEGER array, dimension (N lg N)
   *         Contains the permutations (from deflation and sorting) to be
   *         applied to each eigenblock.
   *
   *  GIVPTR (input) INTEGER array, dimension (N lg N)
   *         Contains a list of pointers which indicate where in GIVCOL a
   *         level's Givens rotations are stored.  GIVPTR(i+1) - GIVPTR(i)
   *         indicates the number of Givens rotations.
   *
   *  GIVCOL (input) INTEGER array, dimension (2, N lg N)
   *         Each pair of numbers indicates a pair of columns to take place
   *         in a Givens rotation.
   *
   *  GIVNUM (input) DOUBLE PRECISION array, dimension (2, N lg N)
   *         Each number indicates the S value to be used in the
   *         corresponding Givens rotation.
   *
   *  Q      (input) DOUBLE PRECISION array, dimension (N**2)
   *         Contains the square eigenblocks from previous levels, the
   *         starting positions for blocks are given by QPTR.
   *
   *  QPTR   (input) INTEGER array, dimension (N+2)
   *         Contains a list of pointers which indicate where in Q an
   *         eigenblock is stored.  SQRT( QPTR(i+1) - QPTR(i) ) indicates
   *         the size of the block.
   *
   *  Z      (output) DOUBLE PRECISION array, dimension (N)
   *         On output this vector contains the updating vector (the last
   *         row of the first sub-eigenvector matrix and the first row of
   *         the second sub-eigenvector matrix).
   *
   *  ZTEMP  (workspace) DOUBLE PRECISION array, dimension (N)
   *
   *  INFO   (output) INTEGER
   *          = 0:  successful exit.
   *          < 0:  if INFO = -i, the i-th argument had an illegal value.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Jeff Rutter, Computer Science Division, University of California
   *     at Berkeley, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param tlvls
   * @param curlvl
   * @param curpbm
   * @param prmptr
   * @param _prmptr_offset
   * @param perm
   * @param _perm_offset
   * @param givptr
   * @param _givptr_offset
   * @param givcol
   * @param _givcol_offset
   * @param givnum
   * @param _givnum_offset
   * @param q
   * @param _q_offset
   * @param qptr
   * @param _qptr_offset
   * @param z
   * @param _z_offset
   * @param ztemp
   * @param _ztemp_offset
   * @param info
   * 
   */
  abstract public void dlaeda(int n, int tlvls, int curlvl, int curpbm, int[] prmptr, int _prmptr_offset, int[] perm, int _perm_offset, int[] givptr, int _givptr_offset, int[] givcol, int _givcol_offset, double[] givnum, int _givnum_offset, double[] q, int _q_offset, int[] qptr, int _qptr_offset, double[] z, int _z_offset, double[] ztemp, int _ztemp_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAEIN uses inverse iteration to find a right or left eigenvector
   *  corresponding to the eigenvalue (WR,WI) of a real upper Hessenberg
   *  matrix H.
   *
   *  Arguments
   *  =========
   *
   *  RIGHTV   (input) LOGICAL
   *          = .TRUE. : compute right eigenvector;
   *          = .FALSE.: compute left eigenvector.
   *
   *  NOINIT   (input) LOGICAL
   *          = .TRUE. : no initial vector supplied in (VR,VI).
   *          = .FALSE.: initial vector supplied in (VR,VI).
   *
   *  N       (input) INTEGER
   *          The order of the matrix H.  N >= 0.
   *
   *  H       (input) DOUBLE PRECISION array, dimension (LDH,N)
   *          The upper Hessenberg matrix H.
   *
   *  LDH     (input) INTEGER
   *          The leading dimension of the array H.  LDH >= max(1,N).
   *
   *  WR      (input) DOUBLE PRECISION
   *  WI      (input) DOUBLE PRECISION
   *          The real and imaginary parts of the eigenvalue of H whose
   *          corresponding right or left eigenvector is to be computed.
   *
   *  VR      (input/output) DOUBLE PRECISION array, dimension (N)
   *  VI      (input/output) DOUBLE PRECISION array, dimension (N)
   *          On entry, if NOINIT = .FALSE. and WI = 0.0, VR must contain
   *          a real starting vector for inverse iteration using the real
   *          eigenvalue WR; if NOINIT = .FALSE. and WI.ne.0.0, VR and VI
   *          must contain the real and imaginary parts of a complex
   *          starting vector for inverse iteration using the complex
   *          eigenvalue (WR,WI); otherwise VR and VI need not be set.
   *          On exit, if WI = 0.0 (real eigenvalue), VR contains the
   *          computed real eigenvector; if WI.ne.0.0 (complex eigenvalue),
   *          VR and VI contain the real and imaginary parts of the
   *          computed complex eigenvector. The eigenvector is normalized
   *          so that the component of largest magnitude has magnitude 1;
   *          here the magnitude of a complex number (x,y) is taken to be
   *          |x| + |y|.
   *          VI is not referenced if WI = 0.0.
   *
   *  B       (workspace) DOUBLE PRECISION array, dimension (LDB,N)
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= N+1.
   *
   *  WORK   (workspace) DOUBLE PRECISION array, dimension (N)
   *
   *  EPS3    (input) DOUBLE PRECISION
   *          A small machine-dependent value which is used to perturb
   *          close eigenvalues, and to replace zero pivots.
   *
   *  SMLNUM  (input) DOUBLE PRECISION
   *          A machine-dependent value close to the underflow threshold.
   *
   *  BIGNUM  (input) DOUBLE PRECISION
   *          A machine-dependent value close to the overflow threshold.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          = 1:  inverse iteration did not converge; VR is set to the
   *                last iterate, and so is VI if WI.ne.0.0.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param rightv
   * @param noinit
   * @param n
   * @param h
   * @param ldh
   * @param wr
   * @param wi
   * @param vr
   * @param vi
   * @param b
   * @param ldb
   * @param work
   * @param eps3
   * @param smlnum
   * @param bignum
   * @param info
   * 
   */
  abstract public void dlaein(boolean rightv, boolean noinit, int n, double[] h, int ldh, double wr, double wi, double[] vr, double[] vi, double[] b, int ldb, double[] work, double eps3, double smlnum, double bignum, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAEIN uses inverse iteration to find a right or left eigenvector
   *  corresponding to the eigenvalue (WR,WI) of a real upper Hessenberg
   *  matrix H.
   *
   *  Arguments
   *  =========
   *
   *  RIGHTV   (input) LOGICAL
   *          = .TRUE. : compute right eigenvector;
   *          = .FALSE.: compute left eigenvector.
   *
   *  NOINIT   (input) LOGICAL
   *          = .TRUE. : no initial vector supplied in (VR,VI).
   *          = .FALSE.: initial vector supplied in (VR,VI).
   *
   *  N       (input) INTEGER
   *          The order of the matrix H.  N >= 0.
   *
   *  H       (input) DOUBLE PRECISION array, dimension (LDH,N)
   *          The upper Hessenberg matrix H.
   *
   *  LDH     (input) INTEGER
   *          The leading dimension of the array H.  LDH >= max(1,N).
   *
   *  WR      (input) DOUBLE PRECISION
   *  WI      (input) DOUBLE PRECISION
   *          The real and imaginary parts of the eigenvalue of H whose
   *          corresponding right or left eigenvector is to be computed.
   *
   *  VR      (input/output) DOUBLE PRECISION array, dimension (N)
   *  VI      (input/output) DOUBLE PRECISION array, dimension (N)
   *          On entry, if NOINIT = .FALSE. and WI = 0.0, VR must contain
   *          a real starting vector for inverse iteration using the real
   *          eigenvalue WR; if NOINIT = .FALSE. and WI.ne.0.0, VR and VI
   *          must contain the real and imaginary parts of a complex
   *          starting vector for inverse iteration using the complex
   *          eigenvalue (WR,WI); otherwise VR and VI need not be set.
   *          On exit, if WI = 0.0 (real eigenvalue), VR contains the
   *          computed real eigenvector; if WI.ne.0.0 (complex eigenvalue),
   *          VR and VI contain the real and imaginary parts of the
   *          computed complex eigenvector. The eigenvector is normalized
   *          so that the component of largest magnitude has magnitude 1;
   *          here the magnitude of a complex number (x,y) is taken to be
   *          |x| + |y|.
   *          VI is not referenced if WI = 0.0.
   *
   *  B       (workspace) DOUBLE PRECISION array, dimension (LDB,N)
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= N+1.
   *
   *  WORK   (workspace) DOUBLE PRECISION array, dimension (N)
   *
   *  EPS3    (input) DOUBLE PRECISION
   *          A small machine-dependent value which is used to perturb
   *          close eigenvalues, and to replace zero pivots.
   *
   *  SMLNUM  (input) DOUBLE PRECISION
   *          A machine-dependent value close to the underflow threshold.
   *
   *  BIGNUM  (input) DOUBLE PRECISION
   *          A machine-dependent value close to the overflow threshold.
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          = 1:  inverse iteration did not converge; VR is set to the
   *                last iterate, and so is VI if WI.ne.0.0.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param rightv
   * @param noinit
   * @param n
   * @param h
   * @param _h_offset
   * @param ldh
   * @param wr
   * @param wi
   * @param vr
   * @param _vr_offset
   * @param vi
   * @param _vi_offset
   * @param b
   * @param _b_offset
   * @param ldb
   * @param work
   * @param _work_offset
   * @param eps3
   * @param smlnum
   * @param bignum
   * @param info
   * 
   */
  abstract public void dlaein(boolean rightv, boolean noinit, int n, double[] h, int _h_offset, int ldh, double wr, double wi, double[] vr, int _vr_offset, double[] vi, int _vi_offset, double[] b, int _b_offset, int ldb, double[] work, int _work_offset, double eps3, double smlnum, double bignum, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAEV2 computes the eigendecomposition of a 2-by-2 symmetric matrix
   *     [  A   B  ]
   *     [  B   C  ].
   *  On return, RT1 is the eigenvalue of larger absolute value, RT2 is the
   *  eigenvalue of smaller absolute value, and (CS1,SN1) is the unit right
   *  eigenvector for RT1, giving the decomposition
   *
   *     [ CS1  SN1 ] [  A   B  ] [ CS1 -SN1 ]  =  [ RT1  0  ]
   *     [-SN1  CS1 ] [  B   C  ] [ SN1  CS1 ]     [  0  RT2 ].
   *
   *  Arguments
   *  =========
   *
   *  A       (input) DOUBLE PRECISION
   *          The (1,1) element of the 2-by-2 matrix.
   *
   *  B       (input) DOUBLE PRECISION
   *          The (1,2) element and the conjugate of the (2,1) element of
   *          the 2-by-2 matrix.
   *
   *  C       (input) DOUBLE PRECISION
   *          The (2,2) element of the 2-by-2 matrix.
   *
   *  RT1     (output) DOUBLE PRECISION
   *          The eigenvalue of larger absolute value.
   *
   *  RT2     (output) DOUBLE PRECISION
   *          The eigenvalue of smaller absolute value.
   *
   *  CS1     (output) DOUBLE PRECISION
   *  SN1     (output) DOUBLE PRECISION
   *          The vector (CS1, SN1) is a unit right eigenvector for RT1.
   *
   *  Further Details
   *  ===============
   *
   *  RT1 is accurate to a few ulps barring over/underflow.
   *
   *  RT2 may be inaccurate if there is massive cancellation in the
   *  determinant A*C-B*B; higher precision or correctly rounded or
   *  correctly truncated arithmetic would be needed to compute RT2
   *  accurately in all cases.
   *
   *  CS1 and SN1 are accurate to a few ulps barring over/underflow.
   *
   *  Overflow is possible only if RT1 is within a factor of 5 of overflow.
   *  Underflow is harmless if the input data is 0 or exceeds
   *     underflow_threshold / macheps.
   *
   * =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param a
   * @param b
   * @param c
   * @param rt1
   * @param rt2
   * @param cs1
   * @param sn1
   * 
   */
  abstract public void dlaev2(double a, double b, double c, org.netlib.util.doubleW rt1, org.netlib.util.doubleW rt2, org.netlib.util.doubleW cs1, org.netlib.util.doubleW sn1);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAEXC swaps adjacent diagonal blocks T11 and T22 of order 1 or 2 in
   *  an upper quasi-triangular matrix T by an orthogonal similarity
   *  transformation.
   *
   *  T must be in Schur canonical form, that is, block upper triangular
   *  with 1-by-1 and 2-by-2 diagonal blocks; each 2-by-2 diagonal block
   *  has its diagonal elemnts equal and its off-diagonal elements of
   *  opposite sign.
   *
   *  Arguments
   *  =========
   *
   *  WANTQ   (input) LOGICAL
   *          = .TRUE. : accumulate the transformation in the matrix Q;
   *          = .FALSE.: do not accumulate the transformation.
   *
   *  N       (input) INTEGER
   *          The order of the matrix T. N >= 0.
   *
   *  T       (input/output) DOUBLE PRECISION array, dimension (LDT,N)
   *          On entry, the upper quasi-triangular matrix T, in Schur
   *          canonical form.
   *          On exit, the updated matrix T, again in Schur canonical form.
   *
   *  LDT     (input)  INTEGER
   *          The leading dimension of the array T. LDT >= max(1,N).
   *
   *  Q       (input/output) DOUBLE PRECISION array, dimension (LDQ,N)
   *          On entry, if WANTQ is .TRUE., the orthogonal matrix Q.
   *          On exit, if WANTQ is .TRUE., the updated matrix Q.
   *          If WANTQ is .FALSE., Q is not referenced.
   *
   *  LDQ     (input) INTEGER
   *          The leading dimension of the array Q.
   *          LDQ >= 1; and if WANTQ is .TRUE., LDQ >= N.
   *
   *  J1      (input) INTEGER
   *          The index of the first row of the first block T11.
   *
   *  N1      (input) INTEGER
   *          The order of the first block T11. N1 = 0, 1 or 2.
   *
   *  N2      (input) INTEGER
   *          The order of the second block T22. N2 = 0, 1 or 2.
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          = 1: the transformed matrix T would be too far from Schur
   *               form; the blocks are not swapped and T and Q are
   *               unchanged.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param wantq
   * @param n
   * @param t
   * @param ldt
   * @param q
   * @param ldq
   * @param j1
   * @param n1
   * @param n2
   * @param work
   * @param info
   * 
   */
  abstract public void dlaexc(boolean wantq, int n, double[] t, int ldt, double[] q, int ldq, int j1, int n1, int n2, double[] work, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAEXC swaps adjacent diagonal blocks T11 and T22 of order 1 or 2 in
   *  an upper quasi-triangular matrix T by an orthogonal similarity
   *  transformation.
   *
   *  T must be in Schur canonical form, that is, block upper triangular
   *  with 1-by-1 and 2-by-2 diagonal blocks; each 2-by-2 diagonal block
   *  has its diagonal elemnts equal and its off-diagonal elements of
   *  opposite sign.
   *
   *  Arguments
   *  =========
   *
   *  WANTQ   (input) LOGICAL
   *          = .TRUE. : accumulate the transformation in the matrix Q;
   *          = .FALSE.: do not accumulate the transformation.
   *
   *  N       (input) INTEGER
   *          The order of the matrix T. N >= 0.
   *
   *  T       (input/output) DOUBLE PRECISION array, dimension (LDT,N)
   *          On entry, the upper quasi-triangular matrix T, in Schur
   *          canonical form.
   *          On exit, the updated matrix T, again in Schur canonical form.
   *
   *  LDT     (input)  INTEGER
   *          The leading dimension of the array T. LDT >= max(1,N).
   *
   *  Q       (input/output) DOUBLE PRECISION array, dimension (LDQ,N)
   *          On entry, if WANTQ is .TRUE., the orthogonal matrix Q.
   *          On exit, if WANTQ is .TRUE., the updated matrix Q.
   *          If WANTQ is .FALSE., Q is not referenced.
   *
   *  LDQ     (input) INTEGER
   *          The leading dimension of the array Q.
   *          LDQ >= 1; and if WANTQ is .TRUE., LDQ >= N.
   *
   *  J1      (input) INTEGER
   *          The index of the first row of the first block T11.
   *
   *  N1      (input) INTEGER
   *          The order of the first block T11. N1 = 0, 1 or 2.
   *
   *  N2      (input) INTEGER
   *          The order of the second block T22. N2 = 0, 1 or 2.
   *
   *  WORK    (workspace) DOUBLE PRECISION array, dimension (N)
   *
   *  INFO    (output) INTEGER
   *          = 0: successful exit
   *          = 1: the transformed matrix T would be too far from Schur
   *               form; the blocks are not swapped and T and Q are
   *               unchanged.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param wantq
   * @param n
   * @param t
   * @param _t_offset
   * @param ldt
   * @param q
   * @param _q_offset
   * @param ldq
   * @param j1
   * @param n1
   * @param n2
   * @param work
   * @param _work_offset
   * @param info
   * 
   */
  abstract public void dlaexc(boolean wantq, int n, double[] t, int _t_offset, int ldt, double[] q, int _q_offset, int ldq, int j1, int n1, int n2, double[] work, int _work_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAG2 computes the eigenvalues of a 2 x 2 generalized eigenvalue
   *  problem  A - w B, with scaling as necessary to avoid over-/underflow.
   *
   *  The scaling factor "s" results in a modified eigenvalue equation
   *
   *      s A - w B
   *
   *  where  s  is a non-negative scaling factor chosen so that  w,  w B,
   *  and  s A  do not overflow and, if possible, do not underflow, either.
   *
   *  Arguments
   *  =========
   *
   *  A       (input) DOUBLE PRECISION array, dimension (LDA, 2)
   *          On entry, the 2 x 2 matrix A.  It is assumed that its 1-norm
   *          is less than 1/SAFMIN.  Entries less than
   *          sqrt(SAFMIN)*norm(A) are subject to being treated as zero.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= 2.
   *
   *  B       (input) DOUBLE PRECISION array, dimension (LDB, 2)
   *          On entry, the 2 x 2 upper triangular matrix B.  It is
   *          assumed that the one-norm of B is less than 1/SAFMIN.  The
   *          diagonals should be at least sqrt(SAFMIN) times the largest
   *          element of B (in absolute value); if a diagonal is smaller
   *          than that, then  +/- sqrt(SAFMIN) will be used instead of
   *          that diagonal.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= 2.
   *
   *  SAFMIN  (input) DOUBLE PRECISION
   *          The smallest positive number s.t. 1/SAFMIN does not
   *          overflow.  (This should always be DLAMCH('S') -- it is an
   *          argument in order to avoid having to call DLAMCH frequently.)
   *
   *  SCALE1  (output) DOUBLE PRECISION
   *          A scaling factor used to avoid over-/underflow in the
   *          eigenvalue equation which defines the first eigenvalue.  If
   *          the eigenvalues are complex, then the eigenvalues are
   *          ( WR1  +/-  WI i ) / SCALE1  (which may lie outside the
   *          exponent range of the machine), SCALE1=SCALE2, and SCALE1
   *          will always be positive.  If the eigenvalues are real, then
   *          the first (real) eigenvalue is  WR1 / SCALE1 , but this may
   *          overflow or underflow, and in fact, SCALE1 may be zero or
   *          less than the underflow threshhold if the exact eigenvalue
   *          is sufficiently large.
   *
   *  SCALE2  (output) DOUBLE PRECISION
   *          A scaling factor used to avoid over-/underflow in the
   *          eigenvalue equation which defines the second eigenvalue.  If
   *          the eigenvalues are complex, then SCALE2=SCALE1.  If the
   *          eigenvalues are real, then the second (real) eigenvalue is
   *          WR2 / SCALE2 , but this may overflow or underflow, and in
   *          fact, SCALE2 may be zero or less than the underflow
   *          threshhold if the exact eigenvalue is sufficiently large.
   *
   *  WR1     (output) DOUBLE PRECISION
   *          If the eigenvalue is real, then WR1 is SCALE1 times the
   *          eigenvalue closest to the (2,2) element of A B**(-1).  If the
   *          eigenvalue is complex, then WR1=WR2 is SCALE1 times the real
   *          part of the eigenvalues.
   *
   *  WR2     (output) DOUBLE PRECISION
   *          If the eigenvalue is real, then WR2 is SCALE2 times the
   *          other eigenvalue.  If the eigenvalue is complex, then
   *          WR1=WR2 is SCALE1 times the real part of the eigenvalues.
   *
   *  WI      (output) DOUBLE PRECISION
   *          If the eigenvalue is real, then WI is zero.  If the
   *          eigenvalue is complex, then WI is SCALE1 times the imaginary
   *          part of the eigenvalues.  WI will always be non-negative.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param safmin
   * @param scale1
   * @param scale2
   * @param wr1
   * @param wr2
   * @param wi
   * 
   */
  abstract public void dlag2(double[] a, int lda, double[] b, int ldb, double safmin, org.netlib.util.doubleW scale1, org.netlib.util.doubleW scale2, org.netlib.util.doubleW wr1, org.netlib.util.doubleW wr2, org.netlib.util.doubleW wi);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAG2 computes the eigenvalues of a 2 x 2 generalized eigenvalue
   *  problem  A - w B, with scaling as necessary to avoid over-/underflow.
   *
   *  The scaling factor "s" results in a modified eigenvalue equation
   *
   *      s A - w B
   *
   *  where  s  is a non-negative scaling factor chosen so that  w,  w B,
   *  and  s A  do not overflow and, if possible, do not underflow, either.
   *
   *  Arguments
   *  =========
   *
   *  A       (input) DOUBLE PRECISION array, dimension (LDA, 2)
   *          On entry, the 2 x 2 matrix A.  It is assumed that its 1-norm
   *          is less than 1/SAFMIN.  Entries less than
   *          sqrt(SAFMIN)*norm(A) are subject to being treated as zero.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= 2.
   *
   *  B       (input) DOUBLE PRECISION array, dimension (LDB, 2)
   *          On entry, the 2 x 2 upper triangular matrix B.  It is
   *          assumed that the one-norm of B is less than 1/SAFMIN.  The
   *          diagonals should be at least sqrt(SAFMIN) times the largest
   *          element of B (in absolute value); if a diagonal is smaller
   *          than that, then  +/- sqrt(SAFMIN) will be used instead of
   *          that diagonal.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= 2.
   *
   *  SAFMIN  (input) DOUBLE PRECISION
   *          The smallest positive number s.t. 1/SAFMIN does not
   *          overflow.  (This should always be DLAMCH('S') -- it is an
   *          argument in order to avoid having to call DLAMCH frequently.)
   *
   *  SCALE1  (output) DOUBLE PRECISION
   *          A scaling factor used to avoid over-/underflow in the
   *          eigenvalue equation which defines the first eigenvalue.  If
   *          the eigenvalues are complex, then the eigenvalues are
   *          ( WR1  +/-  WI i ) / SCALE1  (which may lie outside the
   *          exponent range of the machine), SCALE1=SCALE2, and SCALE1
   *          will always be positive.  If the eigenvalues are real, then
   *          the first (real) eigenvalue is  WR1 / SCALE1 , but this may
   *          overflow or underflow, and in fact, SCALE1 may be zero or
   *          less than the underflow threshhold if the exact eigenvalue
   *          is sufficiently large.
   *
   *  SCALE2  (output) DOUBLE PRECISION
   *          A scaling factor used to avoid over-/underflow in the
   *          eigenvalue equation which defines the second eigenvalue.  If
   *          the eigenvalues are complex, then SCALE2=SCALE1.  If the
   *          eigenvalues are real, then the second (real) eigenvalue is
   *          WR2 / SCALE2 , but this may overflow or underflow, and in
   *          fact, SCALE2 may be zero or less than the underflow
   *          threshhold if the exact eigenvalue is sufficiently large.
   *
   *  WR1     (output) DOUBLE PRECISION
   *          If the eigenvalue is real, then WR1 is SCALE1 times the
   *          eigenvalue closest to the (2,2) element of A B**(-1).  If the
   *          eigenvalue is complex, then WR1=WR2 is SCALE1 times the real
   *          part of the eigenvalues.
   *
   *  WR2     (output) DOUBLE PRECISION
   *          If the eigenvalue is real, then WR2 is SCALE2 times the
   *          other eigenvalue.  If the eigenvalue is complex, then
   *          WR1=WR2 is SCALE1 times the real part of the eigenvalues.
   *
   *  WI      (output) DOUBLE PRECISION
   *          If the eigenvalue is real, then WI is zero.  If the
   *          eigenvalue is complex, then WI is SCALE1 times the imaginary
   *          part of the eigenvalues.  WI will always be non-negative.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param safmin
   * @param scale1
   * @param scale2
   * @param wr1
   * @param wr2
   * @param wi
   * 
   */
  abstract public void dlag2(double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double safmin, org.netlib.util.doubleW scale1, org.netlib.util.doubleW scale2, org.netlib.util.doubleW wr1, org.netlib.util.doubleW wr2, org.netlib.util.doubleW wi);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAG2S converts a DOUBLE PRECISION matrix, SA, to a SINGLE
   *  PRECISION matrix, A.
   *
   *  RMAX is the overflow for the SINGLE PRECISION arithmetic
   *  DLAG2S checks that all the entries of A are between -RMAX and
   *  RMAX. If not the convertion is aborted and a flag is raised.
   *
   *  This is a helper routine so there is no argument checking.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of lines of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N coefficient matrix A.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  SA      (output) REAL array, dimension (LDSA,N)
   *          On exit, if INFO=0, the M-by-N coefficient matrix SA.
   *
   *  LDSA    (input) INTEGER
   *          The leading dimension of the array SA.  LDSA >= max(1,M).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          > 0:  if INFO = k, the (i,j) entry of the matrix A has
   *                overflowed when moving from DOUBLE PRECISION to SINGLE
   *                k is given by k = (i-1)*LDA+j
   *
   *  =========
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param sa
   * @param ldsa
   * @param info
   * 
   */
  abstract public void dlag2s(int m, int n, double[] a, int lda, float[] sa, int ldsa, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAG2S converts a DOUBLE PRECISION matrix, SA, to a SINGLE
   *  PRECISION matrix, A.
   *
   *  RMAX is the overflow for the SINGLE PRECISION arithmetic
   *  DLAG2S checks that all the entries of A are between -RMAX and
   *  RMAX. If not the convertion is aborted and a flag is raised.
   *
   *  This is a helper routine so there is no argument checking.
   *
   *  Arguments
   *  =========
   *
   *  M       (input) INTEGER
   *          The number of lines of the matrix A.  M >= 0.
   *
   *  N       (input) INTEGER
   *          The number of columns of the matrix A.  N >= 0.
   *
   *  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
   *          On entry, the M-by-N coefficient matrix A.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,M).
   *
   *  SA      (output) REAL array, dimension (LDSA,N)
   *          On exit, if INFO=0, the M-by-N coefficient matrix SA.
   *
   *  LDSA    (input) INTEGER
   *          The leading dimension of the array SA.  LDSA >= max(1,M).
   *
   *  INFO    (output) INTEGER
   *          = 0:  successful exit
   *          > 0:  if INFO = k, the (i,j) entry of the matrix A has
   *                overflowed when moving from DOUBLE PRECISION to SINGLE
   *                k is given by k = (i-1)*LDA+j
   *
   *  =========
   *
   *     .. Local Scalars ..
   * </code></pre>
   *
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param sa
   * @param _sa_offset
   * @param ldsa
   * @param info
   * 
   */
  abstract public void dlag2s(int m, int n, double[] a, int _a_offset, int lda, float[] sa, int _sa_offset, int ldsa, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAGS2 computes 2-by-2 orthogonal matrices U, V and Q, such
   *  that if ( UPPER ) then
   *
   *            U'*A*Q = U'*( A1 A2 )*Q = ( x  0  )
   *                        ( 0  A3 )     ( x  x  )
   *  and
   *            V'*B*Q = V'*( B1 B2 )*Q = ( x  0  )
   *                        ( 0  B3 )     ( x  x  )
   *
   *  or if ( .NOT.UPPER ) then
   *
   *            U'*A*Q = U'*( A1 0  )*Q = ( x  x  )
   *                        ( A2 A3 )     ( 0  x  )
   *  and
   *            V'*B*Q = V'*( B1 0  )*Q = ( x  x  )
   *                        ( B2 B3 )     ( 0  x  )
   *
   *  The rows of the transformed A and B are parallel, where
   *
   *    U = (  CSU  SNU ), V = (  CSV SNV ), Q = (  CSQ   SNQ )
   *        ( -SNU  CSU )      ( -SNV CSV )      ( -SNQ   CSQ )
   *
   *  Z' denotes the transpose of Z.
   *
   *
   *  Arguments
   *  =========
   *
   *  UPPER   (input) LOGICAL
   *          = .TRUE.: the input matrices A and B are upper triangular.
   *          = .FALSE.: the input matrices A and B are lower triangular.
   *
   *  A1      (input) DOUBLE PRECISION
   *  A2      (input) DOUBLE PRECISION
   *  A3      (input) DOUBLE PRECISION
   *          On entry, A1, A2 and A3 are elements of the input 2-by-2
   *          upper (lower) triangular matrix A.
   *
   *  B1      (input) DOUBLE PRECISION
   *  B2      (input) DOUBLE PRECISION
   *  B3      (input) DOUBLE PRECISION
   *          On entry, B1, B2 and B3 are elements of the input 2-by-2
   *          upper (lower) triangular matrix B.
   *
   *  CSU     (output) DOUBLE PRECISION
   *  SNU     (output) DOUBLE PRECISION
   *          The desired orthogonal matrix U.
   *
   *  CSV     (output) DOUBLE PRECISION
   *  SNV     (output) DOUBLE PRECISION
   *          The desired orthogonal matrix V.
   *
   *  CSQ     (output) DOUBLE PRECISION
   *  SNQ     (output) DOUBLE PRECISION
   *          The desired orthogonal matrix Q.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param upper
   * @param a1
   * @param a2
   * @param a3
   * @param b1
   * @param b2
   * @param b3
   * @param csu
   * @param snu
   * @param csv
   * @param snv
   * @param csq
   * @param snq
   * 
   */
  abstract public void dlags2(boolean upper, double a1, double a2, double a3, double b1, double b2, double b3, org.netlib.util.doubleW csu, org.netlib.util.doubleW snu, org.netlib.util.doubleW csv, org.netlib.util.doubleW snv, org.netlib.util.doubleW csq, org.netlib.util.doubleW snq);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAGTF factorizes the matrix (T - lambda*I), where T is an n by n
   *  tridiagonal matrix and lambda is a scalar, as
   *
   *     T - lambda*I = PLU,
   *
   *  where P is a permutation matrix, L is a unit lower tridiagonal matrix
   *  with at most one non-zero sub-diagonal elements per column and U is
   *  an upper triangular matrix with at most two non-zero super-diagonal
   *  elements per column.
   *
   *  The factorization is obtained by Gaussian elimination with partial
   *  pivoting and implicit row scaling.
   *
   *  The parameter LAMBDA is included in the routine so that DLAGTF may
   *  be used, in conjunction with DLAGTS, to obtain eigenvectors of T by
   *  inverse iteration.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The order of the matrix T.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (N)
   *          On entry, A must contain the diagonal elements of T.
   *
   *          On exit, A is overwritten by the n diagonal elements of the
   *          upper triangular matrix U of the factorization of T.
   *
   *  LAMBDA  (input) DOUBLE PRECISION
   *          On entry, the scalar lambda.
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (N-1)
   *          On entry, B must contain the (n-1) super-diagonal elements of
   *          T.
   *
   *          On exit, B is overwritten by the (n-1) super-diagonal
   *          elements of the matrix U of the factorization of T.
   *
   *  C       (input/output) DOUBLE PRECISION array, dimension (N-1)
   *          On entry, C must contain the (n-1) sub-diagonal elements of
   *          T.
   *
   *          On exit, C is overwritten by the (n-1) sub-diagonal elements
   *          of the matrix L of the factorization of T.
   *
   *  TOL     (input) DOUBLE PRECISION
   *          On entry, a relative tolerance used to indicate whether or
   *          not the matrix (T - lambda*I) is nearly singular. TOL should
   *          normally be chose as approximately the largest relative error
   *          in the elements of T. For example, if the elements of T are
   *          correct to about 4 significant figures, then TOL should be
   *          set to about 5*10**(-4). If TOL is supplied as less than eps,
   *          where eps is the relative machine precision, then the value
   *          eps is used in place of TOL.
   *
   *  D       (output) DOUBLE PRECISION array, dimension (N-2)
   *          On exit, D is overwritten by the (n-2) second super-diagonal
   *          elements of the matrix U of the factorization of T.
   *
   *  IN      (output) INTEGER array, dimension (N)
   *          On exit, IN contains details of the permutation matrix P. If
   *          an interchange occurred at the kth step of the elimination,
   *          then IN(k) = 1, otherwise IN(k) = 0. The element IN(n)
   *          returns the smallest positive integer j such that
   *
   *             abs( u(j,j) ).le. norm( (T - lambda*I)(j) )*TOL,
   *
   *          where norm( A(j) ) denotes the sum of the absolute values of
   *          the jth row of the matrix A. If no such j exists then IN(n)
   *          is returned as zero. If IN(n) is returned as positive, then a
   *          diagonal element of U is small, indicating that
   *          (T - lambda*I) is singular or nearly singular,
   *
   *  INFO    (output) INTEGER
   *          = 0   : successful exit
   *          .lt. 0: if INFO = -k, the kth argument had an illegal value
   *
   * =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param a
   * @param lambda
   * @param b
   * @param c
   * @param tol
   * @param d
   * @param in
   * @param info
   * 
   */
  abstract public void dlagtf(int n, double[] a, double lambda, double[] b, double[] c, double tol, double[] d, int[] in, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAGTF factorizes the matrix (T - lambda*I), where T is an n by n
   *  tridiagonal matrix and lambda is a scalar, as
   *
   *     T - lambda*I = PLU,
   *
   *  where P is a permutation matrix, L is a unit lower tridiagonal matrix
   *  with at most one non-zero sub-diagonal elements per column and U is
   *  an upper triangular matrix with at most two non-zero super-diagonal
   *  elements per column.
   *
   *  The factorization is obtained by Gaussian elimination with partial
   *  pivoting and implicit row scaling.
   *
   *  The parameter LAMBDA is included in the routine so that DLAGTF may
   *  be used, in conjunction with DLAGTS, to obtain eigenvectors of T by
   *  inverse iteration.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The order of the matrix T.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (N)
   *          On entry, A must contain the diagonal elements of T.
   *
   *          On exit, A is overwritten by the n diagonal elements of the
   *          upper triangular matrix U of the factorization of T.
   *
   *  LAMBDA  (input) DOUBLE PRECISION
   *          On entry, the scalar lambda.
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (N-1)
   *          On entry, B must contain the (n-1) super-diagonal elements of
   *          T.
   *
   *          On exit, B is overwritten by the (n-1) super-diagonal
   *          elements of the matrix U of the factorization of T.
   *
   *  C       (input/output) DOUBLE PRECISION array, dimension (N-1)
   *          On entry, C must contain the (n-1) sub-diagonal elements of
   *          T.
   *
   *          On exit, C is overwritten by the (n-1) sub-diagonal elements
   *          of the matrix L of the factorization of T.
   *
   *  TOL     (input) DOUBLE PRECISION
   *          On entry, a relative tolerance used to indicate whether or
   *          not the matrix (T - lambda*I) is nearly singular. TOL should
   *          normally be chose as approximately the largest relative error
   *          in the elements of T. For example, if the elements of T are
   *          correct to about 4 significant figures, then TOL should be
   *          set to about 5*10**(-4). If TOL is supplied as less than eps,
   *          where eps is the relative machine precision, then the value
   *          eps is used in place of TOL.
   *
   *  D       (output) DOUBLE PRECISION array, dimension (N-2)
   *          On exit, D is overwritten by the (n-2) second super-diagonal
   *          elements of the matrix U of the factorization of T.
   *
   *  IN      (output) INTEGER array, dimension (N)
   *          On exit, IN contains details of the permutation matrix P. If
   *          an interchange occurred at the kth step of the elimination,
   *          then IN(k) = 1, otherwise IN(k) = 0. The element IN(n)
   *          returns the smallest positive integer j such that
   *
   *             abs( u(j,j) ).le. norm( (T - lambda*I)(j) )*TOL,
   *
   *          where norm( A(j) ) denotes the sum of the absolute values of
   *          the jth row of the matrix A. If no such j exists then IN(n)
   *          is returned as zero. If IN(n) is returned as positive, then a
   *          diagonal element of U is small, indicating that
   *          (T - lambda*I) is singular or nearly singular,
   *
   *  INFO    (output) INTEGER
   *          = 0   : successful exit
   *          .lt. 0: if INFO = -k, the kth argument had an illegal value
   *
   * =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param a
   * @param _a_offset
   * @param lambda
   * @param b
   * @param _b_offset
   * @param c
   * @param _c_offset
   * @param tol
   * @param d
   * @param _d_offset
   * @param in
   * @param _in_offset
   * @param info
   * 
   */
  abstract public void dlagtf(int n, double[] a, int _a_offset, double lambda, double[] b, int _b_offset, double[] c, int _c_offset, double tol, double[] d, int _d_offset, int[] in, int _in_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAGTM performs a matrix-vector product of the form
   *
   *     B := alpha * A * X + beta * B
   *
   *  where A is a tridiagonal matrix of order N, B and X are N by NRHS
   *  matrices, and alpha and beta are real scalars, each of which may be
   *  0., 1., or -1.
   *
   *  Arguments
   *  =========
   *
   *  TRANS   (input) CHARACTER*1
   *          Specifies the operation applied to A.
   *          = 'N':  No transpose, B := alpha * A * X + beta * B
   *          = 'T':  Transpose,    B := alpha * A'* X + beta * B
   *          = 'C':  Conjugate transpose = Transpose
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrices X and B.
   *
   *  ALPHA   (input) DOUBLE PRECISION
   *          The scalar alpha.  ALPHA must be 0., 1., or -1.; otherwise,
   *          it is assumed to be 0.
   *
   *  DL      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) sub-diagonal elements of T.
   *
   *  D       (input) DOUBLE PRECISION array, dimension (N)
   *          The diagonal elements of T.
   *
   *  DU      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) super-diagonal elements of T.
   *
   *  X       (input) DOUBLE PRECISION array, dimension (LDX,NRHS)
   *          The N by NRHS matrix X.
   *  LDX     (input) INTEGER
   *          The leading dimension of the array X.  LDX >= max(N,1).
   *
   *  BETA    (input) DOUBLE PRECISION
   *          The scalar beta.  BETA must be 0., 1., or -1.; otherwise,
   *          it is assumed to be 1.
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the N by NRHS matrix B.
   *          On exit, B is overwritten by the matrix expression
   *          B := alpha * A * X + beta * B.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(N,1).
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param n
   * @param nrhs
   * @param alpha
   * @param dl
   * @param d
   * @param du
   * @param x
   * @param ldx
   * @param beta
   * @param b
   * @param ldb
   * 
   */
  abstract public void dlagtm(java.lang.String trans, int n, int nrhs, double alpha, double[] dl, double[] d, double[] du, double[] x, int ldx, double beta, double[] b, int ldb);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAGTM performs a matrix-vector product of the form
   *
   *     B := alpha * A * X + beta * B
   *
   *  where A is a tridiagonal matrix of order N, B and X are N by NRHS
   *  matrices, and alpha and beta are real scalars, each of which may be
   *  0., 1., or -1.
   *
   *  Arguments
   *  =========
   *
   *  TRANS   (input) CHARACTER*1
   *          Specifies the operation applied to A.
   *          = 'N':  No transpose, B := alpha * A * X + beta * B
   *          = 'T':  Transpose,    B := alpha * A'* X + beta * B
   *          = 'C':  Conjugate transpose = Transpose
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.  N >= 0.
   *
   *  NRHS    (input) INTEGER
   *          The number of right hand sides, i.e., the number of columns
   *          of the matrices X and B.
   *
   *  ALPHA   (input) DOUBLE PRECISION
   *          The scalar alpha.  ALPHA must be 0., 1., or -1.; otherwise,
   *          it is assumed to be 0.
   *
   *  DL      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) sub-diagonal elements of T.
   *
   *  D       (input) DOUBLE PRECISION array, dimension (N)
   *          The diagonal elements of T.
   *
   *  DU      (input) DOUBLE PRECISION array, dimension (N-1)
   *          The (n-1) super-diagonal elements of T.
   *
   *  X       (input) DOUBLE PRECISION array, dimension (LDX,NRHS)
   *          The N by NRHS matrix X.
   *  LDX     (input) INTEGER
   *          The leading dimension of the array X.  LDX >= max(N,1).
   *
   *  BETA    (input) DOUBLE PRECISION
   *          The scalar beta.  BETA must be 0., 1., or -1.; otherwise,
   *          it is assumed to be 1.
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
   *          On entry, the N by NRHS matrix B.
   *          On exit, B is overwritten by the matrix expression
   *          B := alpha * A * X + beta * B.
   *
   *  LDB     (input) INTEGER
   *          The leading dimension of the array B.  LDB >= max(N,1).
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param trans
   * @param n
   * @param nrhs
   * @param alpha
   * @param dl
   * @param _dl_offset
   * @param d
   * @param _d_offset
   * @param du
   * @param _du_offset
   * @param x
   * @param _x_offset
   * @param ldx
   * @param beta
   * @param b
   * @param _b_offset
   * @param ldb
   * 
   */
  abstract public void dlagtm(java.lang.String trans, int n, int nrhs, double alpha, double[] dl, int _dl_offset, double[] d, int _d_offset, double[] du, int _du_offset, double[] x, int _x_offset, int ldx, double beta, double[] b, int _b_offset, int ldb);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAGTS may be used to solve one of the systems of equations
   *
   *     (T - lambda*I)*x = y   or   (T - lambda*I)'*x = y,
   *
   *  where T is an n by n tridiagonal matrix, for x, following the
   *  factorization of (T - lambda*I) as
   *
   *     (T - lambda*I) = P*L*U ,
   *
   *  by routine DLAGTF. The choice of equation to be solved is
   *  controlled by the argument JOB, and in each case there is an option
   *  to perturb zero or very small diagonal elements of U, this option
   *  being intended for use in applications such as inverse iteration.
   *
   *  Arguments
   *  =========
   *
   *  JOB     (input) INTEGER
   *          Specifies the job to be performed by DLAGTS as follows:
   *          =  1: The equations  (T - lambda*I)x = y  are to be solved,
   *                but diagonal elements of U are not to be perturbed.
   *          = -1: The equations  (T - lambda*I)x = y  are to be solved
   *                and, if overflow would otherwise occur, the diagonal
   *                elements of U are to be perturbed. See argument TOL
   *                below.
   *          =  2: The equations  (T - lambda*I)'x = y  are to be solved,
   *                but diagonal elements of U are not to be perturbed.
   *          = -2: The equations  (T - lambda*I)'x = y  are to be solved
   *                and, if overflow would otherwise occur, the diagonal
   *                elements of U are to be perturbed. See argument TOL
   *                below.
   *
   *  N       (input) INTEGER
   *          The order of the matrix T.
   *
   *  A       (input) DOUBLE PRECISION array, dimension (N)
   *          On entry, A must contain the diagonal elements of U as
   *          returned from DLAGTF.
   *
   *  B       (input) DOUBLE PRECISION array, dimension (N-1)
   *          On entry, B must contain the first super-diagonal elements of
   *          U as returned from DLAGTF.
   *
   *  C       (input) DOUBLE PRECISION array, dimension (N-1)
   *          On entry, C must contain the sub-diagonal elements of L as
   *          returned from DLAGTF.
   *
   *  D       (input) DOUBLE PRECISION array, dimension (N-2)
   *          On entry, D must contain the second super-diagonal elements
   *          of U as returned from DLAGTF.
   *
   *  IN      (input) INTEGER array, dimension (N)
   *          On entry, IN must contain details of the matrix P as returned
   *          from DLAGTF.
   *
   *  Y       (input/output) DOUBLE PRECISION array, dimension (N)
   *          On entry, the right hand side vector y.
   *          On exit, Y is overwritten by the solution vector x.
   *
   *  TOL     (input/output) DOUBLE PRECISION
   *          On entry, with  JOB .lt. 0, TOL should be the minimum
   *          perturbation to be made to very small diagonal elements of U.
   *          TOL should normally be chosen as about eps*norm(U), where eps
   *          is the relative machine precision, but if TOL is supplied as
   *          non-positive, then it is reset to eps*max( abs( u(i,j) ) ).
   *          If  JOB .gt. 0  then TOL is not referenced.
   *
   *          On exit, TOL is changed as described above, only if TOL is
   *          non-positive on entry. Otherwise TOL is unchanged.
   *
   *  INFO    (output) INTEGER
   *          = 0   : successful exit
   *          .lt. 0: if INFO = -i, the i-th argument had an illegal value
   *          .gt. 0: overflow would occur when computing the INFO(th)
   *                  element of the solution vector x. This can only occur
   *                  when JOB is supplied as positive and either means
   *                  that a diagonal element of U is very small, or that
   *                  the elements of the right-hand side vector y are very
   *                  large.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param job
   * @param n
   * @param a
   * @param b
   * @param c
   * @param d
   * @param in
   * @param y
   * @param tol
   * @param info
   * 
   */
  abstract public void dlagts(int job, int n, double[] a, double[] b, double[] c, double[] d, int[] in, double[] y, org.netlib.util.doubleW tol, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAGTS may be used to solve one of the systems of equations
   *
   *     (T - lambda*I)*x = y   or   (T - lambda*I)'*x = y,
   *
   *  where T is an n by n tridiagonal matrix, for x, following the
   *  factorization of (T - lambda*I) as
   *
   *     (T - lambda*I) = P*L*U ,
   *
   *  by routine DLAGTF. The choice of equation to be solved is
   *  controlled by the argument JOB, and in each case there is an option
   *  to perturb zero or very small diagonal elements of U, this option
   *  being intended for use in applications such as inverse iteration.
   *
   *  Arguments
   *  =========
   *
   *  JOB     (input) INTEGER
   *          Specifies the job to be performed by DLAGTS as follows:
   *          =  1: The equations  (T - lambda*I)x = y  are to be solved,
   *                but diagonal elements of U are not to be perturbed.
   *          = -1: The equations  (T - lambda*I)x = y  are to be solved
   *                and, if overflow would otherwise occur, the diagonal
   *                elements of U are to be perturbed. See argument TOL
   *                below.
   *          =  2: The equations  (T - lambda*I)'x = y  are to be solved,
   *                but diagonal elements of U are not to be perturbed.
   *          = -2: The equations  (T - lambda*I)'x = y  are to be solved
   *                and, if overflow would otherwise occur, the diagonal
   *                elements of U are to be perturbed. See argument TOL
   *                below.
   *
   *  N       (input) INTEGER
   *          The order of the matrix T.
   *
   *  A       (input) DOUBLE PRECISION array, dimension (N)
   *          On entry, A must contain the diagonal elements of U as
   *          returned from DLAGTF.
   *
   *  B       (input) DOUBLE PRECISION array, dimension (N-1)
   *          On entry, B must contain the first super-diagonal elements of
   *          U as returned from DLAGTF.
   *
   *  C       (input) DOUBLE PRECISION array, dimension (N-1)
   *          On entry, C must contain the sub-diagonal elements of L as
   *          returned from DLAGTF.
   *
   *  D       (input) DOUBLE PRECISION array, dimension (N-2)
   *          On entry, D must contain the second super-diagonal elements
   *          of U as returned from DLAGTF.
   *
   *  IN      (input) INTEGER array, dimension (N)
   *          On entry, IN must contain details of the matrix P as returned
   *          from DLAGTF.
   *
   *  Y       (input/output) DOUBLE PRECISION array, dimension (N)
   *          On entry, the right hand side vector y.
   *          On exit, Y is overwritten by the solution vector x.
   *
   *  TOL     (input/output) DOUBLE PRECISION
   *          On entry, with  JOB .lt. 0, TOL should be the minimum
   *          perturbation to be made to very small diagonal elements of U.
   *          TOL should normally be chosen as about eps*norm(U), where eps
   *          is the relative machine precision, but if TOL is supplied as
   *          non-positive, then it is reset to eps*max( abs( u(i,j) ) ).
   *          If  JOB .gt. 0  then TOL is not referenced.
   *
   *          On exit, TOL is changed as described above, only if TOL is
   *          non-positive on entry. Otherwise TOL is unchanged.
   *
   *  INFO    (output) INTEGER
   *          = 0   : successful exit
   *          .lt. 0: if INFO = -i, the i-th argument had an illegal value
   *          .gt. 0: overflow would occur when computing the INFO(th)
   *                  element of the solution vector x. This can only occur
   *                  when JOB is supplied as positive and either means
   *                  that a diagonal element of U is very small, or that
   *                  the elements of the right-hand side vector y are very
   *                  large.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param job
   * @param n
   * @param a
   * @param _a_offset
   * @param b
   * @param _b_offset
   * @param c
   * @param _c_offset
   * @param d
   * @param _d_offset
   * @param in
   * @param _in_offset
   * @param y
   * @param _y_offset
   * @param tol
   * @param info
   * 
   */
  abstract public void dlagts(int job, int n, double[] a, int _a_offset, double[] b, int _b_offset, double[] c, int _c_offset, double[] d, int _d_offset, int[] in, int _in_offset, double[] y, int _y_offset, org.netlib.util.doubleW tol, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAGV2 computes the Generalized Schur factorization of a real 2-by-2
   *  matrix pencil (A,B) where B is upper triangular. This routine
   *  computes orthogonal (rotation) matrices given by CSL, SNL and CSR,
   *  SNR such that
   *
   *  1) if the pencil (A,B) has two real eigenvalues (include 0/0 or 1/0
   *     types), then
   *
   *     [ a11 a12 ] := [  CSL  SNL ] [ a11 a12 ] [  CSR -SNR ]
   *     [  0  a22 ]    [ -SNL  CSL ] [ a21 a22 ] [  SNR  CSR ]
   *
   *     [ b11 b12 ] := [  CSL  SNL ] [ b11 b12 ] [  CSR -SNR ]
   *     [  0  b22 ]    [ -SNL  CSL ] [  0  b22 ] [  SNR  CSR ],
   *
   *  2) if the pencil (A,B) has a pair of complex conjugate eigenvalues,
   *     then
   *
   *     [ a11 a12 ] := [  CSL  SNL ] [ a11 a12 ] [  CSR -SNR ]
   *     [ a21 a22 ]    [ -SNL  CSL ] [ a21 a22 ] [  SNR  CSR ]
   *
   *     [ b11  0  ] := [  CSL  SNL ] [ b11 b12 ] [  CSR -SNR ]
   *     [  0  b22 ]    [ -SNL  CSL ] [  0  b22 ] [  SNR  CSR ]
   *
   *     where b11 >= b22 > 0.
   *
   *
   *  Arguments
   *  =========
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA, 2)
   *          On entry, the 2 x 2 matrix A.
   *          On exit, A is overwritten by the ``A-part'' of the
   *          generalized Schur form.
   *
   *  LDA     (input) INTEGER
   *          THe leading dimension of the array A.  LDA >= 2.
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB, 2)
   *          On entry, the upper triangular 2 x 2 matrix B.
   *          On exit, B is overwritten by the ``B-part'' of the
   *          generalized Schur form.
   *
   *  LDB     (input) INTEGER
   *          THe leading dimension of the array B.  LDB >= 2.
   *
   *  ALPHAR  (output) DOUBLE PRECISION array, dimension (2)
   *  ALPHAI  (output) DOUBLE PRECISION array, dimension (2)
   *  BETA    (output) DOUBLE PRECISION array, dimension (2)
   *          (ALPHAR(k)+i*ALPHAI(k))/BETA(k) are the eigenvalues of the
   *          pencil (A,B), k=1,2, i = sqrt(-1).  Note that BETA(k) may
   *          be zero.
   *
   *  CSL     (output) DOUBLE PRECISION
   *          The cosine of the left rotation matrix.
   *
   *  SNL     (output) DOUBLE PRECISION
   *          The sine of the left rotation matrix.
   *
   *  CSR     (output) DOUBLE PRECISION
   *          The cosine of the right rotation matrix.
   *
   *  SNR     (output) DOUBLE PRECISION
   *          The sine of the right rotation matrix.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Mark Fahey, Department of Mathematics, Univ. of Kentucky, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param a
   * @param lda
   * @param b
   * @param ldb
   * @param alphar
   * @param alphai
   * @param beta
   * @param csl
   * @param snl
   * @param csr
   * @param snr
   * 
   */
  abstract public void dlagv2(double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, org.netlib.util.doubleW csl, org.netlib.util.doubleW snl, org.netlib.util.doubleW csr, org.netlib.util.doubleW snr);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAGV2 computes the Generalized Schur factorization of a real 2-by-2
   *  matrix pencil (A,B) where B is upper triangular. This routine
   *  computes orthogonal (rotation) matrices given by CSL, SNL and CSR,
   *  SNR such that
   *
   *  1) if the pencil (A,B) has two real eigenvalues (include 0/0 or 1/0
   *     types), then
   *
   *     [ a11 a12 ] := [  CSL  SNL ] [ a11 a12 ] [  CSR -SNR ]
   *     [  0  a22 ]    [ -SNL  CSL ] [ a21 a22 ] [  SNR  CSR ]
   *
   *     [ b11 b12 ] := [  CSL  SNL ] [ b11 b12 ] [  CSR -SNR ]
   *     [  0  b22 ]    [ -SNL  CSL ] [  0  b22 ] [  SNR  CSR ],
   *
   *  2) if the pencil (A,B) has a pair of complex conjugate eigenvalues,
   *     then
   *
   *     [ a11 a12 ] := [  CSL  SNL ] [ a11 a12 ] [  CSR -SNR ]
   *     [ a21 a22 ]    [ -SNL  CSL ] [ a21 a22 ] [  SNR  CSR ]
   *
   *     [ b11  0  ] := [  CSL  SNL ] [ b11 b12 ] [  CSR -SNR ]
   *     [  0  b22 ]    [ -SNL  CSL ] [  0  b22 ] [  SNR  CSR ]
   *
   *     where b11 >= b22 > 0.
   *
   *
   *  Arguments
   *  =========
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA, 2)
   *          On entry, the 2 x 2 matrix A.
   *          On exit, A is overwritten by the ``A-part'' of the
   *          generalized Schur form.
   *
   *  LDA     (input) INTEGER
   *          THe leading dimension of the array A.  LDA >= 2.
   *
   *  B       (input/output) DOUBLE PRECISION array, dimension (LDB, 2)
   *          On entry, the upper triangular 2 x 2 matrix B.
   *          On exit, B is overwritten by the ``B-part'' of the
   *          generalized Schur form.
   *
   *  LDB     (input) INTEGER
   *          THe leading dimension of the array B.  LDB >= 2.
   *
   *  ALPHAR  (output) DOUBLE PRECISION array, dimension (2)
   *  ALPHAI  (output) DOUBLE PRECISION array, dimension (2)
   *  BETA    (output) DOUBLE PRECISION array, dimension (2)
   *          (ALPHAR(k)+i*ALPHAI(k))/BETA(k) are the eigenvalues of the
   *          pencil (A,B), k=1,2, i = sqrt(-1).  Note that BETA(k) may
   *          be zero.
   *
   *  CSL     (output) DOUBLE PRECISION
   *          The cosine of the left rotation matrix.
   *
   *  SNL     (output) DOUBLE PRECISION
   *          The sine of the left rotation matrix.
   *
   *  CSR     (output) DOUBLE PRECISION
   *          The cosine of the right rotation matrix.
   *
   *  SNR     (output) DOUBLE PRECISION
   *          The sine of the right rotation matrix.
   *
   *  Further Details
   *  ===============
   *
   *  Based on contributions by
   *     Mark Fahey, Department of Mathematics, Univ. of Kentucky, USA
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param a
   * @param _a_offset
   * @param lda
   * @param b
   * @param _b_offset
   * @param ldb
   * @param alphar
   * @param _alphar_offset
   * @param alphai
   * @param _alphai_offset
   * @param beta
   * @param _beta_offset
   * @param csl
   * @param snl
   * @param csr
   * @param snr
   * 
   */
  abstract public void dlagv2(double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double[] alphar, int _alphar_offset, double[] alphai, int _alphai_offset, double[] beta, int _beta_offset, org.netlib.util.doubleW csl, org.netlib.util.doubleW snl, org.netlib.util.doubleW csr, org.netlib.util.doubleW snr);

  /**
   * <pre><code>
   *     ..
   *
   *     Purpose
   *     =======
   *
   *     DLAHQR is an auxiliary routine called by DHSEQR to update the
   *     eigenvalues and Schur decomposition already computed by DHSEQR, by
   *     dealing with the Hessenberg submatrix in rows and columns ILO to
   *     IHI.
   *
   *     Arguments
   *     =========
   *
   *     WANTT   (input) LOGICAL
   *          = .TRUE. : the full Schur form T is required;
   *          = .FALSE.: only eigenvalues are required.
   *
   *     WANTZ   (input) LOGICAL
   *          = .TRUE. : the matrix of Schur vectors Z is required;
   *          = .FALSE.: Schur vectors are not required.
   *
   *     N       (input) INTEGER
   *          The order of the matrix H.  N >= 0.
   *
   *     ILO     (input) INTEGER
   *     IHI     (input) INTEGER
   *          It is assumed that H is already upper quasi-triangular in
   *          rows and columns IHI+1:N, and that H(ILO,ILO-1) = 0 (unless
   *          ILO = 1). DLAHQR works primarily with the Hessenberg
   *          submatrix in rows and columns ILO to IHI, but applies
   *          transformations to all of H if WANTT is .TRUE..
   *          1 <= ILO <= max(1,IHI); IHI <= N.
   *
   *     H       (input/output) DOUBLE PRECISION array, dimension (LDH,N)
   *          On entry, the upper Hessenberg matrix H.
   *          On exit, if INFO is zero and if WANTT is .TRUE., H is upper
   *          quasi-triangular in rows and columns ILO:IHI, with any
   *          2-by-2 diagonal blocks in standard form. If INFO is zero
   *          and WANTT is .FALSE., the contents of H are unspecified on
   *          exit.  The output state of H if INFO is nonzero is given
   *          below under the description of INFO.
   *
   *     LDH     (input) INTEGER
   *          The leading dimension of the array H. LDH >= max(1,N).
   *
   *     WR      (output) DOUBLE PRECISION array, dimension (N)
   *     WI      (output) DOUBLE PRECISION array, dimension (N)
   *          The real and imaginary parts, respectively, of the computed
   *          eigenvalues ILO to IHI are stored in the corresponding
   *          elements of WR and WI. If two eigenvalues are computed as a
   *          complex conjugate pair, they are stored in consecutive
   *          elements of WR and WI, say the i-th and (i+1)th, with
   *          WI(i) > 0 and WI(i+1) < 0. If WANTT is .TRUE., the
   *          eigenvalues are stored in the same order as on the diagonal
   *          of the Schur form returned in H, with WR(i) = H(i,i), and, if
   *          H(i:i+1,i:i+1) is a 2-by-2 diagonal block,
   *          WI(i) = sqrt(H(i+1,i)*H(i,i+1)) and WI(i+1) = -WI(i).
   *
   *     ILOZ    (input) INTEGER
   *     IHIZ    (input) INTEGER
   *          Specify the rows of Z to which transformations must be
   *          applied if WANTZ is .TRUE..
   *          1 <= ILOZ <= ILO; IHI <= IHIZ <= N.
   *
   *     Z       (input/output) DOUBLE PRECISION array, dimension (LDZ,N)
   *          If WANTZ is .TRUE., on entry Z must contain the current
   *          matrix Z of transformations accumulated by DHSEQR, and on
   *          exit Z has been updated; transformations are applied only to
   *          the submatrix Z(ILOZ:IHIZ,ILO:IHI).
   *          If WANTZ is .FALSE., Z is not referenced.
   *
   *     LDZ     (input) INTEGER
   *          The leading dimension of the array Z. LDZ >= max(1,N).
   *
   *     INFO    (output) INTEGER
   *           =   0: successful exit
   *          .GT. 0: If INFO = i, DLAHQR failed to compute all the
   *                  eigenvalues ILO to IHI in a total of 30 iterations
   *                  per eigenvalue; elements i+1:ihi of WR and WI
   *                  contain those eigenvalues which have been
   *                  successfully computed.
   *
   *                  If INFO .GT. 0 and WANTT is .FALSE., then on exit,
   *                  the remaining unconverged eigenvalues are the
   *                  eigenvalues of the upper Hessenberg matrix rows
   *                  and columns ILO thorugh INFO of the final, output
   *                  value of H.
   *
   *                  If INFO .GT. 0 and WANTT is .TRUE., then on exit
   *          (*)       (initial value of H)*U  = U*(final value of H)
   *                  where U is an orthognal matrix.    The final
   *                  value of H is upper Hessenberg and triangular in
   *                  rows and columns INFO+1 through IHI.
   *
   *                  If INFO .GT. 0 and WANTZ is .TRUE., then on exit
   *                      (final value of Z)  = (initial value of Z)*U
   *                  where U is the orthogonal matrix in (*)
   *                  (regardless of the value of WANTT.)
   *
   *     Further Details
   *     ===============
   *
   *     02-96 Based on modifications by
   *     David Day, Sandia National Laboratory, USA
   *
   *     12-04 Further modifications by
   *     Ralph Byers, University of Kansas, USA
   *
   *       This is a modified version of DLAHQR from LAPACK version 3.0.
   *       It is (1) more robust against overflow and underflow and
   *       (2) adopts the more conservative Ahues & Tisseur stopping
   *       criterion (LAWN 122, 1997).
   *
   *     =========================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param wantt
   * @param wantz
   * @param n
   * @param ilo
   * @param ihi
   * @param h
   * @param ldh
   * @param wr
   * @param wi
   * @param iloz
   * @param ihiz
   * @param z
   * @param ldz
   * @param info
   * 
   */
  abstract public void dlahqr(boolean wantt, boolean wantz, int n, int ilo, int ihi, double[] h, int ldh, double[] wr, double[] wi, int iloz, int ihiz, double[] z, int ldz, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *     Purpose
   *     =======
   *
   *     DLAHQR is an auxiliary routine called by DHSEQR to update the
   *     eigenvalues and Schur decomposition already computed by DHSEQR, by
   *     dealing with the Hessenberg submatrix in rows and columns ILO to
   *     IHI.
   *
   *     Arguments
   *     =========
   *
   *     WANTT   (input) LOGICAL
   *          = .TRUE. : the full Schur form T is required;
   *          = .FALSE.: only eigenvalues are required.
   *
   *     WANTZ   (input) LOGICAL
   *          = .TRUE. : the matrix of Schur vectors Z is required;
   *          = .FALSE.: Schur vectors are not required.
   *
   *     N       (input) INTEGER
   *          The order of the matrix H.  N >= 0.
   *
   *     ILO     (input) INTEGER
   *     IHI     (input) INTEGER
   *          It is assumed that H is already upper quasi-triangular in
   *          rows and columns IHI+1:N, and that H(ILO,ILO-1) = 0 (unless
   *          ILO = 1). DLAHQR works primarily with the Hessenberg
   *          submatrix in rows and columns ILO to IHI, but applies
   *          transformations to all of H if WANTT is .TRUE..
   *          1 <= ILO <= max(1,IHI); IHI <= N.
   *
   *     H       (input/output) DOUBLE PRECISION array, dimension (LDH,N)
   *          On entry, the upper Hessenberg matrix H.
   *          On exit, if INFO is zero and if WANTT is .TRUE., H is upper
   *          quasi-triangular in rows and columns ILO:IHI, with any
   *          2-by-2 diagonal blocks in standard form. If INFO is zero
   *          and WANTT is .FALSE., the contents of H are unspecified on
   *          exit.  The output state of H if INFO is nonzero is given
   *          below under the description of INFO.
   *
   *     LDH     (input) INTEGER
   *          The leading dimension of the array H. LDH >= max(1,N).
   *
   *     WR      (output) DOUBLE PRECISION array, dimension (N)
   *     WI      (output) DOUBLE PRECISION array, dimension (N)
   *          The real and imaginary parts, respectively, of the computed
   *          eigenvalues ILO to IHI are stored in the corresponding
   *          elements of WR and WI. If two eigenvalues are computed as a
   *          complex conjugate pair, they are stored in consecutive
   *          elements of WR and WI, say the i-th and (i+1)th, with
   *          WI(i) > 0 and WI(i+1) < 0. If WANTT is .TRUE., the
   *          eigenvalues are stored in the same order as on the diagonal
   *          of the Schur form returned in H, with WR(i) = H(i,i), and, if
   *          H(i:i+1,i:i+1) is a 2-by-2 diagonal block,
   *          WI(i) = sqrt(H(i+1,i)*H(i,i+1)) and WI(i+1) = -WI(i).
   *
   *     ILOZ    (input) INTEGER
   *     IHIZ    (input) INTEGER
   *          Specify the rows of Z to which transformations must be
   *          applied if WANTZ is .TRUE..
   *          1 <= ILOZ <= ILO; IHI <= IHIZ <= N.
   *
   *     Z       (input/output) DOUBLE PRECISION array, dimension (LDZ,N)
   *          If WANTZ is .TRUE., on entry Z must contain the current
   *          matrix Z of transformations accumulated by DHSEQR, and on
   *          exit Z has been updated; transformations are applied only to
   *          the submatrix Z(ILOZ:IHIZ,ILO:IHI).
   *          If WANTZ is .FALSE., Z is not referenced.
   *
   *     LDZ     (input) INTEGER
   *          The leading dimension of the array Z. LDZ >= max(1,N).
   *
   *     INFO    (output) INTEGER
   *           =   0: successful exit
   *          .GT. 0: If INFO = i, DLAHQR failed to compute all the
   *                  eigenvalues ILO to IHI in a total of 30 iterations
   *                  per eigenvalue; elements i+1:ihi of WR and WI
   *                  contain those eigenvalues which have been
   *                  successfully computed.
   *
   *                  If INFO .GT. 0 and WANTT is .FALSE., then on exit,
   *                  the remaining unconverged eigenvalues are the
   *                  eigenvalues of the upper Hessenberg matrix rows
   *                  and columns ILO thorugh INFO of the final, output
   *                  value of H.
   *
   *                  If INFO .GT. 0 and WANTT is .TRUE., then on exit
   *          (*)       (initial value of H)*U  = U*(final value of H)
   *                  where U is an orthognal matrix.    The final
   *                  value of H is upper Hessenberg and triangular in
   *                  rows and columns INFO+1 through IHI.
   *
   *                  If INFO .GT. 0 and WANTZ is .TRUE., then on exit
   *                      (final value of Z)  = (initial value of Z)*U
   *                  where U is the orthogonal matrix in (*)
   *                  (regardless of the value of WANTT.)
   *
   *     Further Details
   *     ===============
   *
   *     02-96 Based on modifications by
   *     David Day, Sandia National Laboratory, USA
   *
   *     12-04 Further modifications by
   *     Ralph Byers, University of Kansas, USA
   *
   *       This is a modified version of DLAHQR from LAPACK version 3.0.
   *       It is (1) more robust against overflow and underflow and
   *       (2) adopts the more conservative Ahues & Tisseur stopping
   *       criterion (LAWN 122, 1997).
   *
   *     =========================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param wantt
   * @param wantz
   * @param n
   * @param ilo
   * @param ihi
   * @param h
   * @param _h_offset
   * @param ldh
   * @param wr
   * @param _wr_offset
   * @param wi
   * @param _wi_offset
   * @param iloz
   * @param ihiz
   * @param z
   * @param _z_offset
   * @param ldz
   * @param info
   * 
   */
  abstract public void dlahqr(boolean wantt, boolean wantz, int n, int ilo, int ihi, double[] h, int _h_offset, int ldh, double[] wr, int _wr_offset, double[] wi, int _wi_offset, int iloz, int ihiz, double[] z, int _z_offset, int ldz, org.netlib.util.intW info);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAHR2 reduces the first NB columns of A real general n-BY-(n-k+1)
   *  matrix A so that elements below the k-th subdiagonal are zero. The
   *  reduction is performed by an orthogonal similarity transformation
   *  Q' * A * Q. The routine returns the matrices V and T which determine
   *  Q as a block reflector I - V*T*V', and also the matrix Y = A * V * T.
   *
   *  This is an auxiliary routine called by DGEHRD.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.
   *
   *  K       (input) INTEGER
   *          The offset for the reduction. Elements below the k-th
   *          subdiagonal in the first NB columns are reduced to zero.
   *          K < N.
   *
   *  NB      (input) INTEGER
   *          The number of columns to be reduced.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N-K+1)
   *          On entry, the n-by-(n-k+1) general matrix A.
   *          On exit, the elements on and above the k-th subdiagonal in
   *          the first NB columns are overwritten with the corresponding
   *          elements of the reduced matrix; the elements below the k-th
   *          subdiagonal, with the array TAU, represent the matrix Q as a
   *          product of elementary reflectors. The other columns of A are
   *          unchanged. See Further Details.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (NB)
   *          The scalar factors of the elementary reflectors. See Further
   *          Details.
   *
   *  T       (output) DOUBLE PRECISION array, dimension (LDT,NB)
   *          The upper triangular matrix T.
   *
   *  LDT     (input) INTEGER
   *          The leading dimension of the array T.  LDT >= NB.
   *
   *  Y       (output) DOUBLE PRECISION array, dimension (LDY,NB)
   *          The n-by-nb matrix Y.
   *
   *  LDY     (input) INTEGER
   *          The leading dimension of the array Y. LDY >= N.
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of nb elementary reflectors
   *
   *     Q = H(1) H(2) . . . H(nb).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(1:i+k-1) = 0, v(i+k) = 1; v(i+k+1:n) is stored on exit in
   *  A(i+k+1:n,i), and tau in TAU(i).
   *
   *  The elements of the vectors v together form the (n-k+1)-by-nb matrix
   *  V which is needed, with T and Y, to apply the transformation to the
   *  unreduced part of the matrix, using an update of the form:
   *  A := (I - V*T*V') * (A - Y*V').
   *
   *  The contents of A on exit are illustrated by the following example
   *  with n = 7, k = 3 and nb = 2:
   *
   *     ( a   a   a   a   a )
   *     ( a   a   a   a   a )
   *     ( a   a   a   a   a )
   *     ( h   h   a   a   a )
   *     ( v1  h   a   a   a )
   *     ( v1  v2  a   a   a )
   *     ( v1  v2  a   a   a )
   *
   *  where a denotes an element of the original matrix A, h denotes a
   *  modified element of the upper Hessenberg matrix H, and vi denotes an
   *  element of the vector defining H(i).
   *
   *  This file is a slight modification of LAPACK-3.0's DLAHRD
   *  incorporating improvements proposed by Quintana-Orti and Van de
   *  Gejin. Note that the entries of A(1:K,2:NB) differ from those
   *  returned by the original LAPACK routine. This function is
   *  not backward compatible with LAPACK3.0.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param k
   * @param nb
   * @param a
   * @param lda
   * @param tau
   * @param t
   * @param ldt
   * @param y
   * @param ldy
   * 
   */
  abstract public void dlahr2(int n, int k, int nb, double[] a, int lda, double[] tau, double[] t, int ldt, double[] y, int ldy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAHR2 reduces the first NB columns of A real general n-BY-(n-k+1)
   *  matrix A so that elements below the k-th subdiagonal are zero. The
   *  reduction is performed by an orthogonal similarity transformation
   *  Q' * A * Q. The routine returns the matrices V and T which determine
   *  Q as a block reflector I - V*T*V', and also the matrix Y = A * V * T.
   *
   *  This is an auxiliary routine called by DGEHRD.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.
   *
   *  K       (input) INTEGER
   *          The offset for the reduction. Elements below the k-th
   *          subdiagonal in the first NB columns are reduced to zero.
   *          K < N.
   *
   *  NB      (input) INTEGER
   *          The number of columns to be reduced.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N-K+1)
   *          On entry, the n-by-(n-k+1) general matrix A.
   *          On exit, the elements on and above the k-th subdiagonal in
   *          the first NB columns are overwritten with the corresponding
   *          elements of the reduced matrix; the elements below the k-th
   *          subdiagonal, with the array TAU, represent the matrix Q as a
   *          product of elementary reflectors. The other columns of A are
   *          unchanged. See Further Details.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (NB)
   *          The scalar factors of the elementary reflectors. See Further
   *          Details.
   *
   *  T       (output) DOUBLE PRECISION array, dimension (LDT,NB)
   *          The upper triangular matrix T.
   *
   *  LDT     (input) INTEGER
   *          The leading dimension of the array T.  LDT >= NB.
   *
   *  Y       (output) DOUBLE PRECISION array, dimension (LDY,NB)
   *          The n-by-nb matrix Y.
   *
   *  LDY     (input) INTEGER
   *          The leading dimension of the array Y. LDY >= N.
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of nb elementary reflectors
   *
   *     Q = H(1) H(2) . . . H(nb).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(1:i+k-1) = 0, v(i+k) = 1; v(i+k+1:n) is stored on exit in
   *  A(i+k+1:n,i), and tau in TAU(i).
   *
   *  The elements of the vectors v together form the (n-k+1)-by-nb matrix
   *  V which is needed, with T and Y, to apply the transformation to the
   *  unreduced part of the matrix, using an update of the form:
   *  A := (I - V*T*V') * (A - Y*V').
   *
   *  The contents of A on exit are illustrated by the following example
   *  with n = 7, k = 3 and nb = 2:
   *
   *     ( a   a   a   a   a )
   *     ( a   a   a   a   a )
   *     ( a   a   a   a   a )
   *     ( h   h   a   a   a )
   *     ( v1  h   a   a   a )
   *     ( v1  v2  a   a   a )
   *     ( v1  v2  a   a   a )
   *
   *  where a denotes an element of the original matrix A, h denotes a
   *  modified element of the upper Hessenberg matrix H, and vi denotes an
   *  element of the vector defining H(i).
   *
   *  This file is a slight modification of LAPACK-3.0's DLAHRD
   *  incorporating improvements proposed by Quintana-Orti and Van de
   *  Gejin. Note that the entries of A(1:K,2:NB) differ from those
   *  returned by the original LAPACK routine. This function is
   *  not backward compatible with LAPACK3.0.
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param k
   * @param nb
   * @param a
   * @param _a_offset
   * @param lda
   * @param tau
   * @param _tau_offset
   * @param t
   * @param _t_offset
   * @param ldt
   * @param y
   * @param _y_offset
   * @param ldy
   * 
   */
  abstract public void dlahr2(int n, int k, int nb, double[] a, int _a_offset, int lda, double[] tau, int _tau_offset, double[] t, int _t_offset, int ldt, double[] y, int _y_offset, int ldy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAHRD reduces the first NB columns of a real general n-by-(n-k+1)
   *  matrix A so that elements below the k-th subdiagonal are zero. The
   *  reduction is performed by an orthogonal similarity transformation
   *  Q' * A * Q. The routine returns the matrices V and T which determine
   *  Q as a block reflector I - V*T*V', and also the matrix Y = A * V * T.
   *
   *  This is an OBSOLETE auxiliary routine. 
   *  This routine will be 'deprecated' in a  future release.
   *  Please use the new routine DLAHR2 instead.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.
   *
   *  K       (input) INTEGER
   *          The offset for the reduction. Elements below the k-th
   *          subdiagonal in the first NB columns are reduced to zero.
   *
   *  NB      (input) INTEGER
   *          The number of columns to be reduced.
   *
   *  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N-K+1)
   *          On entry, the n-by-(n-k+1) general matrix A.
   *          On exit, the elements on and above the k-th subdiagonal in
   *          the first NB columns are overwritten with the corresponding
   *          elements of the reduced matrix; the elements below the k-th
   *          subdiagonal, with the array TAU, represent the matrix Q as a
   *          product of elementary reflectors. The other columns of A are
   *          unchanged. See Further Details.
   *
   *  LDA     (input) INTEGER
   *          The leading dimension of the array A.  LDA >= max(1,N).
   *
   *  TAU     (output) DOUBLE PRECISION array, dimension (NB)
   *          The scalar factors of the elementary reflectors. See Further
   *          Details.
   *
   *  T       (output) DOUBLE PRECISION array, dimension (LDT,NB)
   *          The upper triangular matrix T.
   *
   *  LDT     (input) INTEGER
   *          The leading dimension of the array T.  LDT >= NB.
   *
   *  Y       (output) DOUBLE PRECISION array, dimension (LDY,NB)
   *          The n-by-nb matrix Y.
   *
   *  LDY     (input) INTEGER
   *          The leading dimension of the array Y. LDY >= N.
   *
   *  Further Details
   *  ===============
   *
   *  The matrix Q is represented as a product of nb elementary reflectors
   *
   *     Q = H(1) H(2) . . . H(nb).
   *
   *  Each H(i) has the form
   *
   *     H(i) = I - tau * v * v'
   *
   *  where tau is a real scalar, and v is a real vector with
   *  v(1:i+k-1) = 0, v(i+k) = 1; v(i+k+1:n) is stored on exit in
   *  A(i+k+1:n,i), and tau in TAU(i).
   *
   *  The elements of the vectors v together form the (n-k+1)-by-nb matrix
   *  V which is needed, with T and Y, to apply the transformation to the
   *  unreduced part of the matrix, using an update of the form:
   *  A := (I - V*T*V') * (A - Y*V').
   *
   *  The contents of A on exit are illustrated by the following example
   *  with n = 7, k = 3 and nb = 2:
   *
   *     ( a   h   a   a   a )
   *     ( a   h   a   a   a )
   *     ( a   h   a   a   a )
   *     ( h   h   a   a   a )
   *     ( v1  h   a   a   a )
   *     ( v1  v2  a   a   a )
   *     ( v1  v2  a   a   a )
   *
   *  where a denotes an element of the original matrix A, h denotes a
   *  modified element of the upper Hessenberg matrix H, and vi denotes an
   *  element of the vector defining H(i).
   *
   *  =====================================================================
   *
   *     .. Parameters ..
   * </code></pre>
   *
   * @param n
   * @param k
   * @param nb
   * @param a
   * @param lda
   * @param tau
   * @param t
   * @param ldt
   * @param y
   * @param ldy
   * 
   */
  abstract public void dlahrd(int n, int k, int nb, double[] a, int lda, double[] tau, double[] t, int ldt, double[] y, int ldy);

  /**
   * <pre><code>
   *     ..
   *
   *  Purpose
   *  =======
   *
   *  DLAHRD reduces the first NB columns of a real general n-by-(n-k+1)
   *  matrix A so that elements below the k-th subdiagonal are zero. The
   *  reduction is performed by an orthogonal similarity transformation
   *  Q' * A * Q. The routine returns the matrices V and T which determine
   *  Q as a block reflector I - V*T*V', and also the matrix Y = A * V * T.
   *
   *  This is an OBSOLETE auxiliary routine. 
   *  This routine will be 'deprecated' in a  future release.
   *  Please use the new routine DLAHR2 instead.
   *
   *  Arguments
   *  =========
   *
   *  N       (input) INTEGER
   *          The order of the matrix A.
   *
   *  K       (input) INTEGER
   *          The offset for the reduction. Elements below the k-th
   *          subdiagonal in the first NB columns are reduced to zero.
   *
   *  NB      