/*
 * Decompiled with CFR 0.152.
 */
package metrics_influxdb.serialization.line;

import java.util.Map;
import metrics_influxdb.measurements.Measurement;
import metrics_influxdb.misc.Miscellaneous;
import metrics_influxdb.serialization.line.InfluxDBSortedMap;

public class Inliner {
    public String inline(Measurement m) {
        String key = this.buildMeasureKey(m.getName(), m.getTags());
        String values = this.buildMeasureFields(m.getValues());
        String timestamp = "" + m.getTimestamp();
        return key + " " + values + " " + timestamp;
    }

    public String inline(Iterable<Measurement> measurements) {
        StringBuilder sb = new StringBuilder();
        String join = "";
        String cr = "\n";
        for (Measurement m : measurements) {
            sb.append(join).append(this.inline(m));
            join = cr;
        }
        return sb.toString();
    }

    private String buildMeasureFields(Map<String, String> values) {
        InfluxDBSortedMap sortedValues = new InfluxDBSortedMap();
        sortedValues.putAll(values);
        StringBuilder fields = new StringBuilder();
        String join = "";
        for (Map.Entry v : sortedValues.entrySet()) {
            fields.append(join).append(Miscellaneous.escape((String)v.getKey(), ' ', ',')).append("=").append((String)v.getValue());
            join = ",";
        }
        return fields.toString();
    }

    private String buildMeasureKey(String name, Map<String, String> tags) {
        StringBuilder key = new StringBuilder(Miscellaneous.escape(name, ' ', ','));
        InfluxDBSortedMap sortedTags = new InfluxDBSortedMap();
        sortedTags.putAll(tags);
        for (Map.Entry e : sortedTags.entrySet()) {
            key.append(',').append(Miscellaneous.escape((String)e.getKey(), ' ', ',')).append("=").append(Miscellaneous.escape((String)e.getValue(), ' ', ','));
        }
        return key.toString();
    }
}

