/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.pixels;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjExceptionInternal;
import java.util.Arrays;

public class FiltersPerformance {
    private final ImageInfo iminfo;
    private double memoryA = 0.7;
    private int lastrow = -1;
    private double[] absum = new double[5];
    private double[] entropy = new double[5];
    private double[] cost = new double[5];
    private int[] histog = new int[256];
    private int lastprefered = -1;
    private boolean initdone = false;
    private double preferenceForNone = 1.0;
    public static final double[] FILTER_WEIGHTS_DEFAULT = new double[]{0.73, 1.03, 0.97, 1.11, 1.22};
    private double[] filter_weights = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0};
    private static final double LOG2NI = -1.0 / Math.log(2.0);

    public FiltersPerformance(ImageInfo imageInfo) {
        this.iminfo = imageInfo;
    }

    private void init() {
        if (this.filter_weights[0] < 0.0) {
            System.arraycopy(FILTER_WEIGHTS_DEFAULT, 0, this.filter_weights, 0, 5);
            double d = this.filter_weights[0];
            if (this.iminfo.bitDepth == 16) {
                d = 1.2;
            } else if (this.iminfo.alpha) {
                d = 0.8;
            } else if (this.iminfo.indexed || this.iminfo.bitDepth < 8) {
                d = 0.4;
            }
            this.filter_weights[0] = d /= this.preferenceForNone;
        }
        Arrays.fill(this.cost, 1.0);
        this.initdone = true;
    }

    public void updateFromFiltered(FilterType filterType, byte[] byArray, int n) {
        this.updateFromRawOrFiltered(filterType, byArray, null, null, n);
    }

    public void updateFromRaw(FilterType filterType, byte[] byArray, byte[] byArray2, int n) {
        this.updateFromRawOrFiltered(filterType, null, byArray, byArray2, n);
    }

    private void updateFromRawOrFiltered(FilterType filterType, byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        if (!this.initdone) {
            this.init();
        }
        if (n != this.lastrow) {
            Arrays.fill(this.absum, Double.NaN);
            Arrays.fill(this.entropy, Double.NaN);
        }
        this.lastrow = n;
        if (byArray != null) {
            this.computeHistogram(byArray);
        } else {
            this.computeHistogramForFilter(filterType, byArray2, byArray3);
        }
        if (filterType == FilterType.FILTER_NONE) {
            this.entropy[filterType.val] = this.computeEntropyFromHistogram();
        } else {
            this.absum[filterType.val] = this.computeAbsFromHistogram();
        }
    }

    public FilterType getPreferred() {
        int n = 0;
        double d = Double.MAX_VALUE;
        double d2 = 0.0;
        for (int i = 0; i < 5; ++i) {
            if (!Double.isNaN(this.absum[i])) {
                d2 = this.absum[i];
            } else {
                if (Double.isNaN(this.entropy[i])) continue;
                d2 = (Math.pow(2.0, this.entropy[i]) - 1.0) * 0.5;
            }
            d2 *= this.filter_weights[i];
            this.cost[i] = d2 = this.cost[i] * this.memoryA + (1.0 - this.memoryA) * d2;
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
        }
        this.lastprefered = n;
        return FilterType.getByVal(this.lastprefered);
    }

    public final void computeHistogramForFilter(FilterType filterType, byte[] byArray, byte[] byArray2) {
        Arrays.fill(this.histog, 0);
        int n = this.iminfo.bytesPerRow;
        switch (filterType) {
            case FILTER_NONE: {
                for (int i = 1; i <= n; ++i) {
                    int n2 = byArray[i] & 0xFF;
                    this.histog[n2] = this.histog[n2] + 1;
                }
                break;
            }
            case FILTER_PAETH: {
                int n3;
                for (n3 = 1; n3 <= n; ++n3) {
                    int n4 = PngHelperInternal.filterRowPaeth(byArray[n3], 0, byArray2[n3] & 0xFF, 0);
                    this.histog[n4] = this.histog[n4] + 1;
                }
                int n5 = 1;
                n3 = this.iminfo.bytesPixel + 1;
                while (n3 <= n) {
                    int n6 = PngHelperInternal.filterRowPaeth(byArray[n3], byArray[n5] & 0xFF, byArray2[n3] & 0xFF, byArray2[n5] & 0xFF);
                    this.histog[n6] = this.histog[n6] + 1;
                    ++n3;
                    ++n5;
                }
                break;
            }
            case FILTER_SUB: {
                int n7;
                for (n7 = 1; n7 <= this.iminfo.bytesPixel; ++n7) {
                    int n8 = byArray[n7] & 0xFF;
                    this.histog[n8] = this.histog[n8] + 1;
                }
                int n9 = 1;
                n7 = this.iminfo.bytesPixel + 1;
                while (n7 <= n) {
                    int n10 = byArray[n7] - byArray[n9] & 0xFF;
                    this.histog[n10] = this.histog[n10] + 1;
                    ++n7;
                    ++n9;
                }
                break;
            }
            case FILTER_UP: {
                for (int i = 1; i <= this.iminfo.bytesPerRow; ++i) {
                    int n11 = byArray[i] - byArray2[i] & 0xFF;
                    this.histog[n11] = this.histog[n11] + 1;
                }
                break;
            }
            case FILTER_AVERAGE: {
                int n12;
                for (n12 = 1; n12 <= this.iminfo.bytesPixel; ++n12) {
                    int n13 = (byArray[n12] & 0xFF) - (byArray2[n12] & 0xFF) / 2 & 0xFF;
                    this.histog[n13] = this.histog[n13] + 1;
                }
                int n14 = 1;
                n12 = this.iminfo.bytesPixel + 1;
                while (n12 <= n) {
                    int n15 = (byArray[n12] & 0xFF) - ((byArray2[n12] & 0xFF) + (byArray[n14] & 0xFF)) / 2 & 0xFF;
                    this.histog[n15] = this.histog[n15] + 1;
                    ++n12;
                    ++n14;
                }
                break;
            }
            default: {
                throw new PngjExceptionInternal("Bad filter:" + (Object)((Object)filterType));
            }
        }
    }

    public void computeHistogram(byte[] byArray) {
        Arrays.fill(this.histog, 0);
        for (int i = 1; i < this.iminfo.bytesPerRow; ++i) {
            int n = byArray[i] & 0xFF;
            this.histog[n] = this.histog[n] + 1;
        }
    }

    public double computeAbsFromHistogram() {
        int n;
        int n2 = 0;
        for (n = 1; n < 128; ++n) {
            n2 += this.histog[n] * n;
        }
        n = 128;
        for (int i = 128; i > 0; --i) {
            n2 += this.histog[n] * i;
            ++n;
        }
        return (double)n2 / (double)this.iminfo.bytesPerRow;
    }

    public final double computeEntropyFromHistogram() {
        double d = 1.0 / (double)this.iminfo.bytesPerRow;
        double d2 = Math.log(d);
        double d3 = 0.0;
        for (int n : this.histog) {
            if (n <= 0) continue;
            d3 += (Math.log(n) + d2) * (double)n;
        }
        if ((d3 *= d * LOG2NI) < 0.0) {
            d3 = 0.0;
        }
        return d3;
    }

    public void setPreferenceForNone(double d) {
        this.preferenceForNone = d;
    }

    public void tuneMemory(double d) {
        this.memoryA = d == 0.0 ? 0.0 : Math.pow(this.memoryA, 1.0 / d);
    }

    public void setFilterWeights(double[] dArray) {
        System.arraycopy(dArray, 0, this.filter_weights, 0, 5);
    }
}

