/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.pixels;

import java.nio.ByteOrder;

public final class DeflaterEstimatorLz4 {
    static final ByteOrder NATIVE_BYTE_ORDER = ByteOrder.nativeOrder();
    static final int MEMORY_USAGE = 14;
    static final int NOT_COMPRESSIBLE_DETECTION_LEVEL = 6;
    static final int MIN_MATCH = 4;
    static final int HASH_LOG = 12;
    static final int HASH_TABLE_SIZE = 4096;
    static final int SKIP_STRENGTH = Math.max(6, 2);
    static final int COPY_LENGTH = 8;
    static final int LAST_LITERALS = 5;
    static final int MF_LIMIT = 12;
    static final int MIN_LENGTH = 13;
    static final int MAX_DISTANCE = 65536;
    static final int ML_BITS = 4;
    static final int ML_MASK = 15;
    static final int RUN_BITS = 4;
    static final int RUN_MASK = 15;
    static final int LZ4_64K_LIMIT = 65547;
    static final int HASH_LOG_64K = 13;
    static final int HASH_TABLE_SIZE_64K = 8192;
    static final int HASH_LOG_HC = 15;
    static final int HASH_TABLE_SIZE_HC = 32768;
    static final int OPTIMAL_ML = 18;

    public int compressEstim(byte[] byArray, int n, int n2) {
        if (n2 < 10) {
            return n2;
        }
        int n3 = 65546;
        int n4 = (n2 + n3 - 1) / n3;
        if ((n3 = n2 / n4) >= 65546 || n3 * n4 > n2 || n4 < 1 || n3 < 1) {
            throw new RuntimeException("?? " + n2);
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = n2;
        while (n7 > 0) {
            if (n7 > n3) {
                n7 = n3;
            }
            n6 += DeflaterEstimatorLz4.compress64k(byArray, n, n7);
            n += n7;
            n7 = n2 - (n5 += n7);
        }
        double d = (double)n6 / (double)n5;
        return n5 == n2 ? n6 : (int)(d * (double)n2 + 0.5);
    }

    public int compressEstim(byte[] byArray) {
        return this.compressEstim(byArray, 0, byArray.length);
    }

    static int compress64k(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n + n2;
        int n5 = n4 - 5;
        int n6 = n4 - 12;
        int n7 = n;
        int n8 = 0;
        int n9 = n7++;
        if (n2 >= 13) {
            short[] sArray = new short[8192];
            block0: while (true) {
                int n10;
                int n11;
                int n12 = n7;
                int n13 = (1 << SKIP_STRENGTH) + 3;
                do {
                    n7 = n12;
                    if ((n12 += n13++ >>> SKIP_STRENGTH) > n6) break block0;
                    n10 = DeflaterEstimatorLz4.hash64k(DeflaterEstimatorLz4.readInt(byArray, n7));
                    n11 = n + DeflaterEstimatorLz4.readShort(sArray, n10);
                    DeflaterEstimatorLz4.writeShort(sArray, n10, n7 - n);
                } while (!DeflaterEstimatorLz4.readIntEquals(byArray, n11, n7));
                n10 = DeflaterEstimatorLz4.commonBytesBackward(byArray, n11, n7, n, n9);
                n11 -= n10;
                int n14 = (n7 -= n10) - n9;
                ++n8;
                if (n14 >= 15) {
                    if (n14 > 15) {
                        n8 += (n14 - 15) / 255;
                    }
                    ++n8;
                }
                n8 += n14;
                while (true) {
                    n8 += 2;
                    int n15 = DeflaterEstimatorLz4.commonBytes(byArray, n11 += 4, n7 += 4, n5);
                    n7 += n15;
                    if (n15 >= 15) {
                        if (n15 >= 270) {
                            n8 += (n15 - 15) / 255;
                        }
                        ++n8;
                    }
                    if (n7 > n6) {
                        n9 = n7;
                        break block0;
                    }
                    DeflaterEstimatorLz4.writeShort(sArray, DeflaterEstimatorLz4.hash64k(DeflaterEstimatorLz4.readInt(byArray, n7 - 2)), n7 - 2 - n);
                    int n16 = DeflaterEstimatorLz4.hash64k(DeflaterEstimatorLz4.readInt(byArray, n7));
                    n11 = n + DeflaterEstimatorLz4.readShort(sArray, n16);
                    DeflaterEstimatorLz4.writeShort(sArray, n16, n7 - n);
                    if (!DeflaterEstimatorLz4.readIntEquals(byArray, n7, n11)) break;
                    ++n8;
                }
                n9 = n7++;
            }
        }
        if ((n3 = n4 - n9) >= 270) {
            n8 += (n3 - 15) / 255;
        }
        ++n8;
        return n8 += n3;
    }

    static final int maxCompressedLength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("length must be >= 0, got " + n);
        }
        return n + n / 255 + 16;
    }

    static int hash(int n) {
        return n * -1640531535 >>> 20;
    }

    static int hash64k(int n) {
        return n * -1640531535 >>> 19;
    }

    static int readShortLittleEndian(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    static boolean readIntEquals(byte[] byArray, int n, int n2) {
        return byArray[n] == byArray[n2] && byArray[n + 1] == byArray[n2 + 1] && byArray[n + 2] == byArray[n2 + 2] && byArray[n + 3] == byArray[n2 + 3];
    }

    static int commonBytes(byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n2 < n3 && byArray[n++] == byArray[n2++]) {
            ++n4;
        }
        return n4;
    }

    static int commonBytesBackward(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n > n3 && n2 > n4 && byArray[--n] == byArray[--n2]) {
            ++n5;
        }
        return n5;
    }

    static int readShort(short[] sArray, int n) {
        return sArray[n] & 0xFFFF;
    }

    static byte readByte(byte[] byArray, int n) {
        return byArray[n];
    }

    static void checkRange(byte[] byArray, int n) {
        if (n < 0 || n >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
    }

    static void checkRange(byte[] byArray, int n, int n2) {
        DeflaterEstimatorLz4.checkLength(n2);
        if (n2 > 0) {
            DeflaterEstimatorLz4.checkRange(byArray, n);
            DeflaterEstimatorLz4.checkRange(byArray, n + n2 - 1);
        }
    }

    static void checkLength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("lengths must be >= 0");
        }
    }

    static int readIntBE(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    static int readIntLE(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    static int readInt(byte[] byArray, int n) {
        if (NATIVE_BYTE_ORDER == ByteOrder.BIG_ENDIAN) {
            return DeflaterEstimatorLz4.readIntBE(byArray, n);
        }
        return DeflaterEstimatorLz4.readIntLE(byArray, n);
    }

    static void writeShort(short[] sArray, int n, int n2) {
        sArray[n] = (short)n2;
    }
}

