/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.pixels;

import ar.com.hjg.pngj.IdatChunkWriter;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.pixels.CompressorStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.Adler32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class CompressorStreamParallelDeflater
extends CompressorStream {
    private static final int BLOCK_SIZE = 131072;
    private static final int MOD_ADLER = 65521;
    private long chksumS1 = 1L;
    private long chksumS2 = 0L;
    private byte[] last32K = new byte[32768];
    private int last32K_len = 0;
    private Block block;
    private BlockingQueue<Block> freeBlocks;
    private final ExecutorService executor;
    private final int emitQueueSize;
    private final BlockingQueue<Future<Block>> emitQueue;
    private final int deflateBlockLen;
    private final int deflaterCompLevel;
    private final int deflaterStrategy;
    protected byte[] buf1;
    private static final ThreadLocal<State> STATE = new ThreadLocal<State>(){

        @Override
        protected State initialValue() {
            return new State();
        }
    };

    private static Deflater newDeflater() {
        return new Deflater(-1, true);
    }

    private static DeflaterOutputStream newDeflaterOutputStream(OutputStream outputStream, Deflater deflater) {
        return new DeflaterOutputStream(outputStream, deflater, 512, true);
    }

    public CompressorStreamParallelDeflater(IdatChunkWriter idatChunkWriter, int n, long l) {
        this(idatChunkWriter, n, l, CompressorStreamParallelDeflater.getSharedThreadPool(), -1, 0);
    }

    public CompressorStreamParallelDeflater(IdatChunkWriter idatChunkWriter, int n, long l, int n2, int n3) {
        this(idatChunkWriter, n, l, CompressorStreamParallelDeflater.getSharedThreadPool(), n2, n3);
    }

    public CompressorStreamParallelDeflater(IdatChunkWriter idatChunkWriter, int n, long l, ExecutorService executorService) {
        this(idatChunkWriter, n, l, executorService, -1, 0);
    }

    public CompressorStreamParallelDeflater(IdatChunkWriter idatChunkWriter, int n, long l, ExecutorService executorService, int n2, int n3) {
        super(idatChunkWriter, n, l);
        this.executor = executorService;
        int n4 = executorService instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)executorService).getMaximumPoolSize() : Runtime.getRuntime().availableProcessors();
        this.emitQueueSize = n4 * 3;
        this.emitQueue = new ArrayBlockingQueue<Future<Block>>(this.emitQueueSize);
        this.freeBlocks = new ArrayBlockingQueue<Block>(this.emitQueueSize + 1);
        this.deflateBlockLen = n >= 131072 ? 131072 : 131072 / n * n;
        this.deflaterCompLevel = n2 == -1 ? 6 : n2;
        this.deflaterStrategy = n3;
        this.writeHeader();
    }

    private void writeHeader() {
        int n = 30720;
        int n2 = this.deflaterStrategy >= 2 || this.deflaterCompLevel < 2 ? 0 : (this.deflaterCompLevel < 6 ? 1 : (this.deflaterCompLevel == 6 ? 2 : 3));
        n |= n2 << 6;
        n += 31 - n % 31;
        this.internalWrite(new byte[]{(byte)(n >> 8), (byte)(n & 0xFF)});
    }

    private void internalWrite(byte[] byArray) {
        this.internalWrite(byArray, 0, byArray.length);
    }

    private void internalWrite(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            int n3;
            int n4;
            byte[] byArray2;
            if (this.idatChunkWriter != null) {
                byArray2 = this.idatChunkWriter.getBuf();
                n4 = this.idatChunkWriter.getOffset();
                n3 = this.idatChunkWriter.getAvailLen();
            } else {
                if (this.buf1 == null) {
                    this.buf1 = new byte[4096];
                }
                byArray2 = this.buf1;
                n4 = 0;
                n3 = this.buf1.length;
            }
            int n5 = Math.min(n3, n2);
            System.arraycopy(byArray, n, byArray2, n4, n5);
            if (this.idatChunkWriter != null) {
                this.idatChunkWriter.incrementOffset(n5);
            }
            this.bytesOut += (long)n5;
            n += n5;
            n2 -= n5;
        }
    }

    private void updateChecksum(long l, int n) {
        long l2 = l & 0xFFFFL;
        long l3 = l >> 16;
        this.chksumS2 += l3 + (this.chksumS1 - 1L) * (long)n;
        this.chksumS1 += l2 - 1L;
        if (this.chksumS1 > Integer.MAX_VALUE) {
            this.chksumS1 %= 65521L;
        }
        if (this.chksumS2 > Integer.MAX_VALUE) {
            this.chksumS2 %= 65521L;
        }
    }

    @Override
    public void mywrite(byte[] byArray, int n, int n2) {
        if (this.done || this.closed) {
            throw new PngjOutputException("write beyond end of stream");
        }
        while (n2 > 0) {
            int n3;
            if (this.block == null) {
                this.block = this.freeBlocks.peek() != null ? (Block)this.freeBlocks.remove() : new Block(this.deflaterCompLevel, this.deflaterStrategy);
                System.arraycopy(this.last32K, 0, this.block.dict, 0, this.last32K_len);
                this.block.dict_length = this.last32K_len;
            }
            if (n2 >= (n3 = this.deflateBlockLen - this.block.in_length)) {
                System.arraycopy(byArray, n, this.block.in_buf, this.block.in_length, n3);
                this.block.in_length += n3;
                n += n3;
                n2 -= n3;
                this.bytesIn += (long)n3;
                this.submit();
                continue;
            }
            System.arraycopy(byArray, n, this.block.in_buf, this.block.in_length, n2);
            this.block.in_length += n2;
            this.bytesIn += (long)n2;
            break;
        }
    }

    private void submit() {
        this.emitUntil(this.emitQueueSize - 1);
        this.last32K_len = Math.min(this.block.in_length, this.last32K.length);
        System.arraycopy(this.block.in_buf, this.block.in_length - this.last32K_len, this.last32K, 0, this.last32K_len);
        this.emitQueue.add(this.executor.submit(this.block));
        this.block = null;
    }

    @Override
    public void done() {
        if (this.done) {
            return;
        }
        if (this.block != null) {
            this.submit();
        }
        this.emitUntil(0);
        ByteBuffer byteBuffer = ByteBuffer.allocate(6);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.put(new byte[]{3, 0});
        byteBuffer.putShort((short)(this.chksumS2 % 65521L));
        byteBuffer.putShort((short)(this.chksumS1 % 65521L));
        this.internalWrite(byteBuffer.array());
        this.freeBlocks.clear();
        this.done = true;
        if (this.idatChunkWriter != null) {
            this.idatChunkWriter.close();
        }
    }

    @Override
    public void close() {
        this.done();
        super.close();
    }

    private void tryEmit() {
        try {
            while (true) {
                Future future;
                if ((future = (Future)this.emitQueue.peek()) == null) {
                    return;
                }
                if (!future.isDone()) {
                    return;
                }
                Block block = (Block)((Future)this.emitQueue.remove()).get();
                this.updateChecksum(block.chksum, block.in_length);
                this.internalWrite(block.out_buf, 0, block.out_length);
                block.in_length = 0;
                this.freeBlocks.add(block);
            }
        }
        catch (ExecutionException executionException) {
            throw new PngjException(executionException);
        }
        catch (InterruptedException interruptedException) {
            throw new PngjException(interruptedException);
        }
    }

    private void emitUntil(int n) {
        try {
            while (this.emitQueue.size() > n) {
                Block block = (Block)((Future)this.emitQueue.remove()).get();
                this.updateChecksum(block.chksum, block.in_length);
                this.internalWrite(block.out_buf, 0, block.out_length);
                block.in_length = 0;
                this.freeBlocks.put(block);
            }
            this.tryEmit();
        }
        catch (ExecutionException executionException) {
            throw new PngjException(executionException);
        }
        catch (InterruptedException interruptedException) {
            throw new PngjException(interruptedException);
        }
    }

    public static ThreadPoolExecutor newThreadPoolExecutor(int n) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n, n, 1L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(n * 20), ThreadFactoryHolder.THREAD_FACTORY, new ThreadPoolExecutor.CallerRunsPolicy());
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return threadPoolExecutor;
    }

    public static ExecutorService getSharedThreadPool() {
        return ThreadPoolHolder.EXECUTOR;
    }

    static /* synthetic */ Deflater access$000() {
        return CompressorStreamParallelDeflater.newDeflater();
    }

    static /* synthetic */ DeflaterOutputStream access$100(OutputStream outputStream, Deflater deflater) {
        return CompressorStreamParallelDeflater.newDeflaterOutputStream(outputStream, deflater);
    }

    private static class ThreadPoolHolder {
        private static final ExecutorService EXECUTOR = CompressorStreamParallelDeflater.newThreadPoolExecutor(Runtime.getRuntime().availableProcessors());

        private ThreadPoolHolder() {
        }
    }

    private static class ThreadFactoryHolder {
        private static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){
            private final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
            private final AtomicLong counter = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = this.defaultThreadFactory.newThread(runnable);
                thread.setName("paralleldeflate-" + this.counter.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            }
        };

        private ThreadFactoryHolder() {
        }
    }

    private static class Block
    implements Callable<Block> {
        private final int deflaterCompLevel;
        private final int deflaterStrategy;
        private byte[] dict = new byte[32768];
        private int dict_length;
        private byte[] in_buf = new byte[131072];
        private int in_length;
        private byte[] out_buf = new byte[131112];
        private int out_length;
        private long chksum;

        public Block(int n, int n2) {
            this.deflaterCompLevel = n;
            this.deflaterStrategy = n2;
        }

        @Override
        public Block call() throws IOException {
            State state = (State)STATE.get();
            state.def.reset();
            state.chksum.reset();
            state.buf.reset();
            state.def.setLevel(this.deflaterCompLevel);
            state.def.setStrategy(this.deflaterStrategy);
            state.def.setDictionary(this.dict, 0, this.dict_length);
            state.chksum.update(this.in_buf, 0, this.in_length);
            state.str.write(this.in_buf, 0, this.in_length);
            state.str.flush();
            this.chksum = state.chksum.getValue();
            this.out_length = state.buf.size();
            state.buf.writeTo(this.out_buf);
            return this;
        }

        public String toString() {
            return "Block (in " + this.in_length + "/" + this.in_buf.length + " bytes) (out " + this.out_length + "/" + this.out_buf.length + " bytes)";
        }
    }

    private static class State {
        private final Deflater def = CompressorStreamParallelDeflater.access$000();
        private final ByteArrayOutputStreamExposed buf = new ByteArrayOutputStreamExposed(131112);
        private final DeflaterOutputStream str = CompressorStreamParallelDeflater.access$100(this.buf, this.def);
        private final Adler32 chksum = new Adler32();

        private State() {
        }
    }

    private static class ByteArrayOutputStreamExposed
    extends ByteArrayOutputStream {
        public ByteArrayOutputStreamExposed(int n) {
            super(n);
        }

        public void writeTo(byte[] byArray) {
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
        }
    }
}

