/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.pixels;

import ar.com.hjg.pngj.IdatChunkWriter;
import java.io.OutputStream;

public abstract class CompressorStream
extends OutputStream {
    protected IdatChunkWriter idatChunkWriter;
    public final int blockLen;
    public final long totalbytes;
    boolean closed = false;
    protected boolean done = false;
    protected long bytesIn = 0L;
    protected long bytesOut = 0L;
    protected int block = -1;
    private byte[] firstBytes;
    protected boolean storeFirstByte = false;

    public CompressorStream(IdatChunkWriter idatChunkWriter, int n, long l) {
        this.idatChunkWriter = idatChunkWriter;
        if (n < 0) {
            n = 4096;
        }
        if (l < 0L) {
            l = Long.MAX_VALUE;
        }
        if (n < 1 || l < 1L) {
            throw new RuntimeException(" maxBlockLen or totalLen invalid");
        }
        this.blockLen = n;
        this.totalbytes = l;
    }

    @Override
    public void close() {
        this.done();
        if (this.idatChunkWriter != null) {
            this.idatChunkWriter.close();
        }
        this.closed = true;
    }

    public abstract void done();

    @Override
    public final void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public final void write(byte[] byArray, int n, int n2) {
        ++this.block;
        if (n2 <= this.blockLen) {
            this.mywrite(byArray, n, n2);
            if (this.storeFirstByte && this.block < this.firstBytes.length) {
                this.firstBytes[this.block] = byArray[n];
            }
        } else {
            while (n2 > 0) {
                this.mywrite(byArray, n, this.blockLen);
                n += this.blockLen;
                n2 -= this.blockLen;
            }
        }
        if (this.bytesIn >= this.totalbytes) {
            this.done();
        }
    }

    public abstract void mywrite(byte[] var1, int var2, int var3);

    public final double getCompressionRatio() {
        return this.bytesOut == 0L ? 1.0 : (double)this.bytesOut / (double)this.bytesIn;
    }

    public final long getBytesRaw() {
        return this.bytesIn;
    }

    public final long getBytesCompressed() {
        return this.bytesOut;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isDone() {
        return this.done;
    }

    public byte[] getFirstBytes() {
        return this.firstBytes;
    }

    public void setStoreFirstByte(boolean bl, int n) {
        this.storeFirstByte = bl;
        if (this.storeFirstByte) {
            if (this.firstBytes == null || this.firstBytes.length < n) {
                this.firstBytes = new byte[n];
            }
        } else {
            this.firstBytes = null;
        }
    }

    public void reset() {
        this.done();
        this.bytesIn = 0L;
        this.bytesOut = 0L;
        this.block = -1;
        this.done = false;
    }

    @Override
    public void write(int n) {
        this.write(new byte[]{(byte)n});
    }
}

