/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkPredicate;
import ar.com.hjg.pngj.chunks.ChunksList;
import ar.com.hjg.pngj.chunks.ChunksListForWrite;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkITXT;
import ar.com.hjg.pngj.chunks.PngChunkPHYS;
import ar.com.hjg.pngj.chunks.PngChunkPLTE;
import ar.com.hjg.pngj.chunks.PngChunkTEXT;
import ar.com.hjg.pngj.chunks.PngChunkTIME;
import ar.com.hjg.pngj.chunks.PngChunkTRNS;
import ar.com.hjg.pngj.chunks.PngChunkTextVar;
import ar.com.hjg.pngj.chunks.PngChunkZTXT;
import java.util.ArrayList;
import java.util.List;

public class PngMetadata {
    private final ChunksList chunkList;
    private final boolean readonly;

    public PngMetadata(ChunksList chunksList) {
        this.chunkList = chunksList;
        this.readonly = !(chunksList instanceof ChunksListForWrite);
    }

    public void queueChunk(final PngChunk pngChunk, boolean bl) {
        ChunksListForWrite chunksListForWrite = this.getChunkListW();
        if (this.readonly) {
            throw new PngjException("cannot set chunk : readonly metadata");
        }
        if (bl) {
            ChunkHelper.trimList(chunksListForWrite.getQueuedChunks(), new ChunkPredicate(){

                @Override
                public boolean match(PngChunk pngChunk2) {
                    return ChunkHelper.equivalent(pngChunk, pngChunk2);
                }
            });
        }
        chunksListForWrite.queue(pngChunk);
    }

    public void queueChunk(PngChunk pngChunk) {
        this.queueChunk(pngChunk, true);
    }

    private ChunksListForWrite getChunkListW() {
        return (ChunksListForWrite)this.chunkList;
    }

    public double[] getDpi() {
        PngChunk pngChunk = this.chunkList.getById1("pHYs", true);
        if (pngChunk == null) {
            return new double[]{-1.0, -1.0};
        }
        return ((PngChunkPHYS)pngChunk).getAsDpi2();
    }

    public void setDpi(double d) {
        this.setDpi(d, d);
    }

    public void setDpi(double d, double d2) {
        PngChunkPHYS pngChunkPHYS = new PngChunkPHYS(this.chunkList.imageInfo);
        pngChunkPHYS.setAsDpi2(d, d2);
        this.queueChunk(pngChunkPHYS);
    }

    public long[] getDpm() {
        PngChunk pngChunk = this.chunkList.getById1("pHYs", true);
        if (pngChunk == null) {
            return new long[]{-1L, -1L};
        }
        return ((PngChunkPHYS)pngChunk).getAsDpm2();
    }

    public void setDpm(long l) {
        this.setDpm(l, l);
    }

    public void setDpm(long l, long l2) {
        PngChunkPHYS pngChunkPHYS = new PngChunkPHYS(this.chunkList.imageInfo);
        pngChunkPHYS.setAsDpm2(l, l2);
        this.queueChunk(pngChunkPHYS);
    }

    public PngChunkTIME setTimeNow(int n) {
        PngChunkTIME pngChunkTIME = new PngChunkTIME(this.chunkList.imageInfo);
        pngChunkTIME.setNow(n);
        this.queueChunk(pngChunkTIME);
        return pngChunkTIME;
    }

    public PngChunkTIME setTimeNow() {
        return this.setTimeNow(0);
    }

    public PngChunkTIME setTimeYMDHMS(int n, int n2, int n3, int n4, int n5, int n6) {
        PngChunkTIME pngChunkTIME = new PngChunkTIME(this.chunkList.imageInfo);
        pngChunkTIME.setYMDHMS(n, n2, n3, n4, n5, n6);
        this.queueChunk(pngChunkTIME, true);
        return pngChunkTIME;
    }

    public PngChunkTIME getTime() {
        return (PngChunkTIME)this.chunkList.getById1("tIME");
    }

    public String getTimeAsString() {
        PngChunkTIME pngChunkTIME = this.getTime();
        return pngChunkTIME == null ? "" : pngChunkTIME.getAsString();
    }

    public PngChunkTextVar setText(String string, String string2, boolean bl, boolean bl2) {
        if (bl2 && !bl) {
            throw new PngjException("cannot compress non latin text");
        }
        PngChunkTextVar pngChunkTextVar = bl ? (bl2 ? new PngChunkZTXT(this.chunkList.imageInfo) : new PngChunkTEXT(this.chunkList.imageInfo)) : new PngChunkITXT(this.chunkList.imageInfo);
        pngChunkTextVar.setKeyVal(string, string2);
        this.queueChunk(pngChunkTextVar, true);
        return pngChunkTextVar;
    }

    public PngChunkTextVar setText(String string, String string2) {
        return this.setText(string, string2, false, false);
    }

    public List<? extends PngChunkTextVar> getTxtsForKey(String string) {
        ArrayList<? extends PngChunk> arrayList = new ArrayList<PngChunk>();
        arrayList.addAll(this.chunkList.getById("tEXt", string));
        arrayList.addAll(this.chunkList.getById("zTXt", string));
        arrayList.addAll(this.chunkList.getById("iTXt", string));
        return arrayList;
    }

    public String getTxtForKey(String string) {
        List<? extends PngChunkTextVar> list = this.getTxtsForKey(string);
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (PngChunkTextVar pngChunkTextVar : list) {
            stringBuilder.append(pngChunkTextVar.getVal()).append("\n");
        }
        return stringBuilder.toString().trim();
    }

    public PngChunkPLTE getPLTE() {
        return (PngChunkPLTE)this.chunkList.getById1("PLTE");
    }

    public PngChunkPLTE createPLTEChunk() {
        PngChunkPLTE pngChunkPLTE = new PngChunkPLTE(this.chunkList.imageInfo);
        this.queueChunk(pngChunkPLTE);
        return pngChunkPLTE;
    }

    public PngChunkTRNS getTRNS() {
        return (PngChunkTRNS)this.chunkList.getById1("tRNS");
    }

    public PngChunkTRNS createTRNSChunk() {
        PngChunkTRNS pngChunkTRNS = new PngChunkTRNS(this.chunkList.imageInfo);
        this.queueChunk(pngChunkTRNS);
        return pngChunkTRNS;
    }
}

