/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkSingle;

public class PngChunkTRNS
extends PngChunkSingle {
    public static final String ID = "tRNS";
    private int gray;
    private int red;
    private int green;
    private int blue;
    private int[] paletteAlpha = new int[0];

    public PngChunkTRNS(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.AFTER_PLTE_BEFORE_IDAT;
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = null;
        if (this.imgInfo.greyscale) {
            chunkRaw = this.createEmptyChunk(2, true);
            PngHelperInternal.writeInt2tobytes(this.gray, chunkRaw.data, 0);
        } else if (this.imgInfo.indexed) {
            chunkRaw = this.createEmptyChunk(this.paletteAlpha.length, true);
            for (int i = 0; i < chunkRaw.len; ++i) {
                chunkRaw.data[i] = (byte)this.paletteAlpha[i];
            }
        } else {
            chunkRaw = this.createEmptyChunk(6, true);
            PngHelperInternal.writeInt2tobytes(this.red, chunkRaw.data, 0);
            PngHelperInternal.writeInt2tobytes(this.green, chunkRaw.data, 0);
            PngHelperInternal.writeInt2tobytes(this.blue, chunkRaw.data, 0);
        }
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        if (this.imgInfo.greyscale) {
            this.gray = PngHelperInternal.readInt2fromBytes(chunkRaw.data, 0);
        } else if (this.imgInfo.indexed) {
            int n = chunkRaw.data.length;
            this.paletteAlpha = new int[n];
            for (int i = 0; i < n; ++i) {
                this.paletteAlpha[i] = chunkRaw.data[i] & 0xFF;
            }
        } else {
            this.red = PngHelperInternal.readInt2fromBytes(chunkRaw.data, 0);
            this.green = PngHelperInternal.readInt2fromBytes(chunkRaw.data, 2);
            this.blue = PngHelperInternal.readInt2fromBytes(chunkRaw.data, 4);
        }
    }

    public void setRGB(int n, int n2, int n3) {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        this.red = n;
        this.green = n2;
        this.blue = n3;
    }

    public int[] getRGB() {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        return new int[]{this.red, this.green, this.blue};
    }

    public int getRGB888() {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        return this.red << 16 | this.green << 8 | this.blue;
    }

    public void setGray(int n) {
        if (!this.imgInfo.greyscale) {
            throw new PngjException("only grayscale images support this");
        }
        this.gray = n;
    }

    public int getGray() {
        if (!this.imgInfo.greyscale) {
            throw new PngjException("only grayscale images support this");
        }
        return this.gray;
    }

    public void setEntryPalAlpha(int n, int n2) {
        this.paletteAlpha[n] = n2;
    }

    public void setNentriesPalAlpha(int n) {
        this.paletteAlpha = new int[n];
    }

    public void setPalAlpha(int[] nArray) {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed images support this");
        }
        this.paletteAlpha = nArray;
    }

    public int[] getPalletteAlpha() {
        return this.paletteAlpha;
    }

    public void setIndexEntryAsTransparent(int n) {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed images support this");
        }
        this.paletteAlpha = new int[]{n + 1};
        for (int i = 0; i < n; ++i) {
            this.paletteAlpha[i] = 255;
        }
        this.paletteAlpha[n] = 0;
    }
}

