/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkMultiple;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PngChunkSPLT
extends PngChunkMultiple {
    public static final String ID = "sPLT";
    private String palName;
    private int sampledepth;
    private int[] palette;

    public PngChunkSPLT(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_IDAT;
    }

    @Override
    public ChunkRaw createRawChunk() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(ChunkHelper.toBytesLatin1(this.palName));
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write((byte)this.sampledepth);
            int n = this.getNentries();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (this.sampledepth == 8) {
                        PngHelperInternal.writeByte((OutputStream)byteArrayOutputStream, (byte)this.palette[i * 5 + j]);
                        continue;
                    }
                    PngHelperInternal.writeInt2(byteArrayOutputStream, this.palette[i * 5 + j]);
                }
                PngHelperInternal.writeInt2(byteArrayOutputStream, this.palette[i * 5 + 4]);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ChunkRaw chunkRaw = this.createEmptyChunk(byArray.length, false);
            chunkRaw.data = byArray;
            return chunkRaw;
        }
        catch (IOException iOException) {
            throw new PngjException(iOException);
        }
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        int n;
        int n2 = -1;
        for (n = 0; n < chunkRaw.data.length; ++n) {
            if (chunkRaw.data[n] != 0) continue;
            n2 = n;
            break;
        }
        if (n2 <= 0 || n2 > chunkRaw.data.length - 2) {
            throw new PngjException("bad sPLT chunk: no separator found");
        }
        this.palName = ChunkHelper.toStringLatin1(chunkRaw.data, 0, n2);
        this.sampledepth = PngHelperInternal.readInt1fromByte(chunkRaw.data, n2 + 1);
        n = (chunkRaw.data.length - (n2 += 2)) / (this.sampledepth == 8 ? 6 : 10);
        this.palette = new int[n * 5];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5;
            int n6;
            int n7;
            if (this.sampledepth == 8) {
                n7 = PngHelperInternal.readInt1fromByte(chunkRaw.data, n2++);
                n6 = PngHelperInternal.readInt1fromByte(chunkRaw.data, n2++);
                n5 = PngHelperInternal.readInt1fromByte(chunkRaw.data, n2++);
                n4 = PngHelperInternal.readInt1fromByte(chunkRaw.data, n2++);
            } else {
                n7 = PngHelperInternal.readInt2fromBytes(chunkRaw.data, n2);
                n6 = PngHelperInternal.readInt2fromBytes(chunkRaw.data, n2 += 2);
                n5 = PngHelperInternal.readInt2fromBytes(chunkRaw.data, n2 += 2);
                n4 = PngHelperInternal.readInt2fromBytes(chunkRaw.data, n2 += 2);
                n2 += 2;
            }
            int n8 = PngHelperInternal.readInt2fromBytes(chunkRaw.data, n2);
            n2 += 2;
            this.palette[n3++] = n7;
            this.palette[n3++] = n6;
            this.palette[n3++] = n5;
            this.palette[n3++] = n4;
            this.palette[n3++] = n8;
        }
    }

    public int getNentries() {
        return this.palette.length / 5;
    }

    public String getPalName() {
        return this.palName;
    }

    public void setPalName(String string) {
        this.palName = string;
    }

    public int getSampledepth() {
        return this.sampledepth;
    }

    public void setSampledepth(int n) {
        this.sampledepth = n;
    }

    public int[] getPalette() {
        return this.palette;
    }

    public void setPalette(int[] nArray) {
        this.palette = nArray;
    }
}

