/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkMultiple;

public class PngChunkFDAT
extends PngChunkMultiple {
    public static final String ID = "fdAT";
    private int seqNum;
    private byte[] buffer;
    int datalen;

    public PngChunkFDAT(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.AFTER_IDAT;
    }

    @Override
    public ChunkRaw createRawChunk() {
        if (this.buffer == null) {
            throw new PngjException("not buffered");
        }
        ChunkRaw chunkRaw = this.createEmptyChunk(this.datalen + 4, false);
        chunkRaw.data = this.buffer;
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        this.seqNum = PngHelperInternal.readInt4fromBytes(chunkRaw.data, 0);
        this.datalen = chunkRaw.len - 4;
        this.buffer = chunkRaw.data;
    }

    public int getSeqNum() {
        return this.seqNum;
    }

    public void setSeqNum(int n) {
        this.seqNum = n;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void setBuffer(byte[] byArray) {
        this.buffer = byArray;
    }

    public int getDatalen() {
        return this.datalen;
    }

    public void setDatalen(int n) {
        this.datalen = n;
    }
}

