/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkMultiple;

public class PngChunkFCTL
extends PngChunkMultiple {
    public static final String ID = "fcTL";
    public static final byte APNG_DISPOSE_OP_NONE = 0;
    public static final byte APNG_DISPOSE_OP_BACKGROUND = 1;
    public static final byte APNG_DISPOSE_OP_PREVIOUS = 2;
    public static final byte APNG_BLEND_OP_SOURCE = 0;
    public static final byte APNG_BLEND_OP_OVER = 1;
    private int seqNum;
    private int width;
    private int height;
    private int xOff;
    private int yOff;
    private int delayNum;
    private int delayDen;
    private byte disposeOp;
    private byte blendOp;

    public PngChunkFCTL(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    public ImageInfo getEquivImageInfo() {
        return new ImageInfo(this.width, this.height, this.imgInfo.bitDepth, this.imgInfo.alpha, this.imgInfo.greyscale, this.imgInfo.indexed);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.NONE;
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = this.createEmptyChunk(8, true);
        int n = 0;
        PngHelperInternal.writeInt4tobytes(this.seqNum, chunkRaw.data, n);
        PngHelperInternal.writeInt4tobytes(this.width, chunkRaw.data, n += 4);
        PngHelperInternal.writeInt4tobytes(this.height, chunkRaw.data, n += 4);
        PngHelperInternal.writeInt4tobytes(this.xOff, chunkRaw.data, n += 4);
        PngHelperInternal.writeInt4tobytes(this.yOff, chunkRaw.data, n += 4);
        PngHelperInternal.writeInt2tobytes(this.delayNum, chunkRaw.data, n += 4);
        PngHelperInternal.writeInt2tobytes(this.delayDen, chunkRaw.data, n += 2);
        chunkRaw.data[n += 2] = this.disposeOp;
        chunkRaw.data[++n] = this.blendOp;
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        int n = 0;
        this.seqNum = PngHelperInternal.readInt4fromBytes(chunkRaw.data, n);
        this.width = PngHelperInternal.readInt4fromBytes(chunkRaw.data, n += 4);
        this.height = PngHelperInternal.readInt4fromBytes(chunkRaw.data, n += 4);
        this.xOff = PngHelperInternal.readInt4fromBytes(chunkRaw.data, n += 4);
        this.yOff = PngHelperInternal.readInt4fromBytes(chunkRaw.data, n += 4);
        this.delayNum = PngHelperInternal.readInt2fromBytes(chunkRaw.data, n += 4);
        this.delayDen = PngHelperInternal.readInt2fromBytes(chunkRaw.data, n += 2);
        this.disposeOp = chunkRaw.data[n += 2];
        this.blendOp = chunkRaw.data[++n];
    }

    public int getSeqNum() {
        return this.seqNum;
    }

    public void setSeqNum(int n) {
        this.seqNum = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getxOff() {
        return this.xOff;
    }

    public void setxOff(int n) {
        this.xOff = n;
    }

    public int getyOff() {
        return this.yOff;
    }

    public void setyOff(int n) {
        this.yOff = n;
    }

    public int getDelayNum() {
        return this.delayNum;
    }

    public void setDelayNum(int n) {
        this.delayNum = n;
    }

    public int getDelayDen() {
        return this.delayDen;
    }

    public void setDelayDen(int n) {
        this.delayDen = n;
    }

    public byte getDisposeOp() {
        return this.disposeOp;
    }

    public void setDisposeOp(byte by) {
        this.disposeOp = by;
    }

    public byte getBlendOp() {
        return this.blendOp;
    }

    public void setBlendOp(byte by) {
        this.blendOp = by;
    }
}

