/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkSingle;

public class PngChunkACTL
extends PngChunkSingle {
    public static final String ID = "acTL";
    private int numFrames;
    private int numPlays;

    public PngChunkACTL(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_IDAT;
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = this.createEmptyChunk(8, true);
        PngHelperInternal.writeInt4tobytes(this.numFrames, chunkRaw.data, 0);
        PngHelperInternal.writeInt4tobytes(this.numPlays, chunkRaw.data, 4);
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        this.numFrames = PngHelperInternal.readInt4fromBytes(chunkRaw.data, 0);
        this.numPlays = PngHelperInternal.readInt4fromBytes(chunkRaw.data, 4);
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public void setNumFrames(int n) {
        this.numFrames = n;
    }

    public int getNumPlays() {
        return this.numPlays;
    }

    public void setNumPlays(int n) {
        this.numPlays = n;
    }
}

