/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjBadCrcException;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkRaw {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ChunkRaw.class.getName());
    public final int len;
    public final byte[] idbytes;
    public final String id;
    public byte[] data = null;
    private long offset = 0L;
    public byte[] crcval = new byte[4];
    private CRC32 crcengine;

    public ChunkRaw(int n, String string, boolean bl) {
        this.len = n;
        this.id = string;
        this.idbytes = ChunkHelper.toBytesLatin1(string);
        for (int i = 0; i < 4; ++i) {
            if (this.idbytes[i] >= 65 && this.idbytes[i] <= 122 && (this.idbytes[i] <= 90 || this.idbytes[i] >= 97)) continue;
            throw new PngjException("Bad id chunk: must be ascii letters " + string);
        }
        if (bl) {
            this.allocData();
        }
    }

    public ChunkRaw(int n, byte[] byArray, boolean bl) {
        this(n, ChunkHelper.toStringLatin1(byArray), bl);
    }

    public void allocData() {
        if (this.data == null || this.data.length < this.len) {
            this.data = new byte[this.len];
        }
    }

    private void computeCrcForWriting() {
        this.crcengine = new CRC32();
        this.crcengine.update(this.idbytes, 0, 4);
        if (this.len > 0) {
            this.crcengine.update(this.data, 0, this.len);
        }
        PngHelperInternal.writeInt4tobytes((int)this.crcengine.getValue(), this.crcval, 0);
    }

    public void writeChunk(OutputStream outputStream) {
        this.writeChunkHeader(outputStream);
        if (this.len > 0) {
            if (this.data == null) {
                throw new PngjOutputException("cannot write chunk, raw chunk data is null [" + this.id + "]");
            }
            PngHelperInternal.writeBytes(outputStream, this.data, 0, this.len);
        }
        this.computeCrcForWriting();
        this.writeChunkCrc(outputStream);
    }

    public void writeChunkHeader(OutputStream outputStream) {
        if (this.idbytes.length != 4) {
            throw new PngjOutputException("bad chunkid [" + this.id + "]");
        }
        PngHelperInternal.writeInt4(outputStream, this.len);
        PngHelperInternal.writeBytes(outputStream, this.idbytes);
    }

    public void writeChunkCrc(OutputStream outputStream) {
        PngHelperInternal.writeBytes(outputStream, this.crcval, 0, 4);
    }

    public void checkCrc(boolean bl) {
        int n;
        int n2 = (int)this.crcengine.getValue();
        if (n2 != (n = PngHelperInternal.readInt4fromBytes(this.crcval, 0))) {
            String string = String.format("Bad CRC in chunk: %s (offset:%d). Expected:%x Got:%x", this.id, this.offset, n, n2);
            if (bl) {
                throw new PngjBadCrcException(string);
            }
            LOGGER.warn(string);
        }
    }

    public void updateCrc(byte[] byArray, int n, int n2) {
        if (this.crcengine == null) {
            this.crcengine = new CRC32();
        }
        this.crcengine.update(byArray, n, n2);
    }

    ByteArrayInputStream getAsByteStream() {
        return new ByteArrayInputStream(this.data);
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long l) {
        this.offset = l;
    }

    public String toString() {
        return "chunkid=" + ChunkHelper.toStringLatin1(this.idbytes) + " len=" + this.len;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.id == null ? 0 : this.id.hashCode());
        n = 31 * n + (int)(this.offset ^ this.offset >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ChunkRaw chunkRaw = (ChunkRaw)object;
        if (this.id == null ? chunkRaw.id != null : !this.id.equals(chunkRaw.id)) {
            return false;
        }
        return this.offset == chunkRaw.offset;
    }
}

