/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.BufferedStreamFeeder;
import ar.com.hjg.pngj.ChunkReader;
import ar.com.hjg.pngj.ChunkSeqReaderPng;
import ar.com.hjg.pngj.chunks.PngChunk;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class PngReaderFilter
extends FilterInputStream {
    private ChunkSeqReaderPng chunkseq = this.createChunkSequenceReader();

    public PngReaderFilter(InputStream inputStream) {
        super(inputStream);
    }

    protected ChunkSeqReaderPng createChunkSequenceReader() {
        return new ChunkSeqReaderPng(true){

            @Override
            public boolean shouldSkipContent(int n, String string) {
                return super.shouldSkipContent(n, string) || string.equals("IDAT");
            }

            @Override
            protected boolean shouldCheckCrc(int n, String string) {
                return false;
            }

            @Override
            protected void postProcessChunk(ChunkReader chunkReader) {
                super.postProcessChunk(chunkReader);
            }
        };
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.chunkseq.close();
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n > 0) {
            this.chunkseq.feedAll(new byte[]{(byte)n}, 0, 1);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.chunkseq.feedAll(byArray, n, n3);
        }
        return n3;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = super.read(byArray);
        if (n > 0) {
            this.chunkseq.feedAll(byArray, 0, n);
        }
        return n;
    }

    public void readUntilEndAndClose() throws IOException {
        BufferedStreamFeeder bufferedStreamFeeder = new BufferedStreamFeeder(this.in);
        while (!this.chunkseq.isDone() && bufferedStreamFeeder.hasPendingBytes() && bufferedStreamFeeder.feed(this.chunkseq) >= 1) {
        }
        bufferedStreamFeeder.close();
        this.close();
    }

    public List<PngChunk> getChunksList() {
        return this.chunkseq.getChunks();
    }

    public ChunkSeqReaderPng getChunkseq() {
        return this.chunkseq;
    }
}

