/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.BufferedStreamFeeder;
import ar.com.hjg.pngj.ChunkSeqReaderPng;
import ar.com.hjg.pngj.ErrorBehaviour;
import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.IImageLineSet;
import ar.com.hjg.pngj.IImageLineSetFactory;
import ar.com.hjg.pngj.IdatSet;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLineSetDefault;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjInputException;
import ar.com.hjg.pngj.chunks.ChunkLoadBehaviour;
import ar.com.hjg.pngj.chunks.ChunksList;
import ar.com.hjg.pngj.chunks.PngMetadata;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PngReader
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PngReader.class.getName());
    public static final long MAX_TOTAL_BYTES_READ_DEFAULT = 901001001L;
    public static final long MAX_BYTES_METADATA_DEFAULT = 5024024L;
    public static final long MAX_CHUNK_SIZE_SKIP = 2024024L;
    public final ImageInfo imgInfo;
    public final boolean interlaced;
    protected final ChunkSeqReaderPng chunkseq;
    protected final BufferedStreamFeeder streamFeeder;
    protected final PngMetadata metadata;
    protected int rowNum = -1;
    protected IImageLineSet<? extends IImageLine> imlinesSet;
    private IImageLineSetFactory<? extends IImageLine> imageLineSetFactory;
    CRC32 idatCrca;
    Adler32 idatCrcb;
    protected ErrorBehaviour errorBehaviour = ErrorBehaviour.STRICT;

    public PngReader(InputStream inputStream) {
        this(inputStream, true);
    }

    public PngReader(InputStream inputStream, boolean bl) {
        this.streamFeeder = new BufferedStreamFeeder(inputStream);
        this.streamFeeder.setCloseStream(bl);
        this.chunkseq = this.createChunkSeqReader();
        try {
            if (this.streamFeeder.feedFixed(this.chunkseq, 36) != 36) {
                throw new PngjInputException("Could not read first 36 bytes (PNG signature+IHDR chunk)");
            }
            this.imgInfo = this.chunkseq.getImageInfo();
            this.interlaced = this.chunkseq.getDeinterlacer() != null;
            this.setMaxBytesMetadata(5024024L);
            this.setMaxTotalBytesRead(901001001L);
            this.setSkipChunkMaxSize(2024024L);
            this.chunkseq.addChunkToSkip("fdAT");
            this.chunkseq.addChunkToSkip("fcTL");
            this.metadata = new PngMetadata(this.chunkseq.chunksList);
            this.setLineSetFactory(ImageLineSetDefault.getFactoryInt());
            this.rowNum = -1;
        }
        catch (RuntimeException runtimeException) {
            this.streamFeeder.close();
            this.chunkseq.close();
            throw runtimeException;
        }
    }

    public PngReader(File file) {
        this(PngHelperInternal.istreamFromFile(file), true);
    }

    protected void readFirstChunks() {
        while (this.chunkseq.currentChunkGroup < 4) {
            if (this.streamFeeder.feed(this.chunkseq) > 0) continue;
            throw new PngjInputException("Premature ending reading first chunks");
        }
    }

    public void setChunkLoadBehaviour(ChunkLoadBehaviour chunkLoadBehaviour) {
        this.chunkseq.setChunkLoadBehaviour(chunkLoadBehaviour);
    }

    public ChunksList getChunksList() {
        return this.getChunksList(true);
    }

    public ChunksList getChunksList(boolean bl) {
        if (bl && this.chunkseq.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        return this.chunkseq.chunksList;
    }

    int getCurrentChunkGroup() {
        return this.chunkseq.currentChunkGroup;
    }

    public PngMetadata getMetadata() {
        if (this.chunkseq.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        return this.metadata;
    }

    public IImageLine readRow() {
        return this.readRow(this.rowNum + 1);
    }

    public boolean hasMoreRows() {
        return this.rowNum < this.getCurImgInfo().rows - 1;
    }

    public IImageLine readRow(int n) {
        if (this.chunkseq.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        if (!this.interlaced) {
            if (this.imlinesSet == null) {
                this.imlinesSet = this.createLineSet(true, -1, 0, 1);
            }
            IImageLine iImageLine = this.imlinesSet.getImageLine(n);
            if (n == this.rowNum) {
                return iImageLine;
            }
            if (n < this.rowNum) {
                throw new PngjInputException("rows must be read in increasing order: " + n);
            }
            while (this.rowNum < n) {
                while (!this.chunkseq.getIdatSet().isRowReady()) {
                    if (this.streamFeeder.feed(this.chunkseq) >= 1) continue;
                    throw new PngjInputException("premature ending");
                }
                ++this.rowNum;
                this.chunkseq.getIdatSet().updateCrcs(this.idatCrca, this.idatCrcb);
                if (this.rowNum == n) {
                    iImageLine.readFromPngRaw(this.chunkseq.getIdatSet().getUnfilteredRow(), this.getCurImgInfo().bytesPerRow + 1, 0, 1);
                    iImageLine.endReadFromPngRaw();
                }
                this.chunkseq.getIdatSet().advanceToNextRow();
            }
            return iImageLine;
        }
        if (this.imlinesSet == null) {
            this.imlinesSet = this.createLineSet(false, this.getCurImgInfo().rows, 0, 1);
            this.loadAllInterlaced(this.getCurImgInfo().rows, 0, 1);
        }
        this.rowNum = n;
        return this.imlinesSet.getImageLine(n);
    }

    public IImageLineSet<? extends IImageLine> readRows() {
        return this.readRows(this.getCurImgInfo().rows, 0, 1);
    }

    public IImageLineSet<? extends IImageLine> readRows(int n, int n2, int n3) {
        if (this.chunkseq.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        if (n < 0) {
            n = (this.getCurImgInfo().rows - n2) / n3;
        }
        if (n3 < 1 || n2 < 0 || n == 0 || (n - 1) * n3 + 1 + n2 > this.getCurImgInfo().rows) {
            throw new PngjInputException("bad args");
        }
        if (this.rowNum >= n2) {
            throw new PngjInputException("readRows cannot be mixed with readRow");
        }
        this.imlinesSet = this.createLineSet(false, n, n2, n3);
        if (!this.interlaced) {
            int n4 = -1;
            while (n4 < n - 1) {
                while (!this.chunkseq.getIdatSet().isRowReady()) {
                    if (this.streamFeeder.feed(this.chunkseq) >= 1) continue;
                    throw new PngjInputException("Premature ending");
                }
                ++this.rowNum;
                this.chunkseq.getIdatSet().updateCrcs(this.idatCrca, this.idatCrcb);
                n4 = (this.rowNum - n2) / n3;
                if (this.rowNum >= n2 && n3 * n4 + n2 == this.rowNum) {
                    IImageLine iImageLine = this.imlinesSet.getImageLine(this.rowNum);
                    iImageLine.readFromPngRaw(this.chunkseq.getIdatSet().getUnfilteredRow(), this.getCurImgInfo().bytesPerRow + 1, 0, 1);
                    iImageLine.endReadFromPngRaw();
                }
                this.chunkseq.getIdatSet().advanceToNextRow();
            }
        } else {
            this.loadAllInterlaced(n, n2, n3);
        }
        this.chunkseq.getIdatSet().markAsDone();
        return this.imlinesSet;
    }

    public void setLineSetFactory(IImageLineSetFactory<? extends IImageLine> iImageLineSetFactory) {
        this.imageLineSetFactory = iImageLineSetFactory;
    }

    protected IImageLineSet<? extends IImageLine> createLineSet(boolean bl, int n, int n2, int n3) {
        return this.imageLineSetFactory.create(this.getCurImgInfo(), bl, n, n2, n3);
    }

    protected void loadAllInterlaced(int n, int n2, int n3) {
        int n4;
        int n5;
        IdatSet idatSet = this.chunkseq.getIdatSet();
        int n6 = 0;
        while (true) {
            if (!this.chunkseq.getIdatSet().isRowReady() && this.streamFeeder.feed(this.chunkseq) > 0) {
                continue;
            }
            if (!this.chunkseq.getIdatSet().isRowReady()) {
                throw new PngjInputException("Premature ending?");
            }
            this.chunkseq.getIdatSet().updateCrcs(this.idatCrca, this.idatCrcb);
            n5 = idatSet.rowinfo.rowNreal;
            n4 = this.imlinesSet.hasImageLine(n5);
            if (n4 != 0) {
                this.imlinesSet.getImageLine(n5).readFromPngRaw(idatSet.getUnfilteredRow(), idatSet.rowinfo.buflen, idatSet.rowinfo.oX, idatSet.rowinfo.dX);
                ++n6;
            }
            idatSet.advanceToNextRow();
            if (n6 >= n && idatSet.isDone()) break;
        }
        idatSet.markAsDone();
        n5 = 0;
        n4 = n2;
        while (n5 < n) {
            this.imlinesSet.getImageLine(n4).endReadFromPngRaw();
            ++n5;
            n4 += n3;
        }
    }

    public void readSkippingAllRows() {
        this.setCrcCheckDisabled();
        this.chunkseq.addChunkToSkip("IDAT");
        this.chunkseq.addChunkToSkip("fdAT");
        if (this.chunkseq.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        this.end();
    }

    public void setMaxTotalBytesRead(long l) {
        this.chunkseq.setMaxTotalBytesRead(l);
    }

    public void setMaxBytesMetadata(long l) {
        this.chunkseq.setMaxBytesMetadata(l);
    }

    public void setSkipChunkMaxSize(long l) {
        this.chunkseq.setSkipChunkMaxSize(l);
    }

    public void setChunksToSkip(String ... stringArray) {
        this.chunkseq.setChunksToSkip(stringArray);
    }

    public void addChunkToSkip(String string) {
        this.chunkseq.addChunkToSkip(string);
    }

    public void dontSkipChunk(String string) {
        this.chunkseq.dontSkipChunk(string);
    }

    public void setShouldCloseStream(boolean bl) {
        this.streamFeeder.setCloseStream(bl);
    }

    public void end() {
        try {
            if (this.chunkseq.firstChunksNotYetRead()) {
                this.readFirstChunks();
            }
            if (this.chunkseq.getIdatSet() != null && !this.chunkseq.getIdatSet().isDone()) {
                this.chunkseq.getIdatSet().markAsDone();
            }
            while (!this.chunkseq.isDone() && this.streamFeeder.feed(this.chunkseq) > 0) {
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        try {
            if (this.chunkseq != null) {
                this.chunkseq.close();
            }
        }
        catch (Exception exception) {
            LOGGER.warn("error closing chunk sequence:" + exception.getMessage());
        }
        if (this.streamFeeder != null) {
            this.streamFeeder.close();
        }
    }

    public boolean isInterlaced() {
        return this.interlaced;
    }

    public void setCrcCheckDisabled() {
        this.chunkseq.setCheckCrc(false);
    }

    public ChunkSeqReaderPng getChunkseq() {
        return this.chunkseq;
    }

    protected ChunkSeqReaderPng createChunkSeqReader() {
        return new ChunkSeqReaderPng(false);
    }

    public void prepareSimpleDigestComputation() {
        if (this.idatCrca == null) {
            this.idatCrca = new CRC32();
        } else {
            this.idatCrca.reset();
        }
        if (this.idatCrcb == null) {
            this.idatCrcb = new Adler32();
        } else {
            this.idatCrcb.reset();
        }
        this.imgInfo.updateCrc(this.idatCrca);
        this.idatCrcb.update((byte)this.imgInfo.rows);
    }

    long getSimpleDigest() {
        if (this.idatCrca == null) {
            return 0L;
        }
        return this.idatCrca.getValue() ^ this.idatCrcb.getValue() << 31;
    }

    public String getSimpleDigestHex() {
        return String.format("%016X", this.getSimpleDigest());
    }

    public String toString() {
        return this.imgInfo.toString() + " interlaced=" + this.interlaced;
    }

    public String toStringCompact() {
        return this.imgInfo.toStringBrief() + (this.interlaced ? "i" : "");
    }

    public ImageInfo getImgInfo() {
        return this.imgInfo;
    }

    public ImageInfo getCurImgInfo() {
        return this.chunkseq.getCurImgInfo();
    }

    public void setErrorBehaviour(ErrorBehaviour errorBehaviour) {
        this.errorBehaviour = errorBehaviour;
        this.chunkseq.setErrorBehaviour(errorBehaviour);
    }

    public boolean isDone() {
        return this.chunkseq.isDone();
    }
}

