/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.IImageLineFactory;
import ar.com.hjg.pngj.IImageLineSet;
import ar.com.hjg.pngj.IImageLineSetFactory;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLineByte;
import ar.com.hjg.pngj.ImageLineInt;
import ar.com.hjg.pngj.PngjException;
import java.util.ArrayList;
import java.util.List;

public abstract class ImageLineSetDefault<T extends IImageLine>
implements IImageLineSet<T> {
    protected final ImageInfo imgInfo;
    private final boolean singleCursor;
    private final int nlines;
    private final int offset;
    private final int step;
    protected List<T> imageLines;
    protected T imageLine;
    protected int currentRow = -1;

    public ImageLineSetDefault(ImageInfo imageInfo, boolean bl, int n, int n2, int n3) {
        this.imgInfo = imageInfo;
        this.singleCursor = bl;
        if (bl) {
            this.nlines = 1;
            this.offset = 0;
            this.step = 1;
        } else {
            this.nlines = n;
            this.offset = n2;
            this.step = n3;
        }
        this.createImageLines();
    }

    private void createImageLines() {
        if (this.singleCursor) {
            this.imageLine = this.createImageLine();
        } else {
            this.imageLines = new ArrayList<T>();
            for (int i = 0; i < this.nlines; ++i) {
                this.imageLines.add(this.createImageLine());
            }
        }
    }

    protected abstract T createImageLine();

    public T getImageLine(int n) {
        this.currentRow = n;
        if (this.singleCursor) {
            return this.imageLine;
        }
        int n2 = this.imageRowToMatrixRowStrict(n);
        if (n2 < 0) {
            throw new PngjException("Invalid row number");
        }
        return (T)((IImageLine)this.imageLines.get(n2));
    }

    public T getImageLineRawNum(int n) {
        if (this.singleCursor) {
            return this.imageLine;
        }
        return (T)((IImageLine)this.imageLines.get(n));
    }

    @Override
    public boolean hasImageLine(int n) {
        return this.singleCursor ? this.currentRow == n : this.imageRowToMatrixRowStrict(n) >= 0;
    }

    @Override
    public int size() {
        return this.nlines;
    }

    public int imageRowToMatrixRowStrict(int n) {
        int n2 = (n -= this.offset) >= 0 && (this.step == 1 || n % this.step == 0) ? n / this.step : -1;
        return n2 < this.nlines ? n2 : -1;
    }

    public int matrixRowToImageRow(int n) {
        return n * this.step + this.offset;
    }

    public int imageRowToMatrixRow(int n) {
        int n2 = (n - this.offset) / this.step;
        return n2 < 0 ? 0 : (n2 < this.nlines ? n2 : this.nlines - 1);
    }

    public static <T extends IImageLine> IImageLineSetFactory<T> createImageLineSetFactoryFromImageLineFactory(final IImageLineFactory<T> iImageLineFactory) {
        return new IImageLineSetFactory<T>(){

            @Override
            public IImageLineSet<T> create(final ImageInfo imageInfo, boolean bl, int n, int n2, int n3) {
                return new ImageLineSetDefault<T>(imageInfo, bl, n, n2, n3){

                    @Override
                    protected T createImageLine() {
                        return iImageLineFactory.createImageLine(imageInfo);
                    }
                };
            }
        };
    }

    public static IImageLineSetFactory<ImageLineInt> getFactoryInt() {
        return ImageLineSetDefault.createImageLineSetFactoryFromImageLineFactory(ImageLineInt.getFactory());
    }

    public static IImageLineSetFactory<ImageLineByte> getFactoryByte() {
        return ImageLineSetDefault.createImageLineSetFactoryFromImageLineFactory(ImageLineByte.getFactory());
    }
}

