/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.IImageLineArray;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLineByte;
import ar.com.hjg.pngj.ImageLineInt;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.PngjUnsupportedException;
import ar.com.hjg.pngj.chunks.PngChunkPLTE;
import ar.com.hjg.pngj.chunks.PngChunkTRNS;
import java.util.Arrays;

public class ImageLineHelper {
    static int[] DEPTH_UNPACK_1;
    static int[] DEPTH_UNPACK_2;
    static int[] DEPTH_UNPACK_4;
    static int[][] DEPTH_UNPACK;

    private static void initDepthScale() {
        int n;
        DEPTH_UNPACK_1 = new int[2];
        for (n = 0; n < 2; ++n) {
            ImageLineHelper.DEPTH_UNPACK_1[n] = n * 255;
        }
        DEPTH_UNPACK_2 = new int[4];
        for (n = 0; n < 4; ++n) {
            ImageLineHelper.DEPTH_UNPACK_2[n] = n * 255 / 3;
        }
        DEPTH_UNPACK_4 = new int[16];
        for (n = 0; n < 16; ++n) {
            ImageLineHelper.DEPTH_UNPACK_4[n] = n * 255 / 15;
        }
        DEPTH_UNPACK = new int[][]{null, DEPTH_UNPACK_1, DEPTH_UNPACK_2, null, DEPTH_UNPACK_4};
    }

    public static void scaleUp(IImageLineArray iImageLineArray) {
        if (iImageLineArray.getImageInfo().indexed || iImageLineArray.getImageInfo().bitDepth >= 8) {
            return;
        }
        int[] nArray = DEPTH_UNPACK[iImageLineArray.getImageInfo().bitDepth];
        if (iImageLineArray instanceof ImageLineInt) {
            ImageLineInt imageLineInt = (ImageLineInt)iImageLineArray;
            for (int i = 0; i < imageLineInt.getSize(); ++i) {
                imageLineInt.scanline[i] = nArray[imageLineInt.scanline[i]];
            }
        } else if (iImageLineArray instanceof ImageLineByte) {
            ImageLineByte imageLineByte = (ImageLineByte)iImageLineArray;
            for (int i = 0; i < imageLineByte.getSize(); ++i) {
                imageLineByte.scanline[i] = (byte)nArray[imageLineByte.scanline[i]];
            }
        } else {
            throw new PngjException("not implemented");
        }
    }

    public static void scaleDown(IImageLineArray iImageLineArray) {
        if (iImageLineArray.getImageInfo().indexed || iImageLineArray.getImageInfo().bitDepth >= 8) {
            return;
        }
        if (iImageLineArray instanceof ImageLineInt) {
            int n = 8 - iImageLineArray.getImageInfo().bitDepth;
            if (iImageLineArray instanceof ImageLineInt) {
                ImageLineInt imageLineInt = (ImageLineInt)iImageLineArray;
                for (int i = 0; i < iImageLineArray.getSize(); ++i) {
                    imageLineInt.scanline[i] = imageLineInt.scanline[i] >> n;
                }
            } else if (iImageLineArray instanceof ImageLineByte) {
                ImageLineByte imageLineByte = (ImageLineByte)iImageLineArray;
                for (int i = 0; i < iImageLineArray.getSize(); ++i) {
                    imageLineByte.scanline[i] = (byte)((imageLineByte.scanline[i] & 0xFF) >> n);
                }
            }
        } else {
            throw new PngjException("not implemented");
        }
    }

    public static byte scaleUp(int n, byte by) {
        return n < 8 ? (byte)DEPTH_UNPACK[n][by] : by;
    }

    public static byte scaleDown(int n, byte by) {
        return n < 8 ? (byte)(by >> 8 - n) : by;
    }

    public static int[] palette2rgb(ImageLineInt imageLineInt, PngChunkPLTE pngChunkPLTE, PngChunkTRNS pngChunkTRNS, int[] nArray) {
        return ImageLineHelper.palette2rgb(imageLineInt, pngChunkPLTE, pngChunkTRNS, nArray, false);
    }

    static int[] lineToARGB32(ImageLineByte imageLineByte, PngChunkPLTE pngChunkPLTE, PngChunkTRNS pngChunkTRNS, int[] nArray) {
        boolean bl = imageLineByte.imgInfo.alpha;
        int n = imageLineByte.getImageInfo().cols;
        if (nArray == null || nArray.length < n) {
            nArray = new int[n];
        }
        if (imageLineByte.getImageInfo().indexed) {
            int n2 = pngChunkTRNS != null ? pngChunkTRNS.getPalletteAlpha().length : 0;
            for (int i = 0; i < n; ++i) {
                int n3 = imageLineByte.scanline[i] & 0xFF;
                int n4 = pngChunkPLTE.getEntry(n3);
                int n5 = n3 < n2 ? pngChunkTRNS.getPalletteAlpha()[n3] : 255;
                nArray[i] = n5 << 24 | n4;
            }
        } else if (imageLineByte.imgInfo.greyscale) {
            int n6 = pngChunkTRNS != null ? pngChunkTRNS.getGray() : -1;
            int n7 = 0;
            for (int i = 0; i < n; ++i) {
                int n8 = imageLineByte.scanline[n7++] & 0xFF;
                int n9 = bl ? imageLineByte.scanline[n7++] & 0xFF : (n8 != n6 ? 255 : 0);
                nArray[i] = n9 << 24 | n8 | n8 << 8 | n8 << 16;
            }
        } else {
            int n10 = pngChunkTRNS != null ? pngChunkTRNS.getRGB888() : -1;
            int n11 = 0;
            for (int i = 0; i < n; ++i) {
                int n12 = (imageLineByte.scanline[n11++] & 0xFF) << 16 | (imageLineByte.scanline[n11++] & 0xFF) << 8 | imageLineByte.scanline[n11++] & 0xFF;
                int n13 = bl ? imageLineByte.scanline[n11++] & 0xFF : (n12 != n10 ? 255 : 0);
                nArray[i] = n13 << 24 | n12;
            }
        }
        return nArray;
    }

    static byte[] lineToRGBA8888(ImageLineByte imageLineByte, PngChunkPLTE pngChunkPLTE, PngChunkTRNS pngChunkTRNS, byte[] byArray) {
        boolean bl = imageLineByte.imgInfo.alpha;
        int n = imageLineByte.imgInfo.cols;
        int n2 = n * 4;
        if (byArray == null || byArray.length < n2) {
            byArray = new byte[n2];
        }
        if (imageLineByte.imgInfo.indexed) {
            int n3 = pngChunkTRNS != null ? pngChunkTRNS.getPalletteAlpha().length : 0;
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                int n5 = imageLineByte.scanline[i] & 0xFF;
                int n6 = pngChunkPLTE.getEntry(n5);
                byArray[n4++] = (byte)(n6 >> 16 & 0xFF);
                byArray[n4++] = (byte)(n6 >> 8 & 0xFF);
                byArray[n4++] = (byte)(n6 & 0xFF);
                byArray[n4++] = (byte)(n5 < n3 ? pngChunkTRNS.getPalletteAlpha()[n5] : 255);
            }
        } else if (imageLineByte.imgInfo.greyscale) {
            int n7 = pngChunkTRNS != null ? pngChunkTRNS.getGray() : -1;
            int n8 = 0;
            int n9 = 0;
            while (n9 < n2) {
                byte by = imageLineByte.scanline[n8++];
                byArray[n9++] = by;
                byArray[n9++] = by;
                byArray[n9++] = by;
                byArray[n9++] = bl ? imageLineByte.scanline[n8++] : ((by & 0xFF) == n7 ? 0 : -1);
            }
        } else if (bl) {
            System.arraycopy(imageLineByte.scanline, 0, byArray, 0, n2);
        } else {
            int n10 = 0;
            int n11 = 0;
            while (n11 < n2) {
                byArray[n11++] = imageLineByte.scanline[n10++];
                byArray[n11++] = imageLineByte.scanline[n10++];
                byArray[n11++] = imageLineByte.scanline[n10++];
                byArray[n11++] = -1;
                if (pngChunkTRNS == null || byArray[n11 - 3] != (byte)pngChunkTRNS.getRGB()[0] || byArray[n11 - 2] != (byte)pngChunkTRNS.getRGB()[1] || byArray[n11 - 1] != (byte)pngChunkTRNS.getRGB()[2]) continue;
                byArray[n11 - 1] = 0;
            }
        }
        return byArray;
    }

    static byte[] lineToRGB888(ImageLineByte imageLineByte, PngChunkPLTE pngChunkPLTE, byte[] byArray) {
        boolean bl = imageLineByte.imgInfo.alpha;
        int n = imageLineByte.imgInfo.cols;
        int n2 = n * 3;
        if (byArray == null || byArray.length < n2) {
            byArray = new byte[n2];
        }
        int[] nArray = new int[3];
        if (imageLineByte.imgInfo.indexed) {
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                pngChunkPLTE.getEntryRgb(imageLineByte.scanline[i] & 0xFF, nArray);
                byArray[n3++] = (byte)nArray[0];
                byArray[n3++] = (byte)nArray[1];
                byArray[n3++] = (byte)nArray[2];
            }
        } else if (imageLineByte.imgInfo.greyscale) {
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                byte by = imageLineByte.scanline[n4++];
                byArray[n5++] = by;
                byArray[n5++] = by;
                byArray[n5++] = by;
                if (!bl) continue;
                ++n4;
            }
        } else if (!bl) {
            System.arraycopy(imageLineByte.scanline, 0, byArray, 0, n2);
        } else {
            int n6 = 0;
            int n7 = 0;
            while (n7 < n2) {
                byArray[n7++] = imageLineByte.scanline[n6++];
                byArray[n7++] = imageLineByte.scanline[n6++];
                byArray[n7++] = imageLineByte.scanline[n6++];
                ++n6;
            }
        }
        return byArray;
    }

    public static int[] palette2rgba(ImageLineInt imageLineInt, PngChunkPLTE pngChunkPLTE, PngChunkTRNS pngChunkTRNS, int[] nArray) {
        return ImageLineHelper.palette2rgb(imageLineInt, pngChunkPLTE, pngChunkTRNS, nArray, true);
    }

    public static int[] palette2rgb(ImageLineInt imageLineInt, PngChunkPLTE pngChunkPLTE, int[] nArray) {
        return ImageLineHelper.palette2rgb(imageLineInt, pngChunkPLTE, null, nArray, false);
    }

    public static int[] convert2rgba(IImageLineArray iImageLineArray, PngChunkPLTE pngChunkPLTE, PngChunkTRNS pngChunkTRNS, int[] nArray) {
        ImageInfo imageInfo = iImageLineArray.getImageInfo();
        int n = imageInfo.cols * 4;
        if (nArray == null || nArray.length < n) {
            nArray = new int[n];
        }
        int n2 = imageInfo.bitDepth == 16 ? 65535 : 255;
        Arrays.fill(nArray, n2);
        if (imageInfo.indexed) {
            int n3 = pngChunkTRNS != null ? pngChunkTRNS.getPalletteAlpha().length : 0;
            for (int i = 0; i < imageInfo.cols; ++i) {
                int n4 = iImageLineArray.getElem(i);
                pngChunkPLTE.getEntryRgb(n4, nArray, i * 4);
                if (n4 >= n3) continue;
                nArray[i * 4 + 3] = pngChunkTRNS.getPalletteAlpha()[n4];
            }
        } else if (imageInfo.greyscale) {
            int[] nArray2 = null;
            if (imageInfo.bitDepth < 8) {
                nArray2 = DEPTH_UNPACK[imageInfo.bitDepth];
            }
            int n5 = 0;
            int n6 = 0;
            for (int i = 0; i < imageInfo.cols; ++i) {
                nArray[n5++] = nArray2 != null ? nArray2[iImageLineArray.getElem(n6++)] : iImageLineArray.getElem(n6++);
                nArray[n5] = nArray[n5 - 1];
                nArray[++n5] = nArray[n5 - 1];
                ++n5;
                if (imageInfo.channels == 2) {
                    nArray[n5++] = nArray2 != null ? nArray2[iImageLineArray.getElem(n6++)] : iImageLineArray.getElem(n6++);
                    continue;
                }
                nArray[n5++] = n2;
            }
        } else {
            int n7 = 0;
            int n8 = 0;
            for (int i = 0; i < imageInfo.cols; ++i) {
                nArray[n7++] = iImageLineArray.getElem(n8++);
                nArray[n7++] = iImageLineArray.getElem(n8++);
                nArray[n7++] = iImageLineArray.getElem(n8++);
                nArray[n7++] = imageInfo.alpha ? iImageLineArray.getElem(n8++) : n2;
            }
        }
        return nArray;
    }

    private static int[] palette2rgb(IImageLine iImageLine, PngChunkPLTE pngChunkPLTE, PngChunkTRNS pngChunkTRNS, int[] nArray, boolean bl) {
        boolean bl2 = pngChunkTRNS != null;
        int n = bl2 ? 4 : 3;
        ImageLineInt imageLineInt = (ImageLineInt)(iImageLine instanceof ImageLineInt ? iImageLine : null);
        ImageLineByte imageLineByte = (ImageLineByte)(iImageLine instanceof ImageLineByte ? iImageLine : null);
        boolean bl3 = imageLineByte != null;
        int n2 = imageLineInt != null ? imageLineInt.imgInfo.cols : imageLineByte.imgInfo.cols;
        int n3 = n2 * n;
        if (nArray == null || nArray.length < n3) {
            nArray = new int[n3];
        }
        int n4 = pngChunkTRNS != null ? pngChunkTRNS.getPalletteAlpha().length : 0;
        for (int i = 0; i < n2; ++i) {
            int n5;
            int n6 = bl3 ? imageLineByte.scanline[i] & 0xFF : imageLineInt.scanline[i];
            pngChunkPLTE.getEntryRgb(n6, nArray, i * n);
            if (!bl2) continue;
            nArray[i * n + 3] = n5 = n6 < n4 ? pngChunkTRNS.getPalletteAlpha()[n6] : 255;
        }
        return nArray;
    }

    public static String infoFirstLastPixels(ImageLineInt imageLineInt) {
        return imageLineInt.imgInfo.channels == 1 ? String.format("first=(%d) last=(%d)", imageLineInt.scanline[0], imageLineInt.scanline[imageLineInt.scanline.length - 1]) : String.format("first=(%d %d %d) last=(%d %d %d)", imageLineInt.scanline[0], imageLineInt.scanline[1], imageLineInt.scanline[2], imageLineInt.scanline[imageLineInt.scanline.length - imageLineInt.imgInfo.channels], imageLineInt.scanline[imageLineInt.scanline.length - imageLineInt.imgInfo.channels + 1], imageLineInt.scanline[imageLineInt.scanline.length - imageLineInt.imgInfo.channels + 2]);
    }

    public static int getPixelARGB8(IImageLine iImageLine, int n) {
        if (iImageLine instanceof ImageLineInt) {
            if (((ImageLineInt)iImageLine).imgInfo.channels != 4) {
                return ImageLineHelper.getPixelRGB8(iImageLine, n);
            }
            int n2 = n * ((ImageLineInt)iImageLine).imgInfo.channels;
            int[] nArray = ((ImageLineInt)iImageLine).getScanline();
            return nArray[n2 + 3] << 24 | nArray[n2] << 16 | nArray[n2 + 1] << 8 | nArray[n2 + 2];
        }
        if (iImageLine instanceof ImageLineByte) {
            if (((ImageLineByte)iImageLine).imgInfo.channels != 4) {
                return ImageLineHelper.getPixelRGB8(iImageLine, n);
            }
            int n3 = n * ((ImageLineByte)iImageLine).imgInfo.channels;
            byte[] byArray = ((ImageLineByte)iImageLine).getScanline();
            return (byArray[n3 + 3] & 0xFF) << 24 | (byArray[n3] & 0xFF) << 16 | (byArray[n3 + 1] & 0xFF) << 8 | byArray[n3 + 2] & 0xFF;
        }
        throw new PngjUnsupportedException("Not supported " + iImageLine.getClass());
    }

    public static int getPixelRGB8(IImageLine iImageLine, int n) {
        if (iImageLine instanceof ImageLineInt) {
            int n2 = n * ((ImageLineInt)iImageLine).imgInfo.channels;
            int[] nArray = ((ImageLineInt)iImageLine).getScanline();
            return 0xFF000000 | nArray[n2] << 16 | nArray[n2 + 1] << 8 | nArray[n2 + 2];
        }
        if (iImageLine instanceof ImageLineByte) {
            int n3 = n * ((ImageLineByte)iImageLine).imgInfo.channels;
            byte[] byArray = ((ImageLineByte)iImageLine).getScanline();
            return 0xFF000000 | (byArray[n3] & 0xFF) << 16 | (byArray[n3 + 1] & 0xFF) << 8 | byArray[n3 + 2] & 0xFF;
        }
        throw new PngjUnsupportedException("Not supported " + iImageLine.getClass());
    }

    public static void setPixelsRGB8(ImageLineInt imageLineInt, int[] nArray) {
        int n = 0;
        for (int i = 0; i < imageLineInt.imgInfo.cols; ++i) {
            imageLineInt.scanline[n++] = nArray[i] >> 16 & 0xFF;
            imageLineInt.scanline[n++] = nArray[i] >> 8 & 0xFF;
            imageLineInt.scanline[n++] = nArray[i] & 0xFF;
        }
    }

    public static void setPixelRGB8(ImageLineInt imageLineInt, int n, int n2, int n3, int n4) {
        n *= imageLineInt.imgInfo.channels;
        imageLineInt.scanline[n++] = n2;
        imageLineInt.scanline[n++] = n3;
        imageLineInt.scanline[n] = n4;
    }

    public static void setPixelRGB8(ImageLineInt imageLineInt, int n, int n2) {
        ImageLineHelper.setPixelRGB8(imageLineInt, n, n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF);
    }

    public static void setPixelsRGBA8(ImageLineInt imageLineInt, int[] nArray) {
        int n = 0;
        for (int i = 0; i < imageLineInt.imgInfo.cols; ++i) {
            imageLineInt.scanline[n++] = nArray[i] >> 16 & 0xFF;
            imageLineInt.scanline[n++] = nArray[i] >> 8 & 0xFF;
            imageLineInt.scanline[n++] = nArray[i] & 0xFF;
            imageLineInt.scanline[n++] = nArray[i] >> 24 & 0xFF;
        }
    }

    public static void setPixelRGBA8(ImageLineInt imageLineInt, int n, int n2, int n3, int n4, int n5) {
        n *= imageLineInt.imgInfo.channels;
        imageLineInt.scanline[n++] = n2;
        imageLineInt.scanline[n++] = n3;
        imageLineInt.scanline[n++] = n4;
        imageLineInt.scanline[n] = n5;
    }

    public static void setPixelRGBA8(ImageLineInt imageLineInt, int n, int n2) {
        ImageLineHelper.setPixelRGBA8(imageLineInt, n, n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF, n2 >> 24 & 0xFF);
    }

    public static void setValD(ImageLineInt imageLineInt, int n, double d) {
        imageLineInt.scanline[n] = ImageLineHelper.double2int(imageLineInt, d);
    }

    public static int interpol(int n, int n2, int n3, int n4, double d, double d2) {
        double d3 = (double)n * (1.0 - d) + (double)n2 * d;
        double d4 = (double)n3 * (1.0 - d) + (double)n4 * d;
        return (int)(d3 * (1.0 - d2) + d4 * d2 + 0.5);
    }

    public static double int2double(ImageLineInt imageLineInt, int n) {
        return imageLineInt.imgInfo.bitDepth == 16 ? (double)n / 65535.0 : (double)n / 255.0;
    }

    public static double int2doubleClamped(ImageLineInt imageLineInt, int n) {
        double d;
        double d2 = d = imageLineInt.imgInfo.bitDepth == 16 ? (double)n / 65535.0 : (double)n / 255.0;
        return d <= 0.0 ? 0.0 : (d >= 1.0 ? 1.0 : d);
    }

    public static int double2int(ImageLineInt imageLineInt, double d) {
        d = d <= 0.0 ? 0.0 : (d >= 1.0 ? 1.0 : d);
        return imageLineInt.imgInfo.bitDepth == 16 ? (int)(d * 65535.0 + 0.5) : (int)(d * 255.0 + 0.5);
    }

    public static int double2intClamped(ImageLineInt imageLineInt, double d) {
        d = d <= 0.0 ? 0.0 : (d >= 1.0 ? 1.0 : d);
        return imageLineInt.imgInfo.bitDepth == 16 ? (int)(d * 65535.0 + 0.5) : (int)(d * 255.0 + 0.5);
    }

    public static int clampTo_0_255(int n) {
        return n > 255 ? 255 : (n < 0 ? 0 : n);
    }

    public static int clampTo_0_65535(int n) {
        return n > 65535 ? 65535 : (n < 0 ? 0 : n);
    }

    public static int clampTo_128_127(int n) {
        return n > 127 ? 127 : (n < -128 ? -128 : n);
    }

    public static int getMaskForPackedFormats(int n) {
        if (n == 4) {
            return 240;
        }
        if (n == 2) {
            return 192;
        }
        return 128;
    }

    public static int getMaskForPackedFormatsLs(int n) {
        if (n == 4) {
            return 15;
        }
        if (n == 2) {
            return 3;
        }
        return 1;
    }

    static {
        ImageLineHelper.initDepthScale();
    }
}

