/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.IImageLineArray;
import ar.com.hjg.pngj.IImageLineFactory;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLineHelper;

public class ImageLineByte
implements IImageLine,
IImageLineArray {
    public final ImageInfo imgInfo;
    final byte[] scanline;
    final byte[] scanline2;
    protected FilterType filterType;
    final int size;

    public ImageLineByte(ImageInfo imageInfo) {
        this(imageInfo, null);
    }

    public ImageLineByte(ImageInfo imageInfo, byte[] byArray) {
        this.imgInfo = imageInfo;
        this.filterType = FilterType.FILTER_UNKNOWN;
        this.size = imageInfo.samplesPerRow;
        this.scanline = byArray != null && byArray.length >= this.size ? byArray : new byte[this.size];
        this.scanline2 = imageInfo.bitDepth == 16 ? new byte[this.size] : null;
    }

    public static IImageLineFactory<ImageLineByte> getFactory() {
        return new IImageLineFactory<ImageLineByte>(){

            @Override
            public ImageLineByte createImageLine(ImageInfo imageInfo) {
                return new ImageLineByte(imageInfo);
            }
        };
    }

    public FilterType getFilterUsed() {
        return this.filterType;
    }

    public byte[] getScanlineByte() {
        return this.scanline;
    }

    public byte[] getScanlineByte2() {
        return this.scanline2;
    }

    public String toString() {
        return " cols=" + this.imgInfo.cols + " bpc=" + this.imgInfo.bitDepth + " size=" + this.scanline.length;
    }

    @Override
    public void readFromPngRaw(byte[] byArray, int n, int n2, int n3) {
        this.filterType = FilterType.getByVal(byArray[0]);
        int n4 = n - 1;
        int n5 = (n3 - 1) * this.imgInfo.channels;
        if (this.imgInfo.bitDepth == 8) {
            if (n3 == 1) {
                System.arraycopy(byArray, 1, this.scanline, 0, n4);
            } else {
                int n6 = 1;
                int n7 = 0;
                int n8 = n2 * this.imgInfo.channels;
                while (n6 <= n4) {
                    this.scanline[n8] = byArray[n6];
                    if (++n7 == this.imgInfo.channels) {
                        n7 = 0;
                        n8 += n5;
                    }
                    ++n6;
                    ++n8;
                }
            }
        } else if (this.imgInfo.bitDepth == 16) {
            if (n3 == 1) {
                int n9 = 1;
                for (int i = 0; i < this.imgInfo.samplesPerRow; ++i) {
                    this.scanline[i] = byArray[n9++];
                    this.scanline2[i] = byArray[n9++];
                }
            } else {
                int n10;
                int n11 = 1;
                int n12 = 0;
                int n13 = n10 = n2 != 0 ? n2 * this.imgInfo.channels : 0;
                while (n11 <= n4) {
                    this.scanline[n10] = byArray[n11++];
                    this.scanline2[n10] = byArray[n11++];
                    if (++n12 == this.imgInfo.channels) {
                        n12 = 0;
                        n10 += n5;
                    }
                    ++n10;
                }
            }
        } else {
            int n14 = this.imgInfo.bitDepth;
            int n15 = ImageLineHelper.getMaskForPackedFormats(n14);
            int n16 = n2 * this.imgInfo.channels;
            int n17 = 0;
            for (int i = 1; i < n; ++i) {
                int n18 = n15;
                int n19 = 8 - n14;
                do {
                    this.scanline[n16] = (byte)((byArray[i] & n18) >> n19);
                    n18 >>= n14;
                    n19 -= n14;
                    ++n16;
                    if (++n17 != this.imgInfo.channels) continue;
                    n17 = 0;
                    n16 += n5;
                } while (n18 != 0 && n16 < this.size);
            }
        }
    }

    @Override
    public void writeToPngRaw(byte[] byArray) {
        byArray[0] = (byte)this.filterType.val;
        if (this.imgInfo.bitDepth == 8) {
            System.arraycopy(this.scanline, 0, byArray, 1, this.size);
        } else if (this.imgInfo.bitDepth == 16) {
            int n = 1;
            for (int i = 0; i < this.size; ++i) {
                byArray[n++] = this.scanline[i];
                byArray[n++] = this.scanline2[i];
            }
        } else {
            int n = this.imgInfo.bitDepth;
            int n2 = 8 - n;
            int n3 = 0;
            int n4 = 1;
            for (int i = 0; i < this.size; ++i) {
                n3 |= this.scanline[i] << n2;
                if ((n2 -= n) >= 0 && i != this.size - 1) continue;
                byArray[n4++] = (byte)n3;
                n2 = 8 - n;
                n3 = 0;
            }
        }
    }

    @Override
    public void endReadFromPngRaw() {
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getElem(int n) {
        return this.scanline2 == null ? this.scanline[n] & 0xFF : (this.scanline[n] & 0xFF) << 8 | this.scanline2[n] & 0xFF;
    }

    public byte[] getScanline() {
        return this.scanline;
    }

    @Override
    public ImageInfo getImageInfo() {
        return this.imgInfo;
    }

    @Override
    public FilterType getFilterType() {
        return this.filterType;
    }

    public void setFilterType(FilterType filterType) {
        this.filterType = filterType;
    }
}

