/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import java.io.OutputStream;

public class IdatChunkWriter {
    private static final int MAX_LEN_DEFAULT = 32768;
    private final OutputStream outputStream;
    private final int maxChunkLen;
    private byte[] buf;
    private int offset = 0;
    private int availLen;
    private long totalBytesWriten = 0L;
    private int chunksWriten = 0;

    public IdatChunkWriter(OutputStream outputStream) {
        this(outputStream, 0);
    }

    public IdatChunkWriter(OutputStream outputStream, int n) {
        this.outputStream = outputStream;
        this.maxChunkLen = n > 0 ? n : 32768;
        this.buf = new byte[this.maxChunkLen];
        this.availLen = this.maxChunkLen - this.offset;
        this.postReset();
    }

    public IdatChunkWriter(OutputStream outputStream, byte[] byArray) {
        this.outputStream = outputStream;
        this.buf = byArray != null ? byArray : new byte[32768];
        this.maxChunkLen = byArray.length;
        this.availLen = this.maxChunkLen - this.offset;
        this.postReset();
    }

    protected byte[] getChunkId() {
        return ChunkHelper.b_IDAT;
    }

    public final void flush() {
        if (this.offset > 0 && this.offset >= this.minLenToWrite()) {
            ChunkRaw chunkRaw = new ChunkRaw(this.offset, this.getChunkId(), false);
            chunkRaw.data = this.buf;
            chunkRaw.writeChunk(this.outputStream);
            this.totalBytesWriten += (long)(chunkRaw.len + 12);
            ++this.chunksWriten;
            this.offset = 0;
            this.availLen = this.maxChunkLen;
            this.postReset();
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public int getAvailLen() {
        return this.availLen;
    }

    public void incrementOffset(int n) {
        this.offset += n;
        this.availLen -= n;
        if (this.availLen < 0) {
            throw new PngjOutputException("Anomalous situation");
        }
        if (this.availLen == 0) {
            this.flush();
        }
    }

    public void write(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            int n3 = n2 <= this.availLen ? n2 : this.availLen;
            System.arraycopy(byArray, n, this.buf, this.offset, n3);
            this.incrementOffset(n3);
            n2 -= n3;
            n += n3;
        }
    }

    protected void postReset() {
    }

    protected int minLenToWrite() {
        return 1;
    }

    public void close() {
        this.flush();
        this.offset = 0;
        this.buf = null;
    }

    public byte[] getBuf() {
        return this.buf;
    }

    public long getTotalBytesWriten() {
        return this.totalBytesWriten;
    }

    public int getChunksWriten() {
        return this.chunksWriten;
    }
}

