/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngjExceptionInternal;

public class Deinterlacer {
    final ImageInfo imi;
    private int pass;
    private int rows;
    private int cols;
    int dY;
    int dX;
    int oY;
    int oX;
    int oXsamples;
    int dXsamples;
    private int currRowSubimg;
    private int currRowReal;
    private int currRowSeq;
    int totalRows;
    private boolean ended = false;

    public Deinterlacer(ImageInfo imageInfo) {
        this.imi = imageInfo;
        this.pass = 0;
        this.currRowSubimg = -1;
        this.currRowReal = -1;
        this.currRowSeq = 0;
        this.ended = false;
        this.totalRows = 0;
        this.setPass(1);
        this.setRow(0);
    }

    private void setRow(int n) {
        this.currRowSubimg = n;
        this.currRowReal = n * this.dY + this.oY;
        if (this.currRowReal < 0 || this.currRowReal >= this.imi.rows) {
            throw new PngjExceptionInternal("bad row - this should not happen");
        }
    }

    boolean nextRow() {
        ++this.currRowSeq;
        if (this.rows == 0 || this.currRowSubimg >= this.rows - 1) {
            if (this.pass == 7) {
                this.ended = true;
                return false;
            }
            this.setPass(this.pass + 1);
            if (this.rows == 0) {
                --this.currRowSeq;
                return this.nextRow();
            }
            this.setRow(0);
        } else {
            this.setRow(this.currRowSubimg + 1);
        }
        return true;
    }

    boolean isEnded() {
        return this.ended;
    }

    void setPass(int n) {
        if (this.pass == n) {
            return;
        }
        this.pass = n;
        byte[] byArray = Deinterlacer.paramsForPass(n);
        this.dX = byArray[0];
        this.dY = byArray[1];
        this.oX = byArray[2];
        this.oY = byArray[3];
        this.rows = this.imi.rows > this.oY ? (this.imi.rows + this.dY - 1 - this.oY) / this.dY : 0;
        int n2 = this.cols = this.imi.cols > this.oX ? (this.imi.cols + this.dX - 1 - this.oX) / this.dX : 0;
        if (this.cols == 0) {
            this.rows = 0;
        }
        this.dXsamples = this.dX * this.imi.channels;
        this.oXsamples = this.oX * this.imi.channels;
    }

    static byte[] paramsForPass(int n) {
        switch (n) {
            case 1: {
                return new byte[]{8, 8, 0, 0};
            }
            case 2: {
                return new byte[]{8, 8, 4, 0};
            }
            case 3: {
                return new byte[]{4, 8, 0, 4};
            }
            case 4: {
                return new byte[]{4, 4, 2, 0};
            }
            case 5: {
                return new byte[]{2, 4, 0, 2};
            }
            case 6: {
                return new byte[]{2, 2, 1, 0};
            }
            case 7: {
                return new byte[]{1, 2, 0, 1};
            }
        }
        throw new PngjExceptionInternal("bad interlace pass" + n);
    }

    int getCurrRowSubimg() {
        return this.currRowSubimg;
    }

    int getCurrRowReal() {
        return this.currRowReal;
    }

    int getPass() {
        return this.pass;
    }

    int getRows() {
        return this.rows;
    }

    int getCols() {
        return this.cols;
    }

    public int getPixelsToRead() {
        return this.getCols();
    }

    public int getBytesToRead() {
        return (this.imi.bitspPixel * this.getPixelsToRead() + 7) / 8;
    }

    public int getdY() {
        return this.dY;
    }

    public int getdX() {
        return this.dX;
    }

    public int getoY() {
        return this.oY;
    }

    public int getoX() {
        return this.oX;
    }

    public int getTotalRows() {
        if (this.totalRows == 0) {
            for (int i = 1; i <= 7; ++i) {
                int n;
                byte[] byArray = Deinterlacer.paramsForPass(i);
                int n2 = this.imi.rows > byArray[3] ? (this.imi.rows + byArray[1] - 1 - byArray[3]) / byArray[1] : 0;
                int n3 = n = this.imi.cols > byArray[2] ? (this.imi.cols + byArray[0] - 1 - byArray[2]) / byArray[0] : 0;
                if (n2 <= 0 || n <= 0) continue;
                this.totalRows += n2;
            }
        }
        return this.totalRows;
    }

    public long getTotalRawBytes() {
        long l = 0L;
        for (int i = 1; i <= 7; ++i) {
            byte[] byArray = Deinterlacer.paramsForPass(i);
            int n = this.imi.rows > byArray[3] ? (this.imi.rows + byArray[1] - 1 - byArray[3]) / byArray[1] : 0;
            int n2 = this.imi.cols > byArray[2] ? (this.imi.cols + byArray[0] - 1 - byArray[2]) / byArray[0] : 0;
            int n3 = (this.imi.bitspPixel * n2 + 7) / 8;
            if (n <= 0 || n2 <= 0) continue;
            l += (long)n * (1L + (long)n3);
        }
        return l;
    }

    public int getCurrRowSeq() {
        return this.currRowSeq;
    }
}

