/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.ChunkReader;
import ar.com.hjg.pngj.ChunkSeqReader;
import ar.com.hjg.pngj.DeflatedChunksSet;
import ar.com.hjg.pngj.Deinterlacer;
import ar.com.hjg.pngj.IChunkFactory;
import ar.com.hjg.pngj.IdatSet;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngjInputException;
import ar.com.hjg.pngj.chunks.ChunkFactory;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkLoadBehaviour;
import ar.com.hjg.pngj.chunks.ChunksList;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkIHDR;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ChunkSeqReaderPng
extends ChunkSeqReader {
    protected ImageInfo imageInfo;
    protected ImageInfo curImageInfo;
    protected Deinterlacer deinterlacer;
    protected int currentChunkGroup = -1;
    protected ChunksList chunksList = null;
    protected final boolean callbackMode;
    private long bytesAncChunksLoaded = 0L;
    private boolean checkCrc = true;
    private boolean includeNonBufferedChunks = false;
    private Set<String> chunksToSkip = new HashSet<String>();
    private long maxTotalBytesRead = 0L;
    private long skipChunkMaxSize = 0L;
    private long maxBytesMetadata = 0L;
    private IChunkFactory chunkFactory;
    private ChunkLoadBehaviour chunkLoadBehaviour = ChunkLoadBehaviour.LOAD_CHUNK_ALWAYS;

    public ChunkSeqReaderPng(boolean bl) {
        this.callbackMode = bl;
        this.chunkFactory = new ChunkFactory();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateAndCheckChunkGroup(String string) {
        if (string.equals("IHDR")) {
            if (this.currentChunkGroup >= 0) throw new PngjInputException("unexpected chunk " + string);
            this.currentChunkGroup = 0;
            return;
        } else if (string.equals("PLTE")) {
            if (this.currentChunkGroup != 0 && this.currentChunkGroup != 1) throw new PngjInputException("unexpected chunk here " + string);
            this.currentChunkGroup = 2;
            return;
        } else if (string.equals("IDAT")) {
            if (this.currentChunkGroup < 0 || this.currentChunkGroup > 4) throw new PngjInputException("unexpected chunk " + string);
            this.currentChunkGroup = 4;
            return;
        } else if (string.equals("IEND")) {
            if (this.currentChunkGroup < 4) throw new PngjInputException("unexpected chunk " + string);
            this.currentChunkGroup = 6;
            return;
        } else {
            this.currentChunkGroup = this.currentChunkGroup <= 1 ? 1 : (this.currentChunkGroup <= 3 ? 3 : 5);
        }
    }

    @Override
    public boolean shouldSkipContent(int n, String string) {
        if (super.shouldSkipContent(n, string)) {
            return true;
        }
        if (this.maxTotalBytesRead > 0L && (long)n + this.getBytesCount() > this.maxTotalBytesRead) {
            throw new PngjInputException("Maximum total bytes to read exceeeded: " + this.maxTotalBytesRead + " offset:" + this.getBytesCount() + " len=" + n);
        }
        if (this.chunksToSkip.contains(string)) {
            return true;
        }
        if (ChunkHelper.isCritical(string)) {
            return false;
        }
        if (this.skipChunkMaxSize > 0L && (long)n > this.skipChunkMaxSize) {
            return true;
        }
        if (this.maxBytesMetadata > 0L && (long)n > this.maxBytesMetadata - this.bytesAncChunksLoaded) {
            return true;
        }
        switch (this.chunkLoadBehaviour) {
            case LOAD_CHUNK_IF_SAFE: {
                if (ChunkHelper.isSafeToCopy(string)) break;
                return true;
            }
            case LOAD_CHUNK_NEVER: {
                return true;
            }
        }
        return false;
    }

    public long getBytesChunksLoaded() {
        return this.bytesAncChunksLoaded;
    }

    public int getCurrentChunkGroup() {
        return this.currentChunkGroup;
    }

    public void setChunksToSkip(String ... stringArray) {
        this.chunksToSkip.clear();
        for (String string : stringArray) {
            this.chunksToSkip.add(string);
        }
    }

    public void addChunkToSkip(String string) {
        this.chunksToSkip.add(string);
    }

    public void dontSkipChunk(String string) {
        this.chunksToSkip.remove(string);
    }

    public boolean firstChunksNotYetRead() {
        return this.getCurrentChunkGroup() < 4;
    }

    @Override
    protected void postProcessChunk(ChunkReader chunkReader) {
        PngChunk pngChunk;
        super.postProcessChunk(chunkReader);
        if (chunkReader.getChunkRaw().id.equals("IHDR")) {
            pngChunk = new PngChunkIHDR(null);
            ((PngChunkIHDR)pngChunk).parseFromRaw(chunkReader.getChunkRaw());
            this.curImageInfo = this.imageInfo = ((PngChunkIHDR)pngChunk).createImageInfo();
            if (((PngChunkIHDR)pngChunk).isInterlaced()) {
                this.deinterlacer = new Deinterlacer(this.curImageInfo);
            }
            this.chunksList = new ChunksList(this.imageInfo);
        }
        if (chunkReader.mode == ChunkReader.ChunkReaderMode.BUFFER && this.countChunkTypeAsAncillary(chunkReader.getChunkRaw().id)) {
            this.bytesAncChunksLoaded += (long)chunkReader.getChunkRaw().len;
        }
        if (chunkReader.mode == ChunkReader.ChunkReaderMode.BUFFER || this.includeNonBufferedChunks) {
            pngChunk = this.chunkFactory.createChunk(chunkReader.getChunkRaw(), this.getImageInfo());
            this.chunksList.appendReadChunk(pngChunk, this.currentChunkGroup);
        }
        if (this.isDone()) {
            this.processEndPng();
        }
    }

    protected boolean countChunkTypeAsAncillary(String string) {
        return !ChunkHelper.isCritical(string);
    }

    @Override
    protected DeflatedChunksSet createIdatSet(String string) {
        IdatSet idatSet = new IdatSet(string, this.callbackMode, this.getCurImgInfo(), this.deinterlacer);
        return idatSet;
    }

    public IdatSet getIdatSet() {
        DeflatedChunksSet deflatedChunksSet = this.getCurDeflatedSet();
        return deflatedChunksSet instanceof IdatSet ? (IdatSet)deflatedChunksSet : null;
    }

    @Override
    protected boolean isIdatKind(String string) {
        return string.equals("IDAT");
    }

    @Override
    public int consume(byte[] byArray, int n, int n2) {
        return super.consume(byArray, n, n2);
    }

    public void setChunkFactory(IChunkFactory iChunkFactory) {
        this.chunkFactory = iChunkFactory;
    }

    protected void processEndPng() {
    }

    public ImageInfo getImageInfo() {
        return this.imageInfo;
    }

    public boolean isInterlaced() {
        return this.deinterlacer != null;
    }

    public Deinterlacer getDeinterlacer() {
        return this.deinterlacer;
    }

    @Override
    protected void startNewChunk(int n, String string, long l) {
        this.updateAndCheckChunkGroup(string);
        super.startNewChunk(n, string, l);
    }

    @Override
    public void close() {
        if (this.currentChunkGroup != 6) {
            this.currentChunkGroup = 6;
        }
        super.close();
    }

    public List<PngChunk> getChunks() {
        return this.chunksList.getChunks();
    }

    public void setMaxTotalBytesRead(long l) {
        this.maxTotalBytesRead = l;
    }

    public long getSkipChunkMaxSize() {
        return this.skipChunkMaxSize;
    }

    public void setSkipChunkMaxSize(long l) {
        this.skipChunkMaxSize = l;
    }

    public long getMaxBytesMetadata() {
        return this.maxBytesMetadata;
    }

    public void setMaxBytesMetadata(long l) {
        this.maxBytesMetadata = l;
    }

    public long getMaxTotalBytesRead() {
        return this.maxTotalBytesRead;
    }

    @Override
    protected boolean shouldCheckCrc(int n, String string) {
        return this.checkCrc;
    }

    public boolean isCheckCrc() {
        return this.checkCrc;
    }

    public void setCheckCrc(boolean bl) {
        this.checkCrc = bl;
    }

    public boolean isCallbackMode() {
        return this.callbackMode;
    }

    public Set<String> getChunksToSkip() {
        return this.chunksToSkip;
    }

    public void setChunkLoadBehaviour(ChunkLoadBehaviour chunkLoadBehaviour) {
        this.chunkLoadBehaviour = chunkLoadBehaviour;
    }

    public ImageInfo getCurImgInfo() {
        return this.curImageInfo;
    }

    public void updateCurImgInfo(ImageInfo imageInfo) {
        if (!imageInfo.equals(this.curImageInfo)) {
            this.curImageInfo = imageInfo;
        }
        if (this.deinterlacer != null) {
            this.deinterlacer = new Deinterlacer(this.curImageInfo);
        }
    }

    public void setIncludeNonBufferedChunks(boolean bl) {
        this.includeNonBufferedChunks = bl;
    }
}

