/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.BufferedStreamFeeder;
import ar.com.hjg.pngj.ChunkReader;
import ar.com.hjg.pngj.DeflatedChunkReader;
import ar.com.hjg.pngj.DeflatedChunksSet;
import ar.com.hjg.pngj.ErrorBehaviour;
import ar.com.hjg.pngj.IBytesConsumer;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjBadSignature;
import ar.com.hjg.pngj.PngjExceptionInternal;
import ar.com.hjg.pngj.PngjInputException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChunkSeqReader
implements IBytesConsumer,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ChunkSeqReader.class.getName());
    private final byte[] expectedSignature;
    private final int signatureLength;
    private byte[] buf0 = new byte[8];
    private int buf0len = 0;
    protected boolean signatureDone = false;
    protected boolean endChunkDone = false;
    protected boolean closed = false;
    private int chunkCount = 0;
    private long bytesCount = 0L;
    private DeflatedChunksSet curDeflatedSet;
    private ChunkReader curChunkReader;
    private long idatBytes;
    private ErrorBehaviour errorBehaviour = ErrorBehaviour.STRICT;

    public ChunkSeqReader() {
        this(PngHelperInternal.getPngIdSignature());
    }

    public ChunkSeqReader(byte[] byArray) {
        this.expectedSignature = byArray;
        this.signatureLength = this.expectedSignature == null ? 0 : this.expectedSignature.length;
        this.signatureDone = this.signatureLength <= 0;
    }

    @Override
    public int consume(byte[] byArray, int n, int n2) {
        if (this.closed) {
            return -1;
        }
        if (n2 == 0) {
            return 0;
        }
        if (n2 < 0) {
            throw new PngjInputException("This should not happen. Bad length: " + n2);
        }
        int n3 = 0;
        if (this.signatureDone) {
            if (this.curChunkReader == null || this.curChunkReader.isDone()) {
                int n4 = 8 - this.buf0len;
                if (n4 > n2) {
                    n4 = n2;
                }
                System.arraycopy(byArray, n, this.buf0, this.buf0len, n4);
                this.buf0len += n4;
                n3 += n4;
                this.bytesCount += (long)n4;
                if (this.buf0len == 8) {
                    ++this.chunkCount;
                    int n5 = PngHelperInternal.readInt4fromBytes(this.buf0, 0);
                    String string = ChunkHelper.idFromBytes(this.buf0, 4);
                    this.startNewChunk(n5, string, this.bytesCount - 8L);
                    this.buf0len = 0;
                }
            } else {
                int n6 = this.curChunkReader.consume(byArray, n, n2);
                if (n6 < 0) {
                    return -1;
                }
                n3 += n6;
                this.bytesCount += (long)n6;
            }
        } else {
            int n7 = this.signatureLength - this.buf0len;
            if (n7 > n2) {
                n7 = n2;
            }
            System.arraycopy(byArray, n, this.buf0, this.buf0len, n7);
            this.buf0len += n7;
            if (this.buf0len == this.signatureLength) {
                this.checkSignature(this.buf0);
                this.buf0len = 0;
                this.signatureDone = true;
            }
            n3 += n7;
            this.bytesCount += (long)n7;
        }
        return n3;
    }

    public int feedAll(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            int n3 = this.consume(byArray, n, n2);
            if (n3 < 1) {
                return n2;
            }
            n2 -= n3;
            n += n3;
        }
        assert (n2 == 0);
        return 0;
    }

    protected void startNewChunk(int n, String string, long l) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("New chunk: " + string + " " + n + " off:" + l);
        }
        if (string.length() != 4 || !ChunkHelper.CHUNK_ID_PAT.matcher(string).matches()) {
            throw new PngjInputException("Bad chunk id: " + string);
        }
        if (n < 0) {
            throw new PngjInputException("Bad chunk len: " + n);
        }
        if (string.equals("IDAT")) {
            this.idatBytes += (long)n;
        }
        boolean bl = this.shouldCheckCrc(n, string);
        boolean bl2 = this.shouldSkipContent(n, string);
        boolean bl3 = this.isIdatKind(string);
        boolean bl4 = false;
        if (this.curDeflatedSet != null && !this.curDeflatedSet.isClosed()) {
            bl4 = this.curDeflatedSet.ackNextChunkId(string);
        }
        if (bl3 && !bl2) {
            if (!bl4) {
                if (this.curDeflatedSet != null && !this.curDeflatedSet.isDone()) {
                    throw new PngjInputException("new IDAT-like chunk when previous was not done");
                }
                this.curDeflatedSet = this.createIdatSet(string);
            }
            this.curChunkReader = new DeflatedChunkReader(n, string, bl, l, this.curDeflatedSet){

                @Override
                protected void chunkDone() {
                    super.chunkDone();
                    ChunkSeqReader.this.postProcessChunk(this);
                }
            };
        } else {
            this.curChunkReader = this.createChunkReaderForNewChunk(string, n, l, bl2);
        }
        if (this.curChunkReader != null && !bl) {
            this.curChunkReader.setCrcCheck(false);
        }
    }

    protected ChunkReader createChunkReaderForNewChunk(String string, int n, long l, boolean bl) {
        return new ChunkReader(n, string, l, bl ? ChunkReader.ChunkReaderMode.SKIP : ChunkReader.ChunkReaderMode.BUFFER){

            @Override
            protected void chunkDone() {
                ChunkSeqReader.this.postProcessChunk(this);
            }

            @Override
            protected void processData(int n, byte[] byArray, int n2, int n3) {
                throw new PngjExceptionInternal("should never happen");
            }
        };
    }

    protected void postProcessChunk(ChunkReader chunkReader) {
        String string;
        if (this.chunkCount == 1 && (string = this.firstChunkId()) != null && !string.equals(chunkReader.getChunkRaw().id)) {
            String string2 = "Bad first chunk: " + chunkReader.getChunkRaw().id + " expected: " + this.firstChunkId();
            if (this.errorBehaviour.c < ErrorBehaviour.SUPER_LENIENT.c) {
                throw new PngjInputException(string2);
            }
            LOGGER.warn(string2);
        }
        if (this.endChunkId() != null && chunkReader.getChunkRaw().id.equals(this.endChunkId())) {
            this.endChunkDone = true;
            this.close();
        }
    }

    protected abstract DeflatedChunksSet createIdatSet(String var1);

    protected boolean isIdatKind(String string) {
        return false;
    }

    protected boolean shouldSkipContent(int n, String string) {
        return false;
    }

    protected boolean shouldCheckCrc(int n, String string) {
        return true;
    }

    protected void checkSignature(byte[] byArray) {
        if (!Arrays.equals(byArray, PngHelperInternal.getPngIdSignature())) {
            throw new PngjBadSignature("Bad signature:" + Arrays.toString(byArray));
        }
    }

    public boolean isSignatureDone() {
        return this.signatureDone;
    }

    @Override
    public boolean isDone() {
        return this.endChunkDone;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public long getBytesCount() {
        return this.bytesCount;
    }

    public int getChunkCount() {
        return this.chunkCount;
    }

    public ChunkReader getCurChunkReader() {
        return this.curChunkReader;
    }

    public DeflatedChunksSet getCurDeflatedSet() {
        return this.curDeflatedSet;
    }

    @Override
    public void close() {
        if (this.curDeflatedSet != null) {
            this.curDeflatedSet.close();
        }
        this.closed = true;
    }

    public boolean isAtChunkBoundary() {
        return this.bytesCount == 0L || this.bytesCount == 8L || this.closed || this.curChunkReader == null || this.curChunkReader.isDone();
    }

    protected String firstChunkId() {
        return "IHDR";
    }

    public long getIdatBytes() {
        return this.idatBytes;
    }

    protected String endChunkId() {
        return "IEND";
    }

    public void feedFromFile(File file) {
        try {
            this.feedFromInputStream(new FileInputStream(file), true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PngjInputException("Error reading from file '" + file + "' :" + fileNotFoundException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void feedFromInputStream(InputStream inputStream, boolean bl) {
        bufferedStreamFeeder.setCloseStream(bl);
        try (BufferedStreamFeeder bufferedStreamFeeder = new BufferedStreamFeeder(inputStream);){
            bufferedStreamFeeder.feedAll(this);
        }
    }

    public void feedFromInputStream(InputStream inputStream) {
        this.feedFromInputStream(inputStream, true);
    }

    public void setErrorBehaviour(ErrorBehaviour errorBehaviour) {
        this.errorBehaviour = errorBehaviour;
    }
}

