/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.IBytesConsumer;
import ar.com.hjg.pngj.PngjInputException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class BufferedStreamFeeder
implements Closeable {
    private InputStream stream;
    private byte[] buf;
    private int pendinglen;
    private int offset;
    private boolean eof = false;
    private boolean closeStream = true;
    private long bytesRead = 0L;
    private static final int DEFAULTSIZE = 16384;

    public BufferedStreamFeeder(InputStream inputStream) {
        this(inputStream, 16384);
    }

    public BufferedStreamFeeder(InputStream inputStream, int n) {
        this.stream = inputStream;
        this.buf = new byte[n < 1 ? 16384 : n];
    }

    public InputStream getStream() {
        return this.stream;
    }

    public int feed(IBytesConsumer iBytesConsumer) {
        return this.feed(iBytesConsumer, Integer.MAX_VALUE);
    }

    public int feed(IBytesConsumer iBytesConsumer, int n) {
        int n2;
        this.refillBufferIfAppropiate();
        int n3 = 0;
        int n4 = n2 = n > 0 && n < this.pendinglen ? n : this.pendinglen;
        if (n2 > 0) {
            n3 = iBytesConsumer.consume(this.buf, this.offset, n2);
            if (n3 > 0) {
                this.offset += n3;
                this.pendinglen -= n3;
                assert (this.pendinglen >= 0);
            }
        } else {
            if (!this.eof) {
                throw new PngjInputException("This should not happen");
            }
            return iBytesConsumer.isDone() ? -1 : 0;
        }
        if (n3 > 0) {
            return n3;
        }
        if (!iBytesConsumer.isDone()) {
            throw new PngjInputException("This should not happen!");
        }
        return -1;
    }

    public long feedAll(IBytesConsumer iBytesConsumer) {
        int n;
        long l = 0L;
        while (this.hasPendingBytes() && (n = this.feed(iBytesConsumer)) > 0) {
            l += (long)n;
        }
        return l;
    }

    public int feedFixed(IBytesConsumer iBytesConsumer, int n) {
        int n2;
        int n3;
        for (n2 = n; n2 > 0; n2 -= n3) {
            n3 = this.feed(iBytesConsumer, n2);
            if (n3 > 0) continue;
            return n3;
        }
        assert (n2 == 0);
        return n;
    }

    protected void refillBufferIfAppropiate() {
        if (this.pendinglen > 0 || this.eof) {
            return;
        }
        try {
            this.offset = 0;
            this.pendinglen = this.stream.read(this.buf);
            if (this.pendinglen == 0) {
                throw new PngjInputException("This should not happen: stream.read(buf) returned 0");
            }
            if (this.pendinglen < 0) {
                this.close();
            } else {
                this.bytesRead += (long)this.pendinglen;
            }
        }
        catch (IOException iOException) {
            throw new PngjInputException(iOException);
        }
    }

    public boolean hasPendingBytes() {
        this.refillBufferIfAppropiate();
        return this.pendinglen > 0;
    }

    public void setCloseStream(boolean bl) {
        this.closeStream = bl;
    }

    @Override
    public void close() {
        this.eof = true;
        this.buf = null;
        this.pendinglen = 0;
        this.offset = 0;
        if (this.stream != null && this.closeStream) {
            try {
                this.stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.stream = null;
    }

    public void setInputStream(InputStream inputStream) {
        this.stream = inputStream;
        this.eof = false;
    }

    public boolean isEof() {
        return this.eof;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

