/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.builder;

import co.nstant.in.cbor.builder.AbstractBuilder;
import co.nstant.in.cbor.builder.MapBuilder;
import co.nstant.in.cbor.model.DataItem;

public class MapEntryBuilder<T extends MapBuilder<?>>
extends AbstractBuilder<T> {
    private final DataItem key;

    public MapEntryBuilder(T parent, DataItem key) {
        super(parent);
        this.key = key;
    }

    public T value(boolean value) {
        return this.put(this.key, this.convert(value));
    }

    public T value(byte[] value) {
        return this.put(this.key, this.convert(value));
    }

    public T value(double value) {
        return this.put(this.key, this.convert(value));
    }

    public T value(String value) {
        return this.put(this.key, this.convert(value));
    }

    private T put(DataItem key, DataItem value) {
        ((MapBuilder)this.getParent()).put(key, value);
        return (T)((MapBuilder)this.getParent());
    }

    public MapEntryBuilder<T> tagged(long tag) {
        DataItem item = this.key.getOuterTaggable();
        item.setTag(tag);
        return this;
    }
}

